# See :help option-summary
Abbreviations = {
    'acd': 'autochdir',
    'ai': 'autoindent',
    'akm': 'altkeymap',
    'al': 'aleph',
    'ambw': 'ambiwidth',
    'anti': 'antialias',
    'ar': 'autoread',
    'arab': 'arabic',
    'ari': 'allowrevins',
    'arshape': 'arabicshape',
    'aw': 'autowrite',
    'awa': 'autowriteall',
    'bdir': 'backupdir',
    'bdlay': 'balloondelay',
    'beval': 'ballooneval',
    'bex': 'backupext',
    'bexpr': 'balloonexpr',
    'bg': 'background',
    'bh': 'bufhidden',
    'bin': 'binary',
    'biosk': 'bioskey',
    'bk': 'backup',
    'bkc': 'backupcopy',
    'bl': 'buflisted',
    'bri': 'breakindent',
    'briopt': 'breakindentopt',
    'brk': 'breakat',
    'bs': 'backspace',
    'bsdir': 'browsedir',
    'bsk': 'backupskip',
    'bt': 'buftype',
    'cb': 'clipboard',
    'cc': 'colorcolumn',
    'ccv': 'charconvert',
    'cd': 'cdpath',
    'cf': 'confirm',
    'cfu': 'completefunc',
    'ch': 'cmdheight',
    'ci': 'copyindent',
    'cin': 'cindent',
    'cink': 'cinkeys',
    'cino': 'cinoptions',
    'cinw': 'cinwords',
    'cm': 'cryptmethod',
    'cmp': 'casemap',
    'cms': 'commentstring',
    'co': 'columns',
    'cocu': 'concealcursor',
    'cole': 'conceallevel',
    'com': 'comments',
    'consk': 'conskey',
    'cot': 'completeopt',
    'cp': 'compatible',
    'cpo': 'cpoptions',
    'cpt': 'complete',
    'crb': 'cursorbind',
    'cspc': 'cscopepathcomp',
    'csprg': 'cscopeprg',
    'csqf': 'cscopequickfix',
    'csre': 'cscoperelative',
    'cst': 'cscopetag',
    'csto': 'cscopetagorder',
    'csverb': 'cscopeverbose',
    'cuc': 'cursorcolumn',
    'cul': 'cursorline',
    'cwh': 'cmdwinheight',
    'deco': 'delcombine',
    'def': 'define',
    'dex': 'diffexpr',
    'dg': 'digraph',
    'dict': 'dictionary',
    'dip': 'diffopt',
    'dir': 'directory',
    'dy': 'display',
    'ea': 'equalalways',
    'ead': 'eadirection',
    'eb': 'errorbells',
    'ed': 'edcompatible',
    'ef': 'errorfile',
    'efm': 'errorformat',
    'ei': 'eventignore',
    'ek': 'esckeys',
    'enc': 'encoding',
    'eol': 'endofline',
    'ep': 'equalprg',
    'et': 'expandtab',
    'ex': 'exrc',
    'fcl': 'foldclose',
    'fcs': 'fillchars',
    'fdc': 'foldcolumn',
    'fde': 'foldexpr',
    'fdi': 'foldignore',
    'fdl': 'foldlevel',
    'fdls': 'foldlevelstart',
    'fdm': 'foldmethod',
    'fdn': 'foldnestmax',
    'fdo': 'foldopen',
    'fdt': 'foldtext',
    'fen': 'foldenable',
    'fenc': 'fileencoding',
    'fencs': 'fileencodings',
    'fex': 'formatexpr',
    'ff': 'fileformat',
    'ffs': 'fileformats',
    'fic': 'fileignorecase',
    'fk': 'fkmap',
    'flp': 'formatlistpat',
    'fml': 'foldminlines',
    'fmr': 'foldmarker',
    'fo': 'formatoptions',
    'fp': 'formatprg',
    'fs': 'fsync',
    'ft': 'filetype',
    'gcr': 'guicursor',
    'gd': 'gdefault',
    'gfm': 'grepformat',
    'gfn': 'guifont',
    'gfs': 'guifontset',
    'gfw': 'guifontwide',
    'ghr': 'guiheadroom',
    'go': 'guioptions',
    'gp': 'grepprg',
    'gtl': 'guitablabel',
    'gtt': 'guitabtooltip',
    'hf': 'helpfile',
    'hh': 'helpheight',
    'hi': 'history',
    'hid': 'hidden',
    'hk': 'hkmap',
    'hkp': 'hkmapp',
    'hl': 'highlight',
    'hlg': 'helplang',
    'hls': 'hlsearch',
    'ic': 'ignorecase',
    'im': 'insertmode',
    'imaf': 'imactivatefunc',
    'imak': 'imactivatekey',
    'imc': 'imcmdline',
    'imd': 'imdisable',
    'imi': 'iminsert',
    'ims': 'imsearch',
    'imsf': 'imstatusfunc',
    'inc': 'include',
    'inde': 'indentexpr',
    'indk': 'indentkeys',
    'inex': 'includeexpr',
    'inf': 'infercase',
    'is': 'incsearch',
    'isf': 'isfname',
    'isi': 'isident',
    'isk': 'iskeyword',
    'isp': 'isprint',
    'js': 'joinspaces',
    'km': 'keymodel',
    'kmp': 'keymap',
    'kp': 'keywordprg',
    'lbr': 'linebreak',
    'lcs': 'listchars',
    'lm': 'langmenu',
    'lmap': 'langmap',
    'lpl': 'loadplugins',
    'ls': 'laststatus',
    'lsp': 'linespace',
    'lw': 'lispwords',
    'lz': 'lazyredraw',
    'ma': 'modifiable',
    'mat': 'matchtime',
    'mco': 'maxcombine',
    'mef': 'makeef',
    'mfd': 'maxfuncdepth',
    'mh': 'mousehide',
    'mis': 'menuitems',
    'ml': 'modeline',
    'mls': 'modelines',
    'mm': 'maxmem',
    'mmd': 'maxmapdepth',
    'mmp': 'maxmempattern',
    'mmt': 'maxmemtot',
    'mod': 'modified',
    'mousef': 'mousefocus',
    'mousem': 'mousemodel',
    'mouses': 'mouseshape',
    'mouset': 'mousetime',
    'mp': 'makeprg',
    'mps': 'matchpairs',
    'msm': 'mkspellmem',
    'mzq': 'mzquantum',
    'nf': 'nrformats',
    'nu': 'number',
    'nuw': 'numberwidth',
    'odev': 'opendevice',
    'oft': 'osfiletype',
    'ofu': 'omnifunc',
    'opfunc': 'operatorfunc',
    'pa': 'path',
    'para': 'paragraphs',
    'pdev': 'printdevice',
    'penc': 'printencoding',
    'pex': 'patchexpr',
    'pexpr': 'printexpr',
    'pfn': 'printfont',
    'ph': 'pumheight',
    'pheader': 'printheader',
    'pi': 'preserveindent',
    'pm': 'patchmode',
    'pmbcs': 'printmbcharset',
    'pmbfn': 'printmbfont',
    'popt': 'printoptions',
    'pt': 'pastetoggle',
    'pvh': 'previewheight',
    'pvw': 'previewwindow',
    'qe': 'quoteescape',
    'rdt': 'redrawtime',
    're': 'regexpengine',
    'ri': 'revins',
    'rl': 'rightleft',
    'rlc': 'rightleftcmd',
    'rnu': 'relativenumber',
    'ro': 'readonly',
    'rop': 'renderoptions',
    'rs': 'restorescreen',
    'rtp': 'runtimepath',
    'ru': 'ruler',
    'ruf': 'rulerformat',
    'sb': 'splitbelow',
    'sbo': 'scrollopt',
    'sbr': 'showbreak',
    'sc': 'showcmd',
    'scb': 'scrollbind',
    'scr': 'scroll',
    'scs': 'smartcase',
    'sect': 'sections',
    'sel': 'selection',
    'sft': 'showfulltag',
    'sh': 'shell',
    'shcf': 'shellcmdflag',
    'shm': 'shortmess',
    'shq': 'shellquote',
    'si': 'smartindent',
    'siso': 'sidescrolloff',
    'sj': 'scrolljump',
    'slm': 'selectmode',
    'sm': 'showmatch',
    'smc': 'synmaxcol',
    'smd': 'showmode',
    'sn': 'shortname',
    'so': 'scrolloff',
    'sol': 'startofline',
    'sp': 'shellpipe',
    'spc': 'spellcapcheck',
    'spf': 'spellfile',
    'spl': 'spelllang',
    'spr': 'splitright',
    'sps': 'spellsuggest',
    'sr': 'shiftround',
    'srr': 'shellredir',
    'ss': 'sidescroll',
    'ssl': 'shellslash',
    'ssop': 'sessionoptions',
    'st': 'shelltype',
    'sta': 'smarttab',
    'stal': 'showtabline',
    'stl': 'statusline',
    'stmp': 'shelltemp',
    'sts': 'softtabstop',
    'su': 'suffixes',
    'sua': 'suffixesadd',
    'sw': 'shiftwidth',
    'swb': 'switchbuf',
    'swf': 'swapfile',
    'sws': 'swapsync',
    'sxe': 'shellxescape',
    'sxq': 'shellxquote',
    'syn': 'syntax',
    'ta': 'textauto',
    'tag': 'tags',
    'tal': 'tabline',
    'tb': 'toolbar',
    'tbi': 'ttybuiltin',
    'tbidi': 'termbidi',
    'tbis': 'toolbariconsize',
    'tbs': 'tagbsearch',
    'tenc': 'termencoding',
    'tf': 'ttyfast',
    'tgst': 'tagstack',
    'tl': 'taglength',
    'tm': 'timeoutlen',
    'to': 'timeout',
    'top': 'tildeop',
    'tpm': 'tabpagemax',
    'tr': 'tagrelative',
    'ts': 'tabstop',
    'tsl': 'ttyscroll',
    'tsr': 'thesaurus',
    'ttm': 'ttimeoutlen',
    'tty': 'ttytype',
    'ttym': 'ttymouse',
    'tw': 'textwidth',
    'tx': 'textmode',
    'uc': 'updatecount',
    'udf': 'undofile',
    'udir': 'undodir',
    'ul': 'undolevels',
    'ur': 'undoreload',
    'ut': 'updatetime',
    'vb': 'visualbell',
    'vbs': 'verbose',
    'vdir': 'viewdir',
    've': 'virtualedit',
    'vfile': 'verbosefile',
    'vi': 'viminfo',
    'vop': 'viewoptions',
    'wa': 'writeany',
    'wak': 'winaltkeys',
    'wb': 'writebackup',
    'wc': 'wildchar',
    'wcm': 'wildcharm',
    'wd': 'writedelay',
    'wfh': 'winfixheight',
    'wfw': 'winfixwidth',
    'wh': 'winheight',
    'wi': 'window',
    'wic': 'wildignorecase',
    'wig': 'wildignore',
    'wim': 'wildmode',
    'wiv': 'weirdinvert',
    'wiw': 'winwidth',
    'wm': 'wrapmargin',
    'wmh': 'winminheight',
    'wmnu': 'wildmenu',
    'wmw': 'winminwidth',
    'wop': 'wildoptions',
    'ws': 'wrapscan',
    'ww': 'whichwrap',
}


AbbreviationsIncludingInvertPrefix = {}

for abbr_name, full_name in Abbreviations.items():
    AbbreviationsIncludingInvertPrefix[abbr_name] = full_name

    # See :help E518
    AbbreviationsIncludingInvertPrefix['no' + abbr_name] = 'no' + full_name

    # See :help :set-inv
    AbbreviationsIncludingInvertPrefix['inv' + abbr_name] = 'inv' + full_name
