/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.authentication;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.authentication.AuthenticationCredentials;
import org.zaproxy.zap.authentication.AuthenticationHelper;
import org.zaproxy.zap.authentication.AuthenticationMethodType;
import org.zaproxy.zap.extension.api.ApiResponse;
import org.zaproxy.zap.extension.api.ApiResponseSet;
import org.zaproxy.zap.model.SessionStructure;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.WebSession;
import org.zaproxy.zap.users.AuthenticationState;
import org.zaproxy.zap.users.User;
import org.zaproxy.zap.utils.Stats;

public abstract class AuthenticationMethod {
    private static final Logger LOGGER = LogManager.getLogger(AuthenticationMethod.class);
    public static final String CONTEXT_CONFIG_AUTH = "context.authentication";
    public static final String CONTEXT_CONFIG_AUTH_TYPE = "context.authentication.type";
    public static final String CONTEXT_CONFIG_AUTH_STRATEGY = "context.authentication.strategy";
    public static final String CONTEXT_CONFIG_AUTH_POLL_URL = "context.authentication.pollurl";
    public static final String CONTEXT_CONFIG_AUTH_POLL_DATA = "context.authentication.polldata";
    public static final String CONTEXT_CONFIG_AUTH_POLL_HEADERS = "context.authentication.pollheaders";
    public static final String CONTEXT_CONFIG_AUTH_POLL_FREQ = "context.authentication.pollfreq";
    public static final String CONTEXT_CONFIG_AUTH_POLL_UNITS = "context.authentication.pollunits";
    public static final String CONTEXT_CONFIG_AUTH_LOGGEDIN = "context.authentication.loggedin";
    public static final String CONTEXT_CONFIG_AUTH_LOGGEDOUT = "context.authentication.loggedout";
    public static final String AUTH_STATE_ASSUMED_IN_STATS = "stats.auth.state.assumedin";
    public static final String AUTH_STATE_LOGGED_IN_STATS = "stats.auth.state.loggedin";
    public static final String AUTH_STATE_LOGGED_OUT_STATS = "stats.auth.state.loggedout";
    public static final String AUTH_STATE_NO_INDICATOR_STATS = "stats.auth.state.noindicator";
    public static final String AUTH_STATE_UNKNOWN_STATS = "stats.auth.state.unknown";
    public static final String TOKEN_PREFIX = "{%";
    public static final String TOKEN_POSTFIX = "%}";
    public static final int DEFAULT_POLL_FREQUENCY = 60;
    private AuthCheckingStrategy authCheckingStrategy = AuthCheckingStrategy.EACH_RESP;
    private String pollUrl;
    private String pollData;
    private String pollHeaders;
    private int pollFrequency = 60;
    private AuthPollFrequencyUnits pollFrequencyUnits = AuthPollFrequencyUnits.REQUESTS;
    protected Pattern loggedInIndicatorPattern = null;
    protected Pattern loggedOutIndicatorPattern = null;
    private HttpSender httpSender;

    public abstract boolean isConfigured();

    public AuthenticationMethod clone() {
        AuthenticationMethod method = this.duplicate();
        method.authCheckingStrategy = this.authCheckingStrategy;
        method.pollUrl = this.pollUrl;
        method.pollData = this.pollData;
        method.pollHeaders = this.pollHeaders;
        method.pollFrequency = this.pollFrequency;
        method.pollFrequencyUnits = this.pollFrequencyUnits;
        method.loggedInIndicatorPattern = this.loggedInIndicatorPattern;
        method.loggedOutIndicatorPattern = this.loggedOutIndicatorPattern;
        return method;
    }

    protected abstract AuthenticationMethod duplicate();

    public boolean validateCreationOfAuthenticationCredentials() {
        return true;
    }

    public abstract AuthenticationCredentials createAuthenticationCredentials();

    public abstract AuthenticationMethodType getType();

    public abstract WebSession authenticate(SessionManagementMethod var1, AuthenticationCredentials var2, User var3) throws UnsupportedAuthenticationCredentialsException;

    public abstract ApiResponse getApiResponseRepresentation();

    public abstract void replaceUserDataInPollRequest(HttpMessage var1, User var2);

    public void onMethodPersisted() {
    }

    public void onMethodDiscarded() {
    }

    private HttpSender getHttpSender() {
        if (this.httpSender == null) {
            this.httpSender = new HttpSender(Model.getSingleton().getOptionsParam().getConnectionParam(), true, 15);
        }
        return this.httpSender;
    }

    @Deprecated
    public boolean isAuthenticated(HttpMessage msg) {
        return this.isAuthenticated(msg, null, false);
    }

    public boolean isAuthenticated(HttpMessage msg, User user) {
        return this.isAuthenticated(msg, user, false);
    }

    public boolean isAuthenticated(HttpMessage msg, User user, boolean force) {
        HttpMessage msgToTest;
        if (msg == null || user == null) {
            return false;
        }
        AuthenticationState authState = user.getAuthenticationState();
        if (this.loggedInIndicatorPattern == null && this.loggedOutIndicatorPattern == null) {
            try {
                Stats.incCounter(SessionStructure.getHostName(msg), AUTH_STATE_NO_INDICATOR_STATS);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            if (View.isInitialised()) {
                View.getSingleton().getOutputPanel().append(Constant.messages.getString("authentication.output.indicatorsNotSet", msg.getRequestHeader().getURI()) + "\n");
            }
            return true;
        }
        switch (this.authCheckingStrategy) {
            case EACH_REQ: 
            case EACH_REQ_RESP: 
            case EACH_RESP: {
                msgToTest = msg;
                break;
            }
            case POLL_URL: {
                if (!force && authState.getLastPollResult() != null && authState.getLastPollResult().booleanValue()) {
                    switch (this.pollFrequencyUnits) {
                        case SECONDS: {
                            if ((System.currentTimeMillis() - authState.getLastPollTime()) / 1000L >= (long)this.pollFrequency) break;
                            try {
                                Stats.incCounter(SessionStructure.getHostName(msg), AUTH_STATE_ASSUMED_IN_STATS);
                            }
                            catch (URIException uRIException) {
                                // empty catch block
                            }
                            return true;
                        }
                        default: {
                            if (authState.getRequestsSincePoll() >= this.pollFrequency) break;
                            authState.incRequestsSincePoll();
                            try {
                                Stats.incCounter(SessionStructure.getHostName(msg), AUTH_STATE_ASSUMED_IN_STATS);
                            }
                            catch (URIException uRIException) {
                                // empty catch block
                            }
                            return true;
                        }
                    }
                }
                try {
                    HttpMessage pollMsg;
                    msgToTest = pollMsg = this.pollAsUser(user);
                    break;
                }
                catch (Exception e1) {
                    LOGGER.warn("Failed sending poll request to " + this.getPollUrl(), (Throwable)e1);
                    return false;
                }
            }
            default: {
                return false;
            }
        }
        return this.evaluateAuthRequest(msgToTest, authState);
    }

    public boolean evaluateAuthRequest(HttpMessage msg, AuthenticationState authState) {
        ArrayList<String> contentToTest = new ArrayList<String>();
        switch (this.authCheckingStrategy) {
            case EACH_REQ: {
                contentToTest.add(msg.getRequestHeader().toString());
                contentToTest.add(msg.getRequestBody().toString());
                break;
            }
            case EACH_REQ_RESP: {
                contentToTest.add(msg.getRequestHeader().toString());
                contentToTest.add(msg.getRequestBody().toString());
                contentToTest.add(msg.getResponseHeader().toString());
                contentToTest.add(msg.getResponseBody().toString());
                break;
            }
            case EACH_RESP: 
            case POLL_URL: {
                contentToTest.add(msg.getResponseHeader().toString());
                contentToTest.add(msg.getResponseBody().toString());
            }
        }
        if (AuthenticationMethod.patternMatchesAny(this.loggedInIndicatorPattern, contentToTest)) {
            try {
                Stats.incCounter(SessionStructure.getHostName(msg), AUTH_STATE_LOGGED_IN_STATS);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            if (this.authCheckingStrategy.equals((Object)AuthCheckingStrategy.POLL_URL)) {
                authState.setLastPollResult(true);
            }
            return true;
        }
        if (this.loggedOutIndicatorPattern != null && !AuthenticationMethod.patternMatchesAny(this.loggedOutIndicatorPattern, contentToTest)) {
            try {
                Stats.incCounter(SessionStructure.getHostName(msg), AUTH_STATE_UNKNOWN_STATS);
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            if (this.authCheckingStrategy.equals((Object)AuthCheckingStrategy.POLL_URL)) {
                authState.setLastPollResult(true);
            }
            return true;
        }
        try {
            Stats.incCounter(SessionStructure.getHostName(msg), AUTH_STATE_LOGGED_OUT_STATS);
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        if (this.authCheckingStrategy.equals((Object)AuthCheckingStrategy.POLL_URL)) {
            authState.setLastPollResult(false);
        }
        return false;
    }

    public HttpMessage pollAsUser(User user) throws IOException {
        if (!this.authCheckingStrategy.equals((Object)AuthCheckingStrategy.POLL_URL)) {
            throw new IllegalArgumentException("Authentication checking strategy is not POLL_URL");
        }
        HttpMessage pollMsg = new HttpMessage(new URI(this.getPollUrl(), true));
        if (this.getPollData() != null && this.getPollData().length() > 0) {
            pollMsg.getRequestHeader().setMethod("POST");
            pollMsg.getRequestBody().setBody(this.getPollData());
            pollMsg.getRequestHeader().setContentLength(pollMsg.getRequestBody().length());
        }
        if (this.getPollHeaders() != null && this.getPollHeaders().length() > 0) {
            for (String header : this.getPollHeaders().split("\n")) {
                String[] headerValue = header.split(":");
                if (headerValue.length == 2) {
                    pollMsg.getRequestHeader().addHeader(headerValue[0].trim(), headerValue[1].trim());
                    continue;
                }
                LOGGER.error("Invalid header '" + header + "' for poll request to " + this.getPollUrl());
            }
        }
        pollMsg.setRequestingUser(user);
        this.replaceUserDataInPollRequest(pollMsg, user);
        this.getHttpSender().sendAndReceive(pollMsg);
        AuthenticationHelper.addAuthMessageToHistory(pollMsg);
        AuthenticationState authState = user.getAuthenticationState();
        authState.setLastPollTime(System.currentTimeMillis());
        authState.setRequestsSincePoll(0);
        return pollMsg;
    }

    private static boolean patternMatchesAny(Pattern pattern, List<String> content) {
        if (pattern != null) {
            for (String str : content) {
                if (!pattern.matcher(str).find()) continue;
                return true;
            }
        }
        return false;
    }

    public Pattern getLoggedInIndicatorPattern() {
        return this.loggedInIndicatorPattern;
    }

    public void setLoggedInIndicatorPattern(String loggedInIndicatorPattern) {
        this.loggedInIndicatorPattern = loggedInIndicatorPattern == null || loggedInIndicatorPattern.trim().length() == 0 ? null : Pattern.compile(loggedInIndicatorPattern);
    }

    public Pattern getLoggedOutIndicatorPattern() {
        return this.loggedOutIndicatorPattern;
    }

    public void setLoggedOutIndicatorPattern(String loggedOutIndicatorPattern) {
        this.loggedOutIndicatorPattern = loggedOutIndicatorPattern == null || loggedOutIndicatorPattern.trim().length() == 0 ? null : Pattern.compile(loggedOutIndicatorPattern);
    }

    public AuthCheckingStrategy getAuthCheckingStrategy() {
        return this.authCheckingStrategy;
    }

    public void setAuthCheckingStrategy(AuthCheckingStrategy authCheckingStrategy) {
        Objects.requireNonNull(authCheckingStrategy);
        this.authCheckingStrategy = authCheckingStrategy;
    }

    public String getPollUrl() {
        return this.pollUrl;
    }

    public void setPollUrl(String pollUrl) {
        this.pollUrl = pollUrl;
    }

    public String getPollData() {
        return this.pollData;
    }

    public void setPollData(String pollData) {
        this.pollData = pollData;
    }

    public String getPollHeaders() {
        return this.pollHeaders;
    }

    public void setPollHeaders(String pollHeaders) {
        this.pollHeaders = pollHeaders;
    }

    public int getPollFrequency() {
        return this.pollFrequency;
    }

    public void setPollFrequency(int pollFrequency) {
        this.pollFrequency = pollFrequency;
    }

    public AuthPollFrequencyUnits getPollFrequencyUnits() {
        return this.pollFrequencyUnits;
    }

    public void setPollFrequencyUnits(AuthPollFrequencyUnits pollFrequencyUnits) {
        this.pollFrequencyUnits = pollFrequencyUnits;
    }

    public boolean isSameType(AuthenticationMethod other) {
        if (other == null) {
            return false;
        }
        return other.getClass().equals(this.getClass());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.loggedInIndicatorPattern == null ? 0 : this.loggedInIndicatorPattern.pattern().hashCode());
        result = 31 * result + (this.loggedOutIndicatorPattern == null ? 0 : this.loggedOutIndicatorPattern.pattern().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AuthenticationMethod other = (AuthenticationMethod)obj;
        if (!AuthenticationMethod.isSamePattern(this.loggedInIndicatorPattern, other.loggedInIndicatorPattern)) {
            return false;
        }
        if (!AuthenticationMethod.isSamePattern(this.loggedOutIndicatorPattern, other.loggedOutIndicatorPattern)) {
            return false;
        }
        if (!this.authCheckingStrategy.equals((Object)other.authCheckingStrategy)) {
            return false;
        }
        if (!Objects.equals(this.pollUrl, other.pollUrl)) {
            return false;
        }
        if (!Objects.equals(this.pollData, other.pollData)) {
            return false;
        }
        if (!Objects.equals(this.pollHeaders, other.pollHeaders)) {
            return false;
        }
        if (this.pollFrequency != other.pollFrequency) {
            return false;
        }
        return this.pollFrequencyUnits.equals((Object)other.pollFrequencyUnits);
    }

    private static boolean isSamePattern(Pattern pattern, Pattern other) {
        if (pattern == null) {
            return other == null;
        }
        return other != null && pattern.pattern().equals(other.pattern());
    }

    static class AuthMethodApiResponseRepresentation<T>
    extends ApiResponseSet<T> {
        public AuthMethodApiResponseRepresentation(Map<String, T> values) {
            super("method", values);
        }

        @Override
        public JSON toJSON() {
            JSONObject response = new JSONObject();
            response.put((Object)this.getName(), (Object)super.toJSON());
            return response;
        }
    }

    public static class UnsupportedAuthenticationCredentialsException
    extends RuntimeException {
        private static final long serialVersionUID = 4802501809913124766L;

        public UnsupportedAuthenticationCredentialsException(String message) {
            super(message);
        }
    }

    public static enum AuthPollFrequencyUnits {
        REQUESTS,
        SECONDS;

    }

    public static enum AuthCheckingStrategy {
        EACH_RESP,
        EACH_REQ,
        EACH_REQ_RESP,
        POLL_URL;

    }
}

