/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.skins;

import eu.hansolo.tilesfx.Tile;
import eu.hansolo.tilesfx.events.SwitchEvent;
import eu.hansolo.tilesfx.fonts.Fonts;
import eu.hansolo.tilesfx.skins.TileSkin;
import eu.hansolo.tilesfx.tools.Helper;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.event.EventHandler;
import javafx.event.EventType;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class SwitchTileSkin
extends TileSkin {
    private static final SwitchEvent SWITCH_PRESSED = new SwitchEvent(SwitchEvent.SWITCH_PRESSED);
    private static final SwitchEvent SWITCH_RELEASED = new SwitchEvent(SwitchEvent.SWITCH_RELEASED);
    private Text titleText;
    private Text text;
    private Label description;
    private Rectangle switchBorder;
    private Rectangle switchBackground;
    private Circle thumb;
    private Timeline timeline;
    private EventHandler<MouseEvent> mouseEventHandler;
    private InvalidationListener selectedListener;

    public SwitchTileSkin(Tile TILE) {
        super(TILE);
    }

    @Override
    protected void initGraphics() {
        super.initGraphics();
        this.mouseEventHandler = e -> {
            if (!this.tile.isInteractive()) {
                return;
            }
            EventType<? extends MouseEvent> TYPE = e.getEventType();
            if (MouseEvent.MOUSE_PRESSED == TYPE) {
                this.tile.setActive(!this.tile.isActive());
                this.tile.fireEvent(SWITCH_PRESSED);
            } else if (MouseEvent.MOUSE_RELEASED == TYPE) {
                this.tile.fireEvent(SWITCH_RELEASED);
            }
        };
        this.selectedListener = o -> this.moveThumb();
        this.timeline = new Timeline();
        this.titleText = new Text();
        this.titleText.setFill(this.tile.getTitleColor());
        Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
        this.text = new Text(this.tile.getText());
        this.text.setFill(this.tile.getUnitColor());
        Helper.enableNode(this.text, this.tile.isTextVisible());
        this.description = new Label(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.description.setWrapText(true);
        this.description.setTextFill(this.tile.getTextColor());
        Helper.enableNode(this.description, !this.tile.getDescription().isEmpty());
        this.switchBorder = new Rectangle();
        this.switchBackground = new Rectangle();
        this.switchBackground.setMouseTransparent(true);
        this.switchBackground.setFill(this.tile.isActive() ? this.tile.getActiveColor() : this.tile.getBackgroundColor());
        this.thumb = new Circle();
        this.thumb.setMouseTransparent(true);
        this.thumb.setEffect(this.shadow);
        this.getPane().getChildren().addAll((Node[])new Node[]{this.titleText, this.text, this.description, this.switchBorder, this.switchBackground, this.thumb});
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.switchBorder.addEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.switchBorder.addEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
        this.tile.activeProperty().addListener(this.selectedListener);
    }

    @Override
    protected void handleEvents(String EVENT_TYPE) {
        super.handleEvents(EVENT_TYPE);
        if ("VISIBILITY".equals(EVENT_TYPE)) {
            Helper.enableNode(this.titleText, !this.tile.getTitle().isEmpty());
            Helper.enableNode(this.text, this.tile.isTextVisible());
            Helper.enableNode(this.description, !this.tile.getDescription().isEmpty());
        }
    }

    private void moveThumb() {
        KeyValue thumbLeftX = new KeyValue(this.thumb.centerXProperty(), this.switchBackground.getLayoutX() + this.size * 0.1);
        KeyValue thumbRightX = new KeyValue(this.thumb.centerXProperty(), this.switchBackground.getLayoutX() + this.switchBackground.getWidth() - this.size * 0.1);
        KeyValue switchBackgroundLeftColor = new KeyValue(this.switchBackground.fillProperty(), this.tile.getBackgroundColor());
        KeyValue switchBackgroundRightColor = new KeyValue(this.switchBackground.fillProperty(), this.tile.getActiveColor());
        if (this.tile.isActive()) {
            KeyFrame kf0 = new KeyFrame(Duration.ZERO, thumbLeftX, switchBackgroundLeftColor);
            KeyFrame kf1 = new KeyFrame(Duration.millis(200.0), thumbRightX, switchBackgroundRightColor);
            this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{kf0, kf1});
        } else {
            KeyFrame kf0 = new KeyFrame(Duration.ZERO, thumbRightX, switchBackgroundRightColor);
            KeyFrame kf1 = new KeyFrame(Duration.millis(200.0), thumbLeftX, switchBackgroundLeftColor);
            this.timeline.getKeyFrames().setAll((KeyFrame[])new KeyFrame[]{kf0, kf1});
        }
        this.timeline.play();
    }

    @Override
    public void dispose() {
        this.switchBorder.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.mouseEventHandler);
        this.switchBorder.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.mouseEventHandler);
        this.tile.activeProperty().removeListener(this.selectedListener);
        super.dispose();
    }

    @Override
    protected void resizeStaticText() {
        double maxWidth = this.width - this.size * 0.1;
        double fontSize = this.size * this.textSize.factor;
        boolean customFontEnabled = this.tile.isCustomFontEnabled();
        Font customFont = this.tile.getCustomFont();
        Font font = customFontEnabled && customFont != null ? Font.font(customFont.getFamily(), fontSize) : Fonts.latoRegular(fontSize);
        this.titleText.setFont(font);
        if (this.titleText.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.titleText, maxWidth, fontSize);
        }
        switch (this.tile.getTitleAlignment()) {
            default: {
                this.titleText.relocate(this.size * 0.05, this.size * 0.05);
                break;
            }
            case CENTER: {
                this.titleText.relocate((this.width - this.titleText.getLayoutBounds().getWidth()) * 0.5, this.size * 0.05);
                break;
            }
            case RIGHT: {
                this.titleText.relocate(this.width - this.size * 0.05 - this.titleText.getLayoutBounds().getWidth(), this.size * 0.05);
            }
        }
        this.text.setText(this.tile.getText());
        this.text.setFont(font);
        if (this.text.getLayoutBounds().getWidth() > maxWidth) {
            Helper.adjustTextSize(this.text, maxWidth, fontSize);
        }
        switch (this.tile.getTextAlignment()) {
            default: {
                this.text.setX(this.size * 0.05);
                break;
            }
            case CENTER: {
                this.text.setX((this.width - this.text.getLayoutBounds().getWidth()) * 0.5);
                break;
            }
            case RIGHT: {
                this.text.setX(this.width - this.size * 0.05 - this.text.getLayoutBounds().getWidth());
            }
        }
        this.text.setY(this.height - this.size * 0.05);
        fontSize = this.size * 0.1;
        this.description.setFont(Fonts.latoRegular(fontSize));
    }

    @Override
    protected void resize() {
        super.resize();
        this.description.setPrefSize(this.contentBounds.getWidth(), this.size * 0.43);
        this.description.relocate(this.contentBounds.getX(), this.height * 0.42);
        this.switchBorder.setWidth(this.size * 0.445);
        this.switchBorder.setHeight(this.size * 0.22);
        this.switchBorder.setArcWidth(this.size * 0.22);
        this.switchBorder.setArcHeight(this.size * 0.22);
        this.switchBorder.relocate((this.width - this.switchBorder.getWidth()) * 0.5, this.tile.getDescription().isEmpty() ? (this.height - this.switchBorder.getHeight()) * 0.5 : this.height - this.size * 0.4);
        this.switchBackground.setWidth(this.size * 0.425);
        this.switchBackground.setHeight(this.size * 0.2);
        this.switchBackground.setArcWidth(this.size * 0.2);
        this.switchBackground.setArcHeight(this.size * 0.2);
        this.switchBackground.relocate((this.width - this.switchBackground.getWidth()) * 0.5, this.tile.getDescription().isEmpty() ? (this.height - this.switchBackground.getHeight()) * 0.5 : this.height - this.size * 0.39);
        this.thumb.setRadius(this.size * 0.09);
        this.thumb.setCenterX(this.tile.isActive() ? this.switchBackground.getLayoutX() + this.switchBackground.getWidth() - this.size * 0.1 : this.switchBackground.getLayoutX() + this.size * 0.1);
        this.thumb.setCenterY(this.tile.getDescription().isEmpty() ? this.height * 0.5 : this.height - this.size * 0.29);
    }

    @Override
    protected void redraw() {
        super.redraw();
        this.titleText.setText(this.tile.getTitle());
        this.text.setText(this.tile.getText());
        this.description.setText(this.tile.getDescription());
        this.description.setAlignment(this.tile.getDescriptionAlignment());
        this.resizeStaticText();
        this.titleText.setFill(this.tile.getTitleColor());
        this.text.setFill(this.tile.getTextColor());
        this.description.setTextFill(this.tile.getDescriptionColor());
        this.switchBorder.setFill(this.tile.getForegroundColor());
        this.thumb.setFill(this.tile.getForegroundColor());
    }
}

