# Migrating to 14.0.0

This release contains breaking changes. We know these can be disruptive, but they were needed to keep our dependencies up to date and Stylelint free of security issues.

## Users

There are five changes that may affect you:

- the `syntax` option and automatic inferral of syntax was removed
- Node.js 10 support was dropped
- the rules deprecated in 13.7.0 were removed
- the `configOverrides` option was removed
- the `function-calc-no-invalid` rule was removed

If you need to update your config file, you may need delete your `.stylelintcache` file too.

### `syntax` option and automatic inferral of syntax

Stylelint no longer includes the syntaxes that:

- parse CSS-like languages like SCSS, Sass, Less and SugarSS
- extract styles from HTML, Markdown and CSS-in-JS object & template literals

If you use Stylelint to lint anything other than CSS files, you will need to install and configure these syntaxes. We recommend [extending](../user-guide/configure.md#extends) a shared config that includes the appropriate [PostCSS syntax](https://github.com/postcss/postcss#syntaxes) for you. For example, if you use Stylelint to lint SCSS, you can extend the [stylelint-config-standard-scss shared config](https://www.npmjs.com/package/stylelint-config-standard-scss).

First, install the shared config as a dependency:

```shell
npm install --save-dev stylelint-config-standard-scss
```

Then, update your [configuration object](../user-guide/configure.md) to use it:

```json
{
  "extends": ["stylelint-config-standard-scss"],
  "rules": {
    ..
  }
}
```

This shared config extends Stylelint to be compatible with SCSS. It configures the [built-in rules](../user-guide/rules/list.md) for SCSS, and includes the [postcss-scss syntax](https://www.npmjs.com/package/postcss-scss) and [stylelint-scss plugin](https://www.npmjs.com/package/stylelint-scss) (a collection of rules specific to SCSS).

If a shared config isn't available for your perferred language or library, then you can install the appropriate [PostCSS syntax](https://github.com/postcss/postcss#syntaxes) yourself and use the [`customSyntax` option](../user-guide/usage/options.md#customSyntax), which is now available in the configuration object.

For example, to lint [SugarSS](https://github.com/postcss/sugarss).

First, install the [sugarss syntax](https://www.npmjs.com/package/sugarss) as a dependency:

```shell
npm install --save-dev sugarss
```

Then, update your configuration object to use it:

```json
{
  "customSyntax": "sugarss",
  "rules": {
    ..
  }
}
```

For other languages and embedded styles, we suggest the following [PostCSS syntaxes](https://github.com/postcss/postcss#syntaxes):

- Less language (`.less`) use [postcss-less](https://www.npmjs.com/package/postcss-less)
- Sass language (`.sass`) use [postcss-sass](https://www.npmjs.com/package/postcss-sass)
- CSS-in-JS embeds (`.js`, `.jsx`, `.ts` etc.) use [@stylelint/postcss-css-in-js](https://www.npmjs.com/package/@stylelint/postcss-css-in-js)
- HTML, XML and HTML-like embeds (`.html`, `.xml`, `.svelte`, `.vue` etc.) use [postcss-html](https://www.npmjs.com/package/postcss-html)
- Markdown embeds (`.md`, `.markdown` etc.) use [postcss-markdown](https://www.npmjs.com/package/postcss-markdown)

(The [postcss-markdown](https://www.npmjs.com/package/postcss-markdown) package needs a maintainer (see [this issue](https://github.com/stylelint/stylelint/issues/5583)). The [@stylelint/postcss-css-in-js](https://www.npmjs.com/package/@stylelint/postcss-css-in-js) package [has issues](https://github.com/stylelint/stylelint/issues/4574). It will likely to be deprecated in the future in favor of smaller syntaxes that focus on only one library (see [this issue](https://github.com/stylelint/postcss-css-in-js/issues/225))).

If you lint more than one styling language, then you can use the new [`overrides` property](../user-guide/configure.md#overrides). For example, to lint both CSS and [SugarSS](https://github.com/postcss/sugarss) you can update your configuration object to include:

```json
{
  "extends": ["stylelint-config-standard"],
  "overrides": [
    {
      "files": ["**/*.sss"],
      "customSyntax": "sugarss",
      "rules": {
        "block-closing-brace-empty-line-before": null,
        "block-closing-brace-newline-after": null,
        "block-closing-brace-newline-before": null,
        "block-closing-brace-space-before": null,
        "block-opening-brace-newline-after": null,
        "block-opening-brace-space-after": null,
        "block-opening-brace-space-before": null,
        "declaration-block-semicolon-newline-after": null,
        "declaration-block-semicolon-space-after": null,
        "declaration-block-semicolon-space-before": null,
        "declaration-block-trailing-semicolon": null
      }
    }
  ]
}
```

Which will extend the [official standard config](https://github.com/stylelint/stylelint-config-standard), then use the `overrides` property to set the `customSyntax` property and turn off the rules that check braces and semicolons for SugarSS files.

You can then use Stylelint to lint both CSS and SugarSS files:

```shell
npx stylelint "**/*.{css,sss}"
```

### Node.js 10

Support for Node.js 10 was dropped. You should use the following or higher versions of Node.js:

- 12.20.0
- 14.13.1
- 16.0.0

### Rules deprecated in 13.7.0

The rules deprecated in 13.7.0 were removed. You should refer to the [list of alternatives in the 13.7.0 CHANGELOG entry](../../CHANGELOG.md#1370) and use them instead.

### `configOverrides` option

The `configOverrides` option has been removed. Use the [`overrides` property](../user-guide/configure.md#overrides) in the configuration object instead.

### `function-calc-no-invalid` rule

The `function-calc-no-invalid` has be removed. You should remove it from your configuration object.

## Plugin authors

There are three changes that may affect you:

- version 8 of PostCSS is now used in stylelint
- a [`disableFix` secondary option](../user-guide/configure.md#disableFix) was added
- TypeScript type definitions were added to the package

### PostCSS 8

The behavior of the parser has changed in PostCSS version 8. The following is now parsed as a `Declaration` when it was previously parsed as a `Rule`:

```css
foo: {
  bar: baz;
}
```

If your plugin targets this construct, you'll need to update your logic.

Even though version 8 of PostCSS is used in stylelint, you can't use the [new Visitor API](https://github.com/postcss/postcss/releases/tag/8.0.0) as Stylelint plugins are converted to use `Once` by Stylelint itself. You should continue to use the `walk*` API.

### `disableFix` secondary option

We previously suggested plugin authors provide this option. It is now available in Stylelint itself, and you should remove the option from your plugin.

### Built-in TypeScript definitions

The `stylelint` package exports its own TypeScript type definitions now. If you are using the `@types/stylelint` package, you should remove it from your dependencies.
