/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BS;
import javajs.util.P3;
import javajs.util.P3i;
import org.jmol.c.PAL;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.shape.Shape;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Edge;
import org.jmol.util.Escape;

public class Sticks
extends Shape {
    private int myMask;
    public boolean reportAll;
    public BS bsOrderSet;
    private BS selectedBonds;
    private int[] closestAtom = new int[1];
    private static final int MAX_BOND_CLICK_DISTANCE_SQUARED = 100;
    private final P3i ptXY = new P3i();
    private static final int XY_THREASHOLD = 40;

    @Override
    public void initShape() {
        this.myMask = 1023;
        this.reportAll = false;
    }

    @Override
    protected void setSize(int size, BS bsSelected) {
        if (size == Integer.MAX_VALUE) {
            this.selectedBonds = BSUtil.copy(bsSelected);
            return;
        }
        if (size == Integer.MIN_VALUE) {
            if (this.bsOrderSet == null) {
                this.bsOrderSet = new BS();
            }
            this.bsOrderSet.or(bsSelected);
            return;
        }
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BS();
        }
        BondIterator iter = this.selectedBonds != null ? this.ms.getBondIterator(this.selectedBonds) : this.ms.getBondIteratorForType(this.myMask, bsSelected);
        short mad = (short)size;
        while (iter.hasNext()) {
            this.bsSizeSet.set(iter.nextIndex());
            iter.next().setMad(mad);
        }
    }

    @Override
    public void setProperty(String propertyName, Object value, BS bs) {
        if ("type" == propertyName) {
            this.myMask = (Integer)value;
            return;
        }
        if ("reportAll" == propertyName) {
            this.reportAll = true;
            return;
        }
        if ("reset" == propertyName) {
            this.bsOrderSet = null;
            this.bsSizeSet = null;
            this.bsColixSet = null;
            this.selectedBonds = null;
            return;
        }
        if ("bondOrder" == propertyName) {
            BondIterator iter;
            if (this.bsOrderSet == null) {
                this.bsOrderSet = new BS();
            }
            int order = (Integer)value;
            BondIterator bondIterator = iter = this.selectedBonds != null ? this.ms.getBondIterator(this.selectedBonds) : this.ms.getBondIteratorForType(65535, bs);
            while (iter.hasNext()) {
                this.bsOrderSet.set(iter.nextIndex());
                iter.next().setOrder(order);
            }
            return;
        }
        if ("color" == propertyName) {
            BondIterator iter;
            PAL pal;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            short colix = C.getColixO(value);
            PAL pAL = pal = value instanceof PAL ? (PAL)((Object)value) : null;
            if (pal == PAL.TYPE || pal == PAL.ENERGY) {
                BondIterator iter2;
                boolean isEnergy = pal == PAL.ENERGY;
                BondIterator bondIterator = iter2 = this.selectedBonds != null ? this.ms.getBondIterator(this.selectedBonds) : this.ms.getBondIteratorForType(this.myMask, bs);
                while (iter2.hasNext()) {
                    this.bsColixSet.set(iter2.nextIndex());
                    Bond bond = iter2.next();
                    bond.colix = isEnergy ? this.getColixB(colix, pal.id, bond) : C.getColix(Edge.getArgbHbondType(bond.order));
                }
                return;
            }
            if (colix == 2 && pal != PAL.CPK) {
                return;
            }
            BondIterator bondIterator = iter = this.selectedBonds != null ? this.ms.getBondIterator(this.selectedBonds) : this.ms.getBondIteratorForType(this.myMask, bs);
            while (iter.hasNext()) {
                int iBond = iter.nextIndex();
                iter.next().colix = colix;
                this.bsColixSet.setBitTo(iBond, colix != 0 && colix != 2);
            }
            return;
        }
        if ("translucency" == propertyName) {
            BondIterator iter;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            boolean isTranslucent = ((String)value).equals("translucent");
            BondIterator bondIterator = iter = this.selectedBonds != null ? this.ms.getBondIterator(this.selectedBonds) : this.ms.getBondIteratorForType(this.myMask, bs);
            while (iter.hasNext()) {
                this.bsColixSet.set(iter.nextIndex());
                iter.next().setTranslucent(isTranslucent, this.translucentLevel);
            }
            return;
        }
        if ("deleteModelAtoms" == propertyName) {
            return;
        }
        this.setPropS(propertyName, value, bs);
    }

    @Override
    public Object getProperty(String property, int index) {
        if (property.equals("selectionState")) {
            return this.selectedBonds != null ? "select BONDS " + Escape.eBS(this.selectedBonds) + "\n" : "";
        }
        if (property.equals("sets")) {
            return new BS[]{this.bsOrderSet, this.bsSizeSet, this.bsColixSet};
        }
        return null;
    }

    @Override
    public void setAtomClickability() {
        Bond[] bonds = this.ms.bo;
        int i = this.ms.bondCount;
        while (--i >= 0) {
            Bond bond = bonds[i];
            if ((bond.shapeVisibilityFlags & this.vf) == 0 || this.ms.isAtomHidden(bond.atom1.i) || this.ms.isAtomHidden(bond.atom2.i)) continue;
            bond.atom1.setClickable(this.vf);
            bond.atom2.setClickable(this.vf);
        }
    }

    @Override
    public String getShapeState() {
        return null;
    }

    @Override
    public boolean checkObjectHovered(int x, int y, BS bsVisible) {
        P3 pt = new P3();
        Bond bond = this.findPickedBond(x, y, bsVisible, pt, this.closestAtom);
        if (bond == null) {
            return false;
        }
        this.vwr.highlightBond(bond.index, this.closestAtom[0], x, y);
        return true;
    }

    @Override
    public Map<String, Object> checkObjectClicked(int x, int y, int modifiers, BS bsVisible, boolean drawPicking) {
        P3 pt = new P3();
        Bond bond = this.findPickedBond(x, y, bsVisible, pt, this.closestAtom);
        if (bond == null) {
            return null;
        }
        short modelIndex = bond.atom1.mi;
        String info = bond.getIdentity();
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        map.put("pt", pt);
        map.put("index", bond.index);
        map.put("modelIndex", Integer.valueOf(modelIndex));
        map.put("model", this.vwr.getModelNumberDotted(modelIndex));
        map.put("type", "bond");
        map.put("info", info);
        this.vwr.setStatusAtomPicked(-3, "[\"bond\",\"" + bond.getIdentity() + "\"," + pt.x + "," + pt.y + "," + pt.z + "]", map, false);
        return map;
    }

    private Bond findPickedBond(int x, int y, BS bsVisible, P3 pt, int[] closestAtom) {
        int dmin2 = 100;
        if (this.vwr.gdata.isAntialiased()) {
            x <<= 1;
            y <<= 1;
            dmin2 <<= 1;
        }
        Bond pickedBond = null;
        P3 v = new P3();
        Bond[] bonds = this.ms.bo;
        int i = this.ms.bondCount;
        while (--i >= 0) {
            float f;
            Bond bond = bonds[i];
            if (bond.shapeVisibilityFlags == 0) continue;
            Atom atom1 = bond.atom1;
            Atom atom2 = bond.atom2;
            if (!atom1.checkVisible() || !atom2.checkVisible()) continue;
            v.ave(atom1, atom2);
            int d2 = this.coordinateInRange(x, y, v, dmin2, this.ptXY);
            if (d2 < 0 || Math.abs(atom1.sY - atom2.sY) + Math.abs(atom1.sX - atom2.sX) <= 40 || (f = 1.0f * (float)(this.ptXY.x - atom1.sX) / (float)(atom2.sX - atom1.sX)) < 0.4f || f > 0.6f) continue;
            dmin2 = d2;
            pickedBond = bond;
            if (closestAtom != null) {
                closestAtom[0] = f < 0.5f ? atom1.i : atom2.i;
            }
            pt.setT(v);
        }
        return pickedBond;
    }
}

