// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See helper_file_generator.py for modifications


/***************************************************************************
 *
 * Copyright (c) 2015-2021 The Khronos Group Inc.
 * Copyright (c) 2015-2021 Valve Corporation
 * Copyright (c) 2015-2021 LunarG, Inc.
 * Copyright (c) 2015-2021 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Author: Mark Lobodzinski <mark@lunarg.com>
 * Author: Courtney Goeltzenleuchter <courtneygo@google.com>
 * Author: Tobin Ehlis <tobine@google.com>
 * Author: Chris Forbes <chrisforbes@google.com>
 * Author: John Zulauf<jzulauf@lunarg.com>
 *
 ****************************************************************************/


#include "vk_safe_struct.h"

#include <string.h>
#include <cassert>
#include <cstring>
#include <vector>

#include <vulkan/vk_layer.h>

extern std::vector<std::pair<uint32_t, uint32_t>> custom_stype_info;


safe_VkBufferMemoryBarrier::safe_VkBufferMemoryBarrier(const VkBufferMemoryBarrier* in_struct) :
    sType(in_struct->sType),
    srcAccessMask(in_struct->srcAccessMask),
    dstAccessMask(in_struct->dstAccessMask),
    srcQueueFamilyIndex(in_struct->srcQueueFamilyIndex),
    dstQueueFamilyIndex(in_struct->dstQueueFamilyIndex),
    buffer(in_struct->buffer),
    offset(in_struct->offset),
    size(in_struct->size)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferMemoryBarrier::safe_VkBufferMemoryBarrier() :
    sType(VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER),
    pNext(nullptr)
{}

safe_VkBufferMemoryBarrier::safe_VkBufferMemoryBarrier(const safe_VkBufferMemoryBarrier& copy_src)
{
    sType = copy_src.sType;
    srcAccessMask = copy_src.srcAccessMask;
    dstAccessMask = copy_src.dstAccessMask;
    srcQueueFamilyIndex = copy_src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src.dstQueueFamilyIndex;
    buffer = copy_src.buffer;
    offset = copy_src.offset;
    size = copy_src.size;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBufferMemoryBarrier& safe_VkBufferMemoryBarrier::operator=(const safe_VkBufferMemoryBarrier& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcAccessMask = copy_src.srcAccessMask;
    dstAccessMask = copy_src.dstAccessMask;
    srcQueueFamilyIndex = copy_src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src.dstQueueFamilyIndex;
    buffer = copy_src.buffer;
    offset = copy_src.offset;
    size = copy_src.size;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBufferMemoryBarrier::~safe_VkBufferMemoryBarrier()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferMemoryBarrier::initialize(const VkBufferMemoryBarrier* in_struct)
{
    sType = in_struct->sType;
    srcAccessMask = in_struct->srcAccessMask;
    dstAccessMask = in_struct->dstAccessMask;
    srcQueueFamilyIndex = in_struct->srcQueueFamilyIndex;
    dstQueueFamilyIndex = in_struct->dstQueueFamilyIndex;
    buffer = in_struct->buffer;
    offset = in_struct->offset;
    size = in_struct->size;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferMemoryBarrier::initialize(const safe_VkBufferMemoryBarrier* copy_src)
{
    sType = copy_src->sType;
    srcAccessMask = copy_src->srcAccessMask;
    dstAccessMask = copy_src->dstAccessMask;
    srcQueueFamilyIndex = copy_src->srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src->dstQueueFamilyIndex;
    buffer = copy_src->buffer;
    offset = copy_src->offset;
    size = copy_src->size;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkImageMemoryBarrier::safe_VkImageMemoryBarrier(const VkImageMemoryBarrier* in_struct) :
    sType(in_struct->sType),
    srcAccessMask(in_struct->srcAccessMask),
    dstAccessMask(in_struct->dstAccessMask),
    oldLayout(in_struct->oldLayout),
    newLayout(in_struct->newLayout),
    srcQueueFamilyIndex(in_struct->srcQueueFamilyIndex),
    dstQueueFamilyIndex(in_struct->dstQueueFamilyIndex),
    image(in_struct->image),
    subresourceRange(in_struct->subresourceRange)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageMemoryBarrier::safe_VkImageMemoryBarrier() :
    sType(VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER),
    pNext(nullptr)
{}

safe_VkImageMemoryBarrier::safe_VkImageMemoryBarrier(const safe_VkImageMemoryBarrier& copy_src)
{
    sType = copy_src.sType;
    srcAccessMask = copy_src.srcAccessMask;
    dstAccessMask = copy_src.dstAccessMask;
    oldLayout = copy_src.oldLayout;
    newLayout = copy_src.newLayout;
    srcQueueFamilyIndex = copy_src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src.dstQueueFamilyIndex;
    image = copy_src.image;
    subresourceRange = copy_src.subresourceRange;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageMemoryBarrier& safe_VkImageMemoryBarrier::operator=(const safe_VkImageMemoryBarrier& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcAccessMask = copy_src.srcAccessMask;
    dstAccessMask = copy_src.dstAccessMask;
    oldLayout = copy_src.oldLayout;
    newLayout = copy_src.newLayout;
    srcQueueFamilyIndex = copy_src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src.dstQueueFamilyIndex;
    image = copy_src.image;
    subresourceRange = copy_src.subresourceRange;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageMemoryBarrier::~safe_VkImageMemoryBarrier()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageMemoryBarrier::initialize(const VkImageMemoryBarrier* in_struct)
{
    sType = in_struct->sType;
    srcAccessMask = in_struct->srcAccessMask;
    dstAccessMask = in_struct->dstAccessMask;
    oldLayout = in_struct->oldLayout;
    newLayout = in_struct->newLayout;
    srcQueueFamilyIndex = in_struct->srcQueueFamilyIndex;
    dstQueueFamilyIndex = in_struct->dstQueueFamilyIndex;
    image = in_struct->image;
    subresourceRange = in_struct->subresourceRange;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageMemoryBarrier::initialize(const safe_VkImageMemoryBarrier* copy_src)
{
    sType = copy_src->sType;
    srcAccessMask = copy_src->srcAccessMask;
    dstAccessMask = copy_src->dstAccessMask;
    oldLayout = copy_src->oldLayout;
    newLayout = copy_src->newLayout;
    srcQueueFamilyIndex = copy_src->srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src->dstQueueFamilyIndex;
    image = copy_src->image;
    subresourceRange = copy_src->subresourceRange;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkMemoryBarrier::safe_VkMemoryBarrier(const VkMemoryBarrier* in_struct) :
    sType(in_struct->sType),
    srcAccessMask(in_struct->srcAccessMask),
    dstAccessMask(in_struct->dstAccessMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryBarrier::safe_VkMemoryBarrier() :
    sType(VK_STRUCTURE_TYPE_MEMORY_BARRIER),
    pNext(nullptr)
{}

safe_VkMemoryBarrier::safe_VkMemoryBarrier(const safe_VkMemoryBarrier& copy_src)
{
    sType = copy_src.sType;
    srcAccessMask = copy_src.srcAccessMask;
    dstAccessMask = copy_src.dstAccessMask;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryBarrier& safe_VkMemoryBarrier::operator=(const safe_VkMemoryBarrier& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcAccessMask = copy_src.srcAccessMask;
    dstAccessMask = copy_src.dstAccessMask;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryBarrier::~safe_VkMemoryBarrier()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryBarrier::initialize(const VkMemoryBarrier* in_struct)
{
    sType = in_struct->sType;
    srcAccessMask = in_struct->srcAccessMask;
    dstAccessMask = in_struct->dstAccessMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryBarrier::initialize(const safe_VkMemoryBarrier* copy_src)
{
    sType = copy_src->sType;
    srcAccessMask = copy_src->srcAccessMask;
    dstAccessMask = copy_src->dstAccessMask;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkAllocationCallbacks::safe_VkAllocationCallbacks(const VkAllocationCallbacks* in_struct) :
    pUserData(in_struct->pUserData),
    pfnAllocation(in_struct->pfnAllocation),
    pfnReallocation(in_struct->pfnReallocation),
    pfnFree(in_struct->pfnFree),
    pfnInternalAllocation(in_struct->pfnInternalAllocation),
    pfnInternalFree(in_struct->pfnInternalFree)
{
}

safe_VkAllocationCallbacks::safe_VkAllocationCallbacks() :
    pUserData(nullptr)
{}

safe_VkAllocationCallbacks::safe_VkAllocationCallbacks(const safe_VkAllocationCallbacks& copy_src)
{
    pUserData = copy_src.pUserData;
    pfnAllocation = copy_src.pfnAllocation;
    pfnReallocation = copy_src.pfnReallocation;
    pfnFree = copy_src.pfnFree;
    pfnInternalAllocation = copy_src.pfnInternalAllocation;
    pfnInternalFree = copy_src.pfnInternalFree;
}

safe_VkAllocationCallbacks& safe_VkAllocationCallbacks::operator=(const safe_VkAllocationCallbacks& copy_src)
{
    if (&copy_src == this) return *this;


    pUserData = copy_src.pUserData;
    pfnAllocation = copy_src.pfnAllocation;
    pfnReallocation = copy_src.pfnReallocation;
    pfnFree = copy_src.pfnFree;
    pfnInternalAllocation = copy_src.pfnInternalAllocation;
    pfnInternalFree = copy_src.pfnInternalFree;

    return *this;
}

safe_VkAllocationCallbacks::~safe_VkAllocationCallbacks()
{
}

void safe_VkAllocationCallbacks::initialize(const VkAllocationCallbacks* in_struct)
{
    pUserData = in_struct->pUserData;
    pfnAllocation = in_struct->pfnAllocation;
    pfnReallocation = in_struct->pfnReallocation;
    pfnFree = in_struct->pfnFree;
    pfnInternalAllocation = in_struct->pfnInternalAllocation;
    pfnInternalFree = in_struct->pfnInternalFree;
}

void safe_VkAllocationCallbacks::initialize(const safe_VkAllocationCallbacks* copy_src)
{
    pUserData = copy_src->pUserData;
    pfnAllocation = copy_src->pfnAllocation;
    pfnReallocation = copy_src->pfnReallocation;
    pfnFree = copy_src->pfnFree;
    pfnInternalAllocation = copy_src->pfnInternalAllocation;
    pfnInternalFree = copy_src->pfnInternalFree;
}

safe_VkApplicationInfo::safe_VkApplicationInfo(const VkApplicationInfo* in_struct) :
    sType(in_struct->sType),
    applicationVersion(in_struct->applicationVersion),
    engineVersion(in_struct->engineVersion),
    apiVersion(in_struct->apiVersion)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pApplicationName = SafeStringCopy(in_struct->pApplicationName);
    pEngineName = SafeStringCopy(in_struct->pEngineName);
}

safe_VkApplicationInfo::safe_VkApplicationInfo() :
    sType(VK_STRUCTURE_TYPE_APPLICATION_INFO),
    pNext(nullptr),
    pApplicationName(nullptr),
    pEngineName(nullptr)
{}

safe_VkApplicationInfo::safe_VkApplicationInfo(const safe_VkApplicationInfo& copy_src)
{
    sType = copy_src.sType;
    applicationVersion = copy_src.applicationVersion;
    engineVersion = copy_src.engineVersion;
    apiVersion = copy_src.apiVersion;
    pNext = SafePnextCopy(copy_src.pNext);
    pApplicationName = SafeStringCopy(copy_src.pApplicationName);
    pEngineName = SafeStringCopy(copy_src.pEngineName);
}

safe_VkApplicationInfo& safe_VkApplicationInfo::operator=(const safe_VkApplicationInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pApplicationName) delete [] pApplicationName;
    if (pEngineName) delete [] pEngineName;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    applicationVersion = copy_src.applicationVersion;
    engineVersion = copy_src.engineVersion;
    apiVersion = copy_src.apiVersion;
    pNext = SafePnextCopy(copy_src.pNext);
    pApplicationName = SafeStringCopy(copy_src.pApplicationName);
    pEngineName = SafeStringCopy(copy_src.pEngineName);

    return *this;
}

safe_VkApplicationInfo::~safe_VkApplicationInfo()
{
    if (pApplicationName) delete [] pApplicationName;
    if (pEngineName) delete [] pEngineName;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkApplicationInfo::initialize(const VkApplicationInfo* in_struct)
{
    sType = in_struct->sType;
    applicationVersion = in_struct->applicationVersion;
    engineVersion = in_struct->engineVersion;
    apiVersion = in_struct->apiVersion;
    pNext = SafePnextCopy(in_struct->pNext);
    pApplicationName = SafeStringCopy(in_struct->pApplicationName);
    pEngineName = SafeStringCopy(in_struct->pEngineName);
}

void safe_VkApplicationInfo::initialize(const safe_VkApplicationInfo* copy_src)
{
    sType = copy_src->sType;
    applicationVersion = copy_src->applicationVersion;
    engineVersion = copy_src->engineVersion;
    apiVersion = copy_src->apiVersion;
    pNext = SafePnextCopy(copy_src->pNext);
    pApplicationName = SafeStringCopy(copy_src->pApplicationName);
    pEngineName = SafeStringCopy(copy_src->pEngineName);
}

safe_VkInstanceCreateInfo::safe_VkInstanceCreateInfo(const VkInstanceCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pApplicationInfo(nullptr),
    enabledLayerCount(in_struct->enabledLayerCount),
    enabledExtensionCount(in_struct->enabledExtensionCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
    char **tmp_ppEnabledLayerNames = new char *[in_struct->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(in_struct->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[in_struct->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(in_struct->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (in_struct->pApplicationInfo)
        pApplicationInfo = new safe_VkApplicationInfo(in_struct->pApplicationInfo);
}

safe_VkInstanceCreateInfo::safe_VkInstanceCreateInfo() :
    sType(VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO),
    pNext(nullptr),
    pApplicationInfo(nullptr),
    ppEnabledLayerNames(nullptr),
    ppEnabledExtensionNames(nullptr)
{}

safe_VkInstanceCreateInfo::safe_VkInstanceCreateInfo(const safe_VkInstanceCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    pApplicationInfo = nullptr;
    enabledLayerCount = copy_src.enabledLayerCount;
    enabledExtensionCount = copy_src.enabledExtensionCount;
    pNext = SafePnextCopy(copy_src.pNext);
    char **tmp_ppEnabledLayerNames = new char *[copy_src.enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(copy_src.ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[copy_src.enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(copy_src.ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (copy_src.pApplicationInfo)
        pApplicationInfo = new safe_VkApplicationInfo(*copy_src.pApplicationInfo);
}

safe_VkInstanceCreateInfo& safe_VkInstanceCreateInfo::operator=(const safe_VkInstanceCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pApplicationInfo)
        delete pApplicationInfo;
    if (ppEnabledLayerNames) {
        for (uint32_t i = 0; i < enabledLayerCount; ++i) {
            delete [] ppEnabledLayerNames[i];
        }
        delete [] ppEnabledLayerNames;
    }
    if (ppEnabledExtensionNames) {
        for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
            delete [] ppEnabledExtensionNames[i];
        }
        delete [] ppEnabledExtensionNames;
    }
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    pApplicationInfo = nullptr;
    enabledLayerCount = copy_src.enabledLayerCount;
    enabledExtensionCount = copy_src.enabledExtensionCount;
    pNext = SafePnextCopy(copy_src.pNext);
    char **tmp_ppEnabledLayerNames = new char *[copy_src.enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(copy_src.ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[copy_src.enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(copy_src.ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (copy_src.pApplicationInfo)
        pApplicationInfo = new safe_VkApplicationInfo(*copy_src.pApplicationInfo);

    return *this;
}

safe_VkInstanceCreateInfo::~safe_VkInstanceCreateInfo()
{
    if (pApplicationInfo)
        delete pApplicationInfo;
    if (ppEnabledLayerNames) {
        for (uint32_t i = 0; i < enabledLayerCount; ++i) {
            delete [] ppEnabledLayerNames[i];
        }
        delete [] ppEnabledLayerNames;
    }
    if (ppEnabledExtensionNames) {
        for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
            delete [] ppEnabledExtensionNames[i];
        }
        delete [] ppEnabledExtensionNames;
    }
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkInstanceCreateInfo::initialize(const VkInstanceCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pApplicationInfo = nullptr;
    enabledLayerCount = in_struct->enabledLayerCount;
    enabledExtensionCount = in_struct->enabledExtensionCount;
    pNext = SafePnextCopy(in_struct->pNext);
    char **tmp_ppEnabledLayerNames = new char *[in_struct->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(in_struct->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[in_struct->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(in_struct->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (in_struct->pApplicationInfo)
        pApplicationInfo = new safe_VkApplicationInfo(in_struct->pApplicationInfo);
}

void safe_VkInstanceCreateInfo::initialize(const safe_VkInstanceCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    pApplicationInfo = nullptr;
    enabledLayerCount = copy_src->enabledLayerCount;
    enabledExtensionCount = copy_src->enabledExtensionCount;
    pNext = SafePnextCopy(copy_src->pNext);
    char **tmp_ppEnabledLayerNames = new char *[copy_src->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(copy_src->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[copy_src->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(copy_src->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (copy_src->pApplicationInfo)
        pApplicationInfo = new safe_VkApplicationInfo(*copy_src->pApplicationInfo);
}

safe_VkDeviceQueueCreateInfo::safe_VkDeviceQueueCreateInfo(const VkDeviceQueueCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    queueFamilyIndex(in_struct->queueFamilyIndex),
    queueCount(in_struct->queueCount),
    pQueuePriorities(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueuePriorities) {
        pQueuePriorities = new float[in_struct->queueCount];
        memcpy ((void *)pQueuePriorities, (void *)in_struct->pQueuePriorities, sizeof(float)*in_struct->queueCount);
    }
}

safe_VkDeviceQueueCreateInfo::safe_VkDeviceQueueCreateInfo() :
    sType(VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO),
    pNext(nullptr),
    pQueuePriorities(nullptr)
{}

safe_VkDeviceQueueCreateInfo::safe_VkDeviceQueueCreateInfo(const safe_VkDeviceQueueCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    queueFamilyIndex = copy_src.queueFamilyIndex;
    queueCount = copy_src.queueCount;
    pQueuePriorities = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pQueuePriorities) {
        pQueuePriorities = new float[copy_src.queueCount];
        memcpy ((void *)pQueuePriorities, (void *)copy_src.pQueuePriorities, sizeof(float)*copy_src.queueCount);
    }
}

safe_VkDeviceQueueCreateInfo& safe_VkDeviceQueueCreateInfo::operator=(const safe_VkDeviceQueueCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pQueuePriorities)
        delete[] pQueuePriorities;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    queueFamilyIndex = copy_src.queueFamilyIndex;
    queueCount = copy_src.queueCount;
    pQueuePriorities = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pQueuePriorities) {
        pQueuePriorities = new float[copy_src.queueCount];
        memcpy ((void *)pQueuePriorities, (void *)copy_src.pQueuePriorities, sizeof(float)*copy_src.queueCount);
    }

    return *this;
}

safe_VkDeviceQueueCreateInfo::~safe_VkDeviceQueueCreateInfo()
{
    if (pQueuePriorities)
        delete[] pQueuePriorities;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceQueueCreateInfo::initialize(const VkDeviceQueueCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    queueFamilyIndex = in_struct->queueFamilyIndex;
    queueCount = in_struct->queueCount;
    pQueuePriorities = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pQueuePriorities) {
        pQueuePriorities = new float[in_struct->queueCount];
        memcpy ((void *)pQueuePriorities, (void *)in_struct->pQueuePriorities, sizeof(float)*in_struct->queueCount);
    }
}

void safe_VkDeviceQueueCreateInfo::initialize(const safe_VkDeviceQueueCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    queueFamilyIndex = copy_src->queueFamilyIndex;
    queueCount = copy_src->queueCount;
    pQueuePriorities = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pQueuePriorities) {
        pQueuePriorities = new float[copy_src->queueCount];
        memcpy ((void *)pQueuePriorities, (void *)copy_src->pQueuePriorities, sizeof(float)*copy_src->queueCount);
    }
}

safe_VkDeviceCreateInfo::safe_VkDeviceCreateInfo(const VkDeviceCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    queueCreateInfoCount(in_struct->queueCreateInfoCount),
    pQueueCreateInfos(nullptr),
    enabledLayerCount(in_struct->enabledLayerCount),
    enabledExtensionCount(in_struct->enabledExtensionCount),
    pEnabledFeatures(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    char **tmp_ppEnabledLayerNames = new char *[in_struct->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(in_struct->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[in_struct->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(in_struct->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (queueCreateInfoCount && in_struct->pQueueCreateInfos) {
        pQueueCreateInfos = new safe_VkDeviceQueueCreateInfo[queueCreateInfoCount];
        for (uint32_t i = 0; i < queueCreateInfoCount; ++i) {
            pQueueCreateInfos[i].initialize(&in_struct->pQueueCreateInfos[i]);
        }
    }
    if (in_struct->pEnabledFeatures) {
        pEnabledFeatures = new VkPhysicalDeviceFeatures(*in_struct->pEnabledFeatures);
    }
}

safe_VkDeviceCreateInfo::safe_VkDeviceCreateInfo() :
    sType(VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO),
    pNext(nullptr),
    pQueueCreateInfos(nullptr),
    ppEnabledLayerNames(nullptr),
    ppEnabledExtensionNames(nullptr),
    pEnabledFeatures(nullptr)
{}

safe_VkDeviceCreateInfo::safe_VkDeviceCreateInfo(const safe_VkDeviceCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    queueCreateInfoCount = copy_src.queueCreateInfoCount;
    pQueueCreateInfos = nullptr;
    enabledLayerCount = copy_src.enabledLayerCount;
    enabledExtensionCount = copy_src.enabledExtensionCount;
    pEnabledFeatures = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    char **tmp_ppEnabledLayerNames = new char *[copy_src.enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(copy_src.ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[copy_src.enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(copy_src.ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (queueCreateInfoCount && copy_src.pQueueCreateInfos) {
        pQueueCreateInfos = new safe_VkDeviceQueueCreateInfo[queueCreateInfoCount];
        for (uint32_t i = 0; i < queueCreateInfoCount; ++i) {
            pQueueCreateInfos[i].initialize(&copy_src.pQueueCreateInfos[i]);
        }
    }
    if (copy_src.pEnabledFeatures) {
        pEnabledFeatures = new VkPhysicalDeviceFeatures(*copy_src.pEnabledFeatures);
    }
}

safe_VkDeviceCreateInfo& safe_VkDeviceCreateInfo::operator=(const safe_VkDeviceCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pQueueCreateInfos)
        delete[] pQueueCreateInfos;
    if (ppEnabledLayerNames) {
        for (uint32_t i = 0; i < enabledLayerCount; ++i) {
            delete [] ppEnabledLayerNames[i];
        }
        delete [] ppEnabledLayerNames;
    }
    if (ppEnabledExtensionNames) {
        for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
            delete [] ppEnabledExtensionNames[i];
        }
        delete [] ppEnabledExtensionNames;
    }
    if (pEnabledFeatures)
        delete pEnabledFeatures;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    queueCreateInfoCount = copy_src.queueCreateInfoCount;
    pQueueCreateInfos = nullptr;
    enabledLayerCount = copy_src.enabledLayerCount;
    enabledExtensionCount = copy_src.enabledExtensionCount;
    pEnabledFeatures = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    char **tmp_ppEnabledLayerNames = new char *[copy_src.enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(copy_src.ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[copy_src.enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(copy_src.ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (queueCreateInfoCount && copy_src.pQueueCreateInfos) {
        pQueueCreateInfos = new safe_VkDeviceQueueCreateInfo[queueCreateInfoCount];
        for (uint32_t i = 0; i < queueCreateInfoCount; ++i) {
            pQueueCreateInfos[i].initialize(&copy_src.pQueueCreateInfos[i]);
        }
    }
    if (copy_src.pEnabledFeatures) {
        pEnabledFeatures = new VkPhysicalDeviceFeatures(*copy_src.pEnabledFeatures);
    }

    return *this;
}

safe_VkDeviceCreateInfo::~safe_VkDeviceCreateInfo()
{
    if (pQueueCreateInfos)
        delete[] pQueueCreateInfos;
    if (ppEnabledLayerNames) {
        for (uint32_t i = 0; i < enabledLayerCount; ++i) {
            delete [] ppEnabledLayerNames[i];
        }
        delete [] ppEnabledLayerNames;
    }
    if (ppEnabledExtensionNames) {
        for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
            delete [] ppEnabledExtensionNames[i];
        }
        delete [] ppEnabledExtensionNames;
    }
    if (pEnabledFeatures)
        delete pEnabledFeatures;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceCreateInfo::initialize(const VkDeviceCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    queueCreateInfoCount = in_struct->queueCreateInfoCount;
    pQueueCreateInfos = nullptr;
    enabledLayerCount = in_struct->enabledLayerCount;
    enabledExtensionCount = in_struct->enabledExtensionCount;
    pEnabledFeatures = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    char **tmp_ppEnabledLayerNames = new char *[in_struct->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(in_struct->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[in_struct->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(in_struct->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (queueCreateInfoCount && in_struct->pQueueCreateInfos) {
        pQueueCreateInfos = new safe_VkDeviceQueueCreateInfo[queueCreateInfoCount];
        for (uint32_t i = 0; i < queueCreateInfoCount; ++i) {
            pQueueCreateInfos[i].initialize(&in_struct->pQueueCreateInfos[i]);
        }
    }
    if (in_struct->pEnabledFeatures) {
        pEnabledFeatures = new VkPhysicalDeviceFeatures(*in_struct->pEnabledFeatures);
    }
}

void safe_VkDeviceCreateInfo::initialize(const safe_VkDeviceCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    queueCreateInfoCount = copy_src->queueCreateInfoCount;
    pQueueCreateInfos = nullptr;
    enabledLayerCount = copy_src->enabledLayerCount;
    enabledExtensionCount = copy_src->enabledExtensionCount;
    pEnabledFeatures = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    char **tmp_ppEnabledLayerNames = new char *[copy_src->enabledLayerCount];
    for (uint32_t i = 0; i < enabledLayerCount; ++i) {
        tmp_ppEnabledLayerNames[i] = SafeStringCopy(copy_src->ppEnabledLayerNames[i]);
    }
    ppEnabledLayerNames = tmp_ppEnabledLayerNames;
    char **tmp_ppEnabledExtensionNames = new char *[copy_src->enabledExtensionCount];
    for (uint32_t i = 0; i < enabledExtensionCount; ++i) {
        tmp_ppEnabledExtensionNames[i] = SafeStringCopy(copy_src->ppEnabledExtensionNames[i]);
    }
    ppEnabledExtensionNames = tmp_ppEnabledExtensionNames;
    if (queueCreateInfoCount && copy_src->pQueueCreateInfos) {
        pQueueCreateInfos = new safe_VkDeviceQueueCreateInfo[queueCreateInfoCount];
        for (uint32_t i = 0; i < queueCreateInfoCount; ++i) {
            pQueueCreateInfos[i].initialize(&copy_src->pQueueCreateInfos[i]);
        }
    }
    if (copy_src->pEnabledFeatures) {
        pEnabledFeatures = new VkPhysicalDeviceFeatures(*copy_src->pEnabledFeatures);
    }
}

safe_VkSubmitInfo::safe_VkSubmitInfo(const VkSubmitInfo* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreCount(in_struct->waitSemaphoreCount),
    pWaitSemaphores(nullptr),
    pWaitDstStageMask(nullptr),
    commandBufferCount(in_struct->commandBufferCount),
    pCommandBuffers(nullptr),
    signalSemaphoreCount(in_struct->signalSemaphoreCount),
    pSignalSemaphores(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (in_struct->pWaitDstStageMask) {
        pWaitDstStageMask = new VkPipelineStageFlags[in_struct->waitSemaphoreCount];
        memcpy ((void *)pWaitDstStageMask, (void *)in_struct->pWaitDstStageMask, sizeof(VkPipelineStageFlags)*in_struct->waitSemaphoreCount);
    }
    if (in_struct->pCommandBuffers) {
        pCommandBuffers = new VkCommandBuffer[in_struct->commandBufferCount];
        memcpy ((void *)pCommandBuffers, (void *)in_struct->pCommandBuffers, sizeof(VkCommandBuffer)*in_struct->commandBufferCount);
    }
    if (signalSemaphoreCount && in_struct->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = in_struct->pSignalSemaphores[i];
        }
    }
}

safe_VkSubmitInfo::safe_VkSubmitInfo() :
    sType(VK_STRUCTURE_TYPE_SUBMIT_INFO),
    pNext(nullptr),
    pWaitSemaphores(nullptr),
    pWaitDstStageMask(nullptr),
    pCommandBuffers(nullptr),
    pSignalSemaphores(nullptr)
{}

safe_VkSubmitInfo::safe_VkSubmitInfo(const safe_VkSubmitInfo& copy_src)
{
    sType = copy_src.sType;
    waitSemaphoreCount = copy_src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    pWaitDstStageMask = nullptr;
    commandBufferCount = copy_src.commandBufferCount;
    pCommandBuffers = nullptr;
    signalSemaphoreCount = copy_src.signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (waitSemaphoreCount && copy_src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = copy_src.pWaitSemaphores[i];
        }
    }
    if (copy_src.pWaitDstStageMask) {
        pWaitDstStageMask = new VkPipelineStageFlags[copy_src.waitSemaphoreCount];
        memcpy ((void *)pWaitDstStageMask, (void *)copy_src.pWaitDstStageMask, sizeof(VkPipelineStageFlags)*copy_src.waitSemaphoreCount);
    }
    if (copy_src.pCommandBuffers) {
        pCommandBuffers = new VkCommandBuffer[copy_src.commandBufferCount];
        memcpy ((void *)pCommandBuffers, (void *)copy_src.pCommandBuffers, sizeof(VkCommandBuffer)*copy_src.commandBufferCount);
    }
    if (signalSemaphoreCount && copy_src.pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = copy_src.pSignalSemaphores[i];
        }
    }
}

safe_VkSubmitInfo& safe_VkSubmitInfo::operator=(const safe_VkSubmitInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pWaitDstStageMask)
        delete[] pWaitDstStageMask;
    if (pCommandBuffers)
        delete[] pCommandBuffers;
    if (pSignalSemaphores)
        delete[] pSignalSemaphores;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    waitSemaphoreCount = copy_src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    pWaitDstStageMask = nullptr;
    commandBufferCount = copy_src.commandBufferCount;
    pCommandBuffers = nullptr;
    signalSemaphoreCount = copy_src.signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (waitSemaphoreCount && copy_src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = copy_src.pWaitSemaphores[i];
        }
    }
    if (copy_src.pWaitDstStageMask) {
        pWaitDstStageMask = new VkPipelineStageFlags[copy_src.waitSemaphoreCount];
        memcpy ((void *)pWaitDstStageMask, (void *)copy_src.pWaitDstStageMask, sizeof(VkPipelineStageFlags)*copy_src.waitSemaphoreCount);
    }
    if (copy_src.pCommandBuffers) {
        pCommandBuffers = new VkCommandBuffer[copy_src.commandBufferCount];
        memcpy ((void *)pCommandBuffers, (void *)copy_src.pCommandBuffers, sizeof(VkCommandBuffer)*copy_src.commandBufferCount);
    }
    if (signalSemaphoreCount && copy_src.pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = copy_src.pSignalSemaphores[i];
        }
    }

    return *this;
}

safe_VkSubmitInfo::~safe_VkSubmitInfo()
{
    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pWaitDstStageMask)
        delete[] pWaitDstStageMask;
    if (pCommandBuffers)
        delete[] pCommandBuffers;
    if (pSignalSemaphores)
        delete[] pSignalSemaphores;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubmitInfo::initialize(const VkSubmitInfo* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreCount = in_struct->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    pWaitDstStageMask = nullptr;
    commandBufferCount = in_struct->commandBufferCount;
    pCommandBuffers = nullptr;
    signalSemaphoreCount = in_struct->signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (in_struct->pWaitDstStageMask) {
        pWaitDstStageMask = new VkPipelineStageFlags[in_struct->waitSemaphoreCount];
        memcpy ((void *)pWaitDstStageMask, (void *)in_struct->pWaitDstStageMask, sizeof(VkPipelineStageFlags)*in_struct->waitSemaphoreCount);
    }
    if (in_struct->pCommandBuffers) {
        pCommandBuffers = new VkCommandBuffer[in_struct->commandBufferCount];
        memcpy ((void *)pCommandBuffers, (void *)in_struct->pCommandBuffers, sizeof(VkCommandBuffer)*in_struct->commandBufferCount);
    }
    if (signalSemaphoreCount && in_struct->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = in_struct->pSignalSemaphores[i];
        }
    }
}

void safe_VkSubmitInfo::initialize(const safe_VkSubmitInfo* copy_src)
{
    sType = copy_src->sType;
    waitSemaphoreCount = copy_src->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    pWaitDstStageMask = nullptr;
    commandBufferCount = copy_src->commandBufferCount;
    pCommandBuffers = nullptr;
    signalSemaphoreCount = copy_src->signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (waitSemaphoreCount && copy_src->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = copy_src->pWaitSemaphores[i];
        }
    }
    if (copy_src->pWaitDstStageMask) {
        pWaitDstStageMask = new VkPipelineStageFlags[copy_src->waitSemaphoreCount];
        memcpy ((void *)pWaitDstStageMask, (void *)copy_src->pWaitDstStageMask, sizeof(VkPipelineStageFlags)*copy_src->waitSemaphoreCount);
    }
    if (copy_src->pCommandBuffers) {
        pCommandBuffers = new VkCommandBuffer[copy_src->commandBufferCount];
        memcpy ((void *)pCommandBuffers, (void *)copy_src->pCommandBuffers, sizeof(VkCommandBuffer)*copy_src->commandBufferCount);
    }
    if (signalSemaphoreCount && copy_src->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = copy_src->pSignalSemaphores[i];
        }
    }
}

safe_VkMappedMemoryRange::safe_VkMappedMemoryRange(const VkMappedMemoryRange* in_struct) :
    sType(in_struct->sType),
    memory(in_struct->memory),
    offset(in_struct->offset),
    size(in_struct->size)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMappedMemoryRange::safe_VkMappedMemoryRange() :
    sType(VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE),
    pNext(nullptr)
{}

safe_VkMappedMemoryRange::safe_VkMappedMemoryRange(const safe_VkMappedMemoryRange& copy_src)
{
    sType = copy_src.sType;
    memory = copy_src.memory;
    offset = copy_src.offset;
    size = copy_src.size;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMappedMemoryRange& safe_VkMappedMemoryRange::operator=(const safe_VkMappedMemoryRange& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    memory = copy_src.memory;
    offset = copy_src.offset;
    size = copy_src.size;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMappedMemoryRange::~safe_VkMappedMemoryRange()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMappedMemoryRange::initialize(const VkMappedMemoryRange* in_struct)
{
    sType = in_struct->sType;
    memory = in_struct->memory;
    offset = in_struct->offset;
    size = in_struct->size;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMappedMemoryRange::initialize(const safe_VkMappedMemoryRange* copy_src)
{
    sType = copy_src->sType;
    memory = copy_src->memory;
    offset = copy_src->offset;
    size = copy_src->size;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkMemoryAllocateInfo::safe_VkMemoryAllocateInfo(const VkMemoryAllocateInfo* in_struct) :
    sType(in_struct->sType),
    allocationSize(in_struct->allocationSize),
    memoryTypeIndex(in_struct->memoryTypeIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryAllocateInfo::safe_VkMemoryAllocateInfo() :
    sType(VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO),
    pNext(nullptr)
{}

safe_VkMemoryAllocateInfo::safe_VkMemoryAllocateInfo(const safe_VkMemoryAllocateInfo& copy_src)
{
    sType = copy_src.sType;
    allocationSize = copy_src.allocationSize;
    memoryTypeIndex = copy_src.memoryTypeIndex;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryAllocateInfo& safe_VkMemoryAllocateInfo::operator=(const safe_VkMemoryAllocateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    allocationSize = copy_src.allocationSize;
    memoryTypeIndex = copy_src.memoryTypeIndex;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryAllocateInfo::~safe_VkMemoryAllocateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryAllocateInfo::initialize(const VkMemoryAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    allocationSize = in_struct->allocationSize;
    memoryTypeIndex = in_struct->memoryTypeIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryAllocateInfo::initialize(const safe_VkMemoryAllocateInfo* copy_src)
{
    sType = copy_src->sType;
    allocationSize = copy_src->allocationSize;
    memoryTypeIndex = copy_src->memoryTypeIndex;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSparseBufferMemoryBindInfo::safe_VkSparseBufferMemoryBindInfo(const VkSparseBufferMemoryBindInfo* in_struct) :
    buffer(in_struct->buffer),
    bindCount(in_struct->bindCount),
    pBinds(nullptr)
{
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

safe_VkSparseBufferMemoryBindInfo::safe_VkSparseBufferMemoryBindInfo() :
    pBinds(nullptr)
{}

safe_VkSparseBufferMemoryBindInfo::safe_VkSparseBufferMemoryBindInfo(const safe_VkSparseBufferMemoryBindInfo& copy_src)
{
    buffer = copy_src.buffer;
    bindCount = copy_src.bindCount;
    pBinds = nullptr;
    if (bindCount && copy_src.pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = copy_src.pBinds[i];
        }
    }
}

safe_VkSparseBufferMemoryBindInfo& safe_VkSparseBufferMemoryBindInfo::operator=(const safe_VkSparseBufferMemoryBindInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pBinds)
        delete[] pBinds;

    buffer = copy_src.buffer;
    bindCount = copy_src.bindCount;
    pBinds = nullptr;
    if (bindCount && copy_src.pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = copy_src.pBinds[i];
        }
    }

    return *this;
}

safe_VkSparseBufferMemoryBindInfo::~safe_VkSparseBufferMemoryBindInfo()
{
    if (pBinds)
        delete[] pBinds;
}

void safe_VkSparseBufferMemoryBindInfo::initialize(const VkSparseBufferMemoryBindInfo* in_struct)
{
    buffer = in_struct->buffer;
    bindCount = in_struct->bindCount;
    pBinds = nullptr;
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

void safe_VkSparseBufferMemoryBindInfo::initialize(const safe_VkSparseBufferMemoryBindInfo* copy_src)
{
    buffer = copy_src->buffer;
    bindCount = copy_src->bindCount;
    pBinds = nullptr;
    if (bindCount && copy_src->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = copy_src->pBinds[i];
        }
    }
}

safe_VkSparseImageOpaqueMemoryBindInfo::safe_VkSparseImageOpaqueMemoryBindInfo(const VkSparseImageOpaqueMemoryBindInfo* in_struct) :
    image(in_struct->image),
    bindCount(in_struct->bindCount),
    pBinds(nullptr)
{
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

safe_VkSparseImageOpaqueMemoryBindInfo::safe_VkSparseImageOpaqueMemoryBindInfo() :
    pBinds(nullptr)
{}

safe_VkSparseImageOpaqueMemoryBindInfo::safe_VkSparseImageOpaqueMemoryBindInfo(const safe_VkSparseImageOpaqueMemoryBindInfo& copy_src)
{
    image = copy_src.image;
    bindCount = copy_src.bindCount;
    pBinds = nullptr;
    if (bindCount && copy_src.pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = copy_src.pBinds[i];
        }
    }
}

safe_VkSparseImageOpaqueMemoryBindInfo& safe_VkSparseImageOpaqueMemoryBindInfo::operator=(const safe_VkSparseImageOpaqueMemoryBindInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pBinds)
        delete[] pBinds;

    image = copy_src.image;
    bindCount = copy_src.bindCount;
    pBinds = nullptr;
    if (bindCount && copy_src.pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = copy_src.pBinds[i];
        }
    }

    return *this;
}

safe_VkSparseImageOpaqueMemoryBindInfo::~safe_VkSparseImageOpaqueMemoryBindInfo()
{
    if (pBinds)
        delete[] pBinds;
}

void safe_VkSparseImageOpaqueMemoryBindInfo::initialize(const VkSparseImageOpaqueMemoryBindInfo* in_struct)
{
    image = in_struct->image;
    bindCount = in_struct->bindCount;
    pBinds = nullptr;
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

void safe_VkSparseImageOpaqueMemoryBindInfo::initialize(const safe_VkSparseImageOpaqueMemoryBindInfo* copy_src)
{
    image = copy_src->image;
    bindCount = copy_src->bindCount;
    pBinds = nullptr;
    if (bindCount && copy_src->pBinds) {
        pBinds = new VkSparseMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = copy_src->pBinds[i];
        }
    }
}

safe_VkSparseImageMemoryBindInfo::safe_VkSparseImageMemoryBindInfo(const VkSparseImageMemoryBindInfo* in_struct) :
    image(in_struct->image),
    bindCount(in_struct->bindCount),
    pBinds(nullptr)
{
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseImageMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

safe_VkSparseImageMemoryBindInfo::safe_VkSparseImageMemoryBindInfo() :
    pBinds(nullptr)
{}

safe_VkSparseImageMemoryBindInfo::safe_VkSparseImageMemoryBindInfo(const safe_VkSparseImageMemoryBindInfo& copy_src)
{
    image = copy_src.image;
    bindCount = copy_src.bindCount;
    pBinds = nullptr;
    if (bindCount && copy_src.pBinds) {
        pBinds = new VkSparseImageMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = copy_src.pBinds[i];
        }
    }
}

safe_VkSparseImageMemoryBindInfo& safe_VkSparseImageMemoryBindInfo::operator=(const safe_VkSparseImageMemoryBindInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pBinds)
        delete[] pBinds;

    image = copy_src.image;
    bindCount = copy_src.bindCount;
    pBinds = nullptr;
    if (bindCount && copy_src.pBinds) {
        pBinds = new VkSparseImageMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = copy_src.pBinds[i];
        }
    }

    return *this;
}

safe_VkSparseImageMemoryBindInfo::~safe_VkSparseImageMemoryBindInfo()
{
    if (pBinds)
        delete[] pBinds;
}

void safe_VkSparseImageMemoryBindInfo::initialize(const VkSparseImageMemoryBindInfo* in_struct)
{
    image = in_struct->image;
    bindCount = in_struct->bindCount;
    pBinds = nullptr;
    if (bindCount && in_struct->pBinds) {
        pBinds = new VkSparseImageMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = in_struct->pBinds[i];
        }
    }
}

void safe_VkSparseImageMemoryBindInfo::initialize(const safe_VkSparseImageMemoryBindInfo* copy_src)
{
    image = copy_src->image;
    bindCount = copy_src->bindCount;
    pBinds = nullptr;
    if (bindCount && copy_src->pBinds) {
        pBinds = new VkSparseImageMemoryBind[bindCount];
        for (uint32_t i = 0; i < bindCount; ++i) {
            pBinds[i] = copy_src->pBinds[i];
        }
    }
}

safe_VkBindSparseInfo::safe_VkBindSparseInfo(const VkBindSparseInfo* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreCount(in_struct->waitSemaphoreCount),
    pWaitSemaphores(nullptr),
    bufferBindCount(in_struct->bufferBindCount),
    pBufferBinds(nullptr),
    imageOpaqueBindCount(in_struct->imageOpaqueBindCount),
    pImageOpaqueBinds(nullptr),
    imageBindCount(in_struct->imageBindCount),
    pImageBinds(nullptr),
    signalSemaphoreCount(in_struct->signalSemaphoreCount),
    pSignalSemaphores(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (bufferBindCount && in_struct->pBufferBinds) {
        pBufferBinds = new safe_VkSparseBufferMemoryBindInfo[bufferBindCount];
        for (uint32_t i = 0; i < bufferBindCount; ++i) {
            pBufferBinds[i].initialize(&in_struct->pBufferBinds[i]);
        }
    }
    if (imageOpaqueBindCount && in_struct->pImageOpaqueBinds) {
        pImageOpaqueBinds = new safe_VkSparseImageOpaqueMemoryBindInfo[imageOpaqueBindCount];
        for (uint32_t i = 0; i < imageOpaqueBindCount; ++i) {
            pImageOpaqueBinds[i].initialize(&in_struct->pImageOpaqueBinds[i]);
        }
    }
    if (imageBindCount && in_struct->pImageBinds) {
        pImageBinds = new safe_VkSparseImageMemoryBindInfo[imageBindCount];
        for (uint32_t i = 0; i < imageBindCount; ++i) {
            pImageBinds[i].initialize(&in_struct->pImageBinds[i]);
        }
    }
    if (signalSemaphoreCount && in_struct->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = in_struct->pSignalSemaphores[i];
        }
    }
}

safe_VkBindSparseInfo::safe_VkBindSparseInfo() :
    sType(VK_STRUCTURE_TYPE_BIND_SPARSE_INFO),
    pNext(nullptr),
    pWaitSemaphores(nullptr),
    pBufferBinds(nullptr),
    pImageOpaqueBinds(nullptr),
    pImageBinds(nullptr),
    pSignalSemaphores(nullptr)
{}

safe_VkBindSparseInfo::safe_VkBindSparseInfo(const safe_VkBindSparseInfo& copy_src)
{
    sType = copy_src.sType;
    waitSemaphoreCount = copy_src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    bufferBindCount = copy_src.bufferBindCount;
    pBufferBinds = nullptr;
    imageOpaqueBindCount = copy_src.imageOpaqueBindCount;
    pImageOpaqueBinds = nullptr;
    imageBindCount = copy_src.imageBindCount;
    pImageBinds = nullptr;
    signalSemaphoreCount = copy_src.signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (waitSemaphoreCount && copy_src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = copy_src.pWaitSemaphores[i];
        }
    }
    if (bufferBindCount && copy_src.pBufferBinds) {
        pBufferBinds = new safe_VkSparseBufferMemoryBindInfo[bufferBindCount];
        for (uint32_t i = 0; i < bufferBindCount; ++i) {
            pBufferBinds[i].initialize(&copy_src.pBufferBinds[i]);
        }
    }
    if (imageOpaqueBindCount && copy_src.pImageOpaqueBinds) {
        pImageOpaqueBinds = new safe_VkSparseImageOpaqueMemoryBindInfo[imageOpaqueBindCount];
        for (uint32_t i = 0; i < imageOpaqueBindCount; ++i) {
            pImageOpaqueBinds[i].initialize(&copy_src.pImageOpaqueBinds[i]);
        }
    }
    if (imageBindCount && copy_src.pImageBinds) {
        pImageBinds = new safe_VkSparseImageMemoryBindInfo[imageBindCount];
        for (uint32_t i = 0; i < imageBindCount; ++i) {
            pImageBinds[i].initialize(&copy_src.pImageBinds[i]);
        }
    }
    if (signalSemaphoreCount && copy_src.pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = copy_src.pSignalSemaphores[i];
        }
    }
}

safe_VkBindSparseInfo& safe_VkBindSparseInfo::operator=(const safe_VkBindSparseInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pBufferBinds)
        delete[] pBufferBinds;
    if (pImageOpaqueBinds)
        delete[] pImageOpaqueBinds;
    if (pImageBinds)
        delete[] pImageBinds;
    if (pSignalSemaphores)
        delete[] pSignalSemaphores;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    waitSemaphoreCount = copy_src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    bufferBindCount = copy_src.bufferBindCount;
    pBufferBinds = nullptr;
    imageOpaqueBindCount = copy_src.imageOpaqueBindCount;
    pImageOpaqueBinds = nullptr;
    imageBindCount = copy_src.imageBindCount;
    pImageBinds = nullptr;
    signalSemaphoreCount = copy_src.signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (waitSemaphoreCount && copy_src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = copy_src.pWaitSemaphores[i];
        }
    }
    if (bufferBindCount && copy_src.pBufferBinds) {
        pBufferBinds = new safe_VkSparseBufferMemoryBindInfo[bufferBindCount];
        for (uint32_t i = 0; i < bufferBindCount; ++i) {
            pBufferBinds[i].initialize(&copy_src.pBufferBinds[i]);
        }
    }
    if (imageOpaqueBindCount && copy_src.pImageOpaqueBinds) {
        pImageOpaqueBinds = new safe_VkSparseImageOpaqueMemoryBindInfo[imageOpaqueBindCount];
        for (uint32_t i = 0; i < imageOpaqueBindCount; ++i) {
            pImageOpaqueBinds[i].initialize(&copy_src.pImageOpaqueBinds[i]);
        }
    }
    if (imageBindCount && copy_src.pImageBinds) {
        pImageBinds = new safe_VkSparseImageMemoryBindInfo[imageBindCount];
        for (uint32_t i = 0; i < imageBindCount; ++i) {
            pImageBinds[i].initialize(&copy_src.pImageBinds[i]);
        }
    }
    if (signalSemaphoreCount && copy_src.pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = copy_src.pSignalSemaphores[i];
        }
    }

    return *this;
}

safe_VkBindSparseInfo::~safe_VkBindSparseInfo()
{
    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pBufferBinds)
        delete[] pBufferBinds;
    if (pImageOpaqueBinds)
        delete[] pImageOpaqueBinds;
    if (pImageBinds)
        delete[] pImageBinds;
    if (pSignalSemaphores)
        delete[] pSignalSemaphores;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindSparseInfo::initialize(const VkBindSparseInfo* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreCount = in_struct->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    bufferBindCount = in_struct->bufferBindCount;
    pBufferBinds = nullptr;
    imageOpaqueBindCount = in_struct->imageOpaqueBindCount;
    pImageOpaqueBinds = nullptr;
    imageBindCount = in_struct->imageBindCount;
    pImageBinds = nullptr;
    signalSemaphoreCount = in_struct->signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (bufferBindCount && in_struct->pBufferBinds) {
        pBufferBinds = new safe_VkSparseBufferMemoryBindInfo[bufferBindCount];
        for (uint32_t i = 0; i < bufferBindCount; ++i) {
            pBufferBinds[i].initialize(&in_struct->pBufferBinds[i]);
        }
    }
    if (imageOpaqueBindCount && in_struct->pImageOpaqueBinds) {
        pImageOpaqueBinds = new safe_VkSparseImageOpaqueMemoryBindInfo[imageOpaqueBindCount];
        for (uint32_t i = 0; i < imageOpaqueBindCount; ++i) {
            pImageOpaqueBinds[i].initialize(&in_struct->pImageOpaqueBinds[i]);
        }
    }
    if (imageBindCount && in_struct->pImageBinds) {
        pImageBinds = new safe_VkSparseImageMemoryBindInfo[imageBindCount];
        for (uint32_t i = 0; i < imageBindCount; ++i) {
            pImageBinds[i].initialize(&in_struct->pImageBinds[i]);
        }
    }
    if (signalSemaphoreCount && in_struct->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = in_struct->pSignalSemaphores[i];
        }
    }
}

void safe_VkBindSparseInfo::initialize(const safe_VkBindSparseInfo* copy_src)
{
    sType = copy_src->sType;
    waitSemaphoreCount = copy_src->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    bufferBindCount = copy_src->bufferBindCount;
    pBufferBinds = nullptr;
    imageOpaqueBindCount = copy_src->imageOpaqueBindCount;
    pImageOpaqueBinds = nullptr;
    imageBindCount = copy_src->imageBindCount;
    pImageBinds = nullptr;
    signalSemaphoreCount = copy_src->signalSemaphoreCount;
    pSignalSemaphores = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (waitSemaphoreCount && copy_src->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = copy_src->pWaitSemaphores[i];
        }
    }
    if (bufferBindCount && copy_src->pBufferBinds) {
        pBufferBinds = new safe_VkSparseBufferMemoryBindInfo[bufferBindCount];
        for (uint32_t i = 0; i < bufferBindCount; ++i) {
            pBufferBinds[i].initialize(&copy_src->pBufferBinds[i]);
        }
    }
    if (imageOpaqueBindCount && copy_src->pImageOpaqueBinds) {
        pImageOpaqueBinds = new safe_VkSparseImageOpaqueMemoryBindInfo[imageOpaqueBindCount];
        for (uint32_t i = 0; i < imageOpaqueBindCount; ++i) {
            pImageOpaqueBinds[i].initialize(&copy_src->pImageOpaqueBinds[i]);
        }
    }
    if (imageBindCount && copy_src->pImageBinds) {
        pImageBinds = new safe_VkSparseImageMemoryBindInfo[imageBindCount];
        for (uint32_t i = 0; i < imageBindCount; ++i) {
            pImageBinds[i].initialize(&copy_src->pImageBinds[i]);
        }
    }
    if (signalSemaphoreCount && copy_src->pSignalSemaphores) {
        pSignalSemaphores = new VkSemaphore[signalSemaphoreCount];
        for (uint32_t i = 0; i < signalSemaphoreCount; ++i) {
            pSignalSemaphores[i] = copy_src->pSignalSemaphores[i];
        }
    }
}

safe_VkFenceCreateInfo::safe_VkFenceCreateInfo(const VkFenceCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkFenceCreateInfo::safe_VkFenceCreateInfo() :
    sType(VK_STRUCTURE_TYPE_FENCE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkFenceCreateInfo::safe_VkFenceCreateInfo(const safe_VkFenceCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkFenceCreateInfo& safe_VkFenceCreateInfo::operator=(const safe_VkFenceCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkFenceCreateInfo::~safe_VkFenceCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFenceCreateInfo::initialize(const VkFenceCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkFenceCreateInfo::initialize(const safe_VkFenceCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSemaphoreCreateInfo::safe_VkSemaphoreCreateInfo(const VkSemaphoreCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSemaphoreCreateInfo::safe_VkSemaphoreCreateInfo() :
    sType(VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkSemaphoreCreateInfo::safe_VkSemaphoreCreateInfo(const safe_VkSemaphoreCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSemaphoreCreateInfo& safe_VkSemaphoreCreateInfo::operator=(const safe_VkSemaphoreCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSemaphoreCreateInfo::~safe_VkSemaphoreCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreCreateInfo::initialize(const VkSemaphoreCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSemaphoreCreateInfo::initialize(const safe_VkSemaphoreCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkEventCreateInfo::safe_VkEventCreateInfo(const VkEventCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkEventCreateInfo::safe_VkEventCreateInfo() :
    sType(VK_STRUCTURE_TYPE_EVENT_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkEventCreateInfo::safe_VkEventCreateInfo(const safe_VkEventCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkEventCreateInfo& safe_VkEventCreateInfo::operator=(const safe_VkEventCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkEventCreateInfo::~safe_VkEventCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkEventCreateInfo::initialize(const VkEventCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkEventCreateInfo::initialize(const safe_VkEventCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkQueryPoolCreateInfo::safe_VkQueryPoolCreateInfo(const VkQueryPoolCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    queryType(in_struct->queryType),
    queryCount(in_struct->queryCount),
    pipelineStatistics(in_struct->pipelineStatistics)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkQueryPoolCreateInfo::safe_VkQueryPoolCreateInfo() :
    sType(VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkQueryPoolCreateInfo::safe_VkQueryPoolCreateInfo(const safe_VkQueryPoolCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    queryType = copy_src.queryType;
    queryCount = copy_src.queryCount;
    pipelineStatistics = copy_src.pipelineStatistics;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkQueryPoolCreateInfo& safe_VkQueryPoolCreateInfo::operator=(const safe_VkQueryPoolCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    queryType = copy_src.queryType;
    queryCount = copy_src.queryCount;
    pipelineStatistics = copy_src.pipelineStatistics;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkQueryPoolCreateInfo::~safe_VkQueryPoolCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkQueryPoolCreateInfo::initialize(const VkQueryPoolCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    queryType = in_struct->queryType;
    queryCount = in_struct->queryCount;
    pipelineStatistics = in_struct->pipelineStatistics;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkQueryPoolCreateInfo::initialize(const safe_VkQueryPoolCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    queryType = copy_src->queryType;
    queryCount = copy_src->queryCount;
    pipelineStatistics = copy_src->pipelineStatistics;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkBufferCreateInfo::safe_VkBufferCreateInfo(const VkBufferCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    size(in_struct->size),
    usage(in_struct->usage),
    sharingMode(in_struct->sharingMode),
    queueFamilyIndexCount(in_struct->queueFamilyIndexCount),
    pQueueFamilyIndices(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if ((in_struct->sharingMode == VK_SHARING_MODE_CONCURRENT) && in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

safe_VkBufferCreateInfo::safe_VkBufferCreateInfo() :
    sType(VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO),
    pNext(nullptr),
    pQueueFamilyIndices(nullptr)
{}

safe_VkBufferCreateInfo::safe_VkBufferCreateInfo(const safe_VkBufferCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    size = copy_src.size;
    usage = copy_src.usage;
    sharingMode = copy_src.sharingMode;
    queueFamilyIndexCount = copy_src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if ((copy_src.sharingMode == VK_SHARING_MODE_CONCURRENT) && copy_src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[copy_src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)copy_src.pQueueFamilyIndices, sizeof(uint32_t)*copy_src.queueFamilyIndexCount);
    }
}

safe_VkBufferCreateInfo& safe_VkBufferCreateInfo::operator=(const safe_VkBufferCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    size = copy_src.size;
    usage = copy_src.usage;
    sharingMode = copy_src.sharingMode;
    queueFamilyIndexCount = copy_src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if ((copy_src.sharingMode == VK_SHARING_MODE_CONCURRENT) && copy_src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[copy_src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)copy_src.pQueueFamilyIndices, sizeof(uint32_t)*copy_src.queueFamilyIndexCount);
    }

    return *this;
}

safe_VkBufferCreateInfo::~safe_VkBufferCreateInfo()
{
    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferCreateInfo::initialize(const VkBufferCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    size = in_struct->size;
    usage = in_struct->usage;
    sharingMode = in_struct->sharingMode;
    queueFamilyIndexCount = in_struct->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if ((in_struct->sharingMode == VK_SHARING_MODE_CONCURRENT) && in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

void safe_VkBufferCreateInfo::initialize(const safe_VkBufferCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    size = copy_src->size;
    usage = copy_src->usage;
    sharingMode = copy_src->sharingMode;
    queueFamilyIndexCount = copy_src->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if ((copy_src->sharingMode == VK_SHARING_MODE_CONCURRENT) && copy_src->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[copy_src->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)copy_src->pQueueFamilyIndices, sizeof(uint32_t)*copy_src->queueFamilyIndexCount);
    }
}

safe_VkBufferViewCreateInfo::safe_VkBufferViewCreateInfo(const VkBufferViewCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    buffer(in_struct->buffer),
    format(in_struct->format),
    offset(in_struct->offset),
    range(in_struct->range)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferViewCreateInfo::safe_VkBufferViewCreateInfo() :
    sType(VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkBufferViewCreateInfo::safe_VkBufferViewCreateInfo(const safe_VkBufferViewCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    buffer = copy_src.buffer;
    format = copy_src.format;
    offset = copy_src.offset;
    range = copy_src.range;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBufferViewCreateInfo& safe_VkBufferViewCreateInfo::operator=(const safe_VkBufferViewCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    buffer = copy_src.buffer;
    format = copy_src.format;
    offset = copy_src.offset;
    range = copy_src.range;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBufferViewCreateInfo::~safe_VkBufferViewCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferViewCreateInfo::initialize(const VkBufferViewCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    buffer = in_struct->buffer;
    format = in_struct->format;
    offset = in_struct->offset;
    range = in_struct->range;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferViewCreateInfo::initialize(const safe_VkBufferViewCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    buffer = copy_src->buffer;
    format = copy_src->format;
    offset = copy_src->offset;
    range = copy_src->range;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkImageCreateInfo::safe_VkImageCreateInfo(const VkImageCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    imageType(in_struct->imageType),
    format(in_struct->format),
    extent(in_struct->extent),
    mipLevels(in_struct->mipLevels),
    arrayLayers(in_struct->arrayLayers),
    samples(in_struct->samples),
    tiling(in_struct->tiling),
    usage(in_struct->usage),
    sharingMode(in_struct->sharingMode),
    queueFamilyIndexCount(in_struct->queueFamilyIndexCount),
    pQueueFamilyIndices(nullptr),
    initialLayout(in_struct->initialLayout)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if ((in_struct->sharingMode == VK_SHARING_MODE_CONCURRENT) && in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

safe_VkImageCreateInfo::safe_VkImageCreateInfo() :
    sType(VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO),
    pNext(nullptr),
    pQueueFamilyIndices(nullptr)
{}

safe_VkImageCreateInfo::safe_VkImageCreateInfo(const safe_VkImageCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    imageType = copy_src.imageType;
    format = copy_src.format;
    extent = copy_src.extent;
    mipLevels = copy_src.mipLevels;
    arrayLayers = copy_src.arrayLayers;
    samples = copy_src.samples;
    tiling = copy_src.tiling;
    usage = copy_src.usage;
    sharingMode = copy_src.sharingMode;
    queueFamilyIndexCount = copy_src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    initialLayout = copy_src.initialLayout;
    pNext = SafePnextCopy(copy_src.pNext);
    if ((copy_src.sharingMode == VK_SHARING_MODE_CONCURRENT) && copy_src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[copy_src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)copy_src.pQueueFamilyIndices, sizeof(uint32_t)*copy_src.queueFamilyIndexCount);
    }
}

safe_VkImageCreateInfo& safe_VkImageCreateInfo::operator=(const safe_VkImageCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    imageType = copy_src.imageType;
    format = copy_src.format;
    extent = copy_src.extent;
    mipLevels = copy_src.mipLevels;
    arrayLayers = copy_src.arrayLayers;
    samples = copy_src.samples;
    tiling = copy_src.tiling;
    usage = copy_src.usage;
    sharingMode = copy_src.sharingMode;
    queueFamilyIndexCount = copy_src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    initialLayout = copy_src.initialLayout;
    pNext = SafePnextCopy(copy_src.pNext);
    if ((copy_src.sharingMode == VK_SHARING_MODE_CONCURRENT) && copy_src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[copy_src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)copy_src.pQueueFamilyIndices, sizeof(uint32_t)*copy_src.queueFamilyIndexCount);
    }

    return *this;
}

safe_VkImageCreateInfo::~safe_VkImageCreateInfo()
{
    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageCreateInfo::initialize(const VkImageCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    imageType = in_struct->imageType;
    format = in_struct->format;
    extent = in_struct->extent;
    mipLevels = in_struct->mipLevels;
    arrayLayers = in_struct->arrayLayers;
    samples = in_struct->samples;
    tiling = in_struct->tiling;
    usage = in_struct->usage;
    sharingMode = in_struct->sharingMode;
    queueFamilyIndexCount = in_struct->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    initialLayout = in_struct->initialLayout;
    pNext = SafePnextCopy(in_struct->pNext);
    if ((in_struct->sharingMode == VK_SHARING_MODE_CONCURRENT) && in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

void safe_VkImageCreateInfo::initialize(const safe_VkImageCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    imageType = copy_src->imageType;
    format = copy_src->format;
    extent = copy_src->extent;
    mipLevels = copy_src->mipLevels;
    arrayLayers = copy_src->arrayLayers;
    samples = copy_src->samples;
    tiling = copy_src->tiling;
    usage = copy_src->usage;
    sharingMode = copy_src->sharingMode;
    queueFamilyIndexCount = copy_src->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    initialLayout = copy_src->initialLayout;
    pNext = SafePnextCopy(copy_src->pNext);
    if ((copy_src->sharingMode == VK_SHARING_MODE_CONCURRENT) && copy_src->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[copy_src->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)copy_src->pQueueFamilyIndices, sizeof(uint32_t)*copy_src->queueFamilyIndexCount);
    }
}

safe_VkImageViewCreateInfo::safe_VkImageViewCreateInfo(const VkImageViewCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    image(in_struct->image),
    viewType(in_struct->viewType),
    format(in_struct->format),
    components(in_struct->components),
    subresourceRange(in_struct->subresourceRange)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageViewCreateInfo::safe_VkImageViewCreateInfo() :
    sType(VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkImageViewCreateInfo::safe_VkImageViewCreateInfo(const safe_VkImageViewCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    image = copy_src.image;
    viewType = copy_src.viewType;
    format = copy_src.format;
    components = copy_src.components;
    subresourceRange = copy_src.subresourceRange;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageViewCreateInfo& safe_VkImageViewCreateInfo::operator=(const safe_VkImageViewCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    image = copy_src.image;
    viewType = copy_src.viewType;
    format = copy_src.format;
    components = copy_src.components;
    subresourceRange = copy_src.subresourceRange;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageViewCreateInfo::~safe_VkImageViewCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageViewCreateInfo::initialize(const VkImageViewCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    image = in_struct->image;
    viewType = in_struct->viewType;
    format = in_struct->format;
    components = in_struct->components;
    subresourceRange = in_struct->subresourceRange;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageViewCreateInfo::initialize(const safe_VkImageViewCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    image = copy_src->image;
    viewType = copy_src->viewType;
    format = copy_src->format;
    components = copy_src->components;
    subresourceRange = copy_src->subresourceRange;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkShaderModuleCreateInfo::safe_VkShaderModuleCreateInfo(const VkShaderModuleCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    codeSize(in_struct->codeSize),
    pCode(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pCode) {
        pCode = reinterpret_cast<uint32_t *>(new uint8_t[codeSize]);
        memcpy((void *)pCode, (void *)in_struct->pCode, codeSize);
    }
}

safe_VkShaderModuleCreateInfo::safe_VkShaderModuleCreateInfo() :
    sType(VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO),
    pNext(nullptr),
    pCode(nullptr)
{}

safe_VkShaderModuleCreateInfo::safe_VkShaderModuleCreateInfo(const safe_VkShaderModuleCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    codeSize = copy_src.codeSize;
    pCode = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pCode) {
        pCode = reinterpret_cast<uint32_t *>(new uint8_t[codeSize]);
        memcpy((void *)pCode, (void *)copy_src.pCode, codeSize);
    }
}

safe_VkShaderModuleCreateInfo& safe_VkShaderModuleCreateInfo::operator=(const safe_VkShaderModuleCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pCode)
        delete[] reinterpret_cast<const uint8_t *>(pCode);
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    codeSize = copy_src.codeSize;
    pCode = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pCode) {
        pCode = reinterpret_cast<uint32_t *>(new uint8_t[codeSize]);
        memcpy((void *)pCode, (void *)copy_src.pCode, codeSize);
    }

    return *this;
}

safe_VkShaderModuleCreateInfo::~safe_VkShaderModuleCreateInfo()
{
    if (pCode)
        delete[] reinterpret_cast<const uint8_t *>(pCode);
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkShaderModuleCreateInfo::initialize(const VkShaderModuleCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    codeSize = in_struct->codeSize;
    pCode = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pCode) {
        pCode = reinterpret_cast<uint32_t *>(new uint8_t[codeSize]);
        memcpy((void *)pCode, (void *)in_struct->pCode, codeSize);
    }
}

void safe_VkShaderModuleCreateInfo::initialize(const safe_VkShaderModuleCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    codeSize = copy_src->codeSize;
    pCode = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pCode) {
        pCode = reinterpret_cast<uint32_t *>(new uint8_t[codeSize]);
        memcpy((void *)pCode, (void *)copy_src->pCode, codeSize);
    }
}

safe_VkPipelineCacheCreateInfo::safe_VkPipelineCacheCreateInfo(const VkPipelineCacheCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    initialDataSize(in_struct->initialDataSize),
    pInitialData(in_struct->pInitialData)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineCacheCreateInfo::safe_VkPipelineCacheCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO),
    pNext(nullptr),
    pInitialData(nullptr)
{}

safe_VkPipelineCacheCreateInfo::safe_VkPipelineCacheCreateInfo(const safe_VkPipelineCacheCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    initialDataSize = copy_src.initialDataSize;
    pInitialData = copy_src.pInitialData;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPipelineCacheCreateInfo& safe_VkPipelineCacheCreateInfo::operator=(const safe_VkPipelineCacheCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    initialDataSize = copy_src.initialDataSize;
    pInitialData = copy_src.pInitialData;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPipelineCacheCreateInfo::~safe_VkPipelineCacheCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineCacheCreateInfo::initialize(const VkPipelineCacheCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    initialDataSize = in_struct->initialDataSize;
    pInitialData = in_struct->pInitialData;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineCacheCreateInfo::initialize(const safe_VkPipelineCacheCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    initialDataSize = copy_src->initialDataSize;
    pInitialData = copy_src->pInitialData;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSpecializationInfo::safe_VkSpecializationInfo(const VkSpecializationInfo* in_struct) :
    mapEntryCount(in_struct->mapEntryCount),
    pMapEntries(nullptr),
    dataSize(in_struct->dataSize),
    pData(in_struct->pData)
{
    if (in_struct->pMapEntries) {
        pMapEntries = new VkSpecializationMapEntry[in_struct->mapEntryCount];
        memcpy ((void *)pMapEntries, (void *)in_struct->pMapEntries, sizeof(VkSpecializationMapEntry)*in_struct->mapEntryCount);
    }
}

safe_VkSpecializationInfo::safe_VkSpecializationInfo() :
    pMapEntries(nullptr),
    pData(nullptr)
{}

safe_VkSpecializationInfo::safe_VkSpecializationInfo(const safe_VkSpecializationInfo& copy_src)
{
    mapEntryCount = copy_src.mapEntryCount;
    pMapEntries = nullptr;
    dataSize = copy_src.dataSize;
    pData = copy_src.pData;
    if (copy_src.pMapEntries) {
        pMapEntries = new VkSpecializationMapEntry[copy_src.mapEntryCount];
        memcpy ((void *)pMapEntries, (void *)copy_src.pMapEntries, sizeof(VkSpecializationMapEntry)*copy_src.mapEntryCount);
    }
}

safe_VkSpecializationInfo& safe_VkSpecializationInfo::operator=(const safe_VkSpecializationInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pMapEntries)
        delete[] pMapEntries;

    mapEntryCount = copy_src.mapEntryCount;
    pMapEntries = nullptr;
    dataSize = copy_src.dataSize;
    pData = copy_src.pData;
    if (copy_src.pMapEntries) {
        pMapEntries = new VkSpecializationMapEntry[copy_src.mapEntryCount];
        memcpy ((void *)pMapEntries, (void *)copy_src.pMapEntries, sizeof(VkSpecializationMapEntry)*copy_src.mapEntryCount);
    }

    return *this;
}

safe_VkSpecializationInfo::~safe_VkSpecializationInfo()
{
    if (pMapEntries)
        delete[] pMapEntries;
}

void safe_VkSpecializationInfo::initialize(const VkSpecializationInfo* in_struct)
{
    mapEntryCount = in_struct->mapEntryCount;
    pMapEntries = nullptr;
    dataSize = in_struct->dataSize;
    pData = in_struct->pData;
    if (in_struct->pMapEntries) {
        pMapEntries = new VkSpecializationMapEntry[in_struct->mapEntryCount];
        memcpy ((void *)pMapEntries, (void *)in_struct->pMapEntries, sizeof(VkSpecializationMapEntry)*in_struct->mapEntryCount);
    }
}

void safe_VkSpecializationInfo::initialize(const safe_VkSpecializationInfo* copy_src)
{
    mapEntryCount = copy_src->mapEntryCount;
    pMapEntries = nullptr;
    dataSize = copy_src->dataSize;
    pData = copy_src->pData;
    if (copy_src->pMapEntries) {
        pMapEntries = new VkSpecializationMapEntry[copy_src->mapEntryCount];
        memcpy ((void *)pMapEntries, (void *)copy_src->pMapEntries, sizeof(VkSpecializationMapEntry)*copy_src->mapEntryCount);
    }
}

safe_VkPipelineShaderStageCreateInfo::safe_VkPipelineShaderStageCreateInfo(const VkPipelineShaderStageCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    stage(in_struct->stage),
    module(in_struct->module),
    pSpecializationInfo(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pName = SafeStringCopy(in_struct->pName);
    if (in_struct->pSpecializationInfo)
        pSpecializationInfo = new safe_VkSpecializationInfo(in_struct->pSpecializationInfo);
}

safe_VkPipelineShaderStageCreateInfo::safe_VkPipelineShaderStageCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO),
    pNext(nullptr),
    pName(nullptr),
    pSpecializationInfo(nullptr)
{}

safe_VkPipelineShaderStageCreateInfo::safe_VkPipelineShaderStageCreateInfo(const safe_VkPipelineShaderStageCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    stage = copy_src.stage;
    module = copy_src.module;
    pSpecializationInfo = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    pName = SafeStringCopy(copy_src.pName);
    if (copy_src.pSpecializationInfo)
        pSpecializationInfo = new safe_VkSpecializationInfo(*copy_src.pSpecializationInfo);
}

safe_VkPipelineShaderStageCreateInfo& safe_VkPipelineShaderStageCreateInfo::operator=(const safe_VkPipelineShaderStageCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pName) delete [] pName;
    if (pSpecializationInfo)
        delete pSpecializationInfo;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    stage = copy_src.stage;
    module = copy_src.module;
    pSpecializationInfo = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    pName = SafeStringCopy(copy_src.pName);
    if (copy_src.pSpecializationInfo)
        pSpecializationInfo = new safe_VkSpecializationInfo(*copy_src.pSpecializationInfo);

    return *this;
}

safe_VkPipelineShaderStageCreateInfo::~safe_VkPipelineShaderStageCreateInfo()
{
    if (pName) delete [] pName;
    if (pSpecializationInfo)
        delete pSpecializationInfo;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineShaderStageCreateInfo::initialize(const VkPipelineShaderStageCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    stage = in_struct->stage;
    module = in_struct->module;
    pSpecializationInfo = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    pName = SafeStringCopy(in_struct->pName);
    if (in_struct->pSpecializationInfo)
        pSpecializationInfo = new safe_VkSpecializationInfo(in_struct->pSpecializationInfo);
}

void safe_VkPipelineShaderStageCreateInfo::initialize(const safe_VkPipelineShaderStageCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    stage = copy_src->stage;
    module = copy_src->module;
    pSpecializationInfo = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    pName = SafeStringCopy(copy_src->pName);
    if (copy_src->pSpecializationInfo)
        pSpecializationInfo = new safe_VkSpecializationInfo(*copy_src->pSpecializationInfo);
}

safe_VkComputePipelineCreateInfo::safe_VkComputePipelineCreateInfo(const VkComputePipelineCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    stage(&in_struct->stage),
    layout(in_struct->layout),
    basePipelineHandle(in_struct->basePipelineHandle),
    basePipelineIndex(in_struct->basePipelineIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkComputePipelineCreateInfo::safe_VkComputePipelineCreateInfo() :
    sType(VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkComputePipelineCreateInfo::safe_VkComputePipelineCreateInfo(const safe_VkComputePipelineCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    stage.initialize(&copy_src.stage);
    layout = copy_src.layout;
    basePipelineHandle = copy_src.basePipelineHandle;
    basePipelineIndex = copy_src.basePipelineIndex;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkComputePipelineCreateInfo& safe_VkComputePipelineCreateInfo::operator=(const safe_VkComputePipelineCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    stage.initialize(&copy_src.stage);
    layout = copy_src.layout;
    basePipelineHandle = copy_src.basePipelineHandle;
    basePipelineIndex = copy_src.basePipelineIndex;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkComputePipelineCreateInfo::~safe_VkComputePipelineCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkComputePipelineCreateInfo::initialize(const VkComputePipelineCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    stage.initialize(&in_struct->stage);
    layout = in_struct->layout;
    basePipelineHandle = in_struct->basePipelineHandle;
    basePipelineIndex = in_struct->basePipelineIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkComputePipelineCreateInfo::initialize(const safe_VkComputePipelineCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    stage.initialize(&copy_src->stage);
    layout = copy_src->layout;
    basePipelineHandle = copy_src->basePipelineHandle;
    basePipelineIndex = copy_src->basePipelineIndex;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineVertexInputStateCreateInfo::safe_VkPipelineVertexInputStateCreateInfo(const VkPipelineVertexInputStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    vertexBindingDescriptionCount(in_struct->vertexBindingDescriptionCount),
    pVertexBindingDescriptions(nullptr),
    vertexAttributeDescriptionCount(in_struct->vertexAttributeDescriptionCount),
    pVertexAttributeDescriptions(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pVertexBindingDescriptions) {
        pVertexBindingDescriptions = new VkVertexInputBindingDescription[in_struct->vertexBindingDescriptionCount];
        memcpy ((void *)pVertexBindingDescriptions, (void *)in_struct->pVertexBindingDescriptions, sizeof(VkVertexInputBindingDescription)*in_struct->vertexBindingDescriptionCount);
    }
    if (in_struct->pVertexAttributeDescriptions) {
        pVertexAttributeDescriptions = new VkVertexInputAttributeDescription[in_struct->vertexAttributeDescriptionCount];
        memcpy ((void *)pVertexAttributeDescriptions, (void *)in_struct->pVertexAttributeDescriptions, sizeof(VkVertexInputAttributeDescription)*in_struct->vertexAttributeDescriptionCount);
    }
}

safe_VkPipelineVertexInputStateCreateInfo::safe_VkPipelineVertexInputStateCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO),
    pNext(nullptr),
    pVertexBindingDescriptions(nullptr),
    pVertexAttributeDescriptions(nullptr)
{}

safe_VkPipelineVertexInputStateCreateInfo::safe_VkPipelineVertexInputStateCreateInfo(const safe_VkPipelineVertexInputStateCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    vertexBindingDescriptionCount = copy_src.vertexBindingDescriptionCount;
    pVertexBindingDescriptions = nullptr;
    vertexAttributeDescriptionCount = copy_src.vertexAttributeDescriptionCount;
    pVertexAttributeDescriptions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pVertexBindingDescriptions) {
        pVertexBindingDescriptions = new VkVertexInputBindingDescription[copy_src.vertexBindingDescriptionCount];
        memcpy ((void *)pVertexBindingDescriptions, (void *)copy_src.pVertexBindingDescriptions, sizeof(VkVertexInputBindingDescription)*copy_src.vertexBindingDescriptionCount);
    }
    if (copy_src.pVertexAttributeDescriptions) {
        pVertexAttributeDescriptions = new VkVertexInputAttributeDescription[copy_src.vertexAttributeDescriptionCount];
        memcpy ((void *)pVertexAttributeDescriptions, (void *)copy_src.pVertexAttributeDescriptions, sizeof(VkVertexInputAttributeDescription)*copy_src.vertexAttributeDescriptionCount);
    }
}

safe_VkPipelineVertexInputStateCreateInfo& safe_VkPipelineVertexInputStateCreateInfo::operator=(const safe_VkPipelineVertexInputStateCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pVertexBindingDescriptions)
        delete[] pVertexBindingDescriptions;
    if (pVertexAttributeDescriptions)
        delete[] pVertexAttributeDescriptions;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    vertexBindingDescriptionCount = copy_src.vertexBindingDescriptionCount;
    pVertexBindingDescriptions = nullptr;
    vertexAttributeDescriptionCount = copy_src.vertexAttributeDescriptionCount;
    pVertexAttributeDescriptions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pVertexBindingDescriptions) {
        pVertexBindingDescriptions = new VkVertexInputBindingDescription[copy_src.vertexBindingDescriptionCount];
        memcpy ((void *)pVertexBindingDescriptions, (void *)copy_src.pVertexBindingDescriptions, sizeof(VkVertexInputBindingDescription)*copy_src.vertexBindingDescriptionCount);
    }
    if (copy_src.pVertexAttributeDescriptions) {
        pVertexAttributeDescriptions = new VkVertexInputAttributeDescription[copy_src.vertexAttributeDescriptionCount];
        memcpy ((void *)pVertexAttributeDescriptions, (void *)copy_src.pVertexAttributeDescriptions, sizeof(VkVertexInputAttributeDescription)*copy_src.vertexAttributeDescriptionCount);
    }

    return *this;
}

safe_VkPipelineVertexInputStateCreateInfo::~safe_VkPipelineVertexInputStateCreateInfo()
{
    if (pVertexBindingDescriptions)
        delete[] pVertexBindingDescriptions;
    if (pVertexAttributeDescriptions)
        delete[] pVertexAttributeDescriptions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineVertexInputStateCreateInfo::initialize(const VkPipelineVertexInputStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    vertexBindingDescriptionCount = in_struct->vertexBindingDescriptionCount;
    pVertexBindingDescriptions = nullptr;
    vertexAttributeDescriptionCount = in_struct->vertexAttributeDescriptionCount;
    pVertexAttributeDescriptions = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pVertexBindingDescriptions) {
        pVertexBindingDescriptions = new VkVertexInputBindingDescription[in_struct->vertexBindingDescriptionCount];
        memcpy ((void *)pVertexBindingDescriptions, (void *)in_struct->pVertexBindingDescriptions, sizeof(VkVertexInputBindingDescription)*in_struct->vertexBindingDescriptionCount);
    }
    if (in_struct->pVertexAttributeDescriptions) {
        pVertexAttributeDescriptions = new VkVertexInputAttributeDescription[in_struct->vertexAttributeDescriptionCount];
        memcpy ((void *)pVertexAttributeDescriptions, (void *)in_struct->pVertexAttributeDescriptions, sizeof(VkVertexInputAttributeDescription)*in_struct->vertexAttributeDescriptionCount);
    }
}

void safe_VkPipelineVertexInputStateCreateInfo::initialize(const safe_VkPipelineVertexInputStateCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    vertexBindingDescriptionCount = copy_src->vertexBindingDescriptionCount;
    pVertexBindingDescriptions = nullptr;
    vertexAttributeDescriptionCount = copy_src->vertexAttributeDescriptionCount;
    pVertexAttributeDescriptions = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pVertexBindingDescriptions) {
        pVertexBindingDescriptions = new VkVertexInputBindingDescription[copy_src->vertexBindingDescriptionCount];
        memcpy ((void *)pVertexBindingDescriptions, (void *)copy_src->pVertexBindingDescriptions, sizeof(VkVertexInputBindingDescription)*copy_src->vertexBindingDescriptionCount);
    }
    if (copy_src->pVertexAttributeDescriptions) {
        pVertexAttributeDescriptions = new VkVertexInputAttributeDescription[copy_src->vertexAttributeDescriptionCount];
        memcpy ((void *)pVertexAttributeDescriptions, (void *)copy_src->pVertexAttributeDescriptions, sizeof(VkVertexInputAttributeDescription)*copy_src->vertexAttributeDescriptionCount);
    }
}

safe_VkPipelineInputAssemblyStateCreateInfo::safe_VkPipelineInputAssemblyStateCreateInfo(const VkPipelineInputAssemblyStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    topology(in_struct->topology),
    primitiveRestartEnable(in_struct->primitiveRestartEnable)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineInputAssemblyStateCreateInfo::safe_VkPipelineInputAssemblyStateCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkPipelineInputAssemblyStateCreateInfo::safe_VkPipelineInputAssemblyStateCreateInfo(const safe_VkPipelineInputAssemblyStateCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    topology = copy_src.topology;
    primitiveRestartEnable = copy_src.primitiveRestartEnable;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPipelineInputAssemblyStateCreateInfo& safe_VkPipelineInputAssemblyStateCreateInfo::operator=(const safe_VkPipelineInputAssemblyStateCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    topology = copy_src.topology;
    primitiveRestartEnable = copy_src.primitiveRestartEnable;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPipelineInputAssemblyStateCreateInfo::~safe_VkPipelineInputAssemblyStateCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineInputAssemblyStateCreateInfo::initialize(const VkPipelineInputAssemblyStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    topology = in_struct->topology;
    primitiveRestartEnable = in_struct->primitiveRestartEnable;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineInputAssemblyStateCreateInfo::initialize(const safe_VkPipelineInputAssemblyStateCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    topology = copy_src->topology;
    primitiveRestartEnable = copy_src->primitiveRestartEnable;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineTessellationStateCreateInfo::safe_VkPipelineTessellationStateCreateInfo(const VkPipelineTessellationStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    patchControlPoints(in_struct->patchControlPoints)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineTessellationStateCreateInfo::safe_VkPipelineTessellationStateCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkPipelineTessellationStateCreateInfo::safe_VkPipelineTessellationStateCreateInfo(const safe_VkPipelineTessellationStateCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    patchControlPoints = copy_src.patchControlPoints;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPipelineTessellationStateCreateInfo& safe_VkPipelineTessellationStateCreateInfo::operator=(const safe_VkPipelineTessellationStateCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    patchControlPoints = copy_src.patchControlPoints;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPipelineTessellationStateCreateInfo::~safe_VkPipelineTessellationStateCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineTessellationStateCreateInfo::initialize(const VkPipelineTessellationStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    patchControlPoints = in_struct->patchControlPoints;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineTessellationStateCreateInfo::initialize(const safe_VkPipelineTessellationStateCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    patchControlPoints = copy_src->patchControlPoints;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineViewportStateCreateInfo::safe_VkPipelineViewportStateCreateInfo(const VkPipelineViewportStateCreateInfo* in_struct, const bool is_dynamic_viewports, const bool is_dynamic_scissors) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    viewportCount(in_struct->viewportCount),
    pViewports(nullptr),
    scissorCount(in_struct->scissorCount),
    pScissors(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewports && !is_dynamic_viewports) {
        pViewports = new VkViewport[in_struct->viewportCount];
        memcpy ((void *)pViewports, (void *)in_struct->pViewports, sizeof(VkViewport)*in_struct->viewportCount);
    }
    else
        pViewports = NULL;
    if (in_struct->pScissors && !is_dynamic_scissors) {
        pScissors = new VkRect2D[in_struct->scissorCount];
        memcpy ((void *)pScissors, (void *)in_struct->pScissors, sizeof(VkRect2D)*in_struct->scissorCount);
    }
    else
        pScissors = NULL;
}

safe_VkPipelineViewportStateCreateInfo::safe_VkPipelineViewportStateCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO),
    pNext(nullptr),
    pViewports(nullptr),
    pScissors(nullptr)
{}

safe_VkPipelineViewportStateCreateInfo::safe_VkPipelineViewportStateCreateInfo(const safe_VkPipelineViewportStateCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    viewportCount = copy_src.viewportCount;
    pViewports = nullptr;
    scissorCount = copy_src.scissorCount;
    pScissors = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pViewports) {
        pViewports = new VkViewport[copy_src.viewportCount];
        memcpy ((void *)pViewports, (void *)copy_src.pViewports, sizeof(VkViewport)*copy_src.viewportCount);
    }
    else
        pViewports = NULL;
    if (copy_src.pScissors) {
        pScissors = new VkRect2D[copy_src.scissorCount];
        memcpy ((void *)pScissors, (void *)copy_src.pScissors, sizeof(VkRect2D)*copy_src.scissorCount);
    }
    else
        pScissors = NULL;
}

safe_VkPipelineViewportStateCreateInfo& safe_VkPipelineViewportStateCreateInfo::operator=(const safe_VkPipelineViewportStateCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pViewports)
        delete[] pViewports;
    if (pScissors)
        delete[] pScissors;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    viewportCount = copy_src.viewportCount;
    pViewports = nullptr;
    scissorCount = copy_src.scissorCount;
    pScissors = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pViewports) {
        pViewports = new VkViewport[copy_src.viewportCount];
        memcpy ((void *)pViewports, (void *)copy_src.pViewports, sizeof(VkViewport)*copy_src.viewportCount);
    }
    else
        pViewports = NULL;
    if (copy_src.pScissors) {
        pScissors = new VkRect2D[copy_src.scissorCount];
        memcpy ((void *)pScissors, (void *)copy_src.pScissors, sizeof(VkRect2D)*copy_src.scissorCount);
    }
    else
        pScissors = NULL;

    return *this;
}

safe_VkPipelineViewportStateCreateInfo::~safe_VkPipelineViewportStateCreateInfo()
{
    if (pViewports)
        delete[] pViewports;
    if (pScissors)
        delete[] pScissors;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineViewportStateCreateInfo::initialize(const VkPipelineViewportStateCreateInfo* in_struct, const bool is_dynamic_viewports, const bool is_dynamic_scissors)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    viewportCount = in_struct->viewportCount;
    pViewports = nullptr;
    scissorCount = in_struct->scissorCount;
    pScissors = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewports && !is_dynamic_viewports) {
        pViewports = new VkViewport[in_struct->viewportCount];
        memcpy ((void *)pViewports, (void *)in_struct->pViewports, sizeof(VkViewport)*in_struct->viewportCount);
    }
    else
        pViewports = NULL;
    if (in_struct->pScissors && !is_dynamic_scissors) {
        pScissors = new VkRect2D[in_struct->scissorCount];
        memcpy ((void *)pScissors, (void *)in_struct->pScissors, sizeof(VkRect2D)*in_struct->scissorCount);
    }
    else
        pScissors = NULL;
}

void safe_VkPipelineViewportStateCreateInfo::initialize(const safe_VkPipelineViewportStateCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    viewportCount = copy_src->viewportCount;
    pViewports = nullptr;
    scissorCount = copy_src->scissorCount;
    pScissors = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pViewports) {
        pViewports = new VkViewport[copy_src->viewportCount];
        memcpy ((void *)pViewports, (void *)copy_src->pViewports, sizeof(VkViewport)*copy_src->viewportCount);
    }
    else
        pViewports = NULL;
    if (copy_src->pScissors) {
        pScissors = new VkRect2D[copy_src->scissorCount];
        memcpy ((void *)pScissors, (void *)copy_src->pScissors, sizeof(VkRect2D)*copy_src->scissorCount);
    }
    else
        pScissors = NULL;
}

safe_VkPipelineRasterizationStateCreateInfo::safe_VkPipelineRasterizationStateCreateInfo(const VkPipelineRasterizationStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    depthClampEnable(in_struct->depthClampEnable),
    rasterizerDiscardEnable(in_struct->rasterizerDiscardEnable),
    polygonMode(in_struct->polygonMode),
    cullMode(in_struct->cullMode),
    frontFace(in_struct->frontFace),
    depthBiasEnable(in_struct->depthBiasEnable),
    depthBiasConstantFactor(in_struct->depthBiasConstantFactor),
    depthBiasClamp(in_struct->depthBiasClamp),
    depthBiasSlopeFactor(in_struct->depthBiasSlopeFactor),
    lineWidth(in_struct->lineWidth)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineRasterizationStateCreateInfo::safe_VkPipelineRasterizationStateCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkPipelineRasterizationStateCreateInfo::safe_VkPipelineRasterizationStateCreateInfo(const safe_VkPipelineRasterizationStateCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    depthClampEnable = copy_src.depthClampEnable;
    rasterizerDiscardEnable = copy_src.rasterizerDiscardEnable;
    polygonMode = copy_src.polygonMode;
    cullMode = copy_src.cullMode;
    frontFace = copy_src.frontFace;
    depthBiasEnable = copy_src.depthBiasEnable;
    depthBiasConstantFactor = copy_src.depthBiasConstantFactor;
    depthBiasClamp = copy_src.depthBiasClamp;
    depthBiasSlopeFactor = copy_src.depthBiasSlopeFactor;
    lineWidth = copy_src.lineWidth;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPipelineRasterizationStateCreateInfo& safe_VkPipelineRasterizationStateCreateInfo::operator=(const safe_VkPipelineRasterizationStateCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    depthClampEnable = copy_src.depthClampEnable;
    rasterizerDiscardEnable = copy_src.rasterizerDiscardEnable;
    polygonMode = copy_src.polygonMode;
    cullMode = copy_src.cullMode;
    frontFace = copy_src.frontFace;
    depthBiasEnable = copy_src.depthBiasEnable;
    depthBiasConstantFactor = copy_src.depthBiasConstantFactor;
    depthBiasClamp = copy_src.depthBiasClamp;
    depthBiasSlopeFactor = copy_src.depthBiasSlopeFactor;
    lineWidth = copy_src.lineWidth;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPipelineRasterizationStateCreateInfo::~safe_VkPipelineRasterizationStateCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineRasterizationStateCreateInfo::initialize(const VkPipelineRasterizationStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    depthClampEnable = in_struct->depthClampEnable;
    rasterizerDiscardEnable = in_struct->rasterizerDiscardEnable;
    polygonMode = in_struct->polygonMode;
    cullMode = in_struct->cullMode;
    frontFace = in_struct->frontFace;
    depthBiasEnable = in_struct->depthBiasEnable;
    depthBiasConstantFactor = in_struct->depthBiasConstantFactor;
    depthBiasClamp = in_struct->depthBiasClamp;
    depthBiasSlopeFactor = in_struct->depthBiasSlopeFactor;
    lineWidth = in_struct->lineWidth;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineRasterizationStateCreateInfo::initialize(const safe_VkPipelineRasterizationStateCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    depthClampEnable = copy_src->depthClampEnable;
    rasterizerDiscardEnable = copy_src->rasterizerDiscardEnable;
    polygonMode = copy_src->polygonMode;
    cullMode = copy_src->cullMode;
    frontFace = copy_src->frontFace;
    depthBiasEnable = copy_src->depthBiasEnable;
    depthBiasConstantFactor = copy_src->depthBiasConstantFactor;
    depthBiasClamp = copy_src->depthBiasClamp;
    depthBiasSlopeFactor = copy_src->depthBiasSlopeFactor;
    lineWidth = copy_src->lineWidth;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineMultisampleStateCreateInfo::safe_VkPipelineMultisampleStateCreateInfo(const VkPipelineMultisampleStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    rasterizationSamples(in_struct->rasterizationSamples),
    sampleShadingEnable(in_struct->sampleShadingEnable),
    minSampleShading(in_struct->minSampleShading),
    pSampleMask(nullptr),
    alphaToCoverageEnable(in_struct->alphaToCoverageEnable),
    alphaToOneEnable(in_struct->alphaToOneEnable)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSampleMask) {
        pSampleMask = new VkSampleMask(*in_struct->pSampleMask);
    }
}

safe_VkPipelineMultisampleStateCreateInfo::safe_VkPipelineMultisampleStateCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO),
    pNext(nullptr),
    pSampleMask(nullptr)
{}

safe_VkPipelineMultisampleStateCreateInfo::safe_VkPipelineMultisampleStateCreateInfo(const safe_VkPipelineMultisampleStateCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    rasterizationSamples = copy_src.rasterizationSamples;
    sampleShadingEnable = copy_src.sampleShadingEnable;
    minSampleShading = copy_src.minSampleShading;
    pSampleMask = nullptr;
    alphaToCoverageEnable = copy_src.alphaToCoverageEnable;
    alphaToOneEnable = copy_src.alphaToOneEnable;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSampleMask) {
        pSampleMask = new VkSampleMask(*copy_src.pSampleMask);
    }
}

safe_VkPipelineMultisampleStateCreateInfo& safe_VkPipelineMultisampleStateCreateInfo::operator=(const safe_VkPipelineMultisampleStateCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pSampleMask)
        delete pSampleMask;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    rasterizationSamples = copy_src.rasterizationSamples;
    sampleShadingEnable = copy_src.sampleShadingEnable;
    minSampleShading = copy_src.minSampleShading;
    pSampleMask = nullptr;
    alphaToCoverageEnable = copy_src.alphaToCoverageEnable;
    alphaToOneEnable = copy_src.alphaToOneEnable;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSampleMask) {
        pSampleMask = new VkSampleMask(*copy_src.pSampleMask);
    }

    return *this;
}

safe_VkPipelineMultisampleStateCreateInfo::~safe_VkPipelineMultisampleStateCreateInfo()
{
    if (pSampleMask)
        delete pSampleMask;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineMultisampleStateCreateInfo::initialize(const VkPipelineMultisampleStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    rasterizationSamples = in_struct->rasterizationSamples;
    sampleShadingEnable = in_struct->sampleShadingEnable;
    minSampleShading = in_struct->minSampleShading;
    pSampleMask = nullptr;
    alphaToCoverageEnable = in_struct->alphaToCoverageEnable;
    alphaToOneEnable = in_struct->alphaToOneEnable;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSampleMask) {
        pSampleMask = new VkSampleMask(*in_struct->pSampleMask);
    }
}

void safe_VkPipelineMultisampleStateCreateInfo::initialize(const safe_VkPipelineMultisampleStateCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    rasterizationSamples = copy_src->rasterizationSamples;
    sampleShadingEnable = copy_src->sampleShadingEnable;
    minSampleShading = copy_src->minSampleShading;
    pSampleMask = nullptr;
    alphaToCoverageEnable = copy_src->alphaToCoverageEnable;
    alphaToOneEnable = copy_src->alphaToOneEnable;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pSampleMask) {
        pSampleMask = new VkSampleMask(*copy_src->pSampleMask);
    }
}

safe_VkPipelineDepthStencilStateCreateInfo::safe_VkPipelineDepthStencilStateCreateInfo(const VkPipelineDepthStencilStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    depthTestEnable(in_struct->depthTestEnable),
    depthWriteEnable(in_struct->depthWriteEnable),
    depthCompareOp(in_struct->depthCompareOp),
    depthBoundsTestEnable(in_struct->depthBoundsTestEnable),
    stencilTestEnable(in_struct->stencilTestEnable),
    front(in_struct->front),
    back(in_struct->back),
    minDepthBounds(in_struct->minDepthBounds),
    maxDepthBounds(in_struct->maxDepthBounds)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineDepthStencilStateCreateInfo::safe_VkPipelineDepthStencilStateCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkPipelineDepthStencilStateCreateInfo::safe_VkPipelineDepthStencilStateCreateInfo(const safe_VkPipelineDepthStencilStateCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    depthTestEnable = copy_src.depthTestEnable;
    depthWriteEnable = copy_src.depthWriteEnable;
    depthCompareOp = copy_src.depthCompareOp;
    depthBoundsTestEnable = copy_src.depthBoundsTestEnable;
    stencilTestEnable = copy_src.stencilTestEnable;
    front = copy_src.front;
    back = copy_src.back;
    minDepthBounds = copy_src.minDepthBounds;
    maxDepthBounds = copy_src.maxDepthBounds;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPipelineDepthStencilStateCreateInfo& safe_VkPipelineDepthStencilStateCreateInfo::operator=(const safe_VkPipelineDepthStencilStateCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    depthTestEnable = copy_src.depthTestEnable;
    depthWriteEnable = copy_src.depthWriteEnable;
    depthCompareOp = copy_src.depthCompareOp;
    depthBoundsTestEnable = copy_src.depthBoundsTestEnable;
    stencilTestEnable = copy_src.stencilTestEnable;
    front = copy_src.front;
    back = copy_src.back;
    minDepthBounds = copy_src.minDepthBounds;
    maxDepthBounds = copy_src.maxDepthBounds;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPipelineDepthStencilStateCreateInfo::~safe_VkPipelineDepthStencilStateCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineDepthStencilStateCreateInfo::initialize(const VkPipelineDepthStencilStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    depthTestEnable = in_struct->depthTestEnable;
    depthWriteEnable = in_struct->depthWriteEnable;
    depthCompareOp = in_struct->depthCompareOp;
    depthBoundsTestEnable = in_struct->depthBoundsTestEnable;
    stencilTestEnable = in_struct->stencilTestEnable;
    front = in_struct->front;
    back = in_struct->back;
    minDepthBounds = in_struct->minDepthBounds;
    maxDepthBounds = in_struct->maxDepthBounds;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineDepthStencilStateCreateInfo::initialize(const safe_VkPipelineDepthStencilStateCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    depthTestEnable = copy_src->depthTestEnable;
    depthWriteEnable = copy_src->depthWriteEnable;
    depthCompareOp = copy_src->depthCompareOp;
    depthBoundsTestEnable = copy_src->depthBoundsTestEnable;
    stencilTestEnable = copy_src->stencilTestEnable;
    front = copy_src->front;
    back = copy_src->back;
    minDepthBounds = copy_src->minDepthBounds;
    maxDepthBounds = copy_src->maxDepthBounds;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineColorBlendStateCreateInfo::safe_VkPipelineColorBlendStateCreateInfo(const VkPipelineColorBlendStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    logicOpEnable(in_struct->logicOpEnable),
    logicOp(in_struct->logicOp),
    attachmentCount(in_struct->attachmentCount),
    pAttachments(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttachments) {
        pAttachments = new VkPipelineColorBlendAttachmentState[in_struct->attachmentCount];
        memcpy ((void *)pAttachments, (void *)in_struct->pAttachments, sizeof(VkPipelineColorBlendAttachmentState)*in_struct->attachmentCount);
    }
    for (uint32_t i = 0; i < 4; ++i) {
        blendConstants[i] = in_struct->blendConstants[i];
    }
}

safe_VkPipelineColorBlendStateCreateInfo::safe_VkPipelineColorBlendStateCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO),
    pNext(nullptr),
    pAttachments(nullptr)
{}

safe_VkPipelineColorBlendStateCreateInfo::safe_VkPipelineColorBlendStateCreateInfo(const safe_VkPipelineColorBlendStateCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    logicOpEnable = copy_src.logicOpEnable;
    logicOp = copy_src.logicOp;
    attachmentCount = copy_src.attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAttachments) {
        pAttachments = new VkPipelineColorBlendAttachmentState[copy_src.attachmentCount];
        memcpy ((void *)pAttachments, (void *)copy_src.pAttachments, sizeof(VkPipelineColorBlendAttachmentState)*copy_src.attachmentCount);
    }
    for (uint32_t i = 0; i < 4; ++i) {
        blendConstants[i] = copy_src.blendConstants[i];
    }
}

safe_VkPipelineColorBlendStateCreateInfo& safe_VkPipelineColorBlendStateCreateInfo::operator=(const safe_VkPipelineColorBlendStateCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    logicOpEnable = copy_src.logicOpEnable;
    logicOp = copy_src.logicOp;
    attachmentCount = copy_src.attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAttachments) {
        pAttachments = new VkPipelineColorBlendAttachmentState[copy_src.attachmentCount];
        memcpy ((void *)pAttachments, (void *)copy_src.pAttachments, sizeof(VkPipelineColorBlendAttachmentState)*copy_src.attachmentCount);
    }
    for (uint32_t i = 0; i < 4; ++i) {
        blendConstants[i] = copy_src.blendConstants[i];
    }

    return *this;
}

safe_VkPipelineColorBlendStateCreateInfo::~safe_VkPipelineColorBlendStateCreateInfo()
{
    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineColorBlendStateCreateInfo::initialize(const VkPipelineColorBlendStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    logicOpEnable = in_struct->logicOpEnable;
    logicOp = in_struct->logicOp;
    attachmentCount = in_struct->attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttachments) {
        pAttachments = new VkPipelineColorBlendAttachmentState[in_struct->attachmentCount];
        memcpy ((void *)pAttachments, (void *)in_struct->pAttachments, sizeof(VkPipelineColorBlendAttachmentState)*in_struct->attachmentCount);
    }
    for (uint32_t i = 0; i < 4; ++i) {
        blendConstants[i] = in_struct->blendConstants[i];
    }
}

void safe_VkPipelineColorBlendStateCreateInfo::initialize(const safe_VkPipelineColorBlendStateCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    logicOpEnable = copy_src->logicOpEnable;
    logicOp = copy_src->logicOp;
    attachmentCount = copy_src->attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pAttachments) {
        pAttachments = new VkPipelineColorBlendAttachmentState[copy_src->attachmentCount];
        memcpy ((void *)pAttachments, (void *)copy_src->pAttachments, sizeof(VkPipelineColorBlendAttachmentState)*copy_src->attachmentCount);
    }
    for (uint32_t i = 0; i < 4; ++i) {
        blendConstants[i] = copy_src->blendConstants[i];
    }
}

safe_VkPipelineDynamicStateCreateInfo::safe_VkPipelineDynamicStateCreateInfo(const VkPipelineDynamicStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    dynamicStateCount(in_struct->dynamicStateCount),
    pDynamicStates(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDynamicStates) {
        pDynamicStates = new VkDynamicState[in_struct->dynamicStateCount];
        memcpy ((void *)pDynamicStates, (void *)in_struct->pDynamicStates, sizeof(VkDynamicState)*in_struct->dynamicStateCount);
    }
}

safe_VkPipelineDynamicStateCreateInfo::safe_VkPipelineDynamicStateCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO),
    pNext(nullptr),
    pDynamicStates(nullptr)
{}

safe_VkPipelineDynamicStateCreateInfo::safe_VkPipelineDynamicStateCreateInfo(const safe_VkPipelineDynamicStateCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    dynamicStateCount = copy_src.dynamicStateCount;
    pDynamicStates = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDynamicStates) {
        pDynamicStates = new VkDynamicState[copy_src.dynamicStateCount];
        memcpy ((void *)pDynamicStates, (void *)copy_src.pDynamicStates, sizeof(VkDynamicState)*copy_src.dynamicStateCount);
    }
}

safe_VkPipelineDynamicStateCreateInfo& safe_VkPipelineDynamicStateCreateInfo::operator=(const safe_VkPipelineDynamicStateCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pDynamicStates)
        delete[] pDynamicStates;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    dynamicStateCount = copy_src.dynamicStateCount;
    pDynamicStates = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDynamicStates) {
        pDynamicStates = new VkDynamicState[copy_src.dynamicStateCount];
        memcpy ((void *)pDynamicStates, (void *)copy_src.pDynamicStates, sizeof(VkDynamicState)*copy_src.dynamicStateCount);
    }

    return *this;
}

safe_VkPipelineDynamicStateCreateInfo::~safe_VkPipelineDynamicStateCreateInfo()
{
    if (pDynamicStates)
        delete[] pDynamicStates;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineDynamicStateCreateInfo::initialize(const VkPipelineDynamicStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    dynamicStateCount = in_struct->dynamicStateCount;
    pDynamicStates = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDynamicStates) {
        pDynamicStates = new VkDynamicState[in_struct->dynamicStateCount];
        memcpy ((void *)pDynamicStates, (void *)in_struct->pDynamicStates, sizeof(VkDynamicState)*in_struct->dynamicStateCount);
    }
}

void safe_VkPipelineDynamicStateCreateInfo::initialize(const safe_VkPipelineDynamicStateCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    dynamicStateCount = copy_src->dynamicStateCount;
    pDynamicStates = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pDynamicStates) {
        pDynamicStates = new VkDynamicState[copy_src->dynamicStateCount];
        memcpy ((void *)pDynamicStates, (void *)copy_src->pDynamicStates, sizeof(VkDynamicState)*copy_src->dynamicStateCount);
    }
}

safe_VkGraphicsPipelineCreateInfo::safe_VkGraphicsPipelineCreateInfo(const VkGraphicsPipelineCreateInfo* in_struct, const bool uses_color_attachment, const bool uses_depthstencil_attachment) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    stageCount(in_struct->stageCount),
    pStages(nullptr),
    pVertexInputState(nullptr),
    pInputAssemblyState(nullptr),
    pTessellationState(nullptr),
    pViewportState(nullptr),
    pRasterizationState(nullptr),
    pMultisampleState(nullptr),
    pDepthStencilState(nullptr),
    pColorBlendState(nullptr),
    pDynamicState(nullptr),
    layout(in_struct->layout),
    renderPass(in_struct->renderPass),
    subpass(in_struct->subpass),
    basePipelineHandle(in_struct->basePipelineHandle),
    basePipelineIndex(in_struct->basePipelineIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (stageCount && in_struct->pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&in_struct->pStages[i]);
        }
    }
    if (in_struct->pVertexInputState)
        pVertexInputState = new safe_VkPipelineVertexInputStateCreateInfo(in_struct->pVertexInputState);
    else
        pVertexInputState = NULL;
    if (in_struct->pInputAssemblyState)
        pInputAssemblyState = new safe_VkPipelineInputAssemblyStateCreateInfo(in_struct->pInputAssemblyState);
    else
        pInputAssemblyState = NULL;
    bool has_tessellation_stage = false;
    if (stageCount && pStages)
        for (uint32_t i = 0; i < stageCount && !has_tessellation_stage; ++i)
            if (pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT || pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)
                has_tessellation_stage = true;
    if (in_struct->pTessellationState && has_tessellation_stage)
        pTessellationState = new safe_VkPipelineTessellationStateCreateInfo(in_struct->pTessellationState);
    else
        pTessellationState = NULL; // original pTessellationState pointer ignored
    bool is_dynamic_has_rasterization = false;
    if (in_struct->pDynamicState && in_struct->pDynamicState->pDynamicStates) {
        for (uint32_t i = 0; i < in_struct->pDynamicState->dynamicStateCount && !is_dynamic_has_rasterization; ++i)
            if (in_struct->pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT)
                is_dynamic_has_rasterization = true;
    }
    bool has_rasterization = in_struct->pRasterizationState ? (is_dynamic_has_rasterization || !in_struct->pRasterizationState->rasterizerDiscardEnable) : false;
    if (in_struct->pViewportState && has_rasterization) {
        bool is_dynamic_viewports = false;
        bool is_dynamic_scissors = false;
        if (in_struct->pDynamicState && in_struct->pDynamicState->pDynamicStates) {
            for (uint32_t i = 0; i < in_struct->pDynamicState->dynamicStateCount && !is_dynamic_viewports; ++i)
                if (in_struct->pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_VIEWPORT)
                    is_dynamic_viewports = true;
            for (uint32_t i = 0; i < in_struct->pDynamicState->dynamicStateCount && !is_dynamic_scissors; ++i)
                if (in_struct->pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_SCISSOR)
                    is_dynamic_scissors = true;
        }
        pViewportState = new safe_VkPipelineViewportStateCreateInfo(in_struct->pViewportState, is_dynamic_viewports, is_dynamic_scissors);
    } else
        pViewportState = NULL; // original pViewportState pointer ignored
    if (in_struct->pRasterizationState)
        pRasterizationState = new safe_VkPipelineRasterizationStateCreateInfo(in_struct->pRasterizationState);
    else
        pRasterizationState = NULL;
    if (in_struct->pMultisampleState && has_rasterization)
        pMultisampleState = new safe_VkPipelineMultisampleStateCreateInfo(in_struct->pMultisampleState);
    else
        pMultisampleState = NULL; // original pMultisampleState pointer ignored
    // needs a tracked subpass state uses_depthstencil_attachment
    if (in_struct->pDepthStencilState && has_rasterization && uses_depthstencil_attachment)
        pDepthStencilState = new safe_VkPipelineDepthStencilStateCreateInfo(in_struct->pDepthStencilState);
    else
        pDepthStencilState = NULL; // original pDepthStencilState pointer ignored
    // needs a tracked subpass state usesColorAttachment
    if (in_struct->pColorBlendState && has_rasterization && uses_color_attachment)
        pColorBlendState = new safe_VkPipelineColorBlendStateCreateInfo(in_struct->pColorBlendState);
    else
        pColorBlendState = NULL; // original pColorBlendState pointer ignored
    if (in_struct->pDynamicState)
        pDynamicState = new safe_VkPipelineDynamicStateCreateInfo(in_struct->pDynamicState);
    else
        pDynamicState = NULL;
}

safe_VkGraphicsPipelineCreateInfo::safe_VkGraphicsPipelineCreateInfo() :
    sType(VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO),
    pNext(nullptr),
    pStages(nullptr),
    pVertexInputState(nullptr),
    pInputAssemblyState(nullptr),
    pTessellationState(nullptr),
    pViewportState(nullptr),
    pRasterizationState(nullptr),
    pMultisampleState(nullptr),
    pDepthStencilState(nullptr),
    pColorBlendState(nullptr),
    pDynamicState(nullptr)
{}

safe_VkGraphicsPipelineCreateInfo::safe_VkGraphicsPipelineCreateInfo(const safe_VkGraphicsPipelineCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    stageCount = copy_src.stageCount;
    pStages = nullptr;
    pVertexInputState = nullptr;
    pInputAssemblyState = nullptr;
    pTessellationState = nullptr;
    pViewportState = nullptr;
    pRasterizationState = nullptr;
    pMultisampleState = nullptr;
    pDepthStencilState = nullptr;
    pColorBlendState = nullptr;
    pDynamicState = nullptr;
    layout = copy_src.layout;
    renderPass = copy_src.renderPass;
    subpass = copy_src.subpass;
    basePipelineHandle = copy_src.basePipelineHandle;
    basePipelineIndex = copy_src.basePipelineIndex;
    pNext = SafePnextCopy(copy_src.pNext);
    if (stageCount && copy_src.pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&copy_src.pStages[i]);
        }
    }
    if (copy_src.pVertexInputState)
        pVertexInputState = new safe_VkPipelineVertexInputStateCreateInfo(*copy_src.pVertexInputState);
    else
        pVertexInputState = NULL;
    if (copy_src.pInputAssemblyState)
        pInputAssemblyState = new safe_VkPipelineInputAssemblyStateCreateInfo(*copy_src.pInputAssemblyState);
    else
        pInputAssemblyState = NULL;
    bool has_tessellation_stage = false;
    if (stageCount && pStages)
        for (uint32_t i = 0; i < stageCount && !has_tessellation_stage; ++i)
            if (pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT || pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)
                has_tessellation_stage = true;
    if (copy_src.pTessellationState && has_tessellation_stage)
        pTessellationState = new safe_VkPipelineTessellationStateCreateInfo(*copy_src.pTessellationState);
    else
        pTessellationState = NULL; // original pTessellationState pointer ignored
    bool is_dynamic_has_rasterization = false;
    if (copy_src.pDynamicState && copy_src.pDynamicState->pDynamicStates) {
        for (uint32_t i = 0; i < copy_src.pDynamicState->dynamicStateCount && !is_dynamic_has_rasterization; ++i)
            if (copy_src.pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT)
                is_dynamic_has_rasterization = true;
    }
    bool has_rasterization = copy_src.pRasterizationState ? (is_dynamic_has_rasterization || !copy_src.pRasterizationState->rasterizerDiscardEnable) : false;
    if (copy_src.pViewportState && has_rasterization) {
        pViewportState = new safe_VkPipelineViewportStateCreateInfo(*copy_src.pViewportState);
    } else
        pViewportState = NULL; // original pViewportState pointer ignored
    if (copy_src.pRasterizationState)
        pRasterizationState = new safe_VkPipelineRasterizationStateCreateInfo(*copy_src.pRasterizationState);
    else
        pRasterizationState = NULL;
    if (copy_src.pMultisampleState && has_rasterization)
        pMultisampleState = new safe_VkPipelineMultisampleStateCreateInfo(*copy_src.pMultisampleState);
    else
        pMultisampleState = NULL; // original pMultisampleState pointer ignored
    if (copy_src.pDepthStencilState && has_rasterization)
        pDepthStencilState = new safe_VkPipelineDepthStencilStateCreateInfo(*copy_src.pDepthStencilState);
    else
        pDepthStencilState = NULL; // original pDepthStencilState pointer ignored
    if (copy_src.pColorBlendState && has_rasterization)
        pColorBlendState = new safe_VkPipelineColorBlendStateCreateInfo(*copy_src.pColorBlendState);
    else
        pColorBlendState = NULL; // original pColorBlendState pointer ignored
    if (copy_src.pDynamicState)
        pDynamicState = new safe_VkPipelineDynamicStateCreateInfo(*copy_src.pDynamicState);
    else
        pDynamicState = NULL;
}

safe_VkGraphicsPipelineCreateInfo& safe_VkGraphicsPipelineCreateInfo::operator=(const safe_VkGraphicsPipelineCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pStages)
        delete[] pStages;
    if (pVertexInputState)
        delete pVertexInputState;
    if (pInputAssemblyState)
        delete pInputAssemblyState;
    if (pTessellationState)
        delete pTessellationState;
    if (pViewportState)
        delete pViewportState;
    if (pRasterizationState)
        delete pRasterizationState;
    if (pMultisampleState)
        delete pMultisampleState;
    if (pDepthStencilState)
        delete pDepthStencilState;
    if (pColorBlendState)
        delete pColorBlendState;
    if (pDynamicState)
        delete pDynamicState;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    stageCount = copy_src.stageCount;
    pStages = nullptr;
    pVertexInputState = nullptr;
    pInputAssemblyState = nullptr;
    pTessellationState = nullptr;
    pViewportState = nullptr;
    pRasterizationState = nullptr;
    pMultisampleState = nullptr;
    pDepthStencilState = nullptr;
    pColorBlendState = nullptr;
    pDynamicState = nullptr;
    layout = copy_src.layout;
    renderPass = copy_src.renderPass;
    subpass = copy_src.subpass;
    basePipelineHandle = copy_src.basePipelineHandle;
    basePipelineIndex = copy_src.basePipelineIndex;
    pNext = SafePnextCopy(copy_src.pNext);
    if (stageCount && copy_src.pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&copy_src.pStages[i]);
        }
    }
    if (copy_src.pVertexInputState)
        pVertexInputState = new safe_VkPipelineVertexInputStateCreateInfo(*copy_src.pVertexInputState);
    else
        pVertexInputState = NULL;
    if (copy_src.pInputAssemblyState)
        pInputAssemblyState = new safe_VkPipelineInputAssemblyStateCreateInfo(*copy_src.pInputAssemblyState);
    else
        pInputAssemblyState = NULL;
    bool has_tessellation_stage = false;
    if (stageCount && pStages)
        for (uint32_t i = 0; i < stageCount && !has_tessellation_stage; ++i)
            if (pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT || pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)
                has_tessellation_stage = true;
    if (copy_src.pTessellationState && has_tessellation_stage)
        pTessellationState = new safe_VkPipelineTessellationStateCreateInfo(*copy_src.pTessellationState);
    else
        pTessellationState = NULL; // original pTessellationState pointer ignored
    bool is_dynamic_has_rasterization = false;
    if (copy_src.pDynamicState && copy_src.pDynamicState->pDynamicStates) {
        for (uint32_t i = 0; i < copy_src.pDynamicState->dynamicStateCount && !is_dynamic_has_rasterization; ++i)
            if (copy_src.pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT)
                is_dynamic_has_rasterization = true;
    }
    bool has_rasterization = copy_src.pRasterizationState ? (is_dynamic_has_rasterization || !copy_src.pRasterizationState->rasterizerDiscardEnable) : false;
    if (copy_src.pViewportState && has_rasterization) {
        pViewportState = new safe_VkPipelineViewportStateCreateInfo(*copy_src.pViewportState);
    } else
        pViewportState = NULL; // original pViewportState pointer ignored
    if (copy_src.pRasterizationState)
        pRasterizationState = new safe_VkPipelineRasterizationStateCreateInfo(*copy_src.pRasterizationState);
    else
        pRasterizationState = NULL;
    if (copy_src.pMultisampleState && has_rasterization)
        pMultisampleState = new safe_VkPipelineMultisampleStateCreateInfo(*copy_src.pMultisampleState);
    else
        pMultisampleState = NULL; // original pMultisampleState pointer ignored
    if (copy_src.pDepthStencilState && has_rasterization)
        pDepthStencilState = new safe_VkPipelineDepthStencilStateCreateInfo(*copy_src.pDepthStencilState);
    else
        pDepthStencilState = NULL; // original pDepthStencilState pointer ignored
    if (copy_src.pColorBlendState && has_rasterization)
        pColorBlendState = new safe_VkPipelineColorBlendStateCreateInfo(*copy_src.pColorBlendState);
    else
        pColorBlendState = NULL; // original pColorBlendState pointer ignored
    if (copy_src.pDynamicState)
        pDynamicState = new safe_VkPipelineDynamicStateCreateInfo(*copy_src.pDynamicState);
    else
        pDynamicState = NULL;

    return *this;
}

safe_VkGraphicsPipelineCreateInfo::~safe_VkGraphicsPipelineCreateInfo()
{
    if (pStages)
        delete[] pStages;
    if (pVertexInputState)
        delete pVertexInputState;
    if (pInputAssemblyState)
        delete pInputAssemblyState;
    if (pTessellationState)
        delete pTessellationState;
    if (pViewportState)
        delete pViewportState;
    if (pRasterizationState)
        delete pRasterizationState;
    if (pMultisampleState)
        delete pMultisampleState;
    if (pDepthStencilState)
        delete pDepthStencilState;
    if (pColorBlendState)
        delete pColorBlendState;
    if (pDynamicState)
        delete pDynamicState;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkGraphicsPipelineCreateInfo::initialize(const VkGraphicsPipelineCreateInfo* in_struct, const bool uses_color_attachment, const bool uses_depthstencil_attachment)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    stageCount = in_struct->stageCount;
    pStages = nullptr;
    pVertexInputState = nullptr;
    pInputAssemblyState = nullptr;
    pTessellationState = nullptr;
    pViewportState = nullptr;
    pRasterizationState = nullptr;
    pMultisampleState = nullptr;
    pDepthStencilState = nullptr;
    pColorBlendState = nullptr;
    pDynamicState = nullptr;
    layout = in_struct->layout;
    renderPass = in_struct->renderPass;
    subpass = in_struct->subpass;
    basePipelineHandle = in_struct->basePipelineHandle;
    basePipelineIndex = in_struct->basePipelineIndex;
    pNext = SafePnextCopy(in_struct->pNext);
    if (stageCount && in_struct->pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&in_struct->pStages[i]);
        }
    }
    if (in_struct->pVertexInputState)
        pVertexInputState = new safe_VkPipelineVertexInputStateCreateInfo(in_struct->pVertexInputState);
    else
        pVertexInputState = NULL;
    if (in_struct->pInputAssemblyState)
        pInputAssemblyState = new safe_VkPipelineInputAssemblyStateCreateInfo(in_struct->pInputAssemblyState);
    else
        pInputAssemblyState = NULL;
    bool has_tessellation_stage = false;
    if (stageCount && pStages)
        for (uint32_t i = 0; i < stageCount && !has_tessellation_stage; ++i)
            if (pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT || pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)
                has_tessellation_stage = true;
    if (in_struct->pTessellationState && has_tessellation_stage)
        pTessellationState = new safe_VkPipelineTessellationStateCreateInfo(in_struct->pTessellationState);
    else
        pTessellationState = NULL; // original pTessellationState pointer ignored
    bool is_dynamic_has_rasterization = false;
    if (in_struct->pDynamicState && in_struct->pDynamicState->pDynamicStates) {
        for (uint32_t i = 0; i < in_struct->pDynamicState->dynamicStateCount && !is_dynamic_has_rasterization; ++i)
            if (in_struct->pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT)
                is_dynamic_has_rasterization = true;
    }
    bool has_rasterization = in_struct->pRasterizationState ? (is_dynamic_has_rasterization || !in_struct->pRasterizationState->rasterizerDiscardEnable) : false;
    if (in_struct->pViewportState && has_rasterization) {
        bool is_dynamic_viewports = false;
        bool is_dynamic_scissors = false;
        if (in_struct->pDynamicState && in_struct->pDynamicState->pDynamicStates) {
            for (uint32_t i = 0; i < in_struct->pDynamicState->dynamicStateCount && !is_dynamic_viewports; ++i)
                if (in_struct->pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_VIEWPORT)
                    is_dynamic_viewports = true;
            for (uint32_t i = 0; i < in_struct->pDynamicState->dynamicStateCount && !is_dynamic_scissors; ++i)
                if (in_struct->pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_SCISSOR)
                    is_dynamic_scissors = true;
        }
        pViewportState = new safe_VkPipelineViewportStateCreateInfo(in_struct->pViewportState, is_dynamic_viewports, is_dynamic_scissors);
    } else
        pViewportState = NULL; // original pViewportState pointer ignored
    if (in_struct->pRasterizationState)
        pRasterizationState = new safe_VkPipelineRasterizationStateCreateInfo(in_struct->pRasterizationState);
    else
        pRasterizationState = NULL;
    if (in_struct->pMultisampleState && has_rasterization)
        pMultisampleState = new safe_VkPipelineMultisampleStateCreateInfo(in_struct->pMultisampleState);
    else
        pMultisampleState = NULL; // original pMultisampleState pointer ignored
    // needs a tracked subpass state uses_depthstencil_attachment
    if (in_struct->pDepthStencilState && has_rasterization && uses_depthstencil_attachment)
        pDepthStencilState = new safe_VkPipelineDepthStencilStateCreateInfo(in_struct->pDepthStencilState);
    else
        pDepthStencilState = NULL; // original pDepthStencilState pointer ignored
    // needs a tracked subpass state usesColorAttachment
    if (in_struct->pColorBlendState && has_rasterization && uses_color_attachment)
        pColorBlendState = new safe_VkPipelineColorBlendStateCreateInfo(in_struct->pColorBlendState);
    else
        pColorBlendState = NULL; // original pColorBlendState pointer ignored
    if (in_struct->pDynamicState)
        pDynamicState = new safe_VkPipelineDynamicStateCreateInfo(in_struct->pDynamicState);
    else
        pDynamicState = NULL;
}

void safe_VkGraphicsPipelineCreateInfo::initialize(const safe_VkGraphicsPipelineCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    stageCount = copy_src->stageCount;
    pStages = nullptr;
    pVertexInputState = nullptr;
    pInputAssemblyState = nullptr;
    pTessellationState = nullptr;
    pViewportState = nullptr;
    pRasterizationState = nullptr;
    pMultisampleState = nullptr;
    pDepthStencilState = nullptr;
    pColorBlendState = nullptr;
    pDynamicState = nullptr;
    layout = copy_src->layout;
    renderPass = copy_src->renderPass;
    subpass = copy_src->subpass;
    basePipelineHandle = copy_src->basePipelineHandle;
    basePipelineIndex = copy_src->basePipelineIndex;
    pNext = SafePnextCopy(copy_src->pNext);
    if (stageCount && copy_src->pStages) {
        pStages = new safe_VkPipelineShaderStageCreateInfo[stageCount];
        for (uint32_t i = 0; i < stageCount; ++i) {
            pStages[i].initialize(&copy_src->pStages[i]);
        }
    }
    if (copy_src->pVertexInputState)
        pVertexInputState = new safe_VkPipelineVertexInputStateCreateInfo(*copy_src->pVertexInputState);
    else
        pVertexInputState = NULL;
    if (copy_src->pInputAssemblyState)
        pInputAssemblyState = new safe_VkPipelineInputAssemblyStateCreateInfo(*copy_src->pInputAssemblyState);
    else
        pInputAssemblyState = NULL;
    bool has_tessellation_stage = false;
    if (stageCount && pStages)
        for (uint32_t i = 0; i < stageCount && !has_tessellation_stage; ++i)
            if (pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT || pStages[i].stage == VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT)
                has_tessellation_stage = true;
    if (copy_src->pTessellationState && has_tessellation_stage)
        pTessellationState = new safe_VkPipelineTessellationStateCreateInfo(*copy_src->pTessellationState);
    else
        pTessellationState = NULL; // original pTessellationState pointer ignored
    bool is_dynamic_has_rasterization = false;
    if (copy_src->pDynamicState && copy_src->pDynamicState->pDynamicStates) {
        for (uint32_t i = 0; i < copy_src->pDynamicState->dynamicStateCount && !is_dynamic_has_rasterization; ++i)
            if (copy_src->pDynamicState->pDynamicStates[i] == VK_DYNAMIC_STATE_RASTERIZER_DISCARD_ENABLE_EXT)
                is_dynamic_has_rasterization = true;
    }
    bool has_rasterization = copy_src->pRasterizationState ? (is_dynamic_has_rasterization || !copy_src->pRasterizationState->rasterizerDiscardEnable) : false;
    if (copy_src->pViewportState && has_rasterization) {
        pViewportState = new safe_VkPipelineViewportStateCreateInfo(*copy_src->pViewportState);
    } else
        pViewportState = NULL; // original pViewportState pointer ignored
    if (copy_src->pRasterizationState)
        pRasterizationState = new safe_VkPipelineRasterizationStateCreateInfo(*copy_src->pRasterizationState);
    else
        pRasterizationState = NULL;
    if (copy_src->pMultisampleState && has_rasterization)
        pMultisampleState = new safe_VkPipelineMultisampleStateCreateInfo(*copy_src->pMultisampleState);
    else
        pMultisampleState = NULL; // original pMultisampleState pointer ignored
    if (copy_src->pDepthStencilState && has_rasterization)
        pDepthStencilState = new safe_VkPipelineDepthStencilStateCreateInfo(*copy_src->pDepthStencilState);
    else
        pDepthStencilState = NULL; // original pDepthStencilState pointer ignored
    if (copy_src->pColorBlendState && has_rasterization)
        pColorBlendState = new safe_VkPipelineColorBlendStateCreateInfo(*copy_src->pColorBlendState);
    else
        pColorBlendState = NULL; // original pColorBlendState pointer ignored
    if (copy_src->pDynamicState)
        pDynamicState = new safe_VkPipelineDynamicStateCreateInfo(*copy_src->pDynamicState);
    else
        pDynamicState = NULL;
}

safe_VkPipelineLayoutCreateInfo::safe_VkPipelineLayoutCreateInfo(const VkPipelineLayoutCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    setLayoutCount(in_struct->setLayoutCount),
    pSetLayouts(nullptr),
    pushConstantRangeCount(in_struct->pushConstantRangeCount),
    pPushConstantRanges(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (setLayoutCount && in_struct->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[setLayoutCount];
        for (uint32_t i = 0; i < setLayoutCount; ++i) {
            pSetLayouts[i] = in_struct->pSetLayouts[i];
        }
    }
    if (in_struct->pPushConstantRanges) {
        pPushConstantRanges = new VkPushConstantRange[in_struct->pushConstantRangeCount];
        memcpy ((void *)pPushConstantRanges, (void *)in_struct->pPushConstantRanges, sizeof(VkPushConstantRange)*in_struct->pushConstantRangeCount);
    }
}

safe_VkPipelineLayoutCreateInfo::safe_VkPipelineLayoutCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO),
    pNext(nullptr),
    pSetLayouts(nullptr),
    pPushConstantRanges(nullptr)
{}

safe_VkPipelineLayoutCreateInfo::safe_VkPipelineLayoutCreateInfo(const safe_VkPipelineLayoutCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    setLayoutCount = copy_src.setLayoutCount;
    pSetLayouts = nullptr;
    pushConstantRangeCount = copy_src.pushConstantRangeCount;
    pPushConstantRanges = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (setLayoutCount && copy_src.pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[setLayoutCount];
        for (uint32_t i = 0; i < setLayoutCount; ++i) {
            pSetLayouts[i] = copy_src.pSetLayouts[i];
        }
    }
    if (copy_src.pPushConstantRanges) {
        pPushConstantRanges = new VkPushConstantRange[copy_src.pushConstantRangeCount];
        memcpy ((void *)pPushConstantRanges, (void *)copy_src.pPushConstantRanges, sizeof(VkPushConstantRange)*copy_src.pushConstantRangeCount);
    }
}

safe_VkPipelineLayoutCreateInfo& safe_VkPipelineLayoutCreateInfo::operator=(const safe_VkPipelineLayoutCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pSetLayouts)
        delete[] pSetLayouts;
    if (pPushConstantRanges)
        delete[] pPushConstantRanges;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    setLayoutCount = copy_src.setLayoutCount;
    pSetLayouts = nullptr;
    pushConstantRangeCount = copy_src.pushConstantRangeCount;
    pPushConstantRanges = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (setLayoutCount && copy_src.pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[setLayoutCount];
        for (uint32_t i = 0; i < setLayoutCount; ++i) {
            pSetLayouts[i] = copy_src.pSetLayouts[i];
        }
    }
    if (copy_src.pPushConstantRanges) {
        pPushConstantRanges = new VkPushConstantRange[copy_src.pushConstantRangeCount];
        memcpy ((void *)pPushConstantRanges, (void *)copy_src.pPushConstantRanges, sizeof(VkPushConstantRange)*copy_src.pushConstantRangeCount);
    }

    return *this;
}

safe_VkPipelineLayoutCreateInfo::~safe_VkPipelineLayoutCreateInfo()
{
    if (pSetLayouts)
        delete[] pSetLayouts;
    if (pPushConstantRanges)
        delete[] pPushConstantRanges;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineLayoutCreateInfo::initialize(const VkPipelineLayoutCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    setLayoutCount = in_struct->setLayoutCount;
    pSetLayouts = nullptr;
    pushConstantRangeCount = in_struct->pushConstantRangeCount;
    pPushConstantRanges = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (setLayoutCount && in_struct->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[setLayoutCount];
        for (uint32_t i = 0; i < setLayoutCount; ++i) {
            pSetLayouts[i] = in_struct->pSetLayouts[i];
        }
    }
    if (in_struct->pPushConstantRanges) {
        pPushConstantRanges = new VkPushConstantRange[in_struct->pushConstantRangeCount];
        memcpy ((void *)pPushConstantRanges, (void *)in_struct->pPushConstantRanges, sizeof(VkPushConstantRange)*in_struct->pushConstantRangeCount);
    }
}

void safe_VkPipelineLayoutCreateInfo::initialize(const safe_VkPipelineLayoutCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    setLayoutCount = copy_src->setLayoutCount;
    pSetLayouts = nullptr;
    pushConstantRangeCount = copy_src->pushConstantRangeCount;
    pPushConstantRanges = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (setLayoutCount && copy_src->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[setLayoutCount];
        for (uint32_t i = 0; i < setLayoutCount; ++i) {
            pSetLayouts[i] = copy_src->pSetLayouts[i];
        }
    }
    if (copy_src->pPushConstantRanges) {
        pPushConstantRanges = new VkPushConstantRange[copy_src->pushConstantRangeCount];
        memcpy ((void *)pPushConstantRanges, (void *)copy_src->pPushConstantRanges, sizeof(VkPushConstantRange)*copy_src->pushConstantRangeCount);
    }
}

safe_VkSamplerCreateInfo::safe_VkSamplerCreateInfo(const VkSamplerCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    magFilter(in_struct->magFilter),
    minFilter(in_struct->minFilter),
    mipmapMode(in_struct->mipmapMode),
    addressModeU(in_struct->addressModeU),
    addressModeV(in_struct->addressModeV),
    addressModeW(in_struct->addressModeW),
    mipLodBias(in_struct->mipLodBias),
    anisotropyEnable(in_struct->anisotropyEnable),
    maxAnisotropy(in_struct->maxAnisotropy),
    compareEnable(in_struct->compareEnable),
    compareOp(in_struct->compareOp),
    minLod(in_struct->minLod),
    maxLod(in_struct->maxLod),
    borderColor(in_struct->borderColor),
    unnormalizedCoordinates(in_struct->unnormalizedCoordinates)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSamplerCreateInfo::safe_VkSamplerCreateInfo() :
    sType(VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkSamplerCreateInfo::safe_VkSamplerCreateInfo(const safe_VkSamplerCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    magFilter = copy_src.magFilter;
    minFilter = copy_src.minFilter;
    mipmapMode = copy_src.mipmapMode;
    addressModeU = copy_src.addressModeU;
    addressModeV = copy_src.addressModeV;
    addressModeW = copy_src.addressModeW;
    mipLodBias = copy_src.mipLodBias;
    anisotropyEnable = copy_src.anisotropyEnable;
    maxAnisotropy = copy_src.maxAnisotropy;
    compareEnable = copy_src.compareEnable;
    compareOp = copy_src.compareOp;
    minLod = copy_src.minLod;
    maxLod = copy_src.maxLod;
    borderColor = copy_src.borderColor;
    unnormalizedCoordinates = copy_src.unnormalizedCoordinates;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSamplerCreateInfo& safe_VkSamplerCreateInfo::operator=(const safe_VkSamplerCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    magFilter = copy_src.magFilter;
    minFilter = copy_src.minFilter;
    mipmapMode = copy_src.mipmapMode;
    addressModeU = copy_src.addressModeU;
    addressModeV = copy_src.addressModeV;
    addressModeW = copy_src.addressModeW;
    mipLodBias = copy_src.mipLodBias;
    anisotropyEnable = copy_src.anisotropyEnable;
    maxAnisotropy = copy_src.maxAnisotropy;
    compareEnable = copy_src.compareEnable;
    compareOp = copy_src.compareOp;
    minLod = copy_src.minLod;
    maxLod = copy_src.maxLod;
    borderColor = copy_src.borderColor;
    unnormalizedCoordinates = copy_src.unnormalizedCoordinates;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSamplerCreateInfo::~safe_VkSamplerCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSamplerCreateInfo::initialize(const VkSamplerCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    magFilter = in_struct->magFilter;
    minFilter = in_struct->minFilter;
    mipmapMode = in_struct->mipmapMode;
    addressModeU = in_struct->addressModeU;
    addressModeV = in_struct->addressModeV;
    addressModeW = in_struct->addressModeW;
    mipLodBias = in_struct->mipLodBias;
    anisotropyEnable = in_struct->anisotropyEnable;
    maxAnisotropy = in_struct->maxAnisotropy;
    compareEnable = in_struct->compareEnable;
    compareOp = in_struct->compareOp;
    minLod = in_struct->minLod;
    maxLod = in_struct->maxLod;
    borderColor = in_struct->borderColor;
    unnormalizedCoordinates = in_struct->unnormalizedCoordinates;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSamplerCreateInfo::initialize(const safe_VkSamplerCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    magFilter = copy_src->magFilter;
    minFilter = copy_src->minFilter;
    mipmapMode = copy_src->mipmapMode;
    addressModeU = copy_src->addressModeU;
    addressModeV = copy_src->addressModeV;
    addressModeW = copy_src->addressModeW;
    mipLodBias = copy_src->mipLodBias;
    anisotropyEnable = copy_src->anisotropyEnable;
    maxAnisotropy = copy_src->maxAnisotropy;
    compareEnable = copy_src->compareEnable;
    compareOp = copy_src->compareOp;
    minLod = copy_src->minLod;
    maxLod = copy_src->maxLod;
    borderColor = copy_src->borderColor;
    unnormalizedCoordinates = copy_src->unnormalizedCoordinates;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkCopyDescriptorSet::safe_VkCopyDescriptorSet(const VkCopyDescriptorSet* in_struct) :
    sType(in_struct->sType),
    srcSet(in_struct->srcSet),
    srcBinding(in_struct->srcBinding),
    srcArrayElement(in_struct->srcArrayElement),
    dstSet(in_struct->dstSet),
    dstBinding(in_struct->dstBinding),
    dstArrayElement(in_struct->dstArrayElement),
    descriptorCount(in_struct->descriptorCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCopyDescriptorSet::safe_VkCopyDescriptorSet() :
    sType(VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET),
    pNext(nullptr)
{}

safe_VkCopyDescriptorSet::safe_VkCopyDescriptorSet(const safe_VkCopyDescriptorSet& copy_src)
{
    sType = copy_src.sType;
    srcSet = copy_src.srcSet;
    srcBinding = copy_src.srcBinding;
    srcArrayElement = copy_src.srcArrayElement;
    dstSet = copy_src.dstSet;
    dstBinding = copy_src.dstBinding;
    dstArrayElement = copy_src.dstArrayElement;
    descriptorCount = copy_src.descriptorCount;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkCopyDescriptorSet& safe_VkCopyDescriptorSet::operator=(const safe_VkCopyDescriptorSet& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcSet = copy_src.srcSet;
    srcBinding = copy_src.srcBinding;
    srcArrayElement = copy_src.srcArrayElement;
    dstSet = copy_src.dstSet;
    dstBinding = copy_src.dstBinding;
    dstArrayElement = copy_src.dstArrayElement;
    descriptorCount = copy_src.descriptorCount;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkCopyDescriptorSet::~safe_VkCopyDescriptorSet()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCopyDescriptorSet::initialize(const VkCopyDescriptorSet* in_struct)
{
    sType = in_struct->sType;
    srcSet = in_struct->srcSet;
    srcBinding = in_struct->srcBinding;
    srcArrayElement = in_struct->srcArrayElement;
    dstSet = in_struct->dstSet;
    dstBinding = in_struct->dstBinding;
    dstArrayElement = in_struct->dstArrayElement;
    descriptorCount = in_struct->descriptorCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCopyDescriptorSet::initialize(const safe_VkCopyDescriptorSet* copy_src)
{
    sType = copy_src->sType;
    srcSet = copy_src->srcSet;
    srcBinding = copy_src->srcBinding;
    srcArrayElement = copy_src->srcArrayElement;
    dstSet = copy_src->dstSet;
    dstBinding = copy_src->dstBinding;
    dstArrayElement = copy_src->dstArrayElement;
    descriptorCount = copy_src->descriptorCount;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDescriptorPoolCreateInfo::safe_VkDescriptorPoolCreateInfo(const VkDescriptorPoolCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    maxSets(in_struct->maxSets),
    poolSizeCount(in_struct->poolSizeCount),
    pPoolSizes(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPoolSizes) {
        pPoolSizes = new VkDescriptorPoolSize[in_struct->poolSizeCount];
        memcpy ((void *)pPoolSizes, (void *)in_struct->pPoolSizes, sizeof(VkDescriptorPoolSize)*in_struct->poolSizeCount);
    }
}

safe_VkDescriptorPoolCreateInfo::safe_VkDescriptorPoolCreateInfo() :
    sType(VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO),
    pNext(nullptr),
    pPoolSizes(nullptr)
{}

safe_VkDescriptorPoolCreateInfo::safe_VkDescriptorPoolCreateInfo(const safe_VkDescriptorPoolCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    maxSets = copy_src.maxSets;
    poolSizeCount = copy_src.poolSizeCount;
    pPoolSizes = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pPoolSizes) {
        pPoolSizes = new VkDescriptorPoolSize[copy_src.poolSizeCount];
        memcpy ((void *)pPoolSizes, (void *)copy_src.pPoolSizes, sizeof(VkDescriptorPoolSize)*copy_src.poolSizeCount);
    }
}

safe_VkDescriptorPoolCreateInfo& safe_VkDescriptorPoolCreateInfo::operator=(const safe_VkDescriptorPoolCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pPoolSizes)
        delete[] pPoolSizes;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    maxSets = copy_src.maxSets;
    poolSizeCount = copy_src.poolSizeCount;
    pPoolSizes = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pPoolSizes) {
        pPoolSizes = new VkDescriptorPoolSize[copy_src.poolSizeCount];
        memcpy ((void *)pPoolSizes, (void *)copy_src.pPoolSizes, sizeof(VkDescriptorPoolSize)*copy_src.poolSizeCount);
    }

    return *this;
}

safe_VkDescriptorPoolCreateInfo::~safe_VkDescriptorPoolCreateInfo()
{
    if (pPoolSizes)
        delete[] pPoolSizes;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorPoolCreateInfo::initialize(const VkDescriptorPoolCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    maxSets = in_struct->maxSets;
    poolSizeCount = in_struct->poolSizeCount;
    pPoolSizes = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPoolSizes) {
        pPoolSizes = new VkDescriptorPoolSize[in_struct->poolSizeCount];
        memcpy ((void *)pPoolSizes, (void *)in_struct->pPoolSizes, sizeof(VkDescriptorPoolSize)*in_struct->poolSizeCount);
    }
}

void safe_VkDescriptorPoolCreateInfo::initialize(const safe_VkDescriptorPoolCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    maxSets = copy_src->maxSets;
    poolSizeCount = copy_src->poolSizeCount;
    pPoolSizes = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pPoolSizes) {
        pPoolSizes = new VkDescriptorPoolSize[copy_src->poolSizeCount];
        memcpy ((void *)pPoolSizes, (void *)copy_src->pPoolSizes, sizeof(VkDescriptorPoolSize)*copy_src->poolSizeCount);
    }
}

safe_VkDescriptorSetAllocateInfo::safe_VkDescriptorSetAllocateInfo(const VkDescriptorSetAllocateInfo* in_struct) :
    sType(in_struct->sType),
    descriptorPool(in_struct->descriptorPool),
    descriptorSetCount(in_struct->descriptorSetCount),
    pSetLayouts(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (descriptorSetCount && in_struct->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[descriptorSetCount];
        for (uint32_t i = 0; i < descriptorSetCount; ++i) {
            pSetLayouts[i] = in_struct->pSetLayouts[i];
        }
    }
}

safe_VkDescriptorSetAllocateInfo::safe_VkDescriptorSetAllocateInfo() :
    sType(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO),
    pNext(nullptr),
    pSetLayouts(nullptr)
{}

safe_VkDescriptorSetAllocateInfo::safe_VkDescriptorSetAllocateInfo(const safe_VkDescriptorSetAllocateInfo& copy_src)
{
    sType = copy_src.sType;
    descriptorPool = copy_src.descriptorPool;
    descriptorSetCount = copy_src.descriptorSetCount;
    pSetLayouts = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (descriptorSetCount && copy_src.pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[descriptorSetCount];
        for (uint32_t i = 0; i < descriptorSetCount; ++i) {
            pSetLayouts[i] = copy_src.pSetLayouts[i];
        }
    }
}

safe_VkDescriptorSetAllocateInfo& safe_VkDescriptorSetAllocateInfo::operator=(const safe_VkDescriptorSetAllocateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pSetLayouts)
        delete[] pSetLayouts;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    descriptorPool = copy_src.descriptorPool;
    descriptorSetCount = copy_src.descriptorSetCount;
    pSetLayouts = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (descriptorSetCount && copy_src.pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[descriptorSetCount];
        for (uint32_t i = 0; i < descriptorSetCount; ++i) {
            pSetLayouts[i] = copy_src.pSetLayouts[i];
        }
    }

    return *this;
}

safe_VkDescriptorSetAllocateInfo::~safe_VkDescriptorSetAllocateInfo()
{
    if (pSetLayouts)
        delete[] pSetLayouts;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetAllocateInfo::initialize(const VkDescriptorSetAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    descriptorPool = in_struct->descriptorPool;
    descriptorSetCount = in_struct->descriptorSetCount;
    pSetLayouts = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (descriptorSetCount && in_struct->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[descriptorSetCount];
        for (uint32_t i = 0; i < descriptorSetCount; ++i) {
            pSetLayouts[i] = in_struct->pSetLayouts[i];
        }
    }
}

void safe_VkDescriptorSetAllocateInfo::initialize(const safe_VkDescriptorSetAllocateInfo* copy_src)
{
    sType = copy_src->sType;
    descriptorPool = copy_src->descriptorPool;
    descriptorSetCount = copy_src->descriptorSetCount;
    pSetLayouts = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (descriptorSetCount && copy_src->pSetLayouts) {
        pSetLayouts = new VkDescriptorSetLayout[descriptorSetCount];
        for (uint32_t i = 0; i < descriptorSetCount; ++i) {
            pSetLayouts[i] = copy_src->pSetLayouts[i];
        }
    }
}

safe_VkDescriptorSetLayoutBinding::safe_VkDescriptorSetLayoutBinding(const VkDescriptorSetLayoutBinding* in_struct) :
    binding(in_struct->binding),
    descriptorType(in_struct->descriptorType),
    descriptorCount(in_struct->descriptorCount),
    stageFlags(in_struct->stageFlags),
    pImmutableSamplers(nullptr)
{
    const bool sampler_type = in_struct->descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER || in_struct->descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER;
    if (descriptorCount && in_struct->pImmutableSamplers && sampler_type) {
        pImmutableSamplers = new VkSampler[descriptorCount];
        for (uint32_t i = 0; i < descriptorCount; ++i) {
            pImmutableSamplers[i] = in_struct->pImmutableSamplers[i];
        }
    }
}

safe_VkDescriptorSetLayoutBinding::safe_VkDescriptorSetLayoutBinding() :
    pImmutableSamplers(nullptr)
{}

safe_VkDescriptorSetLayoutBinding::safe_VkDescriptorSetLayoutBinding(const safe_VkDescriptorSetLayoutBinding& copy_src)
{
    binding = copy_src.binding;
    descriptorType = copy_src.descriptorType;
    descriptorCount = copy_src.descriptorCount;
    stageFlags = copy_src.stageFlags;
    pImmutableSamplers = nullptr;
    const bool sampler_type = copy_src.descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER || copy_src.descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER;
    if (descriptorCount && copy_src.pImmutableSamplers && sampler_type) {
        pImmutableSamplers = new VkSampler[descriptorCount];
        for (uint32_t i = 0; i < descriptorCount; ++i) {
            pImmutableSamplers[i] = copy_src.pImmutableSamplers[i];
        }
    }
}

safe_VkDescriptorSetLayoutBinding& safe_VkDescriptorSetLayoutBinding::operator=(const safe_VkDescriptorSetLayoutBinding& copy_src)
{
    if (&copy_src == this) return *this;

    if (pImmutableSamplers)
        delete[] pImmutableSamplers;

    binding = copy_src.binding;
    descriptorType = copy_src.descriptorType;
    descriptorCount = copy_src.descriptorCount;
    stageFlags = copy_src.stageFlags;
    pImmutableSamplers = nullptr;
    const bool sampler_type = copy_src.descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER || copy_src.descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER;
    if (descriptorCount && copy_src.pImmutableSamplers && sampler_type) {
        pImmutableSamplers = new VkSampler[descriptorCount];
        for (uint32_t i = 0; i < descriptorCount; ++i) {
            pImmutableSamplers[i] = copy_src.pImmutableSamplers[i];
        }
    }

    return *this;
}

safe_VkDescriptorSetLayoutBinding::~safe_VkDescriptorSetLayoutBinding()
{
    if (pImmutableSamplers)
        delete[] pImmutableSamplers;
}

void safe_VkDescriptorSetLayoutBinding::initialize(const VkDescriptorSetLayoutBinding* in_struct)
{
    binding = in_struct->binding;
    descriptorType = in_struct->descriptorType;
    descriptorCount = in_struct->descriptorCount;
    stageFlags = in_struct->stageFlags;
    pImmutableSamplers = nullptr;
    const bool sampler_type = in_struct->descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER || in_struct->descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER;
    if (descriptorCount && in_struct->pImmutableSamplers && sampler_type) {
        pImmutableSamplers = new VkSampler[descriptorCount];
        for (uint32_t i = 0; i < descriptorCount; ++i) {
            pImmutableSamplers[i] = in_struct->pImmutableSamplers[i];
        }
    }
}

void safe_VkDescriptorSetLayoutBinding::initialize(const safe_VkDescriptorSetLayoutBinding* copy_src)
{
    binding = copy_src->binding;
    descriptorType = copy_src->descriptorType;
    descriptorCount = copy_src->descriptorCount;
    stageFlags = copy_src->stageFlags;
    pImmutableSamplers = nullptr;
    const bool sampler_type = copy_src->descriptorType == VK_DESCRIPTOR_TYPE_SAMPLER || copy_src->descriptorType == VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER;
    if (descriptorCount && copy_src->pImmutableSamplers && sampler_type) {
        pImmutableSamplers = new VkSampler[descriptorCount];
        for (uint32_t i = 0; i < descriptorCount; ++i) {
            pImmutableSamplers[i] = copy_src->pImmutableSamplers[i];
        }
    }
}

safe_VkDescriptorSetLayoutCreateInfo::safe_VkDescriptorSetLayoutCreateInfo(const VkDescriptorSetLayoutCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    bindingCount(in_struct->bindingCount),
    pBindings(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (bindingCount && in_struct->pBindings) {
        pBindings = new safe_VkDescriptorSetLayoutBinding[bindingCount];
        for (uint32_t i = 0; i < bindingCount; ++i) {
            pBindings[i].initialize(&in_struct->pBindings[i]);
        }
    }
}

safe_VkDescriptorSetLayoutCreateInfo::safe_VkDescriptorSetLayoutCreateInfo() :
    sType(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO),
    pNext(nullptr),
    pBindings(nullptr)
{}

safe_VkDescriptorSetLayoutCreateInfo::safe_VkDescriptorSetLayoutCreateInfo(const safe_VkDescriptorSetLayoutCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    bindingCount = copy_src.bindingCount;
    pBindings = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (bindingCount && copy_src.pBindings) {
        pBindings = new safe_VkDescriptorSetLayoutBinding[bindingCount];
        for (uint32_t i = 0; i < bindingCount; ++i) {
            pBindings[i].initialize(&copy_src.pBindings[i]);
        }
    }
}

safe_VkDescriptorSetLayoutCreateInfo& safe_VkDescriptorSetLayoutCreateInfo::operator=(const safe_VkDescriptorSetLayoutCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pBindings)
        delete[] pBindings;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    bindingCount = copy_src.bindingCount;
    pBindings = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (bindingCount && copy_src.pBindings) {
        pBindings = new safe_VkDescriptorSetLayoutBinding[bindingCount];
        for (uint32_t i = 0; i < bindingCount; ++i) {
            pBindings[i].initialize(&copy_src.pBindings[i]);
        }
    }

    return *this;
}

safe_VkDescriptorSetLayoutCreateInfo::~safe_VkDescriptorSetLayoutCreateInfo()
{
    if (pBindings)
        delete[] pBindings;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetLayoutCreateInfo::initialize(const VkDescriptorSetLayoutCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    bindingCount = in_struct->bindingCount;
    pBindings = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (bindingCount && in_struct->pBindings) {
        pBindings = new safe_VkDescriptorSetLayoutBinding[bindingCount];
        for (uint32_t i = 0; i < bindingCount; ++i) {
            pBindings[i].initialize(&in_struct->pBindings[i]);
        }
    }
}

void safe_VkDescriptorSetLayoutCreateInfo::initialize(const safe_VkDescriptorSetLayoutCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    bindingCount = copy_src->bindingCount;
    pBindings = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (bindingCount && copy_src->pBindings) {
        pBindings = new safe_VkDescriptorSetLayoutBinding[bindingCount];
        for (uint32_t i = 0; i < bindingCount; ++i) {
            pBindings[i].initialize(&copy_src->pBindings[i]);
        }
    }
}

safe_VkWriteDescriptorSet::safe_VkWriteDescriptorSet(const VkWriteDescriptorSet* in_struct) :
    sType(in_struct->sType),
    dstSet(in_struct->dstSet),
    dstBinding(in_struct->dstBinding),
    dstArrayElement(in_struct->dstArrayElement),
    descriptorCount(in_struct->descriptorCount),
    descriptorType(in_struct->descriptorType),
    pImageInfo(nullptr),
    pBufferInfo(nullptr),
    pTexelBufferView(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    switch (descriptorType) {
        case VK_DESCRIPTOR_TYPE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        if (descriptorCount && in_struct->pImageInfo) {
            pImageInfo = new VkDescriptorImageInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pImageInfo[i] = in_struct->pImageInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC:
        if (descriptorCount && in_struct->pBufferInfo) {
            pBufferInfo = new VkDescriptorBufferInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pBufferInfo[i] = in_struct->pBufferInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        if (descriptorCount && in_struct->pTexelBufferView) {
            pTexelBufferView = new VkBufferView[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pTexelBufferView[i] = in_struct->pTexelBufferView[i];
            }
        }
        break;
        default:
        break;
    }
}

safe_VkWriteDescriptorSet::safe_VkWriteDescriptorSet() :
    sType(VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET),
    pNext(nullptr),
    pImageInfo(nullptr),
    pBufferInfo(nullptr),
    pTexelBufferView(nullptr)
{}

safe_VkWriteDescriptorSet::safe_VkWriteDescriptorSet(const safe_VkWriteDescriptorSet& copy_src)
{
    sType = copy_src.sType;
    dstSet = copy_src.dstSet;
    dstBinding = copy_src.dstBinding;
    dstArrayElement = copy_src.dstArrayElement;
    descriptorCount = copy_src.descriptorCount;
    descriptorType = copy_src.descriptorType;
    pImageInfo = nullptr;
    pBufferInfo = nullptr;
    pTexelBufferView = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    switch (descriptorType) {
        case VK_DESCRIPTOR_TYPE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        if (descriptorCount && copy_src.pImageInfo) {
            pImageInfo = new VkDescriptorImageInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pImageInfo[i] = copy_src.pImageInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC:
        if (descriptorCount && copy_src.pBufferInfo) {
            pBufferInfo = new VkDescriptorBufferInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pBufferInfo[i] = copy_src.pBufferInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        if (descriptorCount && copy_src.pTexelBufferView) {
            pTexelBufferView = new VkBufferView[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pTexelBufferView[i] = copy_src.pTexelBufferView[i];
            }
        }
        break;
        default:
        break;
    }
}

safe_VkWriteDescriptorSet& safe_VkWriteDescriptorSet::operator=(const safe_VkWriteDescriptorSet& copy_src)
{
    if (&copy_src == this) return *this;

    if (pImageInfo)
        delete[] pImageInfo;
    if (pBufferInfo)
        delete[] pBufferInfo;
    if (pTexelBufferView)
        delete[] pTexelBufferView;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    dstSet = copy_src.dstSet;
    dstBinding = copy_src.dstBinding;
    dstArrayElement = copy_src.dstArrayElement;
    descriptorCount = copy_src.descriptorCount;
    descriptorType = copy_src.descriptorType;
    pImageInfo = nullptr;
    pBufferInfo = nullptr;
    pTexelBufferView = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    switch (descriptorType) {
        case VK_DESCRIPTOR_TYPE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        if (descriptorCount && copy_src.pImageInfo) {
            pImageInfo = new VkDescriptorImageInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pImageInfo[i] = copy_src.pImageInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC:
        if (descriptorCount && copy_src.pBufferInfo) {
            pBufferInfo = new VkDescriptorBufferInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pBufferInfo[i] = copy_src.pBufferInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        if (descriptorCount && copy_src.pTexelBufferView) {
            pTexelBufferView = new VkBufferView[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pTexelBufferView[i] = copy_src.pTexelBufferView[i];
            }
        }
        break;
        default:
        break;
    }

    return *this;
}

safe_VkWriteDescriptorSet::~safe_VkWriteDescriptorSet()
{
    if (pImageInfo)
        delete[] pImageInfo;
    if (pBufferInfo)
        delete[] pBufferInfo;
    if (pTexelBufferView)
        delete[] pTexelBufferView;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkWriteDescriptorSet::initialize(const VkWriteDescriptorSet* in_struct)
{
    sType = in_struct->sType;
    dstSet = in_struct->dstSet;
    dstBinding = in_struct->dstBinding;
    dstArrayElement = in_struct->dstArrayElement;
    descriptorCount = in_struct->descriptorCount;
    descriptorType = in_struct->descriptorType;
    pImageInfo = nullptr;
    pBufferInfo = nullptr;
    pTexelBufferView = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    switch (descriptorType) {
        case VK_DESCRIPTOR_TYPE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        if (descriptorCount && in_struct->pImageInfo) {
            pImageInfo = new VkDescriptorImageInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pImageInfo[i] = in_struct->pImageInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC:
        if (descriptorCount && in_struct->pBufferInfo) {
            pBufferInfo = new VkDescriptorBufferInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pBufferInfo[i] = in_struct->pBufferInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        if (descriptorCount && in_struct->pTexelBufferView) {
            pTexelBufferView = new VkBufferView[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pTexelBufferView[i] = in_struct->pTexelBufferView[i];
            }
        }
        break;
        default:
        break;
    }
}

void safe_VkWriteDescriptorSet::initialize(const safe_VkWriteDescriptorSet* copy_src)
{
    sType = copy_src->sType;
    dstSet = copy_src->dstSet;
    dstBinding = copy_src->dstBinding;
    dstArrayElement = copy_src->dstArrayElement;
    descriptorCount = copy_src->descriptorCount;
    descriptorType = copy_src->descriptorType;
    pImageInfo = nullptr;
    pBufferInfo = nullptr;
    pTexelBufferView = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    switch (descriptorType) {
        case VK_DESCRIPTOR_TYPE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER:
        case VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE:
        case VK_DESCRIPTOR_TYPE_STORAGE_IMAGE:
        case VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT:
        if (descriptorCount && copy_src->pImageInfo) {
            pImageInfo = new VkDescriptorImageInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pImageInfo[i] = copy_src->pImageInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER:
        case VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC:
        case VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC:
        if (descriptorCount && copy_src->pBufferInfo) {
            pBufferInfo = new VkDescriptorBufferInfo[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pBufferInfo[i] = copy_src->pBufferInfo[i];
            }
        }
        break;
        case VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER:
        case VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER:
        if (descriptorCount && copy_src->pTexelBufferView) {
            pTexelBufferView = new VkBufferView[descriptorCount];
            for (uint32_t i = 0; i < descriptorCount; ++i) {
                pTexelBufferView[i] = copy_src->pTexelBufferView[i];
            }
        }
        break;
        default:
        break;
    }
}

safe_VkFramebufferCreateInfo::safe_VkFramebufferCreateInfo(const VkFramebufferCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    renderPass(in_struct->renderPass),
    attachmentCount(in_struct->attachmentCount),
    pAttachments(nullptr),
    width(in_struct->width),
    height(in_struct->height),
    layers(in_struct->layers)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments && !(flags & VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT)) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = in_struct->pAttachments[i];
        }
    }
}

safe_VkFramebufferCreateInfo::safe_VkFramebufferCreateInfo() :
    sType(VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO),
    pNext(nullptr),
    pAttachments(nullptr)
{}

safe_VkFramebufferCreateInfo::safe_VkFramebufferCreateInfo(const safe_VkFramebufferCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    renderPass = copy_src.renderPass;
    attachmentCount = copy_src.attachmentCount;
    pAttachments = nullptr;
    width = copy_src.width;
    height = copy_src.height;
    layers = copy_src.layers;
    pNext = SafePnextCopy(copy_src.pNext);
    if (attachmentCount && copy_src.pAttachments && !(flags & VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT)) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = copy_src.pAttachments[i];
        }
    }
}

safe_VkFramebufferCreateInfo& safe_VkFramebufferCreateInfo::operator=(const safe_VkFramebufferCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    renderPass = copy_src.renderPass;
    attachmentCount = copy_src.attachmentCount;
    pAttachments = nullptr;
    width = copy_src.width;
    height = copy_src.height;
    layers = copy_src.layers;
    pNext = SafePnextCopy(copy_src.pNext);
    if (attachmentCount && copy_src.pAttachments && !(flags & VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT)) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = copy_src.pAttachments[i];
        }
    }

    return *this;
}

safe_VkFramebufferCreateInfo::~safe_VkFramebufferCreateInfo()
{
    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFramebufferCreateInfo::initialize(const VkFramebufferCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    renderPass = in_struct->renderPass;
    attachmentCount = in_struct->attachmentCount;
    pAttachments = nullptr;
    width = in_struct->width;
    height = in_struct->height;
    layers = in_struct->layers;
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments && !(flags & VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT)) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = in_struct->pAttachments[i];
        }
    }
}

void safe_VkFramebufferCreateInfo::initialize(const safe_VkFramebufferCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    renderPass = copy_src->renderPass;
    attachmentCount = copy_src->attachmentCount;
    pAttachments = nullptr;
    width = copy_src->width;
    height = copy_src->height;
    layers = copy_src->layers;
    pNext = SafePnextCopy(copy_src->pNext);
    if (attachmentCount && copy_src->pAttachments && !(flags & VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT)) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = copy_src->pAttachments[i];
        }
    }
}

safe_VkSubpassDescription::safe_VkSubpassDescription(const VkSubpassDescription* in_struct) :
    flags(in_struct->flags),
    pipelineBindPoint(in_struct->pipelineBindPoint),
    inputAttachmentCount(in_struct->inputAttachmentCount),
    pInputAttachments(nullptr),
    colorAttachmentCount(in_struct->colorAttachmentCount),
    pColorAttachments(nullptr),
    pResolveAttachments(nullptr),
    pDepthStencilAttachment(nullptr),
    preserveAttachmentCount(in_struct->preserveAttachmentCount),
    pPreserveAttachments(nullptr)
{
    if (in_struct->pInputAttachments) {
        pInputAttachments = new VkAttachmentReference[in_struct->inputAttachmentCount];
        memcpy ((void *)pInputAttachments, (void *)in_struct->pInputAttachments, sizeof(VkAttachmentReference)*in_struct->inputAttachmentCount);
    }
    if (in_struct->pColorAttachments) {
        pColorAttachments = new VkAttachmentReference[in_struct->colorAttachmentCount];
        memcpy ((void *)pColorAttachments, (void *)in_struct->pColorAttachments, sizeof(VkAttachmentReference)*in_struct->colorAttachmentCount);
    }
    if (in_struct->pResolveAttachments) {
        pResolveAttachments = new VkAttachmentReference[in_struct->colorAttachmentCount];
        memcpy ((void *)pResolveAttachments, (void *)in_struct->pResolveAttachments, sizeof(VkAttachmentReference)*in_struct->colorAttachmentCount);
    }
    if (in_struct->pDepthStencilAttachment) {
        pDepthStencilAttachment = new VkAttachmentReference(*in_struct->pDepthStencilAttachment);
    }
    if (in_struct->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[in_struct->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)in_struct->pPreserveAttachments, sizeof(uint32_t)*in_struct->preserveAttachmentCount);
    }
}

safe_VkSubpassDescription::safe_VkSubpassDescription() :
    pInputAttachments(nullptr),
    pColorAttachments(nullptr),
    pResolveAttachments(nullptr),
    pDepthStencilAttachment(nullptr),
    pPreserveAttachments(nullptr)
{}

safe_VkSubpassDescription::safe_VkSubpassDescription(const safe_VkSubpassDescription& copy_src)
{
    flags = copy_src.flags;
    pipelineBindPoint = copy_src.pipelineBindPoint;
    inputAttachmentCount = copy_src.inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = copy_src.colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = copy_src.preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    if (copy_src.pInputAttachments) {
        pInputAttachments = new VkAttachmentReference[copy_src.inputAttachmentCount];
        memcpy ((void *)pInputAttachments, (void *)copy_src.pInputAttachments, sizeof(VkAttachmentReference)*copy_src.inputAttachmentCount);
    }
    if (copy_src.pColorAttachments) {
        pColorAttachments = new VkAttachmentReference[copy_src.colorAttachmentCount];
        memcpy ((void *)pColorAttachments, (void *)copy_src.pColorAttachments, sizeof(VkAttachmentReference)*copy_src.colorAttachmentCount);
    }
    if (copy_src.pResolveAttachments) {
        pResolveAttachments = new VkAttachmentReference[copy_src.colorAttachmentCount];
        memcpy ((void *)pResolveAttachments, (void *)copy_src.pResolveAttachments, sizeof(VkAttachmentReference)*copy_src.colorAttachmentCount);
    }
    if (copy_src.pDepthStencilAttachment) {
        pDepthStencilAttachment = new VkAttachmentReference(*copy_src.pDepthStencilAttachment);
    }
    if (copy_src.pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[copy_src.preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)copy_src.pPreserveAttachments, sizeof(uint32_t)*copy_src.preserveAttachmentCount);
    }
}

safe_VkSubpassDescription& safe_VkSubpassDescription::operator=(const safe_VkSubpassDescription& copy_src)
{
    if (&copy_src == this) return *this;

    if (pInputAttachments)
        delete[] pInputAttachments;
    if (pColorAttachments)
        delete[] pColorAttachments;
    if (pResolveAttachments)
        delete[] pResolveAttachments;
    if (pDepthStencilAttachment)
        delete pDepthStencilAttachment;
    if (pPreserveAttachments)
        delete[] pPreserveAttachments;

    flags = copy_src.flags;
    pipelineBindPoint = copy_src.pipelineBindPoint;
    inputAttachmentCount = copy_src.inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = copy_src.colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = copy_src.preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    if (copy_src.pInputAttachments) {
        pInputAttachments = new VkAttachmentReference[copy_src.inputAttachmentCount];
        memcpy ((void *)pInputAttachments, (void *)copy_src.pInputAttachments, sizeof(VkAttachmentReference)*copy_src.inputAttachmentCount);
    }
    if (copy_src.pColorAttachments) {
        pColorAttachments = new VkAttachmentReference[copy_src.colorAttachmentCount];
        memcpy ((void *)pColorAttachments, (void *)copy_src.pColorAttachments, sizeof(VkAttachmentReference)*copy_src.colorAttachmentCount);
    }
    if (copy_src.pResolveAttachments) {
        pResolveAttachments = new VkAttachmentReference[copy_src.colorAttachmentCount];
        memcpy ((void *)pResolveAttachments, (void *)copy_src.pResolveAttachments, sizeof(VkAttachmentReference)*copy_src.colorAttachmentCount);
    }
    if (copy_src.pDepthStencilAttachment) {
        pDepthStencilAttachment = new VkAttachmentReference(*copy_src.pDepthStencilAttachment);
    }
    if (copy_src.pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[copy_src.preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)copy_src.pPreserveAttachments, sizeof(uint32_t)*copy_src.preserveAttachmentCount);
    }

    return *this;
}

safe_VkSubpassDescription::~safe_VkSubpassDescription()
{
    if (pInputAttachments)
        delete[] pInputAttachments;
    if (pColorAttachments)
        delete[] pColorAttachments;
    if (pResolveAttachments)
        delete[] pResolveAttachments;
    if (pDepthStencilAttachment)
        delete pDepthStencilAttachment;
    if (pPreserveAttachments)
        delete[] pPreserveAttachments;
}

void safe_VkSubpassDescription::initialize(const VkSubpassDescription* in_struct)
{
    flags = in_struct->flags;
    pipelineBindPoint = in_struct->pipelineBindPoint;
    inputAttachmentCount = in_struct->inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = in_struct->colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = in_struct->preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    if (in_struct->pInputAttachments) {
        pInputAttachments = new VkAttachmentReference[in_struct->inputAttachmentCount];
        memcpy ((void *)pInputAttachments, (void *)in_struct->pInputAttachments, sizeof(VkAttachmentReference)*in_struct->inputAttachmentCount);
    }
    if (in_struct->pColorAttachments) {
        pColorAttachments = new VkAttachmentReference[in_struct->colorAttachmentCount];
        memcpy ((void *)pColorAttachments, (void *)in_struct->pColorAttachments, sizeof(VkAttachmentReference)*in_struct->colorAttachmentCount);
    }
    if (in_struct->pResolveAttachments) {
        pResolveAttachments = new VkAttachmentReference[in_struct->colorAttachmentCount];
        memcpy ((void *)pResolveAttachments, (void *)in_struct->pResolveAttachments, sizeof(VkAttachmentReference)*in_struct->colorAttachmentCount);
    }
    if (in_struct->pDepthStencilAttachment) {
        pDepthStencilAttachment = new VkAttachmentReference(*in_struct->pDepthStencilAttachment);
    }
    if (in_struct->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[in_struct->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)in_struct->pPreserveAttachments, sizeof(uint32_t)*in_struct->preserveAttachmentCount);
    }
}

void safe_VkSubpassDescription::initialize(const safe_VkSubpassDescription* copy_src)
{
    flags = copy_src->flags;
    pipelineBindPoint = copy_src->pipelineBindPoint;
    inputAttachmentCount = copy_src->inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = copy_src->colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = copy_src->preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    if (copy_src->pInputAttachments) {
        pInputAttachments = new VkAttachmentReference[copy_src->inputAttachmentCount];
        memcpy ((void *)pInputAttachments, (void *)copy_src->pInputAttachments, sizeof(VkAttachmentReference)*copy_src->inputAttachmentCount);
    }
    if (copy_src->pColorAttachments) {
        pColorAttachments = new VkAttachmentReference[copy_src->colorAttachmentCount];
        memcpy ((void *)pColorAttachments, (void *)copy_src->pColorAttachments, sizeof(VkAttachmentReference)*copy_src->colorAttachmentCount);
    }
    if (copy_src->pResolveAttachments) {
        pResolveAttachments = new VkAttachmentReference[copy_src->colorAttachmentCount];
        memcpy ((void *)pResolveAttachments, (void *)copy_src->pResolveAttachments, sizeof(VkAttachmentReference)*copy_src->colorAttachmentCount);
    }
    if (copy_src->pDepthStencilAttachment) {
        pDepthStencilAttachment = new VkAttachmentReference(*copy_src->pDepthStencilAttachment);
    }
    if (copy_src->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[copy_src->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)copy_src->pPreserveAttachments, sizeof(uint32_t)*copy_src->preserveAttachmentCount);
    }
}

safe_VkRenderPassCreateInfo::safe_VkRenderPassCreateInfo(const VkRenderPassCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    attachmentCount(in_struct->attachmentCount),
    pAttachments(nullptr),
    subpassCount(in_struct->subpassCount),
    pSubpasses(nullptr),
    dependencyCount(in_struct->dependencyCount),
    pDependencies(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttachments) {
        pAttachments = new VkAttachmentDescription[in_struct->attachmentCount];
        memcpy ((void *)pAttachments, (void *)in_struct->pAttachments, sizeof(VkAttachmentDescription)*in_struct->attachmentCount);
    }
    if (subpassCount && in_struct->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&in_struct->pSubpasses[i]);
        }
    }
    if (in_struct->pDependencies) {
        pDependencies = new VkSubpassDependency[in_struct->dependencyCount];
        memcpy ((void *)pDependencies, (void *)in_struct->pDependencies, sizeof(VkSubpassDependency)*in_struct->dependencyCount);
    }
}

safe_VkRenderPassCreateInfo::safe_VkRenderPassCreateInfo() :
    sType(VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO),
    pNext(nullptr),
    pAttachments(nullptr),
    pSubpasses(nullptr),
    pDependencies(nullptr)
{}

safe_VkRenderPassCreateInfo::safe_VkRenderPassCreateInfo(const safe_VkRenderPassCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    attachmentCount = copy_src.attachmentCount;
    pAttachments = nullptr;
    subpassCount = copy_src.subpassCount;
    pSubpasses = nullptr;
    dependencyCount = copy_src.dependencyCount;
    pDependencies = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAttachments) {
        pAttachments = new VkAttachmentDescription[copy_src.attachmentCount];
        memcpy ((void *)pAttachments, (void *)copy_src.pAttachments, sizeof(VkAttachmentDescription)*copy_src.attachmentCount);
    }
    if (subpassCount && copy_src.pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&copy_src.pSubpasses[i]);
        }
    }
    if (copy_src.pDependencies) {
        pDependencies = new VkSubpassDependency[copy_src.dependencyCount];
        memcpy ((void *)pDependencies, (void *)copy_src.pDependencies, sizeof(VkSubpassDependency)*copy_src.dependencyCount);
    }
}

safe_VkRenderPassCreateInfo& safe_VkRenderPassCreateInfo::operator=(const safe_VkRenderPassCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pAttachments)
        delete[] pAttachments;
    if (pSubpasses)
        delete[] pSubpasses;
    if (pDependencies)
        delete[] pDependencies;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    attachmentCount = copy_src.attachmentCount;
    pAttachments = nullptr;
    subpassCount = copy_src.subpassCount;
    pSubpasses = nullptr;
    dependencyCount = copy_src.dependencyCount;
    pDependencies = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAttachments) {
        pAttachments = new VkAttachmentDescription[copy_src.attachmentCount];
        memcpy ((void *)pAttachments, (void *)copy_src.pAttachments, sizeof(VkAttachmentDescription)*copy_src.attachmentCount);
    }
    if (subpassCount && copy_src.pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&copy_src.pSubpasses[i]);
        }
    }
    if (copy_src.pDependencies) {
        pDependencies = new VkSubpassDependency[copy_src.dependencyCount];
        memcpy ((void *)pDependencies, (void *)copy_src.pDependencies, sizeof(VkSubpassDependency)*copy_src.dependencyCount);
    }

    return *this;
}

safe_VkRenderPassCreateInfo::~safe_VkRenderPassCreateInfo()
{
    if (pAttachments)
        delete[] pAttachments;
    if (pSubpasses)
        delete[] pSubpasses;
    if (pDependencies)
        delete[] pDependencies;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassCreateInfo::initialize(const VkRenderPassCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    attachmentCount = in_struct->attachmentCount;
    pAttachments = nullptr;
    subpassCount = in_struct->subpassCount;
    pSubpasses = nullptr;
    dependencyCount = in_struct->dependencyCount;
    pDependencies = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttachments) {
        pAttachments = new VkAttachmentDescription[in_struct->attachmentCount];
        memcpy ((void *)pAttachments, (void *)in_struct->pAttachments, sizeof(VkAttachmentDescription)*in_struct->attachmentCount);
    }
    if (subpassCount && in_struct->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&in_struct->pSubpasses[i]);
        }
    }
    if (in_struct->pDependencies) {
        pDependencies = new VkSubpassDependency[in_struct->dependencyCount];
        memcpy ((void *)pDependencies, (void *)in_struct->pDependencies, sizeof(VkSubpassDependency)*in_struct->dependencyCount);
    }
}

void safe_VkRenderPassCreateInfo::initialize(const safe_VkRenderPassCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    attachmentCount = copy_src->attachmentCount;
    pAttachments = nullptr;
    subpassCount = copy_src->subpassCount;
    pSubpasses = nullptr;
    dependencyCount = copy_src->dependencyCount;
    pDependencies = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pAttachments) {
        pAttachments = new VkAttachmentDescription[copy_src->attachmentCount];
        memcpy ((void *)pAttachments, (void *)copy_src->pAttachments, sizeof(VkAttachmentDescription)*copy_src->attachmentCount);
    }
    if (subpassCount && copy_src->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&copy_src->pSubpasses[i]);
        }
    }
    if (copy_src->pDependencies) {
        pDependencies = new VkSubpassDependency[copy_src->dependencyCount];
        memcpy ((void *)pDependencies, (void *)copy_src->pDependencies, sizeof(VkSubpassDependency)*copy_src->dependencyCount);
    }
}

safe_VkCommandPoolCreateInfo::safe_VkCommandPoolCreateInfo(const VkCommandPoolCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    queueFamilyIndex(in_struct->queueFamilyIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCommandPoolCreateInfo::safe_VkCommandPoolCreateInfo() :
    sType(VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkCommandPoolCreateInfo::safe_VkCommandPoolCreateInfo(const safe_VkCommandPoolCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    queueFamilyIndex = copy_src.queueFamilyIndex;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkCommandPoolCreateInfo& safe_VkCommandPoolCreateInfo::operator=(const safe_VkCommandPoolCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    queueFamilyIndex = copy_src.queueFamilyIndex;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkCommandPoolCreateInfo::~safe_VkCommandPoolCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCommandPoolCreateInfo::initialize(const VkCommandPoolCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    queueFamilyIndex = in_struct->queueFamilyIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCommandPoolCreateInfo::initialize(const safe_VkCommandPoolCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    queueFamilyIndex = copy_src->queueFamilyIndex;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkCommandBufferAllocateInfo::safe_VkCommandBufferAllocateInfo(const VkCommandBufferAllocateInfo* in_struct) :
    sType(in_struct->sType),
    commandPool(in_struct->commandPool),
    level(in_struct->level),
    commandBufferCount(in_struct->commandBufferCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCommandBufferAllocateInfo::safe_VkCommandBufferAllocateInfo() :
    sType(VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO),
    pNext(nullptr)
{}

safe_VkCommandBufferAllocateInfo::safe_VkCommandBufferAllocateInfo(const safe_VkCommandBufferAllocateInfo& copy_src)
{
    sType = copy_src.sType;
    commandPool = copy_src.commandPool;
    level = copy_src.level;
    commandBufferCount = copy_src.commandBufferCount;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkCommandBufferAllocateInfo& safe_VkCommandBufferAllocateInfo::operator=(const safe_VkCommandBufferAllocateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    commandPool = copy_src.commandPool;
    level = copy_src.level;
    commandBufferCount = copy_src.commandBufferCount;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkCommandBufferAllocateInfo::~safe_VkCommandBufferAllocateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCommandBufferAllocateInfo::initialize(const VkCommandBufferAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    commandPool = in_struct->commandPool;
    level = in_struct->level;
    commandBufferCount = in_struct->commandBufferCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCommandBufferAllocateInfo::initialize(const safe_VkCommandBufferAllocateInfo* copy_src)
{
    sType = copy_src->sType;
    commandPool = copy_src->commandPool;
    level = copy_src->level;
    commandBufferCount = copy_src->commandBufferCount;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkCommandBufferInheritanceInfo::safe_VkCommandBufferInheritanceInfo(const VkCommandBufferInheritanceInfo* in_struct) :
    sType(in_struct->sType),
    renderPass(in_struct->renderPass),
    subpass(in_struct->subpass),
    framebuffer(in_struct->framebuffer),
    occlusionQueryEnable(in_struct->occlusionQueryEnable),
    queryFlags(in_struct->queryFlags),
    pipelineStatistics(in_struct->pipelineStatistics)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCommandBufferInheritanceInfo::safe_VkCommandBufferInheritanceInfo() :
    sType(VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO),
    pNext(nullptr)
{}

safe_VkCommandBufferInheritanceInfo::safe_VkCommandBufferInheritanceInfo(const safe_VkCommandBufferInheritanceInfo& copy_src)
{
    sType = copy_src.sType;
    renderPass = copy_src.renderPass;
    subpass = copy_src.subpass;
    framebuffer = copy_src.framebuffer;
    occlusionQueryEnable = copy_src.occlusionQueryEnable;
    queryFlags = copy_src.queryFlags;
    pipelineStatistics = copy_src.pipelineStatistics;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkCommandBufferInheritanceInfo& safe_VkCommandBufferInheritanceInfo::operator=(const safe_VkCommandBufferInheritanceInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    renderPass = copy_src.renderPass;
    subpass = copy_src.subpass;
    framebuffer = copy_src.framebuffer;
    occlusionQueryEnable = copy_src.occlusionQueryEnable;
    queryFlags = copy_src.queryFlags;
    pipelineStatistics = copy_src.pipelineStatistics;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkCommandBufferInheritanceInfo::~safe_VkCommandBufferInheritanceInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCommandBufferInheritanceInfo::initialize(const VkCommandBufferInheritanceInfo* in_struct)
{
    sType = in_struct->sType;
    renderPass = in_struct->renderPass;
    subpass = in_struct->subpass;
    framebuffer = in_struct->framebuffer;
    occlusionQueryEnable = in_struct->occlusionQueryEnable;
    queryFlags = in_struct->queryFlags;
    pipelineStatistics = in_struct->pipelineStatistics;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCommandBufferInheritanceInfo::initialize(const safe_VkCommandBufferInheritanceInfo* copy_src)
{
    sType = copy_src->sType;
    renderPass = copy_src->renderPass;
    subpass = copy_src->subpass;
    framebuffer = copy_src->framebuffer;
    occlusionQueryEnable = copy_src->occlusionQueryEnable;
    queryFlags = copy_src->queryFlags;
    pipelineStatistics = copy_src->pipelineStatistics;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkCommandBufferBeginInfo::safe_VkCommandBufferBeginInfo(const VkCommandBufferBeginInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pInheritanceInfo(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pInheritanceInfo)
        pInheritanceInfo = new safe_VkCommandBufferInheritanceInfo(in_struct->pInheritanceInfo);
}

safe_VkCommandBufferBeginInfo::safe_VkCommandBufferBeginInfo() :
    sType(VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO),
    pNext(nullptr),
    pInheritanceInfo(nullptr)
{}

safe_VkCommandBufferBeginInfo::safe_VkCommandBufferBeginInfo(const safe_VkCommandBufferBeginInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    pInheritanceInfo = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pInheritanceInfo)
        pInheritanceInfo = new safe_VkCommandBufferInheritanceInfo(*copy_src.pInheritanceInfo);
}

safe_VkCommandBufferBeginInfo& safe_VkCommandBufferBeginInfo::operator=(const safe_VkCommandBufferBeginInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pInheritanceInfo)
        delete pInheritanceInfo;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    pInheritanceInfo = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pInheritanceInfo)
        pInheritanceInfo = new safe_VkCommandBufferInheritanceInfo(*copy_src.pInheritanceInfo);

    return *this;
}

safe_VkCommandBufferBeginInfo::~safe_VkCommandBufferBeginInfo()
{
    if (pInheritanceInfo)
        delete pInheritanceInfo;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCommandBufferBeginInfo::initialize(const VkCommandBufferBeginInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pInheritanceInfo = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pInheritanceInfo)
        pInheritanceInfo = new safe_VkCommandBufferInheritanceInfo(in_struct->pInheritanceInfo);
}

void safe_VkCommandBufferBeginInfo::initialize(const safe_VkCommandBufferBeginInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    pInheritanceInfo = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pInheritanceInfo)
        pInheritanceInfo = new safe_VkCommandBufferInheritanceInfo(*copy_src->pInheritanceInfo);
}

safe_VkRenderPassBeginInfo::safe_VkRenderPassBeginInfo(const VkRenderPassBeginInfo* in_struct) :
    sType(in_struct->sType),
    renderPass(in_struct->renderPass),
    framebuffer(in_struct->framebuffer),
    renderArea(in_struct->renderArea),
    clearValueCount(in_struct->clearValueCount),
    pClearValues(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pClearValues) {
        pClearValues = new VkClearValue[in_struct->clearValueCount];
        memcpy ((void *)pClearValues, (void *)in_struct->pClearValues, sizeof(VkClearValue)*in_struct->clearValueCount);
    }
}

safe_VkRenderPassBeginInfo::safe_VkRenderPassBeginInfo() :
    sType(VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO),
    pNext(nullptr),
    pClearValues(nullptr)
{}

safe_VkRenderPassBeginInfo::safe_VkRenderPassBeginInfo(const safe_VkRenderPassBeginInfo& copy_src)
{
    sType = copy_src.sType;
    renderPass = copy_src.renderPass;
    framebuffer = copy_src.framebuffer;
    renderArea = copy_src.renderArea;
    clearValueCount = copy_src.clearValueCount;
    pClearValues = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pClearValues) {
        pClearValues = new VkClearValue[copy_src.clearValueCount];
        memcpy ((void *)pClearValues, (void *)copy_src.pClearValues, sizeof(VkClearValue)*copy_src.clearValueCount);
    }
}

safe_VkRenderPassBeginInfo& safe_VkRenderPassBeginInfo::operator=(const safe_VkRenderPassBeginInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pClearValues)
        delete[] pClearValues;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    renderPass = copy_src.renderPass;
    framebuffer = copy_src.framebuffer;
    renderArea = copy_src.renderArea;
    clearValueCount = copy_src.clearValueCount;
    pClearValues = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pClearValues) {
        pClearValues = new VkClearValue[copy_src.clearValueCount];
        memcpy ((void *)pClearValues, (void *)copy_src.pClearValues, sizeof(VkClearValue)*copy_src.clearValueCount);
    }

    return *this;
}

safe_VkRenderPassBeginInfo::~safe_VkRenderPassBeginInfo()
{
    if (pClearValues)
        delete[] pClearValues;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassBeginInfo::initialize(const VkRenderPassBeginInfo* in_struct)
{
    sType = in_struct->sType;
    renderPass = in_struct->renderPass;
    framebuffer = in_struct->framebuffer;
    renderArea = in_struct->renderArea;
    clearValueCount = in_struct->clearValueCount;
    pClearValues = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pClearValues) {
        pClearValues = new VkClearValue[in_struct->clearValueCount];
        memcpy ((void *)pClearValues, (void *)in_struct->pClearValues, sizeof(VkClearValue)*in_struct->clearValueCount);
    }
}

void safe_VkRenderPassBeginInfo::initialize(const safe_VkRenderPassBeginInfo* copy_src)
{
    sType = copy_src->sType;
    renderPass = copy_src->renderPass;
    framebuffer = copy_src->framebuffer;
    renderArea = copy_src->renderArea;
    clearValueCount = copy_src->clearValueCount;
    pClearValues = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pClearValues) {
        pClearValues = new VkClearValue[copy_src->clearValueCount];
        memcpy ((void *)pClearValues, (void *)copy_src->pClearValues, sizeof(VkClearValue)*copy_src->clearValueCount);
    }
}

safe_VkPhysicalDeviceSubgroupProperties::safe_VkPhysicalDeviceSubgroupProperties(const VkPhysicalDeviceSubgroupProperties* in_struct) :
    sType(in_struct->sType),
    subgroupSize(in_struct->subgroupSize),
    supportedStages(in_struct->supportedStages),
    supportedOperations(in_struct->supportedOperations),
    quadOperationsInAllStages(in_struct->quadOperationsInAllStages)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSubgroupProperties::safe_VkPhysicalDeviceSubgroupProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSubgroupProperties::safe_VkPhysicalDeviceSubgroupProperties(const safe_VkPhysicalDeviceSubgroupProperties& copy_src)
{
    sType = copy_src.sType;
    subgroupSize = copy_src.subgroupSize;
    supportedStages = copy_src.supportedStages;
    supportedOperations = copy_src.supportedOperations;
    quadOperationsInAllStages = copy_src.quadOperationsInAllStages;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceSubgroupProperties& safe_VkPhysicalDeviceSubgroupProperties::operator=(const safe_VkPhysicalDeviceSubgroupProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    subgroupSize = copy_src.subgroupSize;
    supportedStages = copy_src.supportedStages;
    supportedOperations = copy_src.supportedOperations;
    quadOperationsInAllStages = copy_src.quadOperationsInAllStages;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSubgroupProperties::~safe_VkPhysicalDeviceSubgroupProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSubgroupProperties::initialize(const VkPhysicalDeviceSubgroupProperties* in_struct)
{
    sType = in_struct->sType;
    subgroupSize = in_struct->subgroupSize;
    supportedStages = in_struct->supportedStages;
    supportedOperations = in_struct->supportedOperations;
    quadOperationsInAllStages = in_struct->quadOperationsInAllStages;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSubgroupProperties::initialize(const safe_VkPhysicalDeviceSubgroupProperties* copy_src)
{
    sType = copy_src->sType;
    subgroupSize = copy_src->subgroupSize;
    supportedStages = copy_src->supportedStages;
    supportedOperations = copy_src->supportedOperations;
    quadOperationsInAllStages = copy_src->quadOperationsInAllStages;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkBindBufferMemoryInfo::safe_VkBindBufferMemoryInfo(const VkBindBufferMemoryInfo* in_struct) :
    sType(in_struct->sType),
    buffer(in_struct->buffer),
    memory(in_struct->memory),
    memoryOffset(in_struct->memoryOffset)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBindBufferMemoryInfo::safe_VkBindBufferMemoryInfo() :
    sType(VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO),
    pNext(nullptr)
{}

safe_VkBindBufferMemoryInfo::safe_VkBindBufferMemoryInfo(const safe_VkBindBufferMemoryInfo& copy_src)
{
    sType = copy_src.sType;
    buffer = copy_src.buffer;
    memory = copy_src.memory;
    memoryOffset = copy_src.memoryOffset;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBindBufferMemoryInfo& safe_VkBindBufferMemoryInfo::operator=(const safe_VkBindBufferMemoryInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    buffer = copy_src.buffer;
    memory = copy_src.memory;
    memoryOffset = copy_src.memoryOffset;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBindBufferMemoryInfo::~safe_VkBindBufferMemoryInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindBufferMemoryInfo::initialize(const VkBindBufferMemoryInfo* in_struct)
{
    sType = in_struct->sType;
    buffer = in_struct->buffer;
    memory = in_struct->memory;
    memoryOffset = in_struct->memoryOffset;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBindBufferMemoryInfo::initialize(const safe_VkBindBufferMemoryInfo* copy_src)
{
    sType = copy_src->sType;
    buffer = copy_src->buffer;
    memory = copy_src->memory;
    memoryOffset = copy_src->memoryOffset;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkBindImageMemoryInfo::safe_VkBindImageMemoryInfo(const VkBindImageMemoryInfo* in_struct) :
    sType(in_struct->sType),
    image(in_struct->image),
    memory(in_struct->memory),
    memoryOffset(in_struct->memoryOffset)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBindImageMemoryInfo::safe_VkBindImageMemoryInfo() :
    sType(VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO),
    pNext(nullptr)
{}

safe_VkBindImageMemoryInfo::safe_VkBindImageMemoryInfo(const safe_VkBindImageMemoryInfo& copy_src)
{
    sType = copy_src.sType;
    image = copy_src.image;
    memory = copy_src.memory;
    memoryOffset = copy_src.memoryOffset;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBindImageMemoryInfo& safe_VkBindImageMemoryInfo::operator=(const safe_VkBindImageMemoryInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    image = copy_src.image;
    memory = copy_src.memory;
    memoryOffset = copy_src.memoryOffset;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBindImageMemoryInfo::~safe_VkBindImageMemoryInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindImageMemoryInfo::initialize(const VkBindImageMemoryInfo* in_struct)
{
    sType = in_struct->sType;
    image = in_struct->image;
    memory = in_struct->memory;
    memoryOffset = in_struct->memoryOffset;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBindImageMemoryInfo::initialize(const safe_VkBindImageMemoryInfo* copy_src)
{
    sType = copy_src->sType;
    image = copy_src->image;
    memory = copy_src->memory;
    memoryOffset = copy_src->memoryOffset;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDevice16BitStorageFeatures::safe_VkPhysicalDevice16BitStorageFeatures(const VkPhysicalDevice16BitStorageFeatures* in_struct) :
    sType(in_struct->sType),
    storageBuffer16BitAccess(in_struct->storageBuffer16BitAccess),
    uniformAndStorageBuffer16BitAccess(in_struct->uniformAndStorageBuffer16BitAccess),
    storagePushConstant16(in_struct->storagePushConstant16),
    storageInputOutput16(in_struct->storageInputOutput16)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevice16BitStorageFeatures::safe_VkPhysicalDevice16BitStorageFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDevice16BitStorageFeatures::safe_VkPhysicalDevice16BitStorageFeatures(const safe_VkPhysicalDevice16BitStorageFeatures& copy_src)
{
    sType = copy_src.sType;
    storageBuffer16BitAccess = copy_src.storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = copy_src.uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = copy_src.storagePushConstant16;
    storageInputOutput16 = copy_src.storageInputOutput16;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDevice16BitStorageFeatures& safe_VkPhysicalDevice16BitStorageFeatures::operator=(const safe_VkPhysicalDevice16BitStorageFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    storageBuffer16BitAccess = copy_src.storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = copy_src.uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = copy_src.storagePushConstant16;
    storageInputOutput16 = copy_src.storageInputOutput16;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDevice16BitStorageFeatures::~safe_VkPhysicalDevice16BitStorageFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevice16BitStorageFeatures::initialize(const VkPhysicalDevice16BitStorageFeatures* in_struct)
{
    sType = in_struct->sType;
    storageBuffer16BitAccess = in_struct->storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = in_struct->uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = in_struct->storagePushConstant16;
    storageInputOutput16 = in_struct->storageInputOutput16;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevice16BitStorageFeatures::initialize(const safe_VkPhysicalDevice16BitStorageFeatures* copy_src)
{
    sType = copy_src->sType;
    storageBuffer16BitAccess = copy_src->storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = copy_src->uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = copy_src->storagePushConstant16;
    storageInputOutput16 = copy_src->storageInputOutput16;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkMemoryDedicatedRequirements::safe_VkMemoryDedicatedRequirements(const VkMemoryDedicatedRequirements* in_struct) :
    sType(in_struct->sType),
    prefersDedicatedAllocation(in_struct->prefersDedicatedAllocation),
    requiresDedicatedAllocation(in_struct->requiresDedicatedAllocation)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryDedicatedRequirements::safe_VkMemoryDedicatedRequirements() :
    sType(VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS),
    pNext(nullptr)
{}

safe_VkMemoryDedicatedRequirements::safe_VkMemoryDedicatedRequirements(const safe_VkMemoryDedicatedRequirements& copy_src)
{
    sType = copy_src.sType;
    prefersDedicatedAllocation = copy_src.prefersDedicatedAllocation;
    requiresDedicatedAllocation = copy_src.requiresDedicatedAllocation;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryDedicatedRequirements& safe_VkMemoryDedicatedRequirements::operator=(const safe_VkMemoryDedicatedRequirements& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    prefersDedicatedAllocation = copy_src.prefersDedicatedAllocation;
    requiresDedicatedAllocation = copy_src.requiresDedicatedAllocation;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryDedicatedRequirements::~safe_VkMemoryDedicatedRequirements()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryDedicatedRequirements::initialize(const VkMemoryDedicatedRequirements* in_struct)
{
    sType = in_struct->sType;
    prefersDedicatedAllocation = in_struct->prefersDedicatedAllocation;
    requiresDedicatedAllocation = in_struct->requiresDedicatedAllocation;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryDedicatedRequirements::initialize(const safe_VkMemoryDedicatedRequirements* copy_src)
{
    sType = copy_src->sType;
    prefersDedicatedAllocation = copy_src->prefersDedicatedAllocation;
    requiresDedicatedAllocation = copy_src->requiresDedicatedAllocation;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkMemoryDedicatedAllocateInfo::safe_VkMemoryDedicatedAllocateInfo(const VkMemoryDedicatedAllocateInfo* in_struct) :
    sType(in_struct->sType),
    image(in_struct->image),
    buffer(in_struct->buffer)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryDedicatedAllocateInfo::safe_VkMemoryDedicatedAllocateInfo() :
    sType(VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO),
    pNext(nullptr)
{}

safe_VkMemoryDedicatedAllocateInfo::safe_VkMemoryDedicatedAllocateInfo(const safe_VkMemoryDedicatedAllocateInfo& copy_src)
{
    sType = copy_src.sType;
    image = copy_src.image;
    buffer = copy_src.buffer;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryDedicatedAllocateInfo& safe_VkMemoryDedicatedAllocateInfo::operator=(const safe_VkMemoryDedicatedAllocateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    image = copy_src.image;
    buffer = copy_src.buffer;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryDedicatedAllocateInfo::~safe_VkMemoryDedicatedAllocateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryDedicatedAllocateInfo::initialize(const VkMemoryDedicatedAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    image = in_struct->image;
    buffer = in_struct->buffer;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryDedicatedAllocateInfo::initialize(const safe_VkMemoryDedicatedAllocateInfo* copy_src)
{
    sType = copy_src->sType;
    image = copy_src->image;
    buffer = copy_src->buffer;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkMemoryAllocateFlagsInfo::safe_VkMemoryAllocateFlagsInfo(const VkMemoryAllocateFlagsInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    deviceMask(in_struct->deviceMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryAllocateFlagsInfo::safe_VkMemoryAllocateFlagsInfo() :
    sType(VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO),
    pNext(nullptr)
{}

safe_VkMemoryAllocateFlagsInfo::safe_VkMemoryAllocateFlagsInfo(const safe_VkMemoryAllocateFlagsInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    deviceMask = copy_src.deviceMask;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryAllocateFlagsInfo& safe_VkMemoryAllocateFlagsInfo::operator=(const safe_VkMemoryAllocateFlagsInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    deviceMask = copy_src.deviceMask;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryAllocateFlagsInfo::~safe_VkMemoryAllocateFlagsInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryAllocateFlagsInfo::initialize(const VkMemoryAllocateFlagsInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    deviceMask = in_struct->deviceMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryAllocateFlagsInfo::initialize(const safe_VkMemoryAllocateFlagsInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    deviceMask = copy_src->deviceMask;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDeviceGroupRenderPassBeginInfo::safe_VkDeviceGroupRenderPassBeginInfo(const VkDeviceGroupRenderPassBeginInfo* in_struct) :
    sType(in_struct->sType),
    deviceMask(in_struct->deviceMask),
    deviceRenderAreaCount(in_struct->deviceRenderAreaCount),
    pDeviceRenderAreas(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceRenderAreas) {
        pDeviceRenderAreas = new VkRect2D[in_struct->deviceRenderAreaCount];
        memcpy ((void *)pDeviceRenderAreas, (void *)in_struct->pDeviceRenderAreas, sizeof(VkRect2D)*in_struct->deviceRenderAreaCount);
    }
}

safe_VkDeviceGroupRenderPassBeginInfo::safe_VkDeviceGroupRenderPassBeginInfo() :
    sType(VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO),
    pNext(nullptr),
    pDeviceRenderAreas(nullptr)
{}

safe_VkDeviceGroupRenderPassBeginInfo::safe_VkDeviceGroupRenderPassBeginInfo(const safe_VkDeviceGroupRenderPassBeginInfo& copy_src)
{
    sType = copy_src.sType;
    deviceMask = copy_src.deviceMask;
    deviceRenderAreaCount = copy_src.deviceRenderAreaCount;
    pDeviceRenderAreas = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDeviceRenderAreas) {
        pDeviceRenderAreas = new VkRect2D[copy_src.deviceRenderAreaCount];
        memcpy ((void *)pDeviceRenderAreas, (void *)copy_src.pDeviceRenderAreas, sizeof(VkRect2D)*copy_src.deviceRenderAreaCount);
    }
}

safe_VkDeviceGroupRenderPassBeginInfo& safe_VkDeviceGroupRenderPassBeginInfo::operator=(const safe_VkDeviceGroupRenderPassBeginInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pDeviceRenderAreas)
        delete[] pDeviceRenderAreas;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    deviceMask = copy_src.deviceMask;
    deviceRenderAreaCount = copy_src.deviceRenderAreaCount;
    pDeviceRenderAreas = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDeviceRenderAreas) {
        pDeviceRenderAreas = new VkRect2D[copy_src.deviceRenderAreaCount];
        memcpy ((void *)pDeviceRenderAreas, (void *)copy_src.pDeviceRenderAreas, sizeof(VkRect2D)*copy_src.deviceRenderAreaCount);
    }

    return *this;
}

safe_VkDeviceGroupRenderPassBeginInfo::~safe_VkDeviceGroupRenderPassBeginInfo()
{
    if (pDeviceRenderAreas)
        delete[] pDeviceRenderAreas;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupRenderPassBeginInfo::initialize(const VkDeviceGroupRenderPassBeginInfo* in_struct)
{
    sType = in_struct->sType;
    deviceMask = in_struct->deviceMask;
    deviceRenderAreaCount = in_struct->deviceRenderAreaCount;
    pDeviceRenderAreas = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceRenderAreas) {
        pDeviceRenderAreas = new VkRect2D[in_struct->deviceRenderAreaCount];
        memcpy ((void *)pDeviceRenderAreas, (void *)in_struct->pDeviceRenderAreas, sizeof(VkRect2D)*in_struct->deviceRenderAreaCount);
    }
}

void safe_VkDeviceGroupRenderPassBeginInfo::initialize(const safe_VkDeviceGroupRenderPassBeginInfo* copy_src)
{
    sType = copy_src->sType;
    deviceMask = copy_src->deviceMask;
    deviceRenderAreaCount = copy_src->deviceRenderAreaCount;
    pDeviceRenderAreas = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pDeviceRenderAreas) {
        pDeviceRenderAreas = new VkRect2D[copy_src->deviceRenderAreaCount];
        memcpy ((void *)pDeviceRenderAreas, (void *)copy_src->pDeviceRenderAreas, sizeof(VkRect2D)*copy_src->deviceRenderAreaCount);
    }
}

safe_VkDeviceGroupCommandBufferBeginInfo::safe_VkDeviceGroupCommandBufferBeginInfo(const VkDeviceGroupCommandBufferBeginInfo* in_struct) :
    sType(in_struct->sType),
    deviceMask(in_struct->deviceMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceGroupCommandBufferBeginInfo::safe_VkDeviceGroupCommandBufferBeginInfo() :
    sType(VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO),
    pNext(nullptr)
{}

safe_VkDeviceGroupCommandBufferBeginInfo::safe_VkDeviceGroupCommandBufferBeginInfo(const safe_VkDeviceGroupCommandBufferBeginInfo& copy_src)
{
    sType = copy_src.sType;
    deviceMask = copy_src.deviceMask;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDeviceGroupCommandBufferBeginInfo& safe_VkDeviceGroupCommandBufferBeginInfo::operator=(const safe_VkDeviceGroupCommandBufferBeginInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    deviceMask = copy_src.deviceMask;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDeviceGroupCommandBufferBeginInfo::~safe_VkDeviceGroupCommandBufferBeginInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupCommandBufferBeginInfo::initialize(const VkDeviceGroupCommandBufferBeginInfo* in_struct)
{
    sType = in_struct->sType;
    deviceMask = in_struct->deviceMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceGroupCommandBufferBeginInfo::initialize(const safe_VkDeviceGroupCommandBufferBeginInfo* copy_src)
{
    sType = copy_src->sType;
    deviceMask = copy_src->deviceMask;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDeviceGroupSubmitInfo::safe_VkDeviceGroupSubmitInfo(const VkDeviceGroupSubmitInfo* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreCount(in_struct->waitSemaphoreCount),
    pWaitSemaphoreDeviceIndices(nullptr),
    commandBufferCount(in_struct->commandBufferCount),
    pCommandBufferDeviceMasks(nullptr),
    signalSemaphoreCount(in_struct->signalSemaphoreCount),
    pSignalSemaphoreDeviceIndices(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreDeviceIndices) {
        pWaitSemaphoreDeviceIndices = new uint32_t[in_struct->waitSemaphoreCount];
        memcpy ((void *)pWaitSemaphoreDeviceIndices, (void *)in_struct->pWaitSemaphoreDeviceIndices, sizeof(uint32_t)*in_struct->waitSemaphoreCount);
    }
    if (in_struct->pCommandBufferDeviceMasks) {
        pCommandBufferDeviceMasks = new uint32_t[in_struct->commandBufferCount];
        memcpy ((void *)pCommandBufferDeviceMasks, (void *)in_struct->pCommandBufferDeviceMasks, sizeof(uint32_t)*in_struct->commandBufferCount);
    }
    if (in_struct->pSignalSemaphoreDeviceIndices) {
        pSignalSemaphoreDeviceIndices = new uint32_t[in_struct->signalSemaphoreCount];
        memcpy ((void *)pSignalSemaphoreDeviceIndices, (void *)in_struct->pSignalSemaphoreDeviceIndices, sizeof(uint32_t)*in_struct->signalSemaphoreCount);
    }
}

safe_VkDeviceGroupSubmitInfo::safe_VkDeviceGroupSubmitInfo() :
    sType(VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO),
    pNext(nullptr),
    pWaitSemaphoreDeviceIndices(nullptr),
    pCommandBufferDeviceMasks(nullptr),
    pSignalSemaphoreDeviceIndices(nullptr)
{}

safe_VkDeviceGroupSubmitInfo::safe_VkDeviceGroupSubmitInfo(const safe_VkDeviceGroupSubmitInfo& copy_src)
{
    sType = copy_src.sType;
    waitSemaphoreCount = copy_src.waitSemaphoreCount;
    pWaitSemaphoreDeviceIndices = nullptr;
    commandBufferCount = copy_src.commandBufferCount;
    pCommandBufferDeviceMasks = nullptr;
    signalSemaphoreCount = copy_src.signalSemaphoreCount;
    pSignalSemaphoreDeviceIndices = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pWaitSemaphoreDeviceIndices) {
        pWaitSemaphoreDeviceIndices = new uint32_t[copy_src.waitSemaphoreCount];
        memcpy ((void *)pWaitSemaphoreDeviceIndices, (void *)copy_src.pWaitSemaphoreDeviceIndices, sizeof(uint32_t)*copy_src.waitSemaphoreCount);
    }
    if (copy_src.pCommandBufferDeviceMasks) {
        pCommandBufferDeviceMasks = new uint32_t[copy_src.commandBufferCount];
        memcpy ((void *)pCommandBufferDeviceMasks, (void *)copy_src.pCommandBufferDeviceMasks, sizeof(uint32_t)*copy_src.commandBufferCount);
    }
    if (copy_src.pSignalSemaphoreDeviceIndices) {
        pSignalSemaphoreDeviceIndices = new uint32_t[copy_src.signalSemaphoreCount];
        memcpy ((void *)pSignalSemaphoreDeviceIndices, (void *)copy_src.pSignalSemaphoreDeviceIndices, sizeof(uint32_t)*copy_src.signalSemaphoreCount);
    }
}

safe_VkDeviceGroupSubmitInfo& safe_VkDeviceGroupSubmitInfo::operator=(const safe_VkDeviceGroupSubmitInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pWaitSemaphoreDeviceIndices)
        delete[] pWaitSemaphoreDeviceIndices;
    if (pCommandBufferDeviceMasks)
        delete[] pCommandBufferDeviceMasks;
    if (pSignalSemaphoreDeviceIndices)
        delete[] pSignalSemaphoreDeviceIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    waitSemaphoreCount = copy_src.waitSemaphoreCount;
    pWaitSemaphoreDeviceIndices = nullptr;
    commandBufferCount = copy_src.commandBufferCount;
    pCommandBufferDeviceMasks = nullptr;
    signalSemaphoreCount = copy_src.signalSemaphoreCount;
    pSignalSemaphoreDeviceIndices = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pWaitSemaphoreDeviceIndices) {
        pWaitSemaphoreDeviceIndices = new uint32_t[copy_src.waitSemaphoreCount];
        memcpy ((void *)pWaitSemaphoreDeviceIndices, (void *)copy_src.pWaitSemaphoreDeviceIndices, sizeof(uint32_t)*copy_src.waitSemaphoreCount);
    }
    if (copy_src.pCommandBufferDeviceMasks) {
        pCommandBufferDeviceMasks = new uint32_t[copy_src.commandBufferCount];
        memcpy ((void *)pCommandBufferDeviceMasks, (void *)copy_src.pCommandBufferDeviceMasks, sizeof(uint32_t)*copy_src.commandBufferCount);
    }
    if (copy_src.pSignalSemaphoreDeviceIndices) {
        pSignalSemaphoreDeviceIndices = new uint32_t[copy_src.signalSemaphoreCount];
        memcpy ((void *)pSignalSemaphoreDeviceIndices, (void *)copy_src.pSignalSemaphoreDeviceIndices, sizeof(uint32_t)*copy_src.signalSemaphoreCount);
    }

    return *this;
}

safe_VkDeviceGroupSubmitInfo::~safe_VkDeviceGroupSubmitInfo()
{
    if (pWaitSemaphoreDeviceIndices)
        delete[] pWaitSemaphoreDeviceIndices;
    if (pCommandBufferDeviceMasks)
        delete[] pCommandBufferDeviceMasks;
    if (pSignalSemaphoreDeviceIndices)
        delete[] pSignalSemaphoreDeviceIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupSubmitInfo::initialize(const VkDeviceGroupSubmitInfo* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreCount = in_struct->waitSemaphoreCount;
    pWaitSemaphoreDeviceIndices = nullptr;
    commandBufferCount = in_struct->commandBufferCount;
    pCommandBufferDeviceMasks = nullptr;
    signalSemaphoreCount = in_struct->signalSemaphoreCount;
    pSignalSemaphoreDeviceIndices = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreDeviceIndices) {
        pWaitSemaphoreDeviceIndices = new uint32_t[in_struct->waitSemaphoreCount];
        memcpy ((void *)pWaitSemaphoreDeviceIndices, (void *)in_struct->pWaitSemaphoreDeviceIndices, sizeof(uint32_t)*in_struct->waitSemaphoreCount);
    }
    if (in_struct->pCommandBufferDeviceMasks) {
        pCommandBufferDeviceMasks = new uint32_t[in_struct->commandBufferCount];
        memcpy ((void *)pCommandBufferDeviceMasks, (void *)in_struct->pCommandBufferDeviceMasks, sizeof(uint32_t)*in_struct->commandBufferCount);
    }
    if (in_struct->pSignalSemaphoreDeviceIndices) {
        pSignalSemaphoreDeviceIndices = new uint32_t[in_struct->signalSemaphoreCount];
        memcpy ((void *)pSignalSemaphoreDeviceIndices, (void *)in_struct->pSignalSemaphoreDeviceIndices, sizeof(uint32_t)*in_struct->signalSemaphoreCount);
    }
}

void safe_VkDeviceGroupSubmitInfo::initialize(const safe_VkDeviceGroupSubmitInfo* copy_src)
{
    sType = copy_src->sType;
    waitSemaphoreCount = copy_src->waitSemaphoreCount;
    pWaitSemaphoreDeviceIndices = nullptr;
    commandBufferCount = copy_src->commandBufferCount;
    pCommandBufferDeviceMasks = nullptr;
    signalSemaphoreCount = copy_src->signalSemaphoreCount;
    pSignalSemaphoreDeviceIndices = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pWaitSemaphoreDeviceIndices) {
        pWaitSemaphoreDeviceIndices = new uint32_t[copy_src->waitSemaphoreCount];
        memcpy ((void *)pWaitSemaphoreDeviceIndices, (void *)copy_src->pWaitSemaphoreDeviceIndices, sizeof(uint32_t)*copy_src->waitSemaphoreCount);
    }
    if (copy_src->pCommandBufferDeviceMasks) {
        pCommandBufferDeviceMasks = new uint32_t[copy_src->commandBufferCount];
        memcpy ((void *)pCommandBufferDeviceMasks, (void *)copy_src->pCommandBufferDeviceMasks, sizeof(uint32_t)*copy_src->commandBufferCount);
    }
    if (copy_src->pSignalSemaphoreDeviceIndices) {
        pSignalSemaphoreDeviceIndices = new uint32_t[copy_src->signalSemaphoreCount];
        memcpy ((void *)pSignalSemaphoreDeviceIndices, (void *)copy_src->pSignalSemaphoreDeviceIndices, sizeof(uint32_t)*copy_src->signalSemaphoreCount);
    }
}

safe_VkDeviceGroupBindSparseInfo::safe_VkDeviceGroupBindSparseInfo(const VkDeviceGroupBindSparseInfo* in_struct) :
    sType(in_struct->sType),
    resourceDeviceIndex(in_struct->resourceDeviceIndex),
    memoryDeviceIndex(in_struct->memoryDeviceIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceGroupBindSparseInfo::safe_VkDeviceGroupBindSparseInfo() :
    sType(VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO),
    pNext(nullptr)
{}

safe_VkDeviceGroupBindSparseInfo::safe_VkDeviceGroupBindSparseInfo(const safe_VkDeviceGroupBindSparseInfo& copy_src)
{
    sType = copy_src.sType;
    resourceDeviceIndex = copy_src.resourceDeviceIndex;
    memoryDeviceIndex = copy_src.memoryDeviceIndex;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDeviceGroupBindSparseInfo& safe_VkDeviceGroupBindSparseInfo::operator=(const safe_VkDeviceGroupBindSparseInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    resourceDeviceIndex = copy_src.resourceDeviceIndex;
    memoryDeviceIndex = copy_src.memoryDeviceIndex;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDeviceGroupBindSparseInfo::~safe_VkDeviceGroupBindSparseInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupBindSparseInfo::initialize(const VkDeviceGroupBindSparseInfo* in_struct)
{
    sType = in_struct->sType;
    resourceDeviceIndex = in_struct->resourceDeviceIndex;
    memoryDeviceIndex = in_struct->memoryDeviceIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceGroupBindSparseInfo::initialize(const safe_VkDeviceGroupBindSparseInfo* copy_src)
{
    sType = copy_src->sType;
    resourceDeviceIndex = copy_src->resourceDeviceIndex;
    memoryDeviceIndex = copy_src->memoryDeviceIndex;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkBindBufferMemoryDeviceGroupInfo::safe_VkBindBufferMemoryDeviceGroupInfo(const VkBindBufferMemoryDeviceGroupInfo* in_struct) :
    sType(in_struct->sType),
    deviceIndexCount(in_struct->deviceIndexCount),
    pDeviceIndices(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceIndices) {
        pDeviceIndices = new uint32_t[in_struct->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)in_struct->pDeviceIndices, sizeof(uint32_t)*in_struct->deviceIndexCount);
    }
}

safe_VkBindBufferMemoryDeviceGroupInfo::safe_VkBindBufferMemoryDeviceGroupInfo() :
    sType(VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO),
    pNext(nullptr),
    pDeviceIndices(nullptr)
{}

safe_VkBindBufferMemoryDeviceGroupInfo::safe_VkBindBufferMemoryDeviceGroupInfo(const safe_VkBindBufferMemoryDeviceGroupInfo& copy_src)
{
    sType = copy_src.sType;
    deviceIndexCount = copy_src.deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDeviceIndices) {
        pDeviceIndices = new uint32_t[copy_src.deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)copy_src.pDeviceIndices, sizeof(uint32_t)*copy_src.deviceIndexCount);
    }
}

safe_VkBindBufferMemoryDeviceGroupInfo& safe_VkBindBufferMemoryDeviceGroupInfo::operator=(const safe_VkBindBufferMemoryDeviceGroupInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pDeviceIndices)
        delete[] pDeviceIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    deviceIndexCount = copy_src.deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDeviceIndices) {
        pDeviceIndices = new uint32_t[copy_src.deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)copy_src.pDeviceIndices, sizeof(uint32_t)*copy_src.deviceIndexCount);
    }

    return *this;
}

safe_VkBindBufferMemoryDeviceGroupInfo::~safe_VkBindBufferMemoryDeviceGroupInfo()
{
    if (pDeviceIndices)
        delete[] pDeviceIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindBufferMemoryDeviceGroupInfo::initialize(const VkBindBufferMemoryDeviceGroupInfo* in_struct)
{
    sType = in_struct->sType;
    deviceIndexCount = in_struct->deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceIndices) {
        pDeviceIndices = new uint32_t[in_struct->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)in_struct->pDeviceIndices, sizeof(uint32_t)*in_struct->deviceIndexCount);
    }
}

void safe_VkBindBufferMemoryDeviceGroupInfo::initialize(const safe_VkBindBufferMemoryDeviceGroupInfo* copy_src)
{
    sType = copy_src->sType;
    deviceIndexCount = copy_src->deviceIndexCount;
    pDeviceIndices = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pDeviceIndices) {
        pDeviceIndices = new uint32_t[copy_src->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)copy_src->pDeviceIndices, sizeof(uint32_t)*copy_src->deviceIndexCount);
    }
}

safe_VkBindImageMemoryDeviceGroupInfo::safe_VkBindImageMemoryDeviceGroupInfo(const VkBindImageMemoryDeviceGroupInfo* in_struct) :
    sType(in_struct->sType),
    deviceIndexCount(in_struct->deviceIndexCount),
    pDeviceIndices(nullptr),
    splitInstanceBindRegionCount(in_struct->splitInstanceBindRegionCount),
    pSplitInstanceBindRegions(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceIndices) {
        pDeviceIndices = new uint32_t[in_struct->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)in_struct->pDeviceIndices, sizeof(uint32_t)*in_struct->deviceIndexCount);
    }
    if (in_struct->pSplitInstanceBindRegions) {
        pSplitInstanceBindRegions = new VkRect2D[in_struct->splitInstanceBindRegionCount];
        memcpy ((void *)pSplitInstanceBindRegions, (void *)in_struct->pSplitInstanceBindRegions, sizeof(VkRect2D)*in_struct->splitInstanceBindRegionCount);
    }
}

safe_VkBindImageMemoryDeviceGroupInfo::safe_VkBindImageMemoryDeviceGroupInfo() :
    sType(VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO),
    pNext(nullptr),
    pDeviceIndices(nullptr),
    pSplitInstanceBindRegions(nullptr)
{}

safe_VkBindImageMemoryDeviceGroupInfo::safe_VkBindImageMemoryDeviceGroupInfo(const safe_VkBindImageMemoryDeviceGroupInfo& copy_src)
{
    sType = copy_src.sType;
    deviceIndexCount = copy_src.deviceIndexCount;
    pDeviceIndices = nullptr;
    splitInstanceBindRegionCount = copy_src.splitInstanceBindRegionCount;
    pSplitInstanceBindRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDeviceIndices) {
        pDeviceIndices = new uint32_t[copy_src.deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)copy_src.pDeviceIndices, sizeof(uint32_t)*copy_src.deviceIndexCount);
    }
    if (copy_src.pSplitInstanceBindRegions) {
        pSplitInstanceBindRegions = new VkRect2D[copy_src.splitInstanceBindRegionCount];
        memcpy ((void *)pSplitInstanceBindRegions, (void *)copy_src.pSplitInstanceBindRegions, sizeof(VkRect2D)*copy_src.splitInstanceBindRegionCount);
    }
}

safe_VkBindImageMemoryDeviceGroupInfo& safe_VkBindImageMemoryDeviceGroupInfo::operator=(const safe_VkBindImageMemoryDeviceGroupInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pDeviceIndices)
        delete[] pDeviceIndices;
    if (pSplitInstanceBindRegions)
        delete[] pSplitInstanceBindRegions;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    deviceIndexCount = copy_src.deviceIndexCount;
    pDeviceIndices = nullptr;
    splitInstanceBindRegionCount = copy_src.splitInstanceBindRegionCount;
    pSplitInstanceBindRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDeviceIndices) {
        pDeviceIndices = new uint32_t[copy_src.deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)copy_src.pDeviceIndices, sizeof(uint32_t)*copy_src.deviceIndexCount);
    }
    if (copy_src.pSplitInstanceBindRegions) {
        pSplitInstanceBindRegions = new VkRect2D[copy_src.splitInstanceBindRegionCount];
        memcpy ((void *)pSplitInstanceBindRegions, (void *)copy_src.pSplitInstanceBindRegions, sizeof(VkRect2D)*copy_src.splitInstanceBindRegionCount);
    }

    return *this;
}

safe_VkBindImageMemoryDeviceGroupInfo::~safe_VkBindImageMemoryDeviceGroupInfo()
{
    if (pDeviceIndices)
        delete[] pDeviceIndices;
    if (pSplitInstanceBindRegions)
        delete[] pSplitInstanceBindRegions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindImageMemoryDeviceGroupInfo::initialize(const VkBindImageMemoryDeviceGroupInfo* in_struct)
{
    sType = in_struct->sType;
    deviceIndexCount = in_struct->deviceIndexCount;
    pDeviceIndices = nullptr;
    splitInstanceBindRegionCount = in_struct->splitInstanceBindRegionCount;
    pSplitInstanceBindRegions = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceIndices) {
        pDeviceIndices = new uint32_t[in_struct->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)in_struct->pDeviceIndices, sizeof(uint32_t)*in_struct->deviceIndexCount);
    }
    if (in_struct->pSplitInstanceBindRegions) {
        pSplitInstanceBindRegions = new VkRect2D[in_struct->splitInstanceBindRegionCount];
        memcpy ((void *)pSplitInstanceBindRegions, (void *)in_struct->pSplitInstanceBindRegions, sizeof(VkRect2D)*in_struct->splitInstanceBindRegionCount);
    }
}

void safe_VkBindImageMemoryDeviceGroupInfo::initialize(const safe_VkBindImageMemoryDeviceGroupInfo* copy_src)
{
    sType = copy_src->sType;
    deviceIndexCount = copy_src->deviceIndexCount;
    pDeviceIndices = nullptr;
    splitInstanceBindRegionCount = copy_src->splitInstanceBindRegionCount;
    pSplitInstanceBindRegions = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pDeviceIndices) {
        pDeviceIndices = new uint32_t[copy_src->deviceIndexCount];
        memcpy ((void *)pDeviceIndices, (void *)copy_src->pDeviceIndices, sizeof(uint32_t)*copy_src->deviceIndexCount);
    }
    if (copy_src->pSplitInstanceBindRegions) {
        pSplitInstanceBindRegions = new VkRect2D[copy_src->splitInstanceBindRegionCount];
        memcpy ((void *)pSplitInstanceBindRegions, (void *)copy_src->pSplitInstanceBindRegions, sizeof(VkRect2D)*copy_src->splitInstanceBindRegionCount);
    }
}

safe_VkPhysicalDeviceGroupProperties::safe_VkPhysicalDeviceGroupProperties(const VkPhysicalDeviceGroupProperties* in_struct) :
    sType(in_struct->sType),
    physicalDeviceCount(in_struct->physicalDeviceCount),
    subsetAllocation(in_struct->subsetAllocation)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        physicalDevices[i] = in_struct->physicalDevices[i];
    }
}

safe_VkPhysicalDeviceGroupProperties::safe_VkPhysicalDeviceGroupProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceGroupProperties::safe_VkPhysicalDeviceGroupProperties(const safe_VkPhysicalDeviceGroupProperties& copy_src)
{
    sType = copy_src.sType;
    physicalDeviceCount = copy_src.physicalDeviceCount;
    subsetAllocation = copy_src.subsetAllocation;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        physicalDevices[i] = copy_src.physicalDevices[i];
    }
}

safe_VkPhysicalDeviceGroupProperties& safe_VkPhysicalDeviceGroupProperties::operator=(const safe_VkPhysicalDeviceGroupProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    physicalDeviceCount = copy_src.physicalDeviceCount;
    subsetAllocation = copy_src.subsetAllocation;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        physicalDevices[i] = copy_src.physicalDevices[i];
    }

    return *this;
}

safe_VkPhysicalDeviceGroupProperties::~safe_VkPhysicalDeviceGroupProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceGroupProperties::initialize(const VkPhysicalDeviceGroupProperties* in_struct)
{
    sType = in_struct->sType;
    physicalDeviceCount = in_struct->physicalDeviceCount;
    subsetAllocation = in_struct->subsetAllocation;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        physicalDevices[i] = in_struct->physicalDevices[i];
    }
}

void safe_VkPhysicalDeviceGroupProperties::initialize(const safe_VkPhysicalDeviceGroupProperties* copy_src)
{
    sType = copy_src->sType;
    physicalDeviceCount = copy_src->physicalDeviceCount;
    subsetAllocation = copy_src->subsetAllocation;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        physicalDevices[i] = copy_src->physicalDevices[i];
    }
}

safe_VkDeviceGroupDeviceCreateInfo::safe_VkDeviceGroupDeviceCreateInfo(const VkDeviceGroupDeviceCreateInfo* in_struct) :
    sType(in_struct->sType),
    physicalDeviceCount(in_struct->physicalDeviceCount),
    pPhysicalDevices(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPhysicalDevices) {
        pPhysicalDevices = new VkPhysicalDevice[in_struct->physicalDeviceCount];
        memcpy ((void *)pPhysicalDevices, (void *)in_struct->pPhysicalDevices, sizeof(VkPhysicalDevice)*in_struct->physicalDeviceCount);
    }
}

safe_VkDeviceGroupDeviceCreateInfo::safe_VkDeviceGroupDeviceCreateInfo() :
    sType(VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO),
    pNext(nullptr),
    pPhysicalDevices(nullptr)
{}

safe_VkDeviceGroupDeviceCreateInfo::safe_VkDeviceGroupDeviceCreateInfo(const safe_VkDeviceGroupDeviceCreateInfo& copy_src)
{
    sType = copy_src.sType;
    physicalDeviceCount = copy_src.physicalDeviceCount;
    pPhysicalDevices = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pPhysicalDevices) {
        pPhysicalDevices = new VkPhysicalDevice[copy_src.physicalDeviceCount];
        memcpy ((void *)pPhysicalDevices, (void *)copy_src.pPhysicalDevices, sizeof(VkPhysicalDevice)*copy_src.physicalDeviceCount);
    }
}

safe_VkDeviceGroupDeviceCreateInfo& safe_VkDeviceGroupDeviceCreateInfo::operator=(const safe_VkDeviceGroupDeviceCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pPhysicalDevices)
        delete[] pPhysicalDevices;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    physicalDeviceCount = copy_src.physicalDeviceCount;
    pPhysicalDevices = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pPhysicalDevices) {
        pPhysicalDevices = new VkPhysicalDevice[copy_src.physicalDeviceCount];
        memcpy ((void *)pPhysicalDevices, (void *)copy_src.pPhysicalDevices, sizeof(VkPhysicalDevice)*copy_src.physicalDeviceCount);
    }

    return *this;
}

safe_VkDeviceGroupDeviceCreateInfo::~safe_VkDeviceGroupDeviceCreateInfo()
{
    if (pPhysicalDevices)
        delete[] pPhysicalDevices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupDeviceCreateInfo::initialize(const VkDeviceGroupDeviceCreateInfo* in_struct)
{
    sType = in_struct->sType;
    physicalDeviceCount = in_struct->physicalDeviceCount;
    pPhysicalDevices = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPhysicalDevices) {
        pPhysicalDevices = new VkPhysicalDevice[in_struct->physicalDeviceCount];
        memcpy ((void *)pPhysicalDevices, (void *)in_struct->pPhysicalDevices, sizeof(VkPhysicalDevice)*in_struct->physicalDeviceCount);
    }
}

void safe_VkDeviceGroupDeviceCreateInfo::initialize(const safe_VkDeviceGroupDeviceCreateInfo* copy_src)
{
    sType = copy_src->sType;
    physicalDeviceCount = copy_src->physicalDeviceCount;
    pPhysicalDevices = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pPhysicalDevices) {
        pPhysicalDevices = new VkPhysicalDevice[copy_src->physicalDeviceCount];
        memcpy ((void *)pPhysicalDevices, (void *)copy_src->pPhysicalDevices, sizeof(VkPhysicalDevice)*copy_src->physicalDeviceCount);
    }
}

safe_VkBufferMemoryRequirementsInfo2::safe_VkBufferMemoryRequirementsInfo2(const VkBufferMemoryRequirementsInfo2* in_struct) :
    sType(in_struct->sType),
    buffer(in_struct->buffer)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferMemoryRequirementsInfo2::safe_VkBufferMemoryRequirementsInfo2() :
    sType(VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2),
    pNext(nullptr)
{}

safe_VkBufferMemoryRequirementsInfo2::safe_VkBufferMemoryRequirementsInfo2(const safe_VkBufferMemoryRequirementsInfo2& copy_src)
{
    sType = copy_src.sType;
    buffer = copy_src.buffer;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBufferMemoryRequirementsInfo2& safe_VkBufferMemoryRequirementsInfo2::operator=(const safe_VkBufferMemoryRequirementsInfo2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    buffer = copy_src.buffer;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBufferMemoryRequirementsInfo2::~safe_VkBufferMemoryRequirementsInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferMemoryRequirementsInfo2::initialize(const VkBufferMemoryRequirementsInfo2* in_struct)
{
    sType = in_struct->sType;
    buffer = in_struct->buffer;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferMemoryRequirementsInfo2::initialize(const safe_VkBufferMemoryRequirementsInfo2* copy_src)
{
    sType = copy_src->sType;
    buffer = copy_src->buffer;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkImageMemoryRequirementsInfo2::safe_VkImageMemoryRequirementsInfo2(const VkImageMemoryRequirementsInfo2* in_struct) :
    sType(in_struct->sType),
    image(in_struct->image)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageMemoryRequirementsInfo2::safe_VkImageMemoryRequirementsInfo2() :
    sType(VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2),
    pNext(nullptr)
{}

safe_VkImageMemoryRequirementsInfo2::safe_VkImageMemoryRequirementsInfo2(const safe_VkImageMemoryRequirementsInfo2& copy_src)
{
    sType = copy_src.sType;
    image = copy_src.image;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageMemoryRequirementsInfo2& safe_VkImageMemoryRequirementsInfo2::operator=(const safe_VkImageMemoryRequirementsInfo2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    image = copy_src.image;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageMemoryRequirementsInfo2::~safe_VkImageMemoryRequirementsInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageMemoryRequirementsInfo2::initialize(const VkImageMemoryRequirementsInfo2* in_struct)
{
    sType = in_struct->sType;
    image = in_struct->image;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageMemoryRequirementsInfo2::initialize(const safe_VkImageMemoryRequirementsInfo2* copy_src)
{
    sType = copy_src->sType;
    image = copy_src->image;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkImageSparseMemoryRequirementsInfo2::safe_VkImageSparseMemoryRequirementsInfo2(const VkImageSparseMemoryRequirementsInfo2* in_struct) :
    sType(in_struct->sType),
    image(in_struct->image)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageSparseMemoryRequirementsInfo2::safe_VkImageSparseMemoryRequirementsInfo2() :
    sType(VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2),
    pNext(nullptr)
{}

safe_VkImageSparseMemoryRequirementsInfo2::safe_VkImageSparseMemoryRequirementsInfo2(const safe_VkImageSparseMemoryRequirementsInfo2& copy_src)
{
    sType = copy_src.sType;
    image = copy_src.image;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageSparseMemoryRequirementsInfo2& safe_VkImageSparseMemoryRequirementsInfo2::operator=(const safe_VkImageSparseMemoryRequirementsInfo2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    image = copy_src.image;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageSparseMemoryRequirementsInfo2::~safe_VkImageSparseMemoryRequirementsInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageSparseMemoryRequirementsInfo2::initialize(const VkImageSparseMemoryRequirementsInfo2* in_struct)
{
    sType = in_struct->sType;
    image = in_struct->image;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageSparseMemoryRequirementsInfo2::initialize(const safe_VkImageSparseMemoryRequirementsInfo2* copy_src)
{
    sType = copy_src->sType;
    image = copy_src->image;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkMemoryRequirements2::safe_VkMemoryRequirements2(const VkMemoryRequirements2* in_struct) :
    sType(in_struct->sType),
    memoryRequirements(in_struct->memoryRequirements)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryRequirements2::safe_VkMemoryRequirements2() :
    sType(VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2),
    pNext(nullptr)
{}

safe_VkMemoryRequirements2::safe_VkMemoryRequirements2(const safe_VkMemoryRequirements2& copy_src)
{
    sType = copy_src.sType;
    memoryRequirements = copy_src.memoryRequirements;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryRequirements2& safe_VkMemoryRequirements2::operator=(const safe_VkMemoryRequirements2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    memoryRequirements = copy_src.memoryRequirements;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryRequirements2::~safe_VkMemoryRequirements2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryRequirements2::initialize(const VkMemoryRequirements2* in_struct)
{
    sType = in_struct->sType;
    memoryRequirements = in_struct->memoryRequirements;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryRequirements2::initialize(const safe_VkMemoryRequirements2* copy_src)
{
    sType = copy_src->sType;
    memoryRequirements = copy_src->memoryRequirements;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSparseImageMemoryRequirements2::safe_VkSparseImageMemoryRequirements2(const VkSparseImageMemoryRequirements2* in_struct) :
    sType(in_struct->sType),
    memoryRequirements(in_struct->memoryRequirements)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSparseImageMemoryRequirements2::safe_VkSparseImageMemoryRequirements2() :
    sType(VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2),
    pNext(nullptr)
{}

safe_VkSparseImageMemoryRequirements2::safe_VkSparseImageMemoryRequirements2(const safe_VkSparseImageMemoryRequirements2& copy_src)
{
    sType = copy_src.sType;
    memoryRequirements = copy_src.memoryRequirements;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSparseImageMemoryRequirements2& safe_VkSparseImageMemoryRequirements2::operator=(const safe_VkSparseImageMemoryRequirements2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    memoryRequirements = copy_src.memoryRequirements;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSparseImageMemoryRequirements2::~safe_VkSparseImageMemoryRequirements2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSparseImageMemoryRequirements2::initialize(const VkSparseImageMemoryRequirements2* in_struct)
{
    sType = in_struct->sType;
    memoryRequirements = in_struct->memoryRequirements;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSparseImageMemoryRequirements2::initialize(const safe_VkSparseImageMemoryRequirements2* copy_src)
{
    sType = copy_src->sType;
    memoryRequirements = copy_src->memoryRequirements;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceFeatures2::safe_VkPhysicalDeviceFeatures2(const VkPhysicalDeviceFeatures2* in_struct) :
    sType(in_struct->sType),
    features(in_struct->features)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceFeatures2::safe_VkPhysicalDeviceFeatures2() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceFeatures2::safe_VkPhysicalDeviceFeatures2(const safe_VkPhysicalDeviceFeatures2& copy_src)
{
    sType = copy_src.sType;
    features = copy_src.features;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceFeatures2& safe_VkPhysicalDeviceFeatures2::operator=(const safe_VkPhysicalDeviceFeatures2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    features = copy_src.features;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceFeatures2::~safe_VkPhysicalDeviceFeatures2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceFeatures2::initialize(const VkPhysicalDeviceFeatures2* in_struct)
{
    sType = in_struct->sType;
    features = in_struct->features;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceFeatures2::initialize(const safe_VkPhysicalDeviceFeatures2* copy_src)
{
    sType = copy_src->sType;
    features = copy_src->features;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceProperties2::safe_VkPhysicalDeviceProperties2(const VkPhysicalDeviceProperties2* in_struct) :
    sType(in_struct->sType),
    properties(in_struct->properties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceProperties2::safe_VkPhysicalDeviceProperties2() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceProperties2::safe_VkPhysicalDeviceProperties2(const safe_VkPhysicalDeviceProperties2& copy_src)
{
    sType = copy_src.sType;
    properties = copy_src.properties;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceProperties2& safe_VkPhysicalDeviceProperties2::operator=(const safe_VkPhysicalDeviceProperties2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    properties = copy_src.properties;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceProperties2::~safe_VkPhysicalDeviceProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceProperties2::initialize(const VkPhysicalDeviceProperties2* in_struct)
{
    sType = in_struct->sType;
    properties = in_struct->properties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceProperties2::initialize(const safe_VkPhysicalDeviceProperties2* copy_src)
{
    sType = copy_src->sType;
    properties = copy_src->properties;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkFormatProperties2::safe_VkFormatProperties2(const VkFormatProperties2* in_struct) :
    sType(in_struct->sType),
    formatProperties(in_struct->formatProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkFormatProperties2::safe_VkFormatProperties2() :
    sType(VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2),
    pNext(nullptr)
{}

safe_VkFormatProperties2::safe_VkFormatProperties2(const safe_VkFormatProperties2& copy_src)
{
    sType = copy_src.sType;
    formatProperties = copy_src.formatProperties;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkFormatProperties2& safe_VkFormatProperties2::operator=(const safe_VkFormatProperties2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    formatProperties = copy_src.formatProperties;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkFormatProperties2::~safe_VkFormatProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFormatProperties2::initialize(const VkFormatProperties2* in_struct)
{
    sType = in_struct->sType;
    formatProperties = in_struct->formatProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkFormatProperties2::initialize(const safe_VkFormatProperties2* copy_src)
{
    sType = copy_src->sType;
    formatProperties = copy_src->formatProperties;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkImageFormatProperties2::safe_VkImageFormatProperties2(const VkImageFormatProperties2* in_struct) :
    sType(in_struct->sType),
    imageFormatProperties(in_struct->imageFormatProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageFormatProperties2::safe_VkImageFormatProperties2() :
    sType(VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2),
    pNext(nullptr)
{}

safe_VkImageFormatProperties2::safe_VkImageFormatProperties2(const safe_VkImageFormatProperties2& copy_src)
{
    sType = copy_src.sType;
    imageFormatProperties = copy_src.imageFormatProperties;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageFormatProperties2& safe_VkImageFormatProperties2::operator=(const safe_VkImageFormatProperties2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    imageFormatProperties = copy_src.imageFormatProperties;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageFormatProperties2::~safe_VkImageFormatProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageFormatProperties2::initialize(const VkImageFormatProperties2* in_struct)
{
    sType = in_struct->sType;
    imageFormatProperties = in_struct->imageFormatProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageFormatProperties2::initialize(const safe_VkImageFormatProperties2* copy_src)
{
    sType = copy_src->sType;
    imageFormatProperties = copy_src->imageFormatProperties;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceImageFormatInfo2::safe_VkPhysicalDeviceImageFormatInfo2(const VkPhysicalDeviceImageFormatInfo2* in_struct) :
    sType(in_struct->sType),
    format(in_struct->format),
    type(in_struct->type),
    tiling(in_struct->tiling),
    usage(in_struct->usage),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceImageFormatInfo2::safe_VkPhysicalDeviceImageFormatInfo2() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceImageFormatInfo2::safe_VkPhysicalDeviceImageFormatInfo2(const safe_VkPhysicalDeviceImageFormatInfo2& copy_src)
{
    sType = copy_src.sType;
    format = copy_src.format;
    type = copy_src.type;
    tiling = copy_src.tiling;
    usage = copy_src.usage;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceImageFormatInfo2& safe_VkPhysicalDeviceImageFormatInfo2::operator=(const safe_VkPhysicalDeviceImageFormatInfo2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    format = copy_src.format;
    type = copy_src.type;
    tiling = copy_src.tiling;
    usage = copy_src.usage;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceImageFormatInfo2::~safe_VkPhysicalDeviceImageFormatInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceImageFormatInfo2::initialize(const VkPhysicalDeviceImageFormatInfo2* in_struct)
{
    sType = in_struct->sType;
    format = in_struct->format;
    type = in_struct->type;
    tiling = in_struct->tiling;
    usage = in_struct->usage;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceImageFormatInfo2::initialize(const safe_VkPhysicalDeviceImageFormatInfo2* copy_src)
{
    sType = copy_src->sType;
    format = copy_src->format;
    type = copy_src->type;
    tiling = copy_src->tiling;
    usage = copy_src->usage;
    flags = copy_src->flags;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkQueueFamilyProperties2::safe_VkQueueFamilyProperties2(const VkQueueFamilyProperties2* in_struct) :
    sType(in_struct->sType),
    queueFamilyProperties(in_struct->queueFamilyProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkQueueFamilyProperties2::safe_VkQueueFamilyProperties2() :
    sType(VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2),
    pNext(nullptr)
{}

safe_VkQueueFamilyProperties2::safe_VkQueueFamilyProperties2(const safe_VkQueueFamilyProperties2& copy_src)
{
    sType = copy_src.sType;
    queueFamilyProperties = copy_src.queueFamilyProperties;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkQueueFamilyProperties2& safe_VkQueueFamilyProperties2::operator=(const safe_VkQueueFamilyProperties2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    queueFamilyProperties = copy_src.queueFamilyProperties;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkQueueFamilyProperties2::~safe_VkQueueFamilyProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkQueueFamilyProperties2::initialize(const VkQueueFamilyProperties2* in_struct)
{
    sType = in_struct->sType;
    queueFamilyProperties = in_struct->queueFamilyProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkQueueFamilyProperties2::initialize(const safe_VkQueueFamilyProperties2* copy_src)
{
    sType = copy_src->sType;
    queueFamilyProperties = copy_src->queueFamilyProperties;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceMemoryProperties2::safe_VkPhysicalDeviceMemoryProperties2(const VkPhysicalDeviceMemoryProperties2* in_struct) :
    sType(in_struct->sType),
    memoryProperties(in_struct->memoryProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceMemoryProperties2::safe_VkPhysicalDeviceMemoryProperties2() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMemoryProperties2::safe_VkPhysicalDeviceMemoryProperties2(const safe_VkPhysicalDeviceMemoryProperties2& copy_src)
{
    sType = copy_src.sType;
    memoryProperties = copy_src.memoryProperties;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceMemoryProperties2& safe_VkPhysicalDeviceMemoryProperties2::operator=(const safe_VkPhysicalDeviceMemoryProperties2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    memoryProperties = copy_src.memoryProperties;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceMemoryProperties2::~safe_VkPhysicalDeviceMemoryProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMemoryProperties2::initialize(const VkPhysicalDeviceMemoryProperties2* in_struct)
{
    sType = in_struct->sType;
    memoryProperties = in_struct->memoryProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceMemoryProperties2::initialize(const safe_VkPhysicalDeviceMemoryProperties2* copy_src)
{
    sType = copy_src->sType;
    memoryProperties = copy_src->memoryProperties;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSparseImageFormatProperties2::safe_VkSparseImageFormatProperties2(const VkSparseImageFormatProperties2* in_struct) :
    sType(in_struct->sType),
    properties(in_struct->properties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSparseImageFormatProperties2::safe_VkSparseImageFormatProperties2() :
    sType(VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2),
    pNext(nullptr)
{}

safe_VkSparseImageFormatProperties2::safe_VkSparseImageFormatProperties2(const safe_VkSparseImageFormatProperties2& copy_src)
{
    sType = copy_src.sType;
    properties = copy_src.properties;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSparseImageFormatProperties2& safe_VkSparseImageFormatProperties2::operator=(const safe_VkSparseImageFormatProperties2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    properties = copy_src.properties;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSparseImageFormatProperties2::~safe_VkSparseImageFormatProperties2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSparseImageFormatProperties2::initialize(const VkSparseImageFormatProperties2* in_struct)
{
    sType = in_struct->sType;
    properties = in_struct->properties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSparseImageFormatProperties2::initialize(const safe_VkSparseImageFormatProperties2* copy_src)
{
    sType = copy_src->sType;
    properties = copy_src->properties;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceSparseImageFormatInfo2::safe_VkPhysicalDeviceSparseImageFormatInfo2(const VkPhysicalDeviceSparseImageFormatInfo2* in_struct) :
    sType(in_struct->sType),
    format(in_struct->format),
    type(in_struct->type),
    samples(in_struct->samples),
    usage(in_struct->usage),
    tiling(in_struct->tiling)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSparseImageFormatInfo2::safe_VkPhysicalDeviceSparseImageFormatInfo2() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSparseImageFormatInfo2::safe_VkPhysicalDeviceSparseImageFormatInfo2(const safe_VkPhysicalDeviceSparseImageFormatInfo2& copy_src)
{
    sType = copy_src.sType;
    format = copy_src.format;
    type = copy_src.type;
    samples = copy_src.samples;
    usage = copy_src.usage;
    tiling = copy_src.tiling;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceSparseImageFormatInfo2& safe_VkPhysicalDeviceSparseImageFormatInfo2::operator=(const safe_VkPhysicalDeviceSparseImageFormatInfo2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    format = copy_src.format;
    type = copy_src.type;
    samples = copy_src.samples;
    usage = copy_src.usage;
    tiling = copy_src.tiling;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSparseImageFormatInfo2::~safe_VkPhysicalDeviceSparseImageFormatInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSparseImageFormatInfo2::initialize(const VkPhysicalDeviceSparseImageFormatInfo2* in_struct)
{
    sType = in_struct->sType;
    format = in_struct->format;
    type = in_struct->type;
    samples = in_struct->samples;
    usage = in_struct->usage;
    tiling = in_struct->tiling;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSparseImageFormatInfo2::initialize(const safe_VkPhysicalDeviceSparseImageFormatInfo2* copy_src)
{
    sType = copy_src->sType;
    format = copy_src->format;
    type = copy_src->type;
    samples = copy_src->samples;
    usage = copy_src->usage;
    tiling = copy_src->tiling;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDevicePointClippingProperties::safe_VkPhysicalDevicePointClippingProperties(const VkPhysicalDevicePointClippingProperties* in_struct) :
    sType(in_struct->sType),
    pointClippingBehavior(in_struct->pointClippingBehavior)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePointClippingProperties::safe_VkPhysicalDevicePointClippingProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDevicePointClippingProperties::safe_VkPhysicalDevicePointClippingProperties(const safe_VkPhysicalDevicePointClippingProperties& copy_src)
{
    sType = copy_src.sType;
    pointClippingBehavior = copy_src.pointClippingBehavior;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDevicePointClippingProperties& safe_VkPhysicalDevicePointClippingProperties::operator=(const safe_VkPhysicalDevicePointClippingProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pointClippingBehavior = copy_src.pointClippingBehavior;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDevicePointClippingProperties::~safe_VkPhysicalDevicePointClippingProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePointClippingProperties::initialize(const VkPhysicalDevicePointClippingProperties* in_struct)
{
    sType = in_struct->sType;
    pointClippingBehavior = in_struct->pointClippingBehavior;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePointClippingProperties::initialize(const safe_VkPhysicalDevicePointClippingProperties* copy_src)
{
    sType = copy_src->sType;
    pointClippingBehavior = copy_src->pointClippingBehavior;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkRenderPassInputAttachmentAspectCreateInfo::safe_VkRenderPassInputAttachmentAspectCreateInfo(const VkRenderPassInputAttachmentAspectCreateInfo* in_struct) :
    sType(in_struct->sType),
    aspectReferenceCount(in_struct->aspectReferenceCount),
    pAspectReferences(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAspectReferences) {
        pAspectReferences = new VkInputAttachmentAspectReference[in_struct->aspectReferenceCount];
        memcpy ((void *)pAspectReferences, (void *)in_struct->pAspectReferences, sizeof(VkInputAttachmentAspectReference)*in_struct->aspectReferenceCount);
    }
}

safe_VkRenderPassInputAttachmentAspectCreateInfo::safe_VkRenderPassInputAttachmentAspectCreateInfo() :
    sType(VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO),
    pNext(nullptr),
    pAspectReferences(nullptr)
{}

safe_VkRenderPassInputAttachmentAspectCreateInfo::safe_VkRenderPassInputAttachmentAspectCreateInfo(const safe_VkRenderPassInputAttachmentAspectCreateInfo& copy_src)
{
    sType = copy_src.sType;
    aspectReferenceCount = copy_src.aspectReferenceCount;
    pAspectReferences = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAspectReferences) {
        pAspectReferences = new VkInputAttachmentAspectReference[copy_src.aspectReferenceCount];
        memcpy ((void *)pAspectReferences, (void *)copy_src.pAspectReferences, sizeof(VkInputAttachmentAspectReference)*copy_src.aspectReferenceCount);
    }
}

safe_VkRenderPassInputAttachmentAspectCreateInfo& safe_VkRenderPassInputAttachmentAspectCreateInfo::operator=(const safe_VkRenderPassInputAttachmentAspectCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pAspectReferences)
        delete[] pAspectReferences;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    aspectReferenceCount = copy_src.aspectReferenceCount;
    pAspectReferences = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAspectReferences) {
        pAspectReferences = new VkInputAttachmentAspectReference[copy_src.aspectReferenceCount];
        memcpy ((void *)pAspectReferences, (void *)copy_src.pAspectReferences, sizeof(VkInputAttachmentAspectReference)*copy_src.aspectReferenceCount);
    }

    return *this;
}

safe_VkRenderPassInputAttachmentAspectCreateInfo::~safe_VkRenderPassInputAttachmentAspectCreateInfo()
{
    if (pAspectReferences)
        delete[] pAspectReferences;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassInputAttachmentAspectCreateInfo::initialize(const VkRenderPassInputAttachmentAspectCreateInfo* in_struct)
{
    sType = in_struct->sType;
    aspectReferenceCount = in_struct->aspectReferenceCount;
    pAspectReferences = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAspectReferences) {
        pAspectReferences = new VkInputAttachmentAspectReference[in_struct->aspectReferenceCount];
        memcpy ((void *)pAspectReferences, (void *)in_struct->pAspectReferences, sizeof(VkInputAttachmentAspectReference)*in_struct->aspectReferenceCount);
    }
}

void safe_VkRenderPassInputAttachmentAspectCreateInfo::initialize(const safe_VkRenderPassInputAttachmentAspectCreateInfo* copy_src)
{
    sType = copy_src->sType;
    aspectReferenceCount = copy_src->aspectReferenceCount;
    pAspectReferences = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pAspectReferences) {
        pAspectReferences = new VkInputAttachmentAspectReference[copy_src->aspectReferenceCount];
        memcpy ((void *)pAspectReferences, (void *)copy_src->pAspectReferences, sizeof(VkInputAttachmentAspectReference)*copy_src->aspectReferenceCount);
    }
}

safe_VkImageViewUsageCreateInfo::safe_VkImageViewUsageCreateInfo(const VkImageViewUsageCreateInfo* in_struct) :
    sType(in_struct->sType),
    usage(in_struct->usage)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageViewUsageCreateInfo::safe_VkImageViewUsageCreateInfo() :
    sType(VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkImageViewUsageCreateInfo::safe_VkImageViewUsageCreateInfo(const safe_VkImageViewUsageCreateInfo& copy_src)
{
    sType = copy_src.sType;
    usage = copy_src.usage;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageViewUsageCreateInfo& safe_VkImageViewUsageCreateInfo::operator=(const safe_VkImageViewUsageCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    usage = copy_src.usage;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageViewUsageCreateInfo::~safe_VkImageViewUsageCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageViewUsageCreateInfo::initialize(const VkImageViewUsageCreateInfo* in_struct)
{
    sType = in_struct->sType;
    usage = in_struct->usage;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageViewUsageCreateInfo::initialize(const safe_VkImageViewUsageCreateInfo* copy_src)
{
    sType = copy_src->sType;
    usage = copy_src->usage;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineTessellationDomainOriginStateCreateInfo::safe_VkPipelineTessellationDomainOriginStateCreateInfo(const VkPipelineTessellationDomainOriginStateCreateInfo* in_struct) :
    sType(in_struct->sType),
    domainOrigin(in_struct->domainOrigin)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineTessellationDomainOriginStateCreateInfo::safe_VkPipelineTessellationDomainOriginStateCreateInfo() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkPipelineTessellationDomainOriginStateCreateInfo::safe_VkPipelineTessellationDomainOriginStateCreateInfo(const safe_VkPipelineTessellationDomainOriginStateCreateInfo& copy_src)
{
    sType = copy_src.sType;
    domainOrigin = copy_src.domainOrigin;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPipelineTessellationDomainOriginStateCreateInfo& safe_VkPipelineTessellationDomainOriginStateCreateInfo::operator=(const safe_VkPipelineTessellationDomainOriginStateCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    domainOrigin = copy_src.domainOrigin;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPipelineTessellationDomainOriginStateCreateInfo::~safe_VkPipelineTessellationDomainOriginStateCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineTessellationDomainOriginStateCreateInfo::initialize(const VkPipelineTessellationDomainOriginStateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    domainOrigin = in_struct->domainOrigin;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineTessellationDomainOriginStateCreateInfo::initialize(const safe_VkPipelineTessellationDomainOriginStateCreateInfo* copy_src)
{
    sType = copy_src->sType;
    domainOrigin = copy_src->domainOrigin;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkRenderPassMultiviewCreateInfo::safe_VkRenderPassMultiviewCreateInfo(const VkRenderPassMultiviewCreateInfo* in_struct) :
    sType(in_struct->sType),
    subpassCount(in_struct->subpassCount),
    pViewMasks(nullptr),
    dependencyCount(in_struct->dependencyCount),
    pViewOffsets(nullptr),
    correlationMaskCount(in_struct->correlationMaskCount),
    pCorrelationMasks(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewMasks) {
        pViewMasks = new uint32_t[in_struct->subpassCount];
        memcpy ((void *)pViewMasks, (void *)in_struct->pViewMasks, sizeof(uint32_t)*in_struct->subpassCount);
    }
    if (in_struct->pViewOffsets) {
        pViewOffsets = new int32_t[in_struct->dependencyCount];
        memcpy ((void *)pViewOffsets, (void *)in_struct->pViewOffsets, sizeof(int32_t)*in_struct->dependencyCount);
    }
    if (in_struct->pCorrelationMasks) {
        pCorrelationMasks = new uint32_t[in_struct->correlationMaskCount];
        memcpy ((void *)pCorrelationMasks, (void *)in_struct->pCorrelationMasks, sizeof(uint32_t)*in_struct->correlationMaskCount);
    }
}

safe_VkRenderPassMultiviewCreateInfo::safe_VkRenderPassMultiviewCreateInfo() :
    sType(VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO),
    pNext(nullptr),
    pViewMasks(nullptr),
    pViewOffsets(nullptr),
    pCorrelationMasks(nullptr)
{}

safe_VkRenderPassMultiviewCreateInfo::safe_VkRenderPassMultiviewCreateInfo(const safe_VkRenderPassMultiviewCreateInfo& copy_src)
{
    sType = copy_src.sType;
    subpassCount = copy_src.subpassCount;
    pViewMasks = nullptr;
    dependencyCount = copy_src.dependencyCount;
    pViewOffsets = nullptr;
    correlationMaskCount = copy_src.correlationMaskCount;
    pCorrelationMasks = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pViewMasks) {
        pViewMasks = new uint32_t[copy_src.subpassCount];
        memcpy ((void *)pViewMasks, (void *)copy_src.pViewMasks, sizeof(uint32_t)*copy_src.subpassCount);
    }
    if (copy_src.pViewOffsets) {
        pViewOffsets = new int32_t[copy_src.dependencyCount];
        memcpy ((void *)pViewOffsets, (void *)copy_src.pViewOffsets, sizeof(int32_t)*copy_src.dependencyCount);
    }
    if (copy_src.pCorrelationMasks) {
        pCorrelationMasks = new uint32_t[copy_src.correlationMaskCount];
        memcpy ((void *)pCorrelationMasks, (void *)copy_src.pCorrelationMasks, sizeof(uint32_t)*copy_src.correlationMaskCount);
    }
}

safe_VkRenderPassMultiviewCreateInfo& safe_VkRenderPassMultiviewCreateInfo::operator=(const safe_VkRenderPassMultiviewCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pViewMasks)
        delete[] pViewMasks;
    if (pViewOffsets)
        delete[] pViewOffsets;
    if (pCorrelationMasks)
        delete[] pCorrelationMasks;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    subpassCount = copy_src.subpassCount;
    pViewMasks = nullptr;
    dependencyCount = copy_src.dependencyCount;
    pViewOffsets = nullptr;
    correlationMaskCount = copy_src.correlationMaskCount;
    pCorrelationMasks = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pViewMasks) {
        pViewMasks = new uint32_t[copy_src.subpassCount];
        memcpy ((void *)pViewMasks, (void *)copy_src.pViewMasks, sizeof(uint32_t)*copy_src.subpassCount);
    }
    if (copy_src.pViewOffsets) {
        pViewOffsets = new int32_t[copy_src.dependencyCount];
        memcpy ((void *)pViewOffsets, (void *)copy_src.pViewOffsets, sizeof(int32_t)*copy_src.dependencyCount);
    }
    if (copy_src.pCorrelationMasks) {
        pCorrelationMasks = new uint32_t[copy_src.correlationMaskCount];
        memcpy ((void *)pCorrelationMasks, (void *)copy_src.pCorrelationMasks, sizeof(uint32_t)*copy_src.correlationMaskCount);
    }

    return *this;
}

safe_VkRenderPassMultiviewCreateInfo::~safe_VkRenderPassMultiviewCreateInfo()
{
    if (pViewMasks)
        delete[] pViewMasks;
    if (pViewOffsets)
        delete[] pViewOffsets;
    if (pCorrelationMasks)
        delete[] pCorrelationMasks;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassMultiviewCreateInfo::initialize(const VkRenderPassMultiviewCreateInfo* in_struct)
{
    sType = in_struct->sType;
    subpassCount = in_struct->subpassCount;
    pViewMasks = nullptr;
    dependencyCount = in_struct->dependencyCount;
    pViewOffsets = nullptr;
    correlationMaskCount = in_struct->correlationMaskCount;
    pCorrelationMasks = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewMasks) {
        pViewMasks = new uint32_t[in_struct->subpassCount];
        memcpy ((void *)pViewMasks, (void *)in_struct->pViewMasks, sizeof(uint32_t)*in_struct->subpassCount);
    }
    if (in_struct->pViewOffsets) {
        pViewOffsets = new int32_t[in_struct->dependencyCount];
        memcpy ((void *)pViewOffsets, (void *)in_struct->pViewOffsets, sizeof(int32_t)*in_struct->dependencyCount);
    }
    if (in_struct->pCorrelationMasks) {
        pCorrelationMasks = new uint32_t[in_struct->correlationMaskCount];
        memcpy ((void *)pCorrelationMasks, (void *)in_struct->pCorrelationMasks, sizeof(uint32_t)*in_struct->correlationMaskCount);
    }
}

void safe_VkRenderPassMultiviewCreateInfo::initialize(const safe_VkRenderPassMultiviewCreateInfo* copy_src)
{
    sType = copy_src->sType;
    subpassCount = copy_src->subpassCount;
    pViewMasks = nullptr;
    dependencyCount = copy_src->dependencyCount;
    pViewOffsets = nullptr;
    correlationMaskCount = copy_src->correlationMaskCount;
    pCorrelationMasks = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pViewMasks) {
        pViewMasks = new uint32_t[copy_src->subpassCount];
        memcpy ((void *)pViewMasks, (void *)copy_src->pViewMasks, sizeof(uint32_t)*copy_src->subpassCount);
    }
    if (copy_src->pViewOffsets) {
        pViewOffsets = new int32_t[copy_src->dependencyCount];
        memcpy ((void *)pViewOffsets, (void *)copy_src->pViewOffsets, sizeof(int32_t)*copy_src->dependencyCount);
    }
    if (copy_src->pCorrelationMasks) {
        pCorrelationMasks = new uint32_t[copy_src->correlationMaskCount];
        memcpy ((void *)pCorrelationMasks, (void *)copy_src->pCorrelationMasks, sizeof(uint32_t)*copy_src->correlationMaskCount);
    }
}

safe_VkPhysicalDeviceMultiviewFeatures::safe_VkPhysicalDeviceMultiviewFeatures(const VkPhysicalDeviceMultiviewFeatures* in_struct) :
    sType(in_struct->sType),
    multiview(in_struct->multiview),
    multiviewGeometryShader(in_struct->multiviewGeometryShader),
    multiviewTessellationShader(in_struct->multiviewTessellationShader)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceMultiviewFeatures::safe_VkPhysicalDeviceMultiviewFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMultiviewFeatures::safe_VkPhysicalDeviceMultiviewFeatures(const safe_VkPhysicalDeviceMultiviewFeatures& copy_src)
{
    sType = copy_src.sType;
    multiview = copy_src.multiview;
    multiviewGeometryShader = copy_src.multiviewGeometryShader;
    multiviewTessellationShader = copy_src.multiviewTessellationShader;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceMultiviewFeatures& safe_VkPhysicalDeviceMultiviewFeatures::operator=(const safe_VkPhysicalDeviceMultiviewFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    multiview = copy_src.multiview;
    multiviewGeometryShader = copy_src.multiviewGeometryShader;
    multiviewTessellationShader = copy_src.multiviewTessellationShader;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceMultiviewFeatures::~safe_VkPhysicalDeviceMultiviewFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMultiviewFeatures::initialize(const VkPhysicalDeviceMultiviewFeatures* in_struct)
{
    sType = in_struct->sType;
    multiview = in_struct->multiview;
    multiviewGeometryShader = in_struct->multiviewGeometryShader;
    multiviewTessellationShader = in_struct->multiviewTessellationShader;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceMultiviewFeatures::initialize(const safe_VkPhysicalDeviceMultiviewFeatures* copy_src)
{
    sType = copy_src->sType;
    multiview = copy_src->multiview;
    multiviewGeometryShader = copy_src->multiviewGeometryShader;
    multiviewTessellationShader = copy_src->multiviewTessellationShader;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceMultiviewProperties::safe_VkPhysicalDeviceMultiviewProperties(const VkPhysicalDeviceMultiviewProperties* in_struct) :
    sType(in_struct->sType),
    maxMultiviewViewCount(in_struct->maxMultiviewViewCount),
    maxMultiviewInstanceIndex(in_struct->maxMultiviewInstanceIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceMultiviewProperties::safe_VkPhysicalDeviceMultiviewProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMultiviewProperties::safe_VkPhysicalDeviceMultiviewProperties(const safe_VkPhysicalDeviceMultiviewProperties& copy_src)
{
    sType = copy_src.sType;
    maxMultiviewViewCount = copy_src.maxMultiviewViewCount;
    maxMultiviewInstanceIndex = copy_src.maxMultiviewInstanceIndex;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceMultiviewProperties& safe_VkPhysicalDeviceMultiviewProperties::operator=(const safe_VkPhysicalDeviceMultiviewProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    maxMultiviewViewCount = copy_src.maxMultiviewViewCount;
    maxMultiviewInstanceIndex = copy_src.maxMultiviewInstanceIndex;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceMultiviewProperties::~safe_VkPhysicalDeviceMultiviewProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMultiviewProperties::initialize(const VkPhysicalDeviceMultiviewProperties* in_struct)
{
    sType = in_struct->sType;
    maxMultiviewViewCount = in_struct->maxMultiviewViewCount;
    maxMultiviewInstanceIndex = in_struct->maxMultiviewInstanceIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceMultiviewProperties::initialize(const safe_VkPhysicalDeviceMultiviewProperties* copy_src)
{
    sType = copy_src->sType;
    maxMultiviewViewCount = copy_src->maxMultiviewViewCount;
    maxMultiviewInstanceIndex = copy_src->maxMultiviewInstanceIndex;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceVariablePointersFeatures::safe_VkPhysicalDeviceVariablePointersFeatures(const VkPhysicalDeviceVariablePointersFeatures* in_struct) :
    sType(in_struct->sType),
    variablePointersStorageBuffer(in_struct->variablePointersStorageBuffer),
    variablePointers(in_struct->variablePointers)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceVariablePointersFeatures::safe_VkPhysicalDeviceVariablePointersFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceVariablePointersFeatures::safe_VkPhysicalDeviceVariablePointersFeatures(const safe_VkPhysicalDeviceVariablePointersFeatures& copy_src)
{
    sType = copy_src.sType;
    variablePointersStorageBuffer = copy_src.variablePointersStorageBuffer;
    variablePointers = copy_src.variablePointers;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceVariablePointersFeatures& safe_VkPhysicalDeviceVariablePointersFeatures::operator=(const safe_VkPhysicalDeviceVariablePointersFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    variablePointersStorageBuffer = copy_src.variablePointersStorageBuffer;
    variablePointers = copy_src.variablePointers;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceVariablePointersFeatures::~safe_VkPhysicalDeviceVariablePointersFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceVariablePointersFeatures::initialize(const VkPhysicalDeviceVariablePointersFeatures* in_struct)
{
    sType = in_struct->sType;
    variablePointersStorageBuffer = in_struct->variablePointersStorageBuffer;
    variablePointers = in_struct->variablePointers;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceVariablePointersFeatures::initialize(const safe_VkPhysicalDeviceVariablePointersFeatures* copy_src)
{
    sType = copy_src->sType;
    variablePointersStorageBuffer = copy_src->variablePointersStorageBuffer;
    variablePointers = copy_src->variablePointers;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceProtectedMemoryFeatures::safe_VkPhysicalDeviceProtectedMemoryFeatures(const VkPhysicalDeviceProtectedMemoryFeatures* in_struct) :
    sType(in_struct->sType),
    protectedMemory(in_struct->protectedMemory)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceProtectedMemoryFeatures::safe_VkPhysicalDeviceProtectedMemoryFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceProtectedMemoryFeatures::safe_VkPhysicalDeviceProtectedMemoryFeatures(const safe_VkPhysicalDeviceProtectedMemoryFeatures& copy_src)
{
    sType = copy_src.sType;
    protectedMemory = copy_src.protectedMemory;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceProtectedMemoryFeatures& safe_VkPhysicalDeviceProtectedMemoryFeatures::operator=(const safe_VkPhysicalDeviceProtectedMemoryFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    protectedMemory = copy_src.protectedMemory;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceProtectedMemoryFeatures::~safe_VkPhysicalDeviceProtectedMemoryFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceProtectedMemoryFeatures::initialize(const VkPhysicalDeviceProtectedMemoryFeatures* in_struct)
{
    sType = in_struct->sType;
    protectedMemory = in_struct->protectedMemory;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceProtectedMemoryFeatures::initialize(const safe_VkPhysicalDeviceProtectedMemoryFeatures* copy_src)
{
    sType = copy_src->sType;
    protectedMemory = copy_src->protectedMemory;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceProtectedMemoryProperties::safe_VkPhysicalDeviceProtectedMemoryProperties(const VkPhysicalDeviceProtectedMemoryProperties* in_struct) :
    sType(in_struct->sType),
    protectedNoFault(in_struct->protectedNoFault)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceProtectedMemoryProperties::safe_VkPhysicalDeviceProtectedMemoryProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceProtectedMemoryProperties::safe_VkPhysicalDeviceProtectedMemoryProperties(const safe_VkPhysicalDeviceProtectedMemoryProperties& copy_src)
{
    sType = copy_src.sType;
    protectedNoFault = copy_src.protectedNoFault;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceProtectedMemoryProperties& safe_VkPhysicalDeviceProtectedMemoryProperties::operator=(const safe_VkPhysicalDeviceProtectedMemoryProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    protectedNoFault = copy_src.protectedNoFault;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceProtectedMemoryProperties::~safe_VkPhysicalDeviceProtectedMemoryProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceProtectedMemoryProperties::initialize(const VkPhysicalDeviceProtectedMemoryProperties* in_struct)
{
    sType = in_struct->sType;
    protectedNoFault = in_struct->protectedNoFault;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceProtectedMemoryProperties::initialize(const safe_VkPhysicalDeviceProtectedMemoryProperties* copy_src)
{
    sType = copy_src->sType;
    protectedNoFault = copy_src->protectedNoFault;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDeviceQueueInfo2::safe_VkDeviceQueueInfo2(const VkDeviceQueueInfo2* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    queueFamilyIndex(in_struct->queueFamilyIndex),
    queueIndex(in_struct->queueIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceQueueInfo2::safe_VkDeviceQueueInfo2() :
    sType(VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2),
    pNext(nullptr)
{}

safe_VkDeviceQueueInfo2::safe_VkDeviceQueueInfo2(const safe_VkDeviceQueueInfo2& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    queueFamilyIndex = copy_src.queueFamilyIndex;
    queueIndex = copy_src.queueIndex;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDeviceQueueInfo2& safe_VkDeviceQueueInfo2::operator=(const safe_VkDeviceQueueInfo2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    queueFamilyIndex = copy_src.queueFamilyIndex;
    queueIndex = copy_src.queueIndex;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDeviceQueueInfo2::~safe_VkDeviceQueueInfo2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceQueueInfo2::initialize(const VkDeviceQueueInfo2* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    queueFamilyIndex = in_struct->queueFamilyIndex;
    queueIndex = in_struct->queueIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceQueueInfo2::initialize(const safe_VkDeviceQueueInfo2* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    queueFamilyIndex = copy_src->queueFamilyIndex;
    queueIndex = copy_src->queueIndex;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkProtectedSubmitInfo::safe_VkProtectedSubmitInfo(const VkProtectedSubmitInfo* in_struct) :
    sType(in_struct->sType),
    protectedSubmit(in_struct->protectedSubmit)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkProtectedSubmitInfo::safe_VkProtectedSubmitInfo() :
    sType(VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO),
    pNext(nullptr)
{}

safe_VkProtectedSubmitInfo::safe_VkProtectedSubmitInfo(const safe_VkProtectedSubmitInfo& copy_src)
{
    sType = copy_src.sType;
    protectedSubmit = copy_src.protectedSubmit;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkProtectedSubmitInfo& safe_VkProtectedSubmitInfo::operator=(const safe_VkProtectedSubmitInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    protectedSubmit = copy_src.protectedSubmit;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkProtectedSubmitInfo::~safe_VkProtectedSubmitInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkProtectedSubmitInfo::initialize(const VkProtectedSubmitInfo* in_struct)
{
    sType = in_struct->sType;
    protectedSubmit = in_struct->protectedSubmit;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkProtectedSubmitInfo::initialize(const safe_VkProtectedSubmitInfo* copy_src)
{
    sType = copy_src->sType;
    protectedSubmit = copy_src->protectedSubmit;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSamplerYcbcrConversionCreateInfo::safe_VkSamplerYcbcrConversionCreateInfo(const VkSamplerYcbcrConversionCreateInfo* in_struct) :
    sType(in_struct->sType),
    format(in_struct->format),
    ycbcrModel(in_struct->ycbcrModel),
    ycbcrRange(in_struct->ycbcrRange),
    components(in_struct->components),
    xChromaOffset(in_struct->xChromaOffset),
    yChromaOffset(in_struct->yChromaOffset),
    chromaFilter(in_struct->chromaFilter),
    forceExplicitReconstruction(in_struct->forceExplicitReconstruction)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSamplerYcbcrConversionCreateInfo::safe_VkSamplerYcbcrConversionCreateInfo() :
    sType(VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkSamplerYcbcrConversionCreateInfo::safe_VkSamplerYcbcrConversionCreateInfo(const safe_VkSamplerYcbcrConversionCreateInfo& copy_src)
{
    sType = copy_src.sType;
    format = copy_src.format;
    ycbcrModel = copy_src.ycbcrModel;
    ycbcrRange = copy_src.ycbcrRange;
    components = copy_src.components;
    xChromaOffset = copy_src.xChromaOffset;
    yChromaOffset = copy_src.yChromaOffset;
    chromaFilter = copy_src.chromaFilter;
    forceExplicitReconstruction = copy_src.forceExplicitReconstruction;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSamplerYcbcrConversionCreateInfo& safe_VkSamplerYcbcrConversionCreateInfo::operator=(const safe_VkSamplerYcbcrConversionCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    format = copy_src.format;
    ycbcrModel = copy_src.ycbcrModel;
    ycbcrRange = copy_src.ycbcrRange;
    components = copy_src.components;
    xChromaOffset = copy_src.xChromaOffset;
    yChromaOffset = copy_src.yChromaOffset;
    chromaFilter = copy_src.chromaFilter;
    forceExplicitReconstruction = copy_src.forceExplicitReconstruction;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSamplerYcbcrConversionCreateInfo::~safe_VkSamplerYcbcrConversionCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSamplerYcbcrConversionCreateInfo::initialize(const VkSamplerYcbcrConversionCreateInfo* in_struct)
{
    sType = in_struct->sType;
    format = in_struct->format;
    ycbcrModel = in_struct->ycbcrModel;
    ycbcrRange = in_struct->ycbcrRange;
    components = in_struct->components;
    xChromaOffset = in_struct->xChromaOffset;
    yChromaOffset = in_struct->yChromaOffset;
    chromaFilter = in_struct->chromaFilter;
    forceExplicitReconstruction = in_struct->forceExplicitReconstruction;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSamplerYcbcrConversionCreateInfo::initialize(const safe_VkSamplerYcbcrConversionCreateInfo* copy_src)
{
    sType = copy_src->sType;
    format = copy_src->format;
    ycbcrModel = copy_src->ycbcrModel;
    ycbcrRange = copy_src->ycbcrRange;
    components = copy_src->components;
    xChromaOffset = copy_src->xChromaOffset;
    yChromaOffset = copy_src->yChromaOffset;
    chromaFilter = copy_src->chromaFilter;
    forceExplicitReconstruction = copy_src->forceExplicitReconstruction;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSamplerYcbcrConversionInfo::safe_VkSamplerYcbcrConversionInfo(const VkSamplerYcbcrConversionInfo* in_struct) :
    sType(in_struct->sType),
    conversion(in_struct->conversion)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSamplerYcbcrConversionInfo::safe_VkSamplerYcbcrConversionInfo() :
    sType(VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO),
    pNext(nullptr)
{}

safe_VkSamplerYcbcrConversionInfo::safe_VkSamplerYcbcrConversionInfo(const safe_VkSamplerYcbcrConversionInfo& copy_src)
{
    sType = copy_src.sType;
    conversion = copy_src.conversion;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSamplerYcbcrConversionInfo& safe_VkSamplerYcbcrConversionInfo::operator=(const safe_VkSamplerYcbcrConversionInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    conversion = copy_src.conversion;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSamplerYcbcrConversionInfo::~safe_VkSamplerYcbcrConversionInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSamplerYcbcrConversionInfo::initialize(const VkSamplerYcbcrConversionInfo* in_struct)
{
    sType = in_struct->sType;
    conversion = in_struct->conversion;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSamplerYcbcrConversionInfo::initialize(const safe_VkSamplerYcbcrConversionInfo* copy_src)
{
    sType = copy_src->sType;
    conversion = copy_src->conversion;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkBindImagePlaneMemoryInfo::safe_VkBindImagePlaneMemoryInfo(const VkBindImagePlaneMemoryInfo* in_struct) :
    sType(in_struct->sType),
    planeAspect(in_struct->planeAspect)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBindImagePlaneMemoryInfo::safe_VkBindImagePlaneMemoryInfo() :
    sType(VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO),
    pNext(nullptr)
{}

safe_VkBindImagePlaneMemoryInfo::safe_VkBindImagePlaneMemoryInfo(const safe_VkBindImagePlaneMemoryInfo& copy_src)
{
    sType = copy_src.sType;
    planeAspect = copy_src.planeAspect;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBindImagePlaneMemoryInfo& safe_VkBindImagePlaneMemoryInfo::operator=(const safe_VkBindImagePlaneMemoryInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    planeAspect = copy_src.planeAspect;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBindImagePlaneMemoryInfo::~safe_VkBindImagePlaneMemoryInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindImagePlaneMemoryInfo::initialize(const VkBindImagePlaneMemoryInfo* in_struct)
{
    sType = in_struct->sType;
    planeAspect = in_struct->planeAspect;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBindImagePlaneMemoryInfo::initialize(const safe_VkBindImagePlaneMemoryInfo* copy_src)
{
    sType = copy_src->sType;
    planeAspect = copy_src->planeAspect;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkImagePlaneMemoryRequirementsInfo::safe_VkImagePlaneMemoryRequirementsInfo(const VkImagePlaneMemoryRequirementsInfo* in_struct) :
    sType(in_struct->sType),
    planeAspect(in_struct->planeAspect)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImagePlaneMemoryRequirementsInfo::safe_VkImagePlaneMemoryRequirementsInfo() :
    sType(VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO),
    pNext(nullptr)
{}

safe_VkImagePlaneMemoryRequirementsInfo::safe_VkImagePlaneMemoryRequirementsInfo(const safe_VkImagePlaneMemoryRequirementsInfo& copy_src)
{
    sType = copy_src.sType;
    planeAspect = copy_src.planeAspect;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImagePlaneMemoryRequirementsInfo& safe_VkImagePlaneMemoryRequirementsInfo::operator=(const safe_VkImagePlaneMemoryRequirementsInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    planeAspect = copy_src.planeAspect;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImagePlaneMemoryRequirementsInfo::~safe_VkImagePlaneMemoryRequirementsInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImagePlaneMemoryRequirementsInfo::initialize(const VkImagePlaneMemoryRequirementsInfo* in_struct)
{
    sType = in_struct->sType;
    planeAspect = in_struct->planeAspect;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImagePlaneMemoryRequirementsInfo::initialize(const safe_VkImagePlaneMemoryRequirementsInfo* copy_src)
{
    sType = copy_src->sType;
    planeAspect = copy_src->planeAspect;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures(const VkPhysicalDeviceSamplerYcbcrConversionFeatures* in_struct) :
    sType(in_struct->sType),
    samplerYcbcrConversion(in_struct->samplerYcbcrConversion)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures(const safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures& copy_src)
{
    sType = copy_src.sType;
    samplerYcbcrConversion = copy_src.samplerYcbcrConversion;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures& safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::operator=(const safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    samplerYcbcrConversion = copy_src.samplerYcbcrConversion;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::~safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::initialize(const VkPhysicalDeviceSamplerYcbcrConversionFeatures* in_struct)
{
    sType = in_struct->sType;
    samplerYcbcrConversion = in_struct->samplerYcbcrConversion;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures::initialize(const safe_VkPhysicalDeviceSamplerYcbcrConversionFeatures* copy_src)
{
    sType = copy_src->sType;
    samplerYcbcrConversion = copy_src->samplerYcbcrConversion;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSamplerYcbcrConversionImageFormatProperties::safe_VkSamplerYcbcrConversionImageFormatProperties(const VkSamplerYcbcrConversionImageFormatProperties* in_struct) :
    sType(in_struct->sType),
    combinedImageSamplerDescriptorCount(in_struct->combinedImageSamplerDescriptorCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSamplerYcbcrConversionImageFormatProperties::safe_VkSamplerYcbcrConversionImageFormatProperties() :
    sType(VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES),
    pNext(nullptr)
{}

safe_VkSamplerYcbcrConversionImageFormatProperties::safe_VkSamplerYcbcrConversionImageFormatProperties(const safe_VkSamplerYcbcrConversionImageFormatProperties& copy_src)
{
    sType = copy_src.sType;
    combinedImageSamplerDescriptorCount = copy_src.combinedImageSamplerDescriptorCount;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSamplerYcbcrConversionImageFormatProperties& safe_VkSamplerYcbcrConversionImageFormatProperties::operator=(const safe_VkSamplerYcbcrConversionImageFormatProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    combinedImageSamplerDescriptorCount = copy_src.combinedImageSamplerDescriptorCount;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSamplerYcbcrConversionImageFormatProperties::~safe_VkSamplerYcbcrConversionImageFormatProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSamplerYcbcrConversionImageFormatProperties::initialize(const VkSamplerYcbcrConversionImageFormatProperties* in_struct)
{
    sType = in_struct->sType;
    combinedImageSamplerDescriptorCount = in_struct->combinedImageSamplerDescriptorCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSamplerYcbcrConversionImageFormatProperties::initialize(const safe_VkSamplerYcbcrConversionImageFormatProperties* copy_src)
{
    sType = copy_src->sType;
    combinedImageSamplerDescriptorCount = copy_src->combinedImageSamplerDescriptorCount;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDescriptorUpdateTemplateCreateInfo::safe_VkDescriptorUpdateTemplateCreateInfo(const VkDescriptorUpdateTemplateCreateInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    descriptorUpdateEntryCount(in_struct->descriptorUpdateEntryCount),
    pDescriptorUpdateEntries(nullptr),
    templateType(in_struct->templateType),
    descriptorSetLayout(in_struct->descriptorSetLayout),
    pipelineBindPoint(in_struct->pipelineBindPoint),
    pipelineLayout(in_struct->pipelineLayout),
    set(in_struct->set)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDescriptorUpdateEntries) {
        pDescriptorUpdateEntries = new VkDescriptorUpdateTemplateEntry[in_struct->descriptorUpdateEntryCount];
        memcpy ((void *)pDescriptorUpdateEntries, (void *)in_struct->pDescriptorUpdateEntries, sizeof(VkDescriptorUpdateTemplateEntry)*in_struct->descriptorUpdateEntryCount);
    }
}

safe_VkDescriptorUpdateTemplateCreateInfo::safe_VkDescriptorUpdateTemplateCreateInfo() :
    sType(VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO),
    pNext(nullptr),
    pDescriptorUpdateEntries(nullptr)
{}

safe_VkDescriptorUpdateTemplateCreateInfo::safe_VkDescriptorUpdateTemplateCreateInfo(const safe_VkDescriptorUpdateTemplateCreateInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    descriptorUpdateEntryCount = copy_src.descriptorUpdateEntryCount;
    pDescriptorUpdateEntries = nullptr;
    templateType = copy_src.templateType;
    descriptorSetLayout = copy_src.descriptorSetLayout;
    pipelineBindPoint = copy_src.pipelineBindPoint;
    pipelineLayout = copy_src.pipelineLayout;
    set = copy_src.set;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDescriptorUpdateEntries) {
        pDescriptorUpdateEntries = new VkDescriptorUpdateTemplateEntry[copy_src.descriptorUpdateEntryCount];
        memcpy ((void *)pDescriptorUpdateEntries, (void *)copy_src.pDescriptorUpdateEntries, sizeof(VkDescriptorUpdateTemplateEntry)*copy_src.descriptorUpdateEntryCount);
    }
}

safe_VkDescriptorUpdateTemplateCreateInfo& safe_VkDescriptorUpdateTemplateCreateInfo::operator=(const safe_VkDescriptorUpdateTemplateCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pDescriptorUpdateEntries)
        delete[] pDescriptorUpdateEntries;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    descriptorUpdateEntryCount = copy_src.descriptorUpdateEntryCount;
    pDescriptorUpdateEntries = nullptr;
    templateType = copy_src.templateType;
    descriptorSetLayout = copy_src.descriptorSetLayout;
    pipelineBindPoint = copy_src.pipelineBindPoint;
    pipelineLayout = copy_src.pipelineLayout;
    set = copy_src.set;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDescriptorUpdateEntries) {
        pDescriptorUpdateEntries = new VkDescriptorUpdateTemplateEntry[copy_src.descriptorUpdateEntryCount];
        memcpy ((void *)pDescriptorUpdateEntries, (void *)copy_src.pDescriptorUpdateEntries, sizeof(VkDescriptorUpdateTemplateEntry)*copy_src.descriptorUpdateEntryCount);
    }

    return *this;
}

safe_VkDescriptorUpdateTemplateCreateInfo::~safe_VkDescriptorUpdateTemplateCreateInfo()
{
    if (pDescriptorUpdateEntries)
        delete[] pDescriptorUpdateEntries;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorUpdateTemplateCreateInfo::initialize(const VkDescriptorUpdateTemplateCreateInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    descriptorUpdateEntryCount = in_struct->descriptorUpdateEntryCount;
    pDescriptorUpdateEntries = nullptr;
    templateType = in_struct->templateType;
    descriptorSetLayout = in_struct->descriptorSetLayout;
    pipelineBindPoint = in_struct->pipelineBindPoint;
    pipelineLayout = in_struct->pipelineLayout;
    set = in_struct->set;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDescriptorUpdateEntries) {
        pDescriptorUpdateEntries = new VkDescriptorUpdateTemplateEntry[in_struct->descriptorUpdateEntryCount];
        memcpy ((void *)pDescriptorUpdateEntries, (void *)in_struct->pDescriptorUpdateEntries, sizeof(VkDescriptorUpdateTemplateEntry)*in_struct->descriptorUpdateEntryCount);
    }
}

void safe_VkDescriptorUpdateTemplateCreateInfo::initialize(const safe_VkDescriptorUpdateTemplateCreateInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    descriptorUpdateEntryCount = copy_src->descriptorUpdateEntryCount;
    pDescriptorUpdateEntries = nullptr;
    templateType = copy_src->templateType;
    descriptorSetLayout = copy_src->descriptorSetLayout;
    pipelineBindPoint = copy_src->pipelineBindPoint;
    pipelineLayout = copy_src->pipelineLayout;
    set = copy_src->set;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pDescriptorUpdateEntries) {
        pDescriptorUpdateEntries = new VkDescriptorUpdateTemplateEntry[copy_src->descriptorUpdateEntryCount];
        memcpy ((void *)pDescriptorUpdateEntries, (void *)copy_src->pDescriptorUpdateEntries, sizeof(VkDescriptorUpdateTemplateEntry)*copy_src->descriptorUpdateEntryCount);
    }
}

safe_VkPhysicalDeviceExternalImageFormatInfo::safe_VkPhysicalDeviceExternalImageFormatInfo(const VkPhysicalDeviceExternalImageFormatInfo* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceExternalImageFormatInfo::safe_VkPhysicalDeviceExternalImageFormatInfo() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceExternalImageFormatInfo::safe_VkPhysicalDeviceExternalImageFormatInfo(const safe_VkPhysicalDeviceExternalImageFormatInfo& copy_src)
{
    sType = copy_src.sType;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceExternalImageFormatInfo& safe_VkPhysicalDeviceExternalImageFormatInfo::operator=(const safe_VkPhysicalDeviceExternalImageFormatInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceExternalImageFormatInfo::~safe_VkPhysicalDeviceExternalImageFormatInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceExternalImageFormatInfo::initialize(const VkPhysicalDeviceExternalImageFormatInfo* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceExternalImageFormatInfo::initialize(const safe_VkPhysicalDeviceExternalImageFormatInfo* copy_src)
{
    sType = copy_src->sType;
    handleType = copy_src->handleType;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkExternalImageFormatProperties::safe_VkExternalImageFormatProperties(const VkExternalImageFormatProperties* in_struct) :
    sType(in_struct->sType),
    externalMemoryProperties(in_struct->externalMemoryProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalImageFormatProperties::safe_VkExternalImageFormatProperties() :
    sType(VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES),
    pNext(nullptr)
{}

safe_VkExternalImageFormatProperties::safe_VkExternalImageFormatProperties(const safe_VkExternalImageFormatProperties& copy_src)
{
    sType = copy_src.sType;
    externalMemoryProperties = copy_src.externalMemoryProperties;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkExternalImageFormatProperties& safe_VkExternalImageFormatProperties::operator=(const safe_VkExternalImageFormatProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    externalMemoryProperties = copy_src.externalMemoryProperties;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkExternalImageFormatProperties::~safe_VkExternalImageFormatProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalImageFormatProperties::initialize(const VkExternalImageFormatProperties* in_struct)
{
    sType = in_struct->sType;
    externalMemoryProperties = in_struct->externalMemoryProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalImageFormatProperties::initialize(const safe_VkExternalImageFormatProperties* copy_src)
{
    sType = copy_src->sType;
    externalMemoryProperties = copy_src->externalMemoryProperties;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceExternalBufferInfo::safe_VkPhysicalDeviceExternalBufferInfo(const VkPhysicalDeviceExternalBufferInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    usage(in_struct->usage),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceExternalBufferInfo::safe_VkPhysicalDeviceExternalBufferInfo() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceExternalBufferInfo::safe_VkPhysicalDeviceExternalBufferInfo(const safe_VkPhysicalDeviceExternalBufferInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    usage = copy_src.usage;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceExternalBufferInfo& safe_VkPhysicalDeviceExternalBufferInfo::operator=(const safe_VkPhysicalDeviceExternalBufferInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    usage = copy_src.usage;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceExternalBufferInfo::~safe_VkPhysicalDeviceExternalBufferInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceExternalBufferInfo::initialize(const VkPhysicalDeviceExternalBufferInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    usage = in_struct->usage;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceExternalBufferInfo::initialize(const safe_VkPhysicalDeviceExternalBufferInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    usage = copy_src->usage;
    handleType = copy_src->handleType;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkExternalBufferProperties::safe_VkExternalBufferProperties(const VkExternalBufferProperties* in_struct) :
    sType(in_struct->sType),
    externalMemoryProperties(in_struct->externalMemoryProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalBufferProperties::safe_VkExternalBufferProperties() :
    sType(VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES),
    pNext(nullptr)
{}

safe_VkExternalBufferProperties::safe_VkExternalBufferProperties(const safe_VkExternalBufferProperties& copy_src)
{
    sType = copy_src.sType;
    externalMemoryProperties = copy_src.externalMemoryProperties;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkExternalBufferProperties& safe_VkExternalBufferProperties::operator=(const safe_VkExternalBufferProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    externalMemoryProperties = copy_src.externalMemoryProperties;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkExternalBufferProperties::~safe_VkExternalBufferProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalBufferProperties::initialize(const VkExternalBufferProperties* in_struct)
{
    sType = in_struct->sType;
    externalMemoryProperties = in_struct->externalMemoryProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalBufferProperties::initialize(const safe_VkExternalBufferProperties* copy_src)
{
    sType = copy_src->sType;
    externalMemoryProperties = copy_src->externalMemoryProperties;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceIDProperties::safe_VkPhysicalDeviceIDProperties(const VkPhysicalDeviceIDProperties* in_struct) :
    sType(in_struct->sType),
    deviceNodeMask(in_struct->deviceNodeMask),
    deviceLUIDValid(in_struct->deviceLUIDValid)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = in_struct->deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = in_struct->driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = in_struct->deviceLUID[i];
    }
}

safe_VkPhysicalDeviceIDProperties::safe_VkPhysicalDeviceIDProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceIDProperties::safe_VkPhysicalDeviceIDProperties(const safe_VkPhysicalDeviceIDProperties& copy_src)
{
    sType = copy_src.sType;
    deviceNodeMask = copy_src.deviceNodeMask;
    deviceLUIDValid = copy_src.deviceLUIDValid;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = copy_src.deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = copy_src.driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = copy_src.deviceLUID[i];
    }
}

safe_VkPhysicalDeviceIDProperties& safe_VkPhysicalDeviceIDProperties::operator=(const safe_VkPhysicalDeviceIDProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    deviceNodeMask = copy_src.deviceNodeMask;
    deviceLUIDValid = copy_src.deviceLUIDValid;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = copy_src.deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = copy_src.driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = copy_src.deviceLUID[i];
    }

    return *this;
}

safe_VkPhysicalDeviceIDProperties::~safe_VkPhysicalDeviceIDProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceIDProperties::initialize(const VkPhysicalDeviceIDProperties* in_struct)
{
    sType = in_struct->sType;
    deviceNodeMask = in_struct->deviceNodeMask;
    deviceLUIDValid = in_struct->deviceLUIDValid;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = in_struct->deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = in_struct->driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = in_struct->deviceLUID[i];
    }
}

void safe_VkPhysicalDeviceIDProperties::initialize(const safe_VkPhysicalDeviceIDProperties* copy_src)
{
    sType = copy_src->sType;
    deviceNodeMask = copy_src->deviceNodeMask;
    deviceLUIDValid = copy_src->deviceLUIDValid;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = copy_src->deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = copy_src->driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = copy_src->deviceLUID[i];
    }
}

safe_VkExternalMemoryImageCreateInfo::safe_VkExternalMemoryImageCreateInfo(const VkExternalMemoryImageCreateInfo* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalMemoryImageCreateInfo::safe_VkExternalMemoryImageCreateInfo() :
    sType(VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkExternalMemoryImageCreateInfo::safe_VkExternalMemoryImageCreateInfo(const safe_VkExternalMemoryImageCreateInfo& copy_src)
{
    sType = copy_src.sType;
    handleTypes = copy_src.handleTypes;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkExternalMemoryImageCreateInfo& safe_VkExternalMemoryImageCreateInfo::operator=(const safe_VkExternalMemoryImageCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    handleTypes = copy_src.handleTypes;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkExternalMemoryImageCreateInfo::~safe_VkExternalMemoryImageCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalMemoryImageCreateInfo::initialize(const VkExternalMemoryImageCreateInfo* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalMemoryImageCreateInfo::initialize(const safe_VkExternalMemoryImageCreateInfo* copy_src)
{
    sType = copy_src->sType;
    handleTypes = copy_src->handleTypes;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkExternalMemoryBufferCreateInfo::safe_VkExternalMemoryBufferCreateInfo(const VkExternalMemoryBufferCreateInfo* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalMemoryBufferCreateInfo::safe_VkExternalMemoryBufferCreateInfo() :
    sType(VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkExternalMemoryBufferCreateInfo::safe_VkExternalMemoryBufferCreateInfo(const safe_VkExternalMemoryBufferCreateInfo& copy_src)
{
    sType = copy_src.sType;
    handleTypes = copy_src.handleTypes;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkExternalMemoryBufferCreateInfo& safe_VkExternalMemoryBufferCreateInfo::operator=(const safe_VkExternalMemoryBufferCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    handleTypes = copy_src.handleTypes;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkExternalMemoryBufferCreateInfo::~safe_VkExternalMemoryBufferCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalMemoryBufferCreateInfo::initialize(const VkExternalMemoryBufferCreateInfo* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalMemoryBufferCreateInfo::initialize(const safe_VkExternalMemoryBufferCreateInfo* copy_src)
{
    sType = copy_src->sType;
    handleTypes = copy_src->handleTypes;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkExportMemoryAllocateInfo::safe_VkExportMemoryAllocateInfo(const VkExportMemoryAllocateInfo* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExportMemoryAllocateInfo::safe_VkExportMemoryAllocateInfo() :
    sType(VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO),
    pNext(nullptr)
{}

safe_VkExportMemoryAllocateInfo::safe_VkExportMemoryAllocateInfo(const safe_VkExportMemoryAllocateInfo& copy_src)
{
    sType = copy_src.sType;
    handleTypes = copy_src.handleTypes;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkExportMemoryAllocateInfo& safe_VkExportMemoryAllocateInfo::operator=(const safe_VkExportMemoryAllocateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    handleTypes = copy_src.handleTypes;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkExportMemoryAllocateInfo::~safe_VkExportMemoryAllocateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportMemoryAllocateInfo::initialize(const VkExportMemoryAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExportMemoryAllocateInfo::initialize(const safe_VkExportMemoryAllocateInfo* copy_src)
{
    sType = copy_src->sType;
    handleTypes = copy_src->handleTypes;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceExternalFenceInfo::safe_VkPhysicalDeviceExternalFenceInfo(const VkPhysicalDeviceExternalFenceInfo* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceExternalFenceInfo::safe_VkPhysicalDeviceExternalFenceInfo() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceExternalFenceInfo::safe_VkPhysicalDeviceExternalFenceInfo(const safe_VkPhysicalDeviceExternalFenceInfo& copy_src)
{
    sType = copy_src.sType;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceExternalFenceInfo& safe_VkPhysicalDeviceExternalFenceInfo::operator=(const safe_VkPhysicalDeviceExternalFenceInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceExternalFenceInfo::~safe_VkPhysicalDeviceExternalFenceInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceExternalFenceInfo::initialize(const VkPhysicalDeviceExternalFenceInfo* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceExternalFenceInfo::initialize(const safe_VkPhysicalDeviceExternalFenceInfo* copy_src)
{
    sType = copy_src->sType;
    handleType = copy_src->handleType;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkExternalFenceProperties::safe_VkExternalFenceProperties(const VkExternalFenceProperties* in_struct) :
    sType(in_struct->sType),
    exportFromImportedHandleTypes(in_struct->exportFromImportedHandleTypes),
    compatibleHandleTypes(in_struct->compatibleHandleTypes),
    externalFenceFeatures(in_struct->externalFenceFeatures)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalFenceProperties::safe_VkExternalFenceProperties() :
    sType(VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES),
    pNext(nullptr)
{}

safe_VkExternalFenceProperties::safe_VkExternalFenceProperties(const safe_VkExternalFenceProperties& copy_src)
{
    sType = copy_src.sType;
    exportFromImportedHandleTypes = copy_src.exportFromImportedHandleTypes;
    compatibleHandleTypes = copy_src.compatibleHandleTypes;
    externalFenceFeatures = copy_src.externalFenceFeatures;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkExternalFenceProperties& safe_VkExternalFenceProperties::operator=(const safe_VkExternalFenceProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    exportFromImportedHandleTypes = copy_src.exportFromImportedHandleTypes;
    compatibleHandleTypes = copy_src.compatibleHandleTypes;
    externalFenceFeatures = copy_src.externalFenceFeatures;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkExternalFenceProperties::~safe_VkExternalFenceProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalFenceProperties::initialize(const VkExternalFenceProperties* in_struct)
{
    sType = in_struct->sType;
    exportFromImportedHandleTypes = in_struct->exportFromImportedHandleTypes;
    compatibleHandleTypes = in_struct->compatibleHandleTypes;
    externalFenceFeatures = in_struct->externalFenceFeatures;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalFenceProperties::initialize(const safe_VkExternalFenceProperties* copy_src)
{
    sType = copy_src->sType;
    exportFromImportedHandleTypes = copy_src->exportFromImportedHandleTypes;
    compatibleHandleTypes = copy_src->compatibleHandleTypes;
    externalFenceFeatures = copy_src->externalFenceFeatures;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkExportFenceCreateInfo::safe_VkExportFenceCreateInfo(const VkExportFenceCreateInfo* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExportFenceCreateInfo::safe_VkExportFenceCreateInfo() :
    sType(VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkExportFenceCreateInfo::safe_VkExportFenceCreateInfo(const safe_VkExportFenceCreateInfo& copy_src)
{
    sType = copy_src.sType;
    handleTypes = copy_src.handleTypes;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkExportFenceCreateInfo& safe_VkExportFenceCreateInfo::operator=(const safe_VkExportFenceCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    handleTypes = copy_src.handleTypes;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkExportFenceCreateInfo::~safe_VkExportFenceCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportFenceCreateInfo::initialize(const VkExportFenceCreateInfo* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExportFenceCreateInfo::initialize(const safe_VkExportFenceCreateInfo* copy_src)
{
    sType = copy_src->sType;
    handleTypes = copy_src->handleTypes;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkExportSemaphoreCreateInfo::safe_VkExportSemaphoreCreateInfo(const VkExportSemaphoreCreateInfo* in_struct) :
    sType(in_struct->sType),
    handleTypes(in_struct->handleTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExportSemaphoreCreateInfo::safe_VkExportSemaphoreCreateInfo() :
    sType(VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkExportSemaphoreCreateInfo::safe_VkExportSemaphoreCreateInfo(const safe_VkExportSemaphoreCreateInfo& copy_src)
{
    sType = copy_src.sType;
    handleTypes = copy_src.handleTypes;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkExportSemaphoreCreateInfo& safe_VkExportSemaphoreCreateInfo::operator=(const safe_VkExportSemaphoreCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    handleTypes = copy_src.handleTypes;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkExportSemaphoreCreateInfo::~safe_VkExportSemaphoreCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportSemaphoreCreateInfo::initialize(const VkExportSemaphoreCreateInfo* in_struct)
{
    sType = in_struct->sType;
    handleTypes = in_struct->handleTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExportSemaphoreCreateInfo::initialize(const safe_VkExportSemaphoreCreateInfo* copy_src)
{
    sType = copy_src->sType;
    handleTypes = copy_src->handleTypes;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceExternalSemaphoreInfo::safe_VkPhysicalDeviceExternalSemaphoreInfo(const VkPhysicalDeviceExternalSemaphoreInfo* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceExternalSemaphoreInfo::safe_VkPhysicalDeviceExternalSemaphoreInfo() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceExternalSemaphoreInfo::safe_VkPhysicalDeviceExternalSemaphoreInfo(const safe_VkPhysicalDeviceExternalSemaphoreInfo& copy_src)
{
    sType = copy_src.sType;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceExternalSemaphoreInfo& safe_VkPhysicalDeviceExternalSemaphoreInfo::operator=(const safe_VkPhysicalDeviceExternalSemaphoreInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceExternalSemaphoreInfo::~safe_VkPhysicalDeviceExternalSemaphoreInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceExternalSemaphoreInfo::initialize(const VkPhysicalDeviceExternalSemaphoreInfo* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceExternalSemaphoreInfo::initialize(const safe_VkPhysicalDeviceExternalSemaphoreInfo* copy_src)
{
    sType = copy_src->sType;
    handleType = copy_src->handleType;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkExternalSemaphoreProperties::safe_VkExternalSemaphoreProperties(const VkExternalSemaphoreProperties* in_struct) :
    sType(in_struct->sType),
    exportFromImportedHandleTypes(in_struct->exportFromImportedHandleTypes),
    compatibleHandleTypes(in_struct->compatibleHandleTypes),
    externalSemaphoreFeatures(in_struct->externalSemaphoreFeatures)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkExternalSemaphoreProperties::safe_VkExternalSemaphoreProperties() :
    sType(VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES),
    pNext(nullptr)
{}

safe_VkExternalSemaphoreProperties::safe_VkExternalSemaphoreProperties(const safe_VkExternalSemaphoreProperties& copy_src)
{
    sType = copy_src.sType;
    exportFromImportedHandleTypes = copy_src.exportFromImportedHandleTypes;
    compatibleHandleTypes = copy_src.compatibleHandleTypes;
    externalSemaphoreFeatures = copy_src.externalSemaphoreFeatures;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkExternalSemaphoreProperties& safe_VkExternalSemaphoreProperties::operator=(const safe_VkExternalSemaphoreProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    exportFromImportedHandleTypes = copy_src.exportFromImportedHandleTypes;
    compatibleHandleTypes = copy_src.compatibleHandleTypes;
    externalSemaphoreFeatures = copy_src.externalSemaphoreFeatures;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkExternalSemaphoreProperties::~safe_VkExternalSemaphoreProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExternalSemaphoreProperties::initialize(const VkExternalSemaphoreProperties* in_struct)
{
    sType = in_struct->sType;
    exportFromImportedHandleTypes = in_struct->exportFromImportedHandleTypes;
    compatibleHandleTypes = in_struct->compatibleHandleTypes;
    externalSemaphoreFeatures = in_struct->externalSemaphoreFeatures;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkExternalSemaphoreProperties::initialize(const safe_VkExternalSemaphoreProperties* copy_src)
{
    sType = copy_src->sType;
    exportFromImportedHandleTypes = copy_src->exportFromImportedHandleTypes;
    compatibleHandleTypes = copy_src->compatibleHandleTypes;
    externalSemaphoreFeatures = copy_src->externalSemaphoreFeatures;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceMaintenance3Properties::safe_VkPhysicalDeviceMaintenance3Properties(const VkPhysicalDeviceMaintenance3Properties* in_struct) :
    sType(in_struct->sType),
    maxPerSetDescriptors(in_struct->maxPerSetDescriptors),
    maxMemoryAllocationSize(in_struct->maxMemoryAllocationSize)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceMaintenance3Properties::safe_VkPhysicalDeviceMaintenance3Properties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceMaintenance3Properties::safe_VkPhysicalDeviceMaintenance3Properties(const safe_VkPhysicalDeviceMaintenance3Properties& copy_src)
{
    sType = copy_src.sType;
    maxPerSetDescriptors = copy_src.maxPerSetDescriptors;
    maxMemoryAllocationSize = copy_src.maxMemoryAllocationSize;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceMaintenance3Properties& safe_VkPhysicalDeviceMaintenance3Properties::operator=(const safe_VkPhysicalDeviceMaintenance3Properties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    maxPerSetDescriptors = copy_src.maxPerSetDescriptors;
    maxMemoryAllocationSize = copy_src.maxMemoryAllocationSize;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceMaintenance3Properties::~safe_VkPhysicalDeviceMaintenance3Properties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceMaintenance3Properties::initialize(const VkPhysicalDeviceMaintenance3Properties* in_struct)
{
    sType = in_struct->sType;
    maxPerSetDescriptors = in_struct->maxPerSetDescriptors;
    maxMemoryAllocationSize = in_struct->maxMemoryAllocationSize;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceMaintenance3Properties::initialize(const safe_VkPhysicalDeviceMaintenance3Properties* copy_src)
{
    sType = copy_src->sType;
    maxPerSetDescriptors = copy_src->maxPerSetDescriptors;
    maxMemoryAllocationSize = copy_src->maxMemoryAllocationSize;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDescriptorSetLayoutSupport::safe_VkDescriptorSetLayoutSupport(const VkDescriptorSetLayoutSupport* in_struct) :
    sType(in_struct->sType),
    supported(in_struct->supported)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDescriptorSetLayoutSupport::safe_VkDescriptorSetLayoutSupport() :
    sType(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT),
    pNext(nullptr)
{}

safe_VkDescriptorSetLayoutSupport::safe_VkDescriptorSetLayoutSupport(const safe_VkDescriptorSetLayoutSupport& copy_src)
{
    sType = copy_src.sType;
    supported = copy_src.supported;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDescriptorSetLayoutSupport& safe_VkDescriptorSetLayoutSupport::operator=(const safe_VkDescriptorSetLayoutSupport& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    supported = copy_src.supported;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDescriptorSetLayoutSupport::~safe_VkDescriptorSetLayoutSupport()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetLayoutSupport::initialize(const VkDescriptorSetLayoutSupport* in_struct)
{
    sType = in_struct->sType;
    supported = in_struct->supported;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDescriptorSetLayoutSupport::initialize(const safe_VkDescriptorSetLayoutSupport* copy_src)
{
    sType = copy_src->sType;
    supported = copy_src->supported;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceShaderDrawParametersFeatures::safe_VkPhysicalDeviceShaderDrawParametersFeatures(const VkPhysicalDeviceShaderDrawParametersFeatures* in_struct) :
    sType(in_struct->sType),
    shaderDrawParameters(in_struct->shaderDrawParameters)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderDrawParametersFeatures::safe_VkPhysicalDeviceShaderDrawParametersFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderDrawParametersFeatures::safe_VkPhysicalDeviceShaderDrawParametersFeatures(const safe_VkPhysicalDeviceShaderDrawParametersFeatures& copy_src)
{
    sType = copy_src.sType;
    shaderDrawParameters = copy_src.shaderDrawParameters;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceShaderDrawParametersFeatures& safe_VkPhysicalDeviceShaderDrawParametersFeatures::operator=(const safe_VkPhysicalDeviceShaderDrawParametersFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    shaderDrawParameters = copy_src.shaderDrawParameters;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderDrawParametersFeatures::~safe_VkPhysicalDeviceShaderDrawParametersFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderDrawParametersFeatures::initialize(const VkPhysicalDeviceShaderDrawParametersFeatures* in_struct)
{
    sType = in_struct->sType;
    shaderDrawParameters = in_struct->shaderDrawParameters;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderDrawParametersFeatures::initialize(const safe_VkPhysicalDeviceShaderDrawParametersFeatures* copy_src)
{
    sType = copy_src->sType;
    shaderDrawParameters = copy_src->shaderDrawParameters;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceVulkan11Features::safe_VkPhysicalDeviceVulkan11Features(const VkPhysicalDeviceVulkan11Features* in_struct) :
    sType(in_struct->sType),
    storageBuffer16BitAccess(in_struct->storageBuffer16BitAccess),
    uniformAndStorageBuffer16BitAccess(in_struct->uniformAndStorageBuffer16BitAccess),
    storagePushConstant16(in_struct->storagePushConstant16),
    storageInputOutput16(in_struct->storageInputOutput16),
    multiview(in_struct->multiview),
    multiviewGeometryShader(in_struct->multiviewGeometryShader),
    multiviewTessellationShader(in_struct->multiviewTessellationShader),
    variablePointersStorageBuffer(in_struct->variablePointersStorageBuffer),
    variablePointers(in_struct->variablePointers),
    protectedMemory(in_struct->protectedMemory),
    samplerYcbcrConversion(in_struct->samplerYcbcrConversion),
    shaderDrawParameters(in_struct->shaderDrawParameters)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceVulkan11Features::safe_VkPhysicalDeviceVulkan11Features() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceVulkan11Features::safe_VkPhysicalDeviceVulkan11Features(const safe_VkPhysicalDeviceVulkan11Features& copy_src)
{
    sType = copy_src.sType;
    storageBuffer16BitAccess = copy_src.storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = copy_src.uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = copy_src.storagePushConstant16;
    storageInputOutput16 = copy_src.storageInputOutput16;
    multiview = copy_src.multiview;
    multiviewGeometryShader = copy_src.multiviewGeometryShader;
    multiviewTessellationShader = copy_src.multiviewTessellationShader;
    variablePointersStorageBuffer = copy_src.variablePointersStorageBuffer;
    variablePointers = copy_src.variablePointers;
    protectedMemory = copy_src.protectedMemory;
    samplerYcbcrConversion = copy_src.samplerYcbcrConversion;
    shaderDrawParameters = copy_src.shaderDrawParameters;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceVulkan11Features& safe_VkPhysicalDeviceVulkan11Features::operator=(const safe_VkPhysicalDeviceVulkan11Features& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    storageBuffer16BitAccess = copy_src.storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = copy_src.uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = copy_src.storagePushConstant16;
    storageInputOutput16 = copy_src.storageInputOutput16;
    multiview = copy_src.multiview;
    multiviewGeometryShader = copy_src.multiviewGeometryShader;
    multiviewTessellationShader = copy_src.multiviewTessellationShader;
    variablePointersStorageBuffer = copy_src.variablePointersStorageBuffer;
    variablePointers = copy_src.variablePointers;
    protectedMemory = copy_src.protectedMemory;
    samplerYcbcrConversion = copy_src.samplerYcbcrConversion;
    shaderDrawParameters = copy_src.shaderDrawParameters;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceVulkan11Features::~safe_VkPhysicalDeviceVulkan11Features()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceVulkan11Features::initialize(const VkPhysicalDeviceVulkan11Features* in_struct)
{
    sType = in_struct->sType;
    storageBuffer16BitAccess = in_struct->storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = in_struct->uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = in_struct->storagePushConstant16;
    storageInputOutput16 = in_struct->storageInputOutput16;
    multiview = in_struct->multiview;
    multiviewGeometryShader = in_struct->multiviewGeometryShader;
    multiviewTessellationShader = in_struct->multiviewTessellationShader;
    variablePointersStorageBuffer = in_struct->variablePointersStorageBuffer;
    variablePointers = in_struct->variablePointers;
    protectedMemory = in_struct->protectedMemory;
    samplerYcbcrConversion = in_struct->samplerYcbcrConversion;
    shaderDrawParameters = in_struct->shaderDrawParameters;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceVulkan11Features::initialize(const safe_VkPhysicalDeviceVulkan11Features* copy_src)
{
    sType = copy_src->sType;
    storageBuffer16BitAccess = copy_src->storageBuffer16BitAccess;
    uniformAndStorageBuffer16BitAccess = copy_src->uniformAndStorageBuffer16BitAccess;
    storagePushConstant16 = copy_src->storagePushConstant16;
    storageInputOutput16 = copy_src->storageInputOutput16;
    multiview = copy_src->multiview;
    multiviewGeometryShader = copy_src->multiviewGeometryShader;
    multiviewTessellationShader = copy_src->multiviewTessellationShader;
    variablePointersStorageBuffer = copy_src->variablePointersStorageBuffer;
    variablePointers = copy_src->variablePointers;
    protectedMemory = copy_src->protectedMemory;
    samplerYcbcrConversion = copy_src->samplerYcbcrConversion;
    shaderDrawParameters = copy_src->shaderDrawParameters;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceVulkan11Properties::safe_VkPhysicalDeviceVulkan11Properties(const VkPhysicalDeviceVulkan11Properties* in_struct) :
    sType(in_struct->sType),
    deviceNodeMask(in_struct->deviceNodeMask),
    deviceLUIDValid(in_struct->deviceLUIDValid),
    subgroupSize(in_struct->subgroupSize),
    subgroupSupportedStages(in_struct->subgroupSupportedStages),
    subgroupSupportedOperations(in_struct->subgroupSupportedOperations),
    subgroupQuadOperationsInAllStages(in_struct->subgroupQuadOperationsInAllStages),
    pointClippingBehavior(in_struct->pointClippingBehavior),
    maxMultiviewViewCount(in_struct->maxMultiviewViewCount),
    maxMultiviewInstanceIndex(in_struct->maxMultiviewInstanceIndex),
    protectedNoFault(in_struct->protectedNoFault),
    maxPerSetDescriptors(in_struct->maxPerSetDescriptors),
    maxMemoryAllocationSize(in_struct->maxMemoryAllocationSize)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = in_struct->deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = in_struct->driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = in_struct->deviceLUID[i];
    }
}

safe_VkPhysicalDeviceVulkan11Properties::safe_VkPhysicalDeviceVulkan11Properties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceVulkan11Properties::safe_VkPhysicalDeviceVulkan11Properties(const safe_VkPhysicalDeviceVulkan11Properties& copy_src)
{
    sType = copy_src.sType;
    deviceNodeMask = copy_src.deviceNodeMask;
    deviceLUIDValid = copy_src.deviceLUIDValid;
    subgroupSize = copy_src.subgroupSize;
    subgroupSupportedStages = copy_src.subgroupSupportedStages;
    subgroupSupportedOperations = copy_src.subgroupSupportedOperations;
    subgroupQuadOperationsInAllStages = copy_src.subgroupQuadOperationsInAllStages;
    pointClippingBehavior = copy_src.pointClippingBehavior;
    maxMultiviewViewCount = copy_src.maxMultiviewViewCount;
    maxMultiviewInstanceIndex = copy_src.maxMultiviewInstanceIndex;
    protectedNoFault = copy_src.protectedNoFault;
    maxPerSetDescriptors = copy_src.maxPerSetDescriptors;
    maxMemoryAllocationSize = copy_src.maxMemoryAllocationSize;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = copy_src.deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = copy_src.driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = copy_src.deviceLUID[i];
    }
}

safe_VkPhysicalDeviceVulkan11Properties& safe_VkPhysicalDeviceVulkan11Properties::operator=(const safe_VkPhysicalDeviceVulkan11Properties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    deviceNodeMask = copy_src.deviceNodeMask;
    deviceLUIDValid = copy_src.deviceLUIDValid;
    subgroupSize = copy_src.subgroupSize;
    subgroupSupportedStages = copy_src.subgroupSupportedStages;
    subgroupSupportedOperations = copy_src.subgroupSupportedOperations;
    subgroupQuadOperationsInAllStages = copy_src.subgroupQuadOperationsInAllStages;
    pointClippingBehavior = copy_src.pointClippingBehavior;
    maxMultiviewViewCount = copy_src.maxMultiviewViewCount;
    maxMultiviewInstanceIndex = copy_src.maxMultiviewInstanceIndex;
    protectedNoFault = copy_src.protectedNoFault;
    maxPerSetDescriptors = copy_src.maxPerSetDescriptors;
    maxMemoryAllocationSize = copy_src.maxMemoryAllocationSize;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = copy_src.deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = copy_src.driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = copy_src.deviceLUID[i];
    }

    return *this;
}

safe_VkPhysicalDeviceVulkan11Properties::~safe_VkPhysicalDeviceVulkan11Properties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceVulkan11Properties::initialize(const VkPhysicalDeviceVulkan11Properties* in_struct)
{
    sType = in_struct->sType;
    deviceNodeMask = in_struct->deviceNodeMask;
    deviceLUIDValid = in_struct->deviceLUIDValid;
    subgroupSize = in_struct->subgroupSize;
    subgroupSupportedStages = in_struct->subgroupSupportedStages;
    subgroupSupportedOperations = in_struct->subgroupSupportedOperations;
    subgroupQuadOperationsInAllStages = in_struct->subgroupQuadOperationsInAllStages;
    pointClippingBehavior = in_struct->pointClippingBehavior;
    maxMultiviewViewCount = in_struct->maxMultiviewViewCount;
    maxMultiviewInstanceIndex = in_struct->maxMultiviewInstanceIndex;
    protectedNoFault = in_struct->protectedNoFault;
    maxPerSetDescriptors = in_struct->maxPerSetDescriptors;
    maxMemoryAllocationSize = in_struct->maxMemoryAllocationSize;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = in_struct->deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = in_struct->driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = in_struct->deviceLUID[i];
    }
}

void safe_VkPhysicalDeviceVulkan11Properties::initialize(const safe_VkPhysicalDeviceVulkan11Properties* copy_src)
{
    sType = copy_src->sType;
    deviceNodeMask = copy_src->deviceNodeMask;
    deviceLUIDValid = copy_src->deviceLUIDValid;
    subgroupSize = copy_src->subgroupSize;
    subgroupSupportedStages = copy_src->subgroupSupportedStages;
    subgroupSupportedOperations = copy_src->subgroupSupportedOperations;
    subgroupQuadOperationsInAllStages = copy_src->subgroupQuadOperationsInAllStages;
    pointClippingBehavior = copy_src->pointClippingBehavior;
    maxMultiviewViewCount = copy_src->maxMultiviewViewCount;
    maxMultiviewInstanceIndex = copy_src->maxMultiviewInstanceIndex;
    protectedNoFault = copy_src->protectedNoFault;
    maxPerSetDescriptors = copy_src->maxPerSetDescriptors;
    maxMemoryAllocationSize = copy_src->maxMemoryAllocationSize;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        deviceUUID[i] = copy_src->deviceUUID[i];
    }
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        driverUUID[i] = copy_src->driverUUID[i];
    }
    for (uint32_t i = 0; i < VK_LUID_SIZE; ++i) {
        deviceLUID[i] = copy_src->deviceLUID[i];
    }
}

safe_VkPhysicalDeviceVulkan12Features::safe_VkPhysicalDeviceVulkan12Features(const VkPhysicalDeviceVulkan12Features* in_struct) :
    sType(in_struct->sType),
    samplerMirrorClampToEdge(in_struct->samplerMirrorClampToEdge),
    drawIndirectCount(in_struct->drawIndirectCount),
    storageBuffer8BitAccess(in_struct->storageBuffer8BitAccess),
    uniformAndStorageBuffer8BitAccess(in_struct->uniformAndStorageBuffer8BitAccess),
    storagePushConstant8(in_struct->storagePushConstant8),
    shaderBufferInt64Atomics(in_struct->shaderBufferInt64Atomics),
    shaderSharedInt64Atomics(in_struct->shaderSharedInt64Atomics),
    shaderFloat16(in_struct->shaderFloat16),
    shaderInt8(in_struct->shaderInt8),
    descriptorIndexing(in_struct->descriptorIndexing),
    shaderInputAttachmentArrayDynamicIndexing(in_struct->shaderInputAttachmentArrayDynamicIndexing),
    shaderUniformTexelBufferArrayDynamicIndexing(in_struct->shaderUniformTexelBufferArrayDynamicIndexing),
    shaderStorageTexelBufferArrayDynamicIndexing(in_struct->shaderStorageTexelBufferArrayDynamicIndexing),
    shaderUniformBufferArrayNonUniformIndexing(in_struct->shaderUniformBufferArrayNonUniformIndexing),
    shaderSampledImageArrayNonUniformIndexing(in_struct->shaderSampledImageArrayNonUniformIndexing),
    shaderStorageBufferArrayNonUniformIndexing(in_struct->shaderStorageBufferArrayNonUniformIndexing),
    shaderStorageImageArrayNonUniformIndexing(in_struct->shaderStorageImageArrayNonUniformIndexing),
    shaderInputAttachmentArrayNonUniformIndexing(in_struct->shaderInputAttachmentArrayNonUniformIndexing),
    shaderUniformTexelBufferArrayNonUniformIndexing(in_struct->shaderUniformTexelBufferArrayNonUniformIndexing),
    shaderStorageTexelBufferArrayNonUniformIndexing(in_struct->shaderStorageTexelBufferArrayNonUniformIndexing),
    descriptorBindingUniformBufferUpdateAfterBind(in_struct->descriptorBindingUniformBufferUpdateAfterBind),
    descriptorBindingSampledImageUpdateAfterBind(in_struct->descriptorBindingSampledImageUpdateAfterBind),
    descriptorBindingStorageImageUpdateAfterBind(in_struct->descriptorBindingStorageImageUpdateAfterBind),
    descriptorBindingStorageBufferUpdateAfterBind(in_struct->descriptorBindingStorageBufferUpdateAfterBind),
    descriptorBindingUniformTexelBufferUpdateAfterBind(in_struct->descriptorBindingUniformTexelBufferUpdateAfterBind),
    descriptorBindingStorageTexelBufferUpdateAfterBind(in_struct->descriptorBindingStorageTexelBufferUpdateAfterBind),
    descriptorBindingUpdateUnusedWhilePending(in_struct->descriptorBindingUpdateUnusedWhilePending),
    descriptorBindingPartiallyBound(in_struct->descriptorBindingPartiallyBound),
    descriptorBindingVariableDescriptorCount(in_struct->descriptorBindingVariableDescriptorCount),
    runtimeDescriptorArray(in_struct->runtimeDescriptorArray),
    samplerFilterMinmax(in_struct->samplerFilterMinmax),
    scalarBlockLayout(in_struct->scalarBlockLayout),
    imagelessFramebuffer(in_struct->imagelessFramebuffer),
    uniformBufferStandardLayout(in_struct->uniformBufferStandardLayout),
    shaderSubgroupExtendedTypes(in_struct->shaderSubgroupExtendedTypes),
    separateDepthStencilLayouts(in_struct->separateDepthStencilLayouts),
    hostQueryReset(in_struct->hostQueryReset),
    timelineSemaphore(in_struct->timelineSemaphore),
    bufferDeviceAddress(in_struct->bufferDeviceAddress),
    bufferDeviceAddressCaptureReplay(in_struct->bufferDeviceAddressCaptureReplay),
    bufferDeviceAddressMultiDevice(in_struct->bufferDeviceAddressMultiDevice),
    vulkanMemoryModel(in_struct->vulkanMemoryModel),
    vulkanMemoryModelDeviceScope(in_struct->vulkanMemoryModelDeviceScope),
    vulkanMemoryModelAvailabilityVisibilityChains(in_struct->vulkanMemoryModelAvailabilityVisibilityChains),
    shaderOutputViewportIndex(in_struct->shaderOutputViewportIndex),
    shaderOutputLayer(in_struct->shaderOutputLayer),
    subgroupBroadcastDynamicId(in_struct->subgroupBroadcastDynamicId)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceVulkan12Features::safe_VkPhysicalDeviceVulkan12Features() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceVulkan12Features::safe_VkPhysicalDeviceVulkan12Features(const safe_VkPhysicalDeviceVulkan12Features& copy_src)
{
    sType = copy_src.sType;
    samplerMirrorClampToEdge = copy_src.samplerMirrorClampToEdge;
    drawIndirectCount = copy_src.drawIndirectCount;
    storageBuffer8BitAccess = copy_src.storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = copy_src.uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = copy_src.storagePushConstant8;
    shaderBufferInt64Atomics = copy_src.shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = copy_src.shaderSharedInt64Atomics;
    shaderFloat16 = copy_src.shaderFloat16;
    shaderInt8 = copy_src.shaderInt8;
    descriptorIndexing = copy_src.descriptorIndexing;
    shaderInputAttachmentArrayDynamicIndexing = copy_src.shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = copy_src.shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = copy_src.shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = copy_src.shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = copy_src.shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = copy_src.shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = copy_src.shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = copy_src.shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = copy_src.shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = copy_src.shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = copy_src.descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = copy_src.descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = copy_src.descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = copy_src.descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = copy_src.descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = copy_src.descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = copy_src.descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = copy_src.descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = copy_src.descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = copy_src.runtimeDescriptorArray;
    samplerFilterMinmax = copy_src.samplerFilterMinmax;
    scalarBlockLayout = copy_src.scalarBlockLayout;
    imagelessFramebuffer = copy_src.imagelessFramebuffer;
    uniformBufferStandardLayout = copy_src.uniformBufferStandardLayout;
    shaderSubgroupExtendedTypes = copy_src.shaderSubgroupExtendedTypes;
    separateDepthStencilLayouts = copy_src.separateDepthStencilLayouts;
    hostQueryReset = copy_src.hostQueryReset;
    timelineSemaphore = copy_src.timelineSemaphore;
    bufferDeviceAddress = copy_src.bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = copy_src.bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = copy_src.bufferDeviceAddressMultiDevice;
    vulkanMemoryModel = copy_src.vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = copy_src.vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = copy_src.vulkanMemoryModelAvailabilityVisibilityChains;
    shaderOutputViewportIndex = copy_src.shaderOutputViewportIndex;
    shaderOutputLayer = copy_src.shaderOutputLayer;
    subgroupBroadcastDynamicId = copy_src.subgroupBroadcastDynamicId;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceVulkan12Features& safe_VkPhysicalDeviceVulkan12Features::operator=(const safe_VkPhysicalDeviceVulkan12Features& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    samplerMirrorClampToEdge = copy_src.samplerMirrorClampToEdge;
    drawIndirectCount = copy_src.drawIndirectCount;
    storageBuffer8BitAccess = copy_src.storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = copy_src.uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = copy_src.storagePushConstant8;
    shaderBufferInt64Atomics = copy_src.shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = copy_src.shaderSharedInt64Atomics;
    shaderFloat16 = copy_src.shaderFloat16;
    shaderInt8 = copy_src.shaderInt8;
    descriptorIndexing = copy_src.descriptorIndexing;
    shaderInputAttachmentArrayDynamicIndexing = copy_src.shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = copy_src.shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = copy_src.shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = copy_src.shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = copy_src.shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = copy_src.shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = copy_src.shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = copy_src.shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = copy_src.shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = copy_src.shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = copy_src.descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = copy_src.descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = copy_src.descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = copy_src.descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = copy_src.descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = copy_src.descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = copy_src.descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = copy_src.descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = copy_src.descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = copy_src.runtimeDescriptorArray;
    samplerFilterMinmax = copy_src.samplerFilterMinmax;
    scalarBlockLayout = copy_src.scalarBlockLayout;
    imagelessFramebuffer = copy_src.imagelessFramebuffer;
    uniformBufferStandardLayout = copy_src.uniformBufferStandardLayout;
    shaderSubgroupExtendedTypes = copy_src.shaderSubgroupExtendedTypes;
    separateDepthStencilLayouts = copy_src.separateDepthStencilLayouts;
    hostQueryReset = copy_src.hostQueryReset;
    timelineSemaphore = copy_src.timelineSemaphore;
    bufferDeviceAddress = copy_src.bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = copy_src.bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = copy_src.bufferDeviceAddressMultiDevice;
    vulkanMemoryModel = copy_src.vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = copy_src.vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = copy_src.vulkanMemoryModelAvailabilityVisibilityChains;
    shaderOutputViewportIndex = copy_src.shaderOutputViewportIndex;
    shaderOutputLayer = copy_src.shaderOutputLayer;
    subgroupBroadcastDynamicId = copy_src.subgroupBroadcastDynamicId;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceVulkan12Features::~safe_VkPhysicalDeviceVulkan12Features()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceVulkan12Features::initialize(const VkPhysicalDeviceVulkan12Features* in_struct)
{
    sType = in_struct->sType;
    samplerMirrorClampToEdge = in_struct->samplerMirrorClampToEdge;
    drawIndirectCount = in_struct->drawIndirectCount;
    storageBuffer8BitAccess = in_struct->storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = in_struct->uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = in_struct->storagePushConstant8;
    shaderBufferInt64Atomics = in_struct->shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = in_struct->shaderSharedInt64Atomics;
    shaderFloat16 = in_struct->shaderFloat16;
    shaderInt8 = in_struct->shaderInt8;
    descriptorIndexing = in_struct->descriptorIndexing;
    shaderInputAttachmentArrayDynamicIndexing = in_struct->shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = in_struct->shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = in_struct->shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = in_struct->shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = in_struct->shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = in_struct->shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = in_struct->shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = in_struct->shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = in_struct->shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = in_struct->shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = in_struct->descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = in_struct->descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = in_struct->descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = in_struct->descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = in_struct->descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = in_struct->descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = in_struct->descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = in_struct->descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = in_struct->descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = in_struct->runtimeDescriptorArray;
    samplerFilterMinmax = in_struct->samplerFilterMinmax;
    scalarBlockLayout = in_struct->scalarBlockLayout;
    imagelessFramebuffer = in_struct->imagelessFramebuffer;
    uniformBufferStandardLayout = in_struct->uniformBufferStandardLayout;
    shaderSubgroupExtendedTypes = in_struct->shaderSubgroupExtendedTypes;
    separateDepthStencilLayouts = in_struct->separateDepthStencilLayouts;
    hostQueryReset = in_struct->hostQueryReset;
    timelineSemaphore = in_struct->timelineSemaphore;
    bufferDeviceAddress = in_struct->bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = in_struct->bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = in_struct->bufferDeviceAddressMultiDevice;
    vulkanMemoryModel = in_struct->vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = in_struct->vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = in_struct->vulkanMemoryModelAvailabilityVisibilityChains;
    shaderOutputViewportIndex = in_struct->shaderOutputViewportIndex;
    shaderOutputLayer = in_struct->shaderOutputLayer;
    subgroupBroadcastDynamicId = in_struct->subgroupBroadcastDynamicId;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceVulkan12Features::initialize(const safe_VkPhysicalDeviceVulkan12Features* copy_src)
{
    sType = copy_src->sType;
    samplerMirrorClampToEdge = copy_src->samplerMirrorClampToEdge;
    drawIndirectCount = copy_src->drawIndirectCount;
    storageBuffer8BitAccess = copy_src->storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = copy_src->uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = copy_src->storagePushConstant8;
    shaderBufferInt64Atomics = copy_src->shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = copy_src->shaderSharedInt64Atomics;
    shaderFloat16 = copy_src->shaderFloat16;
    shaderInt8 = copy_src->shaderInt8;
    descriptorIndexing = copy_src->descriptorIndexing;
    shaderInputAttachmentArrayDynamicIndexing = copy_src->shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = copy_src->shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = copy_src->shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = copy_src->shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = copy_src->shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = copy_src->shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = copy_src->shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = copy_src->shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = copy_src->shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = copy_src->shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = copy_src->descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = copy_src->descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = copy_src->descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = copy_src->descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = copy_src->descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = copy_src->descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = copy_src->descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = copy_src->descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = copy_src->descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = copy_src->runtimeDescriptorArray;
    samplerFilterMinmax = copy_src->samplerFilterMinmax;
    scalarBlockLayout = copy_src->scalarBlockLayout;
    imagelessFramebuffer = copy_src->imagelessFramebuffer;
    uniformBufferStandardLayout = copy_src->uniformBufferStandardLayout;
    shaderSubgroupExtendedTypes = copy_src->shaderSubgroupExtendedTypes;
    separateDepthStencilLayouts = copy_src->separateDepthStencilLayouts;
    hostQueryReset = copy_src->hostQueryReset;
    timelineSemaphore = copy_src->timelineSemaphore;
    bufferDeviceAddress = copy_src->bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = copy_src->bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = copy_src->bufferDeviceAddressMultiDevice;
    vulkanMemoryModel = copy_src->vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = copy_src->vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = copy_src->vulkanMemoryModelAvailabilityVisibilityChains;
    shaderOutputViewportIndex = copy_src->shaderOutputViewportIndex;
    shaderOutputLayer = copy_src->shaderOutputLayer;
    subgroupBroadcastDynamicId = copy_src->subgroupBroadcastDynamicId;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceVulkan12Properties::safe_VkPhysicalDeviceVulkan12Properties(const VkPhysicalDeviceVulkan12Properties* in_struct) :
    sType(in_struct->sType),
    driverID(in_struct->driverID),
    conformanceVersion(in_struct->conformanceVersion),
    denormBehaviorIndependence(in_struct->denormBehaviorIndependence),
    roundingModeIndependence(in_struct->roundingModeIndependence),
    shaderSignedZeroInfNanPreserveFloat16(in_struct->shaderSignedZeroInfNanPreserveFloat16),
    shaderSignedZeroInfNanPreserveFloat32(in_struct->shaderSignedZeroInfNanPreserveFloat32),
    shaderSignedZeroInfNanPreserveFloat64(in_struct->shaderSignedZeroInfNanPreserveFloat64),
    shaderDenormPreserveFloat16(in_struct->shaderDenormPreserveFloat16),
    shaderDenormPreserveFloat32(in_struct->shaderDenormPreserveFloat32),
    shaderDenormPreserveFloat64(in_struct->shaderDenormPreserveFloat64),
    shaderDenormFlushToZeroFloat16(in_struct->shaderDenormFlushToZeroFloat16),
    shaderDenormFlushToZeroFloat32(in_struct->shaderDenormFlushToZeroFloat32),
    shaderDenormFlushToZeroFloat64(in_struct->shaderDenormFlushToZeroFloat64),
    shaderRoundingModeRTEFloat16(in_struct->shaderRoundingModeRTEFloat16),
    shaderRoundingModeRTEFloat32(in_struct->shaderRoundingModeRTEFloat32),
    shaderRoundingModeRTEFloat64(in_struct->shaderRoundingModeRTEFloat64),
    shaderRoundingModeRTZFloat16(in_struct->shaderRoundingModeRTZFloat16),
    shaderRoundingModeRTZFloat32(in_struct->shaderRoundingModeRTZFloat32),
    shaderRoundingModeRTZFloat64(in_struct->shaderRoundingModeRTZFloat64),
    maxUpdateAfterBindDescriptorsInAllPools(in_struct->maxUpdateAfterBindDescriptorsInAllPools),
    shaderUniformBufferArrayNonUniformIndexingNative(in_struct->shaderUniformBufferArrayNonUniformIndexingNative),
    shaderSampledImageArrayNonUniformIndexingNative(in_struct->shaderSampledImageArrayNonUniformIndexingNative),
    shaderStorageBufferArrayNonUniformIndexingNative(in_struct->shaderStorageBufferArrayNonUniformIndexingNative),
    shaderStorageImageArrayNonUniformIndexingNative(in_struct->shaderStorageImageArrayNonUniformIndexingNative),
    shaderInputAttachmentArrayNonUniformIndexingNative(in_struct->shaderInputAttachmentArrayNonUniformIndexingNative),
    robustBufferAccessUpdateAfterBind(in_struct->robustBufferAccessUpdateAfterBind),
    quadDivergentImplicitLod(in_struct->quadDivergentImplicitLod),
    maxPerStageDescriptorUpdateAfterBindSamplers(in_struct->maxPerStageDescriptorUpdateAfterBindSamplers),
    maxPerStageDescriptorUpdateAfterBindUniformBuffers(in_struct->maxPerStageDescriptorUpdateAfterBindUniformBuffers),
    maxPerStageDescriptorUpdateAfterBindStorageBuffers(in_struct->maxPerStageDescriptorUpdateAfterBindStorageBuffers),
    maxPerStageDescriptorUpdateAfterBindSampledImages(in_struct->maxPerStageDescriptorUpdateAfterBindSampledImages),
    maxPerStageDescriptorUpdateAfterBindStorageImages(in_struct->maxPerStageDescriptorUpdateAfterBindStorageImages),
    maxPerStageDescriptorUpdateAfterBindInputAttachments(in_struct->maxPerStageDescriptorUpdateAfterBindInputAttachments),
    maxPerStageUpdateAfterBindResources(in_struct->maxPerStageUpdateAfterBindResources),
    maxDescriptorSetUpdateAfterBindSamplers(in_struct->maxDescriptorSetUpdateAfterBindSamplers),
    maxDescriptorSetUpdateAfterBindUniformBuffers(in_struct->maxDescriptorSetUpdateAfterBindUniformBuffers),
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic(in_struct->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic),
    maxDescriptorSetUpdateAfterBindStorageBuffers(in_struct->maxDescriptorSetUpdateAfterBindStorageBuffers),
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic(in_struct->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic),
    maxDescriptorSetUpdateAfterBindSampledImages(in_struct->maxDescriptorSetUpdateAfterBindSampledImages),
    maxDescriptorSetUpdateAfterBindStorageImages(in_struct->maxDescriptorSetUpdateAfterBindStorageImages),
    maxDescriptorSetUpdateAfterBindInputAttachments(in_struct->maxDescriptorSetUpdateAfterBindInputAttachments),
    supportedDepthResolveModes(in_struct->supportedDepthResolveModes),
    supportedStencilResolveModes(in_struct->supportedStencilResolveModes),
    independentResolveNone(in_struct->independentResolveNone),
    independentResolve(in_struct->independentResolve),
    filterMinmaxSingleComponentFormats(in_struct->filterMinmaxSingleComponentFormats),
    filterMinmaxImageComponentMapping(in_struct->filterMinmaxImageComponentMapping),
    maxTimelineSemaphoreValueDifference(in_struct->maxTimelineSemaphoreValueDifference),
    framebufferIntegerColorSampleCounts(in_struct->framebufferIntegerColorSampleCounts)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE; ++i) {
        driverName[i] = in_struct->driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE; ++i) {
        driverInfo[i] = in_struct->driverInfo[i];
    }
}

safe_VkPhysicalDeviceVulkan12Properties::safe_VkPhysicalDeviceVulkan12Properties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceVulkan12Properties::safe_VkPhysicalDeviceVulkan12Properties(const safe_VkPhysicalDeviceVulkan12Properties& copy_src)
{
    sType = copy_src.sType;
    driverID = copy_src.driverID;
    conformanceVersion = copy_src.conformanceVersion;
    denormBehaviorIndependence = copy_src.denormBehaviorIndependence;
    roundingModeIndependence = copy_src.roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = copy_src.shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = copy_src.shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = copy_src.shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = copy_src.shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = copy_src.shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = copy_src.shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = copy_src.shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = copy_src.shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = copy_src.shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = copy_src.shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = copy_src.shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = copy_src.shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = copy_src.shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = copy_src.shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = copy_src.shaderRoundingModeRTZFloat64;
    maxUpdateAfterBindDescriptorsInAllPools = copy_src.maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = copy_src.shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = copy_src.shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = copy_src.shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = copy_src.shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = copy_src.shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = copy_src.robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = copy_src.quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = copy_src.maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = copy_src.maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = copy_src.maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = copy_src.maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = copy_src.maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = copy_src.maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = copy_src.maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = copy_src.maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = copy_src.maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = copy_src.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = copy_src.maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = copy_src.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = copy_src.maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = copy_src.maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = copy_src.maxDescriptorSetUpdateAfterBindInputAttachments;
    supportedDepthResolveModes = copy_src.supportedDepthResolveModes;
    supportedStencilResolveModes = copy_src.supportedStencilResolveModes;
    independentResolveNone = copy_src.independentResolveNone;
    independentResolve = copy_src.independentResolve;
    filterMinmaxSingleComponentFormats = copy_src.filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = copy_src.filterMinmaxImageComponentMapping;
    maxTimelineSemaphoreValueDifference = copy_src.maxTimelineSemaphoreValueDifference;
    framebufferIntegerColorSampleCounts = copy_src.framebufferIntegerColorSampleCounts;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE; ++i) {
        driverName[i] = copy_src.driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE; ++i) {
        driverInfo[i] = copy_src.driverInfo[i];
    }
}

safe_VkPhysicalDeviceVulkan12Properties& safe_VkPhysicalDeviceVulkan12Properties::operator=(const safe_VkPhysicalDeviceVulkan12Properties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    driverID = copy_src.driverID;
    conformanceVersion = copy_src.conformanceVersion;
    denormBehaviorIndependence = copy_src.denormBehaviorIndependence;
    roundingModeIndependence = copy_src.roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = copy_src.shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = copy_src.shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = copy_src.shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = copy_src.shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = copy_src.shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = copy_src.shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = copy_src.shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = copy_src.shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = copy_src.shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = copy_src.shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = copy_src.shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = copy_src.shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = copy_src.shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = copy_src.shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = copy_src.shaderRoundingModeRTZFloat64;
    maxUpdateAfterBindDescriptorsInAllPools = copy_src.maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = copy_src.shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = copy_src.shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = copy_src.shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = copy_src.shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = copy_src.shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = copy_src.robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = copy_src.quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = copy_src.maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = copy_src.maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = copy_src.maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = copy_src.maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = copy_src.maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = copy_src.maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = copy_src.maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = copy_src.maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = copy_src.maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = copy_src.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = copy_src.maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = copy_src.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = copy_src.maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = copy_src.maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = copy_src.maxDescriptorSetUpdateAfterBindInputAttachments;
    supportedDepthResolveModes = copy_src.supportedDepthResolveModes;
    supportedStencilResolveModes = copy_src.supportedStencilResolveModes;
    independentResolveNone = copy_src.independentResolveNone;
    independentResolve = copy_src.independentResolve;
    filterMinmaxSingleComponentFormats = copy_src.filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = copy_src.filterMinmaxImageComponentMapping;
    maxTimelineSemaphoreValueDifference = copy_src.maxTimelineSemaphoreValueDifference;
    framebufferIntegerColorSampleCounts = copy_src.framebufferIntegerColorSampleCounts;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE; ++i) {
        driverName[i] = copy_src.driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE; ++i) {
        driverInfo[i] = copy_src.driverInfo[i];
    }

    return *this;
}

safe_VkPhysicalDeviceVulkan12Properties::~safe_VkPhysicalDeviceVulkan12Properties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceVulkan12Properties::initialize(const VkPhysicalDeviceVulkan12Properties* in_struct)
{
    sType = in_struct->sType;
    driverID = in_struct->driverID;
    conformanceVersion = in_struct->conformanceVersion;
    denormBehaviorIndependence = in_struct->denormBehaviorIndependence;
    roundingModeIndependence = in_struct->roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = in_struct->shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = in_struct->shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = in_struct->shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = in_struct->shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = in_struct->shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = in_struct->shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = in_struct->shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = in_struct->shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = in_struct->shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = in_struct->shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = in_struct->shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = in_struct->shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = in_struct->shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = in_struct->shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = in_struct->shaderRoundingModeRTZFloat64;
    maxUpdateAfterBindDescriptorsInAllPools = in_struct->maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = in_struct->shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = in_struct->shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = in_struct->shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = in_struct->shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = in_struct->shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = in_struct->robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = in_struct->quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = in_struct->maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = in_struct->maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = in_struct->maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = in_struct->maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = in_struct->maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = in_struct->maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = in_struct->maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = in_struct->maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = in_struct->maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = in_struct->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = in_struct->maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = in_struct->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = in_struct->maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = in_struct->maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = in_struct->maxDescriptorSetUpdateAfterBindInputAttachments;
    supportedDepthResolveModes = in_struct->supportedDepthResolveModes;
    supportedStencilResolveModes = in_struct->supportedStencilResolveModes;
    independentResolveNone = in_struct->independentResolveNone;
    independentResolve = in_struct->independentResolve;
    filterMinmaxSingleComponentFormats = in_struct->filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = in_struct->filterMinmaxImageComponentMapping;
    maxTimelineSemaphoreValueDifference = in_struct->maxTimelineSemaphoreValueDifference;
    framebufferIntegerColorSampleCounts = in_struct->framebufferIntegerColorSampleCounts;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE; ++i) {
        driverName[i] = in_struct->driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE; ++i) {
        driverInfo[i] = in_struct->driverInfo[i];
    }
}

void safe_VkPhysicalDeviceVulkan12Properties::initialize(const safe_VkPhysicalDeviceVulkan12Properties* copy_src)
{
    sType = copy_src->sType;
    driverID = copy_src->driverID;
    conformanceVersion = copy_src->conformanceVersion;
    denormBehaviorIndependence = copy_src->denormBehaviorIndependence;
    roundingModeIndependence = copy_src->roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = copy_src->shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = copy_src->shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = copy_src->shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = copy_src->shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = copy_src->shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = copy_src->shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = copy_src->shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = copy_src->shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = copy_src->shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = copy_src->shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = copy_src->shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = copy_src->shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = copy_src->shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = copy_src->shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = copy_src->shaderRoundingModeRTZFloat64;
    maxUpdateAfterBindDescriptorsInAllPools = copy_src->maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = copy_src->shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = copy_src->shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = copy_src->shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = copy_src->shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = copy_src->shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = copy_src->robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = copy_src->quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = copy_src->maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = copy_src->maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = copy_src->maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = copy_src->maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = copy_src->maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = copy_src->maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = copy_src->maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = copy_src->maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = copy_src->maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = copy_src->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = copy_src->maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = copy_src->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = copy_src->maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = copy_src->maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = copy_src->maxDescriptorSetUpdateAfterBindInputAttachments;
    supportedDepthResolveModes = copy_src->supportedDepthResolveModes;
    supportedStencilResolveModes = copy_src->supportedStencilResolveModes;
    independentResolveNone = copy_src->independentResolveNone;
    independentResolve = copy_src->independentResolve;
    filterMinmaxSingleComponentFormats = copy_src->filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = copy_src->filterMinmaxImageComponentMapping;
    maxTimelineSemaphoreValueDifference = copy_src->maxTimelineSemaphoreValueDifference;
    framebufferIntegerColorSampleCounts = copy_src->framebufferIntegerColorSampleCounts;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE; ++i) {
        driverName[i] = copy_src->driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE; ++i) {
        driverInfo[i] = copy_src->driverInfo[i];
    }
}

safe_VkImageFormatListCreateInfo::safe_VkImageFormatListCreateInfo(const VkImageFormatListCreateInfo* in_struct) :
    sType(in_struct->sType),
    viewFormatCount(in_struct->viewFormatCount),
    pViewFormats(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewFormats) {
        pViewFormats = new VkFormat[in_struct->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)in_struct->pViewFormats, sizeof(VkFormat)*in_struct->viewFormatCount);
    }
}

safe_VkImageFormatListCreateInfo::safe_VkImageFormatListCreateInfo() :
    sType(VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO),
    pNext(nullptr),
    pViewFormats(nullptr)
{}

safe_VkImageFormatListCreateInfo::safe_VkImageFormatListCreateInfo(const safe_VkImageFormatListCreateInfo& copy_src)
{
    sType = copy_src.sType;
    viewFormatCount = copy_src.viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pViewFormats) {
        pViewFormats = new VkFormat[copy_src.viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)copy_src.pViewFormats, sizeof(VkFormat)*copy_src.viewFormatCount);
    }
}

safe_VkImageFormatListCreateInfo& safe_VkImageFormatListCreateInfo::operator=(const safe_VkImageFormatListCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pViewFormats)
        delete[] pViewFormats;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    viewFormatCount = copy_src.viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pViewFormats) {
        pViewFormats = new VkFormat[copy_src.viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)copy_src.pViewFormats, sizeof(VkFormat)*copy_src.viewFormatCount);
    }

    return *this;
}

safe_VkImageFormatListCreateInfo::~safe_VkImageFormatListCreateInfo()
{
    if (pViewFormats)
        delete[] pViewFormats;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageFormatListCreateInfo::initialize(const VkImageFormatListCreateInfo* in_struct)
{
    sType = in_struct->sType;
    viewFormatCount = in_struct->viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewFormats) {
        pViewFormats = new VkFormat[in_struct->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)in_struct->pViewFormats, sizeof(VkFormat)*in_struct->viewFormatCount);
    }
}

void safe_VkImageFormatListCreateInfo::initialize(const safe_VkImageFormatListCreateInfo* copy_src)
{
    sType = copy_src->sType;
    viewFormatCount = copy_src->viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pViewFormats) {
        pViewFormats = new VkFormat[copy_src->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)copy_src->pViewFormats, sizeof(VkFormat)*copy_src->viewFormatCount);
    }
}

safe_VkAttachmentDescription2::safe_VkAttachmentDescription2(const VkAttachmentDescription2* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    format(in_struct->format),
    samples(in_struct->samples),
    loadOp(in_struct->loadOp),
    storeOp(in_struct->storeOp),
    stencilLoadOp(in_struct->stencilLoadOp),
    stencilStoreOp(in_struct->stencilStoreOp),
    initialLayout(in_struct->initialLayout),
    finalLayout(in_struct->finalLayout)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAttachmentDescription2::safe_VkAttachmentDescription2() :
    sType(VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2),
    pNext(nullptr)
{}

safe_VkAttachmentDescription2::safe_VkAttachmentDescription2(const safe_VkAttachmentDescription2& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    format = copy_src.format;
    samples = copy_src.samples;
    loadOp = copy_src.loadOp;
    storeOp = copy_src.storeOp;
    stencilLoadOp = copy_src.stencilLoadOp;
    stencilStoreOp = copy_src.stencilStoreOp;
    initialLayout = copy_src.initialLayout;
    finalLayout = copy_src.finalLayout;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkAttachmentDescription2& safe_VkAttachmentDescription2::operator=(const safe_VkAttachmentDescription2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    format = copy_src.format;
    samples = copy_src.samples;
    loadOp = copy_src.loadOp;
    storeOp = copy_src.storeOp;
    stencilLoadOp = copy_src.stencilLoadOp;
    stencilStoreOp = copy_src.stencilStoreOp;
    initialLayout = copy_src.initialLayout;
    finalLayout = copy_src.finalLayout;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkAttachmentDescription2::~safe_VkAttachmentDescription2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAttachmentDescription2::initialize(const VkAttachmentDescription2* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    format = in_struct->format;
    samples = in_struct->samples;
    loadOp = in_struct->loadOp;
    storeOp = in_struct->storeOp;
    stencilLoadOp = in_struct->stencilLoadOp;
    stencilStoreOp = in_struct->stencilStoreOp;
    initialLayout = in_struct->initialLayout;
    finalLayout = in_struct->finalLayout;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAttachmentDescription2::initialize(const safe_VkAttachmentDescription2* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    format = copy_src->format;
    samples = copy_src->samples;
    loadOp = copy_src->loadOp;
    storeOp = copy_src->storeOp;
    stencilLoadOp = copy_src->stencilLoadOp;
    stencilStoreOp = copy_src->stencilStoreOp;
    initialLayout = copy_src->initialLayout;
    finalLayout = copy_src->finalLayout;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkAttachmentReference2::safe_VkAttachmentReference2(const VkAttachmentReference2* in_struct) :
    sType(in_struct->sType),
    attachment(in_struct->attachment),
    layout(in_struct->layout),
    aspectMask(in_struct->aspectMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAttachmentReference2::safe_VkAttachmentReference2() :
    sType(VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2),
    pNext(nullptr)
{}

safe_VkAttachmentReference2::safe_VkAttachmentReference2(const safe_VkAttachmentReference2& copy_src)
{
    sType = copy_src.sType;
    attachment = copy_src.attachment;
    layout = copy_src.layout;
    aspectMask = copy_src.aspectMask;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkAttachmentReference2& safe_VkAttachmentReference2::operator=(const safe_VkAttachmentReference2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    attachment = copy_src.attachment;
    layout = copy_src.layout;
    aspectMask = copy_src.aspectMask;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkAttachmentReference2::~safe_VkAttachmentReference2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAttachmentReference2::initialize(const VkAttachmentReference2* in_struct)
{
    sType = in_struct->sType;
    attachment = in_struct->attachment;
    layout = in_struct->layout;
    aspectMask = in_struct->aspectMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAttachmentReference2::initialize(const safe_VkAttachmentReference2* copy_src)
{
    sType = copy_src->sType;
    attachment = copy_src->attachment;
    layout = copy_src->layout;
    aspectMask = copy_src->aspectMask;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSubpassDescription2::safe_VkSubpassDescription2(const VkSubpassDescription2* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pipelineBindPoint(in_struct->pipelineBindPoint),
    viewMask(in_struct->viewMask),
    inputAttachmentCount(in_struct->inputAttachmentCount),
    pInputAttachments(nullptr),
    colorAttachmentCount(in_struct->colorAttachmentCount),
    pColorAttachments(nullptr),
    pResolveAttachments(nullptr),
    pDepthStencilAttachment(nullptr),
    preserveAttachmentCount(in_struct->preserveAttachmentCount),
    pPreserveAttachments(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (inputAttachmentCount && in_struct->pInputAttachments) {
        pInputAttachments = new safe_VkAttachmentReference2[inputAttachmentCount];
        for (uint32_t i = 0; i < inputAttachmentCount; ++i) {
            pInputAttachments[i].initialize(&in_struct->pInputAttachments[i]);
        }
    }
    if (colorAttachmentCount && in_struct->pColorAttachments) {
        pColorAttachments = new safe_VkAttachmentReference2[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pColorAttachments[i].initialize(&in_struct->pColorAttachments[i]);
        }
    }
    if (colorAttachmentCount && in_struct->pResolveAttachments) {
        pResolveAttachments = new safe_VkAttachmentReference2[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pResolveAttachments[i].initialize(&in_struct->pResolveAttachments[i]);
        }
    }
    if (in_struct->pDepthStencilAttachment)
        pDepthStencilAttachment = new safe_VkAttachmentReference2(in_struct->pDepthStencilAttachment);
    if (in_struct->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[in_struct->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)in_struct->pPreserveAttachments, sizeof(uint32_t)*in_struct->preserveAttachmentCount);
    }
}

safe_VkSubpassDescription2::safe_VkSubpassDescription2() :
    sType(VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2),
    pNext(nullptr),
    pInputAttachments(nullptr),
    pColorAttachments(nullptr),
    pResolveAttachments(nullptr),
    pDepthStencilAttachment(nullptr),
    pPreserveAttachments(nullptr)
{}

safe_VkSubpassDescription2::safe_VkSubpassDescription2(const safe_VkSubpassDescription2& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    pipelineBindPoint = copy_src.pipelineBindPoint;
    viewMask = copy_src.viewMask;
    inputAttachmentCount = copy_src.inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = copy_src.colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = copy_src.preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (inputAttachmentCount && copy_src.pInputAttachments) {
        pInputAttachments = new safe_VkAttachmentReference2[inputAttachmentCount];
        for (uint32_t i = 0; i < inputAttachmentCount; ++i) {
            pInputAttachments[i].initialize(&copy_src.pInputAttachments[i]);
        }
    }
    if (colorAttachmentCount && copy_src.pColorAttachments) {
        pColorAttachments = new safe_VkAttachmentReference2[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pColorAttachments[i].initialize(&copy_src.pColorAttachments[i]);
        }
    }
    if (colorAttachmentCount && copy_src.pResolveAttachments) {
        pResolveAttachments = new safe_VkAttachmentReference2[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pResolveAttachments[i].initialize(&copy_src.pResolveAttachments[i]);
        }
    }
    if (copy_src.pDepthStencilAttachment)
        pDepthStencilAttachment = new safe_VkAttachmentReference2(*copy_src.pDepthStencilAttachment);
    if (copy_src.pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[copy_src.preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)copy_src.pPreserveAttachments, sizeof(uint32_t)*copy_src.preserveAttachmentCount);
    }
}

safe_VkSubpassDescription2& safe_VkSubpassDescription2::operator=(const safe_VkSubpassDescription2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pInputAttachments)
        delete[] pInputAttachments;
    if (pColorAttachments)
        delete[] pColorAttachments;
    if (pResolveAttachments)
        delete[] pResolveAttachments;
    if (pDepthStencilAttachment)
        delete pDepthStencilAttachment;
    if (pPreserveAttachments)
        delete[] pPreserveAttachments;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    pipelineBindPoint = copy_src.pipelineBindPoint;
    viewMask = copy_src.viewMask;
    inputAttachmentCount = copy_src.inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = copy_src.colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = copy_src.preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (inputAttachmentCount && copy_src.pInputAttachments) {
        pInputAttachments = new safe_VkAttachmentReference2[inputAttachmentCount];
        for (uint32_t i = 0; i < inputAttachmentCount; ++i) {
            pInputAttachments[i].initialize(&copy_src.pInputAttachments[i]);
        }
    }
    if (colorAttachmentCount && copy_src.pColorAttachments) {
        pColorAttachments = new safe_VkAttachmentReference2[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pColorAttachments[i].initialize(&copy_src.pColorAttachments[i]);
        }
    }
    if (colorAttachmentCount && copy_src.pResolveAttachments) {
        pResolveAttachments = new safe_VkAttachmentReference2[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pResolveAttachments[i].initialize(&copy_src.pResolveAttachments[i]);
        }
    }
    if (copy_src.pDepthStencilAttachment)
        pDepthStencilAttachment = new safe_VkAttachmentReference2(*copy_src.pDepthStencilAttachment);
    if (copy_src.pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[copy_src.preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)copy_src.pPreserveAttachments, sizeof(uint32_t)*copy_src.preserveAttachmentCount);
    }

    return *this;
}

safe_VkSubpassDescription2::~safe_VkSubpassDescription2()
{
    if (pInputAttachments)
        delete[] pInputAttachments;
    if (pColorAttachments)
        delete[] pColorAttachments;
    if (pResolveAttachments)
        delete[] pResolveAttachments;
    if (pDepthStencilAttachment)
        delete pDepthStencilAttachment;
    if (pPreserveAttachments)
        delete[] pPreserveAttachments;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubpassDescription2::initialize(const VkSubpassDescription2* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pipelineBindPoint = in_struct->pipelineBindPoint;
    viewMask = in_struct->viewMask;
    inputAttachmentCount = in_struct->inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = in_struct->colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = in_struct->preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (inputAttachmentCount && in_struct->pInputAttachments) {
        pInputAttachments = new safe_VkAttachmentReference2[inputAttachmentCount];
        for (uint32_t i = 0; i < inputAttachmentCount; ++i) {
            pInputAttachments[i].initialize(&in_struct->pInputAttachments[i]);
        }
    }
    if (colorAttachmentCount && in_struct->pColorAttachments) {
        pColorAttachments = new safe_VkAttachmentReference2[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pColorAttachments[i].initialize(&in_struct->pColorAttachments[i]);
        }
    }
    if (colorAttachmentCount && in_struct->pResolveAttachments) {
        pResolveAttachments = new safe_VkAttachmentReference2[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pResolveAttachments[i].initialize(&in_struct->pResolveAttachments[i]);
        }
    }
    if (in_struct->pDepthStencilAttachment)
        pDepthStencilAttachment = new safe_VkAttachmentReference2(in_struct->pDepthStencilAttachment);
    if (in_struct->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[in_struct->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)in_struct->pPreserveAttachments, sizeof(uint32_t)*in_struct->preserveAttachmentCount);
    }
}

void safe_VkSubpassDescription2::initialize(const safe_VkSubpassDescription2* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    pipelineBindPoint = copy_src->pipelineBindPoint;
    viewMask = copy_src->viewMask;
    inputAttachmentCount = copy_src->inputAttachmentCount;
    pInputAttachments = nullptr;
    colorAttachmentCount = copy_src->colorAttachmentCount;
    pColorAttachments = nullptr;
    pResolveAttachments = nullptr;
    pDepthStencilAttachment = nullptr;
    preserveAttachmentCount = copy_src->preserveAttachmentCount;
    pPreserveAttachments = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (inputAttachmentCount && copy_src->pInputAttachments) {
        pInputAttachments = new safe_VkAttachmentReference2[inputAttachmentCount];
        for (uint32_t i = 0; i < inputAttachmentCount; ++i) {
            pInputAttachments[i].initialize(&copy_src->pInputAttachments[i]);
        }
    }
    if (colorAttachmentCount && copy_src->pColorAttachments) {
        pColorAttachments = new safe_VkAttachmentReference2[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pColorAttachments[i].initialize(&copy_src->pColorAttachments[i]);
        }
    }
    if (colorAttachmentCount && copy_src->pResolveAttachments) {
        pResolveAttachments = new safe_VkAttachmentReference2[colorAttachmentCount];
        for (uint32_t i = 0; i < colorAttachmentCount; ++i) {
            pResolveAttachments[i].initialize(&copy_src->pResolveAttachments[i]);
        }
    }
    if (copy_src->pDepthStencilAttachment)
        pDepthStencilAttachment = new safe_VkAttachmentReference2(*copy_src->pDepthStencilAttachment);
    if (copy_src->pPreserveAttachments) {
        pPreserveAttachments = new uint32_t[copy_src->preserveAttachmentCount];
        memcpy ((void *)pPreserveAttachments, (void *)copy_src->pPreserveAttachments, sizeof(uint32_t)*copy_src->preserveAttachmentCount);
    }
}

safe_VkSubpassDependency2::safe_VkSubpassDependency2(const VkSubpassDependency2* in_struct) :
    sType(in_struct->sType),
    srcSubpass(in_struct->srcSubpass),
    dstSubpass(in_struct->dstSubpass),
    srcStageMask(in_struct->srcStageMask),
    dstStageMask(in_struct->dstStageMask),
    srcAccessMask(in_struct->srcAccessMask),
    dstAccessMask(in_struct->dstAccessMask),
    dependencyFlags(in_struct->dependencyFlags),
    viewOffset(in_struct->viewOffset)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSubpassDependency2::safe_VkSubpassDependency2() :
    sType(VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2),
    pNext(nullptr)
{}

safe_VkSubpassDependency2::safe_VkSubpassDependency2(const safe_VkSubpassDependency2& copy_src)
{
    sType = copy_src.sType;
    srcSubpass = copy_src.srcSubpass;
    dstSubpass = copy_src.dstSubpass;
    srcStageMask = copy_src.srcStageMask;
    dstStageMask = copy_src.dstStageMask;
    srcAccessMask = copy_src.srcAccessMask;
    dstAccessMask = copy_src.dstAccessMask;
    dependencyFlags = copy_src.dependencyFlags;
    viewOffset = copy_src.viewOffset;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSubpassDependency2& safe_VkSubpassDependency2::operator=(const safe_VkSubpassDependency2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcSubpass = copy_src.srcSubpass;
    dstSubpass = copy_src.dstSubpass;
    srcStageMask = copy_src.srcStageMask;
    dstStageMask = copy_src.dstStageMask;
    srcAccessMask = copy_src.srcAccessMask;
    dstAccessMask = copy_src.dstAccessMask;
    dependencyFlags = copy_src.dependencyFlags;
    viewOffset = copy_src.viewOffset;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSubpassDependency2::~safe_VkSubpassDependency2()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubpassDependency2::initialize(const VkSubpassDependency2* in_struct)
{
    sType = in_struct->sType;
    srcSubpass = in_struct->srcSubpass;
    dstSubpass = in_struct->dstSubpass;
    srcStageMask = in_struct->srcStageMask;
    dstStageMask = in_struct->dstStageMask;
    srcAccessMask = in_struct->srcAccessMask;
    dstAccessMask = in_struct->dstAccessMask;
    dependencyFlags = in_struct->dependencyFlags;
    viewOffset = in_struct->viewOffset;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSubpassDependency2::initialize(const safe_VkSubpassDependency2* copy_src)
{
    sType = copy_src->sType;
    srcSubpass = copy_src->srcSubpass;
    dstSubpass = copy_src->dstSubpass;
    srcStageMask = copy_src->srcStageMask;
    dstStageMask = copy_src->dstStageMask;
    srcAccessMask = copy_src->srcAccessMask;
    dstAccessMask = copy_src->dstAccessMask;
    dependencyFlags = copy_src->dependencyFlags;
    viewOffset = copy_src->viewOffset;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkRenderPassCreateInfo2::safe_VkRenderPassCreateInfo2(const VkRenderPassCreateInfo2* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    attachmentCount(in_struct->attachmentCount),
    pAttachments(nullptr),
    subpassCount(in_struct->subpassCount),
    pSubpasses(nullptr),
    dependencyCount(in_struct->dependencyCount),
    pDependencies(nullptr),
    correlatedViewMaskCount(in_struct->correlatedViewMaskCount),
    pCorrelatedViewMasks(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments) {
        pAttachments = new safe_VkAttachmentDescription2[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i].initialize(&in_struct->pAttachments[i]);
        }
    }
    if (subpassCount && in_struct->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription2[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&in_struct->pSubpasses[i]);
        }
    }
    if (dependencyCount && in_struct->pDependencies) {
        pDependencies = new safe_VkSubpassDependency2[dependencyCount];
        for (uint32_t i = 0; i < dependencyCount; ++i) {
            pDependencies[i].initialize(&in_struct->pDependencies[i]);
        }
    }
    if (in_struct->pCorrelatedViewMasks) {
        pCorrelatedViewMasks = new uint32_t[in_struct->correlatedViewMaskCount];
        memcpy ((void *)pCorrelatedViewMasks, (void *)in_struct->pCorrelatedViewMasks, sizeof(uint32_t)*in_struct->correlatedViewMaskCount);
    }
}

safe_VkRenderPassCreateInfo2::safe_VkRenderPassCreateInfo2() :
    sType(VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2),
    pNext(nullptr),
    pAttachments(nullptr),
    pSubpasses(nullptr),
    pDependencies(nullptr),
    pCorrelatedViewMasks(nullptr)
{}

safe_VkRenderPassCreateInfo2::safe_VkRenderPassCreateInfo2(const safe_VkRenderPassCreateInfo2& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    attachmentCount = copy_src.attachmentCount;
    pAttachments = nullptr;
    subpassCount = copy_src.subpassCount;
    pSubpasses = nullptr;
    dependencyCount = copy_src.dependencyCount;
    pDependencies = nullptr;
    correlatedViewMaskCount = copy_src.correlatedViewMaskCount;
    pCorrelatedViewMasks = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (attachmentCount && copy_src.pAttachments) {
        pAttachments = new safe_VkAttachmentDescription2[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i].initialize(&copy_src.pAttachments[i]);
        }
    }
    if (subpassCount && copy_src.pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription2[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&copy_src.pSubpasses[i]);
        }
    }
    if (dependencyCount && copy_src.pDependencies) {
        pDependencies = new safe_VkSubpassDependency2[dependencyCount];
        for (uint32_t i = 0; i < dependencyCount; ++i) {
            pDependencies[i].initialize(&copy_src.pDependencies[i]);
        }
    }
    if (copy_src.pCorrelatedViewMasks) {
        pCorrelatedViewMasks = new uint32_t[copy_src.correlatedViewMaskCount];
        memcpy ((void *)pCorrelatedViewMasks, (void *)copy_src.pCorrelatedViewMasks, sizeof(uint32_t)*copy_src.correlatedViewMaskCount);
    }
}

safe_VkRenderPassCreateInfo2& safe_VkRenderPassCreateInfo2::operator=(const safe_VkRenderPassCreateInfo2& copy_src)
{
    if (&copy_src == this) return *this;

    if (pAttachments)
        delete[] pAttachments;
    if (pSubpasses)
        delete[] pSubpasses;
    if (pDependencies)
        delete[] pDependencies;
    if (pCorrelatedViewMasks)
        delete[] pCorrelatedViewMasks;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    attachmentCount = copy_src.attachmentCount;
    pAttachments = nullptr;
    subpassCount = copy_src.subpassCount;
    pSubpasses = nullptr;
    dependencyCount = copy_src.dependencyCount;
    pDependencies = nullptr;
    correlatedViewMaskCount = copy_src.correlatedViewMaskCount;
    pCorrelatedViewMasks = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (attachmentCount && copy_src.pAttachments) {
        pAttachments = new safe_VkAttachmentDescription2[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i].initialize(&copy_src.pAttachments[i]);
        }
    }
    if (subpassCount && copy_src.pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription2[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&copy_src.pSubpasses[i]);
        }
    }
    if (dependencyCount && copy_src.pDependencies) {
        pDependencies = new safe_VkSubpassDependency2[dependencyCount];
        for (uint32_t i = 0; i < dependencyCount; ++i) {
            pDependencies[i].initialize(&copy_src.pDependencies[i]);
        }
    }
    if (copy_src.pCorrelatedViewMasks) {
        pCorrelatedViewMasks = new uint32_t[copy_src.correlatedViewMaskCount];
        memcpy ((void *)pCorrelatedViewMasks, (void *)copy_src.pCorrelatedViewMasks, sizeof(uint32_t)*copy_src.correlatedViewMaskCount);
    }

    return *this;
}

safe_VkRenderPassCreateInfo2::~safe_VkRenderPassCreateInfo2()
{
    if (pAttachments)
        delete[] pAttachments;
    if (pSubpasses)
        delete[] pSubpasses;
    if (pDependencies)
        delete[] pDependencies;
    if (pCorrelatedViewMasks)
        delete[] pCorrelatedViewMasks;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassCreateInfo2::initialize(const VkRenderPassCreateInfo2* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    attachmentCount = in_struct->attachmentCount;
    pAttachments = nullptr;
    subpassCount = in_struct->subpassCount;
    pSubpasses = nullptr;
    dependencyCount = in_struct->dependencyCount;
    pDependencies = nullptr;
    correlatedViewMaskCount = in_struct->correlatedViewMaskCount;
    pCorrelatedViewMasks = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments) {
        pAttachments = new safe_VkAttachmentDescription2[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i].initialize(&in_struct->pAttachments[i]);
        }
    }
    if (subpassCount && in_struct->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription2[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&in_struct->pSubpasses[i]);
        }
    }
    if (dependencyCount && in_struct->pDependencies) {
        pDependencies = new safe_VkSubpassDependency2[dependencyCount];
        for (uint32_t i = 0; i < dependencyCount; ++i) {
            pDependencies[i].initialize(&in_struct->pDependencies[i]);
        }
    }
    if (in_struct->pCorrelatedViewMasks) {
        pCorrelatedViewMasks = new uint32_t[in_struct->correlatedViewMaskCount];
        memcpy ((void *)pCorrelatedViewMasks, (void *)in_struct->pCorrelatedViewMasks, sizeof(uint32_t)*in_struct->correlatedViewMaskCount);
    }
}

void safe_VkRenderPassCreateInfo2::initialize(const safe_VkRenderPassCreateInfo2* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    attachmentCount = copy_src->attachmentCount;
    pAttachments = nullptr;
    subpassCount = copy_src->subpassCount;
    pSubpasses = nullptr;
    dependencyCount = copy_src->dependencyCount;
    pDependencies = nullptr;
    correlatedViewMaskCount = copy_src->correlatedViewMaskCount;
    pCorrelatedViewMasks = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (attachmentCount && copy_src->pAttachments) {
        pAttachments = new safe_VkAttachmentDescription2[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i].initialize(&copy_src->pAttachments[i]);
        }
    }
    if (subpassCount && copy_src->pSubpasses) {
        pSubpasses = new safe_VkSubpassDescription2[subpassCount];
        for (uint32_t i = 0; i < subpassCount; ++i) {
            pSubpasses[i].initialize(&copy_src->pSubpasses[i]);
        }
    }
    if (dependencyCount && copy_src->pDependencies) {
        pDependencies = new safe_VkSubpassDependency2[dependencyCount];
        for (uint32_t i = 0; i < dependencyCount; ++i) {
            pDependencies[i].initialize(&copy_src->pDependencies[i]);
        }
    }
    if (copy_src->pCorrelatedViewMasks) {
        pCorrelatedViewMasks = new uint32_t[copy_src->correlatedViewMaskCount];
        memcpy ((void *)pCorrelatedViewMasks, (void *)copy_src->pCorrelatedViewMasks, sizeof(uint32_t)*copy_src->correlatedViewMaskCount);
    }
}

safe_VkSubpassBeginInfo::safe_VkSubpassBeginInfo(const VkSubpassBeginInfo* in_struct) :
    sType(in_struct->sType),
    contents(in_struct->contents)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSubpassBeginInfo::safe_VkSubpassBeginInfo() :
    sType(VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO),
    pNext(nullptr)
{}

safe_VkSubpassBeginInfo::safe_VkSubpassBeginInfo(const safe_VkSubpassBeginInfo& copy_src)
{
    sType = copy_src.sType;
    contents = copy_src.contents;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSubpassBeginInfo& safe_VkSubpassBeginInfo::operator=(const safe_VkSubpassBeginInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    contents = copy_src.contents;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSubpassBeginInfo::~safe_VkSubpassBeginInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubpassBeginInfo::initialize(const VkSubpassBeginInfo* in_struct)
{
    sType = in_struct->sType;
    contents = in_struct->contents;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSubpassBeginInfo::initialize(const safe_VkSubpassBeginInfo* copy_src)
{
    sType = copy_src->sType;
    contents = copy_src->contents;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSubpassEndInfo::safe_VkSubpassEndInfo(const VkSubpassEndInfo* in_struct) :
    sType(in_struct->sType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSubpassEndInfo::safe_VkSubpassEndInfo() :
    sType(VK_STRUCTURE_TYPE_SUBPASS_END_INFO),
    pNext(nullptr)
{}

safe_VkSubpassEndInfo::safe_VkSubpassEndInfo(const safe_VkSubpassEndInfo& copy_src)
{
    sType = copy_src.sType;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSubpassEndInfo& safe_VkSubpassEndInfo::operator=(const safe_VkSubpassEndInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSubpassEndInfo::~safe_VkSubpassEndInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubpassEndInfo::initialize(const VkSubpassEndInfo* in_struct)
{
    sType = in_struct->sType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSubpassEndInfo::initialize(const safe_VkSubpassEndInfo* copy_src)
{
    sType = copy_src->sType;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDevice8BitStorageFeatures::safe_VkPhysicalDevice8BitStorageFeatures(const VkPhysicalDevice8BitStorageFeatures* in_struct) :
    sType(in_struct->sType),
    storageBuffer8BitAccess(in_struct->storageBuffer8BitAccess),
    uniformAndStorageBuffer8BitAccess(in_struct->uniformAndStorageBuffer8BitAccess),
    storagePushConstant8(in_struct->storagePushConstant8)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevice8BitStorageFeatures::safe_VkPhysicalDevice8BitStorageFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDevice8BitStorageFeatures::safe_VkPhysicalDevice8BitStorageFeatures(const safe_VkPhysicalDevice8BitStorageFeatures& copy_src)
{
    sType = copy_src.sType;
    storageBuffer8BitAccess = copy_src.storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = copy_src.uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = copy_src.storagePushConstant8;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDevice8BitStorageFeatures& safe_VkPhysicalDevice8BitStorageFeatures::operator=(const safe_VkPhysicalDevice8BitStorageFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    storageBuffer8BitAccess = copy_src.storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = copy_src.uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = copy_src.storagePushConstant8;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDevice8BitStorageFeatures::~safe_VkPhysicalDevice8BitStorageFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevice8BitStorageFeatures::initialize(const VkPhysicalDevice8BitStorageFeatures* in_struct)
{
    sType = in_struct->sType;
    storageBuffer8BitAccess = in_struct->storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = in_struct->uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = in_struct->storagePushConstant8;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevice8BitStorageFeatures::initialize(const safe_VkPhysicalDevice8BitStorageFeatures* copy_src)
{
    sType = copy_src->sType;
    storageBuffer8BitAccess = copy_src->storageBuffer8BitAccess;
    uniformAndStorageBuffer8BitAccess = copy_src->uniformAndStorageBuffer8BitAccess;
    storagePushConstant8 = copy_src->storagePushConstant8;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceDriverProperties::safe_VkPhysicalDeviceDriverProperties(const VkPhysicalDeviceDriverProperties* in_struct) :
    sType(in_struct->sType),
    driverID(in_struct->driverID),
    conformanceVersion(in_struct->conformanceVersion)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE; ++i) {
        driverName[i] = in_struct->driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE; ++i) {
        driverInfo[i] = in_struct->driverInfo[i];
    }
}

safe_VkPhysicalDeviceDriverProperties::safe_VkPhysicalDeviceDriverProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceDriverProperties::safe_VkPhysicalDeviceDriverProperties(const safe_VkPhysicalDeviceDriverProperties& copy_src)
{
    sType = copy_src.sType;
    driverID = copy_src.driverID;
    conformanceVersion = copy_src.conformanceVersion;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE; ++i) {
        driverName[i] = copy_src.driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE; ++i) {
        driverInfo[i] = copy_src.driverInfo[i];
    }
}

safe_VkPhysicalDeviceDriverProperties& safe_VkPhysicalDeviceDriverProperties::operator=(const safe_VkPhysicalDeviceDriverProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    driverID = copy_src.driverID;
    conformanceVersion = copy_src.conformanceVersion;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE; ++i) {
        driverName[i] = copy_src.driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE; ++i) {
        driverInfo[i] = copy_src.driverInfo[i];
    }

    return *this;
}

safe_VkPhysicalDeviceDriverProperties::~safe_VkPhysicalDeviceDriverProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceDriverProperties::initialize(const VkPhysicalDeviceDriverProperties* in_struct)
{
    sType = in_struct->sType;
    driverID = in_struct->driverID;
    conformanceVersion = in_struct->conformanceVersion;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE; ++i) {
        driverName[i] = in_struct->driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE; ++i) {
        driverInfo[i] = in_struct->driverInfo[i];
    }
}

void safe_VkPhysicalDeviceDriverProperties::initialize(const safe_VkPhysicalDeviceDriverProperties* copy_src)
{
    sType = copy_src->sType;
    driverID = copy_src->driverID;
    conformanceVersion = copy_src->conformanceVersion;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DRIVER_NAME_SIZE; ++i) {
        driverName[i] = copy_src->driverName[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DRIVER_INFO_SIZE; ++i) {
        driverInfo[i] = copy_src->driverInfo[i];
    }
}

safe_VkPhysicalDeviceShaderAtomicInt64Features::safe_VkPhysicalDeviceShaderAtomicInt64Features(const VkPhysicalDeviceShaderAtomicInt64Features* in_struct) :
    sType(in_struct->sType),
    shaderBufferInt64Atomics(in_struct->shaderBufferInt64Atomics),
    shaderSharedInt64Atomics(in_struct->shaderSharedInt64Atomics)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderAtomicInt64Features::safe_VkPhysicalDeviceShaderAtomicInt64Features() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderAtomicInt64Features::safe_VkPhysicalDeviceShaderAtomicInt64Features(const safe_VkPhysicalDeviceShaderAtomicInt64Features& copy_src)
{
    sType = copy_src.sType;
    shaderBufferInt64Atomics = copy_src.shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = copy_src.shaderSharedInt64Atomics;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceShaderAtomicInt64Features& safe_VkPhysicalDeviceShaderAtomicInt64Features::operator=(const safe_VkPhysicalDeviceShaderAtomicInt64Features& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    shaderBufferInt64Atomics = copy_src.shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = copy_src.shaderSharedInt64Atomics;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderAtomicInt64Features::~safe_VkPhysicalDeviceShaderAtomicInt64Features()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderAtomicInt64Features::initialize(const VkPhysicalDeviceShaderAtomicInt64Features* in_struct)
{
    sType = in_struct->sType;
    shaderBufferInt64Atomics = in_struct->shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = in_struct->shaderSharedInt64Atomics;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderAtomicInt64Features::initialize(const safe_VkPhysicalDeviceShaderAtomicInt64Features* copy_src)
{
    sType = copy_src->sType;
    shaderBufferInt64Atomics = copy_src->shaderBufferInt64Atomics;
    shaderSharedInt64Atomics = copy_src->shaderSharedInt64Atomics;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceShaderFloat16Int8Features::safe_VkPhysicalDeviceShaderFloat16Int8Features(const VkPhysicalDeviceShaderFloat16Int8Features* in_struct) :
    sType(in_struct->sType),
    shaderFloat16(in_struct->shaderFloat16),
    shaderInt8(in_struct->shaderInt8)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderFloat16Int8Features::safe_VkPhysicalDeviceShaderFloat16Int8Features() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderFloat16Int8Features::safe_VkPhysicalDeviceShaderFloat16Int8Features(const safe_VkPhysicalDeviceShaderFloat16Int8Features& copy_src)
{
    sType = copy_src.sType;
    shaderFloat16 = copy_src.shaderFloat16;
    shaderInt8 = copy_src.shaderInt8;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceShaderFloat16Int8Features& safe_VkPhysicalDeviceShaderFloat16Int8Features::operator=(const safe_VkPhysicalDeviceShaderFloat16Int8Features& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    shaderFloat16 = copy_src.shaderFloat16;
    shaderInt8 = copy_src.shaderInt8;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderFloat16Int8Features::~safe_VkPhysicalDeviceShaderFloat16Int8Features()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderFloat16Int8Features::initialize(const VkPhysicalDeviceShaderFloat16Int8Features* in_struct)
{
    sType = in_struct->sType;
    shaderFloat16 = in_struct->shaderFloat16;
    shaderInt8 = in_struct->shaderInt8;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderFloat16Int8Features::initialize(const safe_VkPhysicalDeviceShaderFloat16Int8Features* copy_src)
{
    sType = copy_src->sType;
    shaderFloat16 = copy_src->shaderFloat16;
    shaderInt8 = copy_src->shaderInt8;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceFloatControlsProperties::safe_VkPhysicalDeviceFloatControlsProperties(const VkPhysicalDeviceFloatControlsProperties* in_struct) :
    sType(in_struct->sType),
    denormBehaviorIndependence(in_struct->denormBehaviorIndependence),
    roundingModeIndependence(in_struct->roundingModeIndependence),
    shaderSignedZeroInfNanPreserveFloat16(in_struct->shaderSignedZeroInfNanPreserveFloat16),
    shaderSignedZeroInfNanPreserveFloat32(in_struct->shaderSignedZeroInfNanPreserveFloat32),
    shaderSignedZeroInfNanPreserveFloat64(in_struct->shaderSignedZeroInfNanPreserveFloat64),
    shaderDenormPreserveFloat16(in_struct->shaderDenormPreserveFloat16),
    shaderDenormPreserveFloat32(in_struct->shaderDenormPreserveFloat32),
    shaderDenormPreserveFloat64(in_struct->shaderDenormPreserveFloat64),
    shaderDenormFlushToZeroFloat16(in_struct->shaderDenormFlushToZeroFloat16),
    shaderDenormFlushToZeroFloat32(in_struct->shaderDenormFlushToZeroFloat32),
    shaderDenormFlushToZeroFloat64(in_struct->shaderDenormFlushToZeroFloat64),
    shaderRoundingModeRTEFloat16(in_struct->shaderRoundingModeRTEFloat16),
    shaderRoundingModeRTEFloat32(in_struct->shaderRoundingModeRTEFloat32),
    shaderRoundingModeRTEFloat64(in_struct->shaderRoundingModeRTEFloat64),
    shaderRoundingModeRTZFloat16(in_struct->shaderRoundingModeRTZFloat16),
    shaderRoundingModeRTZFloat32(in_struct->shaderRoundingModeRTZFloat32),
    shaderRoundingModeRTZFloat64(in_struct->shaderRoundingModeRTZFloat64)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceFloatControlsProperties::safe_VkPhysicalDeviceFloatControlsProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceFloatControlsProperties::safe_VkPhysicalDeviceFloatControlsProperties(const safe_VkPhysicalDeviceFloatControlsProperties& copy_src)
{
    sType = copy_src.sType;
    denormBehaviorIndependence = copy_src.denormBehaviorIndependence;
    roundingModeIndependence = copy_src.roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = copy_src.shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = copy_src.shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = copy_src.shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = copy_src.shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = copy_src.shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = copy_src.shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = copy_src.shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = copy_src.shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = copy_src.shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = copy_src.shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = copy_src.shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = copy_src.shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = copy_src.shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = copy_src.shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = copy_src.shaderRoundingModeRTZFloat64;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceFloatControlsProperties& safe_VkPhysicalDeviceFloatControlsProperties::operator=(const safe_VkPhysicalDeviceFloatControlsProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    denormBehaviorIndependence = copy_src.denormBehaviorIndependence;
    roundingModeIndependence = copy_src.roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = copy_src.shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = copy_src.shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = copy_src.shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = copy_src.shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = copy_src.shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = copy_src.shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = copy_src.shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = copy_src.shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = copy_src.shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = copy_src.shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = copy_src.shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = copy_src.shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = copy_src.shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = copy_src.shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = copy_src.shaderRoundingModeRTZFloat64;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceFloatControlsProperties::~safe_VkPhysicalDeviceFloatControlsProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceFloatControlsProperties::initialize(const VkPhysicalDeviceFloatControlsProperties* in_struct)
{
    sType = in_struct->sType;
    denormBehaviorIndependence = in_struct->denormBehaviorIndependence;
    roundingModeIndependence = in_struct->roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = in_struct->shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = in_struct->shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = in_struct->shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = in_struct->shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = in_struct->shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = in_struct->shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = in_struct->shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = in_struct->shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = in_struct->shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = in_struct->shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = in_struct->shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = in_struct->shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = in_struct->shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = in_struct->shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = in_struct->shaderRoundingModeRTZFloat64;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceFloatControlsProperties::initialize(const safe_VkPhysicalDeviceFloatControlsProperties* copy_src)
{
    sType = copy_src->sType;
    denormBehaviorIndependence = copy_src->denormBehaviorIndependence;
    roundingModeIndependence = copy_src->roundingModeIndependence;
    shaderSignedZeroInfNanPreserveFloat16 = copy_src->shaderSignedZeroInfNanPreserveFloat16;
    shaderSignedZeroInfNanPreserveFloat32 = copy_src->shaderSignedZeroInfNanPreserveFloat32;
    shaderSignedZeroInfNanPreserveFloat64 = copy_src->shaderSignedZeroInfNanPreserveFloat64;
    shaderDenormPreserveFloat16 = copy_src->shaderDenormPreserveFloat16;
    shaderDenormPreserveFloat32 = copy_src->shaderDenormPreserveFloat32;
    shaderDenormPreserveFloat64 = copy_src->shaderDenormPreserveFloat64;
    shaderDenormFlushToZeroFloat16 = copy_src->shaderDenormFlushToZeroFloat16;
    shaderDenormFlushToZeroFloat32 = copy_src->shaderDenormFlushToZeroFloat32;
    shaderDenormFlushToZeroFloat64 = copy_src->shaderDenormFlushToZeroFloat64;
    shaderRoundingModeRTEFloat16 = copy_src->shaderRoundingModeRTEFloat16;
    shaderRoundingModeRTEFloat32 = copy_src->shaderRoundingModeRTEFloat32;
    shaderRoundingModeRTEFloat64 = copy_src->shaderRoundingModeRTEFloat64;
    shaderRoundingModeRTZFloat16 = copy_src->shaderRoundingModeRTZFloat16;
    shaderRoundingModeRTZFloat32 = copy_src->shaderRoundingModeRTZFloat32;
    shaderRoundingModeRTZFloat64 = copy_src->shaderRoundingModeRTZFloat64;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDescriptorSetLayoutBindingFlagsCreateInfo::safe_VkDescriptorSetLayoutBindingFlagsCreateInfo(const VkDescriptorSetLayoutBindingFlagsCreateInfo* in_struct) :
    sType(in_struct->sType),
    bindingCount(in_struct->bindingCount),
    pBindingFlags(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pBindingFlags) {
        pBindingFlags = new VkDescriptorBindingFlags[in_struct->bindingCount];
        memcpy ((void *)pBindingFlags, (void *)in_struct->pBindingFlags, sizeof(VkDescriptorBindingFlags)*in_struct->bindingCount);
    }
}

safe_VkDescriptorSetLayoutBindingFlagsCreateInfo::safe_VkDescriptorSetLayoutBindingFlagsCreateInfo() :
    sType(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO),
    pNext(nullptr),
    pBindingFlags(nullptr)
{}

safe_VkDescriptorSetLayoutBindingFlagsCreateInfo::safe_VkDescriptorSetLayoutBindingFlagsCreateInfo(const safe_VkDescriptorSetLayoutBindingFlagsCreateInfo& copy_src)
{
    sType = copy_src.sType;
    bindingCount = copy_src.bindingCount;
    pBindingFlags = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pBindingFlags) {
        pBindingFlags = new VkDescriptorBindingFlags[copy_src.bindingCount];
        memcpy ((void *)pBindingFlags, (void *)copy_src.pBindingFlags, sizeof(VkDescriptorBindingFlags)*copy_src.bindingCount);
    }
}

safe_VkDescriptorSetLayoutBindingFlagsCreateInfo& safe_VkDescriptorSetLayoutBindingFlagsCreateInfo::operator=(const safe_VkDescriptorSetLayoutBindingFlagsCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pBindingFlags)
        delete[] pBindingFlags;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    bindingCount = copy_src.bindingCount;
    pBindingFlags = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pBindingFlags) {
        pBindingFlags = new VkDescriptorBindingFlags[copy_src.bindingCount];
        memcpy ((void *)pBindingFlags, (void *)copy_src.pBindingFlags, sizeof(VkDescriptorBindingFlags)*copy_src.bindingCount);
    }

    return *this;
}

safe_VkDescriptorSetLayoutBindingFlagsCreateInfo::~safe_VkDescriptorSetLayoutBindingFlagsCreateInfo()
{
    if (pBindingFlags)
        delete[] pBindingFlags;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetLayoutBindingFlagsCreateInfo::initialize(const VkDescriptorSetLayoutBindingFlagsCreateInfo* in_struct)
{
    sType = in_struct->sType;
    bindingCount = in_struct->bindingCount;
    pBindingFlags = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pBindingFlags) {
        pBindingFlags = new VkDescriptorBindingFlags[in_struct->bindingCount];
        memcpy ((void *)pBindingFlags, (void *)in_struct->pBindingFlags, sizeof(VkDescriptorBindingFlags)*in_struct->bindingCount);
    }
}

void safe_VkDescriptorSetLayoutBindingFlagsCreateInfo::initialize(const safe_VkDescriptorSetLayoutBindingFlagsCreateInfo* copy_src)
{
    sType = copy_src->sType;
    bindingCount = copy_src->bindingCount;
    pBindingFlags = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pBindingFlags) {
        pBindingFlags = new VkDescriptorBindingFlags[copy_src->bindingCount];
        memcpy ((void *)pBindingFlags, (void *)copy_src->pBindingFlags, sizeof(VkDescriptorBindingFlags)*copy_src->bindingCount);
    }
}

safe_VkPhysicalDeviceDescriptorIndexingFeatures::safe_VkPhysicalDeviceDescriptorIndexingFeatures(const VkPhysicalDeviceDescriptorIndexingFeatures* in_struct) :
    sType(in_struct->sType),
    shaderInputAttachmentArrayDynamicIndexing(in_struct->shaderInputAttachmentArrayDynamicIndexing),
    shaderUniformTexelBufferArrayDynamicIndexing(in_struct->shaderUniformTexelBufferArrayDynamicIndexing),
    shaderStorageTexelBufferArrayDynamicIndexing(in_struct->shaderStorageTexelBufferArrayDynamicIndexing),
    shaderUniformBufferArrayNonUniformIndexing(in_struct->shaderUniformBufferArrayNonUniformIndexing),
    shaderSampledImageArrayNonUniformIndexing(in_struct->shaderSampledImageArrayNonUniformIndexing),
    shaderStorageBufferArrayNonUniformIndexing(in_struct->shaderStorageBufferArrayNonUniformIndexing),
    shaderStorageImageArrayNonUniformIndexing(in_struct->shaderStorageImageArrayNonUniformIndexing),
    shaderInputAttachmentArrayNonUniformIndexing(in_struct->shaderInputAttachmentArrayNonUniformIndexing),
    shaderUniformTexelBufferArrayNonUniformIndexing(in_struct->shaderUniformTexelBufferArrayNonUniformIndexing),
    shaderStorageTexelBufferArrayNonUniformIndexing(in_struct->shaderStorageTexelBufferArrayNonUniformIndexing),
    descriptorBindingUniformBufferUpdateAfterBind(in_struct->descriptorBindingUniformBufferUpdateAfterBind),
    descriptorBindingSampledImageUpdateAfterBind(in_struct->descriptorBindingSampledImageUpdateAfterBind),
    descriptorBindingStorageImageUpdateAfterBind(in_struct->descriptorBindingStorageImageUpdateAfterBind),
    descriptorBindingStorageBufferUpdateAfterBind(in_struct->descriptorBindingStorageBufferUpdateAfterBind),
    descriptorBindingUniformTexelBufferUpdateAfterBind(in_struct->descriptorBindingUniformTexelBufferUpdateAfterBind),
    descriptorBindingStorageTexelBufferUpdateAfterBind(in_struct->descriptorBindingStorageTexelBufferUpdateAfterBind),
    descriptorBindingUpdateUnusedWhilePending(in_struct->descriptorBindingUpdateUnusedWhilePending),
    descriptorBindingPartiallyBound(in_struct->descriptorBindingPartiallyBound),
    descriptorBindingVariableDescriptorCount(in_struct->descriptorBindingVariableDescriptorCount),
    runtimeDescriptorArray(in_struct->runtimeDescriptorArray)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceDescriptorIndexingFeatures::safe_VkPhysicalDeviceDescriptorIndexingFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceDescriptorIndexingFeatures::safe_VkPhysicalDeviceDescriptorIndexingFeatures(const safe_VkPhysicalDeviceDescriptorIndexingFeatures& copy_src)
{
    sType = copy_src.sType;
    shaderInputAttachmentArrayDynamicIndexing = copy_src.shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = copy_src.shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = copy_src.shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = copy_src.shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = copy_src.shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = copy_src.shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = copy_src.shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = copy_src.shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = copy_src.shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = copy_src.shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = copy_src.descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = copy_src.descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = copy_src.descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = copy_src.descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = copy_src.descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = copy_src.descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = copy_src.descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = copy_src.descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = copy_src.descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = copy_src.runtimeDescriptorArray;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceDescriptorIndexingFeatures& safe_VkPhysicalDeviceDescriptorIndexingFeatures::operator=(const safe_VkPhysicalDeviceDescriptorIndexingFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    shaderInputAttachmentArrayDynamicIndexing = copy_src.shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = copy_src.shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = copy_src.shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = copy_src.shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = copy_src.shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = copy_src.shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = copy_src.shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = copy_src.shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = copy_src.shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = copy_src.shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = copy_src.descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = copy_src.descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = copy_src.descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = copy_src.descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = copy_src.descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = copy_src.descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = copy_src.descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = copy_src.descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = copy_src.descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = copy_src.runtimeDescriptorArray;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceDescriptorIndexingFeatures::~safe_VkPhysicalDeviceDescriptorIndexingFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceDescriptorIndexingFeatures::initialize(const VkPhysicalDeviceDescriptorIndexingFeatures* in_struct)
{
    sType = in_struct->sType;
    shaderInputAttachmentArrayDynamicIndexing = in_struct->shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = in_struct->shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = in_struct->shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = in_struct->shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = in_struct->shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = in_struct->shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = in_struct->shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = in_struct->shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = in_struct->shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = in_struct->shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = in_struct->descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = in_struct->descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = in_struct->descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = in_struct->descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = in_struct->descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = in_struct->descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = in_struct->descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = in_struct->descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = in_struct->descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = in_struct->runtimeDescriptorArray;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceDescriptorIndexingFeatures::initialize(const safe_VkPhysicalDeviceDescriptorIndexingFeatures* copy_src)
{
    sType = copy_src->sType;
    shaderInputAttachmentArrayDynamicIndexing = copy_src->shaderInputAttachmentArrayDynamicIndexing;
    shaderUniformTexelBufferArrayDynamicIndexing = copy_src->shaderUniformTexelBufferArrayDynamicIndexing;
    shaderStorageTexelBufferArrayDynamicIndexing = copy_src->shaderStorageTexelBufferArrayDynamicIndexing;
    shaderUniformBufferArrayNonUniformIndexing = copy_src->shaderUniformBufferArrayNonUniformIndexing;
    shaderSampledImageArrayNonUniformIndexing = copy_src->shaderSampledImageArrayNonUniformIndexing;
    shaderStorageBufferArrayNonUniformIndexing = copy_src->shaderStorageBufferArrayNonUniformIndexing;
    shaderStorageImageArrayNonUniformIndexing = copy_src->shaderStorageImageArrayNonUniformIndexing;
    shaderInputAttachmentArrayNonUniformIndexing = copy_src->shaderInputAttachmentArrayNonUniformIndexing;
    shaderUniformTexelBufferArrayNonUniformIndexing = copy_src->shaderUniformTexelBufferArrayNonUniformIndexing;
    shaderStorageTexelBufferArrayNonUniformIndexing = copy_src->shaderStorageTexelBufferArrayNonUniformIndexing;
    descriptorBindingUniformBufferUpdateAfterBind = copy_src->descriptorBindingUniformBufferUpdateAfterBind;
    descriptorBindingSampledImageUpdateAfterBind = copy_src->descriptorBindingSampledImageUpdateAfterBind;
    descriptorBindingStorageImageUpdateAfterBind = copy_src->descriptorBindingStorageImageUpdateAfterBind;
    descriptorBindingStorageBufferUpdateAfterBind = copy_src->descriptorBindingStorageBufferUpdateAfterBind;
    descriptorBindingUniformTexelBufferUpdateAfterBind = copy_src->descriptorBindingUniformTexelBufferUpdateAfterBind;
    descriptorBindingStorageTexelBufferUpdateAfterBind = copy_src->descriptorBindingStorageTexelBufferUpdateAfterBind;
    descriptorBindingUpdateUnusedWhilePending = copy_src->descriptorBindingUpdateUnusedWhilePending;
    descriptorBindingPartiallyBound = copy_src->descriptorBindingPartiallyBound;
    descriptorBindingVariableDescriptorCount = copy_src->descriptorBindingVariableDescriptorCount;
    runtimeDescriptorArray = copy_src->runtimeDescriptorArray;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceDescriptorIndexingProperties::safe_VkPhysicalDeviceDescriptorIndexingProperties(const VkPhysicalDeviceDescriptorIndexingProperties* in_struct) :
    sType(in_struct->sType),
    maxUpdateAfterBindDescriptorsInAllPools(in_struct->maxUpdateAfterBindDescriptorsInAllPools),
    shaderUniformBufferArrayNonUniformIndexingNative(in_struct->shaderUniformBufferArrayNonUniformIndexingNative),
    shaderSampledImageArrayNonUniformIndexingNative(in_struct->shaderSampledImageArrayNonUniformIndexingNative),
    shaderStorageBufferArrayNonUniformIndexingNative(in_struct->shaderStorageBufferArrayNonUniformIndexingNative),
    shaderStorageImageArrayNonUniformIndexingNative(in_struct->shaderStorageImageArrayNonUniformIndexingNative),
    shaderInputAttachmentArrayNonUniformIndexingNative(in_struct->shaderInputAttachmentArrayNonUniformIndexingNative),
    robustBufferAccessUpdateAfterBind(in_struct->robustBufferAccessUpdateAfterBind),
    quadDivergentImplicitLod(in_struct->quadDivergentImplicitLod),
    maxPerStageDescriptorUpdateAfterBindSamplers(in_struct->maxPerStageDescriptorUpdateAfterBindSamplers),
    maxPerStageDescriptorUpdateAfterBindUniformBuffers(in_struct->maxPerStageDescriptorUpdateAfterBindUniformBuffers),
    maxPerStageDescriptorUpdateAfterBindStorageBuffers(in_struct->maxPerStageDescriptorUpdateAfterBindStorageBuffers),
    maxPerStageDescriptorUpdateAfterBindSampledImages(in_struct->maxPerStageDescriptorUpdateAfterBindSampledImages),
    maxPerStageDescriptorUpdateAfterBindStorageImages(in_struct->maxPerStageDescriptorUpdateAfterBindStorageImages),
    maxPerStageDescriptorUpdateAfterBindInputAttachments(in_struct->maxPerStageDescriptorUpdateAfterBindInputAttachments),
    maxPerStageUpdateAfterBindResources(in_struct->maxPerStageUpdateAfterBindResources),
    maxDescriptorSetUpdateAfterBindSamplers(in_struct->maxDescriptorSetUpdateAfterBindSamplers),
    maxDescriptorSetUpdateAfterBindUniformBuffers(in_struct->maxDescriptorSetUpdateAfterBindUniformBuffers),
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic(in_struct->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic),
    maxDescriptorSetUpdateAfterBindStorageBuffers(in_struct->maxDescriptorSetUpdateAfterBindStorageBuffers),
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic(in_struct->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic),
    maxDescriptorSetUpdateAfterBindSampledImages(in_struct->maxDescriptorSetUpdateAfterBindSampledImages),
    maxDescriptorSetUpdateAfterBindStorageImages(in_struct->maxDescriptorSetUpdateAfterBindStorageImages),
    maxDescriptorSetUpdateAfterBindInputAttachments(in_struct->maxDescriptorSetUpdateAfterBindInputAttachments)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceDescriptorIndexingProperties::safe_VkPhysicalDeviceDescriptorIndexingProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceDescriptorIndexingProperties::safe_VkPhysicalDeviceDescriptorIndexingProperties(const safe_VkPhysicalDeviceDescriptorIndexingProperties& copy_src)
{
    sType = copy_src.sType;
    maxUpdateAfterBindDescriptorsInAllPools = copy_src.maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = copy_src.shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = copy_src.shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = copy_src.shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = copy_src.shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = copy_src.shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = copy_src.robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = copy_src.quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = copy_src.maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = copy_src.maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = copy_src.maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = copy_src.maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = copy_src.maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = copy_src.maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = copy_src.maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = copy_src.maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = copy_src.maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = copy_src.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = copy_src.maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = copy_src.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = copy_src.maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = copy_src.maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = copy_src.maxDescriptorSetUpdateAfterBindInputAttachments;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceDescriptorIndexingProperties& safe_VkPhysicalDeviceDescriptorIndexingProperties::operator=(const safe_VkPhysicalDeviceDescriptorIndexingProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    maxUpdateAfterBindDescriptorsInAllPools = copy_src.maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = copy_src.shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = copy_src.shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = copy_src.shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = copy_src.shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = copy_src.shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = copy_src.robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = copy_src.quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = copy_src.maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = copy_src.maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = copy_src.maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = copy_src.maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = copy_src.maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = copy_src.maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = copy_src.maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = copy_src.maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = copy_src.maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = copy_src.maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = copy_src.maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = copy_src.maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = copy_src.maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = copy_src.maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = copy_src.maxDescriptorSetUpdateAfterBindInputAttachments;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceDescriptorIndexingProperties::~safe_VkPhysicalDeviceDescriptorIndexingProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceDescriptorIndexingProperties::initialize(const VkPhysicalDeviceDescriptorIndexingProperties* in_struct)
{
    sType = in_struct->sType;
    maxUpdateAfterBindDescriptorsInAllPools = in_struct->maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = in_struct->shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = in_struct->shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = in_struct->shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = in_struct->shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = in_struct->shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = in_struct->robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = in_struct->quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = in_struct->maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = in_struct->maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = in_struct->maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = in_struct->maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = in_struct->maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = in_struct->maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = in_struct->maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = in_struct->maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = in_struct->maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = in_struct->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = in_struct->maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = in_struct->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = in_struct->maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = in_struct->maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = in_struct->maxDescriptorSetUpdateAfterBindInputAttachments;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceDescriptorIndexingProperties::initialize(const safe_VkPhysicalDeviceDescriptorIndexingProperties* copy_src)
{
    sType = copy_src->sType;
    maxUpdateAfterBindDescriptorsInAllPools = copy_src->maxUpdateAfterBindDescriptorsInAllPools;
    shaderUniformBufferArrayNonUniformIndexingNative = copy_src->shaderUniformBufferArrayNonUniformIndexingNative;
    shaderSampledImageArrayNonUniformIndexingNative = copy_src->shaderSampledImageArrayNonUniformIndexingNative;
    shaderStorageBufferArrayNonUniformIndexingNative = copy_src->shaderStorageBufferArrayNonUniformIndexingNative;
    shaderStorageImageArrayNonUniformIndexingNative = copy_src->shaderStorageImageArrayNonUniformIndexingNative;
    shaderInputAttachmentArrayNonUniformIndexingNative = copy_src->shaderInputAttachmentArrayNonUniformIndexingNative;
    robustBufferAccessUpdateAfterBind = copy_src->robustBufferAccessUpdateAfterBind;
    quadDivergentImplicitLod = copy_src->quadDivergentImplicitLod;
    maxPerStageDescriptorUpdateAfterBindSamplers = copy_src->maxPerStageDescriptorUpdateAfterBindSamplers;
    maxPerStageDescriptorUpdateAfterBindUniformBuffers = copy_src->maxPerStageDescriptorUpdateAfterBindUniformBuffers;
    maxPerStageDescriptorUpdateAfterBindStorageBuffers = copy_src->maxPerStageDescriptorUpdateAfterBindStorageBuffers;
    maxPerStageDescriptorUpdateAfterBindSampledImages = copy_src->maxPerStageDescriptorUpdateAfterBindSampledImages;
    maxPerStageDescriptorUpdateAfterBindStorageImages = copy_src->maxPerStageDescriptorUpdateAfterBindStorageImages;
    maxPerStageDescriptorUpdateAfterBindInputAttachments = copy_src->maxPerStageDescriptorUpdateAfterBindInputAttachments;
    maxPerStageUpdateAfterBindResources = copy_src->maxPerStageUpdateAfterBindResources;
    maxDescriptorSetUpdateAfterBindSamplers = copy_src->maxDescriptorSetUpdateAfterBindSamplers;
    maxDescriptorSetUpdateAfterBindUniformBuffers = copy_src->maxDescriptorSetUpdateAfterBindUniformBuffers;
    maxDescriptorSetUpdateAfterBindUniformBuffersDynamic = copy_src->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic;
    maxDescriptorSetUpdateAfterBindStorageBuffers = copy_src->maxDescriptorSetUpdateAfterBindStorageBuffers;
    maxDescriptorSetUpdateAfterBindStorageBuffersDynamic = copy_src->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic;
    maxDescriptorSetUpdateAfterBindSampledImages = copy_src->maxDescriptorSetUpdateAfterBindSampledImages;
    maxDescriptorSetUpdateAfterBindStorageImages = copy_src->maxDescriptorSetUpdateAfterBindStorageImages;
    maxDescriptorSetUpdateAfterBindInputAttachments = copy_src->maxDescriptorSetUpdateAfterBindInputAttachments;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDescriptorSetVariableDescriptorCountAllocateInfo::safe_VkDescriptorSetVariableDescriptorCountAllocateInfo(const VkDescriptorSetVariableDescriptorCountAllocateInfo* in_struct) :
    sType(in_struct->sType),
    descriptorSetCount(in_struct->descriptorSetCount),
    pDescriptorCounts(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDescriptorCounts) {
        pDescriptorCounts = new uint32_t[in_struct->descriptorSetCount];
        memcpy ((void *)pDescriptorCounts, (void *)in_struct->pDescriptorCounts, sizeof(uint32_t)*in_struct->descriptorSetCount);
    }
}

safe_VkDescriptorSetVariableDescriptorCountAllocateInfo::safe_VkDescriptorSetVariableDescriptorCountAllocateInfo() :
    sType(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO),
    pNext(nullptr),
    pDescriptorCounts(nullptr)
{}

safe_VkDescriptorSetVariableDescriptorCountAllocateInfo::safe_VkDescriptorSetVariableDescriptorCountAllocateInfo(const safe_VkDescriptorSetVariableDescriptorCountAllocateInfo& copy_src)
{
    sType = copy_src.sType;
    descriptorSetCount = copy_src.descriptorSetCount;
    pDescriptorCounts = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDescriptorCounts) {
        pDescriptorCounts = new uint32_t[copy_src.descriptorSetCount];
        memcpy ((void *)pDescriptorCounts, (void *)copy_src.pDescriptorCounts, sizeof(uint32_t)*copy_src.descriptorSetCount);
    }
}

safe_VkDescriptorSetVariableDescriptorCountAllocateInfo& safe_VkDescriptorSetVariableDescriptorCountAllocateInfo::operator=(const safe_VkDescriptorSetVariableDescriptorCountAllocateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pDescriptorCounts)
        delete[] pDescriptorCounts;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    descriptorSetCount = copy_src.descriptorSetCount;
    pDescriptorCounts = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDescriptorCounts) {
        pDescriptorCounts = new uint32_t[copy_src.descriptorSetCount];
        memcpy ((void *)pDescriptorCounts, (void *)copy_src.pDescriptorCounts, sizeof(uint32_t)*copy_src.descriptorSetCount);
    }

    return *this;
}

safe_VkDescriptorSetVariableDescriptorCountAllocateInfo::~safe_VkDescriptorSetVariableDescriptorCountAllocateInfo()
{
    if (pDescriptorCounts)
        delete[] pDescriptorCounts;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetVariableDescriptorCountAllocateInfo::initialize(const VkDescriptorSetVariableDescriptorCountAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    descriptorSetCount = in_struct->descriptorSetCount;
    pDescriptorCounts = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDescriptorCounts) {
        pDescriptorCounts = new uint32_t[in_struct->descriptorSetCount];
        memcpy ((void *)pDescriptorCounts, (void *)in_struct->pDescriptorCounts, sizeof(uint32_t)*in_struct->descriptorSetCount);
    }
}

void safe_VkDescriptorSetVariableDescriptorCountAllocateInfo::initialize(const safe_VkDescriptorSetVariableDescriptorCountAllocateInfo* copy_src)
{
    sType = copy_src->sType;
    descriptorSetCount = copy_src->descriptorSetCount;
    pDescriptorCounts = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pDescriptorCounts) {
        pDescriptorCounts = new uint32_t[copy_src->descriptorSetCount];
        memcpy ((void *)pDescriptorCounts, (void *)copy_src->pDescriptorCounts, sizeof(uint32_t)*copy_src->descriptorSetCount);
    }
}

safe_VkDescriptorSetVariableDescriptorCountLayoutSupport::safe_VkDescriptorSetVariableDescriptorCountLayoutSupport(const VkDescriptorSetVariableDescriptorCountLayoutSupport* in_struct) :
    sType(in_struct->sType),
    maxVariableDescriptorCount(in_struct->maxVariableDescriptorCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDescriptorSetVariableDescriptorCountLayoutSupport::safe_VkDescriptorSetVariableDescriptorCountLayoutSupport() :
    sType(VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT),
    pNext(nullptr)
{}

safe_VkDescriptorSetVariableDescriptorCountLayoutSupport::safe_VkDescriptorSetVariableDescriptorCountLayoutSupport(const safe_VkDescriptorSetVariableDescriptorCountLayoutSupport& copy_src)
{
    sType = copy_src.sType;
    maxVariableDescriptorCount = copy_src.maxVariableDescriptorCount;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDescriptorSetVariableDescriptorCountLayoutSupport& safe_VkDescriptorSetVariableDescriptorCountLayoutSupport::operator=(const safe_VkDescriptorSetVariableDescriptorCountLayoutSupport& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    maxVariableDescriptorCount = copy_src.maxVariableDescriptorCount;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDescriptorSetVariableDescriptorCountLayoutSupport::~safe_VkDescriptorSetVariableDescriptorCountLayoutSupport()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDescriptorSetVariableDescriptorCountLayoutSupport::initialize(const VkDescriptorSetVariableDescriptorCountLayoutSupport* in_struct)
{
    sType = in_struct->sType;
    maxVariableDescriptorCount = in_struct->maxVariableDescriptorCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDescriptorSetVariableDescriptorCountLayoutSupport::initialize(const safe_VkDescriptorSetVariableDescriptorCountLayoutSupport* copy_src)
{
    sType = copy_src->sType;
    maxVariableDescriptorCount = copy_src->maxVariableDescriptorCount;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSubpassDescriptionDepthStencilResolve::safe_VkSubpassDescriptionDepthStencilResolve(const VkSubpassDescriptionDepthStencilResolve* in_struct) :
    sType(in_struct->sType),
    depthResolveMode(in_struct->depthResolveMode),
    stencilResolveMode(in_struct->stencilResolveMode),
    pDepthStencilResolveAttachment(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDepthStencilResolveAttachment)
        pDepthStencilResolveAttachment = new safe_VkAttachmentReference2(in_struct->pDepthStencilResolveAttachment);
}

safe_VkSubpassDescriptionDepthStencilResolve::safe_VkSubpassDescriptionDepthStencilResolve() :
    sType(VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE),
    pNext(nullptr),
    pDepthStencilResolveAttachment(nullptr)
{}

safe_VkSubpassDescriptionDepthStencilResolve::safe_VkSubpassDescriptionDepthStencilResolve(const safe_VkSubpassDescriptionDepthStencilResolve& copy_src)
{
    sType = copy_src.sType;
    depthResolveMode = copy_src.depthResolveMode;
    stencilResolveMode = copy_src.stencilResolveMode;
    pDepthStencilResolveAttachment = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDepthStencilResolveAttachment)
        pDepthStencilResolveAttachment = new safe_VkAttachmentReference2(*copy_src.pDepthStencilResolveAttachment);
}

safe_VkSubpassDescriptionDepthStencilResolve& safe_VkSubpassDescriptionDepthStencilResolve::operator=(const safe_VkSubpassDescriptionDepthStencilResolve& copy_src)
{
    if (&copy_src == this) return *this;

    if (pDepthStencilResolveAttachment)
        delete pDepthStencilResolveAttachment;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    depthResolveMode = copy_src.depthResolveMode;
    stencilResolveMode = copy_src.stencilResolveMode;
    pDepthStencilResolveAttachment = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDepthStencilResolveAttachment)
        pDepthStencilResolveAttachment = new safe_VkAttachmentReference2(*copy_src.pDepthStencilResolveAttachment);

    return *this;
}

safe_VkSubpassDescriptionDepthStencilResolve::~safe_VkSubpassDescriptionDepthStencilResolve()
{
    if (pDepthStencilResolveAttachment)
        delete pDepthStencilResolveAttachment;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubpassDescriptionDepthStencilResolve::initialize(const VkSubpassDescriptionDepthStencilResolve* in_struct)
{
    sType = in_struct->sType;
    depthResolveMode = in_struct->depthResolveMode;
    stencilResolveMode = in_struct->stencilResolveMode;
    pDepthStencilResolveAttachment = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDepthStencilResolveAttachment)
        pDepthStencilResolveAttachment = new safe_VkAttachmentReference2(in_struct->pDepthStencilResolveAttachment);
}

void safe_VkSubpassDescriptionDepthStencilResolve::initialize(const safe_VkSubpassDescriptionDepthStencilResolve* copy_src)
{
    sType = copy_src->sType;
    depthResolveMode = copy_src->depthResolveMode;
    stencilResolveMode = copy_src->stencilResolveMode;
    pDepthStencilResolveAttachment = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pDepthStencilResolveAttachment)
        pDepthStencilResolveAttachment = new safe_VkAttachmentReference2(*copy_src->pDepthStencilResolveAttachment);
}

safe_VkPhysicalDeviceDepthStencilResolveProperties::safe_VkPhysicalDeviceDepthStencilResolveProperties(const VkPhysicalDeviceDepthStencilResolveProperties* in_struct) :
    sType(in_struct->sType),
    supportedDepthResolveModes(in_struct->supportedDepthResolveModes),
    supportedStencilResolveModes(in_struct->supportedStencilResolveModes),
    independentResolveNone(in_struct->independentResolveNone),
    independentResolve(in_struct->independentResolve)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceDepthStencilResolveProperties::safe_VkPhysicalDeviceDepthStencilResolveProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceDepthStencilResolveProperties::safe_VkPhysicalDeviceDepthStencilResolveProperties(const safe_VkPhysicalDeviceDepthStencilResolveProperties& copy_src)
{
    sType = copy_src.sType;
    supportedDepthResolveModes = copy_src.supportedDepthResolveModes;
    supportedStencilResolveModes = copy_src.supportedStencilResolveModes;
    independentResolveNone = copy_src.independentResolveNone;
    independentResolve = copy_src.independentResolve;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceDepthStencilResolveProperties& safe_VkPhysicalDeviceDepthStencilResolveProperties::operator=(const safe_VkPhysicalDeviceDepthStencilResolveProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    supportedDepthResolveModes = copy_src.supportedDepthResolveModes;
    supportedStencilResolveModes = copy_src.supportedStencilResolveModes;
    independentResolveNone = copy_src.independentResolveNone;
    independentResolve = copy_src.independentResolve;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceDepthStencilResolveProperties::~safe_VkPhysicalDeviceDepthStencilResolveProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceDepthStencilResolveProperties::initialize(const VkPhysicalDeviceDepthStencilResolveProperties* in_struct)
{
    sType = in_struct->sType;
    supportedDepthResolveModes = in_struct->supportedDepthResolveModes;
    supportedStencilResolveModes = in_struct->supportedStencilResolveModes;
    independentResolveNone = in_struct->independentResolveNone;
    independentResolve = in_struct->independentResolve;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceDepthStencilResolveProperties::initialize(const safe_VkPhysicalDeviceDepthStencilResolveProperties* copy_src)
{
    sType = copy_src->sType;
    supportedDepthResolveModes = copy_src->supportedDepthResolveModes;
    supportedStencilResolveModes = copy_src->supportedStencilResolveModes;
    independentResolveNone = copy_src->independentResolveNone;
    independentResolve = copy_src->independentResolve;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceScalarBlockLayoutFeatures::safe_VkPhysicalDeviceScalarBlockLayoutFeatures(const VkPhysicalDeviceScalarBlockLayoutFeatures* in_struct) :
    sType(in_struct->sType),
    scalarBlockLayout(in_struct->scalarBlockLayout)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceScalarBlockLayoutFeatures::safe_VkPhysicalDeviceScalarBlockLayoutFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceScalarBlockLayoutFeatures::safe_VkPhysicalDeviceScalarBlockLayoutFeatures(const safe_VkPhysicalDeviceScalarBlockLayoutFeatures& copy_src)
{
    sType = copy_src.sType;
    scalarBlockLayout = copy_src.scalarBlockLayout;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceScalarBlockLayoutFeatures& safe_VkPhysicalDeviceScalarBlockLayoutFeatures::operator=(const safe_VkPhysicalDeviceScalarBlockLayoutFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    scalarBlockLayout = copy_src.scalarBlockLayout;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceScalarBlockLayoutFeatures::~safe_VkPhysicalDeviceScalarBlockLayoutFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceScalarBlockLayoutFeatures::initialize(const VkPhysicalDeviceScalarBlockLayoutFeatures* in_struct)
{
    sType = in_struct->sType;
    scalarBlockLayout = in_struct->scalarBlockLayout;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceScalarBlockLayoutFeatures::initialize(const safe_VkPhysicalDeviceScalarBlockLayoutFeatures* copy_src)
{
    sType = copy_src->sType;
    scalarBlockLayout = copy_src->scalarBlockLayout;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkImageStencilUsageCreateInfo::safe_VkImageStencilUsageCreateInfo(const VkImageStencilUsageCreateInfo* in_struct) :
    sType(in_struct->sType),
    stencilUsage(in_struct->stencilUsage)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageStencilUsageCreateInfo::safe_VkImageStencilUsageCreateInfo() :
    sType(VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkImageStencilUsageCreateInfo::safe_VkImageStencilUsageCreateInfo(const safe_VkImageStencilUsageCreateInfo& copy_src)
{
    sType = copy_src.sType;
    stencilUsage = copy_src.stencilUsage;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageStencilUsageCreateInfo& safe_VkImageStencilUsageCreateInfo::operator=(const safe_VkImageStencilUsageCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    stencilUsage = copy_src.stencilUsage;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageStencilUsageCreateInfo::~safe_VkImageStencilUsageCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageStencilUsageCreateInfo::initialize(const VkImageStencilUsageCreateInfo* in_struct)
{
    sType = in_struct->sType;
    stencilUsage = in_struct->stencilUsage;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageStencilUsageCreateInfo::initialize(const safe_VkImageStencilUsageCreateInfo* copy_src)
{
    sType = copy_src->sType;
    stencilUsage = copy_src->stencilUsage;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSamplerReductionModeCreateInfo::safe_VkSamplerReductionModeCreateInfo(const VkSamplerReductionModeCreateInfo* in_struct) :
    sType(in_struct->sType),
    reductionMode(in_struct->reductionMode)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSamplerReductionModeCreateInfo::safe_VkSamplerReductionModeCreateInfo() :
    sType(VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkSamplerReductionModeCreateInfo::safe_VkSamplerReductionModeCreateInfo(const safe_VkSamplerReductionModeCreateInfo& copy_src)
{
    sType = copy_src.sType;
    reductionMode = copy_src.reductionMode;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSamplerReductionModeCreateInfo& safe_VkSamplerReductionModeCreateInfo::operator=(const safe_VkSamplerReductionModeCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    reductionMode = copy_src.reductionMode;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSamplerReductionModeCreateInfo::~safe_VkSamplerReductionModeCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSamplerReductionModeCreateInfo::initialize(const VkSamplerReductionModeCreateInfo* in_struct)
{
    sType = in_struct->sType;
    reductionMode = in_struct->reductionMode;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSamplerReductionModeCreateInfo::initialize(const safe_VkSamplerReductionModeCreateInfo* copy_src)
{
    sType = copy_src->sType;
    reductionMode = copy_src->reductionMode;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceSamplerFilterMinmaxProperties::safe_VkPhysicalDeviceSamplerFilterMinmaxProperties(const VkPhysicalDeviceSamplerFilterMinmaxProperties* in_struct) :
    sType(in_struct->sType),
    filterMinmaxSingleComponentFormats(in_struct->filterMinmaxSingleComponentFormats),
    filterMinmaxImageComponentMapping(in_struct->filterMinmaxImageComponentMapping)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSamplerFilterMinmaxProperties::safe_VkPhysicalDeviceSamplerFilterMinmaxProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSamplerFilterMinmaxProperties::safe_VkPhysicalDeviceSamplerFilterMinmaxProperties(const safe_VkPhysicalDeviceSamplerFilterMinmaxProperties& copy_src)
{
    sType = copy_src.sType;
    filterMinmaxSingleComponentFormats = copy_src.filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = copy_src.filterMinmaxImageComponentMapping;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceSamplerFilterMinmaxProperties& safe_VkPhysicalDeviceSamplerFilterMinmaxProperties::operator=(const safe_VkPhysicalDeviceSamplerFilterMinmaxProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    filterMinmaxSingleComponentFormats = copy_src.filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = copy_src.filterMinmaxImageComponentMapping;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSamplerFilterMinmaxProperties::~safe_VkPhysicalDeviceSamplerFilterMinmaxProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSamplerFilterMinmaxProperties::initialize(const VkPhysicalDeviceSamplerFilterMinmaxProperties* in_struct)
{
    sType = in_struct->sType;
    filterMinmaxSingleComponentFormats = in_struct->filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = in_struct->filterMinmaxImageComponentMapping;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSamplerFilterMinmaxProperties::initialize(const safe_VkPhysicalDeviceSamplerFilterMinmaxProperties* copy_src)
{
    sType = copy_src->sType;
    filterMinmaxSingleComponentFormats = copy_src->filterMinmaxSingleComponentFormats;
    filterMinmaxImageComponentMapping = copy_src->filterMinmaxImageComponentMapping;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceVulkanMemoryModelFeatures::safe_VkPhysicalDeviceVulkanMemoryModelFeatures(const VkPhysicalDeviceVulkanMemoryModelFeatures* in_struct) :
    sType(in_struct->sType),
    vulkanMemoryModel(in_struct->vulkanMemoryModel),
    vulkanMemoryModelDeviceScope(in_struct->vulkanMemoryModelDeviceScope),
    vulkanMemoryModelAvailabilityVisibilityChains(in_struct->vulkanMemoryModelAvailabilityVisibilityChains)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceVulkanMemoryModelFeatures::safe_VkPhysicalDeviceVulkanMemoryModelFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceVulkanMemoryModelFeatures::safe_VkPhysicalDeviceVulkanMemoryModelFeatures(const safe_VkPhysicalDeviceVulkanMemoryModelFeatures& copy_src)
{
    sType = copy_src.sType;
    vulkanMemoryModel = copy_src.vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = copy_src.vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = copy_src.vulkanMemoryModelAvailabilityVisibilityChains;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceVulkanMemoryModelFeatures& safe_VkPhysicalDeviceVulkanMemoryModelFeatures::operator=(const safe_VkPhysicalDeviceVulkanMemoryModelFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    vulkanMemoryModel = copy_src.vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = copy_src.vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = copy_src.vulkanMemoryModelAvailabilityVisibilityChains;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceVulkanMemoryModelFeatures::~safe_VkPhysicalDeviceVulkanMemoryModelFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceVulkanMemoryModelFeatures::initialize(const VkPhysicalDeviceVulkanMemoryModelFeatures* in_struct)
{
    sType = in_struct->sType;
    vulkanMemoryModel = in_struct->vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = in_struct->vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = in_struct->vulkanMemoryModelAvailabilityVisibilityChains;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceVulkanMemoryModelFeatures::initialize(const safe_VkPhysicalDeviceVulkanMemoryModelFeatures* copy_src)
{
    sType = copy_src->sType;
    vulkanMemoryModel = copy_src->vulkanMemoryModel;
    vulkanMemoryModelDeviceScope = copy_src->vulkanMemoryModelDeviceScope;
    vulkanMemoryModelAvailabilityVisibilityChains = copy_src->vulkanMemoryModelAvailabilityVisibilityChains;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceImagelessFramebufferFeatures::safe_VkPhysicalDeviceImagelessFramebufferFeatures(const VkPhysicalDeviceImagelessFramebufferFeatures* in_struct) :
    sType(in_struct->sType),
    imagelessFramebuffer(in_struct->imagelessFramebuffer)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceImagelessFramebufferFeatures::safe_VkPhysicalDeviceImagelessFramebufferFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceImagelessFramebufferFeatures::safe_VkPhysicalDeviceImagelessFramebufferFeatures(const safe_VkPhysicalDeviceImagelessFramebufferFeatures& copy_src)
{
    sType = copy_src.sType;
    imagelessFramebuffer = copy_src.imagelessFramebuffer;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceImagelessFramebufferFeatures& safe_VkPhysicalDeviceImagelessFramebufferFeatures::operator=(const safe_VkPhysicalDeviceImagelessFramebufferFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    imagelessFramebuffer = copy_src.imagelessFramebuffer;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceImagelessFramebufferFeatures::~safe_VkPhysicalDeviceImagelessFramebufferFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceImagelessFramebufferFeatures::initialize(const VkPhysicalDeviceImagelessFramebufferFeatures* in_struct)
{
    sType = in_struct->sType;
    imagelessFramebuffer = in_struct->imagelessFramebuffer;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceImagelessFramebufferFeatures::initialize(const safe_VkPhysicalDeviceImagelessFramebufferFeatures* copy_src)
{
    sType = copy_src->sType;
    imagelessFramebuffer = copy_src->imagelessFramebuffer;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkFramebufferAttachmentImageInfo::safe_VkFramebufferAttachmentImageInfo(const VkFramebufferAttachmentImageInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    usage(in_struct->usage),
    width(in_struct->width),
    height(in_struct->height),
    layerCount(in_struct->layerCount),
    viewFormatCount(in_struct->viewFormatCount),
    pViewFormats(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewFormats) {
        pViewFormats = new VkFormat[in_struct->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)in_struct->pViewFormats, sizeof(VkFormat)*in_struct->viewFormatCount);
    }
}

safe_VkFramebufferAttachmentImageInfo::safe_VkFramebufferAttachmentImageInfo() :
    sType(VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO),
    pNext(nullptr),
    pViewFormats(nullptr)
{}

safe_VkFramebufferAttachmentImageInfo::safe_VkFramebufferAttachmentImageInfo(const safe_VkFramebufferAttachmentImageInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    usage = copy_src.usage;
    width = copy_src.width;
    height = copy_src.height;
    layerCount = copy_src.layerCount;
    viewFormatCount = copy_src.viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pViewFormats) {
        pViewFormats = new VkFormat[copy_src.viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)copy_src.pViewFormats, sizeof(VkFormat)*copy_src.viewFormatCount);
    }
}

safe_VkFramebufferAttachmentImageInfo& safe_VkFramebufferAttachmentImageInfo::operator=(const safe_VkFramebufferAttachmentImageInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pViewFormats)
        delete[] pViewFormats;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    usage = copy_src.usage;
    width = copy_src.width;
    height = copy_src.height;
    layerCount = copy_src.layerCount;
    viewFormatCount = copy_src.viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pViewFormats) {
        pViewFormats = new VkFormat[copy_src.viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)copy_src.pViewFormats, sizeof(VkFormat)*copy_src.viewFormatCount);
    }

    return *this;
}

safe_VkFramebufferAttachmentImageInfo::~safe_VkFramebufferAttachmentImageInfo()
{
    if (pViewFormats)
        delete[] pViewFormats;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFramebufferAttachmentImageInfo::initialize(const VkFramebufferAttachmentImageInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    usage = in_struct->usage;
    width = in_struct->width;
    height = in_struct->height;
    layerCount = in_struct->layerCount;
    viewFormatCount = in_struct->viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pViewFormats) {
        pViewFormats = new VkFormat[in_struct->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)in_struct->pViewFormats, sizeof(VkFormat)*in_struct->viewFormatCount);
    }
}

void safe_VkFramebufferAttachmentImageInfo::initialize(const safe_VkFramebufferAttachmentImageInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    usage = copy_src->usage;
    width = copy_src->width;
    height = copy_src->height;
    layerCount = copy_src->layerCount;
    viewFormatCount = copy_src->viewFormatCount;
    pViewFormats = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pViewFormats) {
        pViewFormats = new VkFormat[copy_src->viewFormatCount];
        memcpy ((void *)pViewFormats, (void *)copy_src->pViewFormats, sizeof(VkFormat)*copy_src->viewFormatCount);
    }
}

safe_VkFramebufferAttachmentsCreateInfo::safe_VkFramebufferAttachmentsCreateInfo(const VkFramebufferAttachmentsCreateInfo* in_struct) :
    sType(in_struct->sType),
    attachmentImageInfoCount(in_struct->attachmentImageInfoCount),
    pAttachmentImageInfos(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentImageInfoCount && in_struct->pAttachmentImageInfos) {
        pAttachmentImageInfos = new safe_VkFramebufferAttachmentImageInfo[attachmentImageInfoCount];
        for (uint32_t i = 0; i < attachmentImageInfoCount; ++i) {
            pAttachmentImageInfos[i].initialize(&in_struct->pAttachmentImageInfos[i]);
        }
    }
}

safe_VkFramebufferAttachmentsCreateInfo::safe_VkFramebufferAttachmentsCreateInfo() :
    sType(VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO),
    pNext(nullptr),
    pAttachmentImageInfos(nullptr)
{}

safe_VkFramebufferAttachmentsCreateInfo::safe_VkFramebufferAttachmentsCreateInfo(const safe_VkFramebufferAttachmentsCreateInfo& copy_src)
{
    sType = copy_src.sType;
    attachmentImageInfoCount = copy_src.attachmentImageInfoCount;
    pAttachmentImageInfos = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (attachmentImageInfoCount && copy_src.pAttachmentImageInfos) {
        pAttachmentImageInfos = new safe_VkFramebufferAttachmentImageInfo[attachmentImageInfoCount];
        for (uint32_t i = 0; i < attachmentImageInfoCount; ++i) {
            pAttachmentImageInfos[i].initialize(&copy_src.pAttachmentImageInfos[i]);
        }
    }
}

safe_VkFramebufferAttachmentsCreateInfo& safe_VkFramebufferAttachmentsCreateInfo::operator=(const safe_VkFramebufferAttachmentsCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pAttachmentImageInfos)
        delete[] pAttachmentImageInfos;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    attachmentImageInfoCount = copy_src.attachmentImageInfoCount;
    pAttachmentImageInfos = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (attachmentImageInfoCount && copy_src.pAttachmentImageInfos) {
        pAttachmentImageInfos = new safe_VkFramebufferAttachmentImageInfo[attachmentImageInfoCount];
        for (uint32_t i = 0; i < attachmentImageInfoCount; ++i) {
            pAttachmentImageInfos[i].initialize(&copy_src.pAttachmentImageInfos[i]);
        }
    }

    return *this;
}

safe_VkFramebufferAttachmentsCreateInfo::~safe_VkFramebufferAttachmentsCreateInfo()
{
    if (pAttachmentImageInfos)
        delete[] pAttachmentImageInfos;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFramebufferAttachmentsCreateInfo::initialize(const VkFramebufferAttachmentsCreateInfo* in_struct)
{
    sType = in_struct->sType;
    attachmentImageInfoCount = in_struct->attachmentImageInfoCount;
    pAttachmentImageInfos = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentImageInfoCount && in_struct->pAttachmentImageInfos) {
        pAttachmentImageInfos = new safe_VkFramebufferAttachmentImageInfo[attachmentImageInfoCount];
        for (uint32_t i = 0; i < attachmentImageInfoCount; ++i) {
            pAttachmentImageInfos[i].initialize(&in_struct->pAttachmentImageInfos[i]);
        }
    }
}

void safe_VkFramebufferAttachmentsCreateInfo::initialize(const safe_VkFramebufferAttachmentsCreateInfo* copy_src)
{
    sType = copy_src->sType;
    attachmentImageInfoCount = copy_src->attachmentImageInfoCount;
    pAttachmentImageInfos = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (attachmentImageInfoCount && copy_src->pAttachmentImageInfos) {
        pAttachmentImageInfos = new safe_VkFramebufferAttachmentImageInfo[attachmentImageInfoCount];
        for (uint32_t i = 0; i < attachmentImageInfoCount; ++i) {
            pAttachmentImageInfos[i].initialize(&copy_src->pAttachmentImageInfos[i]);
        }
    }
}

safe_VkRenderPassAttachmentBeginInfo::safe_VkRenderPassAttachmentBeginInfo(const VkRenderPassAttachmentBeginInfo* in_struct) :
    sType(in_struct->sType),
    attachmentCount(in_struct->attachmentCount),
    pAttachments(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = in_struct->pAttachments[i];
        }
    }
}

safe_VkRenderPassAttachmentBeginInfo::safe_VkRenderPassAttachmentBeginInfo() :
    sType(VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO),
    pNext(nullptr),
    pAttachments(nullptr)
{}

safe_VkRenderPassAttachmentBeginInfo::safe_VkRenderPassAttachmentBeginInfo(const safe_VkRenderPassAttachmentBeginInfo& copy_src)
{
    sType = copy_src.sType;
    attachmentCount = copy_src.attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (attachmentCount && copy_src.pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = copy_src.pAttachments[i];
        }
    }
}

safe_VkRenderPassAttachmentBeginInfo& safe_VkRenderPassAttachmentBeginInfo::operator=(const safe_VkRenderPassAttachmentBeginInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    attachmentCount = copy_src.attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (attachmentCount && copy_src.pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = copy_src.pAttachments[i];
        }
    }

    return *this;
}

safe_VkRenderPassAttachmentBeginInfo::~safe_VkRenderPassAttachmentBeginInfo()
{
    if (pAttachments)
        delete[] pAttachments;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkRenderPassAttachmentBeginInfo::initialize(const VkRenderPassAttachmentBeginInfo* in_struct)
{
    sType = in_struct->sType;
    attachmentCount = in_struct->attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (attachmentCount && in_struct->pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = in_struct->pAttachments[i];
        }
    }
}

void safe_VkRenderPassAttachmentBeginInfo::initialize(const safe_VkRenderPassAttachmentBeginInfo* copy_src)
{
    sType = copy_src->sType;
    attachmentCount = copy_src->attachmentCount;
    pAttachments = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (attachmentCount && copy_src->pAttachments) {
        pAttachments = new VkImageView[attachmentCount];
        for (uint32_t i = 0; i < attachmentCount; ++i) {
            pAttachments[i] = copy_src->pAttachments[i];
        }
    }
}

safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures::safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* in_struct) :
    sType(in_struct->sType),
    uniformBufferStandardLayout(in_struct->uniformBufferStandardLayout)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures::safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures::safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(const safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures& copy_src)
{
    sType = copy_src.sType;
    uniformBufferStandardLayout = copy_src.uniformBufferStandardLayout;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures& safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures::operator=(const safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    uniformBufferStandardLayout = copy_src.uniformBufferStandardLayout;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures::~safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures::initialize(const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* in_struct)
{
    sType = in_struct->sType;
    uniformBufferStandardLayout = in_struct->uniformBufferStandardLayout;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures::initialize(const safe_VkPhysicalDeviceUniformBufferStandardLayoutFeatures* copy_src)
{
    sType = copy_src->sType;
    uniformBufferStandardLayout = copy_src->uniformBufferStandardLayout;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures::safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* in_struct) :
    sType(in_struct->sType),
    shaderSubgroupExtendedTypes(in_struct->shaderSubgroupExtendedTypes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures::safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures::safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(const safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures& copy_src)
{
    sType = copy_src.sType;
    shaderSubgroupExtendedTypes = copy_src.shaderSubgroupExtendedTypes;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures& safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures::operator=(const safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    shaderSubgroupExtendedTypes = copy_src.shaderSubgroupExtendedTypes;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures::~safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures::initialize(const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* in_struct)
{
    sType = in_struct->sType;
    shaderSubgroupExtendedTypes = in_struct->shaderSubgroupExtendedTypes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures::initialize(const safe_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* copy_src)
{
    sType = copy_src->sType;
    shaderSubgroupExtendedTypes = copy_src->shaderSubgroupExtendedTypes;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures::safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* in_struct) :
    sType(in_struct->sType),
    separateDepthStencilLayouts(in_struct->separateDepthStencilLayouts)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures::safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures::safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(const safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures& copy_src)
{
    sType = copy_src.sType;
    separateDepthStencilLayouts = copy_src.separateDepthStencilLayouts;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures& safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures::operator=(const safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    separateDepthStencilLayouts = copy_src.separateDepthStencilLayouts;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures::~safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures::initialize(const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* in_struct)
{
    sType = in_struct->sType;
    separateDepthStencilLayouts = in_struct->separateDepthStencilLayouts;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures::initialize(const safe_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* copy_src)
{
    sType = copy_src->sType;
    separateDepthStencilLayouts = copy_src->separateDepthStencilLayouts;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkAttachmentReferenceStencilLayout::safe_VkAttachmentReferenceStencilLayout(const VkAttachmentReferenceStencilLayout* in_struct) :
    sType(in_struct->sType),
    stencilLayout(in_struct->stencilLayout)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAttachmentReferenceStencilLayout::safe_VkAttachmentReferenceStencilLayout() :
    sType(VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT),
    pNext(nullptr)
{}

safe_VkAttachmentReferenceStencilLayout::safe_VkAttachmentReferenceStencilLayout(const safe_VkAttachmentReferenceStencilLayout& copy_src)
{
    sType = copy_src.sType;
    stencilLayout = copy_src.stencilLayout;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkAttachmentReferenceStencilLayout& safe_VkAttachmentReferenceStencilLayout::operator=(const safe_VkAttachmentReferenceStencilLayout& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    stencilLayout = copy_src.stencilLayout;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkAttachmentReferenceStencilLayout::~safe_VkAttachmentReferenceStencilLayout()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAttachmentReferenceStencilLayout::initialize(const VkAttachmentReferenceStencilLayout* in_struct)
{
    sType = in_struct->sType;
    stencilLayout = in_struct->stencilLayout;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAttachmentReferenceStencilLayout::initialize(const safe_VkAttachmentReferenceStencilLayout* copy_src)
{
    sType = copy_src->sType;
    stencilLayout = copy_src->stencilLayout;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkAttachmentDescriptionStencilLayout::safe_VkAttachmentDescriptionStencilLayout(const VkAttachmentDescriptionStencilLayout* in_struct) :
    sType(in_struct->sType),
    stencilInitialLayout(in_struct->stencilInitialLayout),
    stencilFinalLayout(in_struct->stencilFinalLayout)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAttachmentDescriptionStencilLayout::safe_VkAttachmentDescriptionStencilLayout() :
    sType(VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT),
    pNext(nullptr)
{}

safe_VkAttachmentDescriptionStencilLayout::safe_VkAttachmentDescriptionStencilLayout(const safe_VkAttachmentDescriptionStencilLayout& copy_src)
{
    sType = copy_src.sType;
    stencilInitialLayout = copy_src.stencilInitialLayout;
    stencilFinalLayout = copy_src.stencilFinalLayout;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkAttachmentDescriptionStencilLayout& safe_VkAttachmentDescriptionStencilLayout::operator=(const safe_VkAttachmentDescriptionStencilLayout& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    stencilInitialLayout = copy_src.stencilInitialLayout;
    stencilFinalLayout = copy_src.stencilFinalLayout;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkAttachmentDescriptionStencilLayout::~safe_VkAttachmentDescriptionStencilLayout()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAttachmentDescriptionStencilLayout::initialize(const VkAttachmentDescriptionStencilLayout* in_struct)
{
    sType = in_struct->sType;
    stencilInitialLayout = in_struct->stencilInitialLayout;
    stencilFinalLayout = in_struct->stencilFinalLayout;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAttachmentDescriptionStencilLayout::initialize(const safe_VkAttachmentDescriptionStencilLayout* copy_src)
{
    sType = copy_src->sType;
    stencilInitialLayout = copy_src->stencilInitialLayout;
    stencilFinalLayout = copy_src->stencilFinalLayout;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceHostQueryResetFeatures::safe_VkPhysicalDeviceHostQueryResetFeatures(const VkPhysicalDeviceHostQueryResetFeatures* in_struct) :
    sType(in_struct->sType),
    hostQueryReset(in_struct->hostQueryReset)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceHostQueryResetFeatures::safe_VkPhysicalDeviceHostQueryResetFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceHostQueryResetFeatures::safe_VkPhysicalDeviceHostQueryResetFeatures(const safe_VkPhysicalDeviceHostQueryResetFeatures& copy_src)
{
    sType = copy_src.sType;
    hostQueryReset = copy_src.hostQueryReset;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceHostQueryResetFeatures& safe_VkPhysicalDeviceHostQueryResetFeatures::operator=(const safe_VkPhysicalDeviceHostQueryResetFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    hostQueryReset = copy_src.hostQueryReset;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceHostQueryResetFeatures::~safe_VkPhysicalDeviceHostQueryResetFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceHostQueryResetFeatures::initialize(const VkPhysicalDeviceHostQueryResetFeatures* in_struct)
{
    sType = in_struct->sType;
    hostQueryReset = in_struct->hostQueryReset;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceHostQueryResetFeatures::initialize(const safe_VkPhysicalDeviceHostQueryResetFeatures* copy_src)
{
    sType = copy_src->sType;
    hostQueryReset = copy_src->hostQueryReset;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceTimelineSemaphoreFeatures::safe_VkPhysicalDeviceTimelineSemaphoreFeatures(const VkPhysicalDeviceTimelineSemaphoreFeatures* in_struct) :
    sType(in_struct->sType),
    timelineSemaphore(in_struct->timelineSemaphore)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceTimelineSemaphoreFeatures::safe_VkPhysicalDeviceTimelineSemaphoreFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceTimelineSemaphoreFeatures::safe_VkPhysicalDeviceTimelineSemaphoreFeatures(const safe_VkPhysicalDeviceTimelineSemaphoreFeatures& copy_src)
{
    sType = copy_src.sType;
    timelineSemaphore = copy_src.timelineSemaphore;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceTimelineSemaphoreFeatures& safe_VkPhysicalDeviceTimelineSemaphoreFeatures::operator=(const safe_VkPhysicalDeviceTimelineSemaphoreFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    timelineSemaphore = copy_src.timelineSemaphore;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceTimelineSemaphoreFeatures::~safe_VkPhysicalDeviceTimelineSemaphoreFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceTimelineSemaphoreFeatures::initialize(const VkPhysicalDeviceTimelineSemaphoreFeatures* in_struct)
{
    sType = in_struct->sType;
    timelineSemaphore = in_struct->timelineSemaphore;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceTimelineSemaphoreFeatures::initialize(const safe_VkPhysicalDeviceTimelineSemaphoreFeatures* copy_src)
{
    sType = copy_src->sType;
    timelineSemaphore = copy_src->timelineSemaphore;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceTimelineSemaphoreProperties::safe_VkPhysicalDeviceTimelineSemaphoreProperties(const VkPhysicalDeviceTimelineSemaphoreProperties* in_struct) :
    sType(in_struct->sType),
    maxTimelineSemaphoreValueDifference(in_struct->maxTimelineSemaphoreValueDifference)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceTimelineSemaphoreProperties::safe_VkPhysicalDeviceTimelineSemaphoreProperties() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceTimelineSemaphoreProperties::safe_VkPhysicalDeviceTimelineSemaphoreProperties(const safe_VkPhysicalDeviceTimelineSemaphoreProperties& copy_src)
{
    sType = copy_src.sType;
    maxTimelineSemaphoreValueDifference = copy_src.maxTimelineSemaphoreValueDifference;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceTimelineSemaphoreProperties& safe_VkPhysicalDeviceTimelineSemaphoreProperties::operator=(const safe_VkPhysicalDeviceTimelineSemaphoreProperties& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    maxTimelineSemaphoreValueDifference = copy_src.maxTimelineSemaphoreValueDifference;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceTimelineSemaphoreProperties::~safe_VkPhysicalDeviceTimelineSemaphoreProperties()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceTimelineSemaphoreProperties::initialize(const VkPhysicalDeviceTimelineSemaphoreProperties* in_struct)
{
    sType = in_struct->sType;
    maxTimelineSemaphoreValueDifference = in_struct->maxTimelineSemaphoreValueDifference;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceTimelineSemaphoreProperties::initialize(const safe_VkPhysicalDeviceTimelineSemaphoreProperties* copy_src)
{
    sType = copy_src->sType;
    maxTimelineSemaphoreValueDifference = copy_src->maxTimelineSemaphoreValueDifference;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSemaphoreTypeCreateInfo::safe_VkSemaphoreTypeCreateInfo(const VkSemaphoreTypeCreateInfo* in_struct) :
    sType(in_struct->sType),
    semaphoreType(in_struct->semaphoreType),
    initialValue(in_struct->initialValue)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSemaphoreTypeCreateInfo::safe_VkSemaphoreTypeCreateInfo() :
    sType(VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkSemaphoreTypeCreateInfo::safe_VkSemaphoreTypeCreateInfo(const safe_VkSemaphoreTypeCreateInfo& copy_src)
{
    sType = copy_src.sType;
    semaphoreType = copy_src.semaphoreType;
    initialValue = copy_src.initialValue;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSemaphoreTypeCreateInfo& safe_VkSemaphoreTypeCreateInfo::operator=(const safe_VkSemaphoreTypeCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    semaphoreType = copy_src.semaphoreType;
    initialValue = copy_src.initialValue;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSemaphoreTypeCreateInfo::~safe_VkSemaphoreTypeCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreTypeCreateInfo::initialize(const VkSemaphoreTypeCreateInfo* in_struct)
{
    sType = in_struct->sType;
    semaphoreType = in_struct->semaphoreType;
    initialValue = in_struct->initialValue;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSemaphoreTypeCreateInfo::initialize(const safe_VkSemaphoreTypeCreateInfo* copy_src)
{
    sType = copy_src->sType;
    semaphoreType = copy_src->semaphoreType;
    initialValue = copy_src->initialValue;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkTimelineSemaphoreSubmitInfo::safe_VkTimelineSemaphoreSubmitInfo(const VkTimelineSemaphoreSubmitInfo* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreValueCount(in_struct->waitSemaphoreValueCount),
    pWaitSemaphoreValues(nullptr),
    signalSemaphoreValueCount(in_struct->signalSemaphoreValueCount),
    pSignalSemaphoreValues(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[in_struct->waitSemaphoreValueCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)in_struct->pWaitSemaphoreValues, sizeof(uint64_t)*in_struct->waitSemaphoreValueCount);
    }
    if (in_struct->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[in_struct->signalSemaphoreValueCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)in_struct->pSignalSemaphoreValues, sizeof(uint64_t)*in_struct->signalSemaphoreValueCount);
    }
}

safe_VkTimelineSemaphoreSubmitInfo::safe_VkTimelineSemaphoreSubmitInfo() :
    sType(VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO),
    pNext(nullptr),
    pWaitSemaphoreValues(nullptr),
    pSignalSemaphoreValues(nullptr)
{}

safe_VkTimelineSemaphoreSubmitInfo::safe_VkTimelineSemaphoreSubmitInfo(const safe_VkTimelineSemaphoreSubmitInfo& copy_src)
{
    sType = copy_src.sType;
    waitSemaphoreValueCount = copy_src.waitSemaphoreValueCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValueCount = copy_src.signalSemaphoreValueCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[copy_src.waitSemaphoreValueCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)copy_src.pWaitSemaphoreValues, sizeof(uint64_t)*copy_src.waitSemaphoreValueCount);
    }
    if (copy_src.pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[copy_src.signalSemaphoreValueCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)copy_src.pSignalSemaphoreValues, sizeof(uint64_t)*copy_src.signalSemaphoreValueCount);
    }
}

safe_VkTimelineSemaphoreSubmitInfo& safe_VkTimelineSemaphoreSubmitInfo::operator=(const safe_VkTimelineSemaphoreSubmitInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pWaitSemaphoreValues)
        delete[] pWaitSemaphoreValues;
    if (pSignalSemaphoreValues)
        delete[] pSignalSemaphoreValues;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    waitSemaphoreValueCount = copy_src.waitSemaphoreValueCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValueCount = copy_src.signalSemaphoreValueCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[copy_src.waitSemaphoreValueCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)copy_src.pWaitSemaphoreValues, sizeof(uint64_t)*copy_src.waitSemaphoreValueCount);
    }
    if (copy_src.pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[copy_src.signalSemaphoreValueCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)copy_src.pSignalSemaphoreValues, sizeof(uint64_t)*copy_src.signalSemaphoreValueCount);
    }

    return *this;
}

safe_VkTimelineSemaphoreSubmitInfo::~safe_VkTimelineSemaphoreSubmitInfo()
{
    if (pWaitSemaphoreValues)
        delete[] pWaitSemaphoreValues;
    if (pSignalSemaphoreValues)
        delete[] pSignalSemaphoreValues;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkTimelineSemaphoreSubmitInfo::initialize(const VkTimelineSemaphoreSubmitInfo* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreValueCount = in_struct->waitSemaphoreValueCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValueCount = in_struct->signalSemaphoreValueCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[in_struct->waitSemaphoreValueCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)in_struct->pWaitSemaphoreValues, sizeof(uint64_t)*in_struct->waitSemaphoreValueCount);
    }
    if (in_struct->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[in_struct->signalSemaphoreValueCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)in_struct->pSignalSemaphoreValues, sizeof(uint64_t)*in_struct->signalSemaphoreValueCount);
    }
}

void safe_VkTimelineSemaphoreSubmitInfo::initialize(const safe_VkTimelineSemaphoreSubmitInfo* copy_src)
{
    sType = copy_src->sType;
    waitSemaphoreValueCount = copy_src->waitSemaphoreValueCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValueCount = copy_src->signalSemaphoreValueCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[copy_src->waitSemaphoreValueCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)copy_src->pWaitSemaphoreValues, sizeof(uint64_t)*copy_src->waitSemaphoreValueCount);
    }
    if (copy_src->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[copy_src->signalSemaphoreValueCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)copy_src->pSignalSemaphoreValues, sizeof(uint64_t)*copy_src->signalSemaphoreValueCount);
    }
}

safe_VkSemaphoreWaitInfo::safe_VkSemaphoreWaitInfo(const VkSemaphoreWaitInfo* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    semaphoreCount(in_struct->semaphoreCount),
    pSemaphores(nullptr),
    pValues(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (semaphoreCount && in_struct->pSemaphores) {
        pSemaphores = new VkSemaphore[semaphoreCount];
        for (uint32_t i = 0; i < semaphoreCount; ++i) {
            pSemaphores[i] = in_struct->pSemaphores[i];
        }
    }
    if (in_struct->pValues) {
        pValues = new uint64_t[in_struct->semaphoreCount];
        memcpy ((void *)pValues, (void *)in_struct->pValues, sizeof(uint64_t)*in_struct->semaphoreCount);
    }
}

safe_VkSemaphoreWaitInfo::safe_VkSemaphoreWaitInfo() :
    sType(VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO),
    pNext(nullptr),
    pSemaphores(nullptr),
    pValues(nullptr)
{}

safe_VkSemaphoreWaitInfo::safe_VkSemaphoreWaitInfo(const safe_VkSemaphoreWaitInfo& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    semaphoreCount = copy_src.semaphoreCount;
    pSemaphores = nullptr;
    pValues = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (semaphoreCount && copy_src.pSemaphores) {
        pSemaphores = new VkSemaphore[semaphoreCount];
        for (uint32_t i = 0; i < semaphoreCount; ++i) {
            pSemaphores[i] = copy_src.pSemaphores[i];
        }
    }
    if (copy_src.pValues) {
        pValues = new uint64_t[copy_src.semaphoreCount];
        memcpy ((void *)pValues, (void *)copy_src.pValues, sizeof(uint64_t)*copy_src.semaphoreCount);
    }
}

safe_VkSemaphoreWaitInfo& safe_VkSemaphoreWaitInfo::operator=(const safe_VkSemaphoreWaitInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pSemaphores)
        delete[] pSemaphores;
    if (pValues)
        delete[] pValues;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    semaphoreCount = copy_src.semaphoreCount;
    pSemaphores = nullptr;
    pValues = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (semaphoreCount && copy_src.pSemaphores) {
        pSemaphores = new VkSemaphore[semaphoreCount];
        for (uint32_t i = 0; i < semaphoreCount; ++i) {
            pSemaphores[i] = copy_src.pSemaphores[i];
        }
    }
    if (copy_src.pValues) {
        pValues = new uint64_t[copy_src.semaphoreCount];
        memcpy ((void *)pValues, (void *)copy_src.pValues, sizeof(uint64_t)*copy_src.semaphoreCount);
    }

    return *this;
}

safe_VkSemaphoreWaitInfo::~safe_VkSemaphoreWaitInfo()
{
    if (pSemaphores)
        delete[] pSemaphores;
    if (pValues)
        delete[] pValues;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreWaitInfo::initialize(const VkSemaphoreWaitInfo* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    semaphoreCount = in_struct->semaphoreCount;
    pSemaphores = nullptr;
    pValues = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (semaphoreCount && in_struct->pSemaphores) {
        pSemaphores = new VkSemaphore[semaphoreCount];
        for (uint32_t i = 0; i < semaphoreCount; ++i) {
            pSemaphores[i] = in_struct->pSemaphores[i];
        }
    }
    if (in_struct->pValues) {
        pValues = new uint64_t[in_struct->semaphoreCount];
        memcpy ((void *)pValues, (void *)in_struct->pValues, sizeof(uint64_t)*in_struct->semaphoreCount);
    }
}

void safe_VkSemaphoreWaitInfo::initialize(const safe_VkSemaphoreWaitInfo* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    semaphoreCount = copy_src->semaphoreCount;
    pSemaphores = nullptr;
    pValues = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (semaphoreCount && copy_src->pSemaphores) {
        pSemaphores = new VkSemaphore[semaphoreCount];
        for (uint32_t i = 0; i < semaphoreCount; ++i) {
            pSemaphores[i] = copy_src->pSemaphores[i];
        }
    }
    if (copy_src->pValues) {
        pValues = new uint64_t[copy_src->semaphoreCount];
        memcpy ((void *)pValues, (void *)copy_src->pValues, sizeof(uint64_t)*copy_src->semaphoreCount);
    }
}

safe_VkSemaphoreSignalInfo::safe_VkSemaphoreSignalInfo(const VkSemaphoreSignalInfo* in_struct) :
    sType(in_struct->sType),
    semaphore(in_struct->semaphore),
    value(in_struct->value)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSemaphoreSignalInfo::safe_VkSemaphoreSignalInfo() :
    sType(VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO),
    pNext(nullptr)
{}

safe_VkSemaphoreSignalInfo::safe_VkSemaphoreSignalInfo(const safe_VkSemaphoreSignalInfo& copy_src)
{
    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    value = copy_src.value;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSemaphoreSignalInfo& safe_VkSemaphoreSignalInfo::operator=(const safe_VkSemaphoreSignalInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    value = copy_src.value;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSemaphoreSignalInfo::~safe_VkSemaphoreSignalInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreSignalInfo::initialize(const VkSemaphoreSignalInfo* in_struct)
{
    sType = in_struct->sType;
    semaphore = in_struct->semaphore;
    value = in_struct->value;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSemaphoreSignalInfo::initialize(const safe_VkSemaphoreSignalInfo* copy_src)
{
    sType = copy_src->sType;
    semaphore = copy_src->semaphore;
    value = copy_src->value;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceBufferDeviceAddressFeatures::safe_VkPhysicalDeviceBufferDeviceAddressFeatures(const VkPhysicalDeviceBufferDeviceAddressFeatures* in_struct) :
    sType(in_struct->sType),
    bufferDeviceAddress(in_struct->bufferDeviceAddress),
    bufferDeviceAddressCaptureReplay(in_struct->bufferDeviceAddressCaptureReplay),
    bufferDeviceAddressMultiDevice(in_struct->bufferDeviceAddressMultiDevice)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceBufferDeviceAddressFeatures::safe_VkPhysicalDeviceBufferDeviceAddressFeatures() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceBufferDeviceAddressFeatures::safe_VkPhysicalDeviceBufferDeviceAddressFeatures(const safe_VkPhysicalDeviceBufferDeviceAddressFeatures& copy_src)
{
    sType = copy_src.sType;
    bufferDeviceAddress = copy_src.bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = copy_src.bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = copy_src.bufferDeviceAddressMultiDevice;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceBufferDeviceAddressFeatures& safe_VkPhysicalDeviceBufferDeviceAddressFeatures::operator=(const safe_VkPhysicalDeviceBufferDeviceAddressFeatures& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    bufferDeviceAddress = copy_src.bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = copy_src.bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = copy_src.bufferDeviceAddressMultiDevice;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceBufferDeviceAddressFeatures::~safe_VkPhysicalDeviceBufferDeviceAddressFeatures()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceBufferDeviceAddressFeatures::initialize(const VkPhysicalDeviceBufferDeviceAddressFeatures* in_struct)
{
    sType = in_struct->sType;
    bufferDeviceAddress = in_struct->bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = in_struct->bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = in_struct->bufferDeviceAddressMultiDevice;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceBufferDeviceAddressFeatures::initialize(const safe_VkPhysicalDeviceBufferDeviceAddressFeatures* copy_src)
{
    sType = copy_src->sType;
    bufferDeviceAddress = copy_src->bufferDeviceAddress;
    bufferDeviceAddressCaptureReplay = copy_src->bufferDeviceAddressCaptureReplay;
    bufferDeviceAddressMultiDevice = copy_src->bufferDeviceAddressMultiDevice;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkBufferDeviceAddressInfo::safe_VkBufferDeviceAddressInfo(const VkBufferDeviceAddressInfo* in_struct) :
    sType(in_struct->sType),
    buffer(in_struct->buffer)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferDeviceAddressInfo::safe_VkBufferDeviceAddressInfo() :
    sType(VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO),
    pNext(nullptr)
{}

safe_VkBufferDeviceAddressInfo::safe_VkBufferDeviceAddressInfo(const safe_VkBufferDeviceAddressInfo& copy_src)
{
    sType = copy_src.sType;
    buffer = copy_src.buffer;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBufferDeviceAddressInfo& safe_VkBufferDeviceAddressInfo::operator=(const safe_VkBufferDeviceAddressInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    buffer = copy_src.buffer;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBufferDeviceAddressInfo::~safe_VkBufferDeviceAddressInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferDeviceAddressInfo::initialize(const VkBufferDeviceAddressInfo* in_struct)
{
    sType = in_struct->sType;
    buffer = in_struct->buffer;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferDeviceAddressInfo::initialize(const safe_VkBufferDeviceAddressInfo* copy_src)
{
    sType = copy_src->sType;
    buffer = copy_src->buffer;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkBufferOpaqueCaptureAddressCreateInfo::safe_VkBufferOpaqueCaptureAddressCreateInfo(const VkBufferOpaqueCaptureAddressCreateInfo* in_struct) :
    sType(in_struct->sType),
    opaqueCaptureAddress(in_struct->opaqueCaptureAddress)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferOpaqueCaptureAddressCreateInfo::safe_VkBufferOpaqueCaptureAddressCreateInfo() :
    sType(VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO),
    pNext(nullptr)
{}

safe_VkBufferOpaqueCaptureAddressCreateInfo::safe_VkBufferOpaqueCaptureAddressCreateInfo(const safe_VkBufferOpaqueCaptureAddressCreateInfo& copy_src)
{
    sType = copy_src.sType;
    opaqueCaptureAddress = copy_src.opaqueCaptureAddress;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBufferOpaqueCaptureAddressCreateInfo& safe_VkBufferOpaqueCaptureAddressCreateInfo::operator=(const safe_VkBufferOpaqueCaptureAddressCreateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    opaqueCaptureAddress = copy_src.opaqueCaptureAddress;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBufferOpaqueCaptureAddressCreateInfo::~safe_VkBufferOpaqueCaptureAddressCreateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferOpaqueCaptureAddressCreateInfo::initialize(const VkBufferOpaqueCaptureAddressCreateInfo* in_struct)
{
    sType = in_struct->sType;
    opaqueCaptureAddress = in_struct->opaqueCaptureAddress;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferOpaqueCaptureAddressCreateInfo::initialize(const safe_VkBufferOpaqueCaptureAddressCreateInfo* copy_src)
{
    sType = copy_src->sType;
    opaqueCaptureAddress = copy_src->opaqueCaptureAddress;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkMemoryOpaqueCaptureAddressAllocateInfo::safe_VkMemoryOpaqueCaptureAddressAllocateInfo(const VkMemoryOpaqueCaptureAddressAllocateInfo* in_struct) :
    sType(in_struct->sType),
    opaqueCaptureAddress(in_struct->opaqueCaptureAddress)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryOpaqueCaptureAddressAllocateInfo::safe_VkMemoryOpaqueCaptureAddressAllocateInfo() :
    sType(VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO),
    pNext(nullptr)
{}

safe_VkMemoryOpaqueCaptureAddressAllocateInfo::safe_VkMemoryOpaqueCaptureAddressAllocateInfo(const safe_VkMemoryOpaqueCaptureAddressAllocateInfo& copy_src)
{
    sType = copy_src.sType;
    opaqueCaptureAddress = copy_src.opaqueCaptureAddress;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryOpaqueCaptureAddressAllocateInfo& safe_VkMemoryOpaqueCaptureAddressAllocateInfo::operator=(const safe_VkMemoryOpaqueCaptureAddressAllocateInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    opaqueCaptureAddress = copy_src.opaqueCaptureAddress;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryOpaqueCaptureAddressAllocateInfo::~safe_VkMemoryOpaqueCaptureAddressAllocateInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryOpaqueCaptureAddressAllocateInfo::initialize(const VkMemoryOpaqueCaptureAddressAllocateInfo* in_struct)
{
    sType = in_struct->sType;
    opaqueCaptureAddress = in_struct->opaqueCaptureAddress;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryOpaqueCaptureAddressAllocateInfo::initialize(const safe_VkMemoryOpaqueCaptureAddressAllocateInfo* copy_src)
{
    sType = copy_src->sType;
    opaqueCaptureAddress = copy_src->opaqueCaptureAddress;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDeviceMemoryOpaqueCaptureAddressInfo::safe_VkDeviceMemoryOpaqueCaptureAddressInfo(const VkDeviceMemoryOpaqueCaptureAddressInfo* in_struct) :
    sType(in_struct->sType),
    memory(in_struct->memory)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceMemoryOpaqueCaptureAddressInfo::safe_VkDeviceMemoryOpaqueCaptureAddressInfo() :
    sType(VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO),
    pNext(nullptr)
{}

safe_VkDeviceMemoryOpaqueCaptureAddressInfo::safe_VkDeviceMemoryOpaqueCaptureAddressInfo(const safe_VkDeviceMemoryOpaqueCaptureAddressInfo& copy_src)
{
    sType = copy_src.sType;
    memory = copy_src.memory;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDeviceMemoryOpaqueCaptureAddressInfo& safe_VkDeviceMemoryOpaqueCaptureAddressInfo::operator=(const safe_VkDeviceMemoryOpaqueCaptureAddressInfo& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    memory = copy_src.memory;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDeviceMemoryOpaqueCaptureAddressInfo::~safe_VkDeviceMemoryOpaqueCaptureAddressInfo()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceMemoryOpaqueCaptureAddressInfo::initialize(const VkDeviceMemoryOpaqueCaptureAddressInfo* in_struct)
{
    sType = in_struct->sType;
    memory = in_struct->memory;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceMemoryOpaqueCaptureAddressInfo::initialize(const safe_VkDeviceMemoryOpaqueCaptureAddressInfo* copy_src)
{
    sType = copy_src->sType;
    memory = copy_src->memory;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSwapchainCreateInfoKHR::safe_VkSwapchainCreateInfoKHR(const VkSwapchainCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    surface(in_struct->surface),
    minImageCount(in_struct->minImageCount),
    imageFormat(in_struct->imageFormat),
    imageColorSpace(in_struct->imageColorSpace),
    imageExtent(in_struct->imageExtent),
    imageArrayLayers(in_struct->imageArrayLayers),
    imageUsage(in_struct->imageUsage),
    imageSharingMode(in_struct->imageSharingMode),
    queueFamilyIndexCount(in_struct->queueFamilyIndexCount),
    pQueueFamilyIndices(nullptr),
    preTransform(in_struct->preTransform),
    compositeAlpha(in_struct->compositeAlpha),
    presentMode(in_struct->presentMode),
    clipped(in_struct->clipped),
    oldSwapchain(in_struct->oldSwapchain)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if ((in_struct->imageSharingMode == VK_SHARING_MODE_CONCURRENT) && in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

safe_VkSwapchainCreateInfoKHR::safe_VkSwapchainCreateInfoKHR() :
    sType(VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR),
    pNext(nullptr),
    pQueueFamilyIndices(nullptr)
{}

safe_VkSwapchainCreateInfoKHR::safe_VkSwapchainCreateInfoKHR(const safe_VkSwapchainCreateInfoKHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    surface = copy_src.surface;
    minImageCount = copy_src.minImageCount;
    imageFormat = copy_src.imageFormat;
    imageColorSpace = copy_src.imageColorSpace;
    imageExtent = copy_src.imageExtent;
    imageArrayLayers = copy_src.imageArrayLayers;
    imageUsage = copy_src.imageUsage;
    imageSharingMode = copy_src.imageSharingMode;
    queueFamilyIndexCount = copy_src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    preTransform = copy_src.preTransform;
    compositeAlpha = copy_src.compositeAlpha;
    presentMode = copy_src.presentMode;
    clipped = copy_src.clipped;
    oldSwapchain = copy_src.oldSwapchain;
    pNext = SafePnextCopy(copy_src.pNext);
    if ((copy_src.imageSharingMode == VK_SHARING_MODE_CONCURRENT) && copy_src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[copy_src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)copy_src.pQueueFamilyIndices, sizeof(uint32_t)*copy_src.queueFamilyIndexCount);
    }
}

safe_VkSwapchainCreateInfoKHR& safe_VkSwapchainCreateInfoKHR::operator=(const safe_VkSwapchainCreateInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    surface = copy_src.surface;
    minImageCount = copy_src.minImageCount;
    imageFormat = copy_src.imageFormat;
    imageColorSpace = copy_src.imageColorSpace;
    imageExtent = copy_src.imageExtent;
    imageArrayLayers = copy_src.imageArrayLayers;
    imageUsage = copy_src.imageUsage;
    imageSharingMode = copy_src.imageSharingMode;
    queueFamilyIndexCount = copy_src.queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    preTransform = copy_src.preTransform;
    compositeAlpha = copy_src.compositeAlpha;
    presentMode = copy_src.presentMode;
    clipped = copy_src.clipped;
    oldSwapchain = copy_src.oldSwapchain;
    pNext = SafePnextCopy(copy_src.pNext);
    if ((copy_src.imageSharingMode == VK_SHARING_MODE_CONCURRENT) && copy_src.pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[copy_src.queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)copy_src.pQueueFamilyIndices, sizeof(uint32_t)*copy_src.queueFamilyIndexCount);
    }

    return *this;
}

safe_VkSwapchainCreateInfoKHR::~safe_VkSwapchainCreateInfoKHR()
{
    if (pQueueFamilyIndices)
        delete[] pQueueFamilyIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSwapchainCreateInfoKHR::initialize(const VkSwapchainCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    surface = in_struct->surface;
    minImageCount = in_struct->minImageCount;
    imageFormat = in_struct->imageFormat;
    imageColorSpace = in_struct->imageColorSpace;
    imageExtent = in_struct->imageExtent;
    imageArrayLayers = in_struct->imageArrayLayers;
    imageUsage = in_struct->imageUsage;
    imageSharingMode = in_struct->imageSharingMode;
    queueFamilyIndexCount = in_struct->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    preTransform = in_struct->preTransform;
    compositeAlpha = in_struct->compositeAlpha;
    presentMode = in_struct->presentMode;
    clipped = in_struct->clipped;
    oldSwapchain = in_struct->oldSwapchain;
    pNext = SafePnextCopy(in_struct->pNext);
    if ((in_struct->imageSharingMode == VK_SHARING_MODE_CONCURRENT) && in_struct->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[in_struct->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)in_struct->pQueueFamilyIndices, sizeof(uint32_t)*in_struct->queueFamilyIndexCount);
    }
}

void safe_VkSwapchainCreateInfoKHR::initialize(const safe_VkSwapchainCreateInfoKHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    surface = copy_src->surface;
    minImageCount = copy_src->minImageCount;
    imageFormat = copy_src->imageFormat;
    imageColorSpace = copy_src->imageColorSpace;
    imageExtent = copy_src->imageExtent;
    imageArrayLayers = copy_src->imageArrayLayers;
    imageUsage = copy_src->imageUsage;
    imageSharingMode = copy_src->imageSharingMode;
    queueFamilyIndexCount = copy_src->queueFamilyIndexCount;
    pQueueFamilyIndices = nullptr;
    preTransform = copy_src->preTransform;
    compositeAlpha = copy_src->compositeAlpha;
    presentMode = copy_src->presentMode;
    clipped = copy_src->clipped;
    oldSwapchain = copy_src->oldSwapchain;
    pNext = SafePnextCopy(copy_src->pNext);
    if ((copy_src->imageSharingMode == VK_SHARING_MODE_CONCURRENT) && copy_src->pQueueFamilyIndices) {
        pQueueFamilyIndices = new uint32_t[copy_src->queueFamilyIndexCount];
        memcpy ((void *)pQueueFamilyIndices, (void *)copy_src->pQueueFamilyIndices, sizeof(uint32_t)*copy_src->queueFamilyIndexCount);
    }
}

safe_VkPresentInfoKHR::safe_VkPresentInfoKHR(const VkPresentInfoKHR* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreCount(in_struct->waitSemaphoreCount),
    pWaitSemaphores(nullptr),
    swapchainCount(in_struct->swapchainCount),
    pSwapchains(nullptr),
    pImageIndices(nullptr),
    pResults(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (swapchainCount && in_struct->pSwapchains) {
        pSwapchains = new VkSwapchainKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pSwapchains[i] = in_struct->pSwapchains[i];
        }
    }
    if (in_struct->pImageIndices) {
        pImageIndices = new uint32_t[in_struct->swapchainCount];
        memcpy ((void *)pImageIndices, (void *)in_struct->pImageIndices, sizeof(uint32_t)*in_struct->swapchainCount);
    }
    if (in_struct->pResults) {
        pResults = new VkResult[in_struct->swapchainCount];
        memcpy ((void *)pResults, (void *)in_struct->pResults, sizeof(VkResult)*in_struct->swapchainCount);
    }
}

safe_VkPresentInfoKHR::safe_VkPresentInfoKHR() :
    sType(VK_STRUCTURE_TYPE_PRESENT_INFO_KHR),
    pNext(nullptr),
    pWaitSemaphores(nullptr),
    pSwapchains(nullptr),
    pImageIndices(nullptr),
    pResults(nullptr)
{}

safe_VkPresentInfoKHR::safe_VkPresentInfoKHR(const safe_VkPresentInfoKHR& copy_src)
{
    sType = copy_src.sType;
    waitSemaphoreCount = copy_src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    swapchainCount = copy_src.swapchainCount;
    pSwapchains = nullptr;
    pImageIndices = nullptr;
    pResults = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (waitSemaphoreCount && copy_src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = copy_src.pWaitSemaphores[i];
        }
    }
    if (swapchainCount && copy_src.pSwapchains) {
        pSwapchains = new VkSwapchainKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pSwapchains[i] = copy_src.pSwapchains[i];
        }
    }
    if (copy_src.pImageIndices) {
        pImageIndices = new uint32_t[copy_src.swapchainCount];
        memcpy ((void *)pImageIndices, (void *)copy_src.pImageIndices, sizeof(uint32_t)*copy_src.swapchainCount);
    }
    if (copy_src.pResults) {
        pResults = new VkResult[copy_src.swapchainCount];
        memcpy ((void *)pResults, (void *)copy_src.pResults, sizeof(VkResult)*copy_src.swapchainCount);
    }
}

safe_VkPresentInfoKHR& safe_VkPresentInfoKHR::operator=(const safe_VkPresentInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pSwapchains)
        delete[] pSwapchains;
    if (pImageIndices)
        delete[] pImageIndices;
    if (pResults)
        delete[] pResults;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    waitSemaphoreCount = copy_src.waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    swapchainCount = copy_src.swapchainCount;
    pSwapchains = nullptr;
    pImageIndices = nullptr;
    pResults = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (waitSemaphoreCount && copy_src.pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = copy_src.pWaitSemaphores[i];
        }
    }
    if (swapchainCount && copy_src.pSwapchains) {
        pSwapchains = new VkSwapchainKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pSwapchains[i] = copy_src.pSwapchains[i];
        }
    }
    if (copy_src.pImageIndices) {
        pImageIndices = new uint32_t[copy_src.swapchainCount];
        memcpy ((void *)pImageIndices, (void *)copy_src.pImageIndices, sizeof(uint32_t)*copy_src.swapchainCount);
    }
    if (copy_src.pResults) {
        pResults = new VkResult[copy_src.swapchainCount];
        memcpy ((void *)pResults, (void *)copy_src.pResults, sizeof(VkResult)*copy_src.swapchainCount);
    }

    return *this;
}

safe_VkPresentInfoKHR::~safe_VkPresentInfoKHR()
{
    if (pWaitSemaphores)
        delete[] pWaitSemaphores;
    if (pSwapchains)
        delete[] pSwapchains;
    if (pImageIndices)
        delete[] pImageIndices;
    if (pResults)
        delete[] pResults;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPresentInfoKHR::initialize(const VkPresentInfoKHR* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreCount = in_struct->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    swapchainCount = in_struct->swapchainCount;
    pSwapchains = nullptr;
    pImageIndices = nullptr;
    pResults = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreCount && in_struct->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = in_struct->pWaitSemaphores[i];
        }
    }
    if (swapchainCount && in_struct->pSwapchains) {
        pSwapchains = new VkSwapchainKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pSwapchains[i] = in_struct->pSwapchains[i];
        }
    }
    if (in_struct->pImageIndices) {
        pImageIndices = new uint32_t[in_struct->swapchainCount];
        memcpy ((void *)pImageIndices, (void *)in_struct->pImageIndices, sizeof(uint32_t)*in_struct->swapchainCount);
    }
    if (in_struct->pResults) {
        pResults = new VkResult[in_struct->swapchainCount];
        memcpy ((void *)pResults, (void *)in_struct->pResults, sizeof(VkResult)*in_struct->swapchainCount);
    }
}

void safe_VkPresentInfoKHR::initialize(const safe_VkPresentInfoKHR* copy_src)
{
    sType = copy_src->sType;
    waitSemaphoreCount = copy_src->waitSemaphoreCount;
    pWaitSemaphores = nullptr;
    swapchainCount = copy_src->swapchainCount;
    pSwapchains = nullptr;
    pImageIndices = nullptr;
    pResults = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (waitSemaphoreCount && copy_src->pWaitSemaphores) {
        pWaitSemaphores = new VkSemaphore[waitSemaphoreCount];
        for (uint32_t i = 0; i < waitSemaphoreCount; ++i) {
            pWaitSemaphores[i] = copy_src->pWaitSemaphores[i];
        }
    }
    if (swapchainCount && copy_src->pSwapchains) {
        pSwapchains = new VkSwapchainKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pSwapchains[i] = copy_src->pSwapchains[i];
        }
    }
    if (copy_src->pImageIndices) {
        pImageIndices = new uint32_t[copy_src->swapchainCount];
        memcpy ((void *)pImageIndices, (void *)copy_src->pImageIndices, sizeof(uint32_t)*copy_src->swapchainCount);
    }
    if (copy_src->pResults) {
        pResults = new VkResult[copy_src->swapchainCount];
        memcpy ((void *)pResults, (void *)copy_src->pResults, sizeof(VkResult)*copy_src->swapchainCount);
    }
}

safe_VkImageSwapchainCreateInfoKHR::safe_VkImageSwapchainCreateInfoKHR(const VkImageSwapchainCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    swapchain(in_struct->swapchain)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageSwapchainCreateInfoKHR::safe_VkImageSwapchainCreateInfoKHR() :
    sType(VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkImageSwapchainCreateInfoKHR::safe_VkImageSwapchainCreateInfoKHR(const safe_VkImageSwapchainCreateInfoKHR& copy_src)
{
    sType = copy_src.sType;
    swapchain = copy_src.swapchain;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageSwapchainCreateInfoKHR& safe_VkImageSwapchainCreateInfoKHR::operator=(const safe_VkImageSwapchainCreateInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    swapchain = copy_src.swapchain;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageSwapchainCreateInfoKHR::~safe_VkImageSwapchainCreateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageSwapchainCreateInfoKHR::initialize(const VkImageSwapchainCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    swapchain = in_struct->swapchain;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageSwapchainCreateInfoKHR::initialize(const safe_VkImageSwapchainCreateInfoKHR* copy_src)
{
    sType = copy_src->sType;
    swapchain = copy_src->swapchain;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkBindImageMemorySwapchainInfoKHR::safe_VkBindImageMemorySwapchainInfoKHR(const VkBindImageMemorySwapchainInfoKHR* in_struct) :
    sType(in_struct->sType),
    swapchain(in_struct->swapchain),
    imageIndex(in_struct->imageIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBindImageMemorySwapchainInfoKHR::safe_VkBindImageMemorySwapchainInfoKHR() :
    sType(VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR),
    pNext(nullptr)
{}

safe_VkBindImageMemorySwapchainInfoKHR::safe_VkBindImageMemorySwapchainInfoKHR(const safe_VkBindImageMemorySwapchainInfoKHR& copy_src)
{
    sType = copy_src.sType;
    swapchain = copy_src.swapchain;
    imageIndex = copy_src.imageIndex;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBindImageMemorySwapchainInfoKHR& safe_VkBindImageMemorySwapchainInfoKHR::operator=(const safe_VkBindImageMemorySwapchainInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    swapchain = copy_src.swapchain;
    imageIndex = copy_src.imageIndex;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBindImageMemorySwapchainInfoKHR::~safe_VkBindImageMemorySwapchainInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBindImageMemorySwapchainInfoKHR::initialize(const VkBindImageMemorySwapchainInfoKHR* in_struct)
{
    sType = in_struct->sType;
    swapchain = in_struct->swapchain;
    imageIndex = in_struct->imageIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBindImageMemorySwapchainInfoKHR::initialize(const safe_VkBindImageMemorySwapchainInfoKHR* copy_src)
{
    sType = copy_src->sType;
    swapchain = copy_src->swapchain;
    imageIndex = copy_src->imageIndex;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkAcquireNextImageInfoKHR::safe_VkAcquireNextImageInfoKHR(const VkAcquireNextImageInfoKHR* in_struct) :
    sType(in_struct->sType),
    swapchain(in_struct->swapchain),
    timeout(in_struct->timeout),
    semaphore(in_struct->semaphore),
    fence(in_struct->fence),
    deviceMask(in_struct->deviceMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAcquireNextImageInfoKHR::safe_VkAcquireNextImageInfoKHR() :
    sType(VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkAcquireNextImageInfoKHR::safe_VkAcquireNextImageInfoKHR(const safe_VkAcquireNextImageInfoKHR& copy_src)
{
    sType = copy_src.sType;
    swapchain = copy_src.swapchain;
    timeout = copy_src.timeout;
    semaphore = copy_src.semaphore;
    fence = copy_src.fence;
    deviceMask = copy_src.deviceMask;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkAcquireNextImageInfoKHR& safe_VkAcquireNextImageInfoKHR::operator=(const safe_VkAcquireNextImageInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    swapchain = copy_src.swapchain;
    timeout = copy_src.timeout;
    semaphore = copy_src.semaphore;
    fence = copy_src.fence;
    deviceMask = copy_src.deviceMask;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkAcquireNextImageInfoKHR::~safe_VkAcquireNextImageInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAcquireNextImageInfoKHR::initialize(const VkAcquireNextImageInfoKHR* in_struct)
{
    sType = in_struct->sType;
    swapchain = in_struct->swapchain;
    timeout = in_struct->timeout;
    semaphore = in_struct->semaphore;
    fence = in_struct->fence;
    deviceMask = in_struct->deviceMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAcquireNextImageInfoKHR::initialize(const safe_VkAcquireNextImageInfoKHR* copy_src)
{
    sType = copy_src->sType;
    swapchain = copy_src->swapchain;
    timeout = copy_src->timeout;
    semaphore = copy_src->semaphore;
    fence = copy_src->fence;
    deviceMask = copy_src->deviceMask;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDeviceGroupPresentCapabilitiesKHR::safe_VkDeviceGroupPresentCapabilitiesKHR(const VkDeviceGroupPresentCapabilitiesKHR* in_struct) :
    sType(in_struct->sType),
    modes(in_struct->modes)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        presentMask[i] = in_struct->presentMask[i];
    }
}

safe_VkDeviceGroupPresentCapabilitiesKHR::safe_VkDeviceGroupPresentCapabilitiesKHR() :
    sType(VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR),
    pNext(nullptr)
{}

safe_VkDeviceGroupPresentCapabilitiesKHR::safe_VkDeviceGroupPresentCapabilitiesKHR(const safe_VkDeviceGroupPresentCapabilitiesKHR& copy_src)
{
    sType = copy_src.sType;
    modes = copy_src.modes;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        presentMask[i] = copy_src.presentMask[i];
    }
}

safe_VkDeviceGroupPresentCapabilitiesKHR& safe_VkDeviceGroupPresentCapabilitiesKHR::operator=(const safe_VkDeviceGroupPresentCapabilitiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    modes = copy_src.modes;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        presentMask[i] = copy_src.presentMask[i];
    }

    return *this;
}

safe_VkDeviceGroupPresentCapabilitiesKHR::~safe_VkDeviceGroupPresentCapabilitiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupPresentCapabilitiesKHR::initialize(const VkDeviceGroupPresentCapabilitiesKHR* in_struct)
{
    sType = in_struct->sType;
    modes = in_struct->modes;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        presentMask[i] = in_struct->presentMask[i];
    }
}

void safe_VkDeviceGroupPresentCapabilitiesKHR::initialize(const safe_VkDeviceGroupPresentCapabilitiesKHR* copy_src)
{
    sType = copy_src->sType;
    modes = copy_src->modes;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DEVICE_GROUP_SIZE; ++i) {
        presentMask[i] = copy_src->presentMask[i];
    }
}

safe_VkDeviceGroupPresentInfoKHR::safe_VkDeviceGroupPresentInfoKHR(const VkDeviceGroupPresentInfoKHR* in_struct) :
    sType(in_struct->sType),
    swapchainCount(in_struct->swapchainCount),
    pDeviceMasks(nullptr),
    mode(in_struct->mode)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceMasks) {
        pDeviceMasks = new uint32_t[in_struct->swapchainCount];
        memcpy ((void *)pDeviceMasks, (void *)in_struct->pDeviceMasks, sizeof(uint32_t)*in_struct->swapchainCount);
    }
}

safe_VkDeviceGroupPresentInfoKHR::safe_VkDeviceGroupPresentInfoKHR() :
    sType(VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR),
    pNext(nullptr),
    pDeviceMasks(nullptr)
{}

safe_VkDeviceGroupPresentInfoKHR::safe_VkDeviceGroupPresentInfoKHR(const safe_VkDeviceGroupPresentInfoKHR& copy_src)
{
    sType = copy_src.sType;
    swapchainCount = copy_src.swapchainCount;
    pDeviceMasks = nullptr;
    mode = copy_src.mode;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDeviceMasks) {
        pDeviceMasks = new uint32_t[copy_src.swapchainCount];
        memcpy ((void *)pDeviceMasks, (void *)copy_src.pDeviceMasks, sizeof(uint32_t)*copy_src.swapchainCount);
    }
}

safe_VkDeviceGroupPresentInfoKHR& safe_VkDeviceGroupPresentInfoKHR::operator=(const safe_VkDeviceGroupPresentInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pDeviceMasks)
        delete[] pDeviceMasks;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    swapchainCount = copy_src.swapchainCount;
    pDeviceMasks = nullptr;
    mode = copy_src.mode;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pDeviceMasks) {
        pDeviceMasks = new uint32_t[copy_src.swapchainCount];
        memcpy ((void *)pDeviceMasks, (void *)copy_src.pDeviceMasks, sizeof(uint32_t)*copy_src.swapchainCount);
    }

    return *this;
}

safe_VkDeviceGroupPresentInfoKHR::~safe_VkDeviceGroupPresentInfoKHR()
{
    if (pDeviceMasks)
        delete[] pDeviceMasks;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupPresentInfoKHR::initialize(const VkDeviceGroupPresentInfoKHR* in_struct)
{
    sType = in_struct->sType;
    swapchainCount = in_struct->swapchainCount;
    pDeviceMasks = nullptr;
    mode = in_struct->mode;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pDeviceMasks) {
        pDeviceMasks = new uint32_t[in_struct->swapchainCount];
        memcpy ((void *)pDeviceMasks, (void *)in_struct->pDeviceMasks, sizeof(uint32_t)*in_struct->swapchainCount);
    }
}

void safe_VkDeviceGroupPresentInfoKHR::initialize(const safe_VkDeviceGroupPresentInfoKHR* copy_src)
{
    sType = copy_src->sType;
    swapchainCount = copy_src->swapchainCount;
    pDeviceMasks = nullptr;
    mode = copy_src->mode;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pDeviceMasks) {
        pDeviceMasks = new uint32_t[copy_src->swapchainCount];
        memcpy ((void *)pDeviceMasks, (void *)copy_src->pDeviceMasks, sizeof(uint32_t)*copy_src->swapchainCount);
    }
}

safe_VkDeviceGroupSwapchainCreateInfoKHR::safe_VkDeviceGroupSwapchainCreateInfoKHR(const VkDeviceGroupSwapchainCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    modes(in_struct->modes)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDeviceGroupSwapchainCreateInfoKHR::safe_VkDeviceGroupSwapchainCreateInfoKHR() :
    sType(VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkDeviceGroupSwapchainCreateInfoKHR::safe_VkDeviceGroupSwapchainCreateInfoKHR(const safe_VkDeviceGroupSwapchainCreateInfoKHR& copy_src)
{
    sType = copy_src.sType;
    modes = copy_src.modes;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDeviceGroupSwapchainCreateInfoKHR& safe_VkDeviceGroupSwapchainCreateInfoKHR::operator=(const safe_VkDeviceGroupSwapchainCreateInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    modes = copy_src.modes;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDeviceGroupSwapchainCreateInfoKHR::~safe_VkDeviceGroupSwapchainCreateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDeviceGroupSwapchainCreateInfoKHR::initialize(const VkDeviceGroupSwapchainCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    modes = in_struct->modes;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDeviceGroupSwapchainCreateInfoKHR::initialize(const safe_VkDeviceGroupSwapchainCreateInfoKHR* copy_src)
{
    sType = copy_src->sType;
    modes = copy_src->modes;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDisplayModeCreateInfoKHR::safe_VkDisplayModeCreateInfoKHR(const VkDisplayModeCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    parameters(in_struct->parameters)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayModeCreateInfoKHR::safe_VkDisplayModeCreateInfoKHR() :
    sType(VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkDisplayModeCreateInfoKHR::safe_VkDisplayModeCreateInfoKHR(const safe_VkDisplayModeCreateInfoKHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    parameters = copy_src.parameters;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDisplayModeCreateInfoKHR& safe_VkDisplayModeCreateInfoKHR::operator=(const safe_VkDisplayModeCreateInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    parameters = copy_src.parameters;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDisplayModeCreateInfoKHR::~safe_VkDisplayModeCreateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayModeCreateInfoKHR::initialize(const VkDisplayModeCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    parameters = in_struct->parameters;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayModeCreateInfoKHR::initialize(const safe_VkDisplayModeCreateInfoKHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    parameters = copy_src->parameters;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDisplayPropertiesKHR::safe_VkDisplayPropertiesKHR(const VkDisplayPropertiesKHR* in_struct) :
    display(in_struct->display),
    physicalDimensions(in_struct->physicalDimensions),
    physicalResolution(in_struct->physicalResolution),
    supportedTransforms(in_struct->supportedTransforms),
    planeReorderPossible(in_struct->planeReorderPossible),
    persistentContent(in_struct->persistentContent)
{
    displayName = SafeStringCopy(in_struct->displayName);
}

safe_VkDisplayPropertiesKHR::safe_VkDisplayPropertiesKHR() :
    displayName(nullptr)
{}

safe_VkDisplayPropertiesKHR::safe_VkDisplayPropertiesKHR(const safe_VkDisplayPropertiesKHR& copy_src)
{
    display = copy_src.display;
    physicalDimensions = copy_src.physicalDimensions;
    physicalResolution = copy_src.physicalResolution;
    supportedTransforms = copy_src.supportedTransforms;
    planeReorderPossible = copy_src.planeReorderPossible;
    persistentContent = copy_src.persistentContent;
    displayName = SafeStringCopy(copy_src.displayName);
}

safe_VkDisplayPropertiesKHR& safe_VkDisplayPropertiesKHR::operator=(const safe_VkDisplayPropertiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (displayName) delete [] displayName;

    display = copy_src.display;
    physicalDimensions = copy_src.physicalDimensions;
    physicalResolution = copy_src.physicalResolution;
    supportedTransforms = copy_src.supportedTransforms;
    planeReorderPossible = copy_src.planeReorderPossible;
    persistentContent = copy_src.persistentContent;
    displayName = SafeStringCopy(copy_src.displayName);

    return *this;
}

safe_VkDisplayPropertiesKHR::~safe_VkDisplayPropertiesKHR()
{
    if (displayName) delete [] displayName;
}

void safe_VkDisplayPropertiesKHR::initialize(const VkDisplayPropertiesKHR* in_struct)
{
    display = in_struct->display;
    physicalDimensions = in_struct->physicalDimensions;
    physicalResolution = in_struct->physicalResolution;
    supportedTransforms = in_struct->supportedTransforms;
    planeReorderPossible = in_struct->planeReorderPossible;
    persistentContent = in_struct->persistentContent;
    displayName = SafeStringCopy(in_struct->displayName);
}

void safe_VkDisplayPropertiesKHR::initialize(const safe_VkDisplayPropertiesKHR* copy_src)
{
    display = copy_src->display;
    physicalDimensions = copy_src->physicalDimensions;
    physicalResolution = copy_src->physicalResolution;
    supportedTransforms = copy_src->supportedTransforms;
    planeReorderPossible = copy_src->planeReorderPossible;
    persistentContent = copy_src->persistentContent;
    displayName = SafeStringCopy(copy_src->displayName);
}

safe_VkDisplaySurfaceCreateInfoKHR::safe_VkDisplaySurfaceCreateInfoKHR(const VkDisplaySurfaceCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    displayMode(in_struct->displayMode),
    planeIndex(in_struct->planeIndex),
    planeStackIndex(in_struct->planeStackIndex),
    transform(in_struct->transform),
    globalAlpha(in_struct->globalAlpha),
    alphaMode(in_struct->alphaMode),
    imageExtent(in_struct->imageExtent)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplaySurfaceCreateInfoKHR::safe_VkDisplaySurfaceCreateInfoKHR() :
    sType(VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkDisplaySurfaceCreateInfoKHR::safe_VkDisplaySurfaceCreateInfoKHR(const safe_VkDisplaySurfaceCreateInfoKHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    displayMode = copy_src.displayMode;
    planeIndex = copy_src.planeIndex;
    planeStackIndex = copy_src.planeStackIndex;
    transform = copy_src.transform;
    globalAlpha = copy_src.globalAlpha;
    alphaMode = copy_src.alphaMode;
    imageExtent = copy_src.imageExtent;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDisplaySurfaceCreateInfoKHR& safe_VkDisplaySurfaceCreateInfoKHR::operator=(const safe_VkDisplaySurfaceCreateInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    displayMode = copy_src.displayMode;
    planeIndex = copy_src.planeIndex;
    planeStackIndex = copy_src.planeStackIndex;
    transform = copy_src.transform;
    globalAlpha = copy_src.globalAlpha;
    alphaMode = copy_src.alphaMode;
    imageExtent = copy_src.imageExtent;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDisplaySurfaceCreateInfoKHR::~safe_VkDisplaySurfaceCreateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplaySurfaceCreateInfoKHR::initialize(const VkDisplaySurfaceCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    displayMode = in_struct->displayMode;
    planeIndex = in_struct->planeIndex;
    planeStackIndex = in_struct->planeStackIndex;
    transform = in_struct->transform;
    globalAlpha = in_struct->globalAlpha;
    alphaMode = in_struct->alphaMode;
    imageExtent = in_struct->imageExtent;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplaySurfaceCreateInfoKHR::initialize(const safe_VkDisplaySurfaceCreateInfoKHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    displayMode = copy_src->displayMode;
    planeIndex = copy_src->planeIndex;
    planeStackIndex = copy_src->planeStackIndex;
    transform = copy_src->transform;
    globalAlpha = copy_src->globalAlpha;
    alphaMode = copy_src->alphaMode;
    imageExtent = copy_src->imageExtent;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDisplayPresentInfoKHR::safe_VkDisplayPresentInfoKHR(const VkDisplayPresentInfoKHR* in_struct) :
    sType(in_struct->sType),
    srcRect(in_struct->srcRect),
    dstRect(in_struct->dstRect),
    persistent(in_struct->persistent)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayPresentInfoKHR::safe_VkDisplayPresentInfoKHR() :
    sType(VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR),
    pNext(nullptr)
{}

safe_VkDisplayPresentInfoKHR::safe_VkDisplayPresentInfoKHR(const safe_VkDisplayPresentInfoKHR& copy_src)
{
    sType = copy_src.sType;
    srcRect = copy_src.srcRect;
    dstRect = copy_src.dstRect;
    persistent = copy_src.persistent;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDisplayPresentInfoKHR& safe_VkDisplayPresentInfoKHR::operator=(const safe_VkDisplayPresentInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcRect = copy_src.srcRect;
    dstRect = copy_src.dstRect;
    persistent = copy_src.persistent;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDisplayPresentInfoKHR::~safe_VkDisplayPresentInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayPresentInfoKHR::initialize(const VkDisplayPresentInfoKHR* in_struct)
{
    sType = in_struct->sType;
    srcRect = in_struct->srcRect;
    dstRect = in_struct->dstRect;
    persistent = in_struct->persistent;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayPresentInfoKHR::initialize(const safe_VkDisplayPresentInfoKHR* copy_src)
{
    sType = copy_src->sType;
    srcRect = copy_src->srcRect;
    dstRect = copy_src->dstRect;
    persistent = copy_src->persistent;
    pNext = SafePnextCopy(copy_src->pNext);
}
#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoQueueFamilyProperties2KHR::safe_VkVideoQueueFamilyProperties2KHR(const VkVideoQueueFamilyProperties2KHR* in_struct) :
    sType(in_struct->sType),
    videoCodecOperations(in_struct->videoCodecOperations)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoQueueFamilyProperties2KHR::safe_VkVideoQueueFamilyProperties2KHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_QUEUE_FAMILY_PROPERTIES_2_KHR),
    pNext(nullptr)
{}

safe_VkVideoQueueFamilyProperties2KHR::safe_VkVideoQueueFamilyProperties2KHR(const safe_VkVideoQueueFamilyProperties2KHR& copy_src)
{
    sType = copy_src.sType;
    videoCodecOperations = copy_src.videoCodecOperations;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoQueueFamilyProperties2KHR& safe_VkVideoQueueFamilyProperties2KHR::operator=(const safe_VkVideoQueueFamilyProperties2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    videoCodecOperations = copy_src.videoCodecOperations;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoQueueFamilyProperties2KHR::~safe_VkVideoQueueFamilyProperties2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoQueueFamilyProperties2KHR::initialize(const VkVideoQueueFamilyProperties2KHR* in_struct)
{
    sType = in_struct->sType;
    videoCodecOperations = in_struct->videoCodecOperations;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoQueueFamilyProperties2KHR::initialize(const safe_VkVideoQueueFamilyProperties2KHR* copy_src)
{
    sType = copy_src->sType;
    videoCodecOperations = copy_src->videoCodecOperations;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoProfileKHR::safe_VkVideoProfileKHR(const VkVideoProfileKHR* in_struct) :
    sType(in_struct->sType),
    videoCodecOperation(in_struct->videoCodecOperation),
    chromaSubsampling(in_struct->chromaSubsampling),
    lumaBitDepth(in_struct->lumaBitDepth),
    chromaBitDepth(in_struct->chromaBitDepth)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoProfileKHR::safe_VkVideoProfileKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_PROFILE_KHR),
    pNext(nullptr)
{}

safe_VkVideoProfileKHR::safe_VkVideoProfileKHR(const safe_VkVideoProfileKHR& copy_src)
{
    sType = copy_src.sType;
    videoCodecOperation = copy_src.videoCodecOperation;
    chromaSubsampling = copy_src.chromaSubsampling;
    lumaBitDepth = copy_src.lumaBitDepth;
    chromaBitDepth = copy_src.chromaBitDepth;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoProfileKHR& safe_VkVideoProfileKHR::operator=(const safe_VkVideoProfileKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    videoCodecOperation = copy_src.videoCodecOperation;
    chromaSubsampling = copy_src.chromaSubsampling;
    lumaBitDepth = copy_src.lumaBitDepth;
    chromaBitDepth = copy_src.chromaBitDepth;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoProfileKHR::~safe_VkVideoProfileKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoProfileKHR::initialize(const VkVideoProfileKHR* in_struct)
{
    sType = in_struct->sType;
    videoCodecOperation = in_struct->videoCodecOperation;
    chromaSubsampling = in_struct->chromaSubsampling;
    lumaBitDepth = in_struct->lumaBitDepth;
    chromaBitDepth = in_struct->chromaBitDepth;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoProfileKHR::initialize(const safe_VkVideoProfileKHR* copy_src)
{
    sType = copy_src->sType;
    videoCodecOperation = copy_src->videoCodecOperation;
    chromaSubsampling = copy_src->chromaSubsampling;
    lumaBitDepth = copy_src->lumaBitDepth;
    chromaBitDepth = copy_src->chromaBitDepth;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoProfilesKHR::safe_VkVideoProfilesKHR(const VkVideoProfilesKHR* in_struct) :
    sType(in_struct->sType),
    profileCount(in_struct->profileCount),
    pProfiles(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pProfiles)
        pProfiles = new safe_VkVideoProfileKHR(in_struct->pProfiles);
}

safe_VkVideoProfilesKHR::safe_VkVideoProfilesKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_PROFILES_KHR),
    pNext(nullptr),
    pProfiles(nullptr)
{}

safe_VkVideoProfilesKHR::safe_VkVideoProfilesKHR(const safe_VkVideoProfilesKHR& copy_src)
{
    sType = copy_src.sType;
    profileCount = copy_src.profileCount;
    pProfiles = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pProfiles)
        pProfiles = new safe_VkVideoProfileKHR(*copy_src.pProfiles);
}

safe_VkVideoProfilesKHR& safe_VkVideoProfilesKHR::operator=(const safe_VkVideoProfilesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pProfiles)
        delete pProfiles;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    profileCount = copy_src.profileCount;
    pProfiles = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pProfiles)
        pProfiles = new safe_VkVideoProfileKHR(*copy_src.pProfiles);

    return *this;
}

safe_VkVideoProfilesKHR::~safe_VkVideoProfilesKHR()
{
    if (pProfiles)
        delete pProfiles;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoProfilesKHR::initialize(const VkVideoProfilesKHR* in_struct)
{
    sType = in_struct->sType;
    profileCount = in_struct->profileCount;
    pProfiles = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pProfiles)
        pProfiles = new safe_VkVideoProfileKHR(in_struct->pProfiles);
}

void safe_VkVideoProfilesKHR::initialize(const safe_VkVideoProfilesKHR* copy_src)
{
    sType = copy_src->sType;
    profileCount = copy_src->profileCount;
    pProfiles = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pProfiles)
        pProfiles = new safe_VkVideoProfileKHR(*copy_src->pProfiles);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoCapabilitiesKHR::safe_VkVideoCapabilitiesKHR(const VkVideoCapabilitiesKHR* in_struct) :
    sType(in_struct->sType),
    capabilityFlags(in_struct->capabilityFlags),
    minBitstreamBufferOffsetAlignment(in_struct->minBitstreamBufferOffsetAlignment),
    minBitstreamBufferSizeAlignment(in_struct->minBitstreamBufferSizeAlignment),
    videoPictureExtentGranularity(in_struct->videoPictureExtentGranularity),
    minExtent(in_struct->minExtent),
    maxExtent(in_struct->maxExtent),
    maxReferencePicturesSlotsCount(in_struct->maxReferencePicturesSlotsCount),
    maxReferencePicturesActiveCount(in_struct->maxReferencePicturesActiveCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoCapabilitiesKHR::safe_VkVideoCapabilitiesKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR),
    pNext(nullptr)
{}

safe_VkVideoCapabilitiesKHR::safe_VkVideoCapabilitiesKHR(const safe_VkVideoCapabilitiesKHR& copy_src)
{
    sType = copy_src.sType;
    capabilityFlags = copy_src.capabilityFlags;
    minBitstreamBufferOffsetAlignment = copy_src.minBitstreamBufferOffsetAlignment;
    minBitstreamBufferSizeAlignment = copy_src.minBitstreamBufferSizeAlignment;
    videoPictureExtentGranularity = copy_src.videoPictureExtentGranularity;
    minExtent = copy_src.minExtent;
    maxExtent = copy_src.maxExtent;
    maxReferencePicturesSlotsCount = copy_src.maxReferencePicturesSlotsCount;
    maxReferencePicturesActiveCount = copy_src.maxReferencePicturesActiveCount;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoCapabilitiesKHR& safe_VkVideoCapabilitiesKHR::operator=(const safe_VkVideoCapabilitiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    capabilityFlags = copy_src.capabilityFlags;
    minBitstreamBufferOffsetAlignment = copy_src.minBitstreamBufferOffsetAlignment;
    minBitstreamBufferSizeAlignment = copy_src.minBitstreamBufferSizeAlignment;
    videoPictureExtentGranularity = copy_src.videoPictureExtentGranularity;
    minExtent = copy_src.minExtent;
    maxExtent = copy_src.maxExtent;
    maxReferencePicturesSlotsCount = copy_src.maxReferencePicturesSlotsCount;
    maxReferencePicturesActiveCount = copy_src.maxReferencePicturesActiveCount;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoCapabilitiesKHR::~safe_VkVideoCapabilitiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoCapabilitiesKHR::initialize(const VkVideoCapabilitiesKHR* in_struct)
{
    sType = in_struct->sType;
    capabilityFlags = in_struct->capabilityFlags;
    minBitstreamBufferOffsetAlignment = in_struct->minBitstreamBufferOffsetAlignment;
    minBitstreamBufferSizeAlignment = in_struct->minBitstreamBufferSizeAlignment;
    videoPictureExtentGranularity = in_struct->videoPictureExtentGranularity;
    minExtent = in_struct->minExtent;
    maxExtent = in_struct->maxExtent;
    maxReferencePicturesSlotsCount = in_struct->maxReferencePicturesSlotsCount;
    maxReferencePicturesActiveCount = in_struct->maxReferencePicturesActiveCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoCapabilitiesKHR::initialize(const safe_VkVideoCapabilitiesKHR* copy_src)
{
    sType = copy_src->sType;
    capabilityFlags = copy_src->capabilityFlags;
    minBitstreamBufferOffsetAlignment = copy_src->minBitstreamBufferOffsetAlignment;
    minBitstreamBufferSizeAlignment = copy_src->minBitstreamBufferSizeAlignment;
    videoPictureExtentGranularity = copy_src->videoPictureExtentGranularity;
    minExtent = copy_src->minExtent;
    maxExtent = copy_src->maxExtent;
    maxReferencePicturesSlotsCount = copy_src->maxReferencePicturesSlotsCount;
    maxReferencePicturesActiveCount = copy_src->maxReferencePicturesActiveCount;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkPhysicalDeviceVideoFormatInfoKHR::safe_VkPhysicalDeviceVideoFormatInfoKHR(const VkPhysicalDeviceVideoFormatInfoKHR* in_struct) :
    sType(in_struct->sType),
    imageUsage(in_struct->imageUsage),
    pVideoProfiles(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pVideoProfiles)
        pVideoProfiles = new safe_VkVideoProfilesKHR(in_struct->pVideoProfiles);
}

safe_VkPhysicalDeviceVideoFormatInfoKHR::safe_VkPhysicalDeviceVideoFormatInfoKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR),
    pNext(nullptr),
    pVideoProfiles(nullptr)
{}

safe_VkPhysicalDeviceVideoFormatInfoKHR::safe_VkPhysicalDeviceVideoFormatInfoKHR(const safe_VkPhysicalDeviceVideoFormatInfoKHR& copy_src)
{
    sType = copy_src.sType;
    imageUsage = copy_src.imageUsage;
    pVideoProfiles = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pVideoProfiles)
        pVideoProfiles = new safe_VkVideoProfilesKHR(*copy_src.pVideoProfiles);
}

safe_VkPhysicalDeviceVideoFormatInfoKHR& safe_VkPhysicalDeviceVideoFormatInfoKHR::operator=(const safe_VkPhysicalDeviceVideoFormatInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pVideoProfiles)
        delete pVideoProfiles;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    imageUsage = copy_src.imageUsage;
    pVideoProfiles = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pVideoProfiles)
        pVideoProfiles = new safe_VkVideoProfilesKHR(*copy_src.pVideoProfiles);

    return *this;
}

safe_VkPhysicalDeviceVideoFormatInfoKHR::~safe_VkPhysicalDeviceVideoFormatInfoKHR()
{
    if (pVideoProfiles)
        delete pVideoProfiles;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceVideoFormatInfoKHR::initialize(const VkPhysicalDeviceVideoFormatInfoKHR* in_struct)
{
    sType = in_struct->sType;
    imageUsage = in_struct->imageUsage;
    pVideoProfiles = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pVideoProfiles)
        pVideoProfiles = new safe_VkVideoProfilesKHR(in_struct->pVideoProfiles);
}

void safe_VkPhysicalDeviceVideoFormatInfoKHR::initialize(const safe_VkPhysicalDeviceVideoFormatInfoKHR* copy_src)
{
    sType = copy_src->sType;
    imageUsage = copy_src->imageUsage;
    pVideoProfiles = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pVideoProfiles)
        pVideoProfiles = new safe_VkVideoProfilesKHR(*copy_src->pVideoProfiles);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoFormatPropertiesKHR::safe_VkVideoFormatPropertiesKHR(const VkVideoFormatPropertiesKHR* in_struct) :
    sType(in_struct->sType),
    format(in_struct->format)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoFormatPropertiesKHR::safe_VkVideoFormatPropertiesKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR),
    pNext(nullptr)
{}

safe_VkVideoFormatPropertiesKHR::safe_VkVideoFormatPropertiesKHR(const safe_VkVideoFormatPropertiesKHR& copy_src)
{
    sType = copy_src.sType;
    format = copy_src.format;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoFormatPropertiesKHR& safe_VkVideoFormatPropertiesKHR::operator=(const safe_VkVideoFormatPropertiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    format = copy_src.format;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoFormatPropertiesKHR::~safe_VkVideoFormatPropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoFormatPropertiesKHR::initialize(const VkVideoFormatPropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    format = in_struct->format;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoFormatPropertiesKHR::initialize(const safe_VkVideoFormatPropertiesKHR* copy_src)
{
    sType = copy_src->sType;
    format = copy_src->format;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoPictureResourceKHR::safe_VkVideoPictureResourceKHR(const VkVideoPictureResourceKHR* in_struct) :
    sType(in_struct->sType),
    codedOffset(in_struct->codedOffset),
    codedExtent(in_struct->codedExtent),
    baseArrayLayer(in_struct->baseArrayLayer),
    imageViewBinding(in_struct->imageViewBinding)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoPictureResourceKHR::safe_VkVideoPictureResourceKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_KHR),
    pNext(nullptr)
{}

safe_VkVideoPictureResourceKHR::safe_VkVideoPictureResourceKHR(const safe_VkVideoPictureResourceKHR& copy_src)
{
    sType = copy_src.sType;
    codedOffset = copy_src.codedOffset;
    codedExtent = copy_src.codedExtent;
    baseArrayLayer = copy_src.baseArrayLayer;
    imageViewBinding = copy_src.imageViewBinding;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoPictureResourceKHR& safe_VkVideoPictureResourceKHR::operator=(const safe_VkVideoPictureResourceKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    codedOffset = copy_src.codedOffset;
    codedExtent = copy_src.codedExtent;
    baseArrayLayer = copy_src.baseArrayLayer;
    imageViewBinding = copy_src.imageViewBinding;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoPictureResourceKHR::~safe_VkVideoPictureResourceKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoPictureResourceKHR::initialize(const VkVideoPictureResourceKHR* in_struct)
{
    sType = in_struct->sType;
    codedOffset = in_struct->codedOffset;
    codedExtent = in_struct->codedExtent;
    baseArrayLayer = in_struct->baseArrayLayer;
    imageViewBinding = in_struct->imageViewBinding;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoPictureResourceKHR::initialize(const safe_VkVideoPictureResourceKHR* copy_src)
{
    sType = copy_src->sType;
    codedOffset = copy_src->codedOffset;
    codedExtent = copy_src->codedExtent;
    baseArrayLayer = copy_src->baseArrayLayer;
    imageViewBinding = copy_src->imageViewBinding;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoReferenceSlotKHR::safe_VkVideoReferenceSlotKHR(const VkVideoReferenceSlotKHR* in_struct) :
    sType(in_struct->sType),
    slotIndex(in_struct->slotIndex),
    pPictureResource(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPictureResource)
        pPictureResource = new safe_VkVideoPictureResourceKHR(in_struct->pPictureResource);
}

safe_VkVideoReferenceSlotKHR::safe_VkVideoReferenceSlotKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_KHR),
    pNext(nullptr),
    pPictureResource(nullptr)
{}

safe_VkVideoReferenceSlotKHR::safe_VkVideoReferenceSlotKHR(const safe_VkVideoReferenceSlotKHR& copy_src)
{
    sType = copy_src.sType;
    slotIndex = copy_src.slotIndex;
    pPictureResource = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pPictureResource)
        pPictureResource = new safe_VkVideoPictureResourceKHR(*copy_src.pPictureResource);
}

safe_VkVideoReferenceSlotKHR& safe_VkVideoReferenceSlotKHR::operator=(const safe_VkVideoReferenceSlotKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pPictureResource)
        delete pPictureResource;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    slotIndex = copy_src.slotIndex;
    pPictureResource = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pPictureResource)
        pPictureResource = new safe_VkVideoPictureResourceKHR(*copy_src.pPictureResource);

    return *this;
}

safe_VkVideoReferenceSlotKHR::~safe_VkVideoReferenceSlotKHR()
{
    if (pPictureResource)
        delete pPictureResource;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoReferenceSlotKHR::initialize(const VkVideoReferenceSlotKHR* in_struct)
{
    sType = in_struct->sType;
    slotIndex = in_struct->slotIndex;
    pPictureResource = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPictureResource)
        pPictureResource = new safe_VkVideoPictureResourceKHR(in_struct->pPictureResource);
}

void safe_VkVideoReferenceSlotKHR::initialize(const safe_VkVideoReferenceSlotKHR* copy_src)
{
    sType = copy_src->sType;
    slotIndex = copy_src->slotIndex;
    pPictureResource = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pPictureResource)
        pPictureResource = new safe_VkVideoPictureResourceKHR(*copy_src->pPictureResource);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoGetMemoryPropertiesKHR::safe_VkVideoGetMemoryPropertiesKHR(const VkVideoGetMemoryPropertiesKHR* in_struct) :
    sType(in_struct->sType),
    memoryBindIndex(in_struct->memoryBindIndex),
    pMemoryRequirements(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pMemoryRequirements)
        pMemoryRequirements = new safe_VkMemoryRequirements2(in_struct->pMemoryRequirements);
}

safe_VkVideoGetMemoryPropertiesKHR::safe_VkVideoGetMemoryPropertiesKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_GET_MEMORY_PROPERTIES_KHR),
    pNext(nullptr),
    pMemoryRequirements(nullptr)
{}

safe_VkVideoGetMemoryPropertiesKHR::safe_VkVideoGetMemoryPropertiesKHR(const safe_VkVideoGetMemoryPropertiesKHR& copy_src)
{
    sType = copy_src.sType;
    memoryBindIndex = copy_src.memoryBindIndex;
    pMemoryRequirements = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pMemoryRequirements)
        pMemoryRequirements = new safe_VkMemoryRequirements2(*copy_src.pMemoryRequirements);
}

safe_VkVideoGetMemoryPropertiesKHR& safe_VkVideoGetMemoryPropertiesKHR::operator=(const safe_VkVideoGetMemoryPropertiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pMemoryRequirements)
        delete pMemoryRequirements;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    memoryBindIndex = copy_src.memoryBindIndex;
    pMemoryRequirements = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pMemoryRequirements)
        pMemoryRequirements = new safe_VkMemoryRequirements2(*copy_src.pMemoryRequirements);

    return *this;
}

safe_VkVideoGetMemoryPropertiesKHR::~safe_VkVideoGetMemoryPropertiesKHR()
{
    if (pMemoryRequirements)
        delete pMemoryRequirements;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoGetMemoryPropertiesKHR::initialize(const VkVideoGetMemoryPropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    memoryBindIndex = in_struct->memoryBindIndex;
    pMemoryRequirements = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pMemoryRequirements)
        pMemoryRequirements = new safe_VkMemoryRequirements2(in_struct->pMemoryRequirements);
}

void safe_VkVideoGetMemoryPropertiesKHR::initialize(const safe_VkVideoGetMemoryPropertiesKHR* copy_src)
{
    sType = copy_src->sType;
    memoryBindIndex = copy_src->memoryBindIndex;
    pMemoryRequirements = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pMemoryRequirements)
        pMemoryRequirements = new safe_VkMemoryRequirements2(*copy_src->pMemoryRequirements);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoBindMemoryKHR::safe_VkVideoBindMemoryKHR(const VkVideoBindMemoryKHR* in_struct) :
    sType(in_struct->sType),
    memoryBindIndex(in_struct->memoryBindIndex),
    memory(in_struct->memory),
    memoryOffset(in_struct->memoryOffset),
    memorySize(in_struct->memorySize)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoBindMemoryKHR::safe_VkVideoBindMemoryKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_BIND_MEMORY_KHR),
    pNext(nullptr)
{}

safe_VkVideoBindMemoryKHR::safe_VkVideoBindMemoryKHR(const safe_VkVideoBindMemoryKHR& copy_src)
{
    sType = copy_src.sType;
    memoryBindIndex = copy_src.memoryBindIndex;
    memory = copy_src.memory;
    memoryOffset = copy_src.memoryOffset;
    memorySize = copy_src.memorySize;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoBindMemoryKHR& safe_VkVideoBindMemoryKHR::operator=(const safe_VkVideoBindMemoryKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    memoryBindIndex = copy_src.memoryBindIndex;
    memory = copy_src.memory;
    memoryOffset = copy_src.memoryOffset;
    memorySize = copy_src.memorySize;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoBindMemoryKHR::~safe_VkVideoBindMemoryKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoBindMemoryKHR::initialize(const VkVideoBindMemoryKHR* in_struct)
{
    sType = in_struct->sType;
    memoryBindIndex = in_struct->memoryBindIndex;
    memory = in_struct->memory;
    memoryOffset = in_struct->memoryOffset;
    memorySize = in_struct->memorySize;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoBindMemoryKHR::initialize(const safe_VkVideoBindMemoryKHR* copy_src)
{
    sType = copy_src->sType;
    memoryBindIndex = copy_src->memoryBindIndex;
    memory = copy_src->memory;
    memoryOffset = copy_src->memoryOffset;
    memorySize = copy_src->memorySize;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoSessionCreateInfoKHR::safe_VkVideoSessionCreateInfoKHR(const VkVideoSessionCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    queueFamilyIndex(in_struct->queueFamilyIndex),
    flags(in_struct->flags),
    pVideoProfile(nullptr),
    pictureFormat(in_struct->pictureFormat),
    maxCodedExtent(in_struct->maxCodedExtent),
    referencePicturesFormat(in_struct->referencePicturesFormat),
    maxReferencePicturesSlotsCount(in_struct->maxReferencePicturesSlotsCount),
    maxReferencePicturesActiveCount(in_struct->maxReferencePicturesActiveCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pVideoProfile)
        pVideoProfile = new safe_VkVideoProfileKHR(in_struct->pVideoProfile);
}

safe_VkVideoSessionCreateInfoKHR::safe_VkVideoSessionCreateInfoKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR),
    pNext(nullptr),
    pVideoProfile(nullptr)
{}

safe_VkVideoSessionCreateInfoKHR::safe_VkVideoSessionCreateInfoKHR(const safe_VkVideoSessionCreateInfoKHR& copy_src)
{
    sType = copy_src.sType;
    queueFamilyIndex = copy_src.queueFamilyIndex;
    flags = copy_src.flags;
    pVideoProfile = nullptr;
    pictureFormat = copy_src.pictureFormat;
    maxCodedExtent = copy_src.maxCodedExtent;
    referencePicturesFormat = copy_src.referencePicturesFormat;
    maxReferencePicturesSlotsCount = copy_src.maxReferencePicturesSlotsCount;
    maxReferencePicturesActiveCount = copy_src.maxReferencePicturesActiveCount;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pVideoProfile)
        pVideoProfile = new safe_VkVideoProfileKHR(*copy_src.pVideoProfile);
}

safe_VkVideoSessionCreateInfoKHR& safe_VkVideoSessionCreateInfoKHR::operator=(const safe_VkVideoSessionCreateInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pVideoProfile)
        delete pVideoProfile;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    queueFamilyIndex = copy_src.queueFamilyIndex;
    flags = copy_src.flags;
    pVideoProfile = nullptr;
    pictureFormat = copy_src.pictureFormat;
    maxCodedExtent = copy_src.maxCodedExtent;
    referencePicturesFormat = copy_src.referencePicturesFormat;
    maxReferencePicturesSlotsCount = copy_src.maxReferencePicturesSlotsCount;
    maxReferencePicturesActiveCount = copy_src.maxReferencePicturesActiveCount;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pVideoProfile)
        pVideoProfile = new safe_VkVideoProfileKHR(*copy_src.pVideoProfile);

    return *this;
}

safe_VkVideoSessionCreateInfoKHR::~safe_VkVideoSessionCreateInfoKHR()
{
    if (pVideoProfile)
        delete pVideoProfile;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoSessionCreateInfoKHR::initialize(const VkVideoSessionCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    queueFamilyIndex = in_struct->queueFamilyIndex;
    flags = in_struct->flags;
    pVideoProfile = nullptr;
    pictureFormat = in_struct->pictureFormat;
    maxCodedExtent = in_struct->maxCodedExtent;
    referencePicturesFormat = in_struct->referencePicturesFormat;
    maxReferencePicturesSlotsCount = in_struct->maxReferencePicturesSlotsCount;
    maxReferencePicturesActiveCount = in_struct->maxReferencePicturesActiveCount;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pVideoProfile)
        pVideoProfile = new safe_VkVideoProfileKHR(in_struct->pVideoProfile);
}

void safe_VkVideoSessionCreateInfoKHR::initialize(const safe_VkVideoSessionCreateInfoKHR* copy_src)
{
    sType = copy_src->sType;
    queueFamilyIndex = copy_src->queueFamilyIndex;
    flags = copy_src->flags;
    pVideoProfile = nullptr;
    pictureFormat = copy_src->pictureFormat;
    maxCodedExtent = copy_src->maxCodedExtent;
    referencePicturesFormat = copy_src->referencePicturesFormat;
    maxReferencePicturesSlotsCount = copy_src->maxReferencePicturesSlotsCount;
    maxReferencePicturesActiveCount = copy_src->maxReferencePicturesActiveCount;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pVideoProfile)
        pVideoProfile = new safe_VkVideoProfileKHR(*copy_src->pVideoProfile);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoSessionParametersCreateInfoKHR::safe_VkVideoSessionParametersCreateInfoKHR(const VkVideoSessionParametersCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    videoSessionParametersTemplate(in_struct->videoSessionParametersTemplate),
    videoSession(in_struct->videoSession)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoSessionParametersCreateInfoKHR::safe_VkVideoSessionParametersCreateInfoKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkVideoSessionParametersCreateInfoKHR::safe_VkVideoSessionParametersCreateInfoKHR(const safe_VkVideoSessionParametersCreateInfoKHR& copy_src)
{
    sType = copy_src.sType;
    videoSessionParametersTemplate = copy_src.videoSessionParametersTemplate;
    videoSession = copy_src.videoSession;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoSessionParametersCreateInfoKHR& safe_VkVideoSessionParametersCreateInfoKHR::operator=(const safe_VkVideoSessionParametersCreateInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    videoSessionParametersTemplate = copy_src.videoSessionParametersTemplate;
    videoSession = copy_src.videoSession;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoSessionParametersCreateInfoKHR::~safe_VkVideoSessionParametersCreateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoSessionParametersCreateInfoKHR::initialize(const VkVideoSessionParametersCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    videoSessionParametersTemplate = in_struct->videoSessionParametersTemplate;
    videoSession = in_struct->videoSession;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoSessionParametersCreateInfoKHR::initialize(const safe_VkVideoSessionParametersCreateInfoKHR* copy_src)
{
    sType = copy_src->sType;
    videoSessionParametersTemplate = copy_src->videoSessionParametersTemplate;
    videoSession = copy_src->videoSession;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoSessionParametersUpdateInfoKHR::safe_VkVideoSessionParametersUpdateInfoKHR(const VkVideoSessionParametersUpdateInfoKHR* in_struct) :
    sType(in_struct->sType),
    updateSequenceCount(in_struct->updateSequenceCount)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoSessionParametersUpdateInfoKHR::safe_VkVideoSessionParametersUpdateInfoKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkVideoSessionParametersUpdateInfoKHR::safe_VkVideoSessionParametersUpdateInfoKHR(const safe_VkVideoSessionParametersUpdateInfoKHR& copy_src)
{
    sType = copy_src.sType;
    updateSequenceCount = copy_src.updateSequenceCount;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoSessionParametersUpdateInfoKHR& safe_VkVideoSessionParametersUpdateInfoKHR::operator=(const safe_VkVideoSessionParametersUpdateInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    updateSequenceCount = copy_src.updateSequenceCount;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoSessionParametersUpdateInfoKHR::~safe_VkVideoSessionParametersUpdateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoSessionParametersUpdateInfoKHR::initialize(const VkVideoSessionParametersUpdateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    updateSequenceCount = in_struct->updateSequenceCount;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoSessionParametersUpdateInfoKHR::initialize(const safe_VkVideoSessionParametersUpdateInfoKHR* copy_src)
{
    sType = copy_src->sType;
    updateSequenceCount = copy_src->updateSequenceCount;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoBeginCodingInfoKHR::safe_VkVideoBeginCodingInfoKHR(const VkVideoBeginCodingInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    codecQualityPreset(in_struct->codecQualityPreset),
    videoSession(in_struct->videoSession),
    videoSessionParameters(in_struct->videoSessionParameters),
    referenceSlotCount(in_struct->referenceSlotCount),
    pReferenceSlots(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (referenceSlotCount && in_struct->pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&in_struct->pReferenceSlots[i]);
        }
    }
}

safe_VkVideoBeginCodingInfoKHR::safe_VkVideoBeginCodingInfoKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR),
    pNext(nullptr),
    pReferenceSlots(nullptr)
{}

safe_VkVideoBeginCodingInfoKHR::safe_VkVideoBeginCodingInfoKHR(const safe_VkVideoBeginCodingInfoKHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    codecQualityPreset = copy_src.codecQualityPreset;
    videoSession = copy_src.videoSession;
    videoSessionParameters = copy_src.videoSessionParameters;
    referenceSlotCount = copy_src.referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (referenceSlotCount && copy_src.pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&copy_src.pReferenceSlots[i]);
        }
    }
}

safe_VkVideoBeginCodingInfoKHR& safe_VkVideoBeginCodingInfoKHR::operator=(const safe_VkVideoBeginCodingInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pReferenceSlots)
        delete[] pReferenceSlots;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    codecQualityPreset = copy_src.codecQualityPreset;
    videoSession = copy_src.videoSession;
    videoSessionParameters = copy_src.videoSessionParameters;
    referenceSlotCount = copy_src.referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (referenceSlotCount && copy_src.pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&copy_src.pReferenceSlots[i]);
        }
    }

    return *this;
}

safe_VkVideoBeginCodingInfoKHR::~safe_VkVideoBeginCodingInfoKHR()
{
    if (pReferenceSlots)
        delete[] pReferenceSlots;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoBeginCodingInfoKHR::initialize(const VkVideoBeginCodingInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    codecQualityPreset = in_struct->codecQualityPreset;
    videoSession = in_struct->videoSession;
    videoSessionParameters = in_struct->videoSessionParameters;
    referenceSlotCount = in_struct->referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (referenceSlotCount && in_struct->pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&in_struct->pReferenceSlots[i]);
        }
    }
}

void safe_VkVideoBeginCodingInfoKHR::initialize(const safe_VkVideoBeginCodingInfoKHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    codecQualityPreset = copy_src->codecQualityPreset;
    videoSession = copy_src->videoSession;
    videoSessionParameters = copy_src->videoSessionParameters;
    referenceSlotCount = copy_src->referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (referenceSlotCount && copy_src->pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&copy_src->pReferenceSlots[i]);
        }
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEndCodingInfoKHR::safe_VkVideoEndCodingInfoKHR(const VkVideoEndCodingInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoEndCodingInfoKHR::safe_VkVideoEndCodingInfoKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR),
    pNext(nullptr)
{}

safe_VkVideoEndCodingInfoKHR::safe_VkVideoEndCodingInfoKHR(const safe_VkVideoEndCodingInfoKHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoEndCodingInfoKHR& safe_VkVideoEndCodingInfoKHR::operator=(const safe_VkVideoEndCodingInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoEndCodingInfoKHR::~safe_VkVideoEndCodingInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEndCodingInfoKHR::initialize(const VkVideoEndCodingInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoEndCodingInfoKHR::initialize(const safe_VkVideoEndCodingInfoKHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoCodingControlInfoKHR::safe_VkVideoCodingControlInfoKHR(const VkVideoCodingControlInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoCodingControlInfoKHR::safe_VkVideoCodingControlInfoKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR),
    pNext(nullptr)
{}

safe_VkVideoCodingControlInfoKHR::safe_VkVideoCodingControlInfoKHR(const safe_VkVideoCodingControlInfoKHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoCodingControlInfoKHR& safe_VkVideoCodingControlInfoKHR::operator=(const safe_VkVideoCodingControlInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoCodingControlInfoKHR::~safe_VkVideoCodingControlInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoCodingControlInfoKHR::initialize(const VkVideoCodingControlInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoCodingControlInfoKHR::initialize(const safe_VkVideoCodingControlInfoKHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoDecodeInfoKHR::safe_VkVideoDecodeInfoKHR(const VkVideoDecodeInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    codedOffset(in_struct->codedOffset),
    codedExtent(in_struct->codedExtent),
    srcBuffer(in_struct->srcBuffer),
    srcBufferOffset(in_struct->srcBufferOffset),
    srcBufferRange(in_struct->srcBufferRange),
    dstPictureResource(&in_struct->dstPictureResource),
    pSetupReferenceSlot(nullptr),
    referenceSlotCount(in_struct->referenceSlotCount),
    pReferenceSlots(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSetupReferenceSlot)
        pSetupReferenceSlot = new safe_VkVideoReferenceSlotKHR(in_struct->pSetupReferenceSlot);
    if (referenceSlotCount && in_struct->pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&in_struct->pReferenceSlots[i]);
        }
    }
}

safe_VkVideoDecodeInfoKHR::safe_VkVideoDecodeInfoKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR),
    pNext(nullptr),
    pSetupReferenceSlot(nullptr),
    pReferenceSlots(nullptr)
{}

safe_VkVideoDecodeInfoKHR::safe_VkVideoDecodeInfoKHR(const safe_VkVideoDecodeInfoKHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    codedOffset = copy_src.codedOffset;
    codedExtent = copy_src.codedExtent;
    srcBuffer = copy_src.srcBuffer;
    srcBufferOffset = copy_src.srcBufferOffset;
    srcBufferRange = copy_src.srcBufferRange;
    dstPictureResource.initialize(&copy_src.dstPictureResource);
    pSetupReferenceSlot = nullptr;
    referenceSlotCount = copy_src.referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSetupReferenceSlot)
        pSetupReferenceSlot = new safe_VkVideoReferenceSlotKHR(*copy_src.pSetupReferenceSlot);
    if (referenceSlotCount && copy_src.pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&copy_src.pReferenceSlots[i]);
        }
    }
}

safe_VkVideoDecodeInfoKHR& safe_VkVideoDecodeInfoKHR::operator=(const safe_VkVideoDecodeInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pSetupReferenceSlot)
        delete pSetupReferenceSlot;
    if (pReferenceSlots)
        delete[] pReferenceSlots;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    codedOffset = copy_src.codedOffset;
    codedExtent = copy_src.codedExtent;
    srcBuffer = copy_src.srcBuffer;
    srcBufferOffset = copy_src.srcBufferOffset;
    srcBufferRange = copy_src.srcBufferRange;
    dstPictureResource.initialize(&copy_src.dstPictureResource);
    pSetupReferenceSlot = nullptr;
    referenceSlotCount = copy_src.referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSetupReferenceSlot)
        pSetupReferenceSlot = new safe_VkVideoReferenceSlotKHR(*copy_src.pSetupReferenceSlot);
    if (referenceSlotCount && copy_src.pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&copy_src.pReferenceSlots[i]);
        }
    }

    return *this;
}

safe_VkVideoDecodeInfoKHR::~safe_VkVideoDecodeInfoKHR()
{
    if (pSetupReferenceSlot)
        delete pSetupReferenceSlot;
    if (pReferenceSlots)
        delete[] pReferenceSlots;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoDecodeInfoKHR::initialize(const VkVideoDecodeInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    codedOffset = in_struct->codedOffset;
    codedExtent = in_struct->codedExtent;
    srcBuffer = in_struct->srcBuffer;
    srcBufferOffset = in_struct->srcBufferOffset;
    srcBufferRange = in_struct->srcBufferRange;
    dstPictureResource.initialize(&in_struct->dstPictureResource);
    pSetupReferenceSlot = nullptr;
    referenceSlotCount = in_struct->referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSetupReferenceSlot)
        pSetupReferenceSlot = new safe_VkVideoReferenceSlotKHR(in_struct->pSetupReferenceSlot);
    if (referenceSlotCount && in_struct->pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&in_struct->pReferenceSlots[i]);
        }
    }
}

void safe_VkVideoDecodeInfoKHR::initialize(const safe_VkVideoDecodeInfoKHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    codedOffset = copy_src->codedOffset;
    codedExtent = copy_src->codedExtent;
    srcBuffer = copy_src->srcBuffer;
    srcBufferOffset = copy_src->srcBufferOffset;
    srcBufferRange = copy_src->srcBufferRange;
    dstPictureResource.initialize(&copy_src->dstPictureResource);
    pSetupReferenceSlot = nullptr;
    referenceSlotCount = copy_src->referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pSetupReferenceSlot)
        pSetupReferenceSlot = new safe_VkVideoReferenceSlotKHR(*copy_src->pSetupReferenceSlot);
    if (referenceSlotCount && copy_src->pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&copy_src->pReferenceSlots[i]);
        }
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkImportMemoryWin32HandleInfoKHR::safe_VkImportMemoryWin32HandleInfoKHR(const VkImportMemoryWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType),
    handle(in_struct->handle),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportMemoryWin32HandleInfoKHR::safe_VkImportMemoryWin32HandleInfoKHR() :
    sType(VK_STRUCTURE_TYPE_IMPORT_MEMORY_WIN32_HANDLE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkImportMemoryWin32HandleInfoKHR::safe_VkImportMemoryWin32HandleInfoKHR(const safe_VkImportMemoryWin32HandleInfoKHR& copy_src)
{
    sType = copy_src.sType;
    handleType = copy_src.handleType;
    handle = copy_src.handle;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImportMemoryWin32HandleInfoKHR& safe_VkImportMemoryWin32HandleInfoKHR::operator=(const safe_VkImportMemoryWin32HandleInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    handleType = copy_src.handleType;
    handle = copy_src.handle;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImportMemoryWin32HandleInfoKHR::~safe_VkImportMemoryWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportMemoryWin32HandleInfoKHR::initialize(const VkImportMemoryWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    handle = in_struct->handle;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportMemoryWin32HandleInfoKHR::initialize(const safe_VkImportMemoryWin32HandleInfoKHR* copy_src)
{
    sType = copy_src->sType;
    handleType = copy_src->handleType;
    handle = copy_src->handle;
    name = copy_src->name;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkExportMemoryWin32HandleInfoKHR::safe_VkExportMemoryWin32HandleInfoKHR(const VkExportMemoryWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    pAttributes(nullptr),
    dwAccess(in_struct->dwAccess),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

safe_VkExportMemoryWin32HandleInfoKHR::safe_VkExportMemoryWin32HandleInfoKHR() :
    sType(VK_STRUCTURE_TYPE_EXPORT_MEMORY_WIN32_HANDLE_INFO_KHR),
    pNext(nullptr),
    pAttributes(nullptr)
{}

safe_VkExportMemoryWin32HandleInfoKHR::safe_VkExportMemoryWin32HandleInfoKHR(const safe_VkExportMemoryWin32HandleInfoKHR& copy_src)
{
    sType = copy_src.sType;
    pAttributes = nullptr;
    dwAccess = copy_src.dwAccess;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*copy_src.pAttributes);
    }
}

safe_VkExportMemoryWin32HandleInfoKHR& safe_VkExportMemoryWin32HandleInfoKHR::operator=(const safe_VkExportMemoryWin32HandleInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pAttributes = nullptr;
    dwAccess = copy_src.dwAccess;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*copy_src.pAttributes);
    }

    return *this;
}

safe_VkExportMemoryWin32HandleInfoKHR::~safe_VkExportMemoryWin32HandleInfoKHR()
{
    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportMemoryWin32HandleInfoKHR::initialize(const VkExportMemoryWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pAttributes = nullptr;
    dwAccess = in_struct->dwAccess;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

void safe_VkExportMemoryWin32HandleInfoKHR::initialize(const safe_VkExportMemoryWin32HandleInfoKHR* copy_src)
{
    sType = copy_src->sType;
    pAttributes = nullptr;
    dwAccess = copy_src->dwAccess;
    name = copy_src->name;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*copy_src->pAttributes);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkMemoryWin32HandlePropertiesKHR::safe_VkMemoryWin32HandlePropertiesKHR(const VkMemoryWin32HandlePropertiesKHR* in_struct) :
    sType(in_struct->sType),
    memoryTypeBits(in_struct->memoryTypeBits)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryWin32HandlePropertiesKHR::safe_VkMemoryWin32HandlePropertiesKHR() :
    sType(VK_STRUCTURE_TYPE_MEMORY_WIN32_HANDLE_PROPERTIES_KHR),
    pNext(nullptr)
{}

safe_VkMemoryWin32HandlePropertiesKHR::safe_VkMemoryWin32HandlePropertiesKHR(const safe_VkMemoryWin32HandlePropertiesKHR& copy_src)
{
    sType = copy_src.sType;
    memoryTypeBits = copy_src.memoryTypeBits;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryWin32HandlePropertiesKHR& safe_VkMemoryWin32HandlePropertiesKHR::operator=(const safe_VkMemoryWin32HandlePropertiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    memoryTypeBits = copy_src.memoryTypeBits;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryWin32HandlePropertiesKHR::~safe_VkMemoryWin32HandlePropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryWin32HandlePropertiesKHR::initialize(const VkMemoryWin32HandlePropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    memoryTypeBits = in_struct->memoryTypeBits;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryWin32HandlePropertiesKHR::initialize(const safe_VkMemoryWin32HandlePropertiesKHR* copy_src)
{
    sType = copy_src->sType;
    memoryTypeBits = copy_src->memoryTypeBits;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkMemoryGetWin32HandleInfoKHR::safe_VkMemoryGetWin32HandleInfoKHR(const VkMemoryGetWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    memory(in_struct->memory),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryGetWin32HandleInfoKHR::safe_VkMemoryGetWin32HandleInfoKHR() :
    sType(VK_STRUCTURE_TYPE_MEMORY_GET_WIN32_HANDLE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkMemoryGetWin32HandleInfoKHR::safe_VkMemoryGetWin32HandleInfoKHR(const safe_VkMemoryGetWin32HandleInfoKHR& copy_src)
{
    sType = copy_src.sType;
    memory = copy_src.memory;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryGetWin32HandleInfoKHR& safe_VkMemoryGetWin32HandleInfoKHR::operator=(const safe_VkMemoryGetWin32HandleInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    memory = copy_src.memory;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryGetWin32HandleInfoKHR::~safe_VkMemoryGetWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryGetWin32HandleInfoKHR::initialize(const VkMemoryGetWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    memory = in_struct->memory;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryGetWin32HandleInfoKHR::initialize(const safe_VkMemoryGetWin32HandleInfoKHR* copy_src)
{
    sType = copy_src->sType;
    memory = copy_src->memory;
    handleType = copy_src->handleType;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR


safe_VkImportMemoryFdInfoKHR::safe_VkImportMemoryFdInfoKHR(const VkImportMemoryFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    handleType(in_struct->handleType),
    fd(in_struct->fd)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportMemoryFdInfoKHR::safe_VkImportMemoryFdInfoKHR() :
    sType(VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR),
    pNext(nullptr)
{}

safe_VkImportMemoryFdInfoKHR::safe_VkImportMemoryFdInfoKHR(const safe_VkImportMemoryFdInfoKHR& copy_src)
{
    sType = copy_src.sType;
    handleType = copy_src.handleType;
    fd = copy_src.fd;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImportMemoryFdInfoKHR& safe_VkImportMemoryFdInfoKHR::operator=(const safe_VkImportMemoryFdInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    handleType = copy_src.handleType;
    fd = copy_src.fd;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImportMemoryFdInfoKHR::~safe_VkImportMemoryFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportMemoryFdInfoKHR::initialize(const VkImportMemoryFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    handleType = in_struct->handleType;
    fd = in_struct->fd;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportMemoryFdInfoKHR::initialize(const safe_VkImportMemoryFdInfoKHR* copy_src)
{
    sType = copy_src->sType;
    handleType = copy_src->handleType;
    fd = copy_src->fd;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkMemoryFdPropertiesKHR::safe_VkMemoryFdPropertiesKHR(const VkMemoryFdPropertiesKHR* in_struct) :
    sType(in_struct->sType),
    memoryTypeBits(in_struct->memoryTypeBits)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryFdPropertiesKHR::safe_VkMemoryFdPropertiesKHR() :
    sType(VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR),
    pNext(nullptr)
{}

safe_VkMemoryFdPropertiesKHR::safe_VkMemoryFdPropertiesKHR(const safe_VkMemoryFdPropertiesKHR& copy_src)
{
    sType = copy_src.sType;
    memoryTypeBits = copy_src.memoryTypeBits;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryFdPropertiesKHR& safe_VkMemoryFdPropertiesKHR::operator=(const safe_VkMemoryFdPropertiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    memoryTypeBits = copy_src.memoryTypeBits;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryFdPropertiesKHR::~safe_VkMemoryFdPropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryFdPropertiesKHR::initialize(const VkMemoryFdPropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    memoryTypeBits = in_struct->memoryTypeBits;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryFdPropertiesKHR::initialize(const safe_VkMemoryFdPropertiesKHR* copy_src)
{
    sType = copy_src->sType;
    memoryTypeBits = copy_src->memoryTypeBits;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkMemoryGetFdInfoKHR::safe_VkMemoryGetFdInfoKHR(const VkMemoryGetFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    memory(in_struct->memory),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryGetFdInfoKHR::safe_VkMemoryGetFdInfoKHR() :
    sType(VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR),
    pNext(nullptr)
{}

safe_VkMemoryGetFdInfoKHR::safe_VkMemoryGetFdInfoKHR(const safe_VkMemoryGetFdInfoKHR& copy_src)
{
    sType = copy_src.sType;
    memory = copy_src.memory;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryGetFdInfoKHR& safe_VkMemoryGetFdInfoKHR::operator=(const safe_VkMemoryGetFdInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    memory = copy_src.memory;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryGetFdInfoKHR::~safe_VkMemoryGetFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryGetFdInfoKHR::initialize(const VkMemoryGetFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    memory = in_struct->memory;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryGetFdInfoKHR::initialize(const safe_VkMemoryGetFdInfoKHR* copy_src)
{
    sType = copy_src->sType;
    memory = copy_src->memory;
    handleType = copy_src->handleType;
    pNext = SafePnextCopy(copy_src->pNext);
}
#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::safe_VkWin32KeyedMutexAcquireReleaseInfoKHR(const VkWin32KeyedMutexAcquireReleaseInfoKHR* in_struct) :
    sType(in_struct->sType),
    acquireCount(in_struct->acquireCount),
    pAcquireSyncs(nullptr),
    pAcquireKeys(nullptr),
    pAcquireTimeouts(nullptr),
    releaseCount(in_struct->releaseCount),
    pReleaseSyncs(nullptr),
    pReleaseKeys(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (acquireCount && in_struct->pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = in_struct->pAcquireSyncs[i];
        }
    }
    if (in_struct->pAcquireKeys) {
        pAcquireKeys = new uint64_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)in_struct->pAcquireKeys, sizeof(uint64_t)*in_struct->acquireCount);
    }
    if (in_struct->pAcquireTimeouts) {
        pAcquireTimeouts = new uint32_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireTimeouts, (void *)in_struct->pAcquireTimeouts, sizeof(uint32_t)*in_struct->acquireCount);
    }
    if (releaseCount && in_struct->pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = in_struct->pReleaseSyncs[i];
        }
    }
    if (in_struct->pReleaseKeys) {
        pReleaseKeys = new uint64_t[in_struct->releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)in_struct->pReleaseKeys, sizeof(uint64_t)*in_struct->releaseCount);
    }
}

safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::safe_VkWin32KeyedMutexAcquireReleaseInfoKHR() :
    sType(VK_STRUCTURE_TYPE_WIN32_KEYED_MUTEX_ACQUIRE_RELEASE_INFO_KHR),
    pNext(nullptr),
    pAcquireSyncs(nullptr),
    pAcquireKeys(nullptr),
    pAcquireTimeouts(nullptr),
    pReleaseSyncs(nullptr),
    pReleaseKeys(nullptr)
{}

safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::safe_VkWin32KeyedMutexAcquireReleaseInfoKHR(const safe_VkWin32KeyedMutexAcquireReleaseInfoKHR& copy_src)
{
    sType = copy_src.sType;
    acquireCount = copy_src.acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeouts = nullptr;
    releaseCount = copy_src.releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (acquireCount && copy_src.pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = copy_src.pAcquireSyncs[i];
        }
    }
    if (copy_src.pAcquireKeys) {
        pAcquireKeys = new uint64_t[copy_src.acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)copy_src.pAcquireKeys, sizeof(uint64_t)*copy_src.acquireCount);
    }
    if (copy_src.pAcquireTimeouts) {
        pAcquireTimeouts = new uint32_t[copy_src.acquireCount];
        memcpy ((void *)pAcquireTimeouts, (void *)copy_src.pAcquireTimeouts, sizeof(uint32_t)*copy_src.acquireCount);
    }
    if (releaseCount && copy_src.pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = copy_src.pReleaseSyncs[i];
        }
    }
    if (copy_src.pReleaseKeys) {
        pReleaseKeys = new uint64_t[copy_src.releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)copy_src.pReleaseKeys, sizeof(uint64_t)*copy_src.releaseCount);
    }
}

safe_VkWin32KeyedMutexAcquireReleaseInfoKHR& safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::operator=(const safe_VkWin32KeyedMutexAcquireReleaseInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pAcquireSyncs)
        delete[] pAcquireSyncs;
    if (pAcquireKeys)
        delete[] pAcquireKeys;
    if (pAcquireTimeouts)
        delete[] pAcquireTimeouts;
    if (pReleaseSyncs)
        delete[] pReleaseSyncs;
    if (pReleaseKeys)
        delete[] pReleaseKeys;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    acquireCount = copy_src.acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeouts = nullptr;
    releaseCount = copy_src.releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (acquireCount && copy_src.pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = copy_src.pAcquireSyncs[i];
        }
    }
    if (copy_src.pAcquireKeys) {
        pAcquireKeys = new uint64_t[copy_src.acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)copy_src.pAcquireKeys, sizeof(uint64_t)*copy_src.acquireCount);
    }
    if (copy_src.pAcquireTimeouts) {
        pAcquireTimeouts = new uint32_t[copy_src.acquireCount];
        memcpy ((void *)pAcquireTimeouts, (void *)copy_src.pAcquireTimeouts, sizeof(uint32_t)*copy_src.acquireCount);
    }
    if (releaseCount && copy_src.pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = copy_src.pReleaseSyncs[i];
        }
    }
    if (copy_src.pReleaseKeys) {
        pReleaseKeys = new uint64_t[copy_src.releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)copy_src.pReleaseKeys, sizeof(uint64_t)*copy_src.releaseCount);
    }

    return *this;
}

safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::~safe_VkWin32KeyedMutexAcquireReleaseInfoKHR()
{
    if (pAcquireSyncs)
        delete[] pAcquireSyncs;
    if (pAcquireKeys)
        delete[] pAcquireKeys;
    if (pAcquireTimeouts)
        delete[] pAcquireTimeouts;
    if (pReleaseSyncs)
        delete[] pReleaseSyncs;
    if (pReleaseKeys)
        delete[] pReleaseKeys;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::initialize(const VkWin32KeyedMutexAcquireReleaseInfoKHR* in_struct)
{
    sType = in_struct->sType;
    acquireCount = in_struct->acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeouts = nullptr;
    releaseCount = in_struct->releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (acquireCount && in_struct->pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = in_struct->pAcquireSyncs[i];
        }
    }
    if (in_struct->pAcquireKeys) {
        pAcquireKeys = new uint64_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)in_struct->pAcquireKeys, sizeof(uint64_t)*in_struct->acquireCount);
    }
    if (in_struct->pAcquireTimeouts) {
        pAcquireTimeouts = new uint32_t[in_struct->acquireCount];
        memcpy ((void *)pAcquireTimeouts, (void *)in_struct->pAcquireTimeouts, sizeof(uint32_t)*in_struct->acquireCount);
    }
    if (releaseCount && in_struct->pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = in_struct->pReleaseSyncs[i];
        }
    }
    if (in_struct->pReleaseKeys) {
        pReleaseKeys = new uint64_t[in_struct->releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)in_struct->pReleaseKeys, sizeof(uint64_t)*in_struct->releaseCount);
    }
}

void safe_VkWin32KeyedMutexAcquireReleaseInfoKHR::initialize(const safe_VkWin32KeyedMutexAcquireReleaseInfoKHR* copy_src)
{
    sType = copy_src->sType;
    acquireCount = copy_src->acquireCount;
    pAcquireSyncs = nullptr;
    pAcquireKeys = nullptr;
    pAcquireTimeouts = nullptr;
    releaseCount = copy_src->releaseCount;
    pReleaseSyncs = nullptr;
    pReleaseKeys = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (acquireCount && copy_src->pAcquireSyncs) {
        pAcquireSyncs = new VkDeviceMemory[acquireCount];
        for (uint32_t i = 0; i < acquireCount; ++i) {
            pAcquireSyncs[i] = copy_src->pAcquireSyncs[i];
        }
    }
    if (copy_src->pAcquireKeys) {
        pAcquireKeys = new uint64_t[copy_src->acquireCount];
        memcpy ((void *)pAcquireKeys, (void *)copy_src->pAcquireKeys, sizeof(uint64_t)*copy_src->acquireCount);
    }
    if (copy_src->pAcquireTimeouts) {
        pAcquireTimeouts = new uint32_t[copy_src->acquireCount];
        memcpy ((void *)pAcquireTimeouts, (void *)copy_src->pAcquireTimeouts, sizeof(uint32_t)*copy_src->acquireCount);
    }
    if (releaseCount && copy_src->pReleaseSyncs) {
        pReleaseSyncs = new VkDeviceMemory[releaseCount];
        for (uint32_t i = 0; i < releaseCount; ++i) {
            pReleaseSyncs[i] = copy_src->pReleaseSyncs[i];
        }
    }
    if (copy_src->pReleaseKeys) {
        pReleaseKeys = new uint64_t[copy_src->releaseCount];
        memcpy ((void *)pReleaseKeys, (void *)copy_src->pReleaseKeys, sizeof(uint64_t)*copy_src->releaseCount);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkImportSemaphoreWin32HandleInfoKHR::safe_VkImportSemaphoreWin32HandleInfoKHR(const VkImportSemaphoreWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    semaphore(in_struct->semaphore),
    flags(in_struct->flags),
    handleType(in_struct->handleType),
    handle(in_struct->handle),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportSemaphoreWin32HandleInfoKHR::safe_VkImportSemaphoreWin32HandleInfoKHR() :
    sType(VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkImportSemaphoreWin32HandleInfoKHR::safe_VkImportSemaphoreWin32HandleInfoKHR(const safe_VkImportSemaphoreWin32HandleInfoKHR& copy_src)
{
    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    flags = copy_src.flags;
    handleType = copy_src.handleType;
    handle = copy_src.handle;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImportSemaphoreWin32HandleInfoKHR& safe_VkImportSemaphoreWin32HandleInfoKHR::operator=(const safe_VkImportSemaphoreWin32HandleInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    flags = copy_src.flags;
    handleType = copy_src.handleType;
    handle = copy_src.handle;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImportSemaphoreWin32HandleInfoKHR::~safe_VkImportSemaphoreWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportSemaphoreWin32HandleInfoKHR::initialize(const VkImportSemaphoreWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    semaphore = in_struct->semaphore;
    flags = in_struct->flags;
    handleType = in_struct->handleType;
    handle = in_struct->handle;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportSemaphoreWin32HandleInfoKHR::initialize(const safe_VkImportSemaphoreWin32HandleInfoKHR* copy_src)
{
    sType = copy_src->sType;
    semaphore = copy_src->semaphore;
    flags = copy_src->flags;
    handleType = copy_src->handleType;
    handle = copy_src->handle;
    name = copy_src->name;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkExportSemaphoreWin32HandleInfoKHR::safe_VkExportSemaphoreWin32HandleInfoKHR(const VkExportSemaphoreWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    pAttributes(nullptr),
    dwAccess(in_struct->dwAccess),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

safe_VkExportSemaphoreWin32HandleInfoKHR::safe_VkExportSemaphoreWin32HandleInfoKHR() :
    sType(VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_WIN32_HANDLE_INFO_KHR),
    pNext(nullptr),
    pAttributes(nullptr)
{}

safe_VkExportSemaphoreWin32HandleInfoKHR::safe_VkExportSemaphoreWin32HandleInfoKHR(const safe_VkExportSemaphoreWin32HandleInfoKHR& copy_src)
{
    sType = copy_src.sType;
    pAttributes = nullptr;
    dwAccess = copy_src.dwAccess;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*copy_src.pAttributes);
    }
}

safe_VkExportSemaphoreWin32HandleInfoKHR& safe_VkExportSemaphoreWin32HandleInfoKHR::operator=(const safe_VkExportSemaphoreWin32HandleInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pAttributes = nullptr;
    dwAccess = copy_src.dwAccess;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*copy_src.pAttributes);
    }

    return *this;
}

safe_VkExportSemaphoreWin32HandleInfoKHR::~safe_VkExportSemaphoreWin32HandleInfoKHR()
{
    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportSemaphoreWin32HandleInfoKHR::initialize(const VkExportSemaphoreWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pAttributes = nullptr;
    dwAccess = in_struct->dwAccess;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

void safe_VkExportSemaphoreWin32HandleInfoKHR::initialize(const safe_VkExportSemaphoreWin32HandleInfoKHR* copy_src)
{
    sType = copy_src->sType;
    pAttributes = nullptr;
    dwAccess = copy_src->dwAccess;
    name = copy_src->name;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*copy_src->pAttributes);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkD3D12FenceSubmitInfoKHR::safe_VkD3D12FenceSubmitInfoKHR(const VkD3D12FenceSubmitInfoKHR* in_struct) :
    sType(in_struct->sType),
    waitSemaphoreValuesCount(in_struct->waitSemaphoreValuesCount),
    pWaitSemaphoreValues(nullptr),
    signalSemaphoreValuesCount(in_struct->signalSemaphoreValuesCount),
    pSignalSemaphoreValues(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[in_struct->waitSemaphoreValuesCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)in_struct->pWaitSemaphoreValues, sizeof(uint64_t)*in_struct->waitSemaphoreValuesCount);
    }
    if (in_struct->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[in_struct->signalSemaphoreValuesCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)in_struct->pSignalSemaphoreValues, sizeof(uint64_t)*in_struct->signalSemaphoreValuesCount);
    }
}

safe_VkD3D12FenceSubmitInfoKHR::safe_VkD3D12FenceSubmitInfoKHR() :
    sType(VK_STRUCTURE_TYPE_D3D12_FENCE_SUBMIT_INFO_KHR),
    pNext(nullptr),
    pWaitSemaphoreValues(nullptr),
    pSignalSemaphoreValues(nullptr)
{}

safe_VkD3D12FenceSubmitInfoKHR::safe_VkD3D12FenceSubmitInfoKHR(const safe_VkD3D12FenceSubmitInfoKHR& copy_src)
{
    sType = copy_src.sType;
    waitSemaphoreValuesCount = copy_src.waitSemaphoreValuesCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValuesCount = copy_src.signalSemaphoreValuesCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[copy_src.waitSemaphoreValuesCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)copy_src.pWaitSemaphoreValues, sizeof(uint64_t)*copy_src.waitSemaphoreValuesCount);
    }
    if (copy_src.pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[copy_src.signalSemaphoreValuesCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)copy_src.pSignalSemaphoreValues, sizeof(uint64_t)*copy_src.signalSemaphoreValuesCount);
    }
}

safe_VkD3D12FenceSubmitInfoKHR& safe_VkD3D12FenceSubmitInfoKHR::operator=(const safe_VkD3D12FenceSubmitInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pWaitSemaphoreValues)
        delete[] pWaitSemaphoreValues;
    if (pSignalSemaphoreValues)
        delete[] pSignalSemaphoreValues;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    waitSemaphoreValuesCount = copy_src.waitSemaphoreValuesCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValuesCount = copy_src.signalSemaphoreValuesCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[copy_src.waitSemaphoreValuesCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)copy_src.pWaitSemaphoreValues, sizeof(uint64_t)*copy_src.waitSemaphoreValuesCount);
    }
    if (copy_src.pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[copy_src.signalSemaphoreValuesCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)copy_src.pSignalSemaphoreValues, sizeof(uint64_t)*copy_src.signalSemaphoreValuesCount);
    }

    return *this;
}

safe_VkD3D12FenceSubmitInfoKHR::~safe_VkD3D12FenceSubmitInfoKHR()
{
    if (pWaitSemaphoreValues)
        delete[] pWaitSemaphoreValues;
    if (pSignalSemaphoreValues)
        delete[] pSignalSemaphoreValues;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkD3D12FenceSubmitInfoKHR::initialize(const VkD3D12FenceSubmitInfoKHR* in_struct)
{
    sType = in_struct->sType;
    waitSemaphoreValuesCount = in_struct->waitSemaphoreValuesCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValuesCount = in_struct->signalSemaphoreValuesCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[in_struct->waitSemaphoreValuesCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)in_struct->pWaitSemaphoreValues, sizeof(uint64_t)*in_struct->waitSemaphoreValuesCount);
    }
    if (in_struct->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[in_struct->signalSemaphoreValuesCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)in_struct->pSignalSemaphoreValues, sizeof(uint64_t)*in_struct->signalSemaphoreValuesCount);
    }
}

void safe_VkD3D12FenceSubmitInfoKHR::initialize(const safe_VkD3D12FenceSubmitInfoKHR* copy_src)
{
    sType = copy_src->sType;
    waitSemaphoreValuesCount = copy_src->waitSemaphoreValuesCount;
    pWaitSemaphoreValues = nullptr;
    signalSemaphoreValuesCount = copy_src->signalSemaphoreValuesCount;
    pSignalSemaphoreValues = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pWaitSemaphoreValues) {
        pWaitSemaphoreValues = new uint64_t[copy_src->waitSemaphoreValuesCount];
        memcpy ((void *)pWaitSemaphoreValues, (void *)copy_src->pWaitSemaphoreValues, sizeof(uint64_t)*copy_src->waitSemaphoreValuesCount);
    }
    if (copy_src->pSignalSemaphoreValues) {
        pSignalSemaphoreValues = new uint64_t[copy_src->signalSemaphoreValuesCount];
        memcpy ((void *)pSignalSemaphoreValues, (void *)copy_src->pSignalSemaphoreValues, sizeof(uint64_t)*copy_src->signalSemaphoreValuesCount);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkSemaphoreGetWin32HandleInfoKHR::safe_VkSemaphoreGetWin32HandleInfoKHR(const VkSemaphoreGetWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    semaphore(in_struct->semaphore),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSemaphoreGetWin32HandleInfoKHR::safe_VkSemaphoreGetWin32HandleInfoKHR() :
    sType(VK_STRUCTURE_TYPE_SEMAPHORE_GET_WIN32_HANDLE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkSemaphoreGetWin32HandleInfoKHR::safe_VkSemaphoreGetWin32HandleInfoKHR(const safe_VkSemaphoreGetWin32HandleInfoKHR& copy_src)
{
    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSemaphoreGetWin32HandleInfoKHR& safe_VkSemaphoreGetWin32HandleInfoKHR::operator=(const safe_VkSemaphoreGetWin32HandleInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSemaphoreGetWin32HandleInfoKHR::~safe_VkSemaphoreGetWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreGetWin32HandleInfoKHR::initialize(const VkSemaphoreGetWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    semaphore = in_struct->semaphore;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSemaphoreGetWin32HandleInfoKHR::initialize(const safe_VkSemaphoreGetWin32HandleInfoKHR* copy_src)
{
    sType = copy_src->sType;
    semaphore = copy_src->semaphore;
    handleType = copy_src->handleType;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR


safe_VkImportSemaphoreFdInfoKHR::safe_VkImportSemaphoreFdInfoKHR(const VkImportSemaphoreFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    semaphore(in_struct->semaphore),
    flags(in_struct->flags),
    handleType(in_struct->handleType),
    fd(in_struct->fd)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportSemaphoreFdInfoKHR::safe_VkImportSemaphoreFdInfoKHR() :
    sType(VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR),
    pNext(nullptr)
{}

safe_VkImportSemaphoreFdInfoKHR::safe_VkImportSemaphoreFdInfoKHR(const safe_VkImportSemaphoreFdInfoKHR& copy_src)
{
    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    flags = copy_src.flags;
    handleType = copy_src.handleType;
    fd = copy_src.fd;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImportSemaphoreFdInfoKHR& safe_VkImportSemaphoreFdInfoKHR::operator=(const safe_VkImportSemaphoreFdInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    flags = copy_src.flags;
    handleType = copy_src.handleType;
    fd = copy_src.fd;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImportSemaphoreFdInfoKHR::~safe_VkImportSemaphoreFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportSemaphoreFdInfoKHR::initialize(const VkImportSemaphoreFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    semaphore = in_struct->semaphore;
    flags = in_struct->flags;
    handleType = in_struct->handleType;
    fd = in_struct->fd;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportSemaphoreFdInfoKHR::initialize(const safe_VkImportSemaphoreFdInfoKHR* copy_src)
{
    sType = copy_src->sType;
    semaphore = copy_src->semaphore;
    flags = copy_src->flags;
    handleType = copy_src->handleType;
    fd = copy_src->fd;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSemaphoreGetFdInfoKHR::safe_VkSemaphoreGetFdInfoKHR(const VkSemaphoreGetFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    semaphore(in_struct->semaphore),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSemaphoreGetFdInfoKHR::safe_VkSemaphoreGetFdInfoKHR() :
    sType(VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR),
    pNext(nullptr)
{}

safe_VkSemaphoreGetFdInfoKHR::safe_VkSemaphoreGetFdInfoKHR(const safe_VkSemaphoreGetFdInfoKHR& copy_src)
{
    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSemaphoreGetFdInfoKHR& safe_VkSemaphoreGetFdInfoKHR::operator=(const safe_VkSemaphoreGetFdInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSemaphoreGetFdInfoKHR::~safe_VkSemaphoreGetFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreGetFdInfoKHR::initialize(const VkSemaphoreGetFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    semaphore = in_struct->semaphore;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSemaphoreGetFdInfoKHR::initialize(const safe_VkSemaphoreGetFdInfoKHR* copy_src)
{
    sType = copy_src->sType;
    semaphore = copy_src->semaphore;
    handleType = copy_src->handleType;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDevicePushDescriptorPropertiesKHR::safe_VkPhysicalDevicePushDescriptorPropertiesKHR(const VkPhysicalDevicePushDescriptorPropertiesKHR* in_struct) :
    sType(in_struct->sType),
    maxPushDescriptors(in_struct->maxPushDescriptors)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePushDescriptorPropertiesKHR::safe_VkPhysicalDevicePushDescriptorPropertiesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDevicePushDescriptorPropertiesKHR::safe_VkPhysicalDevicePushDescriptorPropertiesKHR(const safe_VkPhysicalDevicePushDescriptorPropertiesKHR& copy_src)
{
    sType = copy_src.sType;
    maxPushDescriptors = copy_src.maxPushDescriptors;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDevicePushDescriptorPropertiesKHR& safe_VkPhysicalDevicePushDescriptorPropertiesKHR::operator=(const safe_VkPhysicalDevicePushDescriptorPropertiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    maxPushDescriptors = copy_src.maxPushDescriptors;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDevicePushDescriptorPropertiesKHR::~safe_VkPhysicalDevicePushDescriptorPropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePushDescriptorPropertiesKHR::initialize(const VkPhysicalDevicePushDescriptorPropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    maxPushDescriptors = in_struct->maxPushDescriptors;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePushDescriptorPropertiesKHR::initialize(const safe_VkPhysicalDevicePushDescriptorPropertiesKHR* copy_src)
{
    sType = copy_src->sType;
    maxPushDescriptors = copy_src->maxPushDescriptors;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPresentRegionKHR::safe_VkPresentRegionKHR(const VkPresentRegionKHR* in_struct) :
    rectangleCount(in_struct->rectangleCount),
    pRectangles(nullptr)
{
    if (in_struct->pRectangles) {
        pRectangles = new VkRectLayerKHR[in_struct->rectangleCount];
        memcpy ((void *)pRectangles, (void *)in_struct->pRectangles, sizeof(VkRectLayerKHR)*in_struct->rectangleCount);
    }
}

safe_VkPresentRegionKHR::safe_VkPresentRegionKHR() :
    pRectangles(nullptr)
{}

safe_VkPresentRegionKHR::safe_VkPresentRegionKHR(const safe_VkPresentRegionKHR& copy_src)
{
    rectangleCount = copy_src.rectangleCount;
    pRectangles = nullptr;
    if (copy_src.pRectangles) {
        pRectangles = new VkRectLayerKHR[copy_src.rectangleCount];
        memcpy ((void *)pRectangles, (void *)copy_src.pRectangles, sizeof(VkRectLayerKHR)*copy_src.rectangleCount);
    }
}

safe_VkPresentRegionKHR& safe_VkPresentRegionKHR::operator=(const safe_VkPresentRegionKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pRectangles)
        delete[] pRectangles;

    rectangleCount = copy_src.rectangleCount;
    pRectangles = nullptr;
    if (copy_src.pRectangles) {
        pRectangles = new VkRectLayerKHR[copy_src.rectangleCount];
        memcpy ((void *)pRectangles, (void *)copy_src.pRectangles, sizeof(VkRectLayerKHR)*copy_src.rectangleCount);
    }

    return *this;
}

safe_VkPresentRegionKHR::~safe_VkPresentRegionKHR()
{
    if (pRectangles)
        delete[] pRectangles;
}

void safe_VkPresentRegionKHR::initialize(const VkPresentRegionKHR* in_struct)
{
    rectangleCount = in_struct->rectangleCount;
    pRectangles = nullptr;
    if (in_struct->pRectangles) {
        pRectangles = new VkRectLayerKHR[in_struct->rectangleCount];
        memcpy ((void *)pRectangles, (void *)in_struct->pRectangles, sizeof(VkRectLayerKHR)*in_struct->rectangleCount);
    }
}

void safe_VkPresentRegionKHR::initialize(const safe_VkPresentRegionKHR* copy_src)
{
    rectangleCount = copy_src->rectangleCount;
    pRectangles = nullptr;
    if (copy_src->pRectangles) {
        pRectangles = new VkRectLayerKHR[copy_src->rectangleCount];
        memcpy ((void *)pRectangles, (void *)copy_src->pRectangles, sizeof(VkRectLayerKHR)*copy_src->rectangleCount);
    }
}

safe_VkPresentRegionsKHR::safe_VkPresentRegionsKHR(const VkPresentRegionsKHR* in_struct) :
    sType(in_struct->sType),
    swapchainCount(in_struct->swapchainCount),
    pRegions(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (swapchainCount && in_struct->pRegions) {
        pRegions = new safe_VkPresentRegionKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

safe_VkPresentRegionsKHR::safe_VkPresentRegionsKHR() :
    sType(VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR),
    pNext(nullptr),
    pRegions(nullptr)
{}

safe_VkPresentRegionsKHR::safe_VkPresentRegionsKHR(const safe_VkPresentRegionsKHR& copy_src)
{
    sType = copy_src.sType;
    swapchainCount = copy_src.swapchainCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (swapchainCount && copy_src.pRegions) {
        pRegions = new safe_VkPresentRegionKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }
}

safe_VkPresentRegionsKHR& safe_VkPresentRegionsKHR::operator=(const safe_VkPresentRegionsKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    swapchainCount = copy_src.swapchainCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (swapchainCount && copy_src.pRegions) {
        pRegions = new safe_VkPresentRegionKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }

    return *this;
}

safe_VkPresentRegionsKHR::~safe_VkPresentRegionsKHR()
{
    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPresentRegionsKHR::initialize(const VkPresentRegionsKHR* in_struct)
{
    sType = in_struct->sType;
    swapchainCount = in_struct->swapchainCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (swapchainCount && in_struct->pRegions) {
        pRegions = new safe_VkPresentRegionKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

void safe_VkPresentRegionsKHR::initialize(const safe_VkPresentRegionsKHR* copy_src)
{
    sType = copy_src->sType;
    swapchainCount = copy_src->swapchainCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (swapchainCount && copy_src->pRegions) {
        pRegions = new safe_VkPresentRegionKHR[swapchainCount];
        for (uint32_t i = 0; i < swapchainCount; ++i) {
            pRegions[i].initialize(&copy_src->pRegions[i]);
        }
    }
}

safe_VkSharedPresentSurfaceCapabilitiesKHR::safe_VkSharedPresentSurfaceCapabilitiesKHR(const VkSharedPresentSurfaceCapabilitiesKHR* in_struct) :
    sType(in_struct->sType),
    sharedPresentSupportedUsageFlags(in_struct->sharedPresentSupportedUsageFlags)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSharedPresentSurfaceCapabilitiesKHR::safe_VkSharedPresentSurfaceCapabilitiesKHR() :
    sType(VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR),
    pNext(nullptr)
{}

safe_VkSharedPresentSurfaceCapabilitiesKHR::safe_VkSharedPresentSurfaceCapabilitiesKHR(const safe_VkSharedPresentSurfaceCapabilitiesKHR& copy_src)
{
    sType = copy_src.sType;
    sharedPresentSupportedUsageFlags = copy_src.sharedPresentSupportedUsageFlags;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSharedPresentSurfaceCapabilitiesKHR& safe_VkSharedPresentSurfaceCapabilitiesKHR::operator=(const safe_VkSharedPresentSurfaceCapabilitiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    sharedPresentSupportedUsageFlags = copy_src.sharedPresentSupportedUsageFlags;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSharedPresentSurfaceCapabilitiesKHR::~safe_VkSharedPresentSurfaceCapabilitiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSharedPresentSurfaceCapabilitiesKHR::initialize(const VkSharedPresentSurfaceCapabilitiesKHR* in_struct)
{
    sType = in_struct->sType;
    sharedPresentSupportedUsageFlags = in_struct->sharedPresentSupportedUsageFlags;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSharedPresentSurfaceCapabilitiesKHR::initialize(const safe_VkSharedPresentSurfaceCapabilitiesKHR* copy_src)
{
    sType = copy_src->sType;
    sharedPresentSupportedUsageFlags = copy_src->sharedPresentSupportedUsageFlags;
    pNext = SafePnextCopy(copy_src->pNext);
}
#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkImportFenceWin32HandleInfoKHR::safe_VkImportFenceWin32HandleInfoKHR(const VkImportFenceWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    fence(in_struct->fence),
    flags(in_struct->flags),
    handleType(in_struct->handleType),
    handle(in_struct->handle),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportFenceWin32HandleInfoKHR::safe_VkImportFenceWin32HandleInfoKHR() :
    sType(VK_STRUCTURE_TYPE_IMPORT_FENCE_WIN32_HANDLE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkImportFenceWin32HandleInfoKHR::safe_VkImportFenceWin32HandleInfoKHR(const safe_VkImportFenceWin32HandleInfoKHR& copy_src)
{
    sType = copy_src.sType;
    fence = copy_src.fence;
    flags = copy_src.flags;
    handleType = copy_src.handleType;
    handle = copy_src.handle;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImportFenceWin32HandleInfoKHR& safe_VkImportFenceWin32HandleInfoKHR::operator=(const safe_VkImportFenceWin32HandleInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    fence = copy_src.fence;
    flags = copy_src.flags;
    handleType = copy_src.handleType;
    handle = copy_src.handle;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImportFenceWin32HandleInfoKHR::~safe_VkImportFenceWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportFenceWin32HandleInfoKHR::initialize(const VkImportFenceWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    fence = in_struct->fence;
    flags = in_struct->flags;
    handleType = in_struct->handleType;
    handle = in_struct->handle;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportFenceWin32HandleInfoKHR::initialize(const safe_VkImportFenceWin32HandleInfoKHR* copy_src)
{
    sType = copy_src->sType;
    fence = copy_src->fence;
    flags = copy_src->flags;
    handleType = copy_src->handleType;
    handle = copy_src->handle;
    name = copy_src->name;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkExportFenceWin32HandleInfoKHR::safe_VkExportFenceWin32HandleInfoKHR(const VkExportFenceWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    pAttributes(nullptr),
    dwAccess(in_struct->dwAccess),
    name(in_struct->name)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

safe_VkExportFenceWin32HandleInfoKHR::safe_VkExportFenceWin32HandleInfoKHR() :
    sType(VK_STRUCTURE_TYPE_EXPORT_FENCE_WIN32_HANDLE_INFO_KHR),
    pNext(nullptr),
    pAttributes(nullptr)
{}

safe_VkExportFenceWin32HandleInfoKHR::safe_VkExportFenceWin32HandleInfoKHR(const safe_VkExportFenceWin32HandleInfoKHR& copy_src)
{
    sType = copy_src.sType;
    pAttributes = nullptr;
    dwAccess = copy_src.dwAccess;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*copy_src.pAttributes);
    }
}

safe_VkExportFenceWin32HandleInfoKHR& safe_VkExportFenceWin32HandleInfoKHR::operator=(const safe_VkExportFenceWin32HandleInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pAttributes = nullptr;
    dwAccess = copy_src.dwAccess;
    name = copy_src.name;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*copy_src.pAttributes);
    }

    return *this;
}

safe_VkExportFenceWin32HandleInfoKHR::~safe_VkExportFenceWin32HandleInfoKHR()
{
    if (pAttributes)
        delete pAttributes;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkExportFenceWin32HandleInfoKHR::initialize(const VkExportFenceWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pAttributes = nullptr;
    dwAccess = in_struct->dwAccess;
    name = in_struct->name;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*in_struct->pAttributes);
    }
}

void safe_VkExportFenceWin32HandleInfoKHR::initialize(const safe_VkExportFenceWin32HandleInfoKHR* copy_src)
{
    sType = copy_src->sType;
    pAttributes = nullptr;
    dwAccess = copy_src->dwAccess;
    name = copy_src->name;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pAttributes) {
        pAttributes = new SECURITY_ATTRIBUTES(*copy_src->pAttributes);
    }
}
#endif // VK_USE_PLATFORM_WIN32_KHR

#ifdef VK_USE_PLATFORM_WIN32_KHR


safe_VkFenceGetWin32HandleInfoKHR::safe_VkFenceGetWin32HandleInfoKHR(const VkFenceGetWin32HandleInfoKHR* in_struct) :
    sType(in_struct->sType),
    fence(in_struct->fence),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkFenceGetWin32HandleInfoKHR::safe_VkFenceGetWin32HandleInfoKHR() :
    sType(VK_STRUCTURE_TYPE_FENCE_GET_WIN32_HANDLE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkFenceGetWin32HandleInfoKHR::safe_VkFenceGetWin32HandleInfoKHR(const safe_VkFenceGetWin32HandleInfoKHR& copy_src)
{
    sType = copy_src.sType;
    fence = copy_src.fence;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkFenceGetWin32HandleInfoKHR& safe_VkFenceGetWin32HandleInfoKHR::operator=(const safe_VkFenceGetWin32HandleInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    fence = copy_src.fence;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkFenceGetWin32HandleInfoKHR::~safe_VkFenceGetWin32HandleInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFenceGetWin32HandleInfoKHR::initialize(const VkFenceGetWin32HandleInfoKHR* in_struct)
{
    sType = in_struct->sType;
    fence = in_struct->fence;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkFenceGetWin32HandleInfoKHR::initialize(const safe_VkFenceGetWin32HandleInfoKHR* copy_src)
{
    sType = copy_src->sType;
    fence = copy_src->fence;
    handleType = copy_src->handleType;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_USE_PLATFORM_WIN32_KHR


safe_VkImportFenceFdInfoKHR::safe_VkImportFenceFdInfoKHR(const VkImportFenceFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    fence(in_struct->fence),
    flags(in_struct->flags),
    handleType(in_struct->handleType),
    fd(in_struct->fd)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImportFenceFdInfoKHR::safe_VkImportFenceFdInfoKHR() :
    sType(VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR),
    pNext(nullptr)
{}

safe_VkImportFenceFdInfoKHR::safe_VkImportFenceFdInfoKHR(const safe_VkImportFenceFdInfoKHR& copy_src)
{
    sType = copy_src.sType;
    fence = copy_src.fence;
    flags = copy_src.flags;
    handleType = copy_src.handleType;
    fd = copy_src.fd;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImportFenceFdInfoKHR& safe_VkImportFenceFdInfoKHR::operator=(const safe_VkImportFenceFdInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    fence = copy_src.fence;
    flags = copy_src.flags;
    handleType = copy_src.handleType;
    fd = copy_src.fd;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImportFenceFdInfoKHR::~safe_VkImportFenceFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImportFenceFdInfoKHR::initialize(const VkImportFenceFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    fence = in_struct->fence;
    flags = in_struct->flags;
    handleType = in_struct->handleType;
    fd = in_struct->fd;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImportFenceFdInfoKHR::initialize(const safe_VkImportFenceFdInfoKHR* copy_src)
{
    sType = copy_src->sType;
    fence = copy_src->fence;
    flags = copy_src->flags;
    handleType = copy_src->handleType;
    fd = copy_src->fd;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkFenceGetFdInfoKHR::safe_VkFenceGetFdInfoKHR(const VkFenceGetFdInfoKHR* in_struct) :
    sType(in_struct->sType),
    fence(in_struct->fence),
    handleType(in_struct->handleType)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkFenceGetFdInfoKHR::safe_VkFenceGetFdInfoKHR() :
    sType(VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR),
    pNext(nullptr)
{}

safe_VkFenceGetFdInfoKHR::safe_VkFenceGetFdInfoKHR(const safe_VkFenceGetFdInfoKHR& copy_src)
{
    sType = copy_src.sType;
    fence = copy_src.fence;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkFenceGetFdInfoKHR& safe_VkFenceGetFdInfoKHR::operator=(const safe_VkFenceGetFdInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    fence = copy_src.fence;
    handleType = copy_src.handleType;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkFenceGetFdInfoKHR::~safe_VkFenceGetFdInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFenceGetFdInfoKHR::initialize(const VkFenceGetFdInfoKHR* in_struct)
{
    sType = in_struct->sType;
    fence = in_struct->fence;
    handleType = in_struct->handleType;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkFenceGetFdInfoKHR::initialize(const safe_VkFenceGetFdInfoKHR* copy_src)
{
    sType = copy_src->sType;
    fence = copy_src->fence;
    handleType = copy_src->handleType;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDevicePerformanceQueryFeaturesKHR::safe_VkPhysicalDevicePerformanceQueryFeaturesKHR(const VkPhysicalDevicePerformanceQueryFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    performanceCounterQueryPools(in_struct->performanceCounterQueryPools),
    performanceCounterMultipleQueryPools(in_struct->performanceCounterMultipleQueryPools)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePerformanceQueryFeaturesKHR::safe_VkPhysicalDevicePerformanceQueryFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDevicePerformanceQueryFeaturesKHR::safe_VkPhysicalDevicePerformanceQueryFeaturesKHR(const safe_VkPhysicalDevicePerformanceQueryFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    performanceCounterQueryPools = copy_src.performanceCounterQueryPools;
    performanceCounterMultipleQueryPools = copy_src.performanceCounterMultipleQueryPools;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDevicePerformanceQueryFeaturesKHR& safe_VkPhysicalDevicePerformanceQueryFeaturesKHR::operator=(const safe_VkPhysicalDevicePerformanceQueryFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    performanceCounterQueryPools = copy_src.performanceCounterQueryPools;
    performanceCounterMultipleQueryPools = copy_src.performanceCounterMultipleQueryPools;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDevicePerformanceQueryFeaturesKHR::~safe_VkPhysicalDevicePerformanceQueryFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePerformanceQueryFeaturesKHR::initialize(const VkPhysicalDevicePerformanceQueryFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    performanceCounterQueryPools = in_struct->performanceCounterQueryPools;
    performanceCounterMultipleQueryPools = in_struct->performanceCounterMultipleQueryPools;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePerformanceQueryFeaturesKHR::initialize(const safe_VkPhysicalDevicePerformanceQueryFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    performanceCounterQueryPools = copy_src->performanceCounterQueryPools;
    performanceCounterMultipleQueryPools = copy_src->performanceCounterMultipleQueryPools;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDevicePerformanceQueryPropertiesKHR::safe_VkPhysicalDevicePerformanceQueryPropertiesKHR(const VkPhysicalDevicePerformanceQueryPropertiesKHR* in_struct) :
    sType(in_struct->sType),
    allowCommandBufferQueryCopies(in_struct->allowCommandBufferQueryCopies)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePerformanceQueryPropertiesKHR::safe_VkPhysicalDevicePerformanceQueryPropertiesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDevicePerformanceQueryPropertiesKHR::safe_VkPhysicalDevicePerformanceQueryPropertiesKHR(const safe_VkPhysicalDevicePerformanceQueryPropertiesKHR& copy_src)
{
    sType = copy_src.sType;
    allowCommandBufferQueryCopies = copy_src.allowCommandBufferQueryCopies;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDevicePerformanceQueryPropertiesKHR& safe_VkPhysicalDevicePerformanceQueryPropertiesKHR::operator=(const safe_VkPhysicalDevicePerformanceQueryPropertiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    allowCommandBufferQueryCopies = copy_src.allowCommandBufferQueryCopies;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDevicePerformanceQueryPropertiesKHR::~safe_VkPhysicalDevicePerformanceQueryPropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePerformanceQueryPropertiesKHR::initialize(const VkPhysicalDevicePerformanceQueryPropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    allowCommandBufferQueryCopies = in_struct->allowCommandBufferQueryCopies;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePerformanceQueryPropertiesKHR::initialize(const safe_VkPhysicalDevicePerformanceQueryPropertiesKHR* copy_src)
{
    sType = copy_src->sType;
    allowCommandBufferQueryCopies = copy_src->allowCommandBufferQueryCopies;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPerformanceCounterKHR::safe_VkPerformanceCounterKHR(const VkPerformanceCounterKHR* in_struct) :
    sType(in_struct->sType),
    unit(in_struct->unit),
    scope(in_struct->scope),
    storage(in_struct->storage)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        uuid[i] = in_struct->uuid[i];
    }
}

safe_VkPerformanceCounterKHR::safe_VkPerformanceCounterKHR() :
    sType(VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR),
    pNext(nullptr)
{}

safe_VkPerformanceCounterKHR::safe_VkPerformanceCounterKHR(const safe_VkPerformanceCounterKHR& copy_src)
{
    sType = copy_src.sType;
    unit = copy_src.unit;
    scope = copy_src.scope;
    storage = copy_src.storage;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        uuid[i] = copy_src.uuid[i];
    }
}

safe_VkPerformanceCounterKHR& safe_VkPerformanceCounterKHR::operator=(const safe_VkPerformanceCounterKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    unit = copy_src.unit;
    scope = copy_src.scope;
    storage = copy_src.storage;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        uuid[i] = copy_src.uuid[i];
    }

    return *this;
}

safe_VkPerformanceCounterKHR::~safe_VkPerformanceCounterKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPerformanceCounterKHR::initialize(const VkPerformanceCounterKHR* in_struct)
{
    sType = in_struct->sType;
    unit = in_struct->unit;
    scope = in_struct->scope;
    storage = in_struct->storage;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        uuid[i] = in_struct->uuid[i];
    }
}

void safe_VkPerformanceCounterKHR::initialize(const safe_VkPerformanceCounterKHR* copy_src)
{
    sType = copy_src->sType;
    unit = copy_src->unit;
    scope = copy_src->scope;
    storage = copy_src->storage;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < VK_UUID_SIZE; ++i) {
        uuid[i] = copy_src->uuid[i];
    }
}

safe_VkPerformanceCounterDescriptionKHR::safe_VkPerformanceCounterDescriptionKHR(const VkPerformanceCounterDescriptionKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        category[i] = in_struct->category[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

safe_VkPerformanceCounterDescriptionKHR::safe_VkPerformanceCounterDescriptionKHR() :
    sType(VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR),
    pNext(nullptr)
{}

safe_VkPerformanceCounterDescriptionKHR::safe_VkPerformanceCounterDescriptionKHR(const safe_VkPerformanceCounterDescriptionKHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        category[i] = copy_src.category[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src.description[i];
    }
}

safe_VkPerformanceCounterDescriptionKHR& safe_VkPerformanceCounterDescriptionKHR::operator=(const safe_VkPerformanceCounterDescriptionKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        category[i] = copy_src.category[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src.description[i];
    }

    return *this;
}

safe_VkPerformanceCounterDescriptionKHR::~safe_VkPerformanceCounterDescriptionKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPerformanceCounterDescriptionKHR::initialize(const VkPerformanceCounterDescriptionKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        category[i] = in_struct->category[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

void safe_VkPerformanceCounterDescriptionKHR::initialize(const safe_VkPerformanceCounterDescriptionKHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        category[i] = copy_src->category[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src->description[i];
    }
}

safe_VkQueryPoolPerformanceCreateInfoKHR::safe_VkQueryPoolPerformanceCreateInfoKHR(const VkQueryPoolPerformanceCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    queueFamilyIndex(in_struct->queueFamilyIndex),
    counterIndexCount(in_struct->counterIndexCount),
    pCounterIndices(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pCounterIndices) {
        pCounterIndices = new uint32_t[in_struct->counterIndexCount];
        memcpy ((void *)pCounterIndices, (void *)in_struct->pCounterIndices, sizeof(uint32_t)*in_struct->counterIndexCount);
    }
}

safe_VkQueryPoolPerformanceCreateInfoKHR::safe_VkQueryPoolPerformanceCreateInfoKHR() :
    sType(VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR),
    pNext(nullptr),
    pCounterIndices(nullptr)
{}

safe_VkQueryPoolPerformanceCreateInfoKHR::safe_VkQueryPoolPerformanceCreateInfoKHR(const safe_VkQueryPoolPerformanceCreateInfoKHR& copy_src)
{
    sType = copy_src.sType;
    queueFamilyIndex = copy_src.queueFamilyIndex;
    counterIndexCount = copy_src.counterIndexCount;
    pCounterIndices = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pCounterIndices) {
        pCounterIndices = new uint32_t[copy_src.counterIndexCount];
        memcpy ((void *)pCounterIndices, (void *)copy_src.pCounterIndices, sizeof(uint32_t)*copy_src.counterIndexCount);
    }
}

safe_VkQueryPoolPerformanceCreateInfoKHR& safe_VkQueryPoolPerformanceCreateInfoKHR::operator=(const safe_VkQueryPoolPerformanceCreateInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pCounterIndices)
        delete[] pCounterIndices;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    queueFamilyIndex = copy_src.queueFamilyIndex;
    counterIndexCount = copy_src.counterIndexCount;
    pCounterIndices = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pCounterIndices) {
        pCounterIndices = new uint32_t[copy_src.counterIndexCount];
        memcpy ((void *)pCounterIndices, (void *)copy_src.pCounterIndices, sizeof(uint32_t)*copy_src.counterIndexCount);
    }

    return *this;
}

safe_VkQueryPoolPerformanceCreateInfoKHR::~safe_VkQueryPoolPerformanceCreateInfoKHR()
{
    if (pCounterIndices)
        delete[] pCounterIndices;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkQueryPoolPerformanceCreateInfoKHR::initialize(const VkQueryPoolPerformanceCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    queueFamilyIndex = in_struct->queueFamilyIndex;
    counterIndexCount = in_struct->counterIndexCount;
    pCounterIndices = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pCounterIndices) {
        pCounterIndices = new uint32_t[in_struct->counterIndexCount];
        memcpy ((void *)pCounterIndices, (void *)in_struct->pCounterIndices, sizeof(uint32_t)*in_struct->counterIndexCount);
    }
}

void safe_VkQueryPoolPerformanceCreateInfoKHR::initialize(const safe_VkQueryPoolPerformanceCreateInfoKHR* copy_src)
{
    sType = copy_src->sType;
    queueFamilyIndex = copy_src->queueFamilyIndex;
    counterIndexCount = copy_src->counterIndexCount;
    pCounterIndices = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pCounterIndices) {
        pCounterIndices = new uint32_t[copy_src->counterIndexCount];
        memcpy ((void *)pCounterIndices, (void *)copy_src->pCounterIndices, sizeof(uint32_t)*copy_src->counterIndexCount);
    }
}

safe_VkAcquireProfilingLockInfoKHR::safe_VkAcquireProfilingLockInfoKHR(const VkAcquireProfilingLockInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    timeout(in_struct->timeout)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkAcquireProfilingLockInfoKHR::safe_VkAcquireProfilingLockInfoKHR() :
    sType(VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR),
    pNext(nullptr)
{}

safe_VkAcquireProfilingLockInfoKHR::safe_VkAcquireProfilingLockInfoKHR(const safe_VkAcquireProfilingLockInfoKHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    timeout = copy_src.timeout;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkAcquireProfilingLockInfoKHR& safe_VkAcquireProfilingLockInfoKHR::operator=(const safe_VkAcquireProfilingLockInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    timeout = copy_src.timeout;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkAcquireProfilingLockInfoKHR::~safe_VkAcquireProfilingLockInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkAcquireProfilingLockInfoKHR::initialize(const VkAcquireProfilingLockInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    timeout = in_struct->timeout;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkAcquireProfilingLockInfoKHR::initialize(const safe_VkAcquireProfilingLockInfoKHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    timeout = copy_src->timeout;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPerformanceQuerySubmitInfoKHR::safe_VkPerformanceQuerySubmitInfoKHR(const VkPerformanceQuerySubmitInfoKHR* in_struct) :
    sType(in_struct->sType),
    counterPassIndex(in_struct->counterPassIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPerformanceQuerySubmitInfoKHR::safe_VkPerformanceQuerySubmitInfoKHR() :
    sType(VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR),
    pNext(nullptr)
{}

safe_VkPerformanceQuerySubmitInfoKHR::safe_VkPerformanceQuerySubmitInfoKHR(const safe_VkPerformanceQuerySubmitInfoKHR& copy_src)
{
    sType = copy_src.sType;
    counterPassIndex = copy_src.counterPassIndex;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPerformanceQuerySubmitInfoKHR& safe_VkPerformanceQuerySubmitInfoKHR::operator=(const safe_VkPerformanceQuerySubmitInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    counterPassIndex = copy_src.counterPassIndex;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPerformanceQuerySubmitInfoKHR::~safe_VkPerformanceQuerySubmitInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPerformanceQuerySubmitInfoKHR::initialize(const VkPerformanceQuerySubmitInfoKHR* in_struct)
{
    sType = in_struct->sType;
    counterPassIndex = in_struct->counterPassIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPerformanceQuerySubmitInfoKHR::initialize(const safe_VkPerformanceQuerySubmitInfoKHR* copy_src)
{
    sType = copy_src->sType;
    counterPassIndex = copy_src->counterPassIndex;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceSurfaceInfo2KHR::safe_VkPhysicalDeviceSurfaceInfo2KHR(const VkPhysicalDeviceSurfaceInfo2KHR* in_struct) :
    sType(in_struct->sType),
    surface(in_struct->surface)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSurfaceInfo2KHR::safe_VkPhysicalDeviceSurfaceInfo2KHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSurfaceInfo2KHR::safe_VkPhysicalDeviceSurfaceInfo2KHR(const safe_VkPhysicalDeviceSurfaceInfo2KHR& copy_src)
{
    sType = copy_src.sType;
    surface = copy_src.surface;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceSurfaceInfo2KHR& safe_VkPhysicalDeviceSurfaceInfo2KHR::operator=(const safe_VkPhysicalDeviceSurfaceInfo2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    surface = copy_src.surface;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSurfaceInfo2KHR::~safe_VkPhysicalDeviceSurfaceInfo2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSurfaceInfo2KHR::initialize(const VkPhysicalDeviceSurfaceInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    surface = in_struct->surface;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSurfaceInfo2KHR::initialize(const safe_VkPhysicalDeviceSurfaceInfo2KHR* copy_src)
{
    sType = copy_src->sType;
    surface = copy_src->surface;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSurfaceCapabilities2KHR::safe_VkSurfaceCapabilities2KHR(const VkSurfaceCapabilities2KHR* in_struct) :
    sType(in_struct->sType),
    surfaceCapabilities(in_struct->surfaceCapabilities)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSurfaceCapabilities2KHR::safe_VkSurfaceCapabilities2KHR() :
    sType(VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR),
    pNext(nullptr)
{}

safe_VkSurfaceCapabilities2KHR::safe_VkSurfaceCapabilities2KHR(const safe_VkSurfaceCapabilities2KHR& copy_src)
{
    sType = copy_src.sType;
    surfaceCapabilities = copy_src.surfaceCapabilities;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSurfaceCapabilities2KHR& safe_VkSurfaceCapabilities2KHR::operator=(const safe_VkSurfaceCapabilities2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    surfaceCapabilities = copy_src.surfaceCapabilities;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSurfaceCapabilities2KHR::~safe_VkSurfaceCapabilities2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSurfaceCapabilities2KHR::initialize(const VkSurfaceCapabilities2KHR* in_struct)
{
    sType = in_struct->sType;
    surfaceCapabilities = in_struct->surfaceCapabilities;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSurfaceCapabilities2KHR::initialize(const safe_VkSurfaceCapabilities2KHR* copy_src)
{
    sType = copy_src->sType;
    surfaceCapabilities = copy_src->surfaceCapabilities;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSurfaceFormat2KHR::safe_VkSurfaceFormat2KHR(const VkSurfaceFormat2KHR* in_struct) :
    sType(in_struct->sType),
    surfaceFormat(in_struct->surfaceFormat)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSurfaceFormat2KHR::safe_VkSurfaceFormat2KHR() :
    sType(VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR),
    pNext(nullptr)
{}

safe_VkSurfaceFormat2KHR::safe_VkSurfaceFormat2KHR(const safe_VkSurfaceFormat2KHR& copy_src)
{
    sType = copy_src.sType;
    surfaceFormat = copy_src.surfaceFormat;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSurfaceFormat2KHR& safe_VkSurfaceFormat2KHR::operator=(const safe_VkSurfaceFormat2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    surfaceFormat = copy_src.surfaceFormat;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSurfaceFormat2KHR::~safe_VkSurfaceFormat2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSurfaceFormat2KHR::initialize(const VkSurfaceFormat2KHR* in_struct)
{
    sType = in_struct->sType;
    surfaceFormat = in_struct->surfaceFormat;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSurfaceFormat2KHR::initialize(const safe_VkSurfaceFormat2KHR* copy_src)
{
    sType = copy_src->sType;
    surfaceFormat = copy_src->surfaceFormat;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDisplayProperties2KHR::safe_VkDisplayProperties2KHR(const VkDisplayProperties2KHR* in_struct) :
    sType(in_struct->sType),
    displayProperties(&in_struct->displayProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayProperties2KHR::safe_VkDisplayProperties2KHR() :
    sType(VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR),
    pNext(nullptr)
{}

safe_VkDisplayProperties2KHR::safe_VkDisplayProperties2KHR(const safe_VkDisplayProperties2KHR& copy_src)
{
    sType = copy_src.sType;
    displayProperties.initialize(&copy_src.displayProperties);
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDisplayProperties2KHR& safe_VkDisplayProperties2KHR::operator=(const safe_VkDisplayProperties2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    displayProperties.initialize(&copy_src.displayProperties);
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDisplayProperties2KHR::~safe_VkDisplayProperties2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayProperties2KHR::initialize(const VkDisplayProperties2KHR* in_struct)
{
    sType = in_struct->sType;
    displayProperties.initialize(&in_struct->displayProperties);
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayProperties2KHR::initialize(const safe_VkDisplayProperties2KHR* copy_src)
{
    sType = copy_src->sType;
    displayProperties.initialize(&copy_src->displayProperties);
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDisplayPlaneProperties2KHR::safe_VkDisplayPlaneProperties2KHR(const VkDisplayPlaneProperties2KHR* in_struct) :
    sType(in_struct->sType),
    displayPlaneProperties(in_struct->displayPlaneProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayPlaneProperties2KHR::safe_VkDisplayPlaneProperties2KHR() :
    sType(VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR),
    pNext(nullptr)
{}

safe_VkDisplayPlaneProperties2KHR::safe_VkDisplayPlaneProperties2KHR(const safe_VkDisplayPlaneProperties2KHR& copy_src)
{
    sType = copy_src.sType;
    displayPlaneProperties = copy_src.displayPlaneProperties;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDisplayPlaneProperties2KHR& safe_VkDisplayPlaneProperties2KHR::operator=(const safe_VkDisplayPlaneProperties2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    displayPlaneProperties = copy_src.displayPlaneProperties;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDisplayPlaneProperties2KHR::~safe_VkDisplayPlaneProperties2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayPlaneProperties2KHR::initialize(const VkDisplayPlaneProperties2KHR* in_struct)
{
    sType = in_struct->sType;
    displayPlaneProperties = in_struct->displayPlaneProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayPlaneProperties2KHR::initialize(const safe_VkDisplayPlaneProperties2KHR* copy_src)
{
    sType = copy_src->sType;
    displayPlaneProperties = copy_src->displayPlaneProperties;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDisplayModeProperties2KHR::safe_VkDisplayModeProperties2KHR(const VkDisplayModeProperties2KHR* in_struct) :
    sType(in_struct->sType),
    displayModeProperties(in_struct->displayModeProperties)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayModeProperties2KHR::safe_VkDisplayModeProperties2KHR() :
    sType(VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR),
    pNext(nullptr)
{}

safe_VkDisplayModeProperties2KHR::safe_VkDisplayModeProperties2KHR(const safe_VkDisplayModeProperties2KHR& copy_src)
{
    sType = copy_src.sType;
    displayModeProperties = copy_src.displayModeProperties;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDisplayModeProperties2KHR& safe_VkDisplayModeProperties2KHR::operator=(const safe_VkDisplayModeProperties2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    displayModeProperties = copy_src.displayModeProperties;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDisplayModeProperties2KHR::~safe_VkDisplayModeProperties2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayModeProperties2KHR::initialize(const VkDisplayModeProperties2KHR* in_struct)
{
    sType = in_struct->sType;
    displayModeProperties = in_struct->displayModeProperties;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayModeProperties2KHR::initialize(const safe_VkDisplayModeProperties2KHR* copy_src)
{
    sType = copy_src->sType;
    displayModeProperties = copy_src->displayModeProperties;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDisplayPlaneInfo2KHR::safe_VkDisplayPlaneInfo2KHR(const VkDisplayPlaneInfo2KHR* in_struct) :
    sType(in_struct->sType),
    mode(in_struct->mode),
    planeIndex(in_struct->planeIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayPlaneInfo2KHR::safe_VkDisplayPlaneInfo2KHR() :
    sType(VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR),
    pNext(nullptr)
{}

safe_VkDisplayPlaneInfo2KHR::safe_VkDisplayPlaneInfo2KHR(const safe_VkDisplayPlaneInfo2KHR& copy_src)
{
    sType = copy_src.sType;
    mode = copy_src.mode;
    planeIndex = copy_src.planeIndex;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDisplayPlaneInfo2KHR& safe_VkDisplayPlaneInfo2KHR::operator=(const safe_VkDisplayPlaneInfo2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    mode = copy_src.mode;
    planeIndex = copy_src.planeIndex;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDisplayPlaneInfo2KHR::~safe_VkDisplayPlaneInfo2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayPlaneInfo2KHR::initialize(const VkDisplayPlaneInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    mode = in_struct->mode;
    planeIndex = in_struct->planeIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayPlaneInfo2KHR::initialize(const safe_VkDisplayPlaneInfo2KHR* copy_src)
{
    sType = copy_src->sType;
    mode = copy_src->mode;
    planeIndex = copy_src->planeIndex;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDisplayPlaneCapabilities2KHR::safe_VkDisplayPlaneCapabilities2KHR(const VkDisplayPlaneCapabilities2KHR* in_struct) :
    sType(in_struct->sType),
    capabilities(in_struct->capabilities)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDisplayPlaneCapabilities2KHR::safe_VkDisplayPlaneCapabilities2KHR() :
    sType(VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR),
    pNext(nullptr)
{}

safe_VkDisplayPlaneCapabilities2KHR::safe_VkDisplayPlaneCapabilities2KHR(const safe_VkDisplayPlaneCapabilities2KHR& copy_src)
{
    sType = copy_src.sType;
    capabilities = copy_src.capabilities;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDisplayPlaneCapabilities2KHR& safe_VkDisplayPlaneCapabilities2KHR::operator=(const safe_VkDisplayPlaneCapabilities2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    capabilities = copy_src.capabilities;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDisplayPlaneCapabilities2KHR::~safe_VkDisplayPlaneCapabilities2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDisplayPlaneCapabilities2KHR::initialize(const VkDisplayPlaneCapabilities2KHR* in_struct)
{
    sType = in_struct->sType;
    capabilities = in_struct->capabilities;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDisplayPlaneCapabilities2KHR::initialize(const safe_VkDisplayPlaneCapabilities2KHR* copy_src)
{
    sType = copy_src->sType;
    capabilities = copy_src->capabilities;
    pNext = SafePnextCopy(copy_src->pNext);
}
#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR::safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR(const VkPhysicalDevicePortabilitySubsetFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    constantAlphaColorBlendFactors(in_struct->constantAlphaColorBlendFactors),
    events(in_struct->events),
    imageViewFormatReinterpretation(in_struct->imageViewFormatReinterpretation),
    imageViewFormatSwizzle(in_struct->imageViewFormatSwizzle),
    imageView2DOn3DImage(in_struct->imageView2DOn3DImage),
    multisampleArrayImage(in_struct->multisampleArrayImage),
    mutableComparisonSamplers(in_struct->mutableComparisonSamplers),
    pointPolygons(in_struct->pointPolygons),
    samplerMipLodBias(in_struct->samplerMipLodBias),
    separateStencilMaskRef(in_struct->separateStencilMaskRef),
    shaderSampleRateInterpolationFunctions(in_struct->shaderSampleRateInterpolationFunctions),
    tessellationIsolines(in_struct->tessellationIsolines),
    tessellationPointMode(in_struct->tessellationPointMode),
    triangleFans(in_struct->triangleFans),
    vertexAttributeAccessBeyondStride(in_struct->vertexAttributeAccessBeyondStride)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR::safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR::safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR(const safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    constantAlphaColorBlendFactors = copy_src.constantAlphaColorBlendFactors;
    events = copy_src.events;
    imageViewFormatReinterpretation = copy_src.imageViewFormatReinterpretation;
    imageViewFormatSwizzle = copy_src.imageViewFormatSwizzle;
    imageView2DOn3DImage = copy_src.imageView2DOn3DImage;
    multisampleArrayImage = copy_src.multisampleArrayImage;
    mutableComparisonSamplers = copy_src.mutableComparisonSamplers;
    pointPolygons = copy_src.pointPolygons;
    samplerMipLodBias = copy_src.samplerMipLodBias;
    separateStencilMaskRef = copy_src.separateStencilMaskRef;
    shaderSampleRateInterpolationFunctions = copy_src.shaderSampleRateInterpolationFunctions;
    tessellationIsolines = copy_src.tessellationIsolines;
    tessellationPointMode = copy_src.tessellationPointMode;
    triangleFans = copy_src.triangleFans;
    vertexAttributeAccessBeyondStride = copy_src.vertexAttributeAccessBeyondStride;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR& safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR::operator=(const safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    constantAlphaColorBlendFactors = copy_src.constantAlphaColorBlendFactors;
    events = copy_src.events;
    imageViewFormatReinterpretation = copy_src.imageViewFormatReinterpretation;
    imageViewFormatSwizzle = copy_src.imageViewFormatSwizzle;
    imageView2DOn3DImage = copy_src.imageView2DOn3DImage;
    multisampleArrayImage = copy_src.multisampleArrayImage;
    mutableComparisonSamplers = copy_src.mutableComparisonSamplers;
    pointPolygons = copy_src.pointPolygons;
    samplerMipLodBias = copy_src.samplerMipLodBias;
    separateStencilMaskRef = copy_src.separateStencilMaskRef;
    shaderSampleRateInterpolationFunctions = copy_src.shaderSampleRateInterpolationFunctions;
    tessellationIsolines = copy_src.tessellationIsolines;
    tessellationPointMode = copy_src.tessellationPointMode;
    triangleFans = copy_src.triangleFans;
    vertexAttributeAccessBeyondStride = copy_src.vertexAttributeAccessBeyondStride;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR::~safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR::initialize(const VkPhysicalDevicePortabilitySubsetFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    constantAlphaColorBlendFactors = in_struct->constantAlphaColorBlendFactors;
    events = in_struct->events;
    imageViewFormatReinterpretation = in_struct->imageViewFormatReinterpretation;
    imageViewFormatSwizzle = in_struct->imageViewFormatSwizzle;
    imageView2DOn3DImage = in_struct->imageView2DOn3DImage;
    multisampleArrayImage = in_struct->multisampleArrayImage;
    mutableComparisonSamplers = in_struct->mutableComparisonSamplers;
    pointPolygons = in_struct->pointPolygons;
    samplerMipLodBias = in_struct->samplerMipLodBias;
    separateStencilMaskRef = in_struct->separateStencilMaskRef;
    shaderSampleRateInterpolationFunctions = in_struct->shaderSampleRateInterpolationFunctions;
    tessellationIsolines = in_struct->tessellationIsolines;
    tessellationPointMode = in_struct->tessellationPointMode;
    triangleFans = in_struct->triangleFans;
    vertexAttributeAccessBeyondStride = in_struct->vertexAttributeAccessBeyondStride;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR::initialize(const safe_VkPhysicalDevicePortabilitySubsetFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    constantAlphaColorBlendFactors = copy_src->constantAlphaColorBlendFactors;
    events = copy_src->events;
    imageViewFormatReinterpretation = copy_src->imageViewFormatReinterpretation;
    imageViewFormatSwizzle = copy_src->imageViewFormatSwizzle;
    imageView2DOn3DImage = copy_src->imageView2DOn3DImage;
    multisampleArrayImage = copy_src->multisampleArrayImage;
    mutableComparisonSamplers = copy_src->mutableComparisonSamplers;
    pointPolygons = copy_src->pointPolygons;
    samplerMipLodBias = copy_src->samplerMipLodBias;
    separateStencilMaskRef = copy_src->separateStencilMaskRef;
    shaderSampleRateInterpolationFunctions = copy_src->shaderSampleRateInterpolationFunctions;
    tessellationIsolines = copy_src->tessellationIsolines;
    tessellationPointMode = copy_src->tessellationPointMode;
    triangleFans = copy_src->triangleFans;
    vertexAttributeAccessBeyondStride = copy_src->vertexAttributeAccessBeyondStride;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR::safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR(const VkPhysicalDevicePortabilitySubsetPropertiesKHR* in_struct) :
    sType(in_struct->sType),
    minVertexInputBindingStrideAlignment(in_struct->minVertexInputBindingStrideAlignment)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR::safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PORTABILITY_SUBSET_PROPERTIES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR::safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR(const safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR& copy_src)
{
    sType = copy_src.sType;
    minVertexInputBindingStrideAlignment = copy_src.minVertexInputBindingStrideAlignment;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR& safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR::operator=(const safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    minVertexInputBindingStrideAlignment = copy_src.minVertexInputBindingStrideAlignment;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR::~safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR::initialize(const VkPhysicalDevicePortabilitySubsetPropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    minVertexInputBindingStrideAlignment = in_struct->minVertexInputBindingStrideAlignment;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR::initialize(const safe_VkPhysicalDevicePortabilitySubsetPropertiesKHR* copy_src)
{
    sType = copy_src->sType;
    minVertexInputBindingStrideAlignment = copy_src->minVertexInputBindingStrideAlignment;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS


safe_VkPhysicalDeviceShaderClockFeaturesKHR::safe_VkPhysicalDeviceShaderClockFeaturesKHR(const VkPhysicalDeviceShaderClockFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    shaderSubgroupClock(in_struct->shaderSubgroupClock),
    shaderDeviceClock(in_struct->shaderDeviceClock)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderClockFeaturesKHR::safe_VkPhysicalDeviceShaderClockFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderClockFeaturesKHR::safe_VkPhysicalDeviceShaderClockFeaturesKHR(const safe_VkPhysicalDeviceShaderClockFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    shaderSubgroupClock = copy_src.shaderSubgroupClock;
    shaderDeviceClock = copy_src.shaderDeviceClock;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceShaderClockFeaturesKHR& safe_VkPhysicalDeviceShaderClockFeaturesKHR::operator=(const safe_VkPhysicalDeviceShaderClockFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    shaderSubgroupClock = copy_src.shaderSubgroupClock;
    shaderDeviceClock = copy_src.shaderDeviceClock;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderClockFeaturesKHR::~safe_VkPhysicalDeviceShaderClockFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderClockFeaturesKHR::initialize(const VkPhysicalDeviceShaderClockFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    shaderSubgroupClock = in_struct->shaderSubgroupClock;
    shaderDeviceClock = in_struct->shaderDeviceClock;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderClockFeaturesKHR::initialize(const safe_VkPhysicalDeviceShaderClockFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    shaderSubgroupClock = copy_src->shaderSubgroupClock;
    shaderDeviceClock = copy_src->shaderDeviceClock;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR::safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR(const VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    shaderTerminateInvocation(in_struct->shaderTerminateInvocation)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR::safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR::safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR(const safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    shaderTerminateInvocation = copy_src.shaderTerminateInvocation;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR& safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR::operator=(const safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    shaderTerminateInvocation = copy_src.shaderTerminateInvocation;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR::~safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR::initialize(const VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    shaderTerminateInvocation = in_struct->shaderTerminateInvocation;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR::initialize(const safe_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    shaderTerminateInvocation = copy_src->shaderTerminateInvocation;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkFragmentShadingRateAttachmentInfoKHR::safe_VkFragmentShadingRateAttachmentInfoKHR(const VkFragmentShadingRateAttachmentInfoKHR* in_struct) :
    sType(in_struct->sType),
    pFragmentShadingRateAttachment(nullptr),
    shadingRateAttachmentTexelSize(in_struct->shadingRateAttachmentTexelSize)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pFragmentShadingRateAttachment)
        pFragmentShadingRateAttachment = new safe_VkAttachmentReference2(in_struct->pFragmentShadingRateAttachment);
}

safe_VkFragmentShadingRateAttachmentInfoKHR::safe_VkFragmentShadingRateAttachmentInfoKHR() :
    sType(VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR),
    pNext(nullptr),
    pFragmentShadingRateAttachment(nullptr)
{}

safe_VkFragmentShadingRateAttachmentInfoKHR::safe_VkFragmentShadingRateAttachmentInfoKHR(const safe_VkFragmentShadingRateAttachmentInfoKHR& copy_src)
{
    sType = copy_src.sType;
    pFragmentShadingRateAttachment = nullptr;
    shadingRateAttachmentTexelSize = copy_src.shadingRateAttachmentTexelSize;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pFragmentShadingRateAttachment)
        pFragmentShadingRateAttachment = new safe_VkAttachmentReference2(*copy_src.pFragmentShadingRateAttachment);
}

safe_VkFragmentShadingRateAttachmentInfoKHR& safe_VkFragmentShadingRateAttachmentInfoKHR::operator=(const safe_VkFragmentShadingRateAttachmentInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pFragmentShadingRateAttachment)
        delete pFragmentShadingRateAttachment;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pFragmentShadingRateAttachment = nullptr;
    shadingRateAttachmentTexelSize = copy_src.shadingRateAttachmentTexelSize;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pFragmentShadingRateAttachment)
        pFragmentShadingRateAttachment = new safe_VkAttachmentReference2(*copy_src.pFragmentShadingRateAttachment);

    return *this;
}

safe_VkFragmentShadingRateAttachmentInfoKHR::~safe_VkFragmentShadingRateAttachmentInfoKHR()
{
    if (pFragmentShadingRateAttachment)
        delete pFragmentShadingRateAttachment;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkFragmentShadingRateAttachmentInfoKHR::initialize(const VkFragmentShadingRateAttachmentInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pFragmentShadingRateAttachment = nullptr;
    shadingRateAttachmentTexelSize = in_struct->shadingRateAttachmentTexelSize;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pFragmentShadingRateAttachment)
        pFragmentShadingRateAttachment = new safe_VkAttachmentReference2(in_struct->pFragmentShadingRateAttachment);
}

void safe_VkFragmentShadingRateAttachmentInfoKHR::initialize(const safe_VkFragmentShadingRateAttachmentInfoKHR* copy_src)
{
    sType = copy_src->sType;
    pFragmentShadingRateAttachment = nullptr;
    shadingRateAttachmentTexelSize = copy_src->shadingRateAttachmentTexelSize;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pFragmentShadingRateAttachment)
        pFragmentShadingRateAttachment = new safe_VkAttachmentReference2(*copy_src->pFragmentShadingRateAttachment);
}

safe_VkPipelineFragmentShadingRateStateCreateInfoKHR::safe_VkPipelineFragmentShadingRateStateCreateInfoKHR(const VkPipelineFragmentShadingRateStateCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    fragmentSize(in_struct->fragmentSize)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        combinerOps[i] = in_struct->combinerOps[i];
    }
}

safe_VkPipelineFragmentShadingRateStateCreateInfoKHR::safe_VkPipelineFragmentShadingRateStateCreateInfoKHR() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkPipelineFragmentShadingRateStateCreateInfoKHR::safe_VkPipelineFragmentShadingRateStateCreateInfoKHR(const safe_VkPipelineFragmentShadingRateStateCreateInfoKHR& copy_src)
{
    sType = copy_src.sType;
    fragmentSize = copy_src.fragmentSize;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        combinerOps[i] = copy_src.combinerOps[i];
    }
}

safe_VkPipelineFragmentShadingRateStateCreateInfoKHR& safe_VkPipelineFragmentShadingRateStateCreateInfoKHR::operator=(const safe_VkPipelineFragmentShadingRateStateCreateInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    fragmentSize = copy_src.fragmentSize;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        combinerOps[i] = copy_src.combinerOps[i];
    }

    return *this;
}

safe_VkPipelineFragmentShadingRateStateCreateInfoKHR::~safe_VkPipelineFragmentShadingRateStateCreateInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineFragmentShadingRateStateCreateInfoKHR::initialize(const VkPipelineFragmentShadingRateStateCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    fragmentSize = in_struct->fragmentSize;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        combinerOps[i] = in_struct->combinerOps[i];
    }
}

void safe_VkPipelineFragmentShadingRateStateCreateInfoKHR::initialize(const safe_VkPipelineFragmentShadingRateStateCreateInfoKHR* copy_src)
{
    sType = copy_src->sType;
    fragmentSize = copy_src->fragmentSize;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        combinerOps[i] = copy_src->combinerOps[i];
    }
}

safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR::safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR(const VkPhysicalDeviceFragmentShadingRateFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    pipelineFragmentShadingRate(in_struct->pipelineFragmentShadingRate),
    primitiveFragmentShadingRate(in_struct->primitiveFragmentShadingRate),
    attachmentFragmentShadingRate(in_struct->attachmentFragmentShadingRate)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR::safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR::safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR(const safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    pipelineFragmentShadingRate = copy_src.pipelineFragmentShadingRate;
    primitiveFragmentShadingRate = copy_src.primitiveFragmentShadingRate;
    attachmentFragmentShadingRate = copy_src.attachmentFragmentShadingRate;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR& safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR::operator=(const safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pipelineFragmentShadingRate = copy_src.pipelineFragmentShadingRate;
    primitiveFragmentShadingRate = copy_src.primitiveFragmentShadingRate;
    attachmentFragmentShadingRate = copy_src.attachmentFragmentShadingRate;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR::~safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR::initialize(const VkPhysicalDeviceFragmentShadingRateFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    pipelineFragmentShadingRate = in_struct->pipelineFragmentShadingRate;
    primitiveFragmentShadingRate = in_struct->primitiveFragmentShadingRate;
    attachmentFragmentShadingRate = in_struct->attachmentFragmentShadingRate;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR::initialize(const safe_VkPhysicalDeviceFragmentShadingRateFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    pipelineFragmentShadingRate = copy_src->pipelineFragmentShadingRate;
    primitiveFragmentShadingRate = copy_src->primitiveFragmentShadingRate;
    attachmentFragmentShadingRate = copy_src->attachmentFragmentShadingRate;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR::safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR(const VkPhysicalDeviceFragmentShadingRatePropertiesKHR* in_struct) :
    sType(in_struct->sType),
    minFragmentShadingRateAttachmentTexelSize(in_struct->minFragmentShadingRateAttachmentTexelSize),
    maxFragmentShadingRateAttachmentTexelSize(in_struct->maxFragmentShadingRateAttachmentTexelSize),
    maxFragmentShadingRateAttachmentTexelSizeAspectRatio(in_struct->maxFragmentShadingRateAttachmentTexelSizeAspectRatio),
    primitiveFragmentShadingRateWithMultipleViewports(in_struct->primitiveFragmentShadingRateWithMultipleViewports),
    layeredShadingRateAttachments(in_struct->layeredShadingRateAttachments),
    fragmentShadingRateNonTrivialCombinerOps(in_struct->fragmentShadingRateNonTrivialCombinerOps),
    maxFragmentSize(in_struct->maxFragmentSize),
    maxFragmentSizeAspectRatio(in_struct->maxFragmentSizeAspectRatio),
    maxFragmentShadingRateCoverageSamples(in_struct->maxFragmentShadingRateCoverageSamples),
    maxFragmentShadingRateRasterizationSamples(in_struct->maxFragmentShadingRateRasterizationSamples),
    fragmentShadingRateWithShaderDepthStencilWrites(in_struct->fragmentShadingRateWithShaderDepthStencilWrites),
    fragmentShadingRateWithSampleMask(in_struct->fragmentShadingRateWithSampleMask),
    fragmentShadingRateWithShaderSampleMask(in_struct->fragmentShadingRateWithShaderSampleMask),
    fragmentShadingRateWithConservativeRasterization(in_struct->fragmentShadingRateWithConservativeRasterization),
    fragmentShadingRateWithFragmentShaderInterlock(in_struct->fragmentShadingRateWithFragmentShaderInterlock),
    fragmentShadingRateWithCustomSampleLocations(in_struct->fragmentShadingRateWithCustomSampleLocations),
    fragmentShadingRateStrictMultiplyCombiner(in_struct->fragmentShadingRateStrictMultiplyCombiner)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR::safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR::safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR(const safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR& copy_src)
{
    sType = copy_src.sType;
    minFragmentShadingRateAttachmentTexelSize = copy_src.minFragmentShadingRateAttachmentTexelSize;
    maxFragmentShadingRateAttachmentTexelSize = copy_src.maxFragmentShadingRateAttachmentTexelSize;
    maxFragmentShadingRateAttachmentTexelSizeAspectRatio = copy_src.maxFragmentShadingRateAttachmentTexelSizeAspectRatio;
    primitiveFragmentShadingRateWithMultipleViewports = copy_src.primitiveFragmentShadingRateWithMultipleViewports;
    layeredShadingRateAttachments = copy_src.layeredShadingRateAttachments;
    fragmentShadingRateNonTrivialCombinerOps = copy_src.fragmentShadingRateNonTrivialCombinerOps;
    maxFragmentSize = copy_src.maxFragmentSize;
    maxFragmentSizeAspectRatio = copy_src.maxFragmentSizeAspectRatio;
    maxFragmentShadingRateCoverageSamples = copy_src.maxFragmentShadingRateCoverageSamples;
    maxFragmentShadingRateRasterizationSamples = copy_src.maxFragmentShadingRateRasterizationSamples;
    fragmentShadingRateWithShaderDepthStencilWrites = copy_src.fragmentShadingRateWithShaderDepthStencilWrites;
    fragmentShadingRateWithSampleMask = copy_src.fragmentShadingRateWithSampleMask;
    fragmentShadingRateWithShaderSampleMask = copy_src.fragmentShadingRateWithShaderSampleMask;
    fragmentShadingRateWithConservativeRasterization = copy_src.fragmentShadingRateWithConservativeRasterization;
    fragmentShadingRateWithFragmentShaderInterlock = copy_src.fragmentShadingRateWithFragmentShaderInterlock;
    fragmentShadingRateWithCustomSampleLocations = copy_src.fragmentShadingRateWithCustomSampleLocations;
    fragmentShadingRateStrictMultiplyCombiner = copy_src.fragmentShadingRateStrictMultiplyCombiner;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR& safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR::operator=(const safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    minFragmentShadingRateAttachmentTexelSize = copy_src.minFragmentShadingRateAttachmentTexelSize;
    maxFragmentShadingRateAttachmentTexelSize = copy_src.maxFragmentShadingRateAttachmentTexelSize;
    maxFragmentShadingRateAttachmentTexelSizeAspectRatio = copy_src.maxFragmentShadingRateAttachmentTexelSizeAspectRatio;
    primitiveFragmentShadingRateWithMultipleViewports = copy_src.primitiveFragmentShadingRateWithMultipleViewports;
    layeredShadingRateAttachments = copy_src.layeredShadingRateAttachments;
    fragmentShadingRateNonTrivialCombinerOps = copy_src.fragmentShadingRateNonTrivialCombinerOps;
    maxFragmentSize = copy_src.maxFragmentSize;
    maxFragmentSizeAspectRatio = copy_src.maxFragmentSizeAspectRatio;
    maxFragmentShadingRateCoverageSamples = copy_src.maxFragmentShadingRateCoverageSamples;
    maxFragmentShadingRateRasterizationSamples = copy_src.maxFragmentShadingRateRasterizationSamples;
    fragmentShadingRateWithShaderDepthStencilWrites = copy_src.fragmentShadingRateWithShaderDepthStencilWrites;
    fragmentShadingRateWithSampleMask = copy_src.fragmentShadingRateWithSampleMask;
    fragmentShadingRateWithShaderSampleMask = copy_src.fragmentShadingRateWithShaderSampleMask;
    fragmentShadingRateWithConservativeRasterization = copy_src.fragmentShadingRateWithConservativeRasterization;
    fragmentShadingRateWithFragmentShaderInterlock = copy_src.fragmentShadingRateWithFragmentShaderInterlock;
    fragmentShadingRateWithCustomSampleLocations = copy_src.fragmentShadingRateWithCustomSampleLocations;
    fragmentShadingRateStrictMultiplyCombiner = copy_src.fragmentShadingRateStrictMultiplyCombiner;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR::~safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR::initialize(const VkPhysicalDeviceFragmentShadingRatePropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    minFragmentShadingRateAttachmentTexelSize = in_struct->minFragmentShadingRateAttachmentTexelSize;
    maxFragmentShadingRateAttachmentTexelSize = in_struct->maxFragmentShadingRateAttachmentTexelSize;
    maxFragmentShadingRateAttachmentTexelSizeAspectRatio = in_struct->maxFragmentShadingRateAttachmentTexelSizeAspectRatio;
    primitiveFragmentShadingRateWithMultipleViewports = in_struct->primitiveFragmentShadingRateWithMultipleViewports;
    layeredShadingRateAttachments = in_struct->layeredShadingRateAttachments;
    fragmentShadingRateNonTrivialCombinerOps = in_struct->fragmentShadingRateNonTrivialCombinerOps;
    maxFragmentSize = in_struct->maxFragmentSize;
    maxFragmentSizeAspectRatio = in_struct->maxFragmentSizeAspectRatio;
    maxFragmentShadingRateCoverageSamples = in_struct->maxFragmentShadingRateCoverageSamples;
    maxFragmentShadingRateRasterizationSamples = in_struct->maxFragmentShadingRateRasterizationSamples;
    fragmentShadingRateWithShaderDepthStencilWrites = in_struct->fragmentShadingRateWithShaderDepthStencilWrites;
    fragmentShadingRateWithSampleMask = in_struct->fragmentShadingRateWithSampleMask;
    fragmentShadingRateWithShaderSampleMask = in_struct->fragmentShadingRateWithShaderSampleMask;
    fragmentShadingRateWithConservativeRasterization = in_struct->fragmentShadingRateWithConservativeRasterization;
    fragmentShadingRateWithFragmentShaderInterlock = in_struct->fragmentShadingRateWithFragmentShaderInterlock;
    fragmentShadingRateWithCustomSampleLocations = in_struct->fragmentShadingRateWithCustomSampleLocations;
    fragmentShadingRateStrictMultiplyCombiner = in_struct->fragmentShadingRateStrictMultiplyCombiner;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR::initialize(const safe_VkPhysicalDeviceFragmentShadingRatePropertiesKHR* copy_src)
{
    sType = copy_src->sType;
    minFragmentShadingRateAttachmentTexelSize = copy_src->minFragmentShadingRateAttachmentTexelSize;
    maxFragmentShadingRateAttachmentTexelSize = copy_src->maxFragmentShadingRateAttachmentTexelSize;
    maxFragmentShadingRateAttachmentTexelSizeAspectRatio = copy_src->maxFragmentShadingRateAttachmentTexelSizeAspectRatio;
    primitiveFragmentShadingRateWithMultipleViewports = copy_src->primitiveFragmentShadingRateWithMultipleViewports;
    layeredShadingRateAttachments = copy_src->layeredShadingRateAttachments;
    fragmentShadingRateNonTrivialCombinerOps = copy_src->fragmentShadingRateNonTrivialCombinerOps;
    maxFragmentSize = copy_src->maxFragmentSize;
    maxFragmentSizeAspectRatio = copy_src->maxFragmentSizeAspectRatio;
    maxFragmentShadingRateCoverageSamples = copy_src->maxFragmentShadingRateCoverageSamples;
    maxFragmentShadingRateRasterizationSamples = copy_src->maxFragmentShadingRateRasterizationSamples;
    fragmentShadingRateWithShaderDepthStencilWrites = copy_src->fragmentShadingRateWithShaderDepthStencilWrites;
    fragmentShadingRateWithSampleMask = copy_src->fragmentShadingRateWithSampleMask;
    fragmentShadingRateWithShaderSampleMask = copy_src->fragmentShadingRateWithShaderSampleMask;
    fragmentShadingRateWithConservativeRasterization = copy_src->fragmentShadingRateWithConservativeRasterization;
    fragmentShadingRateWithFragmentShaderInterlock = copy_src->fragmentShadingRateWithFragmentShaderInterlock;
    fragmentShadingRateWithCustomSampleLocations = copy_src->fragmentShadingRateWithCustomSampleLocations;
    fragmentShadingRateStrictMultiplyCombiner = copy_src->fragmentShadingRateStrictMultiplyCombiner;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceFragmentShadingRateKHR::safe_VkPhysicalDeviceFragmentShadingRateKHR(const VkPhysicalDeviceFragmentShadingRateKHR* in_struct) :
    sType(in_struct->sType),
    sampleCounts(in_struct->sampleCounts),
    fragmentSize(in_struct->fragmentSize)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceFragmentShadingRateKHR::safe_VkPhysicalDeviceFragmentShadingRateKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceFragmentShadingRateKHR::safe_VkPhysicalDeviceFragmentShadingRateKHR(const safe_VkPhysicalDeviceFragmentShadingRateKHR& copy_src)
{
    sType = copy_src.sType;
    sampleCounts = copy_src.sampleCounts;
    fragmentSize = copy_src.fragmentSize;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceFragmentShadingRateKHR& safe_VkPhysicalDeviceFragmentShadingRateKHR::operator=(const safe_VkPhysicalDeviceFragmentShadingRateKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    sampleCounts = copy_src.sampleCounts;
    fragmentSize = copy_src.fragmentSize;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceFragmentShadingRateKHR::~safe_VkPhysicalDeviceFragmentShadingRateKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceFragmentShadingRateKHR::initialize(const VkPhysicalDeviceFragmentShadingRateKHR* in_struct)
{
    sType = in_struct->sType;
    sampleCounts = in_struct->sampleCounts;
    fragmentSize = in_struct->fragmentSize;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceFragmentShadingRateKHR::initialize(const safe_VkPhysicalDeviceFragmentShadingRateKHR* copy_src)
{
    sType = copy_src->sType;
    sampleCounts = copy_src->sampleCounts;
    fragmentSize = copy_src->fragmentSize;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSurfaceProtectedCapabilitiesKHR::safe_VkSurfaceProtectedCapabilitiesKHR(const VkSurfaceProtectedCapabilitiesKHR* in_struct) :
    sType(in_struct->sType),
    supportsProtected(in_struct->supportsProtected)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSurfaceProtectedCapabilitiesKHR::safe_VkSurfaceProtectedCapabilitiesKHR() :
    sType(VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR),
    pNext(nullptr)
{}

safe_VkSurfaceProtectedCapabilitiesKHR::safe_VkSurfaceProtectedCapabilitiesKHR(const safe_VkSurfaceProtectedCapabilitiesKHR& copy_src)
{
    sType = copy_src.sType;
    supportsProtected = copy_src.supportsProtected;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSurfaceProtectedCapabilitiesKHR& safe_VkSurfaceProtectedCapabilitiesKHR::operator=(const safe_VkSurfaceProtectedCapabilitiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    supportsProtected = copy_src.supportsProtected;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSurfaceProtectedCapabilitiesKHR::~safe_VkSurfaceProtectedCapabilitiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSurfaceProtectedCapabilitiesKHR::initialize(const VkSurfaceProtectedCapabilitiesKHR* in_struct)
{
    sType = in_struct->sType;
    supportsProtected = in_struct->supportsProtected;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSurfaceProtectedCapabilitiesKHR::initialize(const safe_VkSurfaceProtectedCapabilitiesKHR* copy_src)
{
    sType = copy_src->sType;
    supportsProtected = copy_src->supportsProtected;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDevicePresentWaitFeaturesKHR::safe_VkPhysicalDevicePresentWaitFeaturesKHR(const VkPhysicalDevicePresentWaitFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    presentWait(in_struct->presentWait)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePresentWaitFeaturesKHR::safe_VkPhysicalDevicePresentWaitFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDevicePresentWaitFeaturesKHR::safe_VkPhysicalDevicePresentWaitFeaturesKHR(const safe_VkPhysicalDevicePresentWaitFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    presentWait = copy_src.presentWait;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDevicePresentWaitFeaturesKHR& safe_VkPhysicalDevicePresentWaitFeaturesKHR::operator=(const safe_VkPhysicalDevicePresentWaitFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    presentWait = copy_src.presentWait;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDevicePresentWaitFeaturesKHR::~safe_VkPhysicalDevicePresentWaitFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePresentWaitFeaturesKHR::initialize(const VkPhysicalDevicePresentWaitFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    presentWait = in_struct->presentWait;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePresentWaitFeaturesKHR::initialize(const safe_VkPhysicalDevicePresentWaitFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    presentWait = copy_src->presentWait;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    pipelineExecutableInfo(in_struct->pipelineExecutableInfo)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(const safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    pipelineExecutableInfo = copy_src.pipelineExecutableInfo;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR& safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::operator=(const safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pipelineExecutableInfo = copy_src.pipelineExecutableInfo;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::~safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::initialize(const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    pipelineExecutableInfo = in_struct->pipelineExecutableInfo;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR::initialize(const safe_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    pipelineExecutableInfo = copy_src->pipelineExecutableInfo;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineInfoKHR::safe_VkPipelineInfoKHR(const VkPipelineInfoKHR* in_struct) :
    sType(in_struct->sType),
    pipeline(in_struct->pipeline)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineInfoKHR::safe_VkPipelineInfoKHR() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkPipelineInfoKHR::safe_VkPipelineInfoKHR(const safe_VkPipelineInfoKHR& copy_src)
{
    sType = copy_src.sType;
    pipeline = copy_src.pipeline;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPipelineInfoKHR& safe_VkPipelineInfoKHR::operator=(const safe_VkPipelineInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pipeline = copy_src.pipeline;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPipelineInfoKHR::~safe_VkPipelineInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineInfoKHR::initialize(const VkPipelineInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pipeline = in_struct->pipeline;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineInfoKHR::initialize(const safe_VkPipelineInfoKHR* copy_src)
{
    sType = copy_src->sType;
    pipeline = copy_src->pipeline;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineExecutablePropertiesKHR::safe_VkPipelineExecutablePropertiesKHR(const VkPipelineExecutablePropertiesKHR* in_struct) :
    sType(in_struct->sType),
    stages(in_struct->stages),
    subgroupSize(in_struct->subgroupSize)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

safe_VkPipelineExecutablePropertiesKHR::safe_VkPipelineExecutablePropertiesKHR() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR),
    pNext(nullptr)
{}

safe_VkPipelineExecutablePropertiesKHR::safe_VkPipelineExecutablePropertiesKHR(const safe_VkPipelineExecutablePropertiesKHR& copy_src)
{
    sType = copy_src.sType;
    stages = copy_src.stages;
    subgroupSize = copy_src.subgroupSize;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src.description[i];
    }
}

safe_VkPipelineExecutablePropertiesKHR& safe_VkPipelineExecutablePropertiesKHR::operator=(const safe_VkPipelineExecutablePropertiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    stages = copy_src.stages;
    subgroupSize = copy_src.subgroupSize;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src.description[i];
    }

    return *this;
}

safe_VkPipelineExecutablePropertiesKHR::~safe_VkPipelineExecutablePropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineExecutablePropertiesKHR::initialize(const VkPipelineExecutablePropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    stages = in_struct->stages;
    subgroupSize = in_struct->subgroupSize;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

void safe_VkPipelineExecutablePropertiesKHR::initialize(const safe_VkPipelineExecutablePropertiesKHR* copy_src)
{
    sType = copy_src->sType;
    stages = copy_src->stages;
    subgroupSize = copy_src->subgroupSize;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src->description[i];
    }
}

safe_VkPipelineExecutableInfoKHR::safe_VkPipelineExecutableInfoKHR(const VkPipelineExecutableInfoKHR* in_struct) :
    sType(in_struct->sType),
    pipeline(in_struct->pipeline),
    executableIndex(in_struct->executableIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineExecutableInfoKHR::safe_VkPipelineExecutableInfoKHR() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR),
    pNext(nullptr)
{}

safe_VkPipelineExecutableInfoKHR::safe_VkPipelineExecutableInfoKHR(const safe_VkPipelineExecutableInfoKHR& copy_src)
{
    sType = copy_src.sType;
    pipeline = copy_src.pipeline;
    executableIndex = copy_src.executableIndex;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPipelineExecutableInfoKHR& safe_VkPipelineExecutableInfoKHR::operator=(const safe_VkPipelineExecutableInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pipeline = copy_src.pipeline;
    executableIndex = copy_src.executableIndex;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPipelineExecutableInfoKHR::~safe_VkPipelineExecutableInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineExecutableInfoKHR::initialize(const VkPipelineExecutableInfoKHR* in_struct)
{
    sType = in_struct->sType;
    pipeline = in_struct->pipeline;
    executableIndex = in_struct->executableIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineExecutableInfoKHR::initialize(const safe_VkPipelineExecutableInfoKHR* copy_src)
{
    sType = copy_src->sType;
    pipeline = copy_src->pipeline;
    executableIndex = copy_src->executableIndex;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineExecutableStatisticKHR::safe_VkPipelineExecutableStatisticKHR(const VkPipelineExecutableStatisticKHR* in_struct) :
    sType(in_struct->sType),
    format(in_struct->format),
    value(in_struct->value)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

safe_VkPipelineExecutableStatisticKHR::safe_VkPipelineExecutableStatisticKHR() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR),
    pNext(nullptr)
{}

safe_VkPipelineExecutableStatisticKHR::safe_VkPipelineExecutableStatisticKHR(const safe_VkPipelineExecutableStatisticKHR& copy_src)
{
    sType = copy_src.sType;
    format = copy_src.format;
    value = copy_src.value;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src.description[i];
    }
}

safe_VkPipelineExecutableStatisticKHR& safe_VkPipelineExecutableStatisticKHR::operator=(const safe_VkPipelineExecutableStatisticKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    format = copy_src.format;
    value = copy_src.value;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src.description[i];
    }

    return *this;
}

safe_VkPipelineExecutableStatisticKHR::~safe_VkPipelineExecutableStatisticKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineExecutableStatisticKHR::initialize(const VkPipelineExecutableStatisticKHR* in_struct)
{
    sType = in_struct->sType;
    format = in_struct->format;
    value = in_struct->value;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

void safe_VkPipelineExecutableStatisticKHR::initialize(const safe_VkPipelineExecutableStatisticKHR* copy_src)
{
    sType = copy_src->sType;
    format = copy_src->format;
    value = copy_src->value;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src->description[i];
    }
}

safe_VkPipelineExecutableInternalRepresentationKHR::safe_VkPipelineExecutableInternalRepresentationKHR(const VkPipelineExecutableInternalRepresentationKHR* in_struct) :
    sType(in_struct->sType),
    isText(in_struct->isText),
    dataSize(in_struct->dataSize),
    pData(in_struct->pData)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

safe_VkPipelineExecutableInternalRepresentationKHR::safe_VkPipelineExecutableInternalRepresentationKHR() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR),
    pNext(nullptr),
    pData(nullptr)
{}

safe_VkPipelineExecutableInternalRepresentationKHR::safe_VkPipelineExecutableInternalRepresentationKHR(const safe_VkPipelineExecutableInternalRepresentationKHR& copy_src)
{
    sType = copy_src.sType;
    isText = copy_src.isText;
    dataSize = copy_src.dataSize;
    pData = copy_src.pData;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src.description[i];
    }
}

safe_VkPipelineExecutableInternalRepresentationKHR& safe_VkPipelineExecutableInternalRepresentationKHR::operator=(const safe_VkPipelineExecutableInternalRepresentationKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    isText = copy_src.isText;
    dataSize = copy_src.dataSize;
    pData = copy_src.pData;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src.name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src.description[i];
    }

    return *this;
}

safe_VkPipelineExecutableInternalRepresentationKHR::~safe_VkPipelineExecutableInternalRepresentationKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineExecutableInternalRepresentationKHR::initialize(const VkPipelineExecutableInternalRepresentationKHR* in_struct)
{
    sType = in_struct->sType;
    isText = in_struct->isText;
    dataSize = in_struct->dataSize;
    pData = in_struct->pData;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = in_struct->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = in_struct->description[i];
    }
}

void safe_VkPipelineExecutableInternalRepresentationKHR::initialize(const safe_VkPipelineExecutableInternalRepresentationKHR* copy_src)
{
    sType = copy_src->sType;
    isText = copy_src->isText;
    dataSize = copy_src->dataSize;
    pData = copy_src->pData;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        name[i] = copy_src->name[i];
    }
    for (uint32_t i = 0; i < VK_MAX_DESCRIPTION_SIZE; ++i) {
        description[i] = copy_src->description[i];
    }
}

safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR::safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR(const VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    shaderIntegerDotProduct(in_struct->shaderIntegerDotProduct)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR::safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR::safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR(const safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    shaderIntegerDotProduct = copy_src.shaderIntegerDotProduct;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR& safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR::operator=(const safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    shaderIntegerDotProduct = copy_src.shaderIntegerDotProduct;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR::~safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR::initialize(const VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    shaderIntegerDotProduct = in_struct->shaderIntegerDotProduct;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR::initialize(const safe_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    shaderIntegerDotProduct = copy_src->shaderIntegerDotProduct;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR::safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR(const VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR* in_struct) :
    sType(in_struct->sType),
    integerDotProduct8BitUnsignedAccelerated(in_struct->integerDotProduct8BitUnsignedAccelerated),
    integerDotProduct8BitSignedAccelerated(in_struct->integerDotProduct8BitSignedAccelerated),
    integerDotProduct8BitMixedSignednessAccelerated(in_struct->integerDotProduct8BitMixedSignednessAccelerated),
    integerDotProduct4x8BitPackedUnsignedAccelerated(in_struct->integerDotProduct4x8BitPackedUnsignedAccelerated),
    integerDotProduct4x8BitPackedSignedAccelerated(in_struct->integerDotProduct4x8BitPackedSignedAccelerated),
    integerDotProduct4x8BitPackedMixedSignednessAccelerated(in_struct->integerDotProduct4x8BitPackedMixedSignednessAccelerated),
    integerDotProduct16BitUnsignedAccelerated(in_struct->integerDotProduct16BitUnsignedAccelerated),
    integerDotProduct16BitSignedAccelerated(in_struct->integerDotProduct16BitSignedAccelerated),
    integerDotProduct16BitMixedSignednessAccelerated(in_struct->integerDotProduct16BitMixedSignednessAccelerated),
    integerDotProduct32BitUnsignedAccelerated(in_struct->integerDotProduct32BitUnsignedAccelerated),
    integerDotProduct32BitSignedAccelerated(in_struct->integerDotProduct32BitSignedAccelerated),
    integerDotProduct32BitMixedSignednessAccelerated(in_struct->integerDotProduct32BitMixedSignednessAccelerated),
    integerDotProduct64BitUnsignedAccelerated(in_struct->integerDotProduct64BitUnsignedAccelerated),
    integerDotProduct64BitSignedAccelerated(in_struct->integerDotProduct64BitSignedAccelerated),
    integerDotProduct64BitMixedSignednessAccelerated(in_struct->integerDotProduct64BitMixedSignednessAccelerated),
    integerDotProductAccumulatingSaturating8BitUnsignedAccelerated(in_struct->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated),
    integerDotProductAccumulatingSaturating8BitSignedAccelerated(in_struct->integerDotProductAccumulatingSaturating8BitSignedAccelerated),
    integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated(in_struct->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated),
    integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated(in_struct->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated),
    integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated(in_struct->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated),
    integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated(in_struct->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated),
    integerDotProductAccumulatingSaturating16BitUnsignedAccelerated(in_struct->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated),
    integerDotProductAccumulatingSaturating16BitSignedAccelerated(in_struct->integerDotProductAccumulatingSaturating16BitSignedAccelerated),
    integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated(in_struct->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated),
    integerDotProductAccumulatingSaturating32BitUnsignedAccelerated(in_struct->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated),
    integerDotProductAccumulatingSaturating32BitSignedAccelerated(in_struct->integerDotProductAccumulatingSaturating32BitSignedAccelerated),
    integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated(in_struct->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated),
    integerDotProductAccumulatingSaturating64BitUnsignedAccelerated(in_struct->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated),
    integerDotProductAccumulatingSaturating64BitSignedAccelerated(in_struct->integerDotProductAccumulatingSaturating64BitSignedAccelerated),
    integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated(in_struct->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR::safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR::safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR(const safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR& copy_src)
{
    sType = copy_src.sType;
    integerDotProduct8BitUnsignedAccelerated = copy_src.integerDotProduct8BitUnsignedAccelerated;
    integerDotProduct8BitSignedAccelerated = copy_src.integerDotProduct8BitSignedAccelerated;
    integerDotProduct8BitMixedSignednessAccelerated = copy_src.integerDotProduct8BitMixedSignednessAccelerated;
    integerDotProduct4x8BitPackedUnsignedAccelerated = copy_src.integerDotProduct4x8BitPackedUnsignedAccelerated;
    integerDotProduct4x8BitPackedSignedAccelerated = copy_src.integerDotProduct4x8BitPackedSignedAccelerated;
    integerDotProduct4x8BitPackedMixedSignednessAccelerated = copy_src.integerDotProduct4x8BitPackedMixedSignednessAccelerated;
    integerDotProduct16BitUnsignedAccelerated = copy_src.integerDotProduct16BitUnsignedAccelerated;
    integerDotProduct16BitSignedAccelerated = copy_src.integerDotProduct16BitSignedAccelerated;
    integerDotProduct16BitMixedSignednessAccelerated = copy_src.integerDotProduct16BitMixedSignednessAccelerated;
    integerDotProduct32BitUnsignedAccelerated = copy_src.integerDotProduct32BitUnsignedAccelerated;
    integerDotProduct32BitSignedAccelerated = copy_src.integerDotProduct32BitSignedAccelerated;
    integerDotProduct32BitMixedSignednessAccelerated = copy_src.integerDotProduct32BitMixedSignednessAccelerated;
    integerDotProduct64BitUnsignedAccelerated = copy_src.integerDotProduct64BitUnsignedAccelerated;
    integerDotProduct64BitSignedAccelerated = copy_src.integerDotProduct64BitSignedAccelerated;
    integerDotProduct64BitMixedSignednessAccelerated = copy_src.integerDotProduct64BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating8BitUnsignedAccelerated = copy_src.integerDotProductAccumulatingSaturating8BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating8BitSignedAccelerated = copy_src.integerDotProductAccumulatingSaturating8BitSignedAccelerated;
    integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated = copy_src.integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated = copy_src.integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated = copy_src.integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated = copy_src.integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating16BitUnsignedAccelerated = copy_src.integerDotProductAccumulatingSaturating16BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating16BitSignedAccelerated = copy_src.integerDotProductAccumulatingSaturating16BitSignedAccelerated;
    integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated = copy_src.integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating32BitUnsignedAccelerated = copy_src.integerDotProductAccumulatingSaturating32BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating32BitSignedAccelerated = copy_src.integerDotProductAccumulatingSaturating32BitSignedAccelerated;
    integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated = copy_src.integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating64BitUnsignedAccelerated = copy_src.integerDotProductAccumulatingSaturating64BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating64BitSignedAccelerated = copy_src.integerDotProductAccumulatingSaturating64BitSignedAccelerated;
    integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated = copy_src.integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR& safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR::operator=(const safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    integerDotProduct8BitUnsignedAccelerated = copy_src.integerDotProduct8BitUnsignedAccelerated;
    integerDotProduct8BitSignedAccelerated = copy_src.integerDotProduct8BitSignedAccelerated;
    integerDotProduct8BitMixedSignednessAccelerated = copy_src.integerDotProduct8BitMixedSignednessAccelerated;
    integerDotProduct4x8BitPackedUnsignedAccelerated = copy_src.integerDotProduct4x8BitPackedUnsignedAccelerated;
    integerDotProduct4x8BitPackedSignedAccelerated = copy_src.integerDotProduct4x8BitPackedSignedAccelerated;
    integerDotProduct4x8BitPackedMixedSignednessAccelerated = copy_src.integerDotProduct4x8BitPackedMixedSignednessAccelerated;
    integerDotProduct16BitUnsignedAccelerated = copy_src.integerDotProduct16BitUnsignedAccelerated;
    integerDotProduct16BitSignedAccelerated = copy_src.integerDotProduct16BitSignedAccelerated;
    integerDotProduct16BitMixedSignednessAccelerated = copy_src.integerDotProduct16BitMixedSignednessAccelerated;
    integerDotProduct32BitUnsignedAccelerated = copy_src.integerDotProduct32BitUnsignedAccelerated;
    integerDotProduct32BitSignedAccelerated = copy_src.integerDotProduct32BitSignedAccelerated;
    integerDotProduct32BitMixedSignednessAccelerated = copy_src.integerDotProduct32BitMixedSignednessAccelerated;
    integerDotProduct64BitUnsignedAccelerated = copy_src.integerDotProduct64BitUnsignedAccelerated;
    integerDotProduct64BitSignedAccelerated = copy_src.integerDotProduct64BitSignedAccelerated;
    integerDotProduct64BitMixedSignednessAccelerated = copy_src.integerDotProduct64BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating8BitUnsignedAccelerated = copy_src.integerDotProductAccumulatingSaturating8BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating8BitSignedAccelerated = copy_src.integerDotProductAccumulatingSaturating8BitSignedAccelerated;
    integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated = copy_src.integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated = copy_src.integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated = copy_src.integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated = copy_src.integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating16BitUnsignedAccelerated = copy_src.integerDotProductAccumulatingSaturating16BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating16BitSignedAccelerated = copy_src.integerDotProductAccumulatingSaturating16BitSignedAccelerated;
    integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated = copy_src.integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating32BitUnsignedAccelerated = copy_src.integerDotProductAccumulatingSaturating32BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating32BitSignedAccelerated = copy_src.integerDotProductAccumulatingSaturating32BitSignedAccelerated;
    integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated = copy_src.integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating64BitUnsignedAccelerated = copy_src.integerDotProductAccumulatingSaturating64BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating64BitSignedAccelerated = copy_src.integerDotProductAccumulatingSaturating64BitSignedAccelerated;
    integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated = copy_src.integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR::~safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR::initialize(const VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR* in_struct)
{
    sType = in_struct->sType;
    integerDotProduct8BitUnsignedAccelerated = in_struct->integerDotProduct8BitUnsignedAccelerated;
    integerDotProduct8BitSignedAccelerated = in_struct->integerDotProduct8BitSignedAccelerated;
    integerDotProduct8BitMixedSignednessAccelerated = in_struct->integerDotProduct8BitMixedSignednessAccelerated;
    integerDotProduct4x8BitPackedUnsignedAccelerated = in_struct->integerDotProduct4x8BitPackedUnsignedAccelerated;
    integerDotProduct4x8BitPackedSignedAccelerated = in_struct->integerDotProduct4x8BitPackedSignedAccelerated;
    integerDotProduct4x8BitPackedMixedSignednessAccelerated = in_struct->integerDotProduct4x8BitPackedMixedSignednessAccelerated;
    integerDotProduct16BitUnsignedAccelerated = in_struct->integerDotProduct16BitUnsignedAccelerated;
    integerDotProduct16BitSignedAccelerated = in_struct->integerDotProduct16BitSignedAccelerated;
    integerDotProduct16BitMixedSignednessAccelerated = in_struct->integerDotProduct16BitMixedSignednessAccelerated;
    integerDotProduct32BitUnsignedAccelerated = in_struct->integerDotProduct32BitUnsignedAccelerated;
    integerDotProduct32BitSignedAccelerated = in_struct->integerDotProduct32BitSignedAccelerated;
    integerDotProduct32BitMixedSignednessAccelerated = in_struct->integerDotProduct32BitMixedSignednessAccelerated;
    integerDotProduct64BitUnsignedAccelerated = in_struct->integerDotProduct64BitUnsignedAccelerated;
    integerDotProduct64BitSignedAccelerated = in_struct->integerDotProduct64BitSignedAccelerated;
    integerDotProduct64BitMixedSignednessAccelerated = in_struct->integerDotProduct64BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating8BitUnsignedAccelerated = in_struct->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating8BitSignedAccelerated = in_struct->integerDotProductAccumulatingSaturating8BitSignedAccelerated;
    integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated = in_struct->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated = in_struct->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated = in_struct->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated = in_struct->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating16BitUnsignedAccelerated = in_struct->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating16BitSignedAccelerated = in_struct->integerDotProductAccumulatingSaturating16BitSignedAccelerated;
    integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated = in_struct->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating32BitUnsignedAccelerated = in_struct->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating32BitSignedAccelerated = in_struct->integerDotProductAccumulatingSaturating32BitSignedAccelerated;
    integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated = in_struct->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating64BitUnsignedAccelerated = in_struct->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating64BitSignedAccelerated = in_struct->integerDotProductAccumulatingSaturating64BitSignedAccelerated;
    integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated = in_struct->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR::initialize(const safe_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR* copy_src)
{
    sType = copy_src->sType;
    integerDotProduct8BitUnsignedAccelerated = copy_src->integerDotProduct8BitUnsignedAccelerated;
    integerDotProduct8BitSignedAccelerated = copy_src->integerDotProduct8BitSignedAccelerated;
    integerDotProduct8BitMixedSignednessAccelerated = copy_src->integerDotProduct8BitMixedSignednessAccelerated;
    integerDotProduct4x8BitPackedUnsignedAccelerated = copy_src->integerDotProduct4x8BitPackedUnsignedAccelerated;
    integerDotProduct4x8BitPackedSignedAccelerated = copy_src->integerDotProduct4x8BitPackedSignedAccelerated;
    integerDotProduct4x8BitPackedMixedSignednessAccelerated = copy_src->integerDotProduct4x8BitPackedMixedSignednessAccelerated;
    integerDotProduct16BitUnsignedAccelerated = copy_src->integerDotProduct16BitUnsignedAccelerated;
    integerDotProduct16BitSignedAccelerated = copy_src->integerDotProduct16BitSignedAccelerated;
    integerDotProduct16BitMixedSignednessAccelerated = copy_src->integerDotProduct16BitMixedSignednessAccelerated;
    integerDotProduct32BitUnsignedAccelerated = copy_src->integerDotProduct32BitUnsignedAccelerated;
    integerDotProduct32BitSignedAccelerated = copy_src->integerDotProduct32BitSignedAccelerated;
    integerDotProduct32BitMixedSignednessAccelerated = copy_src->integerDotProduct32BitMixedSignednessAccelerated;
    integerDotProduct64BitUnsignedAccelerated = copy_src->integerDotProduct64BitUnsignedAccelerated;
    integerDotProduct64BitSignedAccelerated = copy_src->integerDotProduct64BitSignedAccelerated;
    integerDotProduct64BitMixedSignednessAccelerated = copy_src->integerDotProduct64BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating8BitUnsignedAccelerated = copy_src->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating8BitSignedAccelerated = copy_src->integerDotProductAccumulatingSaturating8BitSignedAccelerated;
    integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated = copy_src->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated = copy_src->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated = copy_src->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated;
    integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated = copy_src->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating16BitUnsignedAccelerated = copy_src->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating16BitSignedAccelerated = copy_src->integerDotProductAccumulatingSaturating16BitSignedAccelerated;
    integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated = copy_src->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating32BitUnsignedAccelerated = copy_src->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating32BitSignedAccelerated = copy_src->integerDotProductAccumulatingSaturating32BitSignedAccelerated;
    integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated = copy_src->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated;
    integerDotProductAccumulatingSaturating64BitUnsignedAccelerated = copy_src->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated;
    integerDotProductAccumulatingSaturating64BitSignedAccelerated = copy_src->integerDotProductAccumulatingSaturating64BitSignedAccelerated;
    integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated = copy_src->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineLibraryCreateInfoKHR::safe_VkPipelineLibraryCreateInfoKHR(const VkPipelineLibraryCreateInfoKHR* in_struct) :
    sType(in_struct->sType),
    libraryCount(in_struct->libraryCount),
    pLibraries(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (libraryCount && in_struct->pLibraries) {
        pLibraries = new VkPipeline[libraryCount];
        for (uint32_t i = 0; i < libraryCount; ++i) {
            pLibraries[i] = in_struct->pLibraries[i];
        }
    }
}

safe_VkPipelineLibraryCreateInfoKHR::safe_VkPipelineLibraryCreateInfoKHR() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR),
    pNext(nullptr),
    pLibraries(nullptr)
{}

safe_VkPipelineLibraryCreateInfoKHR::safe_VkPipelineLibraryCreateInfoKHR(const safe_VkPipelineLibraryCreateInfoKHR& copy_src)
{
    sType = copy_src.sType;
    libraryCount = copy_src.libraryCount;
    pLibraries = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (libraryCount && copy_src.pLibraries) {
        pLibraries = new VkPipeline[libraryCount];
        for (uint32_t i = 0; i < libraryCount; ++i) {
            pLibraries[i] = copy_src.pLibraries[i];
        }
    }
}

safe_VkPipelineLibraryCreateInfoKHR& safe_VkPipelineLibraryCreateInfoKHR::operator=(const safe_VkPipelineLibraryCreateInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pLibraries)
        delete[] pLibraries;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    libraryCount = copy_src.libraryCount;
    pLibraries = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (libraryCount && copy_src.pLibraries) {
        pLibraries = new VkPipeline[libraryCount];
        for (uint32_t i = 0; i < libraryCount; ++i) {
            pLibraries[i] = copy_src.pLibraries[i];
        }
    }

    return *this;
}

safe_VkPipelineLibraryCreateInfoKHR::~safe_VkPipelineLibraryCreateInfoKHR()
{
    if (pLibraries)
        delete[] pLibraries;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineLibraryCreateInfoKHR::initialize(const VkPipelineLibraryCreateInfoKHR* in_struct)
{
    sType = in_struct->sType;
    libraryCount = in_struct->libraryCount;
    pLibraries = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (libraryCount && in_struct->pLibraries) {
        pLibraries = new VkPipeline[libraryCount];
        for (uint32_t i = 0; i < libraryCount; ++i) {
            pLibraries[i] = in_struct->pLibraries[i];
        }
    }
}

void safe_VkPipelineLibraryCreateInfoKHR::initialize(const safe_VkPipelineLibraryCreateInfoKHR* copy_src)
{
    sType = copy_src->sType;
    libraryCount = copy_src->libraryCount;
    pLibraries = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (libraryCount && copy_src->pLibraries) {
        pLibraries = new VkPipeline[libraryCount];
        for (uint32_t i = 0; i < libraryCount; ++i) {
            pLibraries[i] = copy_src->pLibraries[i];
        }
    }
}

safe_VkPresentIdKHR::safe_VkPresentIdKHR(const VkPresentIdKHR* in_struct) :
    sType(in_struct->sType),
    swapchainCount(in_struct->swapchainCount),
    pPresentIds(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPresentIds) {
        pPresentIds = new uint64_t[in_struct->swapchainCount];
        memcpy ((void *)pPresentIds, (void *)in_struct->pPresentIds, sizeof(uint64_t)*in_struct->swapchainCount);
    }
}

safe_VkPresentIdKHR::safe_VkPresentIdKHR() :
    sType(VK_STRUCTURE_TYPE_PRESENT_ID_KHR),
    pNext(nullptr),
    pPresentIds(nullptr)
{}

safe_VkPresentIdKHR::safe_VkPresentIdKHR(const safe_VkPresentIdKHR& copy_src)
{
    sType = copy_src.sType;
    swapchainCount = copy_src.swapchainCount;
    pPresentIds = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pPresentIds) {
        pPresentIds = new uint64_t[copy_src.swapchainCount];
        memcpy ((void *)pPresentIds, (void *)copy_src.pPresentIds, sizeof(uint64_t)*copy_src.swapchainCount);
    }
}

safe_VkPresentIdKHR& safe_VkPresentIdKHR::operator=(const safe_VkPresentIdKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pPresentIds)
        delete[] pPresentIds;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    swapchainCount = copy_src.swapchainCount;
    pPresentIds = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pPresentIds) {
        pPresentIds = new uint64_t[copy_src.swapchainCount];
        memcpy ((void *)pPresentIds, (void *)copy_src.pPresentIds, sizeof(uint64_t)*copy_src.swapchainCount);
    }

    return *this;
}

safe_VkPresentIdKHR::~safe_VkPresentIdKHR()
{
    if (pPresentIds)
        delete[] pPresentIds;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPresentIdKHR::initialize(const VkPresentIdKHR* in_struct)
{
    sType = in_struct->sType;
    swapchainCount = in_struct->swapchainCount;
    pPresentIds = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pPresentIds) {
        pPresentIds = new uint64_t[in_struct->swapchainCount];
        memcpy ((void *)pPresentIds, (void *)in_struct->pPresentIds, sizeof(uint64_t)*in_struct->swapchainCount);
    }
}

void safe_VkPresentIdKHR::initialize(const safe_VkPresentIdKHR* copy_src)
{
    sType = copy_src->sType;
    swapchainCount = copy_src->swapchainCount;
    pPresentIds = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pPresentIds) {
        pPresentIds = new uint64_t[copy_src->swapchainCount];
        memcpy ((void *)pPresentIds, (void *)copy_src->pPresentIds, sizeof(uint64_t)*copy_src->swapchainCount);
    }
}

safe_VkPhysicalDevicePresentIdFeaturesKHR::safe_VkPhysicalDevicePresentIdFeaturesKHR(const VkPhysicalDevicePresentIdFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    presentId(in_struct->presentId)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDevicePresentIdFeaturesKHR::safe_VkPhysicalDevicePresentIdFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDevicePresentIdFeaturesKHR::safe_VkPhysicalDevicePresentIdFeaturesKHR(const safe_VkPhysicalDevicePresentIdFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    presentId = copy_src.presentId;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDevicePresentIdFeaturesKHR& safe_VkPhysicalDevicePresentIdFeaturesKHR::operator=(const safe_VkPhysicalDevicePresentIdFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    presentId = copy_src.presentId;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDevicePresentIdFeaturesKHR::~safe_VkPhysicalDevicePresentIdFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDevicePresentIdFeaturesKHR::initialize(const VkPhysicalDevicePresentIdFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    presentId = in_struct->presentId;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDevicePresentIdFeaturesKHR::initialize(const safe_VkPhysicalDevicePresentIdFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    presentId = copy_src->presentId;
    pNext = SafePnextCopy(copy_src->pNext);
}
#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEncodeInfoKHR::safe_VkVideoEncodeInfoKHR(const VkVideoEncodeInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    qualityLevel(in_struct->qualityLevel),
    codedExtent(in_struct->codedExtent),
    dstBitstreamBuffer(in_struct->dstBitstreamBuffer),
    dstBitstreamBufferOffset(in_struct->dstBitstreamBufferOffset),
    dstBitstreamBufferMaxRange(in_struct->dstBitstreamBufferMaxRange),
    srcPictureResource(&in_struct->srcPictureResource),
    pSetupReferenceSlot(nullptr),
    referenceSlotCount(in_struct->referenceSlotCount),
    pReferenceSlots(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSetupReferenceSlot)
        pSetupReferenceSlot = new safe_VkVideoReferenceSlotKHR(in_struct->pSetupReferenceSlot);
    if (referenceSlotCount && in_struct->pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&in_struct->pReferenceSlots[i]);
        }
    }
}

safe_VkVideoEncodeInfoKHR::safe_VkVideoEncodeInfoKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR),
    pNext(nullptr),
    pSetupReferenceSlot(nullptr),
    pReferenceSlots(nullptr)
{}

safe_VkVideoEncodeInfoKHR::safe_VkVideoEncodeInfoKHR(const safe_VkVideoEncodeInfoKHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    qualityLevel = copy_src.qualityLevel;
    codedExtent = copy_src.codedExtent;
    dstBitstreamBuffer = copy_src.dstBitstreamBuffer;
    dstBitstreamBufferOffset = copy_src.dstBitstreamBufferOffset;
    dstBitstreamBufferMaxRange = copy_src.dstBitstreamBufferMaxRange;
    srcPictureResource.initialize(&copy_src.srcPictureResource);
    pSetupReferenceSlot = nullptr;
    referenceSlotCount = copy_src.referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSetupReferenceSlot)
        pSetupReferenceSlot = new safe_VkVideoReferenceSlotKHR(*copy_src.pSetupReferenceSlot);
    if (referenceSlotCount && copy_src.pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&copy_src.pReferenceSlots[i]);
        }
    }
}

safe_VkVideoEncodeInfoKHR& safe_VkVideoEncodeInfoKHR::operator=(const safe_VkVideoEncodeInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pSetupReferenceSlot)
        delete pSetupReferenceSlot;
    if (pReferenceSlots)
        delete[] pReferenceSlots;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    qualityLevel = copy_src.qualityLevel;
    codedExtent = copy_src.codedExtent;
    dstBitstreamBuffer = copy_src.dstBitstreamBuffer;
    dstBitstreamBufferOffset = copy_src.dstBitstreamBufferOffset;
    dstBitstreamBufferMaxRange = copy_src.dstBitstreamBufferMaxRange;
    srcPictureResource.initialize(&copy_src.srcPictureResource);
    pSetupReferenceSlot = nullptr;
    referenceSlotCount = copy_src.referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSetupReferenceSlot)
        pSetupReferenceSlot = new safe_VkVideoReferenceSlotKHR(*copy_src.pSetupReferenceSlot);
    if (referenceSlotCount && copy_src.pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&copy_src.pReferenceSlots[i]);
        }
    }

    return *this;
}

safe_VkVideoEncodeInfoKHR::~safe_VkVideoEncodeInfoKHR()
{
    if (pSetupReferenceSlot)
        delete pSetupReferenceSlot;
    if (pReferenceSlots)
        delete[] pReferenceSlots;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEncodeInfoKHR::initialize(const VkVideoEncodeInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    qualityLevel = in_struct->qualityLevel;
    codedExtent = in_struct->codedExtent;
    dstBitstreamBuffer = in_struct->dstBitstreamBuffer;
    dstBitstreamBufferOffset = in_struct->dstBitstreamBufferOffset;
    dstBitstreamBufferMaxRange = in_struct->dstBitstreamBufferMaxRange;
    srcPictureResource.initialize(&in_struct->srcPictureResource);
    pSetupReferenceSlot = nullptr;
    referenceSlotCount = in_struct->referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSetupReferenceSlot)
        pSetupReferenceSlot = new safe_VkVideoReferenceSlotKHR(in_struct->pSetupReferenceSlot);
    if (referenceSlotCount && in_struct->pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&in_struct->pReferenceSlots[i]);
        }
    }
}

void safe_VkVideoEncodeInfoKHR::initialize(const safe_VkVideoEncodeInfoKHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    qualityLevel = copy_src->qualityLevel;
    codedExtent = copy_src->codedExtent;
    dstBitstreamBuffer = copy_src->dstBitstreamBuffer;
    dstBitstreamBufferOffset = copy_src->dstBitstreamBufferOffset;
    dstBitstreamBufferMaxRange = copy_src->dstBitstreamBufferMaxRange;
    srcPictureResource.initialize(&copy_src->srcPictureResource);
    pSetupReferenceSlot = nullptr;
    referenceSlotCount = copy_src->referenceSlotCount;
    pReferenceSlots = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pSetupReferenceSlot)
        pSetupReferenceSlot = new safe_VkVideoReferenceSlotKHR(*copy_src->pSetupReferenceSlot);
    if (referenceSlotCount && copy_src->pReferenceSlots) {
        pReferenceSlots = new safe_VkVideoReferenceSlotKHR[referenceSlotCount];
        for (uint32_t i = 0; i < referenceSlotCount; ++i) {
            pReferenceSlots[i].initialize(&copy_src->pReferenceSlots[i]);
        }
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEncodeRateControlInfoKHR::safe_VkVideoEncodeRateControlInfoKHR(const VkVideoEncodeRateControlInfoKHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    rateControlMode(in_struct->rateControlMode),
    averageBitrate(in_struct->averageBitrate),
    peakToAverageBitrateRatio(in_struct->peakToAverageBitrateRatio),
    frameRateNumerator(in_struct->frameRateNumerator),
    frameRateDenominator(in_struct->frameRateDenominator),
    virtualBufferSizeInMs(in_struct->virtualBufferSizeInMs)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoEncodeRateControlInfoKHR::safe_VkVideoEncodeRateControlInfoKHR() :
    sType(VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR),
    pNext(nullptr)
{}

safe_VkVideoEncodeRateControlInfoKHR::safe_VkVideoEncodeRateControlInfoKHR(const safe_VkVideoEncodeRateControlInfoKHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    rateControlMode = copy_src.rateControlMode;
    averageBitrate = copy_src.averageBitrate;
    peakToAverageBitrateRatio = copy_src.peakToAverageBitrateRatio;
    frameRateNumerator = copy_src.frameRateNumerator;
    frameRateDenominator = copy_src.frameRateDenominator;
    virtualBufferSizeInMs = copy_src.virtualBufferSizeInMs;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoEncodeRateControlInfoKHR& safe_VkVideoEncodeRateControlInfoKHR::operator=(const safe_VkVideoEncodeRateControlInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    rateControlMode = copy_src.rateControlMode;
    averageBitrate = copy_src.averageBitrate;
    peakToAverageBitrateRatio = copy_src.peakToAverageBitrateRatio;
    frameRateNumerator = copy_src.frameRateNumerator;
    frameRateDenominator = copy_src.frameRateDenominator;
    virtualBufferSizeInMs = copy_src.virtualBufferSizeInMs;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoEncodeRateControlInfoKHR::~safe_VkVideoEncodeRateControlInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEncodeRateControlInfoKHR::initialize(const VkVideoEncodeRateControlInfoKHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    rateControlMode = in_struct->rateControlMode;
    averageBitrate = in_struct->averageBitrate;
    peakToAverageBitrateRatio = in_struct->peakToAverageBitrateRatio;
    frameRateNumerator = in_struct->frameRateNumerator;
    frameRateDenominator = in_struct->frameRateDenominator;
    virtualBufferSizeInMs = in_struct->virtualBufferSizeInMs;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoEncodeRateControlInfoKHR::initialize(const safe_VkVideoEncodeRateControlInfoKHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    rateControlMode = copy_src->rateControlMode;
    averageBitrate = copy_src->averageBitrate;
    peakToAverageBitrateRatio = copy_src->peakToAverageBitrateRatio;
    frameRateNumerator = copy_src->frameRateNumerator;
    frameRateDenominator = copy_src->frameRateDenominator;
    virtualBufferSizeInMs = copy_src->virtualBufferSizeInMs;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS


safe_VkMemoryBarrier2KHR::safe_VkMemoryBarrier2KHR(const VkMemoryBarrier2KHR* in_struct) :
    sType(in_struct->sType),
    srcStageMask(in_struct->srcStageMask),
    srcAccessMask(in_struct->srcAccessMask),
    dstStageMask(in_struct->dstStageMask),
    dstAccessMask(in_struct->dstAccessMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkMemoryBarrier2KHR::safe_VkMemoryBarrier2KHR() :
    sType(VK_STRUCTURE_TYPE_MEMORY_BARRIER_2_KHR),
    pNext(nullptr)
{}

safe_VkMemoryBarrier2KHR::safe_VkMemoryBarrier2KHR(const safe_VkMemoryBarrier2KHR& copy_src)
{
    sType = copy_src.sType;
    srcStageMask = copy_src.srcStageMask;
    srcAccessMask = copy_src.srcAccessMask;
    dstStageMask = copy_src.dstStageMask;
    dstAccessMask = copy_src.dstAccessMask;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkMemoryBarrier2KHR& safe_VkMemoryBarrier2KHR::operator=(const safe_VkMemoryBarrier2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcStageMask = copy_src.srcStageMask;
    srcAccessMask = copy_src.srcAccessMask;
    dstStageMask = copy_src.dstStageMask;
    dstAccessMask = copy_src.dstAccessMask;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkMemoryBarrier2KHR::~safe_VkMemoryBarrier2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkMemoryBarrier2KHR::initialize(const VkMemoryBarrier2KHR* in_struct)
{
    sType = in_struct->sType;
    srcStageMask = in_struct->srcStageMask;
    srcAccessMask = in_struct->srcAccessMask;
    dstStageMask = in_struct->dstStageMask;
    dstAccessMask = in_struct->dstAccessMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkMemoryBarrier2KHR::initialize(const safe_VkMemoryBarrier2KHR* copy_src)
{
    sType = copy_src->sType;
    srcStageMask = copy_src->srcStageMask;
    srcAccessMask = copy_src->srcAccessMask;
    dstStageMask = copy_src->dstStageMask;
    dstAccessMask = copy_src->dstAccessMask;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkBufferMemoryBarrier2KHR::safe_VkBufferMemoryBarrier2KHR(const VkBufferMemoryBarrier2KHR* in_struct) :
    sType(in_struct->sType),
    srcStageMask(in_struct->srcStageMask),
    srcAccessMask(in_struct->srcAccessMask),
    dstStageMask(in_struct->dstStageMask),
    dstAccessMask(in_struct->dstAccessMask),
    srcQueueFamilyIndex(in_struct->srcQueueFamilyIndex),
    dstQueueFamilyIndex(in_struct->dstQueueFamilyIndex),
    buffer(in_struct->buffer),
    offset(in_struct->offset),
    size(in_struct->size)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferMemoryBarrier2KHR::safe_VkBufferMemoryBarrier2KHR() :
    sType(VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2_KHR),
    pNext(nullptr)
{}

safe_VkBufferMemoryBarrier2KHR::safe_VkBufferMemoryBarrier2KHR(const safe_VkBufferMemoryBarrier2KHR& copy_src)
{
    sType = copy_src.sType;
    srcStageMask = copy_src.srcStageMask;
    srcAccessMask = copy_src.srcAccessMask;
    dstStageMask = copy_src.dstStageMask;
    dstAccessMask = copy_src.dstAccessMask;
    srcQueueFamilyIndex = copy_src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src.dstQueueFamilyIndex;
    buffer = copy_src.buffer;
    offset = copy_src.offset;
    size = copy_src.size;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBufferMemoryBarrier2KHR& safe_VkBufferMemoryBarrier2KHR::operator=(const safe_VkBufferMemoryBarrier2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcStageMask = copy_src.srcStageMask;
    srcAccessMask = copy_src.srcAccessMask;
    dstStageMask = copy_src.dstStageMask;
    dstAccessMask = copy_src.dstAccessMask;
    srcQueueFamilyIndex = copy_src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src.dstQueueFamilyIndex;
    buffer = copy_src.buffer;
    offset = copy_src.offset;
    size = copy_src.size;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBufferMemoryBarrier2KHR::~safe_VkBufferMemoryBarrier2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferMemoryBarrier2KHR::initialize(const VkBufferMemoryBarrier2KHR* in_struct)
{
    sType = in_struct->sType;
    srcStageMask = in_struct->srcStageMask;
    srcAccessMask = in_struct->srcAccessMask;
    dstStageMask = in_struct->dstStageMask;
    dstAccessMask = in_struct->dstAccessMask;
    srcQueueFamilyIndex = in_struct->srcQueueFamilyIndex;
    dstQueueFamilyIndex = in_struct->dstQueueFamilyIndex;
    buffer = in_struct->buffer;
    offset = in_struct->offset;
    size = in_struct->size;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferMemoryBarrier2KHR::initialize(const safe_VkBufferMemoryBarrier2KHR* copy_src)
{
    sType = copy_src->sType;
    srcStageMask = copy_src->srcStageMask;
    srcAccessMask = copy_src->srcAccessMask;
    dstStageMask = copy_src->dstStageMask;
    dstAccessMask = copy_src->dstAccessMask;
    srcQueueFamilyIndex = copy_src->srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src->dstQueueFamilyIndex;
    buffer = copy_src->buffer;
    offset = copy_src->offset;
    size = copy_src->size;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkImageMemoryBarrier2KHR::safe_VkImageMemoryBarrier2KHR(const VkImageMemoryBarrier2KHR* in_struct) :
    sType(in_struct->sType),
    srcStageMask(in_struct->srcStageMask),
    srcAccessMask(in_struct->srcAccessMask),
    dstStageMask(in_struct->dstStageMask),
    dstAccessMask(in_struct->dstAccessMask),
    oldLayout(in_struct->oldLayout),
    newLayout(in_struct->newLayout),
    srcQueueFamilyIndex(in_struct->srcQueueFamilyIndex),
    dstQueueFamilyIndex(in_struct->dstQueueFamilyIndex),
    image(in_struct->image),
    subresourceRange(in_struct->subresourceRange)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageMemoryBarrier2KHR::safe_VkImageMemoryBarrier2KHR() :
    sType(VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2_KHR),
    pNext(nullptr)
{}

safe_VkImageMemoryBarrier2KHR::safe_VkImageMemoryBarrier2KHR(const safe_VkImageMemoryBarrier2KHR& copy_src)
{
    sType = copy_src.sType;
    srcStageMask = copy_src.srcStageMask;
    srcAccessMask = copy_src.srcAccessMask;
    dstStageMask = copy_src.dstStageMask;
    dstAccessMask = copy_src.dstAccessMask;
    oldLayout = copy_src.oldLayout;
    newLayout = copy_src.newLayout;
    srcQueueFamilyIndex = copy_src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src.dstQueueFamilyIndex;
    image = copy_src.image;
    subresourceRange = copy_src.subresourceRange;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageMemoryBarrier2KHR& safe_VkImageMemoryBarrier2KHR::operator=(const safe_VkImageMemoryBarrier2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcStageMask = copy_src.srcStageMask;
    srcAccessMask = copy_src.srcAccessMask;
    dstStageMask = copy_src.dstStageMask;
    dstAccessMask = copy_src.dstAccessMask;
    oldLayout = copy_src.oldLayout;
    newLayout = copy_src.newLayout;
    srcQueueFamilyIndex = copy_src.srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src.dstQueueFamilyIndex;
    image = copy_src.image;
    subresourceRange = copy_src.subresourceRange;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageMemoryBarrier2KHR::~safe_VkImageMemoryBarrier2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageMemoryBarrier2KHR::initialize(const VkImageMemoryBarrier2KHR* in_struct)
{
    sType = in_struct->sType;
    srcStageMask = in_struct->srcStageMask;
    srcAccessMask = in_struct->srcAccessMask;
    dstStageMask = in_struct->dstStageMask;
    dstAccessMask = in_struct->dstAccessMask;
    oldLayout = in_struct->oldLayout;
    newLayout = in_struct->newLayout;
    srcQueueFamilyIndex = in_struct->srcQueueFamilyIndex;
    dstQueueFamilyIndex = in_struct->dstQueueFamilyIndex;
    image = in_struct->image;
    subresourceRange = in_struct->subresourceRange;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageMemoryBarrier2KHR::initialize(const safe_VkImageMemoryBarrier2KHR* copy_src)
{
    sType = copy_src->sType;
    srcStageMask = copy_src->srcStageMask;
    srcAccessMask = copy_src->srcAccessMask;
    dstStageMask = copy_src->dstStageMask;
    dstAccessMask = copy_src->dstAccessMask;
    oldLayout = copy_src->oldLayout;
    newLayout = copy_src->newLayout;
    srcQueueFamilyIndex = copy_src->srcQueueFamilyIndex;
    dstQueueFamilyIndex = copy_src->dstQueueFamilyIndex;
    image = copy_src->image;
    subresourceRange = copy_src->subresourceRange;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDependencyInfoKHR::safe_VkDependencyInfoKHR(const VkDependencyInfoKHR* in_struct) :
    sType(in_struct->sType),
    dependencyFlags(in_struct->dependencyFlags),
    memoryBarrierCount(in_struct->memoryBarrierCount),
    pMemoryBarriers(nullptr),
    bufferMemoryBarrierCount(in_struct->bufferMemoryBarrierCount),
    pBufferMemoryBarriers(nullptr),
    imageMemoryBarrierCount(in_struct->imageMemoryBarrierCount),
    pImageMemoryBarriers(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (memoryBarrierCount && in_struct->pMemoryBarriers) {
        pMemoryBarriers = new safe_VkMemoryBarrier2KHR[memoryBarrierCount];
        for (uint32_t i = 0; i < memoryBarrierCount; ++i) {
            pMemoryBarriers[i].initialize(&in_struct->pMemoryBarriers[i]);
        }
    }
    if (bufferMemoryBarrierCount && in_struct->pBufferMemoryBarriers) {
        pBufferMemoryBarriers = new safe_VkBufferMemoryBarrier2KHR[bufferMemoryBarrierCount];
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; ++i) {
            pBufferMemoryBarriers[i].initialize(&in_struct->pBufferMemoryBarriers[i]);
        }
    }
    if (imageMemoryBarrierCount && in_struct->pImageMemoryBarriers) {
        pImageMemoryBarriers = new safe_VkImageMemoryBarrier2KHR[imageMemoryBarrierCount];
        for (uint32_t i = 0; i < imageMemoryBarrierCount; ++i) {
            pImageMemoryBarriers[i].initialize(&in_struct->pImageMemoryBarriers[i]);
        }
    }
}

safe_VkDependencyInfoKHR::safe_VkDependencyInfoKHR() :
    sType(VK_STRUCTURE_TYPE_DEPENDENCY_INFO_KHR),
    pNext(nullptr),
    pMemoryBarriers(nullptr),
    pBufferMemoryBarriers(nullptr),
    pImageMemoryBarriers(nullptr)
{}

safe_VkDependencyInfoKHR::safe_VkDependencyInfoKHR(const safe_VkDependencyInfoKHR& copy_src)
{
    sType = copy_src.sType;
    dependencyFlags = copy_src.dependencyFlags;
    memoryBarrierCount = copy_src.memoryBarrierCount;
    pMemoryBarriers = nullptr;
    bufferMemoryBarrierCount = copy_src.bufferMemoryBarrierCount;
    pBufferMemoryBarriers = nullptr;
    imageMemoryBarrierCount = copy_src.imageMemoryBarrierCount;
    pImageMemoryBarriers = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (memoryBarrierCount && copy_src.pMemoryBarriers) {
        pMemoryBarriers = new safe_VkMemoryBarrier2KHR[memoryBarrierCount];
        for (uint32_t i = 0; i < memoryBarrierCount; ++i) {
            pMemoryBarriers[i].initialize(&copy_src.pMemoryBarriers[i]);
        }
    }
    if (bufferMemoryBarrierCount && copy_src.pBufferMemoryBarriers) {
        pBufferMemoryBarriers = new safe_VkBufferMemoryBarrier2KHR[bufferMemoryBarrierCount];
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; ++i) {
            pBufferMemoryBarriers[i].initialize(&copy_src.pBufferMemoryBarriers[i]);
        }
    }
    if (imageMemoryBarrierCount && copy_src.pImageMemoryBarriers) {
        pImageMemoryBarriers = new safe_VkImageMemoryBarrier2KHR[imageMemoryBarrierCount];
        for (uint32_t i = 0; i < imageMemoryBarrierCount; ++i) {
            pImageMemoryBarriers[i].initialize(&copy_src.pImageMemoryBarriers[i]);
        }
    }
}

safe_VkDependencyInfoKHR& safe_VkDependencyInfoKHR::operator=(const safe_VkDependencyInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pMemoryBarriers)
        delete[] pMemoryBarriers;
    if (pBufferMemoryBarriers)
        delete[] pBufferMemoryBarriers;
    if (pImageMemoryBarriers)
        delete[] pImageMemoryBarriers;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    dependencyFlags = copy_src.dependencyFlags;
    memoryBarrierCount = copy_src.memoryBarrierCount;
    pMemoryBarriers = nullptr;
    bufferMemoryBarrierCount = copy_src.bufferMemoryBarrierCount;
    pBufferMemoryBarriers = nullptr;
    imageMemoryBarrierCount = copy_src.imageMemoryBarrierCount;
    pImageMemoryBarriers = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (memoryBarrierCount && copy_src.pMemoryBarriers) {
        pMemoryBarriers = new safe_VkMemoryBarrier2KHR[memoryBarrierCount];
        for (uint32_t i = 0; i < memoryBarrierCount; ++i) {
            pMemoryBarriers[i].initialize(&copy_src.pMemoryBarriers[i]);
        }
    }
    if (bufferMemoryBarrierCount && copy_src.pBufferMemoryBarriers) {
        pBufferMemoryBarriers = new safe_VkBufferMemoryBarrier2KHR[bufferMemoryBarrierCount];
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; ++i) {
            pBufferMemoryBarriers[i].initialize(&copy_src.pBufferMemoryBarriers[i]);
        }
    }
    if (imageMemoryBarrierCount && copy_src.pImageMemoryBarriers) {
        pImageMemoryBarriers = new safe_VkImageMemoryBarrier2KHR[imageMemoryBarrierCount];
        for (uint32_t i = 0; i < imageMemoryBarrierCount; ++i) {
            pImageMemoryBarriers[i].initialize(&copy_src.pImageMemoryBarriers[i]);
        }
    }

    return *this;
}

safe_VkDependencyInfoKHR::~safe_VkDependencyInfoKHR()
{
    if (pMemoryBarriers)
        delete[] pMemoryBarriers;
    if (pBufferMemoryBarriers)
        delete[] pBufferMemoryBarriers;
    if (pImageMemoryBarriers)
        delete[] pImageMemoryBarriers;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDependencyInfoKHR::initialize(const VkDependencyInfoKHR* in_struct)
{
    sType = in_struct->sType;
    dependencyFlags = in_struct->dependencyFlags;
    memoryBarrierCount = in_struct->memoryBarrierCount;
    pMemoryBarriers = nullptr;
    bufferMemoryBarrierCount = in_struct->bufferMemoryBarrierCount;
    pBufferMemoryBarriers = nullptr;
    imageMemoryBarrierCount = in_struct->imageMemoryBarrierCount;
    pImageMemoryBarriers = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (memoryBarrierCount && in_struct->pMemoryBarriers) {
        pMemoryBarriers = new safe_VkMemoryBarrier2KHR[memoryBarrierCount];
        for (uint32_t i = 0; i < memoryBarrierCount; ++i) {
            pMemoryBarriers[i].initialize(&in_struct->pMemoryBarriers[i]);
        }
    }
    if (bufferMemoryBarrierCount && in_struct->pBufferMemoryBarriers) {
        pBufferMemoryBarriers = new safe_VkBufferMemoryBarrier2KHR[bufferMemoryBarrierCount];
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; ++i) {
            pBufferMemoryBarriers[i].initialize(&in_struct->pBufferMemoryBarriers[i]);
        }
    }
    if (imageMemoryBarrierCount && in_struct->pImageMemoryBarriers) {
        pImageMemoryBarriers = new safe_VkImageMemoryBarrier2KHR[imageMemoryBarrierCount];
        for (uint32_t i = 0; i < imageMemoryBarrierCount; ++i) {
            pImageMemoryBarriers[i].initialize(&in_struct->pImageMemoryBarriers[i]);
        }
    }
}

void safe_VkDependencyInfoKHR::initialize(const safe_VkDependencyInfoKHR* copy_src)
{
    sType = copy_src->sType;
    dependencyFlags = copy_src->dependencyFlags;
    memoryBarrierCount = copy_src->memoryBarrierCount;
    pMemoryBarriers = nullptr;
    bufferMemoryBarrierCount = copy_src->bufferMemoryBarrierCount;
    pBufferMemoryBarriers = nullptr;
    imageMemoryBarrierCount = copy_src->imageMemoryBarrierCount;
    pImageMemoryBarriers = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (memoryBarrierCount && copy_src->pMemoryBarriers) {
        pMemoryBarriers = new safe_VkMemoryBarrier2KHR[memoryBarrierCount];
        for (uint32_t i = 0; i < memoryBarrierCount; ++i) {
            pMemoryBarriers[i].initialize(&copy_src->pMemoryBarriers[i]);
        }
    }
    if (bufferMemoryBarrierCount && copy_src->pBufferMemoryBarriers) {
        pBufferMemoryBarriers = new safe_VkBufferMemoryBarrier2KHR[bufferMemoryBarrierCount];
        for (uint32_t i = 0; i < bufferMemoryBarrierCount; ++i) {
            pBufferMemoryBarriers[i].initialize(&copy_src->pBufferMemoryBarriers[i]);
        }
    }
    if (imageMemoryBarrierCount && copy_src->pImageMemoryBarriers) {
        pImageMemoryBarriers = new safe_VkImageMemoryBarrier2KHR[imageMemoryBarrierCount];
        for (uint32_t i = 0; i < imageMemoryBarrierCount; ++i) {
            pImageMemoryBarriers[i].initialize(&copy_src->pImageMemoryBarriers[i]);
        }
    }
}

safe_VkSemaphoreSubmitInfoKHR::safe_VkSemaphoreSubmitInfoKHR(const VkSemaphoreSubmitInfoKHR* in_struct) :
    sType(in_struct->sType),
    semaphore(in_struct->semaphore),
    value(in_struct->value),
    stageMask(in_struct->stageMask),
    deviceIndex(in_struct->deviceIndex)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkSemaphoreSubmitInfoKHR::safe_VkSemaphoreSubmitInfoKHR() :
    sType(VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO_KHR),
    pNext(nullptr)
{}

safe_VkSemaphoreSubmitInfoKHR::safe_VkSemaphoreSubmitInfoKHR(const safe_VkSemaphoreSubmitInfoKHR& copy_src)
{
    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    value = copy_src.value;
    stageMask = copy_src.stageMask;
    deviceIndex = copy_src.deviceIndex;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkSemaphoreSubmitInfoKHR& safe_VkSemaphoreSubmitInfoKHR::operator=(const safe_VkSemaphoreSubmitInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    semaphore = copy_src.semaphore;
    value = copy_src.value;
    stageMask = copy_src.stageMask;
    deviceIndex = copy_src.deviceIndex;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkSemaphoreSubmitInfoKHR::~safe_VkSemaphoreSubmitInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSemaphoreSubmitInfoKHR::initialize(const VkSemaphoreSubmitInfoKHR* in_struct)
{
    sType = in_struct->sType;
    semaphore = in_struct->semaphore;
    value = in_struct->value;
    stageMask = in_struct->stageMask;
    deviceIndex = in_struct->deviceIndex;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkSemaphoreSubmitInfoKHR::initialize(const safe_VkSemaphoreSubmitInfoKHR* copy_src)
{
    sType = copy_src->sType;
    semaphore = copy_src->semaphore;
    value = copy_src->value;
    stageMask = copy_src->stageMask;
    deviceIndex = copy_src->deviceIndex;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkCommandBufferSubmitInfoKHR::safe_VkCommandBufferSubmitInfoKHR(const VkCommandBufferSubmitInfoKHR* in_struct) :
    sType(in_struct->sType),
    commandBuffer(in_struct->commandBuffer),
    deviceMask(in_struct->deviceMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCommandBufferSubmitInfoKHR::safe_VkCommandBufferSubmitInfoKHR() :
    sType(VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO_KHR),
    pNext(nullptr)
{}

safe_VkCommandBufferSubmitInfoKHR::safe_VkCommandBufferSubmitInfoKHR(const safe_VkCommandBufferSubmitInfoKHR& copy_src)
{
    sType = copy_src.sType;
    commandBuffer = copy_src.commandBuffer;
    deviceMask = copy_src.deviceMask;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkCommandBufferSubmitInfoKHR& safe_VkCommandBufferSubmitInfoKHR::operator=(const safe_VkCommandBufferSubmitInfoKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    commandBuffer = copy_src.commandBuffer;
    deviceMask = copy_src.deviceMask;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkCommandBufferSubmitInfoKHR::~safe_VkCommandBufferSubmitInfoKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCommandBufferSubmitInfoKHR::initialize(const VkCommandBufferSubmitInfoKHR* in_struct)
{
    sType = in_struct->sType;
    commandBuffer = in_struct->commandBuffer;
    deviceMask = in_struct->deviceMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCommandBufferSubmitInfoKHR::initialize(const safe_VkCommandBufferSubmitInfoKHR* copy_src)
{
    sType = copy_src->sType;
    commandBuffer = copy_src->commandBuffer;
    deviceMask = copy_src->deviceMask;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkSubmitInfo2KHR::safe_VkSubmitInfo2KHR(const VkSubmitInfo2KHR* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    waitSemaphoreInfoCount(in_struct->waitSemaphoreInfoCount),
    pWaitSemaphoreInfos(nullptr),
    commandBufferInfoCount(in_struct->commandBufferInfoCount),
    pCommandBufferInfos(nullptr),
    signalSemaphoreInfoCount(in_struct->signalSemaphoreInfoCount),
    pSignalSemaphoreInfos(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreInfoCount && in_struct->pWaitSemaphoreInfos) {
        pWaitSemaphoreInfos = new safe_VkSemaphoreSubmitInfoKHR[waitSemaphoreInfoCount];
        for (uint32_t i = 0; i < waitSemaphoreInfoCount; ++i) {
            pWaitSemaphoreInfos[i].initialize(&in_struct->pWaitSemaphoreInfos[i]);
        }
    }
    if (commandBufferInfoCount && in_struct->pCommandBufferInfos) {
        pCommandBufferInfos = new safe_VkCommandBufferSubmitInfoKHR[commandBufferInfoCount];
        for (uint32_t i = 0; i < commandBufferInfoCount; ++i) {
            pCommandBufferInfos[i].initialize(&in_struct->pCommandBufferInfos[i]);
        }
    }
    if (signalSemaphoreInfoCount && in_struct->pSignalSemaphoreInfos) {
        pSignalSemaphoreInfos = new safe_VkSemaphoreSubmitInfoKHR[signalSemaphoreInfoCount];
        for (uint32_t i = 0; i < signalSemaphoreInfoCount; ++i) {
            pSignalSemaphoreInfos[i].initialize(&in_struct->pSignalSemaphoreInfos[i]);
        }
    }
}

safe_VkSubmitInfo2KHR::safe_VkSubmitInfo2KHR() :
    sType(VK_STRUCTURE_TYPE_SUBMIT_INFO_2_KHR),
    pNext(nullptr),
    pWaitSemaphoreInfos(nullptr),
    pCommandBufferInfos(nullptr),
    pSignalSemaphoreInfos(nullptr)
{}

safe_VkSubmitInfo2KHR::safe_VkSubmitInfo2KHR(const safe_VkSubmitInfo2KHR& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    waitSemaphoreInfoCount = copy_src.waitSemaphoreInfoCount;
    pWaitSemaphoreInfos = nullptr;
    commandBufferInfoCount = copy_src.commandBufferInfoCount;
    pCommandBufferInfos = nullptr;
    signalSemaphoreInfoCount = copy_src.signalSemaphoreInfoCount;
    pSignalSemaphoreInfos = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (waitSemaphoreInfoCount && copy_src.pWaitSemaphoreInfos) {
        pWaitSemaphoreInfos = new safe_VkSemaphoreSubmitInfoKHR[waitSemaphoreInfoCount];
        for (uint32_t i = 0; i < waitSemaphoreInfoCount; ++i) {
            pWaitSemaphoreInfos[i].initialize(&copy_src.pWaitSemaphoreInfos[i]);
        }
    }
    if (commandBufferInfoCount && copy_src.pCommandBufferInfos) {
        pCommandBufferInfos = new safe_VkCommandBufferSubmitInfoKHR[commandBufferInfoCount];
        for (uint32_t i = 0; i < commandBufferInfoCount; ++i) {
            pCommandBufferInfos[i].initialize(&copy_src.pCommandBufferInfos[i]);
        }
    }
    if (signalSemaphoreInfoCount && copy_src.pSignalSemaphoreInfos) {
        pSignalSemaphoreInfos = new safe_VkSemaphoreSubmitInfoKHR[signalSemaphoreInfoCount];
        for (uint32_t i = 0; i < signalSemaphoreInfoCount; ++i) {
            pSignalSemaphoreInfos[i].initialize(&copy_src.pSignalSemaphoreInfos[i]);
        }
    }
}

safe_VkSubmitInfo2KHR& safe_VkSubmitInfo2KHR::operator=(const safe_VkSubmitInfo2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pWaitSemaphoreInfos)
        delete[] pWaitSemaphoreInfos;
    if (pCommandBufferInfos)
        delete[] pCommandBufferInfos;
    if (pSignalSemaphoreInfos)
        delete[] pSignalSemaphoreInfos;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    waitSemaphoreInfoCount = copy_src.waitSemaphoreInfoCount;
    pWaitSemaphoreInfos = nullptr;
    commandBufferInfoCount = copy_src.commandBufferInfoCount;
    pCommandBufferInfos = nullptr;
    signalSemaphoreInfoCount = copy_src.signalSemaphoreInfoCount;
    pSignalSemaphoreInfos = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (waitSemaphoreInfoCount && copy_src.pWaitSemaphoreInfos) {
        pWaitSemaphoreInfos = new safe_VkSemaphoreSubmitInfoKHR[waitSemaphoreInfoCount];
        for (uint32_t i = 0; i < waitSemaphoreInfoCount; ++i) {
            pWaitSemaphoreInfos[i].initialize(&copy_src.pWaitSemaphoreInfos[i]);
        }
    }
    if (commandBufferInfoCount && copy_src.pCommandBufferInfos) {
        pCommandBufferInfos = new safe_VkCommandBufferSubmitInfoKHR[commandBufferInfoCount];
        for (uint32_t i = 0; i < commandBufferInfoCount; ++i) {
            pCommandBufferInfos[i].initialize(&copy_src.pCommandBufferInfos[i]);
        }
    }
    if (signalSemaphoreInfoCount && copy_src.pSignalSemaphoreInfos) {
        pSignalSemaphoreInfos = new safe_VkSemaphoreSubmitInfoKHR[signalSemaphoreInfoCount];
        for (uint32_t i = 0; i < signalSemaphoreInfoCount; ++i) {
            pSignalSemaphoreInfos[i].initialize(&copy_src.pSignalSemaphoreInfos[i]);
        }
    }

    return *this;
}

safe_VkSubmitInfo2KHR::~safe_VkSubmitInfo2KHR()
{
    if (pWaitSemaphoreInfos)
        delete[] pWaitSemaphoreInfos;
    if (pCommandBufferInfos)
        delete[] pCommandBufferInfos;
    if (pSignalSemaphoreInfos)
        delete[] pSignalSemaphoreInfos;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkSubmitInfo2KHR::initialize(const VkSubmitInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    waitSemaphoreInfoCount = in_struct->waitSemaphoreInfoCount;
    pWaitSemaphoreInfos = nullptr;
    commandBufferInfoCount = in_struct->commandBufferInfoCount;
    pCommandBufferInfos = nullptr;
    signalSemaphoreInfoCount = in_struct->signalSemaphoreInfoCount;
    pSignalSemaphoreInfos = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (waitSemaphoreInfoCount && in_struct->pWaitSemaphoreInfos) {
        pWaitSemaphoreInfos = new safe_VkSemaphoreSubmitInfoKHR[waitSemaphoreInfoCount];
        for (uint32_t i = 0; i < waitSemaphoreInfoCount; ++i) {
            pWaitSemaphoreInfos[i].initialize(&in_struct->pWaitSemaphoreInfos[i]);
        }
    }
    if (commandBufferInfoCount && in_struct->pCommandBufferInfos) {
        pCommandBufferInfos = new safe_VkCommandBufferSubmitInfoKHR[commandBufferInfoCount];
        for (uint32_t i = 0; i < commandBufferInfoCount; ++i) {
            pCommandBufferInfos[i].initialize(&in_struct->pCommandBufferInfos[i]);
        }
    }
    if (signalSemaphoreInfoCount && in_struct->pSignalSemaphoreInfos) {
        pSignalSemaphoreInfos = new safe_VkSemaphoreSubmitInfoKHR[signalSemaphoreInfoCount];
        for (uint32_t i = 0; i < signalSemaphoreInfoCount; ++i) {
            pSignalSemaphoreInfos[i].initialize(&in_struct->pSignalSemaphoreInfos[i]);
        }
    }
}

void safe_VkSubmitInfo2KHR::initialize(const safe_VkSubmitInfo2KHR* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    waitSemaphoreInfoCount = copy_src->waitSemaphoreInfoCount;
    pWaitSemaphoreInfos = nullptr;
    commandBufferInfoCount = copy_src->commandBufferInfoCount;
    pCommandBufferInfos = nullptr;
    signalSemaphoreInfoCount = copy_src->signalSemaphoreInfoCount;
    pSignalSemaphoreInfos = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (waitSemaphoreInfoCount && copy_src->pWaitSemaphoreInfos) {
        pWaitSemaphoreInfos = new safe_VkSemaphoreSubmitInfoKHR[waitSemaphoreInfoCount];
        for (uint32_t i = 0; i < waitSemaphoreInfoCount; ++i) {
            pWaitSemaphoreInfos[i].initialize(&copy_src->pWaitSemaphoreInfos[i]);
        }
    }
    if (commandBufferInfoCount && copy_src->pCommandBufferInfos) {
        pCommandBufferInfos = new safe_VkCommandBufferSubmitInfoKHR[commandBufferInfoCount];
        for (uint32_t i = 0; i < commandBufferInfoCount; ++i) {
            pCommandBufferInfos[i].initialize(&copy_src->pCommandBufferInfos[i]);
        }
    }
    if (signalSemaphoreInfoCount && copy_src->pSignalSemaphoreInfos) {
        pSignalSemaphoreInfos = new safe_VkSemaphoreSubmitInfoKHR[signalSemaphoreInfoCount];
        for (uint32_t i = 0; i < signalSemaphoreInfoCount; ++i) {
            pSignalSemaphoreInfos[i].initialize(&copy_src->pSignalSemaphoreInfos[i]);
        }
    }
}

safe_VkPhysicalDeviceSynchronization2FeaturesKHR::safe_VkPhysicalDeviceSynchronization2FeaturesKHR(const VkPhysicalDeviceSynchronization2FeaturesKHR* in_struct) :
    sType(in_struct->sType),
    synchronization2(in_struct->synchronization2)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceSynchronization2FeaturesKHR::safe_VkPhysicalDeviceSynchronization2FeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceSynchronization2FeaturesKHR::safe_VkPhysicalDeviceSynchronization2FeaturesKHR(const safe_VkPhysicalDeviceSynchronization2FeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    synchronization2 = copy_src.synchronization2;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceSynchronization2FeaturesKHR& safe_VkPhysicalDeviceSynchronization2FeaturesKHR::operator=(const safe_VkPhysicalDeviceSynchronization2FeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    synchronization2 = copy_src.synchronization2;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceSynchronization2FeaturesKHR::~safe_VkPhysicalDeviceSynchronization2FeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceSynchronization2FeaturesKHR::initialize(const VkPhysicalDeviceSynchronization2FeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    synchronization2 = in_struct->synchronization2;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceSynchronization2FeaturesKHR::initialize(const safe_VkPhysicalDeviceSynchronization2FeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    synchronization2 = copy_src->synchronization2;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkQueueFamilyCheckpointProperties2NV::safe_VkQueueFamilyCheckpointProperties2NV(const VkQueueFamilyCheckpointProperties2NV* in_struct) :
    sType(in_struct->sType),
    checkpointExecutionStageMask(in_struct->checkpointExecutionStageMask)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkQueueFamilyCheckpointProperties2NV::safe_VkQueueFamilyCheckpointProperties2NV() :
    sType(VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV),
    pNext(nullptr)
{}

safe_VkQueueFamilyCheckpointProperties2NV::safe_VkQueueFamilyCheckpointProperties2NV(const safe_VkQueueFamilyCheckpointProperties2NV& copy_src)
{
    sType = copy_src.sType;
    checkpointExecutionStageMask = copy_src.checkpointExecutionStageMask;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkQueueFamilyCheckpointProperties2NV& safe_VkQueueFamilyCheckpointProperties2NV::operator=(const safe_VkQueueFamilyCheckpointProperties2NV& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    checkpointExecutionStageMask = copy_src.checkpointExecutionStageMask;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkQueueFamilyCheckpointProperties2NV::~safe_VkQueueFamilyCheckpointProperties2NV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkQueueFamilyCheckpointProperties2NV::initialize(const VkQueueFamilyCheckpointProperties2NV* in_struct)
{
    sType = in_struct->sType;
    checkpointExecutionStageMask = in_struct->checkpointExecutionStageMask;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkQueueFamilyCheckpointProperties2NV::initialize(const safe_VkQueueFamilyCheckpointProperties2NV* copy_src)
{
    sType = copy_src->sType;
    checkpointExecutionStageMask = copy_src->checkpointExecutionStageMask;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkCheckpointData2NV::safe_VkCheckpointData2NV(const VkCheckpointData2NV* in_struct) :
    sType(in_struct->sType),
    stage(in_struct->stage),
    pCheckpointMarker(in_struct->pCheckpointMarker)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCheckpointData2NV::safe_VkCheckpointData2NV() :
    sType(VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV),
    pNext(nullptr),
    pCheckpointMarker(nullptr)
{}

safe_VkCheckpointData2NV::safe_VkCheckpointData2NV(const safe_VkCheckpointData2NV& copy_src)
{
    sType = copy_src.sType;
    stage = copy_src.stage;
    pCheckpointMarker = copy_src.pCheckpointMarker;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkCheckpointData2NV& safe_VkCheckpointData2NV::operator=(const safe_VkCheckpointData2NV& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    stage = copy_src.stage;
    pCheckpointMarker = copy_src.pCheckpointMarker;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkCheckpointData2NV::~safe_VkCheckpointData2NV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCheckpointData2NV::initialize(const VkCheckpointData2NV* in_struct)
{
    sType = in_struct->sType;
    stage = in_struct->stage;
    pCheckpointMarker = in_struct->pCheckpointMarker;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCheckpointData2NV::initialize(const safe_VkCheckpointData2NV* copy_src)
{
    sType = copy_src->sType;
    stage = copy_src->stage;
    pCheckpointMarker = copy_src->pCheckpointMarker;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR::safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR(const VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    shaderSubgroupUniformControlFlow(in_struct->shaderSubgroupUniformControlFlow)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR::safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR::safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR(const safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    shaderSubgroupUniformControlFlow = copy_src.shaderSubgroupUniformControlFlow;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR& safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR::operator=(const safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    shaderSubgroupUniformControlFlow = copy_src.shaderSubgroupUniformControlFlow;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR::~safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR::initialize(const VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    shaderSubgroupUniformControlFlow = in_struct->shaderSubgroupUniformControlFlow;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR::initialize(const safe_VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    shaderSubgroupUniformControlFlow = copy_src->shaderSubgroupUniformControlFlow;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR::safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    shaderZeroInitializeWorkgroupMemory(in_struct->shaderZeroInitializeWorkgroupMemory)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR::safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR::safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR(const safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    shaderZeroInitializeWorkgroupMemory = copy_src.shaderZeroInitializeWorkgroupMemory;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR& safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR::operator=(const safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    shaderZeroInitializeWorkgroupMemory = copy_src.shaderZeroInitializeWorkgroupMemory;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR::~safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR::initialize(const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    shaderZeroInitializeWorkgroupMemory = in_struct->shaderZeroInitializeWorkgroupMemory;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR::initialize(const safe_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    shaderZeroInitializeWorkgroupMemory = copy_src->shaderZeroInitializeWorkgroupMemory;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR::safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR(const VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR* in_struct) :
    sType(in_struct->sType),
    workgroupMemoryExplicitLayout(in_struct->workgroupMemoryExplicitLayout),
    workgroupMemoryExplicitLayoutScalarBlockLayout(in_struct->workgroupMemoryExplicitLayoutScalarBlockLayout),
    workgroupMemoryExplicitLayout8BitAccess(in_struct->workgroupMemoryExplicitLayout8BitAccess),
    workgroupMemoryExplicitLayout16BitAccess(in_struct->workgroupMemoryExplicitLayout16BitAccess)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR::safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR::safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR(const safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR& copy_src)
{
    sType = copy_src.sType;
    workgroupMemoryExplicitLayout = copy_src.workgroupMemoryExplicitLayout;
    workgroupMemoryExplicitLayoutScalarBlockLayout = copy_src.workgroupMemoryExplicitLayoutScalarBlockLayout;
    workgroupMemoryExplicitLayout8BitAccess = copy_src.workgroupMemoryExplicitLayout8BitAccess;
    workgroupMemoryExplicitLayout16BitAccess = copy_src.workgroupMemoryExplicitLayout16BitAccess;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR& safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR::operator=(const safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    workgroupMemoryExplicitLayout = copy_src.workgroupMemoryExplicitLayout;
    workgroupMemoryExplicitLayoutScalarBlockLayout = copy_src.workgroupMemoryExplicitLayoutScalarBlockLayout;
    workgroupMemoryExplicitLayout8BitAccess = copy_src.workgroupMemoryExplicitLayout8BitAccess;
    workgroupMemoryExplicitLayout16BitAccess = copy_src.workgroupMemoryExplicitLayout16BitAccess;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR::~safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR::initialize(const VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR* in_struct)
{
    sType = in_struct->sType;
    workgroupMemoryExplicitLayout = in_struct->workgroupMemoryExplicitLayout;
    workgroupMemoryExplicitLayoutScalarBlockLayout = in_struct->workgroupMemoryExplicitLayoutScalarBlockLayout;
    workgroupMemoryExplicitLayout8BitAccess = in_struct->workgroupMemoryExplicitLayout8BitAccess;
    workgroupMemoryExplicitLayout16BitAccess = in_struct->workgroupMemoryExplicitLayout16BitAccess;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR::initialize(const safe_VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR* copy_src)
{
    sType = copy_src->sType;
    workgroupMemoryExplicitLayout = copy_src->workgroupMemoryExplicitLayout;
    workgroupMemoryExplicitLayoutScalarBlockLayout = copy_src->workgroupMemoryExplicitLayoutScalarBlockLayout;
    workgroupMemoryExplicitLayout8BitAccess = copy_src->workgroupMemoryExplicitLayout8BitAccess;
    workgroupMemoryExplicitLayout16BitAccess = copy_src->workgroupMemoryExplicitLayout16BitAccess;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkBufferCopy2KHR::safe_VkBufferCopy2KHR(const VkBufferCopy2KHR* in_struct) :
    sType(in_struct->sType),
    srcOffset(in_struct->srcOffset),
    dstOffset(in_struct->dstOffset),
    size(in_struct->size)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferCopy2KHR::safe_VkBufferCopy2KHR() :
    sType(VK_STRUCTURE_TYPE_BUFFER_COPY_2_KHR),
    pNext(nullptr)
{}

safe_VkBufferCopy2KHR::safe_VkBufferCopy2KHR(const safe_VkBufferCopy2KHR& copy_src)
{
    sType = copy_src.sType;
    srcOffset = copy_src.srcOffset;
    dstOffset = copy_src.dstOffset;
    size = copy_src.size;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBufferCopy2KHR& safe_VkBufferCopy2KHR::operator=(const safe_VkBufferCopy2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcOffset = copy_src.srcOffset;
    dstOffset = copy_src.dstOffset;
    size = copy_src.size;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBufferCopy2KHR::~safe_VkBufferCopy2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferCopy2KHR::initialize(const VkBufferCopy2KHR* in_struct)
{
    sType = in_struct->sType;
    srcOffset = in_struct->srcOffset;
    dstOffset = in_struct->dstOffset;
    size = in_struct->size;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferCopy2KHR::initialize(const safe_VkBufferCopy2KHR* copy_src)
{
    sType = copy_src->sType;
    srcOffset = copy_src->srcOffset;
    dstOffset = copy_src->dstOffset;
    size = copy_src->size;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkCopyBufferInfo2KHR::safe_VkCopyBufferInfo2KHR(const VkCopyBufferInfo2KHR* in_struct) :
    sType(in_struct->sType),
    srcBuffer(in_struct->srcBuffer),
    dstBuffer(in_struct->dstBuffer),
    regionCount(in_struct->regionCount),
    pRegions(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkBufferCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

safe_VkCopyBufferInfo2KHR::safe_VkCopyBufferInfo2KHR() :
    sType(VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2_KHR),
    pNext(nullptr),
    pRegions(nullptr)
{}

safe_VkCopyBufferInfo2KHR::safe_VkCopyBufferInfo2KHR(const safe_VkCopyBufferInfo2KHR& copy_src)
{
    sType = copy_src.sType;
    srcBuffer = copy_src.srcBuffer;
    dstBuffer = copy_src.dstBuffer;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkBufferCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }
}

safe_VkCopyBufferInfo2KHR& safe_VkCopyBufferInfo2KHR::operator=(const safe_VkCopyBufferInfo2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcBuffer = copy_src.srcBuffer;
    dstBuffer = copy_src.dstBuffer;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkBufferCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }

    return *this;
}

safe_VkCopyBufferInfo2KHR::~safe_VkCopyBufferInfo2KHR()
{
    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCopyBufferInfo2KHR::initialize(const VkCopyBufferInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    srcBuffer = in_struct->srcBuffer;
    dstBuffer = in_struct->dstBuffer;
    regionCount = in_struct->regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkBufferCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

void safe_VkCopyBufferInfo2KHR::initialize(const safe_VkCopyBufferInfo2KHR* copy_src)
{
    sType = copy_src->sType;
    srcBuffer = copy_src->srcBuffer;
    dstBuffer = copy_src->dstBuffer;
    regionCount = copy_src->regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (regionCount && copy_src->pRegions) {
        pRegions = new safe_VkBufferCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src->pRegions[i]);
        }
    }
}

safe_VkImageCopy2KHR::safe_VkImageCopy2KHR(const VkImageCopy2KHR* in_struct) :
    sType(in_struct->sType),
    srcSubresource(in_struct->srcSubresource),
    srcOffset(in_struct->srcOffset),
    dstSubresource(in_struct->dstSubresource),
    dstOffset(in_struct->dstOffset),
    extent(in_struct->extent)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageCopy2KHR::safe_VkImageCopy2KHR() :
    sType(VK_STRUCTURE_TYPE_IMAGE_COPY_2_KHR),
    pNext(nullptr)
{}

safe_VkImageCopy2KHR::safe_VkImageCopy2KHR(const safe_VkImageCopy2KHR& copy_src)
{
    sType = copy_src.sType;
    srcSubresource = copy_src.srcSubresource;
    srcOffset = copy_src.srcOffset;
    dstSubresource = copy_src.dstSubresource;
    dstOffset = copy_src.dstOffset;
    extent = copy_src.extent;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageCopy2KHR& safe_VkImageCopy2KHR::operator=(const safe_VkImageCopy2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcSubresource = copy_src.srcSubresource;
    srcOffset = copy_src.srcOffset;
    dstSubresource = copy_src.dstSubresource;
    dstOffset = copy_src.dstOffset;
    extent = copy_src.extent;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageCopy2KHR::~safe_VkImageCopy2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageCopy2KHR::initialize(const VkImageCopy2KHR* in_struct)
{
    sType = in_struct->sType;
    srcSubresource = in_struct->srcSubresource;
    srcOffset = in_struct->srcOffset;
    dstSubresource = in_struct->dstSubresource;
    dstOffset = in_struct->dstOffset;
    extent = in_struct->extent;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageCopy2KHR::initialize(const safe_VkImageCopy2KHR* copy_src)
{
    sType = copy_src->sType;
    srcSubresource = copy_src->srcSubresource;
    srcOffset = copy_src->srcOffset;
    dstSubresource = copy_src->dstSubresource;
    dstOffset = copy_src->dstOffset;
    extent = copy_src->extent;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkCopyImageInfo2KHR::safe_VkCopyImageInfo2KHR(const VkCopyImageInfo2KHR* in_struct) :
    sType(in_struct->sType),
    srcImage(in_struct->srcImage),
    srcImageLayout(in_struct->srcImageLayout),
    dstImage(in_struct->dstImage),
    dstImageLayout(in_struct->dstImageLayout),
    regionCount(in_struct->regionCount),
    pRegions(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

safe_VkCopyImageInfo2KHR::safe_VkCopyImageInfo2KHR() :
    sType(VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2_KHR),
    pNext(nullptr),
    pRegions(nullptr)
{}

safe_VkCopyImageInfo2KHR::safe_VkCopyImageInfo2KHR(const safe_VkCopyImageInfo2KHR& copy_src)
{
    sType = copy_src.sType;
    srcImage = copy_src.srcImage;
    srcImageLayout = copy_src.srcImageLayout;
    dstImage = copy_src.dstImage;
    dstImageLayout = copy_src.dstImageLayout;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }
}

safe_VkCopyImageInfo2KHR& safe_VkCopyImageInfo2KHR::operator=(const safe_VkCopyImageInfo2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcImage = copy_src.srcImage;
    srcImageLayout = copy_src.srcImageLayout;
    dstImage = copy_src.dstImage;
    dstImageLayout = copy_src.dstImageLayout;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }

    return *this;
}

safe_VkCopyImageInfo2KHR::~safe_VkCopyImageInfo2KHR()
{
    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCopyImageInfo2KHR::initialize(const VkCopyImageInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    srcImage = in_struct->srcImage;
    srcImageLayout = in_struct->srcImageLayout;
    dstImage = in_struct->dstImage;
    dstImageLayout = in_struct->dstImageLayout;
    regionCount = in_struct->regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

void safe_VkCopyImageInfo2KHR::initialize(const safe_VkCopyImageInfo2KHR* copy_src)
{
    sType = copy_src->sType;
    srcImage = copy_src->srcImage;
    srcImageLayout = copy_src->srcImageLayout;
    dstImage = copy_src->dstImage;
    dstImageLayout = copy_src->dstImageLayout;
    regionCount = copy_src->regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (regionCount && copy_src->pRegions) {
        pRegions = new safe_VkImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src->pRegions[i]);
        }
    }
}

safe_VkBufferImageCopy2KHR::safe_VkBufferImageCopy2KHR(const VkBufferImageCopy2KHR* in_struct) :
    sType(in_struct->sType),
    bufferOffset(in_struct->bufferOffset),
    bufferRowLength(in_struct->bufferRowLength),
    bufferImageHeight(in_struct->bufferImageHeight),
    imageSubresource(in_struct->imageSubresource),
    imageOffset(in_struct->imageOffset),
    imageExtent(in_struct->imageExtent)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkBufferImageCopy2KHR::safe_VkBufferImageCopy2KHR() :
    sType(VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2_KHR),
    pNext(nullptr)
{}

safe_VkBufferImageCopy2KHR::safe_VkBufferImageCopy2KHR(const safe_VkBufferImageCopy2KHR& copy_src)
{
    sType = copy_src.sType;
    bufferOffset = copy_src.bufferOffset;
    bufferRowLength = copy_src.bufferRowLength;
    bufferImageHeight = copy_src.bufferImageHeight;
    imageSubresource = copy_src.imageSubresource;
    imageOffset = copy_src.imageOffset;
    imageExtent = copy_src.imageExtent;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkBufferImageCopy2KHR& safe_VkBufferImageCopy2KHR::operator=(const safe_VkBufferImageCopy2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    bufferOffset = copy_src.bufferOffset;
    bufferRowLength = copy_src.bufferRowLength;
    bufferImageHeight = copy_src.bufferImageHeight;
    imageSubresource = copy_src.imageSubresource;
    imageOffset = copy_src.imageOffset;
    imageExtent = copy_src.imageExtent;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkBufferImageCopy2KHR::~safe_VkBufferImageCopy2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBufferImageCopy2KHR::initialize(const VkBufferImageCopy2KHR* in_struct)
{
    sType = in_struct->sType;
    bufferOffset = in_struct->bufferOffset;
    bufferRowLength = in_struct->bufferRowLength;
    bufferImageHeight = in_struct->bufferImageHeight;
    imageSubresource = in_struct->imageSubresource;
    imageOffset = in_struct->imageOffset;
    imageExtent = in_struct->imageExtent;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkBufferImageCopy2KHR::initialize(const safe_VkBufferImageCopy2KHR* copy_src)
{
    sType = copy_src->sType;
    bufferOffset = copy_src->bufferOffset;
    bufferRowLength = copy_src->bufferRowLength;
    bufferImageHeight = copy_src->bufferImageHeight;
    imageSubresource = copy_src->imageSubresource;
    imageOffset = copy_src->imageOffset;
    imageExtent = copy_src->imageExtent;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkCopyBufferToImageInfo2KHR::safe_VkCopyBufferToImageInfo2KHR(const VkCopyBufferToImageInfo2KHR* in_struct) :
    sType(in_struct->sType),
    srcBuffer(in_struct->srcBuffer),
    dstImage(in_struct->dstImage),
    dstImageLayout(in_struct->dstImageLayout),
    regionCount(in_struct->regionCount),
    pRegions(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkBufferImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

safe_VkCopyBufferToImageInfo2KHR::safe_VkCopyBufferToImageInfo2KHR() :
    sType(VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2_KHR),
    pNext(nullptr),
    pRegions(nullptr)
{}

safe_VkCopyBufferToImageInfo2KHR::safe_VkCopyBufferToImageInfo2KHR(const safe_VkCopyBufferToImageInfo2KHR& copy_src)
{
    sType = copy_src.sType;
    srcBuffer = copy_src.srcBuffer;
    dstImage = copy_src.dstImage;
    dstImageLayout = copy_src.dstImageLayout;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkBufferImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }
}

safe_VkCopyBufferToImageInfo2KHR& safe_VkCopyBufferToImageInfo2KHR::operator=(const safe_VkCopyBufferToImageInfo2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcBuffer = copy_src.srcBuffer;
    dstImage = copy_src.dstImage;
    dstImageLayout = copy_src.dstImageLayout;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkBufferImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }

    return *this;
}

safe_VkCopyBufferToImageInfo2KHR::~safe_VkCopyBufferToImageInfo2KHR()
{
    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCopyBufferToImageInfo2KHR::initialize(const VkCopyBufferToImageInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    srcBuffer = in_struct->srcBuffer;
    dstImage = in_struct->dstImage;
    dstImageLayout = in_struct->dstImageLayout;
    regionCount = in_struct->regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkBufferImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

void safe_VkCopyBufferToImageInfo2KHR::initialize(const safe_VkCopyBufferToImageInfo2KHR* copy_src)
{
    sType = copy_src->sType;
    srcBuffer = copy_src->srcBuffer;
    dstImage = copy_src->dstImage;
    dstImageLayout = copy_src->dstImageLayout;
    regionCount = copy_src->regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (regionCount && copy_src->pRegions) {
        pRegions = new safe_VkBufferImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src->pRegions[i]);
        }
    }
}

safe_VkCopyImageToBufferInfo2KHR::safe_VkCopyImageToBufferInfo2KHR(const VkCopyImageToBufferInfo2KHR* in_struct) :
    sType(in_struct->sType),
    srcImage(in_struct->srcImage),
    srcImageLayout(in_struct->srcImageLayout),
    dstBuffer(in_struct->dstBuffer),
    regionCount(in_struct->regionCount),
    pRegions(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkBufferImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

safe_VkCopyImageToBufferInfo2KHR::safe_VkCopyImageToBufferInfo2KHR() :
    sType(VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2_KHR),
    pNext(nullptr),
    pRegions(nullptr)
{}

safe_VkCopyImageToBufferInfo2KHR::safe_VkCopyImageToBufferInfo2KHR(const safe_VkCopyImageToBufferInfo2KHR& copy_src)
{
    sType = copy_src.sType;
    srcImage = copy_src.srcImage;
    srcImageLayout = copy_src.srcImageLayout;
    dstBuffer = copy_src.dstBuffer;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkBufferImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }
}

safe_VkCopyImageToBufferInfo2KHR& safe_VkCopyImageToBufferInfo2KHR::operator=(const safe_VkCopyImageToBufferInfo2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcImage = copy_src.srcImage;
    srcImageLayout = copy_src.srcImageLayout;
    dstBuffer = copy_src.dstBuffer;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkBufferImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }

    return *this;
}

safe_VkCopyImageToBufferInfo2KHR::~safe_VkCopyImageToBufferInfo2KHR()
{
    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCopyImageToBufferInfo2KHR::initialize(const VkCopyImageToBufferInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    srcImage = in_struct->srcImage;
    srcImageLayout = in_struct->srcImageLayout;
    dstBuffer = in_struct->dstBuffer;
    regionCount = in_struct->regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkBufferImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

void safe_VkCopyImageToBufferInfo2KHR::initialize(const safe_VkCopyImageToBufferInfo2KHR* copy_src)
{
    sType = copy_src->sType;
    srcImage = copy_src->srcImage;
    srcImageLayout = copy_src->srcImageLayout;
    dstBuffer = copy_src->dstBuffer;
    regionCount = copy_src->regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (regionCount && copy_src->pRegions) {
        pRegions = new safe_VkBufferImageCopy2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src->pRegions[i]);
        }
    }
}

safe_VkImageBlit2KHR::safe_VkImageBlit2KHR(const VkImageBlit2KHR* in_struct) :
    sType(in_struct->sType),
    srcSubresource(in_struct->srcSubresource),
    dstSubresource(in_struct->dstSubresource)
{
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        srcOffsets[i] = in_struct->srcOffsets[i];
    }
    for (uint32_t i = 0; i < 2; ++i) {
        dstOffsets[i] = in_struct->dstOffsets[i];
    }
}

safe_VkImageBlit2KHR::safe_VkImageBlit2KHR() :
    sType(VK_STRUCTURE_TYPE_IMAGE_BLIT_2_KHR),
    pNext(nullptr)
{}

safe_VkImageBlit2KHR::safe_VkImageBlit2KHR(const safe_VkImageBlit2KHR& copy_src)
{
    sType = copy_src.sType;
    srcSubresource = copy_src.srcSubresource;
    dstSubresource = copy_src.dstSubresource;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        srcOffsets[i] = copy_src.srcOffsets[i];
    }
    for (uint32_t i = 0; i < 2; ++i) {
        dstOffsets[i] = copy_src.dstOffsets[i];
    }
}

safe_VkImageBlit2KHR& safe_VkImageBlit2KHR::operator=(const safe_VkImageBlit2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcSubresource = copy_src.srcSubresource;
    dstSubresource = copy_src.dstSubresource;
    pNext = SafePnextCopy(copy_src.pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        srcOffsets[i] = copy_src.srcOffsets[i];
    }
    for (uint32_t i = 0; i < 2; ++i) {
        dstOffsets[i] = copy_src.dstOffsets[i];
    }

    return *this;
}

safe_VkImageBlit2KHR::~safe_VkImageBlit2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageBlit2KHR::initialize(const VkImageBlit2KHR* in_struct)
{
    sType = in_struct->sType;
    srcSubresource = in_struct->srcSubresource;
    dstSubresource = in_struct->dstSubresource;
    pNext = SafePnextCopy(in_struct->pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        srcOffsets[i] = in_struct->srcOffsets[i];
    }
    for (uint32_t i = 0; i < 2; ++i) {
        dstOffsets[i] = in_struct->dstOffsets[i];
    }
}

void safe_VkImageBlit2KHR::initialize(const safe_VkImageBlit2KHR* copy_src)
{
    sType = copy_src->sType;
    srcSubresource = copy_src->srcSubresource;
    dstSubresource = copy_src->dstSubresource;
    pNext = SafePnextCopy(copy_src->pNext);
    for (uint32_t i = 0; i < 2; ++i) {
        srcOffsets[i] = copy_src->srcOffsets[i];
    }
    for (uint32_t i = 0; i < 2; ++i) {
        dstOffsets[i] = copy_src->dstOffsets[i];
    }
}

safe_VkBlitImageInfo2KHR::safe_VkBlitImageInfo2KHR(const VkBlitImageInfo2KHR* in_struct) :
    sType(in_struct->sType),
    srcImage(in_struct->srcImage),
    srcImageLayout(in_struct->srcImageLayout),
    dstImage(in_struct->dstImage),
    dstImageLayout(in_struct->dstImageLayout),
    regionCount(in_struct->regionCount),
    pRegions(nullptr),
    filter(in_struct->filter)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkImageBlit2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

safe_VkBlitImageInfo2KHR::safe_VkBlitImageInfo2KHR() :
    sType(VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2_KHR),
    pNext(nullptr),
    pRegions(nullptr)
{}

safe_VkBlitImageInfo2KHR::safe_VkBlitImageInfo2KHR(const safe_VkBlitImageInfo2KHR& copy_src)
{
    sType = copy_src.sType;
    srcImage = copy_src.srcImage;
    srcImageLayout = copy_src.srcImageLayout;
    dstImage = copy_src.dstImage;
    dstImageLayout = copy_src.dstImageLayout;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    filter = copy_src.filter;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkImageBlit2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }
}

safe_VkBlitImageInfo2KHR& safe_VkBlitImageInfo2KHR::operator=(const safe_VkBlitImageInfo2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcImage = copy_src.srcImage;
    srcImageLayout = copy_src.srcImageLayout;
    dstImage = copy_src.dstImage;
    dstImageLayout = copy_src.dstImageLayout;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    filter = copy_src.filter;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkImageBlit2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }

    return *this;
}

safe_VkBlitImageInfo2KHR::~safe_VkBlitImageInfo2KHR()
{
    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkBlitImageInfo2KHR::initialize(const VkBlitImageInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    srcImage = in_struct->srcImage;
    srcImageLayout = in_struct->srcImageLayout;
    dstImage = in_struct->dstImage;
    dstImageLayout = in_struct->dstImageLayout;
    regionCount = in_struct->regionCount;
    pRegions = nullptr;
    filter = in_struct->filter;
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkImageBlit2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

void safe_VkBlitImageInfo2KHR::initialize(const safe_VkBlitImageInfo2KHR* copy_src)
{
    sType = copy_src->sType;
    srcImage = copy_src->srcImage;
    srcImageLayout = copy_src->srcImageLayout;
    dstImage = copy_src->dstImage;
    dstImageLayout = copy_src->dstImageLayout;
    regionCount = copy_src->regionCount;
    pRegions = nullptr;
    filter = copy_src->filter;
    pNext = SafePnextCopy(copy_src->pNext);
    if (regionCount && copy_src->pRegions) {
        pRegions = new safe_VkImageBlit2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src->pRegions[i]);
        }
    }
}

safe_VkImageResolve2KHR::safe_VkImageResolve2KHR(const VkImageResolve2KHR* in_struct) :
    sType(in_struct->sType),
    srcSubresource(in_struct->srcSubresource),
    srcOffset(in_struct->srcOffset),
    dstSubresource(in_struct->dstSubresource),
    dstOffset(in_struct->dstOffset),
    extent(in_struct->extent)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageResolve2KHR::safe_VkImageResolve2KHR() :
    sType(VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2_KHR),
    pNext(nullptr)
{}

safe_VkImageResolve2KHR::safe_VkImageResolve2KHR(const safe_VkImageResolve2KHR& copy_src)
{
    sType = copy_src.sType;
    srcSubresource = copy_src.srcSubresource;
    srcOffset = copy_src.srcOffset;
    dstSubresource = copy_src.dstSubresource;
    dstOffset = copy_src.dstOffset;
    extent = copy_src.extent;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageResolve2KHR& safe_VkImageResolve2KHR::operator=(const safe_VkImageResolve2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcSubresource = copy_src.srcSubresource;
    srcOffset = copy_src.srcOffset;
    dstSubresource = copy_src.dstSubresource;
    dstOffset = copy_src.dstOffset;
    extent = copy_src.extent;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageResolve2KHR::~safe_VkImageResolve2KHR()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageResolve2KHR::initialize(const VkImageResolve2KHR* in_struct)
{
    sType = in_struct->sType;
    srcSubresource = in_struct->srcSubresource;
    srcOffset = in_struct->srcOffset;
    dstSubresource = in_struct->dstSubresource;
    dstOffset = in_struct->dstOffset;
    extent = in_struct->extent;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageResolve2KHR::initialize(const safe_VkImageResolve2KHR* copy_src)
{
    sType = copy_src->sType;
    srcSubresource = copy_src->srcSubresource;
    srcOffset = copy_src->srcOffset;
    dstSubresource = copy_src->dstSubresource;
    dstOffset = copy_src->dstOffset;
    extent = copy_src->extent;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkResolveImageInfo2KHR::safe_VkResolveImageInfo2KHR(const VkResolveImageInfo2KHR* in_struct) :
    sType(in_struct->sType),
    srcImage(in_struct->srcImage),
    srcImageLayout(in_struct->srcImageLayout),
    dstImage(in_struct->dstImage),
    dstImageLayout(in_struct->dstImageLayout),
    regionCount(in_struct->regionCount),
    pRegions(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkImageResolve2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

safe_VkResolveImageInfo2KHR::safe_VkResolveImageInfo2KHR() :
    sType(VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2_KHR),
    pNext(nullptr),
    pRegions(nullptr)
{}

safe_VkResolveImageInfo2KHR::safe_VkResolveImageInfo2KHR(const safe_VkResolveImageInfo2KHR& copy_src)
{
    sType = copy_src.sType;
    srcImage = copy_src.srcImage;
    srcImageLayout = copy_src.srcImageLayout;
    dstImage = copy_src.dstImage;
    dstImageLayout = copy_src.dstImageLayout;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkImageResolve2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }
}

safe_VkResolveImageInfo2KHR& safe_VkResolveImageInfo2KHR::operator=(const safe_VkResolveImageInfo2KHR& copy_src)
{
    if (&copy_src == this) return *this;

    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    srcImage = copy_src.srcImage;
    srcImageLayout = copy_src.srcImageLayout;
    dstImage = copy_src.dstImage;
    dstImageLayout = copy_src.dstImageLayout;
    regionCount = copy_src.regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (regionCount && copy_src.pRegions) {
        pRegions = new safe_VkImageResolve2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src.pRegions[i]);
        }
    }

    return *this;
}

safe_VkResolveImageInfo2KHR::~safe_VkResolveImageInfo2KHR()
{
    if (pRegions)
        delete[] pRegions;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkResolveImageInfo2KHR::initialize(const VkResolveImageInfo2KHR* in_struct)
{
    sType = in_struct->sType;
    srcImage = in_struct->srcImage;
    srcImageLayout = in_struct->srcImageLayout;
    dstImage = in_struct->dstImage;
    dstImageLayout = in_struct->dstImageLayout;
    regionCount = in_struct->regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (regionCount && in_struct->pRegions) {
        pRegions = new safe_VkImageResolve2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&in_struct->pRegions[i]);
        }
    }
}

void safe_VkResolveImageInfo2KHR::initialize(const safe_VkResolveImageInfo2KHR* copy_src)
{
    sType = copy_src->sType;
    srcImage = copy_src->srcImage;
    srcImageLayout = copy_src->srcImageLayout;
    dstImage = copy_src->dstImage;
    dstImageLayout = copy_src->dstImageLayout;
    regionCount = copy_src->regionCount;
    pRegions = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (regionCount && copy_src->pRegions) {
        pRegions = new safe_VkImageResolve2KHR[regionCount];
        for (uint32_t i = 0; i < regionCount; ++i) {
            pRegions[i].initialize(&copy_src->pRegions[i]);
        }
    }
}

safe_VkDebugReportCallbackCreateInfoEXT::safe_VkDebugReportCallbackCreateInfoEXT(const VkDebugReportCallbackCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pfnCallback(in_struct->pfnCallback),
    pUserData(in_struct->pUserData)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDebugReportCallbackCreateInfoEXT::safe_VkDebugReportCallbackCreateInfoEXT() :
    sType(VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT),
    pNext(nullptr),
    pUserData(nullptr)
{}

safe_VkDebugReportCallbackCreateInfoEXT::safe_VkDebugReportCallbackCreateInfoEXT(const safe_VkDebugReportCallbackCreateInfoEXT& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    pfnCallback = copy_src.pfnCallback;
    pUserData = copy_src.pUserData;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDebugReportCallbackCreateInfoEXT& safe_VkDebugReportCallbackCreateInfoEXT::operator=(const safe_VkDebugReportCallbackCreateInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    pfnCallback = copy_src.pfnCallback;
    pUserData = copy_src.pUserData;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDebugReportCallbackCreateInfoEXT::~safe_VkDebugReportCallbackCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugReportCallbackCreateInfoEXT::initialize(const VkDebugReportCallbackCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pfnCallback = in_struct->pfnCallback;
    pUserData = in_struct->pUserData;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDebugReportCallbackCreateInfoEXT::initialize(const safe_VkDebugReportCallbackCreateInfoEXT* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    pfnCallback = copy_src->pfnCallback;
    pUserData = copy_src->pUserData;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineRasterizationStateRasterizationOrderAMD::safe_VkPipelineRasterizationStateRasterizationOrderAMD(const VkPipelineRasterizationStateRasterizationOrderAMD* in_struct) :
    sType(in_struct->sType),
    rasterizationOrder(in_struct->rasterizationOrder)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineRasterizationStateRasterizationOrderAMD::safe_VkPipelineRasterizationStateRasterizationOrderAMD() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD),
    pNext(nullptr)
{}

safe_VkPipelineRasterizationStateRasterizationOrderAMD::safe_VkPipelineRasterizationStateRasterizationOrderAMD(const safe_VkPipelineRasterizationStateRasterizationOrderAMD& copy_src)
{
    sType = copy_src.sType;
    rasterizationOrder = copy_src.rasterizationOrder;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPipelineRasterizationStateRasterizationOrderAMD& safe_VkPipelineRasterizationStateRasterizationOrderAMD::operator=(const safe_VkPipelineRasterizationStateRasterizationOrderAMD& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    rasterizationOrder = copy_src.rasterizationOrder;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPipelineRasterizationStateRasterizationOrderAMD::~safe_VkPipelineRasterizationStateRasterizationOrderAMD()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineRasterizationStateRasterizationOrderAMD::initialize(const VkPipelineRasterizationStateRasterizationOrderAMD* in_struct)
{
    sType = in_struct->sType;
    rasterizationOrder = in_struct->rasterizationOrder;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineRasterizationStateRasterizationOrderAMD::initialize(const safe_VkPipelineRasterizationStateRasterizationOrderAMD* copy_src)
{
    sType = copy_src->sType;
    rasterizationOrder = copy_src->rasterizationOrder;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDebugMarkerObjectNameInfoEXT::safe_VkDebugMarkerObjectNameInfoEXT(const VkDebugMarkerObjectNameInfoEXT* in_struct) :
    sType(in_struct->sType),
    objectType(in_struct->objectType),
    object(in_struct->object)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pObjectName = SafeStringCopy(in_struct->pObjectName);
}

safe_VkDebugMarkerObjectNameInfoEXT::safe_VkDebugMarkerObjectNameInfoEXT() :
    sType(VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT),
    pNext(nullptr),
    pObjectName(nullptr)
{}

safe_VkDebugMarkerObjectNameInfoEXT::safe_VkDebugMarkerObjectNameInfoEXT(const safe_VkDebugMarkerObjectNameInfoEXT& copy_src)
{
    sType = copy_src.sType;
    objectType = copy_src.objectType;
    object = copy_src.object;
    pNext = SafePnextCopy(copy_src.pNext);
    pObjectName = SafeStringCopy(copy_src.pObjectName);
}

safe_VkDebugMarkerObjectNameInfoEXT& safe_VkDebugMarkerObjectNameInfoEXT::operator=(const safe_VkDebugMarkerObjectNameInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pObjectName) delete [] pObjectName;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    objectType = copy_src.objectType;
    object = copy_src.object;
    pNext = SafePnextCopy(copy_src.pNext);
    pObjectName = SafeStringCopy(copy_src.pObjectName);

    return *this;
}

safe_VkDebugMarkerObjectNameInfoEXT::~safe_VkDebugMarkerObjectNameInfoEXT()
{
    if (pObjectName) delete [] pObjectName;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugMarkerObjectNameInfoEXT::initialize(const VkDebugMarkerObjectNameInfoEXT* in_struct)
{
    sType = in_struct->sType;
    objectType = in_struct->objectType;
    object = in_struct->object;
    pNext = SafePnextCopy(in_struct->pNext);
    pObjectName = SafeStringCopy(in_struct->pObjectName);
}

void safe_VkDebugMarkerObjectNameInfoEXT::initialize(const safe_VkDebugMarkerObjectNameInfoEXT* copy_src)
{
    sType = copy_src->sType;
    objectType = copy_src->objectType;
    object = copy_src->object;
    pNext = SafePnextCopy(copy_src->pNext);
    pObjectName = SafeStringCopy(copy_src->pObjectName);
}

safe_VkDebugMarkerObjectTagInfoEXT::safe_VkDebugMarkerObjectTagInfoEXT(const VkDebugMarkerObjectTagInfoEXT* in_struct) :
    sType(in_struct->sType),
    objectType(in_struct->objectType),
    object(in_struct->object),
    tagName(in_struct->tagName),
    tagSize(in_struct->tagSize),
    pTag(in_struct->pTag)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDebugMarkerObjectTagInfoEXT::safe_VkDebugMarkerObjectTagInfoEXT() :
    sType(VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT),
    pNext(nullptr),
    pTag(nullptr)
{}

safe_VkDebugMarkerObjectTagInfoEXT::safe_VkDebugMarkerObjectTagInfoEXT(const safe_VkDebugMarkerObjectTagInfoEXT& copy_src)
{
    sType = copy_src.sType;
    objectType = copy_src.objectType;
    object = copy_src.object;
    tagName = copy_src.tagName;
    tagSize = copy_src.tagSize;
    pTag = copy_src.pTag;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDebugMarkerObjectTagInfoEXT& safe_VkDebugMarkerObjectTagInfoEXT::operator=(const safe_VkDebugMarkerObjectTagInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    objectType = copy_src.objectType;
    object = copy_src.object;
    tagName = copy_src.tagName;
    tagSize = copy_src.tagSize;
    pTag = copy_src.pTag;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDebugMarkerObjectTagInfoEXT::~safe_VkDebugMarkerObjectTagInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugMarkerObjectTagInfoEXT::initialize(const VkDebugMarkerObjectTagInfoEXT* in_struct)
{
    sType = in_struct->sType;
    objectType = in_struct->objectType;
    object = in_struct->object;
    tagName = in_struct->tagName;
    tagSize = in_struct->tagSize;
    pTag = in_struct->pTag;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDebugMarkerObjectTagInfoEXT::initialize(const safe_VkDebugMarkerObjectTagInfoEXT* copy_src)
{
    sType = copy_src->sType;
    objectType = copy_src->objectType;
    object = copy_src->object;
    tagName = copy_src->tagName;
    tagSize = copy_src->tagSize;
    pTag = copy_src->pTag;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDebugMarkerMarkerInfoEXT::safe_VkDebugMarkerMarkerInfoEXT(const VkDebugMarkerMarkerInfoEXT* in_struct) :
    sType(in_struct->sType)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pMarkerName = SafeStringCopy(in_struct->pMarkerName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = in_struct->color[i];
    }
}

safe_VkDebugMarkerMarkerInfoEXT::safe_VkDebugMarkerMarkerInfoEXT() :
    sType(VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT),
    pNext(nullptr),
    pMarkerName(nullptr)
{}

safe_VkDebugMarkerMarkerInfoEXT::safe_VkDebugMarkerMarkerInfoEXT(const safe_VkDebugMarkerMarkerInfoEXT& copy_src)
{
    sType = copy_src.sType;
    pNext = SafePnextCopy(copy_src.pNext);
    pMarkerName = SafeStringCopy(copy_src.pMarkerName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = copy_src.color[i];
    }
}

safe_VkDebugMarkerMarkerInfoEXT& safe_VkDebugMarkerMarkerInfoEXT::operator=(const safe_VkDebugMarkerMarkerInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pMarkerName) delete [] pMarkerName;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pNext = SafePnextCopy(copy_src.pNext);
    pMarkerName = SafeStringCopy(copy_src.pMarkerName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = copy_src.color[i];
    }

    return *this;
}

safe_VkDebugMarkerMarkerInfoEXT::~safe_VkDebugMarkerMarkerInfoEXT()
{
    if (pMarkerName) delete [] pMarkerName;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDebugMarkerMarkerInfoEXT::initialize(const VkDebugMarkerMarkerInfoEXT* in_struct)
{
    sType = in_struct->sType;
    pNext = SafePnextCopy(in_struct->pNext);
    pMarkerName = SafeStringCopy(in_struct->pMarkerName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = in_struct->color[i];
    }
}

void safe_VkDebugMarkerMarkerInfoEXT::initialize(const safe_VkDebugMarkerMarkerInfoEXT* copy_src)
{
    sType = copy_src->sType;
    pNext = SafePnextCopy(copy_src->pNext);
    pMarkerName = SafeStringCopy(copy_src->pMarkerName);
    for (uint32_t i = 0; i < 4; ++i) {
        color[i] = copy_src->color[i];
    }
}

safe_VkDedicatedAllocationImageCreateInfoNV::safe_VkDedicatedAllocationImageCreateInfoNV(const VkDedicatedAllocationImageCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    dedicatedAllocation(in_struct->dedicatedAllocation)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDedicatedAllocationImageCreateInfoNV::safe_VkDedicatedAllocationImageCreateInfoNV() :
    sType(VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV),
    pNext(nullptr)
{}

safe_VkDedicatedAllocationImageCreateInfoNV::safe_VkDedicatedAllocationImageCreateInfoNV(const safe_VkDedicatedAllocationImageCreateInfoNV& copy_src)
{
    sType = copy_src.sType;
    dedicatedAllocation = copy_src.dedicatedAllocation;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDedicatedAllocationImageCreateInfoNV& safe_VkDedicatedAllocationImageCreateInfoNV::operator=(const safe_VkDedicatedAllocationImageCreateInfoNV& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    dedicatedAllocation = copy_src.dedicatedAllocation;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDedicatedAllocationImageCreateInfoNV::~safe_VkDedicatedAllocationImageCreateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDedicatedAllocationImageCreateInfoNV::initialize(const VkDedicatedAllocationImageCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    dedicatedAllocation = in_struct->dedicatedAllocation;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDedicatedAllocationImageCreateInfoNV::initialize(const safe_VkDedicatedAllocationImageCreateInfoNV* copy_src)
{
    sType = copy_src->sType;
    dedicatedAllocation = copy_src->dedicatedAllocation;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDedicatedAllocationBufferCreateInfoNV::safe_VkDedicatedAllocationBufferCreateInfoNV(const VkDedicatedAllocationBufferCreateInfoNV* in_struct) :
    sType(in_struct->sType),
    dedicatedAllocation(in_struct->dedicatedAllocation)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDedicatedAllocationBufferCreateInfoNV::safe_VkDedicatedAllocationBufferCreateInfoNV() :
    sType(VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV),
    pNext(nullptr)
{}

safe_VkDedicatedAllocationBufferCreateInfoNV::safe_VkDedicatedAllocationBufferCreateInfoNV(const safe_VkDedicatedAllocationBufferCreateInfoNV& copy_src)
{
    sType = copy_src.sType;
    dedicatedAllocation = copy_src.dedicatedAllocation;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDedicatedAllocationBufferCreateInfoNV& safe_VkDedicatedAllocationBufferCreateInfoNV::operator=(const safe_VkDedicatedAllocationBufferCreateInfoNV& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    dedicatedAllocation = copy_src.dedicatedAllocation;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDedicatedAllocationBufferCreateInfoNV::~safe_VkDedicatedAllocationBufferCreateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDedicatedAllocationBufferCreateInfoNV::initialize(const VkDedicatedAllocationBufferCreateInfoNV* in_struct)
{
    sType = in_struct->sType;
    dedicatedAllocation = in_struct->dedicatedAllocation;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDedicatedAllocationBufferCreateInfoNV::initialize(const safe_VkDedicatedAllocationBufferCreateInfoNV* copy_src)
{
    sType = copy_src->sType;
    dedicatedAllocation = copy_src->dedicatedAllocation;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkDedicatedAllocationMemoryAllocateInfoNV::safe_VkDedicatedAllocationMemoryAllocateInfoNV(const VkDedicatedAllocationMemoryAllocateInfoNV* in_struct) :
    sType(in_struct->sType),
    image(in_struct->image),
    buffer(in_struct->buffer)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkDedicatedAllocationMemoryAllocateInfoNV::safe_VkDedicatedAllocationMemoryAllocateInfoNV() :
    sType(VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV),
    pNext(nullptr)
{}

safe_VkDedicatedAllocationMemoryAllocateInfoNV::safe_VkDedicatedAllocationMemoryAllocateInfoNV(const safe_VkDedicatedAllocationMemoryAllocateInfoNV& copy_src)
{
    sType = copy_src.sType;
    image = copy_src.image;
    buffer = copy_src.buffer;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkDedicatedAllocationMemoryAllocateInfoNV& safe_VkDedicatedAllocationMemoryAllocateInfoNV::operator=(const safe_VkDedicatedAllocationMemoryAllocateInfoNV& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    image = copy_src.image;
    buffer = copy_src.buffer;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkDedicatedAllocationMemoryAllocateInfoNV::~safe_VkDedicatedAllocationMemoryAllocateInfoNV()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkDedicatedAllocationMemoryAllocateInfoNV::initialize(const VkDedicatedAllocationMemoryAllocateInfoNV* in_struct)
{
    sType = in_struct->sType;
    image = in_struct->image;
    buffer = in_struct->buffer;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkDedicatedAllocationMemoryAllocateInfoNV::initialize(const safe_VkDedicatedAllocationMemoryAllocateInfoNV* copy_src)
{
    sType = copy_src->sType;
    image = copy_src->image;
    buffer = copy_src->buffer;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT(const VkPhysicalDeviceTransformFeedbackFeaturesEXT* in_struct) :
    sType(in_struct->sType),
    transformFeedback(in_struct->transformFeedback),
    geometryStreams(in_struct->geometryStreams)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT(const safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT& copy_src)
{
    sType = copy_src.sType;
    transformFeedback = copy_src.transformFeedback;
    geometryStreams = copy_src.geometryStreams;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT& safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::operator=(const safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    transformFeedback = copy_src.transformFeedback;
    geometryStreams = copy_src.geometryStreams;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::~safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::initialize(const VkPhysicalDeviceTransformFeedbackFeaturesEXT* in_struct)
{
    sType = in_struct->sType;
    transformFeedback = in_struct->transformFeedback;
    geometryStreams = in_struct->geometryStreams;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT::initialize(const safe_VkPhysicalDeviceTransformFeedbackFeaturesEXT* copy_src)
{
    sType = copy_src->sType;
    transformFeedback = copy_src->transformFeedback;
    geometryStreams = copy_src->geometryStreams;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT(const VkPhysicalDeviceTransformFeedbackPropertiesEXT* in_struct) :
    sType(in_struct->sType),
    maxTransformFeedbackStreams(in_struct->maxTransformFeedbackStreams),
    maxTransformFeedbackBuffers(in_struct->maxTransformFeedbackBuffers),
    maxTransformFeedbackBufferSize(in_struct->maxTransformFeedbackBufferSize),
    maxTransformFeedbackStreamDataSize(in_struct->maxTransformFeedbackStreamDataSize),
    maxTransformFeedbackBufferDataSize(in_struct->maxTransformFeedbackBufferDataSize),
    maxTransformFeedbackBufferDataStride(in_struct->maxTransformFeedbackBufferDataStride),
    transformFeedbackQueries(in_struct->transformFeedbackQueries),
    transformFeedbackStreamsLinesTriangles(in_struct->transformFeedbackStreamsLinesTriangles),
    transformFeedbackRasterizationStreamSelect(in_struct->transformFeedbackRasterizationStreamSelect),
    transformFeedbackDraw(in_struct->transformFeedbackDraw)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT() :
    sType(VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT),
    pNext(nullptr)
{}

safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT(const safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT& copy_src)
{
    sType = copy_src.sType;
    maxTransformFeedbackStreams = copy_src.maxTransformFeedbackStreams;
    maxTransformFeedbackBuffers = copy_src.maxTransformFeedbackBuffers;
    maxTransformFeedbackBufferSize = copy_src.maxTransformFeedbackBufferSize;
    maxTransformFeedbackStreamDataSize = copy_src.maxTransformFeedbackStreamDataSize;
    maxTransformFeedbackBufferDataSize = copy_src.maxTransformFeedbackBufferDataSize;
    maxTransformFeedbackBufferDataStride = copy_src.maxTransformFeedbackBufferDataStride;
    transformFeedbackQueries = copy_src.transformFeedbackQueries;
    transformFeedbackStreamsLinesTriangles = copy_src.transformFeedbackStreamsLinesTriangles;
    transformFeedbackRasterizationStreamSelect = copy_src.transformFeedbackRasterizationStreamSelect;
    transformFeedbackDraw = copy_src.transformFeedbackDraw;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT& safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::operator=(const safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    maxTransformFeedbackStreams = copy_src.maxTransformFeedbackStreams;
    maxTransformFeedbackBuffers = copy_src.maxTransformFeedbackBuffers;
    maxTransformFeedbackBufferSize = copy_src.maxTransformFeedbackBufferSize;
    maxTransformFeedbackStreamDataSize = copy_src.maxTransformFeedbackStreamDataSize;
    maxTransformFeedbackBufferDataSize = copy_src.maxTransformFeedbackBufferDataSize;
    maxTransformFeedbackBufferDataStride = copy_src.maxTransformFeedbackBufferDataStride;
    transformFeedbackQueries = copy_src.transformFeedbackQueries;
    transformFeedbackStreamsLinesTriangles = copy_src.transformFeedbackStreamsLinesTriangles;
    transformFeedbackRasterizationStreamSelect = copy_src.transformFeedbackRasterizationStreamSelect;
    transformFeedbackDraw = copy_src.transformFeedbackDraw;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::~safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::initialize(const VkPhysicalDeviceTransformFeedbackPropertiesEXT* in_struct)
{
    sType = in_struct->sType;
    maxTransformFeedbackStreams = in_struct->maxTransformFeedbackStreams;
    maxTransformFeedbackBuffers = in_struct->maxTransformFeedbackBuffers;
    maxTransformFeedbackBufferSize = in_struct->maxTransformFeedbackBufferSize;
    maxTransformFeedbackStreamDataSize = in_struct->maxTransformFeedbackStreamDataSize;
    maxTransformFeedbackBufferDataSize = in_struct->maxTransformFeedbackBufferDataSize;
    maxTransformFeedbackBufferDataStride = in_struct->maxTransformFeedbackBufferDataStride;
    transformFeedbackQueries = in_struct->transformFeedbackQueries;
    transformFeedbackStreamsLinesTriangles = in_struct->transformFeedbackStreamsLinesTriangles;
    transformFeedbackRasterizationStreamSelect = in_struct->transformFeedbackRasterizationStreamSelect;
    transformFeedbackDraw = in_struct->transformFeedbackDraw;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT::initialize(const safe_VkPhysicalDeviceTransformFeedbackPropertiesEXT* copy_src)
{
    sType = copy_src->sType;
    maxTransformFeedbackStreams = copy_src->maxTransformFeedbackStreams;
    maxTransformFeedbackBuffers = copy_src->maxTransformFeedbackBuffers;
    maxTransformFeedbackBufferSize = copy_src->maxTransformFeedbackBufferSize;
    maxTransformFeedbackStreamDataSize = copy_src->maxTransformFeedbackStreamDataSize;
    maxTransformFeedbackBufferDataSize = copy_src->maxTransformFeedbackBufferDataSize;
    maxTransformFeedbackBufferDataStride = copy_src->maxTransformFeedbackBufferDataStride;
    transformFeedbackQueries = copy_src->transformFeedbackQueries;
    transformFeedbackStreamsLinesTriangles = copy_src->transformFeedbackStreamsLinesTriangles;
    transformFeedbackRasterizationStreamSelect = copy_src->transformFeedbackRasterizationStreamSelect;
    transformFeedbackDraw = copy_src->transformFeedbackDraw;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkPipelineRasterizationStateStreamCreateInfoEXT::safe_VkPipelineRasterizationStateStreamCreateInfoEXT(const VkPipelineRasterizationStateStreamCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    rasterizationStream(in_struct->rasterizationStream)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkPipelineRasterizationStateStreamCreateInfoEXT::safe_VkPipelineRasterizationStateStreamCreateInfoEXT() :
    sType(VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT),
    pNext(nullptr)
{}

safe_VkPipelineRasterizationStateStreamCreateInfoEXT::safe_VkPipelineRasterizationStateStreamCreateInfoEXT(const safe_VkPipelineRasterizationStateStreamCreateInfoEXT& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    rasterizationStream = copy_src.rasterizationStream;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkPipelineRasterizationStateStreamCreateInfoEXT& safe_VkPipelineRasterizationStateStreamCreateInfoEXT::operator=(const safe_VkPipelineRasterizationStateStreamCreateInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    rasterizationStream = copy_src.rasterizationStream;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkPipelineRasterizationStateStreamCreateInfoEXT::~safe_VkPipelineRasterizationStateStreamCreateInfoEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkPipelineRasterizationStateStreamCreateInfoEXT::initialize(const VkPipelineRasterizationStateStreamCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    rasterizationStream = in_struct->rasterizationStream;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkPipelineRasterizationStateStreamCreateInfoEXT::initialize(const safe_VkPipelineRasterizationStateStreamCreateInfoEXT* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    rasterizationStream = copy_src->rasterizationStream;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkCuModuleCreateInfoNVX::safe_VkCuModuleCreateInfoNVX(const VkCuModuleCreateInfoNVX* in_struct) :
    sType(in_struct->sType),
    dataSize(in_struct->dataSize),
    pData(in_struct->pData)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCuModuleCreateInfoNVX::safe_VkCuModuleCreateInfoNVX() :
    sType(VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX),
    pNext(nullptr),
    pData(nullptr)
{}

safe_VkCuModuleCreateInfoNVX::safe_VkCuModuleCreateInfoNVX(const safe_VkCuModuleCreateInfoNVX& copy_src)
{
    sType = copy_src.sType;
    dataSize = copy_src.dataSize;
    pData = copy_src.pData;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkCuModuleCreateInfoNVX& safe_VkCuModuleCreateInfoNVX::operator=(const safe_VkCuModuleCreateInfoNVX& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    dataSize = copy_src.dataSize;
    pData = copy_src.pData;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkCuModuleCreateInfoNVX::~safe_VkCuModuleCreateInfoNVX()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCuModuleCreateInfoNVX::initialize(const VkCuModuleCreateInfoNVX* in_struct)
{
    sType = in_struct->sType;
    dataSize = in_struct->dataSize;
    pData = in_struct->pData;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCuModuleCreateInfoNVX::initialize(const safe_VkCuModuleCreateInfoNVX* copy_src)
{
    sType = copy_src->sType;
    dataSize = copy_src->dataSize;
    pData = copy_src->pData;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkCuFunctionCreateInfoNVX::safe_VkCuFunctionCreateInfoNVX(const VkCuFunctionCreateInfoNVX* in_struct) :
    sType(in_struct->sType),
    module(in_struct->module)
{
    pNext = SafePnextCopy(in_struct->pNext);
    pName = SafeStringCopy(in_struct->pName);
}

safe_VkCuFunctionCreateInfoNVX::safe_VkCuFunctionCreateInfoNVX() :
    sType(VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX),
    pNext(nullptr),
    pName(nullptr)
{}

safe_VkCuFunctionCreateInfoNVX::safe_VkCuFunctionCreateInfoNVX(const safe_VkCuFunctionCreateInfoNVX& copy_src)
{
    sType = copy_src.sType;
    module = copy_src.module;
    pNext = SafePnextCopy(copy_src.pNext);
    pName = SafeStringCopy(copy_src.pName);
}

safe_VkCuFunctionCreateInfoNVX& safe_VkCuFunctionCreateInfoNVX::operator=(const safe_VkCuFunctionCreateInfoNVX& copy_src)
{
    if (&copy_src == this) return *this;

    if (pName) delete [] pName;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    module = copy_src.module;
    pNext = SafePnextCopy(copy_src.pNext);
    pName = SafeStringCopy(copy_src.pName);

    return *this;
}

safe_VkCuFunctionCreateInfoNVX::~safe_VkCuFunctionCreateInfoNVX()
{
    if (pName) delete [] pName;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCuFunctionCreateInfoNVX::initialize(const VkCuFunctionCreateInfoNVX* in_struct)
{
    sType = in_struct->sType;
    module = in_struct->module;
    pNext = SafePnextCopy(in_struct->pNext);
    pName = SafeStringCopy(in_struct->pName);
}

void safe_VkCuFunctionCreateInfoNVX::initialize(const safe_VkCuFunctionCreateInfoNVX* copy_src)
{
    sType = copy_src->sType;
    module = copy_src->module;
    pNext = SafePnextCopy(copy_src->pNext);
    pName = SafeStringCopy(copy_src->pName);
}

safe_VkCuLaunchInfoNVX::safe_VkCuLaunchInfoNVX(const VkCuLaunchInfoNVX* in_struct) :
    sType(in_struct->sType),
    function(in_struct->function),
    gridDimX(in_struct->gridDimX),
    gridDimY(in_struct->gridDimY),
    gridDimZ(in_struct->gridDimZ),
    blockDimX(in_struct->blockDimX),
    blockDimY(in_struct->blockDimY),
    blockDimZ(in_struct->blockDimZ),
    sharedMemBytes(in_struct->sharedMemBytes),
    paramCount(in_struct->paramCount),
    pParams(in_struct->pParams),
    extraCount(in_struct->extraCount),
    pExtras(in_struct->pExtras)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkCuLaunchInfoNVX::safe_VkCuLaunchInfoNVX() :
    sType(VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX),
    pNext(nullptr),
    pParams(nullptr),
    pExtras(nullptr)
{}

safe_VkCuLaunchInfoNVX::safe_VkCuLaunchInfoNVX(const safe_VkCuLaunchInfoNVX& copy_src)
{
    sType = copy_src.sType;
    function = copy_src.function;
    gridDimX = copy_src.gridDimX;
    gridDimY = copy_src.gridDimY;
    gridDimZ = copy_src.gridDimZ;
    blockDimX = copy_src.blockDimX;
    blockDimY = copy_src.blockDimY;
    blockDimZ = copy_src.blockDimZ;
    sharedMemBytes = copy_src.sharedMemBytes;
    paramCount = copy_src.paramCount;
    pParams = copy_src.pParams;
    extraCount = copy_src.extraCount;
    pExtras = copy_src.pExtras;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkCuLaunchInfoNVX& safe_VkCuLaunchInfoNVX::operator=(const safe_VkCuLaunchInfoNVX& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    function = copy_src.function;
    gridDimX = copy_src.gridDimX;
    gridDimY = copy_src.gridDimY;
    gridDimZ = copy_src.gridDimZ;
    blockDimX = copy_src.blockDimX;
    blockDimY = copy_src.blockDimY;
    blockDimZ = copy_src.blockDimZ;
    sharedMemBytes = copy_src.sharedMemBytes;
    paramCount = copy_src.paramCount;
    pParams = copy_src.pParams;
    extraCount = copy_src.extraCount;
    pExtras = copy_src.pExtras;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkCuLaunchInfoNVX::~safe_VkCuLaunchInfoNVX()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkCuLaunchInfoNVX::initialize(const VkCuLaunchInfoNVX* in_struct)
{
    sType = in_struct->sType;
    function = in_struct->function;
    gridDimX = in_struct->gridDimX;
    gridDimY = in_struct->gridDimY;
    gridDimZ = in_struct->gridDimZ;
    blockDimX = in_struct->blockDimX;
    blockDimY = in_struct->blockDimY;
    blockDimZ = in_struct->blockDimZ;
    sharedMemBytes = in_struct->sharedMemBytes;
    paramCount = in_struct->paramCount;
    pParams = in_struct->pParams;
    extraCount = in_struct->extraCount;
    pExtras = in_struct->pExtras;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkCuLaunchInfoNVX::initialize(const safe_VkCuLaunchInfoNVX* copy_src)
{
    sType = copy_src->sType;
    function = copy_src->function;
    gridDimX = copy_src->gridDimX;
    gridDimY = copy_src->gridDimY;
    gridDimZ = copy_src->gridDimZ;
    blockDimX = copy_src->blockDimX;
    blockDimY = copy_src->blockDimY;
    blockDimZ = copy_src->blockDimZ;
    sharedMemBytes = copy_src->sharedMemBytes;
    paramCount = copy_src->paramCount;
    pParams = copy_src->pParams;
    extraCount = copy_src->extraCount;
    pExtras = copy_src->pExtras;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkImageViewHandleInfoNVX::safe_VkImageViewHandleInfoNVX(const VkImageViewHandleInfoNVX* in_struct) :
    sType(in_struct->sType),
    imageView(in_struct->imageView),
    descriptorType(in_struct->descriptorType),
    sampler(in_struct->sampler)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageViewHandleInfoNVX::safe_VkImageViewHandleInfoNVX() :
    sType(VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX),
    pNext(nullptr)
{}

safe_VkImageViewHandleInfoNVX::safe_VkImageViewHandleInfoNVX(const safe_VkImageViewHandleInfoNVX& copy_src)
{
    sType = copy_src.sType;
    imageView = copy_src.imageView;
    descriptorType = copy_src.descriptorType;
    sampler = copy_src.sampler;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageViewHandleInfoNVX& safe_VkImageViewHandleInfoNVX::operator=(const safe_VkImageViewHandleInfoNVX& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    imageView = copy_src.imageView;
    descriptorType = copy_src.descriptorType;
    sampler = copy_src.sampler;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageViewHandleInfoNVX::~safe_VkImageViewHandleInfoNVX()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageViewHandleInfoNVX::initialize(const VkImageViewHandleInfoNVX* in_struct)
{
    sType = in_struct->sType;
    imageView = in_struct->imageView;
    descriptorType = in_struct->descriptorType;
    sampler = in_struct->sampler;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageViewHandleInfoNVX::initialize(const safe_VkImageViewHandleInfoNVX* copy_src)
{
    sType = copy_src->sType;
    imageView = copy_src->imageView;
    descriptorType = copy_src->descriptorType;
    sampler = copy_src->sampler;
    pNext = SafePnextCopy(copy_src->pNext);
}

safe_VkImageViewAddressPropertiesNVX::safe_VkImageViewAddressPropertiesNVX(const VkImageViewAddressPropertiesNVX* in_struct) :
    sType(in_struct->sType),
    deviceAddress(in_struct->deviceAddress),
    size(in_struct->size)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkImageViewAddressPropertiesNVX::safe_VkImageViewAddressPropertiesNVX() :
    sType(VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX),
    pNext(nullptr)
{}

safe_VkImageViewAddressPropertiesNVX::safe_VkImageViewAddressPropertiesNVX(const safe_VkImageViewAddressPropertiesNVX& copy_src)
{
    sType = copy_src.sType;
    deviceAddress = copy_src.deviceAddress;
    size = copy_src.size;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkImageViewAddressPropertiesNVX& safe_VkImageViewAddressPropertiesNVX::operator=(const safe_VkImageViewAddressPropertiesNVX& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    deviceAddress = copy_src.deviceAddress;
    size = copy_src.size;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkImageViewAddressPropertiesNVX::~safe_VkImageViewAddressPropertiesNVX()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkImageViewAddressPropertiesNVX::initialize(const VkImageViewAddressPropertiesNVX* in_struct)
{
    sType = in_struct->sType;
    deviceAddress = in_struct->deviceAddress;
    size = in_struct->size;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkImageViewAddressPropertiesNVX::initialize(const safe_VkImageViewAddressPropertiesNVX* copy_src)
{
    sType = copy_src->sType;
    deviceAddress = copy_src->deviceAddress;
    size = copy_src->size;
    pNext = SafePnextCopy(copy_src->pNext);
}
#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEncodeH264CapabilitiesEXT::safe_VkVideoEncodeH264CapabilitiesEXT(const VkVideoEncodeH264CapabilitiesEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    inputModeFlags(in_struct->inputModeFlags),
    outputModeFlags(in_struct->outputModeFlags),
    minPictureSizeInMbs(in_struct->minPictureSizeInMbs),
    maxPictureSizeInMbs(in_struct->maxPictureSizeInMbs),
    inputImageDataAlignment(in_struct->inputImageDataAlignment),
    maxNumL0ReferenceForP(in_struct->maxNumL0ReferenceForP),
    maxNumL0ReferenceForB(in_struct->maxNumL0ReferenceForB),
    maxNumL1Reference(in_struct->maxNumL1Reference),
    qualityLevelCount(in_struct->qualityLevelCount),
    stdExtensionVersion(in_struct->stdExtensionVersion)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoEncodeH264CapabilitiesEXT::safe_VkVideoEncodeH264CapabilitiesEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_EXT),
    pNext(nullptr)
{}

safe_VkVideoEncodeH264CapabilitiesEXT::safe_VkVideoEncodeH264CapabilitiesEXT(const safe_VkVideoEncodeH264CapabilitiesEXT& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    inputModeFlags = copy_src.inputModeFlags;
    outputModeFlags = copy_src.outputModeFlags;
    minPictureSizeInMbs = copy_src.minPictureSizeInMbs;
    maxPictureSizeInMbs = copy_src.maxPictureSizeInMbs;
    inputImageDataAlignment = copy_src.inputImageDataAlignment;
    maxNumL0ReferenceForP = copy_src.maxNumL0ReferenceForP;
    maxNumL0ReferenceForB = copy_src.maxNumL0ReferenceForB;
    maxNumL1Reference = copy_src.maxNumL1Reference;
    qualityLevelCount = copy_src.qualityLevelCount;
    stdExtensionVersion = copy_src.stdExtensionVersion;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoEncodeH264CapabilitiesEXT& safe_VkVideoEncodeH264CapabilitiesEXT::operator=(const safe_VkVideoEncodeH264CapabilitiesEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    inputModeFlags = copy_src.inputModeFlags;
    outputModeFlags = copy_src.outputModeFlags;
    minPictureSizeInMbs = copy_src.minPictureSizeInMbs;
    maxPictureSizeInMbs = copy_src.maxPictureSizeInMbs;
    inputImageDataAlignment = copy_src.inputImageDataAlignment;
    maxNumL0ReferenceForP = copy_src.maxNumL0ReferenceForP;
    maxNumL0ReferenceForB = copy_src.maxNumL0ReferenceForB;
    maxNumL1Reference = copy_src.maxNumL1Reference;
    qualityLevelCount = copy_src.qualityLevelCount;
    stdExtensionVersion = copy_src.stdExtensionVersion;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoEncodeH264CapabilitiesEXT::~safe_VkVideoEncodeH264CapabilitiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEncodeH264CapabilitiesEXT::initialize(const VkVideoEncodeH264CapabilitiesEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    inputModeFlags = in_struct->inputModeFlags;
    outputModeFlags = in_struct->outputModeFlags;
    minPictureSizeInMbs = in_struct->minPictureSizeInMbs;
    maxPictureSizeInMbs = in_struct->maxPictureSizeInMbs;
    inputImageDataAlignment = in_struct->inputImageDataAlignment;
    maxNumL0ReferenceForP = in_struct->maxNumL0ReferenceForP;
    maxNumL0ReferenceForB = in_struct->maxNumL0ReferenceForB;
    maxNumL1Reference = in_struct->maxNumL1Reference;
    qualityLevelCount = in_struct->qualityLevelCount;
    stdExtensionVersion = in_struct->stdExtensionVersion;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoEncodeH264CapabilitiesEXT::initialize(const safe_VkVideoEncodeH264CapabilitiesEXT* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    inputModeFlags = copy_src->inputModeFlags;
    outputModeFlags = copy_src->outputModeFlags;
    minPictureSizeInMbs = copy_src->minPictureSizeInMbs;
    maxPictureSizeInMbs = copy_src->maxPictureSizeInMbs;
    inputImageDataAlignment = copy_src->inputImageDataAlignment;
    maxNumL0ReferenceForP = copy_src->maxNumL0ReferenceForP;
    maxNumL0ReferenceForB = copy_src->maxNumL0ReferenceForB;
    maxNumL1Reference = copy_src->maxNumL1Reference;
    qualityLevelCount = copy_src->qualityLevelCount;
    stdExtensionVersion = copy_src->stdExtensionVersion;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEncodeH264SessionCreateInfoEXT::safe_VkVideoEncodeH264SessionCreateInfoEXT(const VkVideoEncodeH264SessionCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    maxPictureSizeInMbs(in_struct->maxPictureSizeInMbs),
    pStdExtensionVersion(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pStdExtensionVersion) {
        pStdExtensionVersion = new VkExtensionProperties(*in_struct->pStdExtensionVersion);
    }
}

safe_VkVideoEncodeH264SessionCreateInfoEXT::safe_VkVideoEncodeH264SessionCreateInfoEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_EXT),
    pNext(nullptr),
    pStdExtensionVersion(nullptr)
{}

safe_VkVideoEncodeH264SessionCreateInfoEXT::safe_VkVideoEncodeH264SessionCreateInfoEXT(const safe_VkVideoEncodeH264SessionCreateInfoEXT& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    maxPictureSizeInMbs = copy_src.maxPictureSizeInMbs;
    pStdExtensionVersion = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pStdExtensionVersion) {
        pStdExtensionVersion = new VkExtensionProperties(*copy_src.pStdExtensionVersion);
    }
}

safe_VkVideoEncodeH264SessionCreateInfoEXT& safe_VkVideoEncodeH264SessionCreateInfoEXT::operator=(const safe_VkVideoEncodeH264SessionCreateInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pStdExtensionVersion)
        delete pStdExtensionVersion;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    maxPictureSizeInMbs = copy_src.maxPictureSizeInMbs;
    pStdExtensionVersion = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pStdExtensionVersion) {
        pStdExtensionVersion = new VkExtensionProperties(*copy_src.pStdExtensionVersion);
    }

    return *this;
}

safe_VkVideoEncodeH264SessionCreateInfoEXT::~safe_VkVideoEncodeH264SessionCreateInfoEXT()
{
    if (pStdExtensionVersion)
        delete pStdExtensionVersion;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEncodeH264SessionCreateInfoEXT::initialize(const VkVideoEncodeH264SessionCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    maxPictureSizeInMbs = in_struct->maxPictureSizeInMbs;
    pStdExtensionVersion = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pStdExtensionVersion) {
        pStdExtensionVersion = new VkExtensionProperties(*in_struct->pStdExtensionVersion);
    }
}

void safe_VkVideoEncodeH264SessionCreateInfoEXT::initialize(const safe_VkVideoEncodeH264SessionCreateInfoEXT* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    maxPictureSizeInMbs = copy_src->maxPictureSizeInMbs;
    pStdExtensionVersion = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pStdExtensionVersion) {
        pStdExtensionVersion = new VkExtensionProperties(*copy_src->pStdExtensionVersion);
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEncodeH264SessionParametersAddInfoEXT::safe_VkVideoEncodeH264SessionParametersAddInfoEXT(const VkVideoEncodeH264SessionParametersAddInfoEXT* in_struct) :
    sType(in_struct->sType),
    spsStdCount(in_struct->spsStdCount),
    pSpsStd(nullptr),
    ppsStdCount(in_struct->ppsStdCount),
    pPpsStd(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSpsStd) {
        pSpsStd = new StdVideoH264SequenceParameterSet[in_struct->spsStdCount];
        memcpy ((void *)pSpsStd, (void *)in_struct->pSpsStd, sizeof(StdVideoH264SequenceParameterSet)*in_struct->spsStdCount);
    }
    if (in_struct->pPpsStd) {
        pPpsStd = new StdVideoH264PictureParameterSet[in_struct->ppsStdCount];
        memcpy ((void *)pPpsStd, (void *)in_struct->pPpsStd, sizeof(StdVideoH264PictureParameterSet)*in_struct->ppsStdCount);
    }
}

safe_VkVideoEncodeH264SessionParametersAddInfoEXT::safe_VkVideoEncodeH264SessionParametersAddInfoEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_EXT),
    pNext(nullptr),
    pSpsStd(nullptr),
    pPpsStd(nullptr)
{}

safe_VkVideoEncodeH264SessionParametersAddInfoEXT::safe_VkVideoEncodeH264SessionParametersAddInfoEXT(const safe_VkVideoEncodeH264SessionParametersAddInfoEXT& copy_src)
{
    sType = copy_src.sType;
    spsStdCount = copy_src.spsStdCount;
    pSpsStd = nullptr;
    ppsStdCount = copy_src.ppsStdCount;
    pPpsStd = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSpsStd) {
        pSpsStd = new StdVideoH264SequenceParameterSet[copy_src.spsStdCount];
        memcpy ((void *)pSpsStd, (void *)copy_src.pSpsStd, sizeof(StdVideoH264SequenceParameterSet)*copy_src.spsStdCount);
    }
    if (copy_src.pPpsStd) {
        pPpsStd = new StdVideoH264PictureParameterSet[copy_src.ppsStdCount];
        memcpy ((void *)pPpsStd, (void *)copy_src.pPpsStd, sizeof(StdVideoH264PictureParameterSet)*copy_src.ppsStdCount);
    }
}

safe_VkVideoEncodeH264SessionParametersAddInfoEXT& safe_VkVideoEncodeH264SessionParametersAddInfoEXT::operator=(const safe_VkVideoEncodeH264SessionParametersAddInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pSpsStd)
        delete[] pSpsStd;
    if (pPpsStd)
        delete[] pPpsStd;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    spsStdCount = copy_src.spsStdCount;
    pSpsStd = nullptr;
    ppsStdCount = copy_src.ppsStdCount;
    pPpsStd = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSpsStd) {
        pSpsStd = new StdVideoH264SequenceParameterSet[copy_src.spsStdCount];
        memcpy ((void *)pSpsStd, (void *)copy_src.pSpsStd, sizeof(StdVideoH264SequenceParameterSet)*copy_src.spsStdCount);
    }
    if (copy_src.pPpsStd) {
        pPpsStd = new StdVideoH264PictureParameterSet[copy_src.ppsStdCount];
        memcpy ((void *)pPpsStd, (void *)copy_src.pPpsStd, sizeof(StdVideoH264PictureParameterSet)*copy_src.ppsStdCount);
    }

    return *this;
}

safe_VkVideoEncodeH264SessionParametersAddInfoEXT::~safe_VkVideoEncodeH264SessionParametersAddInfoEXT()
{
    if (pSpsStd)
        delete[] pSpsStd;
    if (pPpsStd)
        delete[] pPpsStd;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEncodeH264SessionParametersAddInfoEXT::initialize(const VkVideoEncodeH264SessionParametersAddInfoEXT* in_struct)
{
    sType = in_struct->sType;
    spsStdCount = in_struct->spsStdCount;
    pSpsStd = nullptr;
    ppsStdCount = in_struct->ppsStdCount;
    pPpsStd = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSpsStd) {
        pSpsStd = new StdVideoH264SequenceParameterSet[in_struct->spsStdCount];
        memcpy ((void *)pSpsStd, (void *)in_struct->pSpsStd, sizeof(StdVideoH264SequenceParameterSet)*in_struct->spsStdCount);
    }
    if (in_struct->pPpsStd) {
        pPpsStd = new StdVideoH264PictureParameterSet[in_struct->ppsStdCount];
        memcpy ((void *)pPpsStd, (void *)in_struct->pPpsStd, sizeof(StdVideoH264PictureParameterSet)*in_struct->ppsStdCount);
    }
}

void safe_VkVideoEncodeH264SessionParametersAddInfoEXT::initialize(const safe_VkVideoEncodeH264SessionParametersAddInfoEXT* copy_src)
{
    sType = copy_src->sType;
    spsStdCount = copy_src->spsStdCount;
    pSpsStd = nullptr;
    ppsStdCount = copy_src->ppsStdCount;
    pPpsStd = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pSpsStd) {
        pSpsStd = new StdVideoH264SequenceParameterSet[copy_src->spsStdCount];
        memcpy ((void *)pSpsStd, (void *)copy_src->pSpsStd, sizeof(StdVideoH264SequenceParameterSet)*copy_src->spsStdCount);
    }
    if (copy_src->pPpsStd) {
        pPpsStd = new StdVideoH264PictureParameterSet[copy_src->ppsStdCount];
        memcpy ((void *)pPpsStd, (void *)copy_src->pPpsStd, sizeof(StdVideoH264PictureParameterSet)*copy_src->ppsStdCount);
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEncodeH264SessionParametersCreateInfoEXT::safe_VkVideoEncodeH264SessionParametersCreateInfoEXT(const VkVideoEncodeH264SessionParametersCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    maxSpsStdCount(in_struct->maxSpsStdCount),
    maxPpsStdCount(in_struct->maxPpsStdCount),
    pParametersAddInfo(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pParametersAddInfo)
        pParametersAddInfo = new safe_VkVideoEncodeH264SessionParametersAddInfoEXT(in_struct->pParametersAddInfo);
}

safe_VkVideoEncodeH264SessionParametersCreateInfoEXT::safe_VkVideoEncodeH264SessionParametersCreateInfoEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_EXT),
    pNext(nullptr),
    pParametersAddInfo(nullptr)
{}

safe_VkVideoEncodeH264SessionParametersCreateInfoEXT::safe_VkVideoEncodeH264SessionParametersCreateInfoEXT(const safe_VkVideoEncodeH264SessionParametersCreateInfoEXT& copy_src)
{
    sType = copy_src.sType;
    maxSpsStdCount = copy_src.maxSpsStdCount;
    maxPpsStdCount = copy_src.maxPpsStdCount;
    pParametersAddInfo = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pParametersAddInfo)
        pParametersAddInfo = new safe_VkVideoEncodeH264SessionParametersAddInfoEXT(*copy_src.pParametersAddInfo);
}

safe_VkVideoEncodeH264SessionParametersCreateInfoEXT& safe_VkVideoEncodeH264SessionParametersCreateInfoEXT::operator=(const safe_VkVideoEncodeH264SessionParametersCreateInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pParametersAddInfo)
        delete pParametersAddInfo;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    maxSpsStdCount = copy_src.maxSpsStdCount;
    maxPpsStdCount = copy_src.maxPpsStdCount;
    pParametersAddInfo = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pParametersAddInfo)
        pParametersAddInfo = new safe_VkVideoEncodeH264SessionParametersAddInfoEXT(*copy_src.pParametersAddInfo);

    return *this;
}

safe_VkVideoEncodeH264SessionParametersCreateInfoEXT::~safe_VkVideoEncodeH264SessionParametersCreateInfoEXT()
{
    if (pParametersAddInfo)
        delete pParametersAddInfo;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEncodeH264SessionParametersCreateInfoEXT::initialize(const VkVideoEncodeH264SessionParametersCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    maxSpsStdCount = in_struct->maxSpsStdCount;
    maxPpsStdCount = in_struct->maxPpsStdCount;
    pParametersAddInfo = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pParametersAddInfo)
        pParametersAddInfo = new safe_VkVideoEncodeH264SessionParametersAddInfoEXT(in_struct->pParametersAddInfo);
}

void safe_VkVideoEncodeH264SessionParametersCreateInfoEXT::initialize(const safe_VkVideoEncodeH264SessionParametersCreateInfoEXT* copy_src)
{
    sType = copy_src->sType;
    maxSpsStdCount = copy_src->maxSpsStdCount;
    maxPpsStdCount = copy_src->maxPpsStdCount;
    pParametersAddInfo = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pParametersAddInfo)
        pParametersAddInfo = new safe_VkVideoEncodeH264SessionParametersAddInfoEXT(*copy_src->pParametersAddInfo);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEncodeH264DpbSlotInfoEXT::safe_VkVideoEncodeH264DpbSlotInfoEXT(const VkVideoEncodeH264DpbSlotInfoEXT* in_struct) :
    sType(in_struct->sType),
    slotIndex(in_struct->slotIndex),
    pStdPictureInfo(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pStdPictureInfo) {
        pStdPictureInfo = new StdVideoEncodeH264PictureInfo(*in_struct->pStdPictureInfo);
    }
}

safe_VkVideoEncodeH264DpbSlotInfoEXT::safe_VkVideoEncodeH264DpbSlotInfoEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_EXT),
    pNext(nullptr),
    pStdPictureInfo(nullptr)
{}

safe_VkVideoEncodeH264DpbSlotInfoEXT::safe_VkVideoEncodeH264DpbSlotInfoEXT(const safe_VkVideoEncodeH264DpbSlotInfoEXT& copy_src)
{
    sType = copy_src.sType;
    slotIndex = copy_src.slotIndex;
    pStdPictureInfo = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pStdPictureInfo) {
        pStdPictureInfo = new StdVideoEncodeH264PictureInfo(*copy_src.pStdPictureInfo);
    }
}

safe_VkVideoEncodeH264DpbSlotInfoEXT& safe_VkVideoEncodeH264DpbSlotInfoEXT::operator=(const safe_VkVideoEncodeH264DpbSlotInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pStdPictureInfo)
        delete pStdPictureInfo;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    slotIndex = copy_src.slotIndex;
    pStdPictureInfo = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pStdPictureInfo) {
        pStdPictureInfo = new StdVideoEncodeH264PictureInfo(*copy_src.pStdPictureInfo);
    }

    return *this;
}

safe_VkVideoEncodeH264DpbSlotInfoEXT::~safe_VkVideoEncodeH264DpbSlotInfoEXT()
{
    if (pStdPictureInfo)
        delete pStdPictureInfo;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEncodeH264DpbSlotInfoEXT::initialize(const VkVideoEncodeH264DpbSlotInfoEXT* in_struct)
{
    sType = in_struct->sType;
    slotIndex = in_struct->slotIndex;
    pStdPictureInfo = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pStdPictureInfo) {
        pStdPictureInfo = new StdVideoEncodeH264PictureInfo(*in_struct->pStdPictureInfo);
    }
}

void safe_VkVideoEncodeH264DpbSlotInfoEXT::initialize(const safe_VkVideoEncodeH264DpbSlotInfoEXT* copy_src)
{
    sType = copy_src->sType;
    slotIndex = copy_src->slotIndex;
    pStdPictureInfo = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pStdPictureInfo) {
        pStdPictureInfo = new StdVideoEncodeH264PictureInfo(*copy_src->pStdPictureInfo);
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEncodeH264NaluSliceEXT::safe_VkVideoEncodeH264NaluSliceEXT(const VkVideoEncodeH264NaluSliceEXT* in_struct) :
    sType(in_struct->sType),
    pSliceHeaderStd(nullptr),
    mbCount(in_struct->mbCount),
    refFinalList0EntryCount(in_struct->refFinalList0EntryCount),
    pRefFinalList0Entries(nullptr),
    refFinalList1EntryCount(in_struct->refFinalList1EntryCount),
    pRefFinalList1Entries(nullptr),
    precedingNaluBytes(in_struct->precedingNaluBytes),
    minQp(in_struct->minQp),
    maxQp(in_struct->maxQp)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSliceHeaderStd) {
        pSliceHeaderStd = new StdVideoEncodeH264SliceHeader(*in_struct->pSliceHeaderStd);
    }
    if (refFinalList0EntryCount && in_struct->pRefFinalList0Entries) {
        pRefFinalList0Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refFinalList0EntryCount];
        for (uint32_t i = 0; i < refFinalList0EntryCount; ++i) {
            pRefFinalList0Entries[i].initialize(&in_struct->pRefFinalList0Entries[i]);
        }
    }
    if (refFinalList1EntryCount && in_struct->pRefFinalList1Entries) {
        pRefFinalList1Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refFinalList1EntryCount];
        for (uint32_t i = 0; i < refFinalList1EntryCount; ++i) {
            pRefFinalList1Entries[i].initialize(&in_struct->pRefFinalList1Entries[i]);
        }
    }
}

safe_VkVideoEncodeH264NaluSliceEXT::safe_VkVideoEncodeH264NaluSliceEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_EXT),
    pNext(nullptr),
    pSliceHeaderStd(nullptr),
    pRefFinalList0Entries(nullptr),
    pRefFinalList1Entries(nullptr)
{}

safe_VkVideoEncodeH264NaluSliceEXT::safe_VkVideoEncodeH264NaluSliceEXT(const safe_VkVideoEncodeH264NaluSliceEXT& copy_src)
{
    sType = copy_src.sType;
    pSliceHeaderStd = nullptr;
    mbCount = copy_src.mbCount;
    refFinalList0EntryCount = copy_src.refFinalList0EntryCount;
    pRefFinalList0Entries = nullptr;
    refFinalList1EntryCount = copy_src.refFinalList1EntryCount;
    pRefFinalList1Entries = nullptr;
    precedingNaluBytes = copy_src.precedingNaluBytes;
    minQp = copy_src.minQp;
    maxQp = copy_src.maxQp;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSliceHeaderStd) {
        pSliceHeaderStd = new StdVideoEncodeH264SliceHeader(*copy_src.pSliceHeaderStd);
    }
    if (refFinalList0EntryCount && copy_src.pRefFinalList0Entries) {
        pRefFinalList0Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refFinalList0EntryCount];
        for (uint32_t i = 0; i < refFinalList0EntryCount; ++i) {
            pRefFinalList0Entries[i].initialize(&copy_src.pRefFinalList0Entries[i]);
        }
    }
    if (refFinalList1EntryCount && copy_src.pRefFinalList1Entries) {
        pRefFinalList1Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refFinalList1EntryCount];
        for (uint32_t i = 0; i < refFinalList1EntryCount; ++i) {
            pRefFinalList1Entries[i].initialize(&copy_src.pRefFinalList1Entries[i]);
        }
    }
}

safe_VkVideoEncodeH264NaluSliceEXT& safe_VkVideoEncodeH264NaluSliceEXT::operator=(const safe_VkVideoEncodeH264NaluSliceEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pSliceHeaderStd)
        delete pSliceHeaderStd;
    if (pRefFinalList0Entries)
        delete[] pRefFinalList0Entries;
    if (pRefFinalList1Entries)
        delete[] pRefFinalList1Entries;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    pSliceHeaderStd = nullptr;
    mbCount = copy_src.mbCount;
    refFinalList0EntryCount = copy_src.refFinalList0EntryCount;
    pRefFinalList0Entries = nullptr;
    refFinalList1EntryCount = copy_src.refFinalList1EntryCount;
    pRefFinalList1Entries = nullptr;
    precedingNaluBytes = copy_src.precedingNaluBytes;
    minQp = copy_src.minQp;
    maxQp = copy_src.maxQp;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSliceHeaderStd) {
        pSliceHeaderStd = new StdVideoEncodeH264SliceHeader(*copy_src.pSliceHeaderStd);
    }
    if (refFinalList0EntryCount && copy_src.pRefFinalList0Entries) {
        pRefFinalList0Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refFinalList0EntryCount];
        for (uint32_t i = 0; i < refFinalList0EntryCount; ++i) {
            pRefFinalList0Entries[i].initialize(&copy_src.pRefFinalList0Entries[i]);
        }
    }
    if (refFinalList1EntryCount && copy_src.pRefFinalList1Entries) {
        pRefFinalList1Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refFinalList1EntryCount];
        for (uint32_t i = 0; i < refFinalList1EntryCount; ++i) {
            pRefFinalList1Entries[i].initialize(&copy_src.pRefFinalList1Entries[i]);
        }
    }

    return *this;
}

safe_VkVideoEncodeH264NaluSliceEXT::~safe_VkVideoEncodeH264NaluSliceEXT()
{
    if (pSliceHeaderStd)
        delete pSliceHeaderStd;
    if (pRefFinalList0Entries)
        delete[] pRefFinalList0Entries;
    if (pRefFinalList1Entries)
        delete[] pRefFinalList1Entries;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEncodeH264NaluSliceEXT::initialize(const VkVideoEncodeH264NaluSliceEXT* in_struct)
{
    sType = in_struct->sType;
    pSliceHeaderStd = nullptr;
    mbCount = in_struct->mbCount;
    refFinalList0EntryCount = in_struct->refFinalList0EntryCount;
    pRefFinalList0Entries = nullptr;
    refFinalList1EntryCount = in_struct->refFinalList1EntryCount;
    pRefFinalList1Entries = nullptr;
    precedingNaluBytes = in_struct->precedingNaluBytes;
    minQp = in_struct->minQp;
    maxQp = in_struct->maxQp;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSliceHeaderStd) {
        pSliceHeaderStd = new StdVideoEncodeH264SliceHeader(*in_struct->pSliceHeaderStd);
    }
    if (refFinalList0EntryCount && in_struct->pRefFinalList0Entries) {
        pRefFinalList0Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refFinalList0EntryCount];
        for (uint32_t i = 0; i < refFinalList0EntryCount; ++i) {
            pRefFinalList0Entries[i].initialize(&in_struct->pRefFinalList0Entries[i]);
        }
    }
    if (refFinalList1EntryCount && in_struct->pRefFinalList1Entries) {
        pRefFinalList1Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refFinalList1EntryCount];
        for (uint32_t i = 0; i < refFinalList1EntryCount; ++i) {
            pRefFinalList1Entries[i].initialize(&in_struct->pRefFinalList1Entries[i]);
        }
    }
}

void safe_VkVideoEncodeH264NaluSliceEXT::initialize(const safe_VkVideoEncodeH264NaluSliceEXT* copy_src)
{
    sType = copy_src->sType;
    pSliceHeaderStd = nullptr;
    mbCount = copy_src->mbCount;
    refFinalList0EntryCount = copy_src->refFinalList0EntryCount;
    pRefFinalList0Entries = nullptr;
    refFinalList1EntryCount = copy_src->refFinalList1EntryCount;
    pRefFinalList1Entries = nullptr;
    precedingNaluBytes = copy_src->precedingNaluBytes;
    minQp = copy_src->minQp;
    maxQp = copy_src->maxQp;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pSliceHeaderStd) {
        pSliceHeaderStd = new StdVideoEncodeH264SliceHeader(*copy_src->pSliceHeaderStd);
    }
    if (refFinalList0EntryCount && copy_src->pRefFinalList0Entries) {
        pRefFinalList0Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refFinalList0EntryCount];
        for (uint32_t i = 0; i < refFinalList0EntryCount; ++i) {
            pRefFinalList0Entries[i].initialize(&copy_src->pRefFinalList0Entries[i]);
        }
    }
    if (refFinalList1EntryCount && copy_src->pRefFinalList1Entries) {
        pRefFinalList1Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refFinalList1EntryCount];
        for (uint32_t i = 0; i < refFinalList1EntryCount; ++i) {
            pRefFinalList1Entries[i].initialize(&copy_src->pRefFinalList1Entries[i]);
        }
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEncodeH264VclFrameInfoEXT::safe_VkVideoEncodeH264VclFrameInfoEXT(const VkVideoEncodeH264VclFrameInfoEXT* in_struct) :
    sType(in_struct->sType),
    refDefaultFinalList0EntryCount(in_struct->refDefaultFinalList0EntryCount),
    pRefDefaultFinalList0Entries(nullptr),
    refDefaultFinalList1EntryCount(in_struct->refDefaultFinalList1EntryCount),
    pRefDefaultFinalList1Entries(nullptr),
    naluSliceEntryCount(in_struct->naluSliceEntryCount),
    pNaluSliceEntries(nullptr),
    pCurrentPictureInfo(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (refDefaultFinalList0EntryCount && in_struct->pRefDefaultFinalList0Entries) {
        pRefDefaultFinalList0Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refDefaultFinalList0EntryCount];
        for (uint32_t i = 0; i < refDefaultFinalList0EntryCount; ++i) {
            pRefDefaultFinalList0Entries[i].initialize(&in_struct->pRefDefaultFinalList0Entries[i]);
        }
    }
    if (refDefaultFinalList1EntryCount && in_struct->pRefDefaultFinalList1Entries) {
        pRefDefaultFinalList1Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refDefaultFinalList1EntryCount];
        for (uint32_t i = 0; i < refDefaultFinalList1EntryCount; ++i) {
            pRefDefaultFinalList1Entries[i].initialize(&in_struct->pRefDefaultFinalList1Entries[i]);
        }
    }
    if (naluSliceEntryCount && in_struct->pNaluSliceEntries) {
        pNaluSliceEntries = new safe_VkVideoEncodeH264NaluSliceEXT[naluSliceEntryCount];
        for (uint32_t i = 0; i < naluSliceEntryCount; ++i) {
            pNaluSliceEntries[i].initialize(&in_struct->pNaluSliceEntries[i]);
        }
    }
    if (in_struct->pCurrentPictureInfo)
        pCurrentPictureInfo = new safe_VkVideoEncodeH264DpbSlotInfoEXT(in_struct->pCurrentPictureInfo);
}

safe_VkVideoEncodeH264VclFrameInfoEXT::safe_VkVideoEncodeH264VclFrameInfoEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_VCL_FRAME_INFO_EXT),
    pNext(nullptr),
    pRefDefaultFinalList0Entries(nullptr),
    pRefDefaultFinalList1Entries(nullptr),
    pNaluSliceEntries(nullptr),
    pCurrentPictureInfo(nullptr)
{}

safe_VkVideoEncodeH264VclFrameInfoEXT::safe_VkVideoEncodeH264VclFrameInfoEXT(const safe_VkVideoEncodeH264VclFrameInfoEXT& copy_src)
{
    sType = copy_src.sType;
    refDefaultFinalList0EntryCount = copy_src.refDefaultFinalList0EntryCount;
    pRefDefaultFinalList0Entries = nullptr;
    refDefaultFinalList1EntryCount = copy_src.refDefaultFinalList1EntryCount;
    pRefDefaultFinalList1Entries = nullptr;
    naluSliceEntryCount = copy_src.naluSliceEntryCount;
    pNaluSliceEntries = nullptr;
    pCurrentPictureInfo = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (refDefaultFinalList0EntryCount && copy_src.pRefDefaultFinalList0Entries) {
        pRefDefaultFinalList0Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refDefaultFinalList0EntryCount];
        for (uint32_t i = 0; i < refDefaultFinalList0EntryCount; ++i) {
            pRefDefaultFinalList0Entries[i].initialize(&copy_src.pRefDefaultFinalList0Entries[i]);
        }
    }
    if (refDefaultFinalList1EntryCount && copy_src.pRefDefaultFinalList1Entries) {
        pRefDefaultFinalList1Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refDefaultFinalList1EntryCount];
        for (uint32_t i = 0; i < refDefaultFinalList1EntryCount; ++i) {
            pRefDefaultFinalList1Entries[i].initialize(&copy_src.pRefDefaultFinalList1Entries[i]);
        }
    }
    if (naluSliceEntryCount && copy_src.pNaluSliceEntries) {
        pNaluSliceEntries = new safe_VkVideoEncodeH264NaluSliceEXT[naluSliceEntryCount];
        for (uint32_t i = 0; i < naluSliceEntryCount; ++i) {
            pNaluSliceEntries[i].initialize(&copy_src.pNaluSliceEntries[i]);
        }
    }
    if (copy_src.pCurrentPictureInfo)
        pCurrentPictureInfo = new safe_VkVideoEncodeH264DpbSlotInfoEXT(*copy_src.pCurrentPictureInfo);
}

safe_VkVideoEncodeH264VclFrameInfoEXT& safe_VkVideoEncodeH264VclFrameInfoEXT::operator=(const safe_VkVideoEncodeH264VclFrameInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pRefDefaultFinalList0Entries)
        delete[] pRefDefaultFinalList0Entries;
    if (pRefDefaultFinalList1Entries)
        delete[] pRefDefaultFinalList1Entries;
    if (pNaluSliceEntries)
        delete[] pNaluSliceEntries;
    if (pCurrentPictureInfo)
        delete pCurrentPictureInfo;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    refDefaultFinalList0EntryCount = copy_src.refDefaultFinalList0EntryCount;
    pRefDefaultFinalList0Entries = nullptr;
    refDefaultFinalList1EntryCount = copy_src.refDefaultFinalList1EntryCount;
    pRefDefaultFinalList1Entries = nullptr;
    naluSliceEntryCount = copy_src.naluSliceEntryCount;
    pNaluSliceEntries = nullptr;
    pCurrentPictureInfo = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (refDefaultFinalList0EntryCount && copy_src.pRefDefaultFinalList0Entries) {
        pRefDefaultFinalList0Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refDefaultFinalList0EntryCount];
        for (uint32_t i = 0; i < refDefaultFinalList0EntryCount; ++i) {
            pRefDefaultFinalList0Entries[i].initialize(&copy_src.pRefDefaultFinalList0Entries[i]);
        }
    }
    if (refDefaultFinalList1EntryCount && copy_src.pRefDefaultFinalList1Entries) {
        pRefDefaultFinalList1Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refDefaultFinalList1EntryCount];
        for (uint32_t i = 0; i < refDefaultFinalList1EntryCount; ++i) {
            pRefDefaultFinalList1Entries[i].initialize(&copy_src.pRefDefaultFinalList1Entries[i]);
        }
    }
    if (naluSliceEntryCount && copy_src.pNaluSliceEntries) {
        pNaluSliceEntries = new safe_VkVideoEncodeH264NaluSliceEXT[naluSliceEntryCount];
        for (uint32_t i = 0; i < naluSliceEntryCount; ++i) {
            pNaluSliceEntries[i].initialize(&copy_src.pNaluSliceEntries[i]);
        }
    }
    if (copy_src.pCurrentPictureInfo)
        pCurrentPictureInfo = new safe_VkVideoEncodeH264DpbSlotInfoEXT(*copy_src.pCurrentPictureInfo);

    return *this;
}

safe_VkVideoEncodeH264VclFrameInfoEXT::~safe_VkVideoEncodeH264VclFrameInfoEXT()
{
    if (pRefDefaultFinalList0Entries)
        delete[] pRefDefaultFinalList0Entries;
    if (pRefDefaultFinalList1Entries)
        delete[] pRefDefaultFinalList1Entries;
    if (pNaluSliceEntries)
        delete[] pNaluSliceEntries;
    if (pCurrentPictureInfo)
        delete pCurrentPictureInfo;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEncodeH264VclFrameInfoEXT::initialize(const VkVideoEncodeH264VclFrameInfoEXT* in_struct)
{
    sType = in_struct->sType;
    refDefaultFinalList0EntryCount = in_struct->refDefaultFinalList0EntryCount;
    pRefDefaultFinalList0Entries = nullptr;
    refDefaultFinalList1EntryCount = in_struct->refDefaultFinalList1EntryCount;
    pRefDefaultFinalList1Entries = nullptr;
    naluSliceEntryCount = in_struct->naluSliceEntryCount;
    pNaluSliceEntries = nullptr;
    pCurrentPictureInfo = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (refDefaultFinalList0EntryCount && in_struct->pRefDefaultFinalList0Entries) {
        pRefDefaultFinalList0Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refDefaultFinalList0EntryCount];
        for (uint32_t i = 0; i < refDefaultFinalList0EntryCount; ++i) {
            pRefDefaultFinalList0Entries[i].initialize(&in_struct->pRefDefaultFinalList0Entries[i]);
        }
    }
    if (refDefaultFinalList1EntryCount && in_struct->pRefDefaultFinalList1Entries) {
        pRefDefaultFinalList1Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refDefaultFinalList1EntryCount];
        for (uint32_t i = 0; i < refDefaultFinalList1EntryCount; ++i) {
            pRefDefaultFinalList1Entries[i].initialize(&in_struct->pRefDefaultFinalList1Entries[i]);
        }
    }
    if (naluSliceEntryCount && in_struct->pNaluSliceEntries) {
        pNaluSliceEntries = new safe_VkVideoEncodeH264NaluSliceEXT[naluSliceEntryCount];
        for (uint32_t i = 0; i < naluSliceEntryCount; ++i) {
            pNaluSliceEntries[i].initialize(&in_struct->pNaluSliceEntries[i]);
        }
    }
    if (in_struct->pCurrentPictureInfo)
        pCurrentPictureInfo = new safe_VkVideoEncodeH264DpbSlotInfoEXT(in_struct->pCurrentPictureInfo);
}

void safe_VkVideoEncodeH264VclFrameInfoEXT::initialize(const safe_VkVideoEncodeH264VclFrameInfoEXT* copy_src)
{
    sType = copy_src->sType;
    refDefaultFinalList0EntryCount = copy_src->refDefaultFinalList0EntryCount;
    pRefDefaultFinalList0Entries = nullptr;
    refDefaultFinalList1EntryCount = copy_src->refDefaultFinalList1EntryCount;
    pRefDefaultFinalList1Entries = nullptr;
    naluSliceEntryCount = copy_src->naluSliceEntryCount;
    pNaluSliceEntries = nullptr;
    pCurrentPictureInfo = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (refDefaultFinalList0EntryCount && copy_src->pRefDefaultFinalList0Entries) {
        pRefDefaultFinalList0Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refDefaultFinalList0EntryCount];
        for (uint32_t i = 0; i < refDefaultFinalList0EntryCount; ++i) {
            pRefDefaultFinalList0Entries[i].initialize(&copy_src->pRefDefaultFinalList0Entries[i]);
        }
    }
    if (refDefaultFinalList1EntryCount && copy_src->pRefDefaultFinalList1Entries) {
        pRefDefaultFinalList1Entries = new safe_VkVideoEncodeH264DpbSlotInfoEXT[refDefaultFinalList1EntryCount];
        for (uint32_t i = 0; i < refDefaultFinalList1EntryCount; ++i) {
            pRefDefaultFinalList1Entries[i].initialize(&copy_src->pRefDefaultFinalList1Entries[i]);
        }
    }
    if (naluSliceEntryCount && copy_src->pNaluSliceEntries) {
        pNaluSliceEntries = new safe_VkVideoEncodeH264NaluSliceEXT[naluSliceEntryCount];
        for (uint32_t i = 0; i < naluSliceEntryCount; ++i) {
            pNaluSliceEntries[i].initialize(&copy_src->pNaluSliceEntries[i]);
        }
    }
    if (copy_src->pCurrentPictureInfo)
        pCurrentPictureInfo = new safe_VkVideoEncodeH264DpbSlotInfoEXT(*copy_src->pCurrentPictureInfo);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEncodeH264EmitPictureParametersEXT::safe_VkVideoEncodeH264EmitPictureParametersEXT(const VkVideoEncodeH264EmitPictureParametersEXT* in_struct) :
    sType(in_struct->sType),
    spsId(in_struct->spsId),
    emitSpsEnable(in_struct->emitSpsEnable),
    ppsIdEntryCount(in_struct->ppsIdEntryCount),
    ppsIdEntries(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->ppsIdEntries) {
        ppsIdEntries = new uint8_t[in_struct->ppsIdEntryCount];
        memcpy ((void *)ppsIdEntries, (void *)in_struct->ppsIdEntries, sizeof(uint8_t)*in_struct->ppsIdEntryCount);
    }
}

safe_VkVideoEncodeH264EmitPictureParametersEXT::safe_VkVideoEncodeH264EmitPictureParametersEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_EMIT_PICTURE_PARAMETERS_EXT),
    pNext(nullptr),
    ppsIdEntries(nullptr)
{}

safe_VkVideoEncodeH264EmitPictureParametersEXT::safe_VkVideoEncodeH264EmitPictureParametersEXT(const safe_VkVideoEncodeH264EmitPictureParametersEXT& copy_src)
{
    sType = copy_src.sType;
    spsId = copy_src.spsId;
    emitSpsEnable = copy_src.emitSpsEnable;
    ppsIdEntryCount = copy_src.ppsIdEntryCount;
    ppsIdEntries = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.ppsIdEntries) {
        ppsIdEntries = new uint8_t[copy_src.ppsIdEntryCount];
        memcpy ((void *)ppsIdEntries, (void *)copy_src.ppsIdEntries, sizeof(uint8_t)*copy_src.ppsIdEntryCount);
    }
}

safe_VkVideoEncodeH264EmitPictureParametersEXT& safe_VkVideoEncodeH264EmitPictureParametersEXT::operator=(const safe_VkVideoEncodeH264EmitPictureParametersEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (ppsIdEntries)
        delete[] ppsIdEntries;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    spsId = copy_src.spsId;
    emitSpsEnable = copy_src.emitSpsEnable;
    ppsIdEntryCount = copy_src.ppsIdEntryCount;
    ppsIdEntries = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.ppsIdEntries) {
        ppsIdEntries = new uint8_t[copy_src.ppsIdEntryCount];
        memcpy ((void *)ppsIdEntries, (void *)copy_src.ppsIdEntries, sizeof(uint8_t)*copy_src.ppsIdEntryCount);
    }

    return *this;
}

safe_VkVideoEncodeH264EmitPictureParametersEXT::~safe_VkVideoEncodeH264EmitPictureParametersEXT()
{
    if (ppsIdEntries)
        delete[] ppsIdEntries;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEncodeH264EmitPictureParametersEXT::initialize(const VkVideoEncodeH264EmitPictureParametersEXT* in_struct)
{
    sType = in_struct->sType;
    spsId = in_struct->spsId;
    emitSpsEnable = in_struct->emitSpsEnable;
    ppsIdEntryCount = in_struct->ppsIdEntryCount;
    ppsIdEntries = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->ppsIdEntries) {
        ppsIdEntries = new uint8_t[in_struct->ppsIdEntryCount];
        memcpy ((void *)ppsIdEntries, (void *)in_struct->ppsIdEntries, sizeof(uint8_t)*in_struct->ppsIdEntryCount);
    }
}

void safe_VkVideoEncodeH264EmitPictureParametersEXT::initialize(const safe_VkVideoEncodeH264EmitPictureParametersEXT* copy_src)
{
    sType = copy_src->sType;
    spsId = copy_src->spsId;
    emitSpsEnable = copy_src->emitSpsEnable;
    ppsIdEntryCount = copy_src->ppsIdEntryCount;
    ppsIdEntries = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->ppsIdEntries) {
        ppsIdEntries = new uint8_t[copy_src->ppsIdEntryCount];
        memcpy ((void *)ppsIdEntries, (void *)copy_src->ppsIdEntries, sizeof(uint8_t)*copy_src->ppsIdEntryCount);
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoEncodeH264ProfileEXT::safe_VkVideoEncodeH264ProfileEXT(const VkVideoEncodeH264ProfileEXT* in_struct) :
    sType(in_struct->sType),
    stdProfileIdc(in_struct->stdProfileIdc)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoEncodeH264ProfileEXT::safe_VkVideoEncodeH264ProfileEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_EXT),
    pNext(nullptr)
{}

safe_VkVideoEncodeH264ProfileEXT::safe_VkVideoEncodeH264ProfileEXT(const safe_VkVideoEncodeH264ProfileEXT& copy_src)
{
    sType = copy_src.sType;
    stdProfileIdc = copy_src.stdProfileIdc;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoEncodeH264ProfileEXT& safe_VkVideoEncodeH264ProfileEXT::operator=(const safe_VkVideoEncodeH264ProfileEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    stdProfileIdc = copy_src.stdProfileIdc;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoEncodeH264ProfileEXT::~safe_VkVideoEncodeH264ProfileEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoEncodeH264ProfileEXT::initialize(const VkVideoEncodeH264ProfileEXT* in_struct)
{
    sType = in_struct->sType;
    stdProfileIdc = in_struct->stdProfileIdc;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoEncodeH264ProfileEXT::initialize(const safe_VkVideoEncodeH264ProfileEXT* copy_src)
{
    sType = copy_src->sType;
    stdProfileIdc = copy_src->stdProfileIdc;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoDecodeH264ProfileEXT::safe_VkVideoDecodeH264ProfileEXT(const VkVideoDecodeH264ProfileEXT* in_struct) :
    sType(in_struct->sType),
    stdProfileIdc(in_struct->stdProfileIdc),
    pictureLayout(in_struct->pictureLayout)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoDecodeH264ProfileEXT::safe_VkVideoDecodeH264ProfileEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_EXT),
    pNext(nullptr)
{}

safe_VkVideoDecodeH264ProfileEXT::safe_VkVideoDecodeH264ProfileEXT(const safe_VkVideoDecodeH264ProfileEXT& copy_src)
{
    sType = copy_src.sType;
    stdProfileIdc = copy_src.stdProfileIdc;
    pictureLayout = copy_src.pictureLayout;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoDecodeH264ProfileEXT& safe_VkVideoDecodeH264ProfileEXT::operator=(const safe_VkVideoDecodeH264ProfileEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    stdProfileIdc = copy_src.stdProfileIdc;
    pictureLayout = copy_src.pictureLayout;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoDecodeH264ProfileEXT::~safe_VkVideoDecodeH264ProfileEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoDecodeH264ProfileEXT::initialize(const VkVideoDecodeH264ProfileEXT* in_struct)
{
    sType = in_struct->sType;
    stdProfileIdc = in_struct->stdProfileIdc;
    pictureLayout = in_struct->pictureLayout;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoDecodeH264ProfileEXT::initialize(const safe_VkVideoDecodeH264ProfileEXT* copy_src)
{
    sType = copy_src->sType;
    stdProfileIdc = copy_src->stdProfileIdc;
    pictureLayout = copy_src->pictureLayout;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoDecodeH264CapabilitiesEXT::safe_VkVideoDecodeH264CapabilitiesEXT(const VkVideoDecodeH264CapabilitiesEXT* in_struct) :
    sType(in_struct->sType),
    maxLevel(in_struct->maxLevel),
    fieldOffsetGranularity(in_struct->fieldOffsetGranularity),
    stdExtensionVersion(in_struct->stdExtensionVersion)
{
    pNext = SafePnextCopy(in_struct->pNext);
}

safe_VkVideoDecodeH264CapabilitiesEXT::safe_VkVideoDecodeH264CapabilitiesEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_EXT),
    pNext(nullptr)
{}

safe_VkVideoDecodeH264CapabilitiesEXT::safe_VkVideoDecodeH264CapabilitiesEXT(const safe_VkVideoDecodeH264CapabilitiesEXT& copy_src)
{
    sType = copy_src.sType;
    maxLevel = copy_src.maxLevel;
    fieldOffsetGranularity = copy_src.fieldOffsetGranularity;
    stdExtensionVersion = copy_src.stdExtensionVersion;
    pNext = SafePnextCopy(copy_src.pNext);
}

safe_VkVideoDecodeH264CapabilitiesEXT& safe_VkVideoDecodeH264CapabilitiesEXT::operator=(const safe_VkVideoDecodeH264CapabilitiesEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    maxLevel = copy_src.maxLevel;
    fieldOffsetGranularity = copy_src.fieldOffsetGranularity;
    stdExtensionVersion = copy_src.stdExtensionVersion;
    pNext = SafePnextCopy(copy_src.pNext);

    return *this;
}

safe_VkVideoDecodeH264CapabilitiesEXT::~safe_VkVideoDecodeH264CapabilitiesEXT()
{
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoDecodeH264CapabilitiesEXT::initialize(const VkVideoDecodeH264CapabilitiesEXT* in_struct)
{
    sType = in_struct->sType;
    maxLevel = in_struct->maxLevel;
    fieldOffsetGranularity = in_struct->fieldOffsetGranularity;
    stdExtensionVersion = in_struct->stdExtensionVersion;
    pNext = SafePnextCopy(in_struct->pNext);
}

void safe_VkVideoDecodeH264CapabilitiesEXT::initialize(const safe_VkVideoDecodeH264CapabilitiesEXT* copy_src)
{
    sType = copy_src->sType;
    maxLevel = copy_src->maxLevel;
    fieldOffsetGranularity = copy_src->fieldOffsetGranularity;
    stdExtensionVersion = copy_src->stdExtensionVersion;
    pNext = SafePnextCopy(copy_src->pNext);
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoDecodeH264SessionCreateInfoEXT::safe_VkVideoDecodeH264SessionCreateInfoEXT(const VkVideoDecodeH264SessionCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    flags(in_struct->flags),
    pStdExtensionVersion(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pStdExtensionVersion) {
        pStdExtensionVersion = new VkExtensionProperties(*in_struct->pStdExtensionVersion);
    }
}

safe_VkVideoDecodeH264SessionCreateInfoEXT::safe_VkVideoDecodeH264SessionCreateInfoEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_CREATE_INFO_EXT),
    pNext(nullptr),
    pStdExtensionVersion(nullptr)
{}

safe_VkVideoDecodeH264SessionCreateInfoEXT::safe_VkVideoDecodeH264SessionCreateInfoEXT(const safe_VkVideoDecodeH264SessionCreateInfoEXT& copy_src)
{
    sType = copy_src.sType;
    flags = copy_src.flags;
    pStdExtensionVersion = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pStdExtensionVersion) {
        pStdExtensionVersion = new VkExtensionProperties(*copy_src.pStdExtensionVersion);
    }
}

safe_VkVideoDecodeH264SessionCreateInfoEXT& safe_VkVideoDecodeH264SessionCreateInfoEXT::operator=(const safe_VkVideoDecodeH264SessionCreateInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pStdExtensionVersion)
        delete pStdExtensionVersion;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    flags = copy_src.flags;
    pStdExtensionVersion = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pStdExtensionVersion) {
        pStdExtensionVersion = new VkExtensionProperties(*copy_src.pStdExtensionVersion);
    }

    return *this;
}

safe_VkVideoDecodeH264SessionCreateInfoEXT::~safe_VkVideoDecodeH264SessionCreateInfoEXT()
{
    if (pStdExtensionVersion)
        delete pStdExtensionVersion;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoDecodeH264SessionCreateInfoEXT::initialize(const VkVideoDecodeH264SessionCreateInfoEXT* in_struct)
{
    sType = in_struct->sType;
    flags = in_struct->flags;
    pStdExtensionVersion = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pStdExtensionVersion) {
        pStdExtensionVersion = new VkExtensionProperties(*in_struct->pStdExtensionVersion);
    }
}

void safe_VkVideoDecodeH264SessionCreateInfoEXT::initialize(const safe_VkVideoDecodeH264SessionCreateInfoEXT* copy_src)
{
    sType = copy_src->sType;
    flags = copy_src->flags;
    pStdExtensionVersion = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pStdExtensionVersion) {
        pStdExtensionVersion = new VkExtensionProperties(*copy_src->pStdExtensionVersion);
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoDecodeH264SessionParametersAddInfoEXT::safe_VkVideoDecodeH264SessionParametersAddInfoEXT(const VkVideoDecodeH264SessionParametersAddInfoEXT* in_struct) :
    sType(in_struct->sType),
    spsStdCount(in_struct->spsStdCount),
    pSpsStd(nullptr),
    ppsStdCount(in_struct->ppsStdCount),
    pPpsStd(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSpsStd) {
        pSpsStd = new StdVideoH264SequenceParameterSet[in_struct->spsStdCount];
        memcpy ((void *)pSpsStd, (void *)in_struct->pSpsStd, sizeof(StdVideoH264SequenceParameterSet)*in_struct->spsStdCount);
    }
    if (in_struct->pPpsStd) {
        pPpsStd = new StdVideoH264PictureParameterSet[in_struct->ppsStdCount];
        memcpy ((void *)pPpsStd, (void *)in_struct->pPpsStd, sizeof(StdVideoH264PictureParameterSet)*in_struct->ppsStdCount);
    }
}

safe_VkVideoDecodeH264SessionParametersAddInfoEXT::safe_VkVideoDecodeH264SessionParametersAddInfoEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_EXT),
    pNext(nullptr),
    pSpsStd(nullptr),
    pPpsStd(nullptr)
{}

safe_VkVideoDecodeH264SessionParametersAddInfoEXT::safe_VkVideoDecodeH264SessionParametersAddInfoEXT(const safe_VkVideoDecodeH264SessionParametersAddInfoEXT& copy_src)
{
    sType = copy_src.sType;
    spsStdCount = copy_src.spsStdCount;
    pSpsStd = nullptr;
    ppsStdCount = copy_src.ppsStdCount;
    pPpsStd = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSpsStd) {
        pSpsStd = new StdVideoH264SequenceParameterSet[copy_src.spsStdCount];
        memcpy ((void *)pSpsStd, (void *)copy_src.pSpsStd, sizeof(StdVideoH264SequenceParameterSet)*copy_src.spsStdCount);
    }
    if (copy_src.pPpsStd) {
        pPpsStd = new StdVideoH264PictureParameterSet[copy_src.ppsStdCount];
        memcpy ((void *)pPpsStd, (void *)copy_src.pPpsStd, sizeof(StdVideoH264PictureParameterSet)*copy_src.ppsStdCount);
    }
}

safe_VkVideoDecodeH264SessionParametersAddInfoEXT& safe_VkVideoDecodeH264SessionParametersAddInfoEXT::operator=(const safe_VkVideoDecodeH264SessionParametersAddInfoEXT& copy_src)
{
    if (&copy_src == this) return *this;

    if (pSpsStd)
        delete[] pSpsStd;
    if (pPpsStd)
        delete[] pPpsStd;
    if (pNext)
        FreePnextChain(pNext);

    sType = copy_src.sType;
    spsStdCount = copy_src.spsStdCount;
    pSpsStd = nullptr;
    ppsStdCount = copy_src.ppsStdCount;
    pPpsStd = nullptr;
    pNext = SafePnextCopy(copy_src.pNext);
    if (copy_src.pSpsStd) {
        pSpsStd = new StdVideoH264SequenceParameterSet[copy_src.spsStdCount];
        memcpy ((void *)pSpsStd, (void *)copy_src.pSpsStd, sizeof(StdVideoH264SequenceParameterSet)*copy_src.spsStdCount);
    }
    if (copy_src.pPpsStd) {
        pPpsStd = new StdVideoH264PictureParameterSet[copy_src.ppsStdCount];
        memcpy ((void *)pPpsStd, (void *)copy_src.pPpsStd, sizeof(StdVideoH264PictureParameterSet)*copy_src.ppsStdCount);
    }

    return *this;
}

safe_VkVideoDecodeH264SessionParametersAddInfoEXT::~safe_VkVideoDecodeH264SessionParametersAddInfoEXT()
{
    if (pSpsStd)
        delete[] pSpsStd;
    if (pPpsStd)
        delete[] pPpsStd;
    if (pNext)
        FreePnextChain(pNext);
}

void safe_VkVideoDecodeH264SessionParametersAddInfoEXT::initialize(const VkVideoDecodeH264SessionParametersAddInfoEXT* in_struct)
{
    sType = in_struct->sType;
    spsStdCount = in_struct->spsStdCount;
    pSpsStd = nullptr;
    ppsStdCount = in_struct->ppsStdCount;
    pPpsStd = nullptr;
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pSpsStd) {
        pSpsStd = new StdVideoH264SequenceParameterSet[in_struct->spsStdCount];
        memcpy ((void *)pSpsStd, (void *)in_struct->pSpsStd, sizeof(StdVideoH264SequenceParameterSet)*in_struct->spsStdCount);
    }
    if (in_struct->pPpsStd) {
        pPpsStd = new StdVideoH264PictureParameterSet[in_struct->ppsStdCount];
        memcpy ((void *)pPpsStd, (void *)in_struct->pPpsStd, sizeof(StdVideoH264PictureParameterSet)*in_struct->ppsStdCount);
    }
}

void safe_VkVideoDecodeH264SessionParametersAddInfoEXT::initialize(const safe_VkVideoDecodeH264SessionParametersAddInfoEXT* copy_src)
{
    sType = copy_src->sType;
    spsStdCount = copy_src->spsStdCount;
    pSpsStd = nullptr;
    ppsStdCount = copy_src->ppsStdCount;
    pPpsStd = nullptr;
    pNext = SafePnextCopy(copy_src->pNext);
    if (copy_src->pSpsStd) {
        pSpsStd = new StdVideoH264SequenceParameterSet[copy_src->spsStdCount];
        memcpy ((void *)pSpsStd, (void *)copy_src->pSpsStd, sizeof(StdVideoH264SequenceParameterSet)*copy_src->spsStdCount);
    }
    if (copy_src->pPpsStd) {
        pPpsStd = new StdVideoH264PictureParameterSet[copy_src->ppsStdCount];
        memcpy ((void *)pPpsStd, (void *)copy_src->pPpsStd, sizeof(StdVideoH264PictureParameterSet)*copy_src->ppsStdCount);
    }
}
#endif // VK_ENABLE_BETA_EXTENSIONS

#ifdef VK_ENABLE_BETA_EXTENSIONS


safe_VkVideoDecodeH264SessionParametersCreateInfoEXT::safe_VkVideoDecodeH264SessionParametersCreateInfoEXT(const VkVideoDecodeH264SessionParametersCreateInfoEXT* in_struct) :
    sType(in_struct->sType),
    maxSpsStdCount(in_struct->maxSpsStdCount),
    maxPpsStdCount(in_struct->maxPpsStdCount),
    pParametersAddInfo(nullptr)
{
    pNext = SafePnextCopy(in_struct->pNext);
    if (in_struct->pParametersAddInfo)
        pParametersAddInfo = new safe_VkVideoDecodeH264SessionParametersAddInfoEXT(in_struct->pParametersAddInfo);
}

safe_VkVideoDecodeH264SessionParametersCreateInfoEXT::safe_VkVideoDecodeH264SessionParametersCreateInfoEXT() :
    sType(VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_EXT),
    pNext(nullptr),
    pParametersAddInfo(nullptr)
{}

safe_VkVideoDecodeH264SessionParametersCreateInfoEXT::safe_VkVideoDecodeH264SessionParametersCreateInfoEXT(const safe_VkVideoDecodeH264Sessio