/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.details;

import org.graalvm.visualvm.heapviewer.truffle.details.SourceSectionView;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsProvider;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.spi.DetailsUtils;

public class SourceDetailsProvider
extends DetailsProvider.Basic {
    private static final String FSOURCE_NAME_MASK = "com.oracle.truffle.api.source.FileSourceImpl";
    private static final String CONTENT_NAME_MASK = "com.oracle.truffle.api.source.Content+";
    private static final String SOURCE_NAME_MASK = "com.oracle.truffle.api.source.Source+";
    private static final String SOURCEIMPL_KEY_MASK = "com.oracle.truffle.api.source.SourceImpl$Key+";
    private static final String SOURCE_SECTION_MASK = "com.oracle.truffle.api.source.SourceSection+";
    private static final String ASSUMPTION_MASK = "com.oracle.truffle.api.impl.AbstractAssumption+";
    private static final String HIDDEN_KEY_MASK = "com.oracle.truffle.api.object.HiddenKey";
    private static final String PROPERTY_MASK = "com.oracle.truffle.object.PropertyImpl";
    private static final String FRAMESLOT_MASK = "com.oracle.truffle.api.frame.FrameSlot";
    private static final String BP_ENABLED_MASK = "com.oracle.truffle.api.profiles.BranchProfile$Enabled";
    private static final String CP_BINARY_MASK = "com.oracle.truffle.api.profiles.ConditionProfile$Binary";

    public SourceDetailsProvider() {
        super(new String[]{FSOURCE_NAME_MASK, CONTENT_NAME_MASK, SOURCE_NAME_MASK, SOURCEIMPL_KEY_MASK, SOURCE_SECTION_MASK, ASSUMPTION_MASK, HIDDEN_KEY_MASK, PROPERTY_MASK, FRAMESLOT_MASK, BP_ENABLED_MASK, CP_BINARY_MASK});
    }

    public String getDetailsString(String className, Instance instance) {
        Object val;
        if (FSOURCE_NAME_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"path");
        }
        if (ASSUMPTION_MASK.equals(className) && (val = instance.getValueOfField("isValid")) instanceof Boolean) {
            boolean isValid = (Boolean)val;
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name") + " (" + (isValid ? "valid" : "invalid") + ")";
        }
        if (CONTENT_NAME_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"code");
        }
        if (SOURCEIMPL_KEY_MASK.equals(className)) {
            String name = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            String mimeType = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"mimeType");
            return name + " (" + mimeType + ")";
        }
        if (SOURCE_NAME_MASK.equals(className)) {
            Object key = instance.getValueOfField("key");
            if (key instanceof Instance) {
                return DetailsUtils.getInstanceString((Instance)((Instance)key));
            }
            String name = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name");
            String mimeType = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"mimeType");
            return name + " (" + mimeType + ")";
        }
        if (HIDDEN_KEY_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"name") + " (hidden)";
        }
        if (PROPERTY_MASK.equals(className)) {
            return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"key");
        }
        if (SOURCE_SECTION_MASK.equals(className)) {
            Integer charIndex = (Integer)instance.getValueOfField("charIndex");
            Integer charLength = (Integer)instance.getValueOfField("charLength");
            if (charIndex != null && charLength != null) {
                return DetailsUtils.getInstanceFieldString((Instance)instance, (String)"source") + " [" + charIndex + "," + (charIndex + charLength) + "]";
            }
        }
        if (FRAMESLOT_MASK.equals(className)) {
            Integer index = (Integer)instance.getValueOfField("index");
            String identifier = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"identifier");
            String kind = DetailsUtils.getInstanceFieldString((Instance)instance, (String)"kind");
            return "[" + index + "," + identifier + "," + kind + "]";
        }
        if (BP_ENABLED_MASK.equals(className)) {
            val = instance.getValueOfField("visited");
            if (val instanceof Boolean) {
                boolean visited = (Boolean)val;
                return visited ? "VISITED" : "UNINITIALIZED";
            }
            return null;
        }
        if (CP_BINARY_MASK.equals(className)) {
            val = instance.getValueOfField("wasTrue");
            Object val1 = instance.getValueOfField("wasFalse");
            if (val instanceof Boolean && val1 instanceof Boolean) {
                boolean wasTrue = (Boolean)val;
                boolean wasFalse = (Boolean)val1;
                return "wasTrue=" + wasTrue + ", wasFalse=" + wasFalse;
            }
        }
        return null;
    }

    public DetailsProvider.View getDetailsView(String className, Instance instance) {
        if (CONTENT_NAME_MASK.equals(className)) {
            Object val = instance.getValueOfField("code");
            if (val instanceof Instance) {
                Instance text = (Instance)val;
                return DetailsSupport.getDetailsView((Instance)text);
            }
            return null;
        }
        if (SOURCEIMPL_KEY_MASK.equals(className)) {
            Object val = instance.getValueOfField("characters");
            if (val instanceof Instance) {
                Instance text = (Instance)val;
                return DetailsSupport.getDetailsView((Instance)text);
            }
            val = instance.getValueOfField("content");
            if (val instanceof Instance) {
                Instance text = (Instance)val;
                return DetailsSupport.getDetailsView((Instance)text);
            }
            return null;
        }
        if (SOURCE_NAME_MASK.equals(className)) {
            Object val = instance.getValueOfField("content");
            if (val instanceof Instance) {
                Instance content = (Instance)val;
                return DetailsSupport.getDetailsView((Instance)content);
            }
            val = instance.getValueOfField("key");
            if (val instanceof Instance) {
                Instance content = (Instance)val;
                return DetailsSupport.getDetailsView((Instance)content);
            }
            return null;
        }
        if (SOURCE_SECTION_MASK.equals(className)) {
            Integer charIndex = (Integer)instance.getValueOfField("charIndex");
            Integer charLength = (Integer)instance.getValueOfField("charLength");
            Instance source = (Instance)instance.getValueOfField("source");
            Instance content = (Instance)source.getValueOfField("content");
            if (charIndex != null && charLength != null) {
                Instance code;
                if (content != null) {
                    code = (Instance)content.getValueOfField("code");
                    if (charLength == -1) {
                        code = (Instance)source.getValueOfField("name");
                    }
                } else {
                    Instance key = (Instance)source.getValueOfField("key");
                    code = (Instance)key.getValueOfField("characters");
                    if (code == null) {
                        code = (Instance)key.getValueOfField("content");
                    }
                    if (charLength == -1) {
                        code = (Instance)key.getValueOfField("name");
                    }
                }
                return new SourceSectionView(className, code, charIndex, charLength);
            }
        }
        return null;
    }
}

