/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.protobuf;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;
import org.openstreetmap.josm.data.protobuf.ProtobufParser;
import org.openstreetmap.josm.data.protobuf.WireType;
import org.openstreetmap.josm.tools.Utils;

public class ProtobufRecord
implements AutoCloseable {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final WireType type;
    private final int field;
    private byte[] bytes;

    public ProtobufRecord(ProtobufParser parser) throws IOException {
        Number number = ProtobufParser.convertByteArray(parser.nextVarInt(), (byte)7);
        this.field = (int)number.longValue() >> 3;
        byte wireType = (byte)(number.longValue() & 7L);
        this.type = Stream.of(WireType.values()).filter(wType -> wType.getTypeRepresentation() == wireType).findFirst().orElse(WireType.UNKNOWN);
        this.bytes = this.type == WireType.VARINT ? parser.nextVarInt() : (this.type == WireType.SIXTY_FOUR_BIT ? parser.nextFixed64() : (this.type == WireType.THIRTY_TWO_BIT ? parser.nextFixed32() : (this.type == WireType.LENGTH_DELIMITED ? parser.nextLengthDelimited() : EMPTY_BYTES)));
    }

    public double asDouble() {
        long doubleNumber = ProtobufParser.convertByteArray(this.asFixed64(), (byte)8).longValue();
        return Double.longBitsToDouble(doubleNumber);
    }

    public byte[] asFixed32() {
        return this.bytes;
    }

    public byte[] asFixed64() {
        return this.bytes;
    }

    public float asFloat() {
        int floatNumber = ProtobufParser.convertByteArray(this.asFixed32(), (byte)8).intValue();
        return Float.intBitsToFloat(floatNumber);
    }

    public Number asSignedVarInt() {
        Number signed = this.asUnsignedVarInt();
        return ProtobufParser.decodeZigZag(signed);
    }

    public String asString() {
        return Utils.intern(new String(this.bytes, StandardCharsets.UTF_8));
    }

    public Number asUnsignedVarInt() {
        return ProtobufParser.convertByteArray(this.bytes, (byte)7);
    }

    @Override
    public void close() {
        this.bytes = null;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public int getField() {
        return this.field;
    }

    public WireType getType() {
        return this.type;
    }
}

