/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.event.ActionEvent;
import net.osmand.plus.ApplicationMode;
import net.osmand.plus.TargetPointsHelper;
import net.osmand.plus.routing.RoutingHelper;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.actions.OffRoadAction;

public class RouteAction
extends OffRoadAction
implements RoutingHelper.RouteCalculationProgressCallback {
    private ApplicationMode mMode;

    public RouteAction(OsmWindow pCtx, ApplicationMode pMode) {
        super(pCtx);
        this.mMode = pMode;
        this.putValue("Name", this.mContext.getOffRoadString("offroad.route", pMode.toHumanStringCtx()));
    }

    @Override
    public void actionPerformed(ActionEvent pE) {
        this.mContext.getRoutingHelper().setProgressBar(this);
        TargetPointsHelper helper = this.mContext.getTargetPointsHelper();
        if (helper.getPointToStart() == null) {
            this.mContext.showToastMessage(this.mContext.getOffRoadString("offroad.start_position_undefined"));
            return;
        }
        if (helper.getPointToNavigate() == null) {
            this.mContext.showToastMessage(this.mContext.getOffRoadString("offroad.destination_position_undefined"));
            return;
        }
        this.mContext.getRoutingHelper().setAppMode(this.mMode);
        this.mContext.getRoutingHelper().setFinalAndCurrentLocation(helper.getPointToNavigate().point, helper.getIntermediatePointsLatLon(), helper.getPointToStartLocation());
    }

    @Override
    public void save() {
    }

    @Override
    public void updateProgress(int pProgress) {
        this.mContext.setProgress(pProgress);
        this.mContext.setStatus("");
    }

    @Override
    public void finish() {
        this.mContext.setProgress(100);
    }

    @Override
    public void showError(String pMessage) {
        this.mContext.showToastMessage(pMessage);
    }
}

