/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util.tree;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sf.sdedit.util.tree.Tree;

public class TreeAdapter<T>
implements TreeModel {
    private Tree<T> tree;
    private Map<T, Node> nodes;
    private Node root;
    private List<TreeModelListener> listeners;
    private WeakHashMap<Node, T[]> children;
    private DisplayMode displayMode;
    private Comparator<T> nodeComparator;

    public Tree<T> getTree() {
        return this.tree;
    }

    public void setNodeComparator(Comparator<T> comparator) {
        this.nodeComparator = comparator;
    }

    private Node getNode(T t) {
        if (t == null) {
            return this.root;
        }
        Node node = this.nodes.get(t);
        if (node == null) {
            node = new Node(t);
            this.nodes.put(t, node);
        }
        return node;
    }

    public TreePath getPathTo(T t) {
        LinkedList<T> path = new LinkedList<T>();
        while (t != null) {
            path.addFirst(t);
            t = this.tree.getParent(t);
        }
        path.addFirst(null);
        LinkedList<Node> treePath = new LinkedList<Node>();
        for (Object node : path) {
            treePath.add(this.getNode(node));
        }
        return new TreePath(treePath.toArray());
    }

    public T getObjectForPath(TreePath path) {
        Node node = (Node)path.getLastPathComponent();
        return node.t;
    }

    public TreeAdapter(Tree<T> tree) {
        this.tree = tree;
        this.nodes = new IdentityHashMap<T, Node>();
        this.root = new Node(null);
        this.listeners = new LinkedList<TreeModelListener>();
        this.children = new WeakHashMap();
        this.displayMode = DisplayMode.ALL_NODES;
    }

    public void setDisplayMode(DisplayMode newMode) {
        if (!newMode.equals((Object)this.displayMode)) {
            this.displayMode = newMode;
            this.invalidateAll();
            this.fireTreeStructureChanged();
        }
    }

    private TreeModelEvent translate(TreeModelEvent tme) {
        Object[] children = tme.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                children[i] = this.getNode(children[i]);
            }
        }
        return new TreeModelEvent(tme.getSource(), tme.getTreePath(), tme.getChildIndices(), children);
    }

    public void fireTreeNodesRemoved(TreeModelEvent tme) {
        for (TreeModelListener tml : this.listeners) {
            tml.treeNodesRemoved(this.translate(tme));
        }
    }

    public void fireTreeNodesInserted(TreeModelEvent tme) {
        for (TreeModelListener tml : this.listeners) {
            tml.treeNodesInserted(this.translate(tme));
        }
    }

    public void fireTreeNodesChanged(TreeModelEvent tme) {
        for (TreeModelListener tml : this.listeners) {
            tml.treeNodesChanged(this.translate(tme));
        }
    }

    public void fireTreeStructureChanged(TreeModelEvent tme) {
        for (TreeModelListener tml : this.listeners) {
            tml.treeStructureChanged(tme);
        }
    }

    public void fireTreeStructureChanged() {
        TreeModelEvent tme = new TreeModelEvent((Object)this, new Object[]{this.getRoot()});
        for (TreeModelListener tml : this.listeners) {
            tml.treeStructureChanged(tme);
        }
    }

    public void DESTROY() {
        this.nodes.clear();
        this.root = null;
        this.tree = null;
        this.listeners.clear();
        this.children.clear();
    }

    public void invalidateAll() {
        this.children.clear();
    }

    public void invalidate(T t) {
        this.children.remove(this.nodes.get(t));
    }

    private T[] _children(Node node) {
        T[] result = this.children.get(node);
        if (result == null) {
            result = this.tree.getChildren(node.t);
            if (this.nodeComparator != null) {
                Arrays.sort(result, this.nodeComparator);
            }
            this.children.put(node, result);
        }
        return result;
    }

    private T[] children(Node node, boolean ignoreDisplayMode) {
        Object[] children;
        if (ignoreDisplayMode || this.displayMode == DisplayMode.ALL_NODES) {
            return this._children(node);
        }
        LinkedList<T> cl = new LinkedList<T>();
        for (T child : children = this._children(node)) {
            Node c = this.getNode(child);
            if (this._children(c).length <= 0) continue;
            cl.add(child);
        }
        children = (Object[])Array.newInstance(children.getClass().getComponentType(), cl.size());
        return cl.toArray(children);
    }

    public T[] children(Node node) {
        return this.children(node, false);
    }

    @Override
    public void addTreeModelListener(TreeModelListener arg0) {
        this.listeners.add(arg0);
    }

    @Override
    public Object getChild(Object arg0, int arg1) {
        Node node = (Node)arg0;
        return this.getNode(this.children(node)[arg1]);
    }

    @Override
    public int getChildCount(Object arg0) {
        Node node = (Node)arg0;
        return this.children(node).length;
    }

    @Override
    public int getIndexOfChild(Object arg0, Object arg1) {
        int n = this.getChildCount(arg0);
        for (int i = 0; i < n; ++i) {
            if (arg1 != this.getChild(arg0, i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.root;
    }

    @Override
    public boolean isLeaf(Object arg0) {
        return this.children((Node)arg0, true).length == 0;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener arg0) {
        this.listeners.remove(arg0);
    }

    @Override
    public void valueForPathChanged(TreePath arg0, Object arg1) {
    }

    public class Node {
        T t;

        public Node(T t) {
            this.t = t;
        }

        public T getObject() {
            return this.t;
        }

        public String toString() {
            return this.t == null ? "null" : this.t.toString();
        }
    }

    public static enum DisplayMode {
        ALL_NODES,
        NO_LEAVES;

    }
}

