/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.console.r;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import org.graalvm.polyglot.Context;
import org.graalvm.visualvm.core.ui.components.ScrollableContainer;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.console.r.Bundle;
import org.graalvm.visualvm.heapviewer.console.r.MultiSplitContainer;
import org.graalvm.visualvm.heapviewer.console.r.REditorComponent;
import org.graalvm.visualvm.heapviewer.console.r.RPlotPanel;
import org.graalvm.visualvm.heapviewer.console.r.RQueries;
import org.graalvm.visualvm.heapviewer.console.r.engine.REngine;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.InstanceNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.ui.HTMLView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.utils.HeapUtils;
import org.graalvm.visualvm.lib.jfluid.ProfilerLogger;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.JExtendedSplitPane;
import org.graalvm.visualvm.lib.ui.components.ProfilerToolbar;
import org.graalvm.visualvm.lib.ui.swing.ActionPopupButton;
import org.graalvm.visualvm.lib.ui.swing.GrayLabel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

class RConsoleView
extends HeapViewerFeature {
    private static final Color SEPARATOR_COLOR = UIManager.getColor("Separator.foreground");
    private static final Logger LOGGER = Logger.getLogger(RConsoleView.class.getName());
    private static final Icon ICON_EDIT = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)(RQueries.class.getPackage().getName().replace('.', '/') + "/rules.png"), (boolean)true));
    private final HeapContext context;
    private ProfilerToolbar toolbar;
    private ProfilerToolbar graphsToolbar;
    private ProfilerToolbar progressToolbar;
    private JComponent component;
    private Action runAction;
    private Action cancelAction;
    private Action loadAction;
    private Action saveAction;
    private Action editAction;
    private JLabel progressLabel;
    private JProgressBar progressBar;
    private REngine engine;
    private REditorComponent editor;
    private JPanel resultsContainer;
    private final HTMLView htmlView;
    private JPanel graphsContainer;
    private RPlotPanel graphsPanel;
    private JToggleButton rResults;
    private JToggleButton rGraphs;
    private final AtomicBoolean analysisRunning = new AtomicBoolean(false);
    private final ExecutorService progressUpdater = Executors.newSingleThreadExecutor();
    private boolean queryValid;
    private Set<HeapViewerNode> nodeResults;
    private RQueries.Query currentQuery;

    RConsoleView(HeapContext context, HeapViewerActions actions) {
        super("java_objects_rconsole", Bundle.RConsoleView_Name(), Bundle.RConsoleView_Description(), (Icon)RConsoleView.createIcon(), 1100);
        this.context = context;
        final Heap heap = context.getFragment().getHeap();
        String htmlS = "<initializing R engine...>".replace("<", "&lt;").replace(">", "&gt;");
        this.htmlView = new HTMLView("java_objects_rconsole", context, actions, "<p>&nbsp;&nbsp;" + htmlS + "</p>"){

            protected String computeData(HeapContext context, String viewID) {
                if (REngine.isSupported()) {
                    try {
                        RConsoleView.this.engine = new REngine(heap);
                    }
                    catch (Exception e) {
                        ProfilerLogger.log((Exception)e);
                    }
                }
                RConsoleView.this.updateUIState();
                if (RConsoleView.this.engine != null) {
                    String htmlS = Bundle.RConsoleView_NothingExecuted().replace("<", "&lt;").replace(">", "&gt;");
                    return "<p>&nbsp;&nbsp;" + htmlS + "</p>";
                }
                String htmlS = "<R engine not available>".replace("<", "&lt;").replace(">", "&gt;");
                return "<p>&nbsp;&nbsp;" + htmlS + "</p>";
            }

            protected HeapViewerNode nodeForURL(URL url, HeapContext context) {
                return RConsoleView.getNode(url, context);
            }
        };
    }

    public JComponent getComponent() {
        if (this.component == null) {
            this.init();
        }
        return this.component;
    }

    public ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.init();
        }
        return this.toolbar;
    }

    protected void willBeClosed(Runnable viewSelector) {
        if (this.editor != null && this.editor.isChanged() && !this.editor.getScript().isEmpty() && this.saveAction.isEnabled()) {
            viewSelector.run();
            Container c = this.editor;
            while (c != null) {
                Container p = c.getParent();
                if (p instanceof JTabbedPane) {
                    ((JTabbedPane)p).setSelectedComponent(c);
                } else if (p instanceof TopComponent) {
                    ((TopComponent)p).requestActive();
                    break;
                }
                c = p;
            }
            JButton saveButton = new JButton(this.saveAction){

                @Override
                public void addActionListener(ActionListener l) {
                    if (l == RConsoleView.this.saveAction) {
                        super.addActionListener(l);
                    }
                }

                @Override
                public void removeActionListener(ActionListener l) {
                    if (l == RConsoleView.this.saveAction) {
                        super.removeActionListener(l);
                    }
                }
            };
            JButton closeButton = new JButton(Bundle.RConsoleView_NoSaveOnCloseBtn());
            DialogDescriptor dd = new DialogDescriptor((Object)Bundle.RConsoleView_SaveOnClosingMsg(), Bundle.RConsoleView_SaveOnClosingCaption(), true, new Object[]{saveButton, closeButton}, (Object)saveButton, 0, null, null);
            dd.setMessageType(3);
            final Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            this.saveAction.putValue("NOTIFIER", new Runnable(){

                @Override
                public void run() {
                    RConsoleView.this.saveAction.putValue("NOTIFIER", null);
                    d.setVisible(false);
                }
            });
            d.setVisible(true);
        }
    }

    private void executeQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RConsoleView.this.nodeResults == null) {
                    RConsoleView.this.nodeResults = new HashSet();
                } else {
                    RConsoleView.this.nodeResults.clear();
                }
                RConsoleView.this.executeQueryImpl(RConsoleView.this.editor.getScript());
            }
        });
    }

    private void cancelQuery() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    RConsoleView.this.engine.cancelQuery();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                RConsoleView.this.finalizeQuery(null);
            }
        });
    }

    public void queryStarted(final BoundedRangeModel model) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RConsoleView.this.updateUIState();
                RConsoleView.this.graphsToolbar.getComponent().setVisible(false);
                RConsoleView.this.progressToolbar.getComponent().setVisible(true);
                RConsoleView.this.progressBar.setModel(model);
            }
        });
    }

    public void queryFinished(final String result) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                RConsoleView.this.updateUIState();
                RConsoleView.this.progressToolbar.getComponent().setVisible(false);
                RConsoleView.this.graphsToolbar.getComponent().setVisible(RConsoleView.this.rGraphs.isSelected());
                RConsoleView.this.progressBar.setModel(new DefaultBoundedRangeModel(0, 0, 0, 0));
                if (result != null) {
                    RConsoleView.this.htmlView.setText(result);
                }
            }
        });
    }

    private void finalizeQuery(String result) {
        this.analysisRunning.compareAndSet(true, false);
        this.queryFinished(result);
    }

    private void updateUIState() {
        int scriptLength = this.editor.getScript().trim().length();
        if (this.analysisRunning.get()) {
            this.runAction.setEnabled(false);
            this.cancelAction.setEnabled(true);
            this.loadAction.setEnabled(false);
            this.editor.setEditable(false);
        } else {
            this.runAction.setEnabled(this.engine != null && scriptLength > 0 && this.queryValid);
            this.cancelAction.setEnabled(false);
            this.loadAction.setEnabled(true);
            this.editor.setEditable(true);
        }
    }

    private void executeQueryImpl(final String rQuery) {
        Color b = this.graphsPanel.getBackground();
        final String rgb = "rgb(" + b.getRed() + ", " + b.getGreen() + ", " + b.getBlue() + ", maxColorValue = 255)";
        final DefaultBoundedRangeModel progressModel = new DefaultBoundedRangeModel(0, 10, 0, 100);
        new RequestProcessor("R Query Processor").post(new Runnable(){

            @Override
            public void run() {
                final AtomicInteger counter = new AtomicInteger(100);
                progressModel.setMaximum(100);
                final StringBuilder sb = new StringBuilder();
                final boolean[] oddRow = new boolean[1];
                Color oddRowBackground = UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground());
                final String oddRowBackgroundString = "rgb(" + oddRowBackground.getRed() + "," + oddRowBackground.getGreen() + "," + oddRowBackground.getBlue() + ")";
                sb.append("<table border='0' width='100%'>");
                try {
                    RConsoleView.this.analysisRunning.compareAndSet(false, true);
                    RConsoleView.this.queryStarted(progressModel);
                    RConsoleView.this.progressUpdater.submit(new ProgressUpdater(progressModel));
                    Context rContext = RConsoleView.this.engine.getContext();
                    Image rImage = RConsoleView.this.graphsPanel.createPlotImage();
                    Graphics rGraphics = rImage.getGraphics();
                    int rImageW = rImage.getWidth(RConsoleView.this.graphsPanel);
                    int rImageH = rImage.getHeight(RConsoleView.this.graphsPanel);
                    Boolean renderingQuality = RConsoleView.this.graphsPanel.getRenderingQuality();
                    if (renderingQuality != null && rGraphics instanceof Graphics2D) {
                        Graphics2D g2 = (Graphics2D)rGraphics;
                        Object antialiasing = renderingQuality != false ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF;
                        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasing);
                        Object text_antialiasing = renderingQuality != false ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF;
                        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, text_antialiasing);
                    }
                    rContext.eval("R", (CharSequence)"function(g, w, h) { grDevices:::awt(w, h, g); }").execute(new Object[]{rGraphics, rImageW, rImageH});
                    rContext.eval("R", (CharSequence)("library(grid); grid.rect(width = 1, height = 1, gp = gpar(col = " + rgb + ", fill = " + rgb + "));"));
                    RConsoleView.this.engine.executeQuery(rQuery, new REngine.ObjectVisitor(){

                        @Override
                        public boolean visit(Object o) {
                            sb.append(oddRow[0] ? "<tr><td style='background-color: " + oddRowBackgroundString + ";'>" : "<tr><td>");
                            oddRow[0] = !oddRow[0];
                            RConsoleView.this.dump(o, sb);
                            sb.append("</td></tr>");
                            return counter.decrementAndGet() == 0 || !RConsoleView.this.analysisRunning.get() && !RConsoleView.this.engine.isCancelled();
                        }
                    });
                    rContext.eval("R", (CharSequence)"dev.off();");
                    rGraphics.dispose();
                    RConsoleView.this.graphsPanel.repaint();
                    if (counter.get() == 0) {
                        sb.append("<tr><td>");
                        sb.append("&lt;too many results&gt");
                        sb.append("</td></tr>");
                    } else if (counter.get() == 100) {
                        sb.append("<tr><td>");
                        sb.append("&lt;no results&gt");
                        sb.append("</td></tr>");
                    }
                    sb.append("</table>");
                    RConsoleView.this.finalizeQuery(sb.toString());
                }
                catch (Exception oQLException) {
                    LOGGER.log(Level.INFO, "Error executing R", oQLException);
                    StringBuilder errorMessage = new StringBuilder();
                    String exceptionMsg = oQLException.getLocalizedMessage();
                    errorMessage.append("<h2>").append("Query error").append("</h2>");
                    errorMessage.append("Bad R query");
                    errorMessage.append("<hr>");
                    if (exceptionMsg != null) {
                        errorMessage.append(exceptionMsg.replace("\n", "<br>").replace("\r", "<br>"));
                    }
                    RConsoleView.this.finalizeQuery(errorMessage.toString());
                }
            }
        });
    }

    private void dump(Object o, StringBuilder sb) {
        String text = o.toString();
        text = text.replace(" ", "&nbsp;");
        sb.append("<code>").append(text).append("</code>\n");
    }

    private void init() {
        this.toolbar = ProfilerToolbar.create((boolean)false);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel(Bundle.RConsoleView_RQuery()));
        this.toolbar.addSpace(2);
        this.runAction = new AbstractAction(Bundle.RConsoleView_RunAction(), Icons.getIcon((String)"GeneralIcons.Start")){
            {
                this.putValue("ShortDescription", Bundle.RConsoleView_RunActionTooltip());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RConsoleView.this.executeQuery();
            }
        };
        JButton runButton = new JButton(this.runAction){

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.width += 6;
                return d;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        runButton.putClientProperty("JComponent.sizeVariant", "regular");
        this.cancelAction = new AbstractAction(Bundle.RConsoleView_CancelAction(), Icons.getIcon((String)"GeneralIcons.Stop")){
            {
                this.putValue("ShortDescription", Bundle.RConsoleView_CancelActionTooltip());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                RConsoleView.this.cancelQuery();
            }
        };
        JButton cancelButton = new JButton(this.cancelAction);
        cancelButton.setHideActionText(true);
        this.loadAction = new AbstractAction(Bundle.RConsoleView_LoadAction(), RQueries.ICON_LOAD){
            {
                this.putValue("ShortDescription", Bundle.RConsoleView_LoadActionTooltip());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JComponent) {
                    JPopupMenu p = new JPopupMenu();
                    RQueries.instance().populateLoadQuery(p, RConsoleView.this.currentQuery, new RQueries.Handler(){

                        @Override
                        protected void querySelected(RQueries.Query query) {
                            RConsoleView.this.currentQuery = query;
                            if (RConsoleView.this.editor != null) {
                                RConsoleView.this.editor.setScript(RConsoleView.this.currentQuery.getScript());
                            }
                        }
                    });
                    JComponent c = (JComponent)e.getSource();
                    if (p.getComponentCount() > 0) {
                        if (c.getClientProperty("POPUP_LEFT") != null) {
                            p.show(c, c.getWidth() + 1, 0);
                        } else {
                            p.show(c, 0, c.getHeight() + 1);
                        }
                    }
                }
            }
        };
        JButton loadButton = new JButton(this.loadAction);
        loadButton.setHideActionText(true);
        this.saveAction = new AbstractAction(Bundle.RConsoleView_SaveAction(), RQueries.ICON_SAVE){
            {
                this.putValue("ShortDescription", Bundle.RConsoleView_SaveActionTooltip());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JComponent) {
                    JPopupMenu p = new JPopupMenu();
                    RQueries.instance().populateSaveQuery(p, RConsoleView.this.currentQuery, RConsoleView.this.editor.getScript(), new RQueries.Handler(){

                        @Override
                        protected void querySelected(RQueries.Query query) {
                            RConsoleView.this.currentQuery = query;
                            RConsoleView.this.editor.clearChanged();
                            Object notifier = RConsoleView.this.saveAction.getValue("NOTIFIER");
                            if (notifier instanceof Runnable) {
                                ((Runnable)notifier).run();
                            }
                        }
                    });
                    JComponent c = (JComponent)e.getSource();
                    if (p.getComponentCount() > 0) {
                        if (c.getClientProperty("POPUP_LEFT") != null) {
                            p.show(c, c.getWidth() + 1, 0);
                        } else {
                            p.show(c, 0, c.getHeight() + 1);
                        }
                    }
                }
            }
        };
        JButton saveButton = new JButton(this.saveAction);
        saveButton.setHideActionText(true);
        this.editAction = new AbstractAction(Bundle.RConsoleView_EditAction(), ICON_EDIT){
            {
                this.putValue("ShortDescription", Bundle.RConsoleView_EditActionTooltip());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() instanceof JComponent) {
                    JPopupMenu p = new JPopupMenu();
                    RQueries.instance().populateEditQuery(p, RConsoleView.this.currentQuery);
                    JComponent c = (JComponent)e.getSource();
                    if (p.getComponentCount() > 0) {
                        if (c.getClientProperty("POPUP_LEFT") != null) {
                            p.show(c, c.getWidth() + 1, 0);
                        } else {
                            p.show(c, 0, c.getHeight() + 1);
                        }
                    }
                }
            }
        };
        JButton editButton = new JButton(this.editAction);
        editButton.setHideActionText(true);
        this.graphsPanel = new RPlotPanel();
        this.graphsToolbar = ProfilerToolbar.create((boolean)false);
        this.graphsToolbar.addSpace(2);
        this.graphsToolbar.addSeparator();
        this.graphsToolbar.addSpace(5);
        this.graphsToolbar.add((Component)new GrayLabel("Rendering Quality:"));
        this.graphsToolbar.addSpace(2);
        AbstractAction defaultA = new AbstractAction("Default"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RConsoleView.this.graphsPanel.setRenderingQuality(null);
            }
        };
        AbstractAction highA = new AbstractAction("High"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RConsoleView.this.graphsPanel.setRenderingQuality(Boolean.TRUE);
            }
        };
        AbstractAction lowA = new AbstractAction("Low"){

            @Override
            public void actionPerformed(ActionEvent e) {
                RConsoleView.this.graphsPanel.setRenderingQuality(Boolean.FALSE);
            }
        };
        this.graphsToolbar.add((Component)new ActionPopupButton(new Action[]{defaultA, highA, lowA}));
        this.progressToolbar = ProfilerToolbar.create((boolean)false);
        this.progressToolbar.getComponent().setVisible(false);
        this.progressToolbar.addSpace(2);
        this.progressToolbar.addSeparator();
        this.progressToolbar.addSpace(5);
        this.progressLabel = new GrayLabel(Bundle.RConsoleView_ExecutingProgress());
        this.progressToolbar.add((Component)this.progressLabel);
        this.progressToolbar.addSpace(8);
        this.progressBar = new JProgressBar(0){

            @Override
            public Dimension getPreferredSize() {
                Dimension dim = super.getMinimumSize();
                dim.width = 120;
                return dim;
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.progressToolbar.add((Component)this.progressBar);
        this.toolbar.add((Component)runButton);
        this.toolbar.add((Component)cancelButton);
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)loadButton);
        this.toolbar.add((Component)saveButton);
        this.toolbar.add((Component)editButton);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.toolbar.add((Component)new GrayLabel("Results:"));
        this.toolbar.addSpace(3);
        String rResultsPath = RConsoleView.class.getPackage().getName().replace('.', '/') + "/properties.png";
        Image rResultsImage = ImageUtilities.loadImage((String)rResultsPath, (boolean)true);
        this.rResults = new JToggleButton((Icon)new ImageIcon(rResultsImage), true){

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                if (RConsoleView.this.resultsContainer != null) {
                    RConsoleView.this.resultsContainer.setVisible(this.isSelected());
                }
            }
        };
        this.rResults.putClientProperty("JButton.buttonType", "segmented");
        this.rResults.putClientProperty("JButton.segmentPosition", "first");
        this.rResults.setToolTipText("Text");
        this.toolbar.add((Component)this.rResults);
        String rGraphsPath = RConsoleView.class.getPackage().getName().replace('.', '/') + "/showGraphs.png";
        Image rGraphsImage = ImageUtilities.loadImage((String)rGraphsPath, (boolean)true);
        this.rGraphs = new JToggleButton((Icon)new ImageIcon(rGraphsImage), true){

            @Override
            protected void fireItemStateChanged(ItemEvent e) {
                if (RConsoleView.this.graphsContainer != null) {
                    boolean selected = this.isSelected();
                    RConsoleView.this.graphsToolbar.getComponent().setVisible(selected && !RConsoleView.this.progressToolbar.getComponent().isVisible());
                    RConsoleView.this.graphsContainer.setVisible(selected);
                }
            }
        };
        this.rGraphs.putClientProperty("JButton.buttonType", "segmented");
        this.rGraphs.putClientProperty("JButton.segmentPosition", "last");
        this.rGraphs.setToolTipText("Graphs");
        this.toolbar.add((Component)this.rGraphs);
        this.toolbar.add(this.graphsToolbar);
        this.toolbar.add(this.progressToolbar);
        this.editor = new REditorComponent(){

            @Override
            protected void validityChanged(boolean valid) {
                RConsoleView.this.queryValid = valid;
                RConsoleView.this.updateUIState();
            }
        };
        this.resultsContainer = new JPanel(new CardLayout());
        this.resultsContainer.add(new ResultsView(this.htmlView.getComponent()));
        this.graphsContainer = new JPanel(new BorderLayout());
        this.graphsContainer.add((Component)this.graphsPanel, "Center");
        MultiSplitContainer resultsSplit = new MultiSplitContainer();
        resultsSplit.add(this.resultsContainer);
        resultsSplit.add(this.graphsContainer);
        JExtendedSplitPane masterSplit = new JExtendedSplitPane(0, true, (Component)resultsSplit, (Component)new EditorView(this.editor));
        BasicSplitPaneDivider masterDivider = ((BasicSplitPaneUI)masterSplit.getUI()).getDivider();
        masterDivider.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, SEPARATOR_COLOR));
        masterDivider.setDividerSize(6);
        masterSplit.setBorder(BorderFactory.createEmptyBorder());
        masterSplit.setResizeWeight(0.7);
        this.component = new JPanel(new BorderLayout());
        this.component.add((Component)masterSplit, "Center");
        this.updateUIState();
    }

    private static HeapViewerNode getNode(URL url, HeapContext context) {
        String urls = url.toString();
        if (HeapUtils.isInstance((String)urls)) {
            Instance instance = HeapUtils.instanceFromHtml((String)urls, (Heap)context.getFragment().getHeap());
            if (instance != null) {
                return new InstanceNode(instance);
            }
            ProfilerDialogs.displayError((String)Bundle.RConsoleView_CannotResolveInstanceMsg());
        } else if (HeapUtils.isClass((String)urls)) {
            JavaClass javaClass = HeapUtils.classFromHtml((String)urls, (Heap)context.getFragment().getHeap());
            if (javaClass != null) {
                return new ClassNode(javaClass);
            }
            ProfilerDialogs.displayError((String)Bundle.RConsoleView_CannotResolveClassMsg());
        }
        return null;
    }

    private static ImageIcon createIcon() {
        String consolePath = RConsoleView.class.getPackage().getName().replace('.', '/') + "/rConsole.png";
        Image consoleImage = ImageUtilities.loadImage((String)consolePath, (boolean)true);
        String badgePath = RConsoleView.class.getPackage().getName().replace('.', '/') + "/rBadge.png";
        Image badgeImage = ImageUtilities.loadImage((String)badgePath, (boolean)true);
        return new ImageIcon(ImageUtilities.mergeImages((Image)consoleImage, (Image)badgeImage, (int)0, (int)0));
    }

    private static class ResultsView
    extends JPanel {
        ResultsView(JComponent results) {
            super(new BorderLayout());
            this.add((Component)new ScrollableContainer(results), "Center");
        }
    }

    private class EditorView
    extends JPanel {
        EditorView(REditorComponent editor) {
            super(new BorderLayout());
            editor.clearScrollBorders();
            this.add((Component)editor, "Center");
            JToolBar controls = new JToolBar(1);
            controls.setFloatable(false);
            controls.setBorderPainted(false);
            controls.add(RConsoleView.this.runAction);
            controls.add(RConsoleView.this.cancelAction);
            controls.addSeparator();
            controls.add(RConsoleView.this.loadAction).putClientProperty("POPUP_LEFT", Boolean.TRUE);
            controls.add(RConsoleView.this.saveAction).putClientProperty("POPUP_LEFT", Boolean.TRUE);
            controls.add(RConsoleView.this.editAction).putClientProperty("POPUP_LEFT", Boolean.TRUE);
            JPanel controlsContainer = new JPanel(new BorderLayout());
            controlsContainer.setOpaque(false);
            controlsContainer.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getColor("Separator.foreground")), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
            controlsContainer.add((Component)controls, "Center");
            this.add((Component)controlsContainer, "West");
            int h = controls.getComponent((int)0).getPreferredSize().height;
            this.setMinimumSize(new Dimension(0, h += controls.getComponent((int)1).getPreferredSize().height + 2));
        }
    }

    private class ProgressUpdater
    implements Runnable {
        private final BoundedRangeModel progressModel;

        ProgressUpdater(BoundedRangeModel model) {
            this.progressModel = model;
        }

        @Override
        public void run() {
            while (RConsoleView.this.analysisRunning.get()) {
                int val = this.progressModel.getValue() + 10;
                if (val > this.progressModel.getMaximum()) {
                    val = this.progressModel.getMinimum();
                }
                final int newVal = val;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressUpdater.this.progressModel.setValue(newVal);
                    }
                });
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

