/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.ContainerDescriptor;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginError;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.XmlReader;
import com.intellij.openapi.components.ComponentConfig;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class IdeaPluginDescriptorImpl
implements IdeaPluginDescriptor {
    public static final IdeaPluginDescriptorImpl[] EMPTY_ARRAY = new IdeaPluginDescriptorImpl[0];
    final Path path;
    final Path basePath;
    private final boolean myBundled;
    String myName;
    PluginId myId;
    @Nullable
    private String myProductCode;
    @Nullable
    private Date myReleaseDate;
    private int myReleaseVersion;
    private boolean myIsLicenseOptional;
    private String myResourceBundleBaseName;
    private String myChangeNotes;
    private String myVersion;
    private String myVendor;
    private String myVendorEmail;
    private String myVendorUrl;
    private String myCategory;
    String myUrl;
    @Nullable
    List<PluginDependency> pluginDependencies;
    @Nullable
    List<PluginId> incompatibilities;
    transient List<Path> jarFiles;
    @Nullable
    private List<Element> myActionElements;
    @Nullable
    private LinkedHashMap<String, List<Element>> epNameToExtensionElements;
    final ContainerDescriptor appContainerDescriptor;
    final ContainerDescriptor projectContainerDescriptor;
    final ContainerDescriptor moduleContainerDescriptor;
    private List<PluginId> myModules;
    private ClassLoader myLoader;
    private String myDescriptionChildText;
    boolean myUseIdeaClassLoader;
    boolean myAllowBundledUpdate;
    boolean myImplementationDetail;
    boolean myRequireRestart;
    private String mySinceBuild;
    private String myUntilBuild;
    private boolean myEnabled;
    private boolean isExtensionsCleared;
    boolean incomplete;
    public static final Pattern EXPLICIT_BIG_NUMBER_PATTERN = Pattern.compile("(.*)\\.(9{4,}+|10{4,}+)");

    public IdeaPluginDescriptorImpl(@NotNull Path path2, @NotNull Path basePath, boolean bundled) {
        if (path2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(0);
        }
        if (basePath == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(1);
        }
        this.appContainerDescriptor = new ContainerDescriptor();
        this.projectContainerDescriptor = new ContainerDescriptor();
        this.moduleContainerDescriptor = new ContainerDescriptor();
        this.myEnabled = true;
        this.path = path2;
        this.basePath = basePath;
        this.myBundled = bundled;
    }

    @NotNull
    public Path getPluginPath() {
        Path path2 = this.path;
        if (path2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(7);
        }
        return path2;
    }

    boolean readExternal(@NotNull Element element, @NotNull PathBasedJdomXIncluder.PathResolver<?> pathResolver, @NotNull DescriptorListLoadingContext context2, @NotNull IdeaPluginDescriptorImpl mainDescriptor) {
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(8);
        }
        if (pathResolver == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(9);
        }
        if (context2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(10);
        }
        if (mainDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(11);
        }
        if (JDOMUtil.isEmpty(element)) {
            this.markAsIncomplete(context2, "Empty plugin descriptor", null);
            return false;
        }
        XmlReader.readIdAndName(this, element);
        PathBasedJdomXIncluder.resolveNonXIncludeElement(element, this.basePath, context2, pathResolver);
        if (this.myId != null && context2.isPluginDisabled(this.myId)) {
            this.markAsIncomplete(context2, null, null);
        } else if (this.myId == null || this.myName == null) {
            XmlReader.readIdAndName(this, element);
            if (this.myId != null && context2.isPluginDisabled(this.myId)) {
                this.markAsIncomplete(context2, null, null);
            }
        }
        if (this.incomplete) {
            this.myDescriptionChildText = element.getChildTextTrim("description");
            this.myCategory = element.getChildTextTrim("category");
            this.myVersion = element.getChildTextTrim("version");
            if (DescriptorListLoadingContext.LOG.isDebugEnabled()) {
                DescriptorListLoadingContext.LOG.debug("Skipping reading of " + this.myId + " from " + this.basePath + " (reason: disabled)");
            }
            List<Element> dependsElements = element.getChildren("depends");
            for (Element dependsElement : dependsElements) {
                this.readPluginDependency(this.basePath, context2, dependsElement);
            }
            Element productElement = element.getChild("product-descriptor");
            if (productElement != null) {
                this.readProduct(context2, productElement);
            }
            List<Element> moduleElements = element.getChildren("module");
            for (Element moduleElement : moduleElements) {
                this.readModule(moduleElement);
            }
            return false;
        }
        XmlReader.readMetaInfo(this, element);
        this.pluginDependencies = null;
        if (this.doRead(element, context2, mainDescriptor)) {
            return false;
        }
        if (this.myVersion == null) {
            this.myVersion = context2.getDefaultVersion();
        }
        if (this.pluginDependencies != null) {
            XmlReader.readDependencies(mainDescriptor, this, context2, pathResolver, this.pluginDependencies);
        }
        return true;
    }

    private boolean doRead(@NotNull Element element, @NotNull DescriptorListLoadingContext context2, @NotNull IdeaPluginDescriptorImpl mainDescriptor) {
        if (element == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(13);
        }
        if (context2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(14);
        }
        if (mainDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(15);
        }
        for (Content content : element.getContent()) {
            if (!(content instanceof Element)) continue;
            boolean clearContent = true;
            Element child = (Element)content;
            switch (child.getName()) {
                case "extensions": {
                    this.epNameToExtensionElements = XmlReader.readExtensions(this, this.epNameToExtensionElements, context2, child);
                    break;
                }
                case "extensionPoints": {
                    XmlReader.readExtensionPoints(mainDescriptor, this, child);
                    break;
                }
                case "actions": {
                    if (this.myActionElements == null) {
                        this.myActionElements = new ArrayList<Element>(child.getChildren());
                    } else {
                        this.myActionElements.addAll(child.getChildren());
                    }
                    clearContent = child.getAttributeValue("resource-bundle") == null;
                    break;
                }
                case "module": {
                    this.readModule(child);
                    break;
                }
                case "application-components": {
                    IdeaPluginDescriptorImpl.readComponents(child, this.appContainerDescriptor);
                    break;
                }
                case "project-components": {
                    IdeaPluginDescriptorImpl.readComponents(child, this.projectContainerDescriptor);
                    break;
                }
                case "module-components": {
                    IdeaPluginDescriptorImpl.readComponents(child, this.moduleContainerDescriptor);
                    break;
                }
                case "applicationListeners": {
                    XmlReader.readListeners(child, this.appContainerDescriptor, mainDescriptor);
                    break;
                }
                case "projectListeners": {
                    XmlReader.readListeners(child, this.projectContainerDescriptor, mainDescriptor);
                    break;
                }
                case "depends": {
                    if (this.readPluginDependency(this.basePath, context2, child)) break;
                    return true;
                }
                case "incompatible-with": {
                    this.readPluginIncompatibility(child);
                    break;
                }
                case "category": {
                    this.myCategory = StringUtil.nullize(child.getTextTrim());
                    break;
                }
                case "change-notes": {
                    this.myChangeNotes = StringUtil.nullize(child.getTextTrim());
                    break;
                }
                case "version": {
                    this.myVersion = StringUtil.nullize(child.getTextTrim());
                    break;
                }
                case "description": {
                    this.myDescriptionChildText = StringUtil.nullize(child.getTextTrim());
                    break;
                }
                case "resource-bundle": {
                    String value2 = StringUtil.nullize(child.getTextTrim());
                    if (this.myResourceBundleBaseName != null && !Objects.equals(this.myResourceBundleBaseName, value2)) {
                        DescriptorListLoadingContext.LOG.warn("Resource bundle redefinition for plugin '" + mainDescriptor.getPluginId() + "'. Old value: " + this.myResourceBundleBaseName + ", new value: " + value2);
                    }
                    this.myResourceBundleBaseName = value2;
                    break;
                }
                case "product-descriptor": {
                    this.readProduct(context2, child);
                    break;
                }
                case "vendor": {
                    this.myVendor = StringUtil.nullize(child.getTextTrim());
                    this.myVendorEmail = StringUtil.nullize(child.getAttributeValue("email"));
                    this.myVendorUrl = StringUtil.nullize(child.getAttributeValue("url"));
                    break;
                }
                case "idea-version": {
                    this.mySinceBuild = StringUtil.nullize(child.getAttributeValue("since-build"));
                    this.myUntilBuild = StringUtil.nullize(child.getAttributeValue("until-build"));
                    if (this.checkCompatibility(context2)) break;
                    return true;
                }
            }
            if (!clearContent) continue;
            child.getContent().clear();
        }
        return false;
    }

    private void readModule(Element child) {
        String moduleName = child.getAttributeValue("value");
        if (moduleName != null) {
            if (this.myModules == null) {
                this.myModules = Collections.singletonList(PluginId.getId(moduleName));
            } else {
                if (this.myModules.size() == 1) {
                    List<PluginId> singleton = this.myModules;
                    this.myModules = new ArrayList<PluginId>(4);
                    this.myModules.addAll(singleton);
                }
                this.myModules.add(PluginId.getId(moduleName));
            }
        }
    }

    private void readProduct(@NotNull DescriptorListLoadingContext context2, @NotNull Element child) {
        if (context2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(16);
        }
        if (child == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(17);
        }
        this.myProductCode = StringUtil.nullize(child.getAttributeValue("code"));
        this.myReleaseDate = this.parseReleaseDate(child.getAttributeValue("release-date"), context2);
        this.myReleaseVersion = StringUtil.parseInt(child.getAttributeValue("release-version"), 0);
        this.myIsLicenseOptional = Boolean.parseBoolean(child.getAttributeValue("optional", "false"));
    }

    private void readPluginIncompatibility(@NotNull Element child) {
        String pluginId;
        if (child == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(18);
        }
        if ((pluginId = child.getTextTrim()).isEmpty()) {
            return;
        }
        if (this.incompatibilities == null) {
            this.incompatibilities = new ArrayList<PluginId>();
        }
        this.incompatibilities.add(PluginId.getId(pluginId));
    }

    private boolean readPluginDependency(@NotNull Path basePath, @NotNull DescriptorListLoadingContext context2, @NotNull Element child) {
        String dependencyIdString;
        if (basePath == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(19);
        }
        if (context2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(20);
        }
        if (child == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(21);
        }
        if ((dependencyIdString = child.getTextTrim()).isEmpty()) {
            return true;
        }
        PluginId dependencyId = PluginId.getId(dependencyIdString);
        boolean isOptional = Boolean.parseBoolean(child.getAttributeValue("optional"));
        boolean isDisabledOrBroken = false;
        if (context2.isPluginDisabled(dependencyId)) {
            if (!isOptional) {
                this.markAsIncomplete(context2, "Non-optional dependency plugin " + dependencyId + " is disabled", dependencyId);
            }
            isDisabledOrBroken = true;
        } else if (context2.result.isBroken(dependencyId)) {
            if (!isOptional) {
                DescriptorListLoadingContext.LOG.info("Skipping reading of " + this.myId + " from " + basePath + " (reason: non-optional dependency " + dependencyId + " is broken)");
                this.markAsIncomplete(context2, "Non-optional dependency " + dependencyId + " is broken", null);
                return false;
            }
            isDisabledOrBroken = true;
        }
        PluginDependency dependency = new PluginDependency(dependencyId, StringUtil.nullize(child.getAttributeValue("config-file")), isDisabledOrBroken);
        dependency.isOptional = isOptional;
        if (this.pluginDependencies == null) {
            this.pluginDependencies = new ArrayList<PluginDependency>();
        } else {
            for (PluginDependency item : this.pluginDependencies) {
                if (item.id != dependencyId) continue;
                if (item.isOptional) {
                    if (isOptional) continue;
                    item.isOptional = false;
                    continue;
                }
                dependency.isOptional = false;
                if (item.configFile != null) continue;
                item.configFile = dependency.configFile;
                return true;
            }
        }
        this.pluginDependencies.add(dependency);
        return true;
    }

    private boolean checkCompatibility(@NotNull DescriptorListLoadingContext context2) {
        if (context2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(22);
        }
        String since = this.mySinceBuild;
        String until = this.myUntilBuild;
        if (this.isBundled() || since == null && until == null) {
            return true;
        }
        String message2 = PluginManagerCore.getIncompatibleMessage(context2.result.productBuildNumber.get(), since, until);
        if (message2 == null) {
            return true;
        }
        this.markAsIncomplete(context2, null, null);
        context2.result.reportIncompatiblePlugin(this, message2, since, until);
        return false;
    }

    @NotNull
    String formatErrorMessage(@NotNull String message2) {
        if (message2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(23);
        }
        String path2 = this.path.toString();
        StringBuilder builder2 = new StringBuilder();
        builder2.append("The ").append(this.myName).append(" (id=").append(this.myId).append(", path=");
        builder2.append(FileUtil.getLocationRelativeToUserHome(path2, false));
        if (this.myVersion != null && !this.isBundled() && !this.myVersion.equals(PluginManagerCore.getBuildNumber().asString())) {
            builder2.append(", version=").append(this.myVersion);
        }
        builder2.append(") plugin ").append(message2);
        String string2 = builder2.toString();
        if (string2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(24);
        }
        return string2;
    }

    private void markAsIncomplete(@NotNull DescriptorListLoadingContext context2, @Nullable String errorMessage2, @Nullable PluginId disabledDependency) {
        if (context2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(25);
        }
        boolean wasIncomplete = this.incomplete;
        this.incomplete = true;
        this.setEnabled(false);
        if (this.myId != null && !wasIncomplete) {
            PluginError pluginError;
            PluginError pluginError2 = pluginError = errorMessage2 == null ? null : new PluginError(this, errorMessage2, null, false);
            if (pluginError != null && disabledDependency != null) {
                pluginError.setDisabledDependency(disabledDependency);
            }
            context2.result.addIncompletePlugin(this, pluginError);
        }
    }

    private static void readComponents(@NotNull Element parent2, @NotNull ContainerDescriptor containerDescriptor) {
        List<Content> content;
        int contentSize;
        if (parent2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(26);
        }
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(27);
        }
        if ((contentSize = (content = parent2.getContent()).size()) == 0) {
            return;
        }
        List<ComponentConfig> result2 = containerDescriptor.getComponentListToAdd(contentSize);
        for (Content child : content) {
            Element componentElement;
            if (!(child instanceof Element) || !(componentElement = (Element)child).getName().equals("component")) continue;
            ComponentConfig componentConfig = new ComponentConfig();
            Map<String, String> options = null;
            for (Element elementChild : componentElement.getChildren()) {
                switch (elementChild.getName()) {
                    case "skipForDefaultProject": {
                        if (IdeaPluginDescriptorImpl.readBoolValue(elementChild.getTextTrim())) break;
                        componentConfig.setLoadForDefaultProject(true);
                        break;
                    }
                    case "loadForDefaultProject": {
                        componentConfig.setLoadForDefaultProject(IdeaPluginDescriptorImpl.readBoolValue(elementChild.getTextTrim()));
                        break;
                    }
                    case "interface-class": {
                        componentConfig.setInterfaceClass(elementChild.getTextTrim());
                        break;
                    }
                    case "implementation-class": {
                        componentConfig.setImplementationClass(elementChild.getTextTrim());
                        break;
                    }
                    case "headless-implementation-class": {
                        componentConfig.setHeadlessImplementationClass(elementChild.getTextTrim());
                        break;
                    }
                    case "option": {
                        String name = elementChild.getAttributeValue("name");
                        String value2 = elementChild.getAttributeValue("value");
                        if (name == null) break;
                        if (name.equals("os")) {
                            if (value2 == null || XmlReader.isSuitableForOs(value2)) break;
                            break;
                        }
                        if (options == null) {
                            options = Collections.singletonMap(name, value2);
                            break;
                        }
                        if (options.size() == 1) {
                            options = new HashMap<String, String>(options);
                        }
                        options.put(name, value2);
                    }
                }
            }
            if (options != null) {
                componentConfig.options = options;
            }
            result2.add(componentConfig);
        }
    }

    private static boolean readBoolValue(@NotNull String value2) {
        if (value2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(28);
        }
        return value2.isEmpty() || value2.equalsIgnoreCase("true");
    }

    @Nullable
    private Date parseReleaseDate(@Nullable String dateStr, @NotNull DescriptorListLoadingContext context2) {
        if (context2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(29);
        }
        if (StringUtil.isEmpty(dateStr)) {
            return null;
        }
        try {
            return context2.getDateParser().parse(dateStr);
        }
        catch (ParseException e) {
            DescriptorListLoadingContext.LOG.info("Error parse release date from plugin descriptor for plugin " + this.myName + " {" + this.myId + "}: " + e.getMessage());
            return null;
        }
    }

    @ApiStatus.Internal
    public void registerExtensions(@NotNull ExtensionsAreaImpl area, @NotNull IdeaPluginDescriptorImpl rootDescriptor, @NotNull ContainerDescriptor containerDescriptor, @Nullable List<Runnable> listenerCallbacks) {
        Map<String, List<Element>> extensions;
        if (area == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(31);
        }
        if (rootDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(32);
        }
        if (containerDescriptor == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(33);
        }
        if ((extensions = containerDescriptor.extensions) != null) {
            area.registerExtensions(extensions, rootDescriptor, listenerCallbacks);
            return;
        }
        if (this.epNameToExtensionElements == null) {
            return;
        }
        containerDescriptor.extensions = this.epNameToExtensionElements;
        LinkedHashMap<String, List<Element>> other = null;
        Iterator<Map.Entry<String, List<Element>>> iterator2 = containerDescriptor.extensions.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<String, List<Element>> entry = iterator2.next();
            if (area.registerExtensions(entry.getKey(), entry.getValue(), rootDescriptor, listenerCallbacks)) continue;
            iterator2.remove();
            if (other == null) {
                other = new LinkedHashMap<String, List<Element>>();
            }
            IdeaPluginDescriptorImpl.addExtensionList(other, entry.getKey(), entry.getValue());
        }
        this.isExtensionsCleared = true;
        if (containerDescriptor.extensions.isEmpty()) {
            containerDescriptor.extensions = Collections.emptyMap();
        }
        if (containerDescriptor == this.projectContainerDescriptor) {
            this.moduleContainerDescriptor.extensions = other;
            this.epNameToExtensionElements = null;
        } else {
            this.epNameToExtensionElements = other;
        }
    }

    public String getVersion() {
        return this.myVersion;
    }

    @Override
    public PluginId getPluginId() {
        return this.myId;
    }

    @Override
    public ClassLoader getPluginClassLoader() {
        return this.myLoader != null ? this.myLoader : this.getClass().getClassLoader();
    }

    public boolean isUseIdeaClassLoader() {
        return this.myUseIdeaClassLoader;
    }

    public void setEnabled(boolean enabled2) {
        this.myEnabled = enabled2;
    }

    private static void addExtensionList(@NotNull Map<String, List<Element>> map, @NotNull String name, @NotNull List<Element> list2) {
        List mapList;
        if (map == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(45);
        }
        if (name == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(46);
        }
        if (list2 == null) {
            IdeaPluginDescriptorImpl.$$$reportNull$$$0(47);
        }
        if ((mapList = map.computeIfAbsent(name, __ -> list2)) != list2) {
            mapList.addAll(list2);
        }
    }

    @Override
    public boolean isBundled() {
        return this.myBundled;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof IdeaPluginDescriptorImpl && this.myId == ((IdeaPluginDescriptorImpl)o).myId;
    }

    public int hashCode() {
        return Objects.hashCode(this.myId);
    }

    public String toString() {
        return "PluginDescriptor(name=" + this.myName + ", id=" + this.myId + ", path=" + this.path + ", version=" + this.myVersion + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 48: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "basePath";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathResolver";
                break;
            }
            case 10: 
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainDescriptor";
                break;
            }
            case 17: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerDescriptor";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalLayoutMap";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/IdeaPluginDescriptorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getApp";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginPath";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "formatErrorMessage";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppContainerDescriptor";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentPluginIds";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionalDependentPluginIds";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPath";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "collectClassPath";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 48: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readForTest";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "doRead";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readProduct";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "readPluginIncompatibility";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "readPluginDependency";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkCompatibility";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "formatErrorMessage";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "markAsIncomplete";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "readComponents";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readBoolValue";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "parseReleaseDate";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "collectClassPath";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfig";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionList";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 24: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 48: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum OS {
        mac,
        linux,
        windows,
        unix,
        freebsd;

    }
}

