/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.Manifest;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.scan.Jar;
import org.apache.tomcat.util.scan.NonClosingJarInputStream;

public class UrlJar
implements Jar {
    private NonClosingJarInputStream jarInputStream = null;
    private URL url = null;
    private JarEntry entry = null;
    private Map<String, String> mrMap = null;

    public UrlJar(URL uRL) throws IOException {
        String string;
        Manifest manifest;
        this.url = uRL;
        this.jarInputStream = this.createJarInputStream();
        boolean bl = false;
        if (JreCompat.isJre9Available() && (manifest = this.jarInputStream.getManifest()) != null && (string = manifest.getMainAttributes().getValue("Multi-Release")) != null) {
            bl = Boolean.valueOf(string);
        }
        if (bl) {
            this.populateMrMap();
        }
    }

    @Override
    @Deprecated
    public boolean entryExists(String string) throws IOException {
        return false;
    }

    @Override
    public InputStream getInputStream(String string) throws IOException {
        JarEntry jarEntry = this.jarInputStream.getNextJarEntry();
        while (jarEntry != null && !string.equals(jarEntry.getName())) {
            jarEntry = this.jarInputStream.getNextJarEntry();
        }
        if (jarEntry == null) {
            return null;
        }
        return this.jarInputStream;
    }

    @Override
    public void close() {
        if (this.jarInputStream != null) {
            try {
                this.jarInputStream.reallyClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private NonClosingJarInputStream createJarInputStream() throws IOException {
        JarURLConnection jarURLConnection = (JarURLConnection)this.url.openConnection();
        URL uRL = jarURLConnection.getJarFileURL();
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        return new NonClosingJarInputStream(uRLConnection.getInputStream());
    }

    @Override
    public void nextEntry() {
        try {
            this.entry = this.jarInputStream.getNextJarEntry();
            if (this.mrMap != null) {
                while (this.entry != null && (this.mrMap.keySet().contains(this.entry.getName()) || this.entry.getName().startsWith("META-INF/versions/") && !this.mrMap.values().contains(this.entry.getName()))) {
                    this.entry = this.jarInputStream.getNextJarEntry();
                }
            } else {
                while (this.entry != null && this.entry.getName().startsWith("META-INF/versions/")) {
                    this.entry = this.jarInputStream.getNextJarEntry();
                }
            }
        }
        catch (IOException iOException) {
            this.entry = null;
        }
    }

    @Override
    public String getEntryName() {
        if (this.entry == null) {
            return null;
        }
        return this.entry.getName();
    }

    @Override
    public InputStream getEntryInputStream() throws IOException {
        return this.jarInputStream;
    }

    @Override
    public void reset() throws IOException {
        this.close();
        this.entry = null;
        this.jarInputStream = this.createJarInputStream();
    }

    private void populateMrMap() throws IOException {
        int n = JreCompat.getInstance().jarFileRuntimeMajorVersion();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        JarEntry jarEntry = this.jarInputStream.getNextJarEntry();
        while (jarEntry != null) {
            int n2;
            String string = jarEntry.getName();
            if (string.startsWith("META-INF/versions/") && string.endsWith(".class") && (n2 = string.indexOf(47, 18)) > 0) {
                String string2 = string.substring(n2 + 1);
                int n3 = Integer.parseInt(string.substring(18, n2));
                if (n3 <= n) {
                    Integer n4 = (Integer)hashMap.get(string2);
                    if (n4 == null) {
                        hashMap.put(string2, n3);
                    } else if (n3 > n4) {
                        hashMap.put(string2, n3);
                    }
                }
            }
            jarEntry = this.jarInputStream.getNextJarEntry();
        }
        this.mrMap = new HashMap<String, String>();
        for (Map.Entry entry : hashMap.entrySet()) {
            this.mrMap.put((String)entry.getKey(), "META-INF/versions/" + ((Integer)entry.getValue()).toString() + "/" + (String)entry.getKey());
        }
        this.close();
        this.jarInputStream = this.createJarInputStream();
    }
}

