/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.tomcat.dbcp.dbcp.AbandonedConfig;
import org.apache.tomcat.dbcp.dbcp.AbandonedObjectPool;
import org.apache.tomcat.dbcp.dbcp.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp.DriverConnectionFactory;
import org.apache.tomcat.dbcp.dbcp.PStmtKey;
import org.apache.tomcat.dbcp.dbcp.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp.PoolableConnectionFactory;
import org.apache.tomcat.dbcp.dbcp.PoolingDataSource;
import org.apache.tomcat.dbcp.pool.KeyedObjectPoolFactory;
import org.apache.tomcat.dbcp.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.tomcat.dbcp.pool.impl.GenericObjectPool;

public class BasicDataSource
implements DataSource {
    protected volatile boolean defaultAutoCommit = true;
    protected transient Boolean defaultReadOnly = null;
    protected volatile int defaultTransactionIsolation = -1;
    protected volatile String defaultCatalog = null;
    protected String driverClassName = null;
    protected ClassLoader driverClassLoader = null;
    private boolean lifo = true;
    protected int maxActive = 8;
    protected int maxIdle = 8;
    protected int minIdle = 0;
    protected int initialSize = 0;
    protected long maxWait = -1L;
    protected boolean poolPreparedStatements = false;
    protected int maxOpenPreparedStatements = -1;
    protected boolean testOnBorrow = true;
    protected boolean testOnReturn = false;
    protected long timeBetweenEvictionRunsMillis = -1L;
    protected int numTestsPerEvictionRun = 3;
    protected long minEvictableIdleTimeMillis = 1800000L;
    private long softMinEvictableIdleTimeMillis = -1L;
    protected boolean testWhileIdle = false;
    protected volatile String password = null;
    protected String url = null;
    protected String username = null;
    protected volatile String validationQuery = null;
    protected volatile int validationQueryTimeout = -1;
    protected volatile List<String> connectionInitSqls;
    private boolean accessToUnderlyingConnectionAllowed = false;
    protected volatile GenericObjectPool<PoolableConnection> connectionPool = null;
    protected Properties connectionProperties = new Properties();
    protected volatile DataSource dataSource = null;
    protected PrintWriter logWriter = new PrintWriter(System.out);
    private AbandonedConfig abandonedConfig;
    protected boolean closed;

    public boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean bl) {
        this.defaultAutoCommit = bl;
    }

    public boolean getDefaultReadOnly() {
        Boolean bl = this.defaultReadOnly;
        if (bl != null) {
            return bl;
        }
        return false;
    }

    public void setDefaultReadOnly(boolean bl) {
        this.defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.defaultTransactionIsolation = n;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String string) {
        this.defaultCatalog = string != null && string.trim().length() > 0 ? string : null;
    }

    public synchronized String getDriverClassName() {
        return this.driverClassName;
    }

    public synchronized void setDriverClassName(String string) {
        this.driverClassName = string != null && string.trim().length() > 0 ? string : null;
    }

    public synchronized ClassLoader getDriverClassLoader() {
        return this.driverClassLoader;
    }

    public synchronized void setDriverClassLoader(ClassLoader classLoader) {
        this.driverClassLoader = classLoader;
    }

    public synchronized boolean getLifo() {
        return this.lifo;
    }

    public synchronized void setLifo(boolean bl) {
        this.lifo = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setLifo(bl);
        }
    }

    public synchronized int getMaxActive() {
        return this.maxActive;
    }

    public synchronized void setMaxActive(int n) {
        this.maxActive = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxActive(n);
        }
    }

    public synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    public synchronized void setMaxIdle(int n) {
        this.maxIdle = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxIdle(n);
        }
    }

    public synchronized int getMinIdle() {
        return this.minIdle;
    }

    public synchronized void setMinIdle(int n) {
        this.minIdle = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMinIdle(n);
        }
    }

    public synchronized int getInitialSize() {
        return this.initialSize;
    }

    public synchronized void setInitialSize(int n) {
        this.initialSize = n;
    }

    public synchronized long getMaxWait() {
        return this.maxWait;
    }

    public synchronized void setMaxWait(long l) {
        this.maxWait = l;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxWait(l);
        }
    }

    public synchronized boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public synchronized void setPoolPreparedStatements(boolean bl) {
        this.poolPreparedStatements = bl;
    }

    public synchronized int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    public synchronized void setMaxOpenPreparedStatements(int n) {
        this.maxOpenPreparedStatements = n;
    }

    public synchronized boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public synchronized void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnBorrow(bl);
        }
    }

    public synchronized boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public synchronized void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnReturn(bl);
        }
    }

    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long l) {
        this.timeBetweenEvictionRunsMillis = l;
        if (this.connectionPool != null) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(l);
        }
    }

    public synchronized int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int n) {
        this.numTestsPerEvictionRun = n;
        if (this.connectionPool != null) {
            this.connectionPool.setNumTestsPerEvictionRun(n);
        }
    }

    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public synchronized void setMinEvictableIdleTimeMillis(long l) {
        this.minEvictableIdleTimeMillis = l;
        if (this.connectionPool != null) {
            this.connectionPool.setMinEvictableIdleTimeMillis(l);
        }
    }

    public synchronized void setSoftMinEvictableIdleTimeMillis(long l) {
        this.softMinEvictableIdleTimeMillis = l;
        if (this.connectionPool != null) {
            this.connectionPool.setSoftMinEvictableIdleTimeMillis(l);
        }
    }

    public synchronized long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    public synchronized boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestWhileIdle(bl);
        }
    }

    public synchronized int getNumActive() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumActive();
        }
        return 0;
    }

    public synchronized int getNumIdle() {
        if (this.connectionPool != null) {
            return this.connectionPool.getNumIdle();
        }
        return 0;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public synchronized String getUrl() {
        return this.url;
    }

    public synchronized void setUrl(String string) {
        this.url = string;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = string != null && string.trim().length() > 0 ? string : null;
    }

    public int getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public void setValidationQueryTimeout(int n) {
        this.validationQueryTimeout = n;
    }

    public Collection<String> getConnectionInitSqls() {
        List<String> list = this.connectionInitSqls;
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public void setConnectionInitSqls(Collection<String> collection) {
        if (collection != null && collection.size() > 0) {
            ArrayList<String> arrayList = null;
            for (String string : collection) {
                if (string == null || string.trim().length() <= 0) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string);
            }
            this.connectionInitSqls = arrayList;
        } else {
            this.connectionInitSqls = null;
        }
    }

    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.createDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.createDataSource().setLogWriter(printWriter);
        this.logWriter = printWriter;
    }

    public boolean getRemoveAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandoned();
        }
        return false;
    }

    public void setRemoveAbandoned(boolean bl) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandoned(bl);
    }

    public int getRemoveAbandonedTimeout() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandonedTimeout();
        }
        return 300;
    }

    public void setRemoveAbandonedTimeout(int n) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedTimeout(n);
    }

    public boolean getLogAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getLogAbandoned();
        }
        return false;
    }

    public void setLogAbandoned(boolean bl) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogAbandoned(bl);
    }

    public void addConnectionProperty(String string, String string2) {
        this.connectionProperties.put(string, string2);
    }

    public void removeConnectionProperty(String string) {
        this.connectionProperties.remove(string);
    }

    public void setConnectionProperties(String string) {
        if (string == null) {
            throw new NullPointerException("connectionProperties is null");
        }
        String[] stringArray = string.split(";");
        Properties properties = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.length() <= 0) continue;
            int n = string2.indexOf(61);
            if (n > 0) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                properties.setProperty(string3, string4);
                continue;
            }
            properties.setProperty(string2, "");
        }
        this.connectionProperties = properties;
    }

    public synchronized void close() throws SQLException {
        this.closed = true;
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        this.connectionPool = null;
        this.dataSource = null;
        try {
            if (genericObjectPool != null) {
                genericObjectPool.close();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Cannot close connection pool", exception);
        }
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException("BasicDataSource is not a wrapper.");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    protected synchronized DataSource createDataSource() throws SQLException {
        if (this.closed) {
            throw new SQLException("Data source is closed");
        }
        if (this.dataSource != null) {
            return this.dataSource;
        }
        ConnectionFactory connectionFactory = this.createConnectionFactory();
        this.createConnectionPool();
        GenericKeyedObjectPoolFactory genericKeyedObjectPoolFactory = null;
        if (this.isPoolPreparedStatements()) {
            genericKeyedObjectPoolFactory = new GenericKeyedObjectPoolFactory(null, -1, 0, 0L, 1, this.maxOpenPreparedStatements);
        }
        boolean bl = false;
        try {
            this.createPoolableConnectionFactory(connectionFactory, genericKeyedObjectPoolFactory, this.abandonedConfig);
            bl = true;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Error creating connection factory", exception);
        }
        finally {
            if (!bl) {
                this.closeConnectionPool();
            }
        }
        bl = false;
        try {
            this.createDataSourceInstance();
            bl = true;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Error creating datasource", exception);
        }
        finally {
            if (!bl) {
                this.closeConnectionPool();
            }
        }
        try {
            for (int i = 0; i < this.initialSize; ++i) {
                this.connectionPool.addObject();
            }
        }
        catch (Exception exception) {
            this.closeConnectionPool();
            throw new SQLException("Error preloading the connection pool", exception);
        }
        this.startPoolMaintenance();
        return this.dataSource;
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        String string;
        Class<?> clazz;
        block16: {
            clazz = null;
            if (this.driverClassName != null) {
                try {
                    try {
                        if (this.driverClassLoader == null) {
                            clazz = Class.forName(this.driverClassName);
                            break block16;
                        }
                        clazz = Class.forName(this.driverClassName, true, this.driverClassLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clazz = Thread.currentThread().getContextClassLoader().loadClass(this.driverClassName);
                    }
                }
                catch (Throwable throwable) {
                    String string2 = "Cannot load JDBC driver class '" + this.driverClassName + "'";
                    this.logWriter.println(string2);
                    throwable.printStackTrace(this.logWriter);
                    throw new SQLException(string2, throwable);
                }
            }
        }
        Driver driver = null;
        try {
            if (clazz == null) {
                driver = DriverManager.getDriver(this.url);
            } else {
                driver = (Driver)clazz.newInstance();
                if (!driver.acceptsURL(this.url)) {
                    throw new SQLException("No suitable driver", "08001");
                }
            }
        }
        catch (Throwable throwable) {
            String string3 = "Cannot create JDBC driver of class '" + (this.driverClassName != null ? this.driverClassName : "") + "' for connect URL '" + this.url + "'";
            this.logWriter.println(string3);
            throwable.printStackTrace(this.logWriter);
            throw new SQLException(string3, throwable);
        }
        if (this.validationQuery == null) {
            this.setTestOnBorrow(false);
            this.setTestOnReturn(false);
            this.setTestWhileIdle(false);
        }
        if ((string = this.username) != null) {
            this.connectionProperties.put("user", string);
        } else {
            this.log("DBCP DataSource configured without a 'username'");
        }
        String string4 = this.password;
        if (string4 != null) {
            this.connectionProperties.put("password", string4);
        } else {
            this.log("DBCP DataSource configured without a 'password'");
        }
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
        return driverConnectionFactory;
    }

    protected void createConnectionPool() {
        GenericObjectPool genericObjectPool = this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandoned() ? new AbandonedObjectPool(null, this.abandonedConfig) : new GenericObjectPool();
        genericObjectPool.setMaxActive(this.maxActive);
        genericObjectPool.setMaxIdle(this.maxIdle);
        genericObjectPool.setMinIdle(this.minIdle);
        genericObjectPool.setMaxWait(this.maxWait);
        genericObjectPool.setTestOnBorrow(this.testOnBorrow);
        genericObjectPool.setTestOnReturn(this.testOnReturn);
        genericObjectPool.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        genericObjectPool.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        genericObjectPool.setTestWhileIdle(this.testWhileIdle);
        genericObjectPool.setLifo(this.lifo);
        this.connectionPool = genericObjectPool;
    }

    private void closeConnectionPool() {
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        this.connectionPool = null;
        try {
            if (genericObjectPool != null) {
                genericObjectPool.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void startPoolMaintenance() {
        if (this.connectionPool != null && this.timeBetweenEvictionRunsMillis > 0L) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        }
    }

    protected void createDataSourceInstance() throws SQLException {
        PoolingDataSource<PoolableConnection> poolingDataSource = new PoolingDataSource<PoolableConnection>(this.connectionPool);
        poolingDataSource.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        poolingDataSource.setLogWriter(this.logWriter);
        this.dataSource = poolingDataSource;
    }

    protected void createPoolableConnectionFactory(ConnectionFactory connectionFactory, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, AbandonedConfig abandonedConfig) throws SQLException {
        PoolableConnectionFactory poolableConnectionFactory = null;
        try {
            poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, this.connectionPool, keyedObjectPoolFactory, this.validationQuery, this.validationQueryTimeout, this.connectionInitSqls, this.defaultReadOnly, this.defaultAutoCommit, this.defaultTransactionIsolation, this.defaultCatalog, abandonedConfig);
            BasicDataSource.validateConnectionFactory(poolableConnectionFactory);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Cannot create PoolableConnectionFactory (" + exception.getMessage() + ")", exception);
        }
    }

    protected static void validateConnectionFactory(PoolableConnectionFactory poolableConnectionFactory) throws Exception {
        PoolableConnection poolableConnection = null;
        try {
            poolableConnection = poolableConnectionFactory.makeObject();
            poolableConnectionFactory.activateObject(poolableConnection);
            poolableConnectionFactory.validateConnection(poolableConnection);
            poolableConnectionFactory.passivateObject(poolableConnection);
        }
        finally {
            poolableConnectionFactory.destroyObject(poolableConnection);
        }
    }

    protected void log(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }

    static {
        DriverManager.getDrivers();
    }
}

