/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.tomcat.dbcp.dbcp.AbandonedTrace;
import org.apache.tomcat.dbcp.dbcp.DelegatingConnection;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;

public class PoolablePreparedStatement<K>
extends DelegatingPreparedStatement {
    protected KeyedObjectPool<K, PoolablePreparedStatement<K>> _pool = null;
    protected K _key = null;
    private volatile boolean batchAdded = false;

    public PoolablePreparedStatement(PreparedStatement preparedStatement, K k, KeyedObjectPool<K, PoolablePreparedStatement<K>> keyedObjectPool, Connection connection) {
        super((DelegatingConnection)connection, preparedStatement);
        this._pool = keyedObjectPool;
        this._key = k;
        if (this._conn != null) {
            this._conn.removeTrace(this);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        super.addBatch();
        this.batchAdded = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.batchAdded = false;
        super.clearBatch();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed()) {
            try {
                this._pool.returnObject(this._key, this);
            }
            catch (SQLException sQLException) {
                throw sQLException;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new SQLException("Cannot close preparedstatement (return to pool failed)", exception);
            }
        }
    }

    @Override
    public void activate() throws SQLException {
        this._closed = false;
        if (this._conn != null) {
            this._conn.addTrace(this);
        }
        super.activate();
    }

    @Override
    public void passivate() throws SQLException {
        List<AbandonedTrace> list;
        this._closed = true;
        if (this._conn != null) {
            this._conn.removeTrace(this);
        }
        if ((list = this.getTrace()) != null) {
            ResultSet[] resultSetArray = list.toArray(new ResultSet[0]);
            for (int i = 0; i < resultSetArray.length; ++i) {
                resultSetArray[i].close();
            }
            this.clearTrace();
        }
        if (this.batchAdded) {
            this.clearBatch();
        }
        super.passivate();
    }
}

