/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import java.util.Map;
import javajs.util.BS;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Ellipsoid;
import org.jmol.shapespecial.Ellipsoids;
import org.jmol.util.C;
import org.jmol.util.Normix;
import org.jmol.viewer.JC;

public final class EllipsoidsRenderer
extends ShapeRenderer {
    private Ellipsoids ellipsoids;
    private boolean[] bGlobals = new boolean[7];
    private boolean[] bOptions = new boolean[7];
    private final String[] OPTS = new String[]{"dots", "arcs", "axes", "fill", "ball", "arrows", "wireframe"};
    private static final int OPT_DOTS = 0;
    private static final int OPT_ARCS = 1;
    private static final int OPT_AXES = 2;
    private static final int OPT_FILL = 3;
    private static final int OPT_BALL = 4;
    private static final int OPT_ARROWS = 5;
    private static final int OPT_WIREFRAME = 6;
    private static final int OPT_COUNT = 7;
    private boolean fillArc;
    private boolean isSet;
    private int diameter;
    private int diameter0;
    private int dotCount;
    private int dotScale;
    private int dx;
    private int eigenSignMask = 7;
    private int iCutout = -1;
    private int selectedOctant = -1;
    private int[] coords;
    private V3[] axes;
    private P3 center;
    private float perspectiveFactor;
    private BS bsTemp = new BS();
    private M3 mat = new M3();
    private M3 mTemp = new M3();
    private M4 mDeriv = new M4();
    private M3 matScreenToCartesian = new M3();
    private M3 matScreenToEllipsoid = new M3();
    private M3 matEllipsoidToScreen = new M3();
    private final double[] coefs = new double[10];
    private final float[] factoredLengths = new float[3];
    private final P3[] selectedPoints = new P3[3];
    private final V3 v1 = new V3();
    private final V3 v2 = new V3();
    private final V3 v3 = new V3();
    private final P3 pt1 = new P3();
    private final P3 pt2 = new P3();
    private final P3 s0 = new P3();
    private final P3 s1 = new P3();
    private final P3 s2 = new P3();
    private static final float toRadians = (float)Math.PI / 180;
    private static final float[] cossin = new float[36];
    private static final V3[] unitAxisVectors;
    private final P3[] screens = new P3[38];
    private final P3[] points = new P3[6];
    private static int[] axisPoints;
    private static int[] octants;

    public EllipsoidsRenderer() {
        int i;
        for (i = 0; i < this.points.length; ++i) {
            this.points[i] = new P3();
        }
        for (i = 0; i < this.screens.length; ++i) {
            this.screens[i] = new P3();
        }
    }

    @Override
    protected boolean render() {
        this.isSet = false;
        this.ellipsoids = (Ellipsoids)this.shape;
        if (!this.ellipsoids.isActive()) {
            return false;
        }
        boolean needTranslucent = false;
        if (!this.isSet) {
            this.isSet = this.setGlobals();
        }
        if (!this.ellipsoids.atomEllipsoids.isEmpty()) {
            needTranslucent |= this.renderEllipsoids(this.ellipsoids.atomEllipsoids, false);
        }
        if (!this.ellipsoids.simpleEllipsoids.isEmpty()) {
            needTranslucent |= this.renderEllipsoids(this.ellipsoids.simpleEllipsoids, true);
        }
        this.coords = null;
        return needTranslucent;
    }

    private boolean setGlobals() {
        this.bGlobals[1] = this.vwr.getBooleanProperty("ellipsoidArcs");
        this.bGlobals[5] = this.vwr.getBooleanProperty("ellipsoidArrows");
        this.bGlobals[2] = this.vwr.getBooleanProperty("ellipsoidAxes");
        this.bGlobals[4] = this.vwr.getBooleanProperty("ellipsoidBall");
        this.bGlobals[0] = this.vwr.getBooleanProperty("ellipsoidDots");
        this.bGlobals[3] = this.vwr.getBooleanProperty("ellipsoidFill");
        this.bGlobals[6] = !this.isExport && !this.vwr.checkMotionRendering(1112150020);
        this.diameter0 = Math.round(((Float)this.vwr.getP("ellipsoidAxisDiameter")).floatValue() * 1000.0f);
        M4 m4 = this.tm.matrixTransform;
        this.mat.setRow(0, m4.m00, m4.m01, m4.m02);
        this.mat.setRow(1, m4.m10, m4.m11, m4.m12);
        this.mat.setRow(2, m4.m20, m4.m21, m4.m22);
        this.matScreenToCartesian.invertM(this.mat);
        this.setLogic();
        return true;
    }

    private void setOptions(String options) {
        int i;
        for (i = 0; i < 7; ++i) {
            this.bOptions[i] = this.bGlobals[i];
        }
        if (options != null) {
            options = ";" + options + ";";
            for (i = 0; i < 7; ++i) {
                if (PT.isOneOf(this.OPTS[i], options)) {
                    this.bOptions[i] = true;
                    continue;
                }
                if (!PT.isOneOf("no" + this.OPTS[i], options)) continue;
                this.bOptions[i] = false;
            }
        }
        this.setLogic();
    }

    private void setLogic() {
        this.bOptions[0] = this.bOptions[0] & !this.bOptions[6];
        this.bOptions[4] = this.bOptions[4] & !this.bOptions[6];
        this.bOptions[3] = this.bOptions[3] & !this.bOptions[6];
        boolean bl = this.fillArc = this.bOptions[3] && !this.bOptions[4];
        if (this.fillArc) {
            this.g3d.addRenderer(1073742182);
        }
        if (this.bOptions[4]) {
            this.bOptions[0] = false;
        }
        if (!(this.bOptions[0] || this.bOptions[1] || this.bOptions[4])) {
            this.bOptions[2] = true;
        }
        if (this.bOptions[0]) {
            this.bOptions[1] = false;
            this.bOptions[3] = false;
            this.dotScale = this.vwr.getInt(553648142);
        }
        if (this.bOptions[0]) {
            this.dotCount = (Integer)this.vwr.getP("ellipsoidDotCount");
            if (this.coords == null || this.coords.length != this.dotCount * 3) {
                this.coords = new int[this.dotCount * 3];
            }
        }
    }

    private boolean renderEllipsoids(Map<?, Ellipsoid> ht, boolean isSimple) {
        boolean needTranslucent = false;
        Atom atom = null;
        for (Ellipsoid ellipsoid : ht.values()) {
            if (!ellipsoid.visible) continue;
            if (isSimple) {
                this.colix = ellipsoid.colix;
            } else {
                atom = this.ms.at[ellipsoid.tensor.atomIndex1];
                if (atom.sZ <= 1 || !this.isVisibleForMe(atom)) continue;
                this.colix = C.getColixInherited(ellipsoid.colix, atom.colixAtom);
            }
            if (!this.g3d.setC(this.colix)) {
                needTranslucent = true;
                continue;
            }
            this.tm.transformPtScrT3(ellipsoid.center, this.s0);
            this.renderOne(ellipsoid);
        }
        return needTranslucent;
    }

    private void renderOne(Ellipsoid e) {
        this.center = e.center;
        int maxPt = 2;
        float maxLen = 0.0f;
        int i = 3;
        while (--i >= 0) {
            this.factoredLengths[i] = Math.max(e.getLength(i), 0.02f);
            float f = this.factoredLengths[i];
            if (!(f > maxLen)) continue;
            maxLen = f;
            maxPt = i;
        }
        this.axes = e.tensor.eigenVectors;
        this.setMatrices();
        this.setAxes(maxPt);
        if (this.g3d.isClippedXY(this.dx + this.dx, (int)this.s0.x, (int)this.s0.y)) {
            return;
        }
        this.eigenSignMask = e.tensor.eigenSignMask;
        this.setOptions(e.options);
        this.diameter = (int)this.vwr.tm.scaleToScreen((int)this.s0.z, this.bOptions[6] ? 1 : this.diameter0);
        if (e.tensor.isIsotropic) {
            this.renderBall();
            return;
        }
        if (this.bOptions[4]) {
            this.renderBall();
            if (this.bOptions[1] || this.bOptions[2]) {
                this.g3d.setC(this.vwr.cm.colixBackgroundContrast);
                if (this.bOptions[2]) {
                    this.renderAxes();
                }
                if (this.bOptions[1]) {
                    this.renderArcs();
                }
                this.g3d.setC(this.colix);
            }
        } else {
            if (this.bOptions[2]) {
                this.renderAxes();
            }
            if (this.bOptions[1]) {
                this.renderArcs();
            }
        }
        if (this.bOptions[0]) {
            this.renderDots();
        }
        if (this.bOptions[5]) {
            this.renderArrows();
        }
    }

    private void setMatrices() {
        for (int i = 0; i < 3; ++i) {
            this.v1.setT(this.axes[i]);
            this.v1.scale(this.factoredLengths[i]);
            this.mat.setColumnV(i, this.v1);
        }
        this.mat.invertM(this.mat);
        this.matScreenToEllipsoid.mul2(this.mat, this.matScreenToCartesian);
        this.matEllipsoidToScreen.invertM(this.matScreenToEllipsoid);
        this.perspectiveFactor = this.vwr.tm.scaleToPerspective((int)this.s0.z, 1.0f);
        this.matScreenToEllipsoid.scale(1.0f / this.perspectiveFactor);
    }

    private void setAxes(int maxPt) {
        for (int i = 0; i < 6; ++i) {
            int iAxis = axisPoints[i];
            int i012 = Math.abs(iAxis) - 1;
            this.points[i].scaleAdd2(this.factoredLengths[i012] * (float)(iAxis < 0 ? -1 : 1), this.axes[i012], this.center);
            this.pt1.setT(unitAxisVectors[i]);
            this.matEllipsoidToScreen.rotate(this.pt1);
            this.screens[i].set(Math.round(this.s0.x + this.pt1.x * this.perspectiveFactor), Math.round(this.s0.y + this.pt1.y * this.perspectiveFactor), Math.round(this.pt1.z + this.s0.z));
            this.screens[i + 32].set(Math.round(this.s0.x + this.pt1.x * this.perspectiveFactor * 1.05f), Math.round(this.s0.y + this.pt1.y * this.perspectiveFactor * 1.05f), Math.round(this.pt1.z * 1.05f + this.s0.z));
        }
        this.dx = 2 + (int)this.vwr.tm.scaleToScreen((int)this.s0.z, Math.round((Float.isNaN(this.factoredLengths[maxPt]) ? 1.0f : this.factoredLengths[maxPt]) * 1000.0f));
    }

    private void renderBall() {
        this.setSelectedOctant();
        Ellipsoid.getEquationForQuadricWithCenter(this.s0.x, this.s0.y, this.s0.z, this.matScreenToEllipsoid, this.v1, this.mTemp, this.coefs, this.mDeriv);
        this.g3d.fillEllipsoid(this.center, this.points, (int)this.s0.x, (int)this.s0.y, (int)this.s0.z, this.dx + this.dx, this.matScreenToEllipsoid, this.coefs, this.mDeriv, this.selectedOctant, this.selectedOctant >= 0 ? this.selectedPoints : null);
    }

    private void renderArrows() {
        for (int i = 0; i < 6; i += 2) {
            int pt = i == 0 ? 1 : i;
            this.fillConeScreen(this.screens[i], this.screens[i + 1], (this.eigenSignMask & pt) != 0);
        }
    }

    private void fillConeScreen(P3 p1, P3 p2, boolean isPositive) {
        if (this.diameter == 0) {
            return;
        }
        float diam = (this.diameter == 0 ? 1 : this.diameter) * 8;
        this.v1.set(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        this.v1.normalize();
        this.v1.scale(diam);
        this.s1.setT(p1);
        this.s2.setT(p1);
        if (isPositive) {
            this.s2.x -= (float)((int)this.v1.x);
            this.s2.y -= (float)((int)this.v1.y);
            this.s2.z -= (float)((int)this.v1.z);
        } else {
            this.s1.x -= (float)((int)this.v1.x);
            this.s1.y -= (float)((int)this.v1.y);
            this.s1.z -= (float)((int)this.v1.z);
        }
        this.g3d.fillConeScreen3f((byte)2, (int)diam, this.s1, this.s2, false);
        this.s1.setT(p2);
        this.s2.setT(p2);
        if (isPositive) {
            this.s2.x += (float)((int)this.v1.x);
            this.s2.y += (float)((int)this.v1.y);
            this.s2.z += (float)((int)this.v1.z);
        } else {
            this.s1.x += (float)((int)this.v1.x);
            this.s1.y += (float)((int)this.v1.y);
            this.s1.z += (float)((int)this.v1.z);
        }
        this.g3d.fillConeScreen3f((byte)2, (int)diam, this.s1, this.s2, false);
    }

    private void renderAxes() {
        if (this.bOptions[4] && this.bOptions[3]) {
            this.g3d.fillCylinderBits((byte)2, this.diameter, this.s0, this.selectedPoints[0]);
            this.g3d.fillCylinderBits((byte)2, this.diameter, this.s0, this.selectedPoints[1]);
            this.g3d.fillCylinderBits((byte)2, this.diameter, this.s0, this.selectedPoints[2]);
            return;
        }
        if (this.bOptions[4]) {
            this.g3d.fillCylinderBits((byte)2, this.diameter, this.screens[32], this.screens[33]);
            this.g3d.fillCylinderBits((byte)2, this.diameter, this.screens[34], this.screens[35]);
            this.g3d.fillCylinderBits((byte)2, this.diameter, this.screens[36], this.screens[37]);
        } else {
            this.g3d.fillCylinderBits((byte)2, this.diameter, this.screens[0], this.screens[1]);
            this.g3d.fillCylinderBits((byte)2, this.diameter, this.screens[2], this.screens[3]);
            this.g3d.fillCylinderBits((byte)2, this.diameter, this.screens[4], this.screens[5]);
        }
    }

    private void renderDots() {
        int i = 0;
        while (i < this.coords.length) {
            float fz;
            float fx = (float)Math.random();
            float fy = (float)Math.random();
            if (Float.isNaN(fz = (float)Math.sqrt(1.0f - (fx *= (float)(Math.random() > 0.5 ? -1 : 1)) * fx - (fy *= (float)(Math.random() > 0.5 ? -1 : 1)) * fy))) continue;
            fz = (float)(Math.random() > 0.5 ? -1 : 1) * fz;
            this.pt1.scaleAdd2(fx * this.factoredLengths[0], this.axes[0], this.center);
            this.pt1.scaleAdd2(fy * this.factoredLengths[1], this.axes[1], this.pt1);
            this.pt1.scaleAdd2(fz * this.factoredLengths[2], this.axes[2], this.pt1);
            this.tm.transformPtScrT3(this.pt1, this.s1);
            this.coords[i++] = (int)this.s1.x;
            this.coords[i++] = (int)this.s1.y;
            this.coords[i++] = (int)this.s1.z;
        }
        this.g3d.drawPoints(this.dotCount, this.coords, this.dotScale);
    }

    private void renderArcs() {
        if (this.g3d.drawEllipse(this.center, this.points[0], this.points[2], this.fillArc, this.bOptions[6])) {
            this.g3d.drawEllipse(this.center, this.points[2], this.points[5], this.fillArc, this.bOptions[6]);
            this.g3d.drawEllipse(this.center, this.points[5], this.points[0], this.fillArc, this.bOptions[6]);
            return;
        }
        int i = 1;
        int pt = 3;
        while (i < 8) {
            this.renderArc(octants[pt], octants[pt + 1]);
            this.renderArc(octants[pt + 1], octants[pt + 2]);
            this.renderArc(octants[pt + 2], octants[pt]);
            i += 2;
            pt += 6;
        }
    }

    private void renderArc(int ptA, int ptB) {
        this.v1.sub2(this.points[ptA], this.center);
        this.v2.sub2(this.points[ptB], this.center);
        float d1 = this.v1.length();
        float d2 = this.v2.length();
        this.v1.normalize();
        this.v2.normalize();
        this.v3.cross(this.v1, this.v2);
        this.pt1.setT(this.points[ptA]);
        this.s1.setT(this.screens[ptA]);
        short normix = Normix.get2SidedNormix(this.v3, this.bsTemp);
        if (!this.fillArc && !this.bOptions[6]) {
            this.screens[6].setT(this.s1);
        }
        int i = 0;
        int pt = 0;
        while (i < 18) {
            this.pt2.scaleAdd2(cossin[pt] * d1, this.v1, this.center);
            this.pt2.scaleAdd2(cossin[pt + 1] * d2, this.v2, this.pt2);
            this.tm.transformPtScrT3(this.pt2, this.s2);
            if (this.fillArc) {
                this.g3d.fillTriangle3CNBits(this.s0, this.colix, normix, this.s1, this.colix, normix, this.s2, this.colix, normix, true);
            } else if (this.bOptions[6]) {
                this.g3d.fillCylinderBits((byte)2, this.diameter, this.s1, this.s2);
            } else {
                this.screens[i + 7].setT(this.s2);
            }
            this.pt1.setT(this.pt2);
            this.s1.setT(this.s2);
            ++i;
            pt += 2;
        }
        if (!this.fillArc && !this.bOptions[6]) {
            this.g3d.addRenderer(0x21000011);
            for (i = 0; i < 18; ++i) {
                this.g3d.fillHermite(5, this.diameter, this.diameter, this.diameter, this.screens[i == 0 ? i + 6 : i + 5], this.screens[i + 6], this.screens[i + 7], this.screens[i == 17 ? i + 7 : i + 8]);
            }
        }
    }

    private void setSelectedOctant() {
        int zMin = Integer.MAX_VALUE;
        this.selectedOctant = -1;
        this.iCutout = -1;
        if (this.bOptions[3]) {
            int i;
            for (i = 0; i < 8; ++i) {
                int ptA = octants[i * 3];
                int ptB = octants[i * 3 + 1];
                int ptC = octants[i * 3 + 2];
                int z = (int)(this.screens[ptA].z + this.screens[ptB].z + this.screens[ptC].z);
                if (z >= zMin) continue;
                zMin = z;
                this.iCutout = i;
            }
            this.selectedPoints[0] = this.screens[octants[this.iCutout * 3]];
            this.s1.setT(this.selectedPoints[0]);
            this.selectedPoints[1] = this.screens[octants[this.iCutout * 3 + 1]];
            this.s1.add(this.selectedPoints[1]);
            this.selectedPoints[2] = this.screens[octants[this.iCutout * 3 + 2]];
            this.s1.add(this.selectedPoints[2]);
            this.s1.scaleAdd2(-3.0f, this.s0, this.s1);
            this.pt1.set(this.s1.x, this.s1.y, this.s1.z);
            this.matScreenToEllipsoid.rotate(this.pt1);
            i = 0;
            if (this.pt1.x < 0.0f) {
                i |= 1;
            }
            if (this.pt1.y < 0.0f) {
                i |= 2;
            }
            if (this.pt1.z < 0.0f) {
                i |= 4;
            }
            this.selectedOctant = i;
        }
    }

    static {
        int pt = 0;
        for (int i = 5; i <= 90; i += 5) {
            EllipsoidsRenderer.cossin[pt++] = (float)Math.cos((float)i * ((float)Math.PI / 180));
            EllipsoidsRenderer.cossin[pt++] = (float)Math.sin((float)i * ((float)Math.PI / 180));
        }
        unitAxisVectors = new V3[]{JC.axisNX, JC.axisX, JC.axisNY, JC.axisY, JC.axisNZ, JC.axisZ};
        axisPoints = new int[]{-1, 1, -2, 2, -3, 3};
        octants = new int[]{5, 0, 3, 5, 2, 0, 4, 0, 2, 4, 3, 0, 5, 2, 1, 5, 1, 3, 4, 3, 1, 4, 1, 2};
    }
}

