# This file has been autogenerated by the pywayland scanner

# Copyright 2015 Sean Vig
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlSurface


class ZwpPointerGesturePinchV1(Interface):
    """A pinch gesture object

    A pinch gesture object notifies a client about a multi-finger pinch gesture
    detected on an indirect input device such as a touchpad. The gesture is
    usually initiated by multiple fingers moving towards each other or away
    from each other, or by two or more fingers rotating around a logical center
    of gravity. The precise conditions of when such a gesture is detected are
    implementation-dependent.

    A gesture consists of three stages: begin, update (optional) and end. There
    cannot be multiple simultaneous hold, pinch or swipe gestures on a same
    pointer/seat, how compositors prevent these situations is implementation-
    dependent.

    A gesture may be cancelled by the compositor or the hardware. Clients
    should not consider performing permanent or irreversible actions until the
    end of a gesture has been received.
    """

    name = "zwp_pointer_gesture_pinch_v1"
    version = 2


class ZwpPointerGesturePinchV1Proxy(Proxy):
    interface = ZwpPointerGesturePinchV1

    @ZwpPointerGesturePinchV1.request()
    def destroy(self):
        """Destroy the pinch gesture object
        """
        self._marshal(0)
        self._destroy()


class ZwpPointerGesturePinchV1Resource(Resource):
    interface = ZwpPointerGesturePinchV1

    @ZwpPointerGesturePinchV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Object, interface=WlSurface),
        Argument(ArgumentType.Uint),
    )
    def begin(self, serial, time, surface, fingers):
        """Multi-finger pinch begin

        This event is sent when a multi-finger pinch gesture is detected on the
        device.

        :param serial:
        :type serial:
            `ArgumentType.Uint`
        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param surface:
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        :param fingers:
            number of fingers
        :type fingers:
            `ArgumentType.Uint`
        """
        self._post_event(0, serial, time, surface, fingers)

    @ZwpPointerGesturePinchV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
        Argument(ArgumentType.Fixed),
    )
    def update(self, time, dx, dy, scale, rotation):
        """Multi-finger pinch motion

        This event is sent when a multi-finger pinch gesture changes the
        position of the logical center, the rotation or the relative scale.

        The dx and dy coordinates are relative coordinates in the surface
        coordinate space of the logical center of the gesture.

        The scale factor is an absolute scale compared to the
        pointer_gesture_pinch.begin event, e.g. a scale of 2 means the fingers
        are now twice as far apart as on pointer_gesture_pinch.begin.

        The rotation is the relative angle in degrees clockwise compared to the
        previous pointer_gesture_pinch.begin or pointer_gesture_pinch.update
        event.

        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param dx:
            delta x coordinate in surface coordinate space
        :type dx:
            `ArgumentType.Fixed`
        :param dy:
            delta y coordinate in surface coordinate space
        :type dy:
            `ArgumentType.Fixed`
        :param scale:
            scale relative to the initial finger position
        :type scale:
            `ArgumentType.Fixed`
        :param rotation:
            angle in degrees cw relative to the previous event
        :type rotation:
            `ArgumentType.Fixed`
        """
        self._post_event(1, time, dx, dy, scale, rotation)

    @ZwpPointerGesturePinchV1.event(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Int),
    )
    def end(self, serial, time, cancelled):
        """Multi-finger pinch end

        This event is sent when a multi-finger pinch gesture ceases to be
        valid. This may happen when one or more fingers are lifted or the
        gesture is cancelled.

        When a gesture is cancelled, the client should undo state changes
        caused by this gesture. What causes a gesture to be cancelled is
        implementation-dependent.

        :param serial:
        :type serial:
            `ArgumentType.Uint`
        :param time:
            timestamp with millisecond granularity
        :type time:
            `ArgumentType.Uint`
        :param cancelled:
            1 if the gesture was cancelled, 0 otherwise
        :type cancelled:
            `ArgumentType.Int`
        """
        self._post_event(2, serial, time, cancelled)


class ZwpPointerGesturePinchV1Global(Global):
    interface = ZwpPointerGesturePinchV1


ZwpPointerGesturePinchV1._gen_c()
ZwpPointerGesturePinchV1.proxy_class = ZwpPointerGesturePinchV1Proxy
ZwpPointerGesturePinchV1.resource_class = ZwpPointerGesturePinchV1Resource
ZwpPointerGesturePinchV1.global_class = ZwpPointerGesturePinchV1Global
