/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef INCLUDED_IXION_FORMULA_FUNCTION_OPCODE_HPP
#define INCLUDED_IXION_FORMULA_FUNCTION_OPCODE_HPP

#include "ixion/env.hpp"

#include <cstdint>
#include <cstdlib>

namespace ixion {

enum class formula_function_t : uint16_t
{
    func_unknown = 0,
    func_abs,
    func_acos,
    func_acosh,
    func_acot,
    func_acoth,
    func_address,
    func_aggregate,
    func_and,
    func_arabic,
    func_areas,
    func_asc,
    func_asin,
    func_asinh,
    func_atan,
    func_atan2,
    func_atanh,
    func_avedev,
    func_average,
    func_averagea,
    func_averageif,
    func_averageifs,
    func_b,
    func_bahttext,
    func_base,
    func_betadist,
    func_betainv,
    func_binomdist,
    func_bitand,
    func_bitlshift,
    func_bitor,
    func_bitrshift,
    func_bitxor,
    func_ceiling,
    func_cell,
    func_char,
    func_chidist,
    func_chiinv,
    func_chisqdist,
    func_chisqinv,
    func_chitest,
    func_choose,
    func_clean,
    func_code,
    func_color,
    func_column,
    func_columns,
    func_combin,
    func_combina,
    func_concat,
    func_concatenate,
    func_confidence,
    func_correl,
    func_cos,
    func_cosh,
    func_cot,
    func_coth,
    func_count,
    func_counta,
    func_countblank,
    func_countif,
    func_countifs,
    func_covar,
    func_critbinom,
    func_csc,
    func_csch,
    func_cumipmt,
    func_cumprinc,
    func_current,
    func_date,
    func_datedif,
    func_datevalue,
    func_daverage,
    func_day,
    func_days,
    func_days360,
    func_db,
    func_dcount,
    func_dcounta,
    func_ddb,
    func_dde,
    func_decimal,
    func_degrees,
    func_devsq,
    func_dget,
    func_dmax,
    func_dmin,
    func_dollar,
    func_dproduct,
    func_dstdev,
    func_dstdevp,
    func_dsum,
    func_dvar,
    func_dvarp,
    func_eastersunday,
    func_effect,
    func_encodeurl,
    func_errortype,
    func_euroconvert,
    func_even,
    func_exact,
    func_exp,
    func_expondist,
    func_fact,
    func_false,
    func_fdist,
    func_filterxml,
    func_find,
    func_findb,
    func_finv,
    func_fisher,
    func_fisherinv,
    func_fixed,
    func_floor,
    func_forecast,
    func_formula,
    func_fourier,
    func_frequency,
    func_ftest,
    func_fv,
    func_gamma,
    func_gammadist,
    func_gammainv,
    func_gammaln,
    func_gauss,
    func_gcd,
    func_geomean,
    func_getpivotdata,
    func_goalseek,
    func_growth,
    func_harmean,
    func_hlookup,
    func_hour,
    func_hyperlink,
    func_hypgeomdist,
    func_if,
    func_iferror,
    func_ifna,
    func_ifs,
    func_index,
    func_indirect,
    func_info,
    func_int,
    func_intercept,
    func_ipmt,
    func_irr,
    func_isblank,
    func_iserr,
    func_iserror,
    func_iseven,
    func_isformula,
    func_islogical,
    func_isna,
    func_isnontext,
    func_isnumber,
    func_isodd,
    func_isoweeknum,
    func_ispmt,
    func_isref,
    func_istext,
    func_jis,
    func_kurt,
    func_large,
    func_lcm,
    func_left,
    func_leftb,
    func_len,
    func_lenb,
    func_linest,
    func_ln,
    func_log,
    func_log10,
    func_logest,
    func_loginv,
    func_lognormdist,
    func_lookup,
    func_lower,
    func_match,
    func_max,
    func_maxa,
    func_maxifs,
    func_mdeterm,
    func_median,
    func_mid,
    func_midb,
    func_min,
    func_mina,
    func_minifs,
    func_minute,
    func_minverse,
    func_mirr,
    func_mmult,
    func_mod,
    func_mode,
    func_month,
    func_multirange,
    func_munit,
    func_mvalue,
    func_n,
    func_na,
    func_neg,
    func_negbinomdist,
    func_networkdays,
    func_nominal,
    func_normdist,
    func_norminv,
    func_normsdist,
    func_normsinv,
    func_not,
    func_now,
    func_nper,
    func_npv,
    func_numbervalue,
    func_odd,
    func_offset,
    func_or,
    func_pduration,
    func_pearson,
    func_percentile,
    func_percentrank,
    func_permut,
    func_permutationa,
    func_phi,
    func_pi,
    func_pmt,
    func_poisson,
    func_power,
    func_ppmt,
    func_prob,
    func_product,
    func_proper,
    func_pv,
    func_quartile,
    func_radians,
    func_rand,
    func_rank,
    func_rate,
    func_rawsubtract,
    func_regex,
    func_replace,
    func_replaceb,
    func_rept,
    func_right,
    func_rightb,
    func_roman,
    func_round,
    func_rounddown,
    func_roundsig,
    func_roundup,
    func_row,
    func_rows,
    func_rri,
    func_rsq,
    func_search,
    func_searchb,
    func_sec,
    func_sech,
    func_second,
    func_sheet,
    func_sheets,
    func_sign,
    func_sin,
    func_sinh,
    func_skew,
    func_skewp,
    func_sln,
    func_slope,
    func_small,
    func_sqrt,
    func_standardize,
    func_stdev,
    func_stdeva,
    func_stdevp,
    func_stdevpa,
    func_steyx,
    func_style,
    func_substitute,
    func_subtotal,
    func_sum,
    func_sumif,
    func_sumifs,
    func_sumproduct,
    func_sumsq,
    func_sumx2my2,
    func_sumx2py2,
    func_sumxmy2,
    func_switch,
    func_syd,
    func_t,
    func_tan,
    func_tanh,
    func_tdist,
    func_text,
    func_textjoin,
    func_time,
    func_timevalue,
    func_tinv,
    func_today,
    func_transpose,
    func_trend,
    func_trim,
    func_trimmean,
    func_true,
    func_trunc,
    func_ttest,
    func_type,
    func_unichar,
    func_unicode,
    func_upper,
    func_value,
    func_var,
    func_vara,
    func_varp,
    func_varpa,
    func_vdb,
    func_vlookup,
    func_wait,
    func_webservice,
    func_weekday,
    func_weeknum,
    func_weibull,
    func_xor,
    func_year,
    func_ztest,
};

/**
 * Get a string representation of a formula function opcode.
 *
 * @param func formula function opcode.
 *
 * @return null-terminated string representation of the opcode.
 */
IXION_DLLPUBLIC const char* get_formula_function_name(formula_function_t func);

/**
 * Get a formula function opcode from a formula function name.
 *
 * @param p pointer to the string buffer that stores the formula function
 *          name.
 * @param n size of the string buffer.
 *
 * @return formula function opcode representing the specified name.
 */
IXION_DLLPUBLIC formula_function_t get_formula_function_opcode(const char* p, size_t n);

}

#endif
/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
