/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.codegen;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0006\u001a\u00020\u0001*\u00020\u0007\u001a\f\u0010\u0006\u001a\u00020\u0001*\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"isInlineArrayConstructor", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isInlineFunctionCall", "isInlineIrExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "backend.jvm"})
public final class IrInlineCodegenKt {
    public static final boolean isInlineIrExpression(@NotNull IrExpression $this$isInlineIrExpression) {
        boolean bl;
        Intrinsics.checkNotNullParameter($this$isInlineIrExpression, "<this>");
        IrExpression irExpression = $this$isInlineIrExpression;
        if (irExpression instanceof IrBlock) {
            bl = IrInlineCodegenKt.isInlineIrExpression(((IrBlock)$this$isInlineIrExpression).getOrigin());
        } else if (irExpression instanceof IrCallableReference) {
            int n;
            boolean bl2 = true;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean it = bl2;
            boolean bl5 = false;
            Iterable $this$count$iv = RangesKt.until(0, ((IrCallableReference)$this$isInlineIrExpression).getValueArgumentsCount());
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                Iterator iterator2 = $this$count$iv.iterator();
                while (iterator2.hasNext()) {
                    int element$iv;
                    int it2 = element$iv = ((IntIterator)iterator2).nextInt();
                    boolean bl6 = false;
                    if (!(((IrCallableReference)$this$isInlineIrExpression).getValueArgument(it2) != null)) continue;
                    int n2 = ++count$iv;
                    boolean bl7 = false;
                    if (n2 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            boolean bl8 = n == 0;
            boolean bl9 = false;
            if (_Assertions.ENABLED && !bl8) {
                boolean bl10 = false;
                String string2 = Intrinsics.stringPlus("Expecting 0 value arguments for bounded callable reference: ", DumpIrTreeKt.dump$default($this$isInlineIrExpression, false, false, 3, null));
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            bl = bl2;
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isInlineIrExpression(@Nullable IrStatementOrigin $this$isInlineIrExpression) {
        return IrUtilsKt.isLambda($this$isInlineIrExpression) || Intrinsics.areEqual($this$isInlineIrExpression, IrStatementOrigin.ADAPTED_FUNCTION_REFERENCE.INSTANCE) || Intrinsics.areEqual($this$isInlineIrExpression, IrStatementOrigin.SUSPEND_CONVERSION.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isInlineFunctionCall(@NotNull IrFunction $this$isInlineFunctionCall, @NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter($this$isInlineFunctionCall, "<this>");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (context2.getState().isInlineDisabled()) {
            IrTypeParameter it;
            Iterable $this$any$iv = $this$isInlineFunctionCall.getTypeParameters();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                it = (IrTypeParameter)element$iv;
                boolean bl = false;
            } while (!it.isReified());
            boolean bl = true;
            if (!bl) return false;
        }
        if ($this$isInlineFunctionCall.isInline()) return true;
        if (!IrInlineCodegenKt.isInlineArrayConstructor($this$isInlineFunctionCall, context2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isInlineArrayConstructor(IrFunction $this$isInlineArrayConstructor, JvmBackendContext context2) {
        if (!($this$isInlineArrayConstructor instanceof IrConstructor)) return false;
        if ($this$isInlineArrayConstructor.getValueParameters().size() != 2) return false;
        IrClassSymbol irClassSymbol = AdditionalIrUtilsKt.getConstructedClass((IrConstructor)$this$isInlineArrayConstructor).getSymbol();
        boolean bl = false;
        boolean bl2 = false;
        IrClassSymbol it = irClassSymbol;
        boolean bl3 = false;
        if (Intrinsics.areEqual(it, context2.getIrBuiltIns().getArrayClass())) return true;
        if (!context2.getIrBuiltIns().getPrimitiveArrays().contains(it)) return false;
        return true;
    }
}

