package Lire::OutputFormat;

use base qw/Lire::Plugin/;

use strict;

=pod

=head1 NAME

Lire::OutputFormat - Base interface for all OutputFormats.

=head1 SYNOPSIS

  use base qw/ Lire::OutputFormat /;

=head1 DESCRIPTION

The Lire::OutputFormat objects are used to 

This package defines the interface which is implemented by all the
different OutputFormat that Lire is able to produce. It is this object
which has the responsability to convert the XML report to its final
format.

=head1 META INFORMATION METHODS

The Lire::OutputFormat interface extends the Lire::Plugin interface, so
they must implement all standard meta-information methods (name(),
title(), description()).

=cut

sub type { return 'output_format' }


=pod

=head2 missing_requirements()

This method is queried at runtime to determine if any requirements are
missing. It should return an array of messages explaining each missing
requirements for the format.

=cut

sub missing_requirements {
    return ();
}

=pod

=head1 FORMATTING A REPORT

=head2 format_report( $xml_file, $output_file, $format_cfg )

This method should format the XML report contained in $xml_file into
the $output_file (or directory). Additional configuration options are
passed in the $format_cfg Lire::Config::TypeSpec object specific to
the plugin.

=cut

sub format_report {
    die ( ref $_[0], "::format_report unimplemented" );
}

=pod

=head2 mime_report( $xml_file, $format_cfg )

WHen this method is invoked it, the plugin should format the report
contained in $xml_file and MIME encapsulate it a MIME::Entity object
which is return. Formatting options can be be in the $format_cfg
Lire::Config::TypeSpec object.

=cut

sub mime_report {
    die ( ref $_[0], "::mime_report unimplemented" );
}

1;

__END__

=pod

=head1 SEE ALSO

Lire::ReportJob(3pm) Lire::OutputJob(3pm)

=head1 AUTHOR

  Francis J. Lacoste <flacoste@logreport.org>

=head1 VERSION

$Id: OutputFormat.pm,v 1.6 2006/07/23 13:16:29 vanbaal Exp $

=head1 COPYRIGHT

Copyright (C) 2004 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html.

=cut
