/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jsse.provider;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.jsse.provider.JcaAlgorithmDecomposer;
import org.bouncycastle.tls.TlsUtils;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class CipherSuiteInfo {
    private final int cipherSuite;
    private final String name;
    private final boolean isTLSv13;
    private final Set<String> decompositionTLS;
    private final Set<String> decompositionX509;

    static CipherSuiteInfo forCipherSuite(int n, String string, boolean bl) {
        if (!string.startsWith("TLS_")) {
            throw new IllegalArgumentException();
        }
        int n2 = TlsUtils.getEncryptionAlgorithm(n);
        int n3 = TlsUtils.getEncryptionAlgorithmType(n2);
        short s = CipherSuiteInfo.getHashAlgorithm(n);
        int n4 = TlsUtils.getKeyExchangeAlgorithm(n);
        int n5 = TlsUtils.getMACAlgorithm(n);
        HashSet<String> hashSet = new HashSet<String>();
        CipherSuiteInfo.decomposeKeyExchangeAlgorithm(hashSet, n4);
        HashSet<String> hashSet2 = new HashSet<String>(hashSet);
        CipherSuiteInfo.decomposeEncryptionAlgorithm(hashSet2, n2);
        CipherSuiteInfo.decomposeHashAlgorithm(hashSet2, s);
        CipherSuiteInfo.decomposeMACAlgorithm(hashSet2, n3, n5);
        return new CipherSuiteInfo(n, string, bl, Collections.unmodifiableSet(hashSet2), Collections.unmodifiableSet(hashSet));
    }

    private CipherSuiteInfo(int n, String string, boolean bl, Set<String> set, Set<String> set2) {
        this.cipherSuite = n;
        this.name = string;
        this.isTLSv13 = bl;
        this.decompositionTLS = set;
        this.decompositionX509 = set2;
    }

    public int getCipherSuite() {
        return this.cipherSuite;
    }

    public Set<String> getDecompositionTLS() {
        return this.decompositionTLS;
    }

    public Set<String> getDecompositionX509() {
        return this.decompositionX509;
    }

    public String getName() {
        return this.name;
    }

    boolean isTLSv13() {
        return this.isTLSv13;
    }

    private static void addAll(Set<String> set, String ... stringArray) {
        for (String string : stringArray) {
            set.add(string);
        }
    }

    private static void decomposeEncryptionAlgorithm(Set<String> set, int n) {
        String string = CipherSuiteInfo.getTransformation(n);
        set.addAll(JcaAlgorithmDecomposer.INSTANCE_JCA.decompose(string));
        switch (n) {
            case 7: {
                set.add("3DES_EDE_CBC");
                break;
            }
            case 8: {
                set.add("AES_128_CBC");
                break;
            }
            case 15: {
                set.add("AES_128_CCM");
                break;
            }
            case 16: {
                set.add("AES_128_CCM_8");
                break;
            }
            case 10: {
                set.add("AES_128_GCM");
                break;
            }
            case 9: {
                set.add("AES_256_CBC");
                break;
            }
            case 17: {
                set.add("AES_256_CCM");
                break;
            }
            case 18: {
                set.add("AES_256_CCM_8");
                break;
            }
            case 11: {
                set.add("AES_256_GCM");
                break;
            }
            case 22: {
                set.add("ARIA_128_CBC");
                break;
            }
            case 23: {
                set.add("ARIA_256_CBC");
                break;
            }
            case 24: {
                set.add("ARIA_128_GCM");
                break;
            }
            case 25: {
                set.add("ARIA_256_GCM");
                break;
            }
            case 12: {
                set.add("CAMELLIA_128_CBC");
                break;
            }
            case 13: {
                set.add("CAMELLIA_256_CBC");
                break;
            }
            case 19: {
                set.add("CAMELLIA_128_GCM");
                break;
            }
            case 20: {
                set.add("CAMELLIA_256_GCM");
                break;
            }
            case 21: {
                break;
            }
            case 0: {
                set.add("C_NULL");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void decomposeHashAlgorithm(Set<String> set, short s) {
        switch (s) {
            case 0: {
                break;
            }
            case 4: {
                CipherSuiteInfo.addAll(set, "SHA256", "SHA-256", "HmacSHA256");
                break;
            }
            case 5: {
                CipherSuiteInfo.addAll(set, "SHA384", "SHA-384", "HmacSHA384");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void decomposeKeyExchangeAlgorithm(Set<String> set, int n) {
        switch (n) {
            case 3: {
                CipherSuiteInfo.addAll(set, "DSA", "DSS", "DH", "DHE", "DiffieHellman", "DHE_DSS");
                break;
            }
            case 5: {
                CipherSuiteInfo.addAll(set, "RSA", "DH", "DHE", "DiffieHellman", "DHE_RSA");
                break;
            }
            case 17: {
                CipherSuiteInfo.addAll(set, "ECDHE", "ECDSA", "ECDHE_ECDSA");
                break;
            }
            case 19: {
                CipherSuiteInfo.addAll(set, "ECDHE", "RSA", "ECDHE_RSA");
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                CipherSuiteInfo.addAll(set, "RSA");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static void decomposeMACAlgorithm(Set<String> set, int n, int n2) {
        switch (n2) {
            case 0: {
                if (2 == n) break;
                CipherSuiteInfo.addAll(set, "M_NULL");
                break;
            }
            case 1: {
                CipherSuiteInfo.addAll(set, "MD5", "HmacMD5");
                break;
            }
            case 2: {
                CipherSuiteInfo.addAll(set, "SHA1", "SHA-1", "HmacSHA1");
                break;
            }
            case 3: {
                CipherSuiteInfo.addAll(set, "SHA256", "SHA-256", "HmacSHA256");
                break;
            }
            case 4: {
                CipherSuiteInfo.addAll(set, "SHA384", "SHA-384", "HmacSHA384");
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static short getHashAlgorithm(int n) {
        switch (n) {
            case 2: 
            case 10: 
            case 19: 
            case 22: 
            case 47: 
            case 50: 
            case 51: 
            case 53: 
            case 56: 
            case 57: 
            case 65: 
            case 68: 
            case 69: 
            case 132: 
            case 135: 
            case 136: 
            case 49158: 
            case 49160: 
            case 49161: 
            case 49162: 
            case 49168: 
            case 49170: 
            case 49171: 
            case 49172: {
                return 4;
            }
            case 59: 
            case 60: 
            case 61: 
            case 64: 
            case 103: 
            case 106: 
            case 107: 
            case 156: 
            case 158: 
            case 162: 
            case 186: 
            case 189: 
            case 190: 
            case 192: 
            case 195: 
            case 196: 
            case 4865: 
            case 4867: 
            case 4868: 
            case 4869: 
            case 49187: 
            case 49191: 
            case 49195: 
            case 49199: 
            case 49212: 
            case 49218: 
            case 49220: 
            case 49224: 
            case 49228: 
            case 49232: 
            case 49234: 
            case 49238: 
            case 49244: 
            case 49248: 
            case 49266: 
            case 49270: 
            case 49274: 
            case 49276: 
            case 49280: 
            case 49286: 
            case 49290: 
            case 49308: 
            case 49309: 
            case 49310: 
            case 49311: 
            case 49312: 
            case 49313: 
            case 49314: 
            case 49315: 
            case 49324: 
            case 49325: 
            case 49326: 
            case 49327: 
            case 52392: 
            case 52393: 
            case 52394: {
                return 4;
            }
            case 157: 
            case 159: 
            case 163: 
            case 4866: 
            case 49188: 
            case 49192: 
            case 49196: 
            case 49200: 
            case 49213: 
            case 49219: 
            case 49221: 
            case 49225: 
            case 49229: 
            case 49233: 
            case 49235: 
            case 49239: 
            case 49245: 
            case 49249: 
            case 49267: 
            case 49271: 
            case 49275: 
            case 49277: 
            case 49281: 
            case 49287: 
            case 49291: {
                return 5;
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getTransformation(int n) {
        switch (n) {
            case 7: {
                return "DESede/CBC/NoPadding";
            }
            case 8: 
            case 9: {
                return "AES/CBC/NoPadding";
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                return "AES/CCM/NoPadding";
            }
            case 10: 
            case 11: {
                return "AES/GCM/NoPadding";
            }
            case 22: 
            case 23: {
                return "ARIA/CBC/NoPadding";
            }
            case 24: 
            case 25: {
                return "ARIA/GCM/NoPadding";
            }
            case 12: 
            case 13: {
                return "Camellia/CBC/NoPadding";
            }
            case 19: 
            case 20: {
                return "Camellia/GCM/NoPadding";
            }
            case 21: {
                return "ChaCha20-Poly1305";
            }
            case 0: {
                return "NULL";
            }
        }
        throw new IllegalArgumentException();
    }
}

