---@meta

---
---Provides an interface to the user's keyboard.
---
---@class love.keyboard
love.keyboard = {}

---
---Gets the key corresponding to the given hardware scancode.
---
---Unlike key constants, Scancodes are keyboard layout-independent. For example the scancode 'w' will be generated if the key in the same place as the 'w' key on an American keyboard is pressed, no matter what the key is labelled or what the user's operating system settings are.
---
---Scancodes are useful for creating default controls that have the same physical locations on on all systems.
---
---@param scancode love.Scancode # The scancode to get the key from.
---@return love.KeyConstant key # The key corresponding to the given scancode, or 'unknown' if the scancode doesn't map to a KeyConstant on the current system.
function love.keyboard.getKeyFromScancode(scancode) end

---
---Gets the hardware scancode corresponding to the given key.
---
---Unlike key constants, Scancodes are keyboard layout-independent. For example the scancode 'w' will be generated if the key in the same place as the 'w' key on an American keyboard is pressed, no matter what the key is labelled or what the user's operating system settings are.
---
---Scancodes are useful for creating default controls that have the same physical locations on on all systems.
---
---@param key love.KeyConstant # The key to get the scancode from.
---@return love.Scancode scancode # The scancode corresponding to the given key, or 'unknown' if the given key has no known physical representation on the current system.
function love.keyboard.getScancodeFromKey(key) end

---
---Gets whether key repeat is enabled.
---
---@return boolean enabled # Whether key repeat is enabled.
function love.keyboard.hasKeyRepeat() end

---
---Gets whether screen keyboard is supported.
---
---@return boolean supported # Whether screen keyboard is supported.
function love.keyboard.hasScreenKeyboard() end

---
---Gets whether text input events are enabled.
---
---@return boolean enabled # Whether text input events are enabled.
function love.keyboard.hasTextInput() end

---
---Checks whether a certain key is down. Not to be confused with love.keypressed or love.keyreleased.
---
---@overload fun(key: love.KeyConstant, ...):boolean
---@param key love.KeyConstant # The key to check.
---@return boolean down # True if the key is down, false if not.
function love.keyboard.isDown(key) end

---
---Checks whether the specified Scancodes are pressed. Not to be confused with love.keypressed or love.keyreleased.
---
---Unlike regular KeyConstants, Scancodes are keyboard layout-independent. The scancode 'w' is used if the key in the same place as the 'w' key on an American keyboard is pressed, no matter what the key is labelled or what the user's operating system settings are.
---
---@param scancode love.Scancode # A Scancode to check.
---@return boolean down # True if any supplied Scancode is down, false if not.
function love.keyboard.isScancodeDown(scancode) end

---
---Enables or disables key repeat for love.keypressed. It is disabled by default.
---
---@param enable boolean # Whether repeat keypress events should be enabled when a key is held down.
function love.keyboard.setKeyRepeat(enable) end

---
---Enables or disables text input events. It is enabled by default on Windows, Mac, and Linux, and disabled by default on iOS and Android.
---
---On touch devices, this shows the system's native on-screen keyboard when it's enabled.
---
---@overload fun(enable: boolean, x: number, y: number, w: number, h: number)
---@param enable boolean # Whether text input events should be enabled.
function love.keyboard.setTextInput(enable) end

---
---All the keys you can press. Note that some keys may not be available on your keyboard or system.
---
---@class love.KeyConstant
---
---The A key
---
---@field a integer
---
---The B key
---
---@field b integer
---
---The C key
---
---@field c integer
---
---The D key
---
---@field d integer
---
---The E key
---
---@field e integer
---
---The F key
---
---@field f integer
---
---The G key
---
---@field g integer
---
---The H key
---
---@field h integer
---
---The I key
---
---@field i integer
---
---The J key
---
---@field j integer
---
---The K key
---
---@field k integer
---
---The L key
---
---@field l integer
---
---The M key
---
---@field m integer
---
---The N key
---
---@field n integer
---
---The O key
---
---@field o integer
---
---The P key
---
---@field p integer
---
---The Q key
---
---@field q integer
---
---The R key
---
---@field r integer
---
---The S key
---
---@field s integer
---
---The T key
---
---@field t integer
---
---The U key
---
---@field u integer
---
---The V key
---
---@field v integer
---
---The W key
---
---@field w integer
---
---The X key
---
---@field x integer
---
---The Y key
---
---@field y integer
---
---The Z key
---
---@field z integer
---
---The zero key
---
---@field ["0"] integer
---
---The one key
---
---@field ["1"] integer
---
---The two key
---
---@field ["2"] integer
---
---The three key
---
---@field ["3"] integer
---
---The four key
---
---@field ["4"] integer
---
---The five key
---
---@field ["5"] integer
---
---The six key
---
---@field ["6"] integer
---
---The seven key
---
---@field ["7"] integer
---
---The eight key
---
---@field ["8"] integer
---
---The nine key
---
---@field ["9"] integer
---
---Space key
---
---@field space integer
---
---Exclamation mark key
---
---@field ["!"] integer
---
---Double quote key
---
---@field ["\""] integer
---
---Hash key
---
---@field ["#"] integer
---
---Dollar key
---
---@field ["$"] integer
---
---Ampersand key
---
---@field ["&"] integer
---
---Single quote key
---
---@field ["'"] integer
---
---Left parenthesis key
---
---@field ["("] integer
---
---Right parenthesis key
---
---@field [")"] integer
---
---Asterisk key
---
---@field ["*"] integer
---
---Plus key
---
---@field ["+"] integer
---
---Comma key
---
---@field [","] integer
---
---Hyphen-minus key
---
---@field ["-"] integer
---
---Full stop key
---
---@field ["."] integer
---
---Slash key
---
---@field ["/"] integer
---
---Colon key
---
---@field [":"] integer
---
---Semicolon key
---
---@field [";"] integer
---
---Less-than key
---
---@field ["<"] integer
---
---Equal key
---
---@field ["="] integer
---
---Greater-than key
---
---@field [">"] integer
---
---Question mark key
---
---@field ["?"] integer
---
---At sign key
---
---@field ["@"] integer
---
---Left square bracket key
---
---@field ["["] integer
---
---Backslash key
---
---@field ["\\"] integer
---
---Right square bracket key
---
---@field ["]"] integer
---
---Caret key
---
---@field ["^"] integer
---
---Underscore key
---
---@field _ integer
---
---Grave accent key
---
---@field ["`"] integer
---
---The numpad zero key
---
---@field kp0 integer
---
---The numpad one key
---
---@field kp1 integer
---
---The numpad two key
---
---@field kp2 integer
---
---The numpad three key
---
---@field kp3 integer
---
---The numpad four key
---
---@field kp4 integer
---
---The numpad five key
---
---@field kp5 integer
---
---The numpad six key
---
---@field kp6 integer
---
---The numpad seven key
---
---@field kp7 integer
---
---The numpad eight key
---
---@field kp8 integer
---
---The numpad nine key
---
---@field kp9 integer
---
---The numpad decimal point key
---
---@field ["kp."] integer
---
---The numpad division key
---
---@field ["kp/"] integer
---
---The numpad multiplication key
---
---@field ["kp*"] integer
---
---The numpad substraction key
---
---@field ["kp-"] integer
---
---The numpad addition key
---
---@field ["kp+"] integer
---
---The numpad enter key
---
---@field kpenter integer
---
---The numpad equals key
---
---@field ["kp="] integer
---
---Up cursor key
---
---@field up integer
---
---Down cursor key
---
---@field down integer
---
---Right cursor key
---
---@field right integer
---
---Left cursor key
---
---@field left integer
---
---Home key
---
---@field home integer
---
---End key
---
---@field end integer
---
---Page up key
---
---@field pageup integer
---
---Page down key
---
---@field pagedown integer
---
---Insert key
---
---@field insert integer
---
---Backspace key
---
---@field backspace integer
---
---Tab key
---
---@field tab integer
---
---Clear key
---
---@field clear integer
---
---Return key
---
---@field return integer
---
---Delete key
---
---@field delete integer
---
---The 1st function key
---
---@field f1 integer
---
---The 2nd function key
---
---@field f2 integer
---
---The 3rd function key
---
---@field f3 integer
---
---The 4th function key
---
---@field f4 integer
---
---The 5th function key
---
---@field f5 integer
---
---The 6th function key
---
---@field f6 integer
---
---The 7th function key
---
---@field f7 integer
---
---The 8th function key
---
---@field f8 integer
---
---The 9th function key
---
---@field f9 integer
---
---The 10th function key
---
---@field f10 integer
---
---The 11th function key
---
---@field f11 integer
---
---The 12th function key
---
---@field f12 integer
---
---The 13th function key
---
---@field f13 integer
---
---The 14th function key
---
---@field f14 integer
---
---The 15th function key
---
---@field f15 integer
---
---Num-lock key
---
---@field numlock integer
---
---Caps-lock key
---
---@field capslock integer
---
---Scroll-lock key
---
---@field scrollock integer
---
---Right shift key
---
---@field rshift integer
---
---Left shift key
---
---@field lshift integer
---
---Right control key
---
---@field rctrl integer
---
---Left control key
---
---@field lctrl integer
---
---Right alt key
---
---@field ralt integer
---
---Left alt key
---
---@field lalt integer
---
---Right meta key
---
---@field rmeta integer
---
---Left meta key
---
---@field lmeta integer
---
---Left super key
---
---@field lsuper integer
---
---Right super key
---
---@field rsuper integer
---
---Mode key
---
---@field mode integer
---
---Compose key
---
---@field compose integer
---
---Pause key
---
---@field pause integer
---
---Escape key
---
---@field escape integer
---
---Help key
---
---@field help integer
---
---Print key
---
---@field print integer
---
---System request key
---
---@field sysreq integer
---
---Break key
---
---@field break integer
---
---Menu key
---
---@field menu integer
---
---Power key
---
---@field power integer
---
---Euro (&euro;) key
---
---@field euro integer
---
---Undo key
---
---@field undo integer
---
---WWW key
---
---@field www integer
---
---Mail key
---
---@field mail integer
---
---Calculator key
---
---@field calculator integer
---
---Application search key
---
---@field appsearch integer
---
---Application home key
---
---@field apphome integer
---
---Application back key
---
---@field appback integer
---
---Application forward key
---
---@field appforward integer
---
---Application refresh key
---
---@field apprefresh integer
---
---Application bookmarks key
---
---@field appbookmarks integer

---
---Keyboard scancodes.
---
---Scancodes are keyboard layout-independent, so the scancode "w" will be generated if the key in the same place as the "w" key on an American QWERTY keyboard is pressed, no matter what the key is labelled or what the user's operating system settings are.
---
---Using scancodes, rather than keycodes, is useful because keyboards with layouts differing from the US/UK layout(s) might have keys that generate 'unknown' keycodes, but the scancodes will still be detected. This however would necessitate having a list for each keyboard layout one would choose to support.
---
---One could use textinput or textedited instead, but those only give back the end result of keys used, i.e. you can't get modifiers on their own from it, only the final symbols that were generated.
---
---@class love.Scancode
---
---The 'A' key on an American layout.
---
---@field a integer
---
---The 'B' key on an American layout.
---
---@field b integer
---
---The 'C' key on an American layout.
---
---@field c integer
---
---The 'D' key on an American layout.
---
---@field d integer
---
---The 'E' key on an American layout.
---
---@field e integer
---
---The 'F' key on an American layout.
---
---@field f integer
---
---The 'G' key on an American layout.
---
---@field g integer
---
---The 'H' key on an American layout.
---
---@field h integer
---
---The 'I' key on an American layout.
---
---@field i integer
---
---The 'J' key on an American layout.
---
---@field j integer
---
---The 'K' key on an American layout.
---
---@field k integer
---
---The 'L' key on an American layout.
---
---@field l integer
---
---The 'M' key on an American layout.
---
---@field m integer
---
---The 'N' key on an American layout.
---
---@field n integer
---
---The 'O' key on an American layout.
---
---@field o integer
---
---The 'P' key on an American layout.
---
---@field p integer
---
---The 'Q' key on an American layout.
---
---@field q integer
---
---The 'R' key on an American layout.
---
---@field r integer
---
---The 'S' key on an American layout.
---
---@field s integer
---
---The 'T' key on an American layout.
---
---@field t integer
---
---The 'U' key on an American layout.
---
---@field u integer
---
---The 'V' key on an American layout.
---
---@field v integer
---
---The 'W' key on an American layout.
---
---@field w integer
---
---The 'X' key on an American layout.
---
---@field x integer
---
---The 'Y' key on an American layout.
---
---@field y integer
---
---The 'Z' key on an American layout.
---
---@field z integer
---
---The '1' key on an American layout.
---
---@field ["1"] integer
---
---The '2' key on an American layout.
---
---@field ["2"] integer
---
---The '3' key on an American layout.
---
---@field ["3"] integer
---
---The '4' key on an American layout.
---
---@field ["4"] integer
---
---The '5' key on an American layout.
---
---@field ["5"] integer
---
---The '6' key on an American layout.
---
---@field ["6"] integer
---
---The '7' key on an American layout.
---
---@field ["7"] integer
---
---The '8' key on an American layout.
---
---@field ["8"] integer
---
---The '9' key on an American layout.
---
---@field ["9"] integer
---
---The '0' key on an American layout.
---
---@field ["0"] integer
---
---The 'return' / 'enter' key on an American layout.
---
---@field return integer
---
---The 'escape' key on an American layout.
---
---@field escape integer
---
---The 'backspace' key on an American layout.
---
---@field backspace integer
---
---The 'tab' key on an American layout.
---
---@field tab integer
---
---The spacebar on an American layout.
---
---@field space integer
---
---The minus key on an American layout.
---
---@field ["-"] integer
---
---The equals key on an American layout.
---
---@field ["="] integer
---
---The left-bracket key on an American layout.
---
---@field ["["] integer
---
---The right-bracket key on an American layout.
---
---@field ["]"] integer
---
---The backslash key on an American layout.
---
---@field ["\\"] integer
---
---The non-U.S. hash scancode.
---
---@field ["nonus#"] integer
---
---The semicolon key on an American layout.
---
---@field [";"] integer
---
---The apostrophe key on an American layout.
---
---@field ["'"] integer
---
---The back-tick / grave key on an American layout.
---
---@field ["`"] integer
---
---The comma key on an American layout.
---
---@field [","] integer
---
---The period key on an American layout.
---
---@field ["."] integer
---
---The forward-slash key on an American layout.
---
---@field ["/"] integer
---
---The capslock key on an American layout.
---
---@field capslock integer
---
---The F1 key on an American layout.
---
---@field f1 integer
---
---The F2 key on an American layout.
---
---@field f2 integer
---
---The F3 key on an American layout.
---
---@field f3 integer
---
---The F4 key on an American layout.
---
---@field f4 integer
---
---The F5 key on an American layout.
---
---@field f5 integer
---
---The F6 key on an American layout.
---
---@field f6 integer
---
---The F7 key on an American layout.
---
---@field f7 integer
---
---The F8 key on an American layout.
---
---@field f8 integer
---
---The F9 key on an American layout.
---
---@field f9 integer
---
---The F10 key on an American layout.
---
---@field f10 integer
---
---The F11 key on an American layout.
---
---@field f11 integer
---
---The F12 key on an American layout.
---
---@field f12 integer
---
---The F13 key on an American layout.
---
---@field f13 integer
---
---The F14 key on an American layout.
---
---@field f14 integer
---
---The F15 key on an American layout.
---
---@field f15 integer
---
---The F16 key on an American layout.
---
---@field f16 integer
---
---The F17 key on an American layout.
---
---@field f17 integer
---
---The F18 key on an American layout.
---
---@field f18 integer
---
---The F19 key on an American layout.
---
---@field f19 integer
---
---The F20 key on an American layout.
---
---@field f20 integer
---
---The F21 key on an American layout.
---
---@field f21 integer
---
---The F22 key on an American layout.
---
---@field f22 integer
---
---The F23 key on an American layout.
---
---@field f23 integer
---
---The F24 key on an American layout.
---
---@field f24 integer
---
---The left control key on an American layout.
---
---@field lctrl integer
---
---The left shift key on an American layout.
---
---@field lshift integer
---
---The left alt / option key on an American layout.
---
---@field lalt integer
---
---The left GUI (command / windows / super) key on an American layout.
---
---@field lgui integer
---
---The right control key on an American layout.
---
---@field rctrl integer
---
---The right shift key on an American layout.
---
---@field rshift integer
---
---The right alt / option key on an American layout.
---
---@field ralt integer
---
---The right GUI (command / windows / super) key on an American layout.
---
---@field rgui integer
---
---The printscreen key on an American layout.
---
---@field printscreen integer
---
---The scroll-lock key on an American layout.
---
---@field scrolllock integer
---
---The pause key on an American layout.
---
---@field pause integer
---
---The insert key on an American layout.
---
---@field insert integer
---
---The home key on an American layout.
---
---@field home integer
---
---The numlock / clear key on an American layout.
---
---@field numlock integer
---
---The page-up key on an American layout.
---
---@field pageup integer
---
---The forward-delete key on an American layout.
---
---@field delete integer
---
---The end key on an American layout.
---
---@field end integer
---
---The page-down key on an American layout.
---
---@field pagedown integer
---
---The right-arrow key on an American layout.
---
---@field right integer
---
---The left-arrow key on an American layout.
---
---@field left integer
---
---The down-arrow key on an American layout.
---
---@field down integer
---
---The up-arrow key on an American layout.
---
---@field up integer
---
---The non-U.S. backslash scancode.
---
---@field nonusbackslash integer
---
---The application key on an American layout. Windows contextual menu, compose key.
---
---@field application integer
---
---The 'execute' key on an American layout.
---
---@field execute integer
---
---The 'help' key on an American layout.
---
---@field help integer
---
---The 'menu' key on an American layout.
---
---@field menu integer
---
---The 'select' key on an American layout.
---
---@field select integer
---
---The 'stop' key on an American layout.
---
---@field stop integer
---
---The 'again' key on an American layout.
---
---@field again integer
---
---The 'undo' key on an American layout.
---
---@field undo integer
---
---The 'cut' key on an American layout.
---
---@field cut integer
---
---The 'copy' key on an American layout.
---
---@field copy integer
---
---The 'paste' key on an American layout.
---
---@field paste integer
---
---The 'find' key on an American layout.
---
---@field find integer
---
---The keypad forward-slash key on an American layout.
---
---@field ["kp/"] integer
---
---The keypad '*' key on an American layout.
---
---@field ["kp*"] integer
---
---The keypad minus key on an American layout.
---
---@field ["kp-"] integer
---
---The keypad plus key on an American layout.
---
---@field ["kp+"] integer
---
---The keypad equals key on an American layout.
---
---@field ["kp="] integer
---
---The keypad enter key on an American layout.
---
---@field kpenter integer
---
---The keypad '1' key on an American layout.
---
---@field kp1 integer
---
---The keypad '2' key on an American layout.
---
---@field kp2 integer
---
---The keypad '3' key on an American layout.
---
---@field kp3 integer
---
---The keypad '4' key on an American layout.
---
---@field kp4 integer
---
---The keypad '5' key on an American layout.
---
---@field kp5 integer
---
---The keypad '6' key on an American layout.
---
---@field kp6 integer
---
---The keypad '7' key on an American layout.
---
---@field kp7 integer
---
---The keypad '8' key on an American layout.
---
---@field kp8 integer
---
---The keypad '9' key on an American layout.
---
---@field kp9 integer
---
---The keypad '0' key on an American layout.
---
---@field kp0 integer
---
---The keypad period key on an American layout.
---
---@field ["kp."] integer
---
---The 1st international key on an American layout. Used on Asian keyboards.
---
---@field international1 integer
---
---The 2nd international key on an American layout.
---
---@field international2 integer
---
---The 3rd international  key on an American layout. Yen.
---
---@field international3 integer
---
---The 4th international key on an American layout.
---
---@field international4 integer
---
---The 5th international key on an American layout.
---
---@field international5 integer
---
---The 6th international key on an American layout.
---
---@field international6 integer
---
---The 7th international key on an American layout.
---
---@field international7 integer
---
---The 8th international key on an American layout.
---
---@field international8 integer
---
---The 9th international key on an American layout.
---
---@field international9 integer
---
---Hangul/English toggle scancode.
---
---@field lang1 integer
---
---Hanja conversion scancode.
---
---@field lang2 integer
---
---Katakana scancode.
---
---@field lang3 integer
---
---Hiragana scancode.
---
---@field lang4 integer
---
---Zenkaku/Hankaku scancode.
---
---@field lang5 integer
---
---The mute key on an American layout.
---
---@field mute integer
---
---The volume up key on an American layout.
---
---@field volumeup integer
---
---The volume down key on an American layout.
---
---@field volumedown integer
---
---The audio next track key on an American layout.
---
---@field audionext integer
---
---The audio previous track key on an American layout.
---
---@field audioprev integer
---
---The audio stop key on an American layout.
---
---@field audiostop integer
---
---The audio play key on an American layout.
---
---@field audioplay integer
---
---The audio mute key on an American layout.
---
---@field audiomute integer
---
---The media select key on an American layout.
---
---@field mediaselect integer
---
---The 'WWW' key on an American layout.
---
---@field www integer
---
---The Mail key on an American layout.
---
---@field mail integer
---
---The calculator key on an American layout.
---
---@field calculator integer
---
---The 'computer' key on an American layout.
---
---@field computer integer
---
---The AC Search key on an American layout.
---
---@field acsearch integer
---
---The AC Home key on an American layout.
---
---@field achome integer
---
---The AC Back key on an American layout.
---
---@field acback integer
---
---The AC Forward key on an American layout.
---
---@field acforward integer
---
---Th AC Stop key on an American layout.
---
---@field acstop integer
---
---The AC Refresh key on an American layout.
---
---@field acrefresh integer
---
---The AC Bookmarks key on an American layout.
---
---@field acbookmarks integer
---
---The system power scancode.
---
---@field power integer
---
---The brightness-down scancode.
---
---@field brightnessdown integer
---
---The brightness-up scancode.
---
---@field brightnessup integer
---
---The display switch scancode.
---
---@field displayswitch integer
---
---The keyboard illumination toggle scancode.
---
---@field kbdillumtoggle integer
---
---The keyboard illumination down scancode.
---
---@field kbdillumdown integer
---
---The keyboard illumination up scancode.
---
---@field kbdillumup integer
---
---The eject scancode.
---
---@field eject integer
---
---The system sleep scancode.
---
---@field sleep integer
---
---The alt-erase key on an American layout.
---
---@field alterase integer
---
---The sysreq key on an American layout.
---
---@field sysreq integer
---
---The 'cancel' key on an American layout.
---
---@field cancel integer
---
---The 'clear' key on an American layout.
---
---@field clear integer
---
---The 'prior' key on an American layout.
---
---@field prior integer
---
---The 'return2' key on an American layout.
---
---@field return2 integer
---
---The 'separator' key on an American layout.
---
---@field separator integer
---
---The 'out' key on an American layout.
---
---@field out integer
---
---The 'oper' key on an American layout.
---
---@field oper integer
---
---The 'clearagain' key on an American layout.
---
---@field clearagain integer
---
---The 'crsel' key on an American layout.
---
---@field crsel integer
---
---The 'exsel' key on an American layout.
---
---@field exsel integer
---
---The keypad 00 key on an American layout.
---
---@field kp00 integer
---
---The keypad 000 key on an American layout.
---
---@field kp000 integer
---
---The thousands-separator key on an American layout.
---
---@field thsousandsseparator integer
---
---The decimal separator key on an American layout.
---
---@field decimalseparator integer
---
---The currency unit key on an American layout.
---
---@field currencyunit integer
---
---The currency sub-unit key on an American layout.
---
---@field currencysubunit integer
---
---The 'app1' scancode.
---
---@field app1 integer
---
---The 'app2' scancode.
---
---@field app2 integer
---
---An unknown key.
---
---@field unknown integer
