/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.ws.yahoo.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.ws.yahoo.search.PagedResultsList;
import org.jdesktop.swingx.ws.yahoo.search.ResultsList;
import org.jdesktop.swingx.ws.yahoo.search.YahooSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedResultsArrayList<E>
extends AbstractBean
implements List<E>,
PagedResultsList<E> {
    private int numPages = 0;
    private int currentPageIndex = 0;
    private int resultsPerPage = 10;
    private YahooSearch yahoo;
    private int totalResultsAvailable = 0;
    private int firstResultPosition = 1;
    private List<E> results = new ArrayList();

    @Override
    public int getNumPages() {
        return this.numPages;
    }

    @Override
    public boolean nextPage() {
        if (this.isHasNextPage()) {
            return this.gotoPage(this.currentPageIndex + 1);
        }
        return false;
    }

    @Override
    public boolean previousPage() {
        if (this.isHasPreviousPage()) {
            return this.gotoPage(this.currentPageIndex - 1);
        }
        return false;
    }

    @Override
    public boolean firstPage() {
        if (this.currentPageIndex > 0) {
            return this.gotoPage(0);
        }
        return false;
    }

    @Override
    public boolean lastPage() {
        if (this.currentPageIndex < this.numPages - 1) {
            return this.gotoPage(this.numPages - 1);
        }
        return false;
    }

    @Override
    public boolean gotoPage(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("Index must not be < 0");
        }
        if (index >= this.numPages) {
            throw new IllegalArgumentException("Index must be < the total number of pages");
        }
        if (this.yahoo == null) {
            return false;
        }
        int old = this.currentPageIndex;
        this.currentPageIndex = index;
        this.refresh();
        this.firePropertyChange("currentPageIndex", old, this.currentPageIndex);
        return true;
    }

    @Override
    public boolean isHasPreviousPage() {
        return this.yahoo != null && this.currentPageIndex > 0;
    }

    @Override
    public boolean isHasNextPage() {
        return this.yahoo != null && this.currentPageIndex < this.numPages - 1;
    }

    @Override
    public void refresh() {
        int oldTotalResultsAvailable = this.totalResultsAvailable;
        int oldFirstResultPosition = this.firstResultPosition;
        int oldNumPages = this.numPages;
        if (this.yahoo != null) {
            ResultsList r = this.yahoo.search(this.currentPageIndex * this.resultsPerPage, this.resultsPerPage);
            this.results.clear();
            this.results.addAll(r);
            this.totalResultsAvailable = r.getTotalResultsAvailable();
            this.firstResultPosition = r.getFirstResultPosition();
            this.numPages = this.totalResultsAvailable / this.resultsPerPage;
        } else {
            this.totalResultsAvailable = 0;
            this.firstResultPosition = 1;
            this.numPages = 0;
        }
        this.firePropertyChange("totalResultsAvailable", oldTotalResultsAvailable, this.totalResultsAvailable);
        this.firePropertyChange("firstResultPosition", oldFirstResultPosition, this.firstResultPosition);
        this.firePropertyChange("numPages", oldNumPages, this.numPages);
    }

    @Override
    public final void setYahooSearch(YahooSearch search) {
        YahooSearch old = this.getYahooSearch();
        this.yahoo = search;
        this.firePropertyChange("yahooSearch", (Object)old, (Object)this.getYahooSearch());
    }

    @Override
    public final YahooSearch getYahooSearch() {
        return this.yahoo;
    }

    @Override
    public final int getTotalResultsAvailable() {
        return this.totalResultsAvailable;
    }

    @Override
    public final int getFirstResultPosition() {
        return this.firstResultPosition;
    }

    public final int getCurrentPageIndex() {
        return this.currentPageIndex;
    }

    public final void setResultsPerPage(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("resultsPerPage cannot be <= 0");
        }
        int oldNumPages = this.numPages;
        int oldCurrentPageIndex = this.currentPageIndex;
        boolean oldHasNext = this.isHasNextPage();
        boolean oldHasPrev = this.isHasPreviousPage();
        int old = this.getResultsPerPage();
        this.resultsPerPage = value;
        this.firePropertyChange("resultsPerPage", old, this.getResultsPerPage());
        this.numPages = this.getTotalResultsAvailable() / this.resultsPerPage;
        this.currentPageIndex = this.getFirstResultPosition() / this.resultsPerPage;
        this.firePropertyChange("numPages", oldNumPages, this.numPages);
        this.firePropertyChange("currentPageIndex", oldCurrentPageIndex, this.currentPageIndex);
        this.firePropertyChange("hasNextPage", oldHasNext, this.isHasNextPage());
        this.firePropertyChange("hasPreviousPage", oldHasPrev, this.isHasPreviousPage());
    }

    public final int getResultsPerPage() {
        return this.resultsPerPage;
    }

    @Override
    public int size() {
        return this.results.size();
    }

    @Override
    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.results.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.results.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.results.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.results.toArray(a);
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.results.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.results).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.results).hashCode();
    }

    @Override
    public E get(int index) {
        return this.results.get(index);
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return this.results.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.results.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.results.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.results.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.results.subList(fromIndex, toIndex);
    }
}

