/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.RAFile;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747Path;
import gps.convert.Conv;
import gps.log.in.WindowedFile;
import gps.mvc.MtkController;
import gps.mvc.MtkModel;
import gps.mvc.commands.GpsLinkNmeaCommand;

final class MTKLogDownloadHandler {
    private final MTKLogDownloadContext context = new MTKLogDownloadContext(0);

    protected MTKLogDownloadHandler(MtkController mtkController) {
        this.context.mtkC = mtkController;
        this.context.mtkM = mtkController.getMtkModel();
    }

    protected final void getLogInit(int n, int n2, int n3, BT747Path bT747Path, boolean bl, boolean bl2) {
        this.context.startAddr = 0;
        this.context.endAddr = n2;
        this.context.logRequestStep = n3;
        this.context.logPath = bT747Path;
        this.context.isSmart = bl;
        this.context.disableLogging = bl2;
        MTKLogDownloadContext mTKLogDownloadContext = this.context;
        if (mTKLogDownloadContext.getLogState() == 0) {
            mTKLogDownloadContext.loggingIsActiveBeforeDownload = mTKLogDownloadContext.mtkM.isLoggingActive();
            if (mTKLogDownloadContext.disableLogging && mTKLogDownloadContext.loggingIsActiveBeforeDownload) {
                mTKLogDownloadContext.mtkC.cmd(5);
                mTKLogDownloadContext.mtkC.reqData(7);
            }
        }
        mTKLogDownloadContext.mtkM.postEvent(5);
        if (Generic.isDebug()) {
            Generic.debug((mTKLogDownloadContext.isSmart ? "Smart d" : "D") + "ownload request from " + JavaLibBridge.unsigned2hex(mTKLogDownloadContext.startAddr, 8) + " to " + JavaLibBridge.unsigned2hex(mTKLogDownloadContext.endAddr, 8));
        }
        mTKLogDownloadContext.logDownloadStartAddr = mTKLogDownloadContext.startAddr;
        mTKLogDownloadContext.setLogDownloadEndAddr((mTKLogDownloadContext.endAddr + 65535 & 0xFFFF0000) - 1);
        mTKLogDownloadContext.logNextReqAddr = mTKLogDownloadContext.logDownloadStartAddr;
        mTKLogDownloadContext.setLogNextReadAddr(mTKLogDownloadContext.logDownloadStartAddr);
        mTKLogDownloadContext.usedLogRequestAhead = mTKLogDownloadContext.logRequestStep > 2048 ? 0 : mTKLogDownloadContext.logRequestAhead;
        mTKLogDownloadContext.mtkM.getHandler().setLogOrEraseOngoing(true);
        mTKLogDownloadContext.setLogState(5);
    }

    private void openNewLog(BT747Path bT747Path) throws BT747Exception {
        try {
            if (this.context.logFile != null && this.context.logFile.isOpen()) {
                this.context.logFile.close();
            }
            this.context.logFile = new RAFile(bT747Path, 0);
            this.context.logPath = bT747Path;
            if (this.context.logFile.exists()) {
                this.context.logFile.delete();
            }
            this.context.logFile = new RAFile(bT747Path, 4);
            this.context.logPath = bT747Path;
            this.context.logFile.close();
            this.context.logFile = new RAFile(bT747Path, 2);
            this.context.logPath = bT747Path;
            if (this.context.logFile == null || !this.context.logFile.isOpen()) {
                throw new BT747Exception("open", new Throwable(bT747Path.toString()));
            }
            return;
        }
        catch (BT747Exception bT747Exception) {
            throw bT747Exception;
        }
        catch (Exception exception) {
            Generic.debug("openNewLog", exception);
            throw new BT747Exception("open", new Throwable(bT747Path.toString()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getNextLogPart() {
        do {
            int n;
            int n2;
            block11: {
                if (this.context.getLogState() == 0) return;
                n2 = this.context.getLogDownloadEndAddr() - this.context.logNextReqAddr + 1;
                switch (this.context.getLogState()) {
                    case 2: {
                        if (this.context.getLogDownloadEndAddr() <= this.context.getLogNextReadAddr()) {
                            this.endGetLog();
                        }
                        if (this.context.logNextReqAddr > this.context.getLogNextReadAddr() + this.context.logRequestStep * this.context.usedLogRequestAhead) {
                            break;
                        }
                        break block11;
                    }
                    case 3: {
                        if (this.context.getLogDownloadEndAddr() <= this.context.getLogNextReadAddr()) {
                            this.endGetLog();
                        }
                        if (this.context.logNextReqAddr > this.context.getLogNextReadAddr()) return;
                        if (n2 > 2048) {
                            n2 = 2048;
                        }
                        break block11;
                    }
                }
                return;
            }
            if (n2 <= 0) return;
            if (n2 > this.context.logRequestStep) {
                n2 = this.context.logRequestStep;
            }
            if (n2 > (n = (this.context.logNextReqAddr + 65536 & 0xFFFF0000) - this.context.logNextReqAddr)) {
                n2 = n;
            }
            this.readLog(this.context.logNextReqAddr, n2);
            this.context.logNextReqAddr += n2;
        } while (this.context.getLogState() == 2);
    }

    protected final void analyzeLogPart(int n, String string) {
        int n2 = Conv.hexStringToBytes(string, this.context.readDataBuffer) / 2;
        switch (this.context.getLogState()) {
            case 2: 
            case 3: {
                if (this.context.getLogNextReadAddr() == n) {
                    this.context.setLogState(2);
                    int n3 = 0;
                    if (n2 != 2048 && n2 != this.context.logRequestStep && this.context.getLogNextReadAddr() + n2 != this.context.logNextReqAddr && n2 != (this.context.getLogNextReadAddr() + 65536 & 0xFFFF0000) - this.context.getLogNextReadAddr()) {
                        if (Generic.isDebug()) {
                            Generic.debug("Unexpected datalength: " + JavaLibBridge.unsigned2hex(n2, 8));
                        }
                        this.context.setLogState(3);
                    } else {
                        int n4;
                        int n5;
                        for (n5 = n2; n5 > 0; n5 -= 2048) {
                            n4 = n5;
                            if (n4 > 2048) {
                                n4 = 2048;
                            }
                            try {
                                if (this.context.logFile.writeBytes(this.context.readDataBuffer, n3, n4) != n4) {
                                    this.endGetLog();
                                }
                            }
                            catch (Exception exception) {
                                Generic.debug("analyzeLogPart", exception);
                                this.endGetLog();
                            }
                            n3 += n4;
                        }
                        this.context.setLogNextReadAddr(this.context.getLogNextReadAddr() + n2);
                        if (this.context.getFullLogBlocks && (n - 1 + n2 & 0xFFFF0000) >= n && ((this.context.readDataBuffer[n5 = 0xFFFF & 65536 - (n & 0xFFFF)] & 0xFF) != 255 || (this.context.readDataBuffer[n5 + 1] & 0xFF) != 255)) {
                            n4 = (n & 0xFFFF0000) + 131072 - 1;
                            if (n4 > this.context.mtkM.getLogMemSize() - 1) {
                                n4 = this.context.mtkM.getLogMemSize() - 1;
                            }
                            if (n4 > this.context.getLogDownloadEndAddr()) {
                                this.context.setLogDownloadEndAddr(n4);
                            }
                        }
                    }
                    if (this.context.getLogNextReadAddr() > this.context.getLogDownloadEndAddr()) {
                        this.context.mtkM.postEvent(14);
                        this.endGetLog();
                        break;
                    }
                    this.getNextLogPart();
                    break;
                }
                Generic.debug("Expected:" + JavaLibBridge.unsigned2hex(this.context.getLogNextReadAddr(), 8) + " Got:" + JavaLibBridge.unsigned2hex(n, 8) + " (" + JavaLibBridge.unsigned2hex(n2, 8) + ")", null);
                this.context.setLogState(3);
                break;
            }
            case 1: {
                this.context.setLogState(0);
                if (n == 512 && n2 == 512) {
                    boolean bl = true;
                    for (int i = n2 - 1; i >= 0; --i) {
                        if (this.context.readDataBuffer[i] == this.context.expectedResult[i]) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        BT747Path bT747Path = this.context.logPath;
                        MTKLogDownloadHandler mTKLogDownloadHandler = this;
                        mTKLogDownloadHandler.closeLog();
                        try {
                            mTKLogDownloadHandler.context.logFile = new RAFile(bT747Path, 2);
                            mTKLogDownloadHandler.context.logPath = bT747Path;
                        }
                        catch (Exception exception) {
                            Generic.debug("reOpenLogWrite", exception);
                        }
                        try {
                            this.context.logFile.setPos(this.context.getLogNextReadAddr());
                        }
                        catch (Exception exception) {
                            Generic.debug("C_LOG_CHECK", exception);
                        }
                        if (Generic.isDebug()) {
                            Generic.debug("Starting incremental download from " + JavaLibBridge.unsigned2hex(this.context.getLogNextReadAddr(), 8) + " to " + JavaLibBridge.unsigned2hex(this.context.getLogDownloadEndAddr(), 8));
                        }
                        this.context.setLogState(2);
                        this.getNextLogPart();
                        break;
                    }
                    this.context.setLogState(6);
                    if (Generic.isDebug()) {
                        Generic.debug("Different data - requesting overwrite confirmation");
                    }
                    this.context.mtkM.postEvent(8);
                    break;
                }
                if (Generic.isDebug()) {
                    Generic.debug("Expected:" + JavaLibBridge.unsigned2hex(512, 8) + " Got:" + JavaLibBridge.unsigned2hex(n, 8) + " (" + JavaLibBridge.unsigned2hex(n2, 8) + ")", null);
                }
                this.context.setLogState(1);
            }
        }
        if (this.context.getLogState() == 0) {
            this.context.mtkM.getHandler().setLogOrEraseOngoing(false);
        }
        this.context.mtkM.postEvent(6);
    }

    protected final void replyToOkToOverwrite(boolean bl) throws BT747Exception {
        if (this.context.getLogState() == 6) {
            if (bl) {
                this.openNewLog(this.context.logPath);
                this.context.setLogNextReadAddr(0);
                this.context.setLogState(2);
                return;
            }
            this.endGetLog();
        }
    }

    private void requestCheckBlock() {
        this.readLog(512, 512);
    }

    private void closeLog() {
        try {
            if (this.context.logFile != null && this.context.logFile.isOpen()) {
                this.context.logFile.close();
                this.context.logFile = null;
            }
            return;
        }
        catch (Exception exception) {
            Generic.debug("CloseLog", exception);
            return;
        }
    }

    private void endGetLog() {
        this.context.setLogState(0);
        this.closeLog();
        if (this.context.loggingIsActiveBeforeDownload) {
            this.context.mtkC.cmd(4);
            this.context.mtkC.reqData(7);
        }
        this.context.mtkM.postEvent(7);
    }

    protected final int getStartAddr() {
        return this.context.logDownloadStartAddr;
    }

    protected final void cancelGetLog() {
        this.endGetLog();
    }

    protected final void eraseLog() {
        if (this.context.mtkM.getHandler().isConnected()) {
            this.context.mtkM.getHandler().setEraseOngoing(true);
            this.context.mtkC.doSendCmd(new GpsLinkNmeaCommand("PMTK182,6,1"));
            MTKLogDownloadHandler mTKLogDownloadHandler = this;
            mTKLogDownloadHandler.context.setLogState(4);
            mTKLogDownloadHandler.context.mtkM.getHandler().setLogOrEraseOngoing(true);
            mTKLogDownloadHandler.context.mtkM.getHandler().resetLogTimeOut();
        }
    }

    protected final void recoveryEraseLog() {
        this.context.mtkC.cmd(5);
        this.context.mtkC.reqData(7);
        this.context.mtkC.reqData(15);
        this.context.mtkC.sendCmd(new GpsLinkNmeaCommand("PMTK182,10", false));
        this.context.mtkC.reqData(7);
        this.context.forcedErase = true;
        this.eraseLog();
    }

    protected final void signalEraseDone() {
        this.context.setLogState(0);
        this.context.mtkM.getHandler().setLogOrEraseOngoing(true);
        this.context.mtkM.setEraseOngoing(false);
    }

    protected final void stopErase() {
        if (this.context.mtkM.isEraseOngoing() && this.context.getLogState() == 4) {
            this.context.mtkM.getHandler().updateIgnoreNMEA();
            this.signalEraseDone();
            return;
        }
        this.context.mtkM.setEraseOngoing(false);
    }

    protected final void notifyRun() throws BT747Exception {
        if (this.context.mtkM.getHandler().getOutStandingCmdsCount() == 0 && this.context.getLogState() != 0 && this.context.getLogState() != 4) {
            MTKLogDownloadHandler mTKLogDownloadHandler = this;
            switch (mTKLogDownloadHandler.context.getLogState()) {
                case 2: 
                case 3: {
                    mTKLogDownloadHandler.context.logNextReqAddr = mTKLogDownloadHandler.context.getLogNextReadAddr();
                    mTKLogDownloadHandler.getNextLogPart();
                    return;
                }
                case 1: {
                    mTKLogDownloadHandler.requestCheckBlock();
                    return;
                }
                case 5: {
                    try {
                        if (mTKLogDownloadHandler.context.isSmart && new File(mTKLogDownloadHandler.context.logPath).exists()) {
                            mTKLogDownloadHandler.closeLog();
                            WindowedFile windowedFile = new WindowedFile(mTKLogDownloadHandler.context.logPath, 1);
                            windowedFile.setBufferSize(512);
                            if (windowedFile.isOpen() && windowedFile.getSize() >= 1024) {
                                byte[] byArray;
                                int n;
                                int n2 = 0;
                                do {
                                    byArray = windowedFile.fillBuffer(n2);
                                    n = windowedFile.getBufferFill() >= 2 ? 1 : 0;
                                    if (n != 0) {
                                        int n3 = n = byArray[0] != -1 || byArray[1] != -1 ? 1 : 0;
                                    }
                                    if (n == 0) continue;
                                    int n4 = n = (n2 += 65536) <= (windowedFile.getSize() & 0xFFFF0000) ? 1 : 0;
                                } while (n != 0);
                                if (n2 > windowedFile.getSize()) {
                                    mTKLogDownloadHandler.context.setLogNextReadAddr(windowedFile.getSize());
                                    mTKLogDownloadHandler.context.logNextReqAddr = mTKLogDownloadHandler.context.getLogNextReadAddr();
                                } else {
                                    mTKLogDownloadHandler.context.setLogNextReadAddr(n2 + 512);
                                    do {
                                        byArray = windowedFile.fillBuffer(mTKLogDownloadHandler.context.getLogNextReadAddr());
                                        n = windowedFile.getBufferFill() >= 512 ? 1 : 0;
                                        if (n == 0) continue;
                                        for (n2 = 0; n != 0 && n2 < 512; ++n2) {
                                            n = byArray[n2] == -1 ? 1 : 0;
                                        }
                                        if ((n = n == 0 ? 1 : 0) == 0) continue;
                                        mTKLogDownloadHandler.context.setLogNextReadAddr(mTKLogDownloadHandler.context.getLogNextReadAddr() + 512);
                                    } while (n != 0);
                                    mTKLogDownloadHandler.context.setLogNextReadAddr(mTKLogDownloadHandler.context.getLogNextReadAddr() - 512);
                                    mTKLogDownloadHandler.context.logNextReqAddr = mTKLogDownloadHandler.context.getLogNextReadAddr();
                                }
                                int n5 = (mTKLogDownloadHandler.context.getLogNextReadAddr() + 65535 & 0xFFFF0000) - 1;
                                if (n5 > mTKLogDownloadHandler.context.getLogDownloadEndAddr()) {
                                    if (Generic.isDebug()) {
                                        Generic.debug("Adjusted end address from " + JavaLibBridge.unsigned2hex(mTKLogDownloadHandler.context.getLogDownloadEndAddr(), 8) + " to " + JavaLibBridge.unsigned2hex(n5, 8));
                                    }
                                    mTKLogDownloadHandler.context.setLogDownloadEndAddr(n5);
                                }
                                mTKLogDownloadHandler.context.expectedResult = new byte[512];
                                byte[] byArray2 = windowedFile.fillBuffer(512);
                                for (n = mTKLogDownloadHandler.context.expectedResult.length - 1; n >= 0; --n) {
                                    mTKLogDownloadHandler.context.expectedResult[n] = byArray2[n];
                                }
                                mTKLogDownloadHandler.context.setLogState(1);
                                mTKLogDownloadHandler.context.mtkM.getHandler().resetLogTimeOut();
                                mTKLogDownloadHandler.requestCheckBlock();
                            }
                            mTKLogDownloadHandler.context.mtkM.getHandler().updateIgnoreNMEA();
                            windowedFile.close();
                        }
                        if (mTKLogDownloadHandler.context.getLogState() != 1) {
                            mTKLogDownloadHandler.openNewLog(mTKLogDownloadHandler.context.logPath);
                            if (Generic.isDebug()) {
                                Generic.debug("Starting download from " + JavaLibBridge.unsigned2hex(mTKLogDownloadHandler.context.getLogNextReadAddr(), 8) + " to " + JavaLibBridge.unsigned2hex(mTKLogDownloadHandler.context.getLogDownloadEndAddr(), 8));
                            }
                            mTKLogDownloadHandler.context.setLogState(2);
                        }
                        if (mTKLogDownloadHandler.context.getLogState() == 0) {
                            mTKLogDownloadHandler.context.mtkM.postEvent(7);
                        }
                        return;
                    }
                    catch (BT747Exception bT747Exception) {
                        mTKLogDownloadHandler.context.setLogState(0);
                        mTKLogDownloadHandler.context.mtkM.postEvent(7);
                        throw bT747Exception;
                    }
                    catch (Exception exception) {
                        mTKLogDownloadHandler.context.setLogState(0);
                        mTKLogDownloadHandler.context.mtkM.postEvent(7);
                        Generic.debug("getLogInit", exception);
                    }
                }
            }
            return;
        }
        if (this.context.getLogState() == 2) {
            this.getNextLogPart();
            return;
        }
        if (this.context.getLogState() == 4 && this.context.mtkM.getHandler().timeSinceLastStamp() > 2000) {
            this.context.mtkC.reqData(14);
        }
    }

    protected final void notifyDisconnected() {
        if (this.context.getLogState() != 0) {
            this.endGetLog();
        }
    }

    protected final void handleLogFlashStatReply(String object) {
        if (this.context.getLogState() == 4) {
            switch (JavaLibBridge.toInt((String)object)) {
                case 1: {
                    if (this.context.mtkM.isEraseOngoing()) {
                        this.signalEraseDone();
                    }
                    if (!this.context.forcedErase) break;
                    this.context.forcedErase = false;
                    object = this;
                    ((MTKLogDownloadHandler)object).context.mtkC.reqData(7);
                    ((MTKLogDownloadHandler)object).context.mtkC.reqData(15);
                    ((MTKLogDownloadHandler)object).context.mtkC.sendCmd("PMTK182,9");
                    ((MTKLogDownloadHandler)object).context.mtkC.reqData(15);
                    ((MTKLogDownloadHandler)object).context.mtkC.reqData(7);
                }
            }
        }
    }

    protected final void readLog(int n, int n2) {
        this.context.mtkC.sendCmd("PMTK182,7," + JavaLibBridge.unsigned2hex(n, 8) + "," + JavaLibBridge.unsigned2hex(n2, 8));
    }

    protected final void setLogRequestAhead(int n) {
        this.context.logRequestAhead = n;
    }

    static final class MTKLogDownloadContext {
        protected MtkModel mtkM;
        protected MtkController mtkC;
        private int logState = 0;
        private int logDownloadEndAddr;
        private int logNextReadAddr;
        protected RAFile logFile = null;
        protected BT747Path logPath = null;
        protected int startAddr;
        protected int endAddr;
        protected int logNextReqAddr;
        protected int logRequestStep;
        protected boolean isSmart = true;
        protected boolean disableLogging;
        protected boolean loggingIsActiveBeforeDownload = false;
        protected int logDownloadStartAddr;
        protected int logRequestAhead = 0;
        protected byte[] expectedResult;
        protected boolean forcedErase = false;
        protected boolean getFullLogBlocks = true;
        protected int usedLogRequestAhead = 0;
        protected final byte[] readDataBuffer = new byte[2048];

        private MTKLogDownloadContext() {
        }

        protected final void setLogState(int n) {
            this.logState = n;
            switch (n) {
                case 0: 
                case 4: {
                    this.mtkM.setLogDownloadOngoing(false);
                    return;
                }
            }
            this.mtkM.setLogDownloadOngoing(true);
        }

        protected final int getLogState() {
            return this.logState;
        }

        protected final void setLogDownloadEndAddr(int n) {
            this.logDownloadEndAddr = n;
            this.mtkM.setEndAddr(n);
        }

        protected final int getLogDownloadEndAddr() {
            return this.logDownloadEndAddr;
        }

        protected final void setLogNextReadAddr(int n) {
            this.logNextReadAddr = n;
            this.mtkM.setNextReadAddr(n);
        }

        protected final int getLogNextReadAddr() {
            return this.logNextReadAddr;
        }

        /* synthetic */ MTKLogDownloadContext(byte by) {
            this();
        }
    }
}

