/*
 * Decompiled with CFR 0.152.
 */
package org.protege.xmlcatalog.parser;

import java.net.URI;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.protege.xmlcatalog.Prefer;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.XmlBaseContext;
import org.protege.xmlcatalog.entry.DelegatePublicEntry;
import org.protege.xmlcatalog.entry.DelegateSystemEntry;
import org.protege.xmlcatalog.entry.DelegateUriEntry;
import org.protege.xmlcatalog.entry.Entry;
import org.protege.xmlcatalog.entry.GroupEntry;
import org.protege.xmlcatalog.entry.NextCatalogEntry;
import org.protege.xmlcatalog.entry.PublicEntry;
import org.protege.xmlcatalog.entry.RewriteSystemEntry;
import org.protege.xmlcatalog.entry.RewriteUriEntry;
import org.protege.xmlcatalog.entry.SystemEntry;
import org.protege.xmlcatalog.entry.UriEntry;
import org.protege.xmlcatalog.parser.OuterXmlBaseContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Handler
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger(Handler.class);
    public static final String CATALOG_NAMESPACE = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    public static final String CATALOG_ELEMENT = "catalog";
    public static final String GROUP_ELEMENT = "group";
    public static final String PUBLIC_ELEMENT = "public";
    public static final String SYSTEM_ELEMENT = "system";
    public static final String REWRITE_SYSTEM_ELEMENT = "rewriteSystem";
    public static final String DELEGATE_PUBLIC_ELEMENT = "delegatePublic";
    public static final String DELEGATE_SYSTEM_ELEMENT = "delegateSystem";
    public static final String URI_ELEMENT = "uri";
    public static final String REWRITE_URI_ELEMENT = "rewriteURI";
    public static final String DELEGATE_URI_ELEMENT = "delegateURI";
    public static final String NEXT_CATALOG_ELEMENT = "nextCatalog";
    public static final String ID_ATTRIBUTE = "id";
    public static final String PREFER_ATTRIBUTE = "prefer";
    public static final String XML_BASE_ATTRIBUTE = "xml:base";
    public static final String PUBLIC_ID_ATTRIBUTE = "publicId";
    public static final String URI_ATTRIBUTE = "uri";
    public static final String SYSTEM_ID_ATTRIBUTE = "systemId";
    public static final String SYSTEM_ID_START_ATTRIBUTE = "systemIdStartString";
    public static final String REWRITE_PREFIX_ATTRIBUTE = "rewritePrefix";
    public static final String PUBLIC_ID_START_ATTRIBUTE = "publicIdStartString";
    public static final String URI_NAME_ATTRIBUTE = "name";
    public static final String URI_START_STRING = "uriStartString";
    public static final String CATALOG_ATTRIBUTE = "catalog";
    public static final String PREFER_PUBLIC_VALUE = "public";
    public static final String PREFER_SYSTEM_VALUE = "system";
    private XMLCatalog catalog;
    private XmlBaseContext outerContext;
    private Stack<GroupEntry> groupStack = new Stack();

    public Handler() {
    }

    public Handler(URI xmlbase) {
        this(new OuterXmlBaseContext(xmlbase));
    }

    public Handler(XmlBaseContext context) {
        this.outerContext = context;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!CATALOG_NAMESPACE.equals(uri)) {
            logger.warn((Object)"Found entry outside the XML Catalogs namespace - ignored");
        } else if (localName.equals("catalog")) {
            this.catalog = new XMLCatalog(this.getId(attributes), this.outerContext, this.getPrefer(attributes), this.getXmlBase(attributes));
        } else if (localName.equals(GROUP_ELEMENT)) {
            GroupEntry group = new GroupEntry(this.getId(attributes), this.getXmlBaseContext(), this.getPrefer(attributes), this.getXmlBase(attributes));
            this.addEntry(group);
            this.groupStack.push(group);
        } else if (localName.equals("public")) {
            this.addEntry(new PublicEntry(this.getId(attributes), this.getXmlBaseContext(), attributes.getValue(PUBLIC_ID_ATTRIBUTE), URI.create(attributes.getValue("uri")), this.getXmlBase(attributes)));
        } else if (localName.equals("system")) {
            this.addEntry(new SystemEntry(this.getId(attributes), this.getXmlBaseContext(), attributes.getValue(SYSTEM_ID_ATTRIBUTE), URI.create(attributes.getValue("uri")), this.getXmlBase(attributes)));
        } else if (localName.equals(REWRITE_SYSTEM_ELEMENT)) {
            this.addEntry(new RewriteSystemEntry(this.getId(attributes), this.getXmlBaseContext(), attributes.getValue(SYSTEM_ID_START_ATTRIBUTE), URI.create(attributes.getValue(REWRITE_PREFIX_ATTRIBUTE))));
        } else if (localName.equals(DELEGATE_PUBLIC_ELEMENT)) {
            this.addEntry(new DelegatePublicEntry(this.getId(attributes), this.getXmlBaseContext(), attributes.getValue(PUBLIC_ID_START_ATTRIBUTE), URI.create(attributes.getValue("catalog")), this.getXmlBase(attributes)));
        } else if (localName.equals(DELEGATE_SYSTEM_ELEMENT)) {
            this.addEntry(new DelegateSystemEntry(this.getId(attributes), this.getXmlBaseContext(), attributes.getValue(SYSTEM_ID_START_ATTRIBUTE), URI.create(attributes.getValue("catalog")), this.getXmlBase(attributes)));
        } else if (localName.equals("uri")) {
            this.addEntry(new UriEntry(this.getId(attributes), this.getXmlBaseContext(), attributes.getValue(URI_NAME_ATTRIBUTE), URI.create(attributes.getValue("uri")), this.getXmlBase(attributes)));
        } else if (localName.equals(REWRITE_URI_ELEMENT)) {
            this.addEntry(new RewriteUriEntry(this.getId(attributes), this.getXmlBaseContext(), attributes.getValue(URI_START_STRING), URI.create(attributes.getValue(REWRITE_PREFIX_ATTRIBUTE))));
        } else if (localName.equals(DELEGATE_URI_ELEMENT)) {
            this.addEntry(new DelegateUriEntry(this.getId(attributes), this.getXmlBaseContext(), attributes.getValue(URI_START_STRING), URI.create(attributes.getValue("catalog")), this.getXmlBase(attributes)));
        } else if (localName.equals(NEXT_CATALOG_ELEMENT)) {
            this.addEntry(new NextCatalogEntry(this.getId(attributes), this.getXmlBaseContext(), URI.create(attributes.getValue("catalog")), this.getXmlBase(attributes)));
        } else {
            logger.error((Object)("Found unsupported element in xmlcatalog: " + localName));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (uri.equals(CATALOG_NAMESPACE) && localName.equals(GROUP_ELEMENT)) {
            this.groupStack.pop();
        }
    }

    public XMLCatalog getCatalog() {
        return this.catalog;
    }

    private void addEntry(Entry entry) {
        if (this.groupStack.isEmpty()) {
            this.catalog.addEntry(entry);
        } else {
            this.groupStack.peek().addEntry(entry);
        }
    }

    private String getId(Attributes attributes) {
        return attributes.getValue(ID_ATTRIBUTE);
    }

    private Prefer getPrefer() {
        if (this.groupStack.isEmpty()) {
            return this.catalog.getPrefer();
        }
        return this.groupStack.peek().getPrefer();
    }

    private Prefer getPrefer(Attributes attributes) {
        String preferString = attributes.getValue(PREFER_ATTRIBUTE);
        if (preferString == null && this.catalog == null) {
            return null;
        }
        if (preferString == null) {
            return this.getPrefer();
        }
        if (preferString.toLowerCase().equals("public")) {
            return Prefer.PUBLIC;
        }
        if (preferString.toLowerCase().equals("system")) {
            return Prefer.SYSTEM;
        }
        return null;
    }

    private URI getXmlBase(Attributes attributes) {
        String baseString = attributes.getValue(XML_BASE_ATTRIBUTE);
        if (baseString != null) {
            return URI.create(baseString);
        }
        return null;
    }

    private XmlBaseContext getXmlBaseContext() {
        if (this.groupStack.isEmpty()) {
            return this.catalog;
        }
        return this.groupStack.peek();
    }
}

