/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.databaseconnector;

import java.sql.Connection;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.InformationSchemaViewsBuilder;
import schemacrawler.schemacrawler.LimitOptionsBuilder;
import schemacrawler.schemacrawler.Options;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectionSource;
import schemacrawler.tools.databaseconnector.DatabaseConnectionUrlBuilder;
import schemacrawler.tools.databaseconnector.DatabaseServerHostConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseUrlConnectionOptions;
import schemacrawler.tools.databaseconnector.UnknownDatabaseConnector;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.Utility;

public abstract class DatabaseConnector
implements Options {
    public static final DatabaseConnector UNKNOWN = new UnknownDatabaseConnector();
    private final DatabaseServerType dbServerType;
    private final Predicate<String> supportsUrl;
    private final BiConsumer<InformationSchemaViewsBuilder, Connection> informationSchemaViewsBuildProcess;
    private final BiConsumer<SchemaRetrievalOptionsBuilder, Connection> schemaRetrievalOptionsBuildProcess;
    private final Consumer<LimitOptionsBuilder> limitOptionsBuildProcess;
    private final Supplier<DatabaseConnectionUrlBuilder> urlBuildProcess;

    protected DatabaseConnector(DatabaseServerType dbServerType, Predicate<String> supportsUrl, BiConsumer<InformationSchemaViewsBuilder, Connection> informationSchemaViewsBuildProcess, BiConsumer<SchemaRetrievalOptionsBuilder, Connection> schemaRetrievalOptionsBuildProcess, Consumer<LimitOptionsBuilder> limitOptionsBuildProcess, Supplier<DatabaseConnectionUrlBuilder> urlBuildProcess) {
        this.dbServerType = Objects.requireNonNull(dbServerType, "No database server type provided");
        this.supportsUrl = Objects.requireNonNull(supportsUrl, "No predicate for URL support provided");
        this.informationSchemaViewsBuildProcess = Objects.requireNonNull(informationSchemaViewsBuildProcess, "No information schema views build process provided");
        this.schemaRetrievalOptionsBuildProcess = Objects.requireNonNull(schemaRetrievalOptionsBuildProcess, "No schema retrieval options build process provided");
        this.limitOptionsBuildProcess = Objects.requireNonNull(limitOptionsBuildProcess, "No limit options build process provided");
        this.urlBuildProcess = Objects.requireNonNull(urlBuildProcess, "No URL builder provided");
    }

    public final DatabaseServerType getDatabaseServerType() {
        return this.dbServerType;
    }

    public PluginCommand getHelpCommand() {
        PluginCommand pluginCommand = PluginCommand.newDatabasePluginCommand(this.dbServerType.getDatabaseSystemIdentifier(), "** Connect to " + this.dbServerType.getDatabaseSystemName());
        return pluginCommand;
    }

    public final SchemaRetrievalOptionsBuilder getSchemaRetrievalOptionsBuilder(Connection connection) {
        InformationSchemaViews informationSchemaViews = InformationSchemaViewsBuilder.builder().withFunction(this.informationSchemaViewsBuildProcess, connection).toOptions();
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaRetrievalOptionsBuilder.builder().withDatabaseServerType(this.dbServerType).withInformationSchemaViews(informationSchemaViews).fromConnnection(connection);
        this.schemaRetrievalOptionsBuildProcess.accept(schemaRetrievalOptionsBuilder, connection);
        return schemaRetrievalOptionsBuilder;
    }

    public DatabaseConnectionSource newDatabaseConnectionSource(DatabaseConnectionOptions connectionOptions) throws SchemaCrawlerException {
        DatabaseConnectionSource databaseConnectionSource;
        Objects.requireNonNull(connectionOptions, "No database connection options provided");
        if (connectionOptions instanceof DatabaseUrlConnectionOptions) {
            DatabaseUrlConnectionOptions databaseUrlConnectionOptions = (DatabaseUrlConnectionOptions)connectionOptions;
            databaseConnectionSource = new DatabaseConnectionSource(databaseUrlConnectionOptions.getConnectionUrl());
        } else if (connectionOptions instanceof DatabaseServerHostConnectionOptions) {
            DatabaseServerHostConnectionOptions serverHostConnectionOptions = (DatabaseServerHostConnectionOptions)connectionOptions;
            String host = serverHostConnectionOptions.getHost();
            Integer port = serverHostConnectionOptions.getPort();
            String database = serverHostConnectionOptions.getDatabase();
            Map<String, String> urlx = serverHostConnectionOptions.getUrlx();
            DatabaseConnectionUrlBuilder databaseConnectionUrlBuilder = this.urlBuildProcess.get();
            databaseConnectionUrlBuilder.withHost(host);
            databaseConnectionUrlBuilder.withPort(port);
            databaseConnectionUrlBuilder.withDatabase(database);
            databaseConnectionUrlBuilder.withUrlx(urlx);
            String connectionUrl = databaseConnectionUrlBuilder.toURL();
            Map<String, String> connectionUrlx = databaseConnectionUrlBuilder.toUrlx();
            databaseConnectionSource = new DatabaseConnectionSource(connectionUrl, connectionUrlx);
        } else {
            throw new SchemaCrawlerException("Could not create new database connection source");
        }
        return databaseConnectionSource;
    }

    public final SchemaCrawlerOptions setSchemaCrawlerOptionsDefaults(SchemaCrawlerOptions schemaCrawlerOptions) {
        LimitOptionsBuilder limitOptionsBuilder = LimitOptionsBuilder.builder().fromOptions(schemaCrawlerOptions.getLimitOptions());
        this.limitOptionsBuildProcess.accept(limitOptionsBuilder);
        return schemaCrawlerOptions.withLimitOptions(limitOptionsBuilder.toOptions());
    }

    public final boolean supportsUrl(String url) {
        if (Utility.isBlank((CharSequence)url)) {
            return false;
        }
        return this.supportsUrl.test(url);
    }

    public String toString() {
        if (this.dbServerType.isUnknownDatabaseSystem()) {
            return "Database connector for unknown database system type";
        }
        return "Database connector for " + this.dbServerType;
    }
}

