/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.sql.Connection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import picocli.CommandLine;
import schemacrawler.schema.Catalog;
import schemacrawler.schemacrawler.InfoLevel;
import schemacrawler.schemacrawler.LoadOptionsBuilder;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.tools.commandline.state.BaseStateHolder;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.utility.CommandLineUtility;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.utility.SchemaCrawlerUtility;
import us.fatehi.utility.string.ObjectToStringFormat;
import us.fatehi.utility.string.StringFormat;

@CommandLine.Command(name="load", header={"** Load database metadata into memory using a chain of catalog loaders"}, description={""}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"load"}, optionListHeading="Options:%n", footer={"", "For additional options, specific to individual catalog loaders,", "run SchemaCrawler with: `-h loaders`", "or from the SchemaCrawler interactive shell: `help loaders`"})
public class LoadCommand
extends BaseStateHolder
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(LoadCommand.class.getName());
    @CommandLine.Option(names={"-i", "--info-level"}, required=true, description={"<infolevel> is one of ${COMPLETION-CANDIDATES}", "The info level determines the amount of database metadata retrieved, and also determines the time taken to crawl the schema", "Optional, defaults to standard"})
    private InfoLevel infolevel;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    public LoadCommand(ShellState state) {
        super(state);
    }

    public InfoLevel getInfoLevel() {
        return this.infolevel;
    }

    @Override
    public void run() {
        try {
            this.saveCommandOptions();
            if (this.state.isDeferCatalogLoad()) {
                LOGGER.log(Level.CONFIG, "Not loading catalog, since this is deferred");
                return;
            }
            if (!this.state.isConnected()) {
                throw new CommandLine.ExecutionException(this.spec.commandLine(), "Not connected to the database");
            }
            Catalog catalog = this.loadCatalog();
            this.state.setCatalog(catalog);
            LOGGER.log(Level.INFO, "Loaded catalog");
        }
        catch (Exception e) {
            throw new CommandLine.ExecutionException(this.spec.commandLine(), "Cannot load catalog", (Throwable)e);
        }
    }

    private Catalog loadCatalog() {
        Catalog catalog;
        block8: {
            Connection connection = this.state.getDataSource().get();
            try {
                LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("infolevel=%s", new Object[]{this.infolevel}));
                SchemaRetrievalOptions schemaRetrievalOptions = this.state.getSchemaRetrievalOptions();
                SchemaCrawlerOptions schemaCrawlerOptions = this.state.getSchemaCrawlerOptions();
                Config additionalConfig = this.state.getConfig();
                catalog = SchemaCrawlerUtility.getCatalog((Connection)connection, (SchemaRetrievalOptions)schemaRetrievalOptions, (SchemaCrawlerOptions)schemaCrawlerOptions, (Config)additionalConfig);
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new CommandLine.ExecutionException(this.spec.commandLine(), "Cannot load catalog", (Throwable)e);
                }
            }
            connection.close();
        }
        return catalog;
    }

    private void saveCommandOptions() throws SchemaCrawlerException {
        SchemaCrawlerOptions schemaCrawlerOptions = this.state.getSchemaCrawlerOptions();
        LoadOptionsBuilder loadOptionsBuilder = LoadOptionsBuilder.builder().fromOptions(schemaCrawlerOptions.getLoadOptions());
        if (this.infolevel != null) {
            loadOptionsBuilder.withSchemaInfoLevel(this.infolevel.toSchemaInfoLevel());
        }
        this.state.withLoadOptions(loadOptionsBuilder.toOptions());
        CommandLine.ParseResult parseResult = this.spec.commandLine().getParseResult();
        Map<String, Object> catalogLoaderOptions = CommandLineUtility.matchedOptionValues(parseResult);
        LOGGER.log(Level.INFO, "Loaded command loader options");
        LOGGER.log(Level.CONFIG, (Supplier<String>)new ObjectToStringFormat(catalogLoaderOptions));
        this.state.setCatalogLoaderOptions(catalogLoaderOptions);
    }
}

