/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.jcc.dbpool;

import com.ibm.db2.jcc.DB2ConnectionPoolDataSource;
import com.ibm.db2.jcc.DB2Driver;
import com.ibm.db2.jcc.DB2PooledConnection;
import com.ibm.db2.jcc.DB2SimpleDataSource;
import com.ibm.db2.jcc.am.du;
import com.ibm.db2.jcc.am.k9;
import com.ibm.db2.jcc.dbpool.DB2BaseConnectionPool;
import com.ibm.db2.jcc.dbpool.b;
import com.ibm.db2.jcc.dbpool.c;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public final class DB2ConnectionPool
extends DB2BaseConnectionPool {
    private b connectionEventHandler;
    private c poolInfo = new c(this);

    public DB2ConnectionPool() {
        this.connectionEventHandler = new b(this);
    }

    public DB2ConnectionPool(DB2SimpleDataSource dB2SimpleDataSource) throws SQLException {
        this.connectionEventHandler = new b(this);
        this.initializePooolableDataSource(dB2SimpleDataSource);
        this.createPool();
    }

    public DB2ConnectionPool(DB2ConnectionPoolDataSource dB2ConnectionPoolDataSource) throws SQLException {
        this.connectionEventHandler = new b(this);
        this.initializePooolableDataSource(dB2ConnectionPoolDataSource);
        this.createPool();
    }

    public DB2ConnectionPool(String string, Properties properties) throws SQLException {
        this.connectionEventHandler = new b(this);
        if (properties == null) {
            properties = new Properties();
        }
        properties.put("JCC_INTERNAL_KEY_TO_GET_INTERNAL_DATASOURCE_dbpoolcrt_", "JCC_INTERNAL_KEY_TO_GET_INTERNAL_DATASOURCE_dbpoolcrt_");
        new DB2Driver().connect(string, properties);
        DB2SimpleDataSource dB2SimpleDataSource = (DB2SimpleDataSource)properties.remove("JCC_INTERNAL_KEY_TO_GET_INTERNAL_DATASOURCE_dbpoolcrt_");
        this.initializePooolableDataSource(dB2SimpleDataSource);
    }

    @Override
    public String getPoolStats() {
        if (this.poolInfo != null) {
            return this.poolInfo.e();
        }
        return "pool not intitalized";
    }

    @Override
    protected void onExit(StringBuilder stringBuilder) {
        this.poolInfo.a("OnExit close:" + this.poolInfo.e());
    }

    private Connection getNewConn() throws SQLException {
        int n2 = 1;
        int n3 = 0;
        while (n3 < this.getAcquireRetryAttempts()) {
            try {
                DB2PooledConnection dB2PooledConnection = this.createPool();
                try {
                    if (this.testConnectionOnCheckin) {
                        this.testConnection();
                    }
                }
                catch (SQLException sQLException) {
                    throw DB2ConnectionPool.b(sQLException);
                }
                this.poolInfo.b(dB2PooledConnection);
                du du2 = (du)dB2PooledConnection.getConnection();
                return du2;
            }
            catch (SQLException sQLException) {
                try {
                    if (n2 >= this.getAcquireRetryAttempts()) {
                        throw sQLException;
                    }
                }
                catch (SQLException sQLException2) {
                    throw DB2ConnectionPool.b(sQLException2);
                }
                try {
                    if (this.getAcquireRetryDelay() > 0) {
                        this.sleep(this.getAcquireRetryDelay());
                    }
                }
                catch (SQLException sQLException3) {
                    throw DB2ConnectionPool.b(sQLException3);
                }
                ++n2;
                ++n2;
            }
        }
        return null;
    }

    public Connection getConnection() throws SQLException {
        DB2PooledConnection dB2PooledConnection = this.poolInfo.c();
        if (dB2PooledConnection != null) {
            du du2 = (du)dB2PooledConnection.getConnection();
            return du2;
        }
        int n2 = this.poolInfo.a();
        try {
            if (n2 >= this.maxPoolSize) {
                throw new SQLException("Pool max size of" + this.maxPoolSize + " exceeded, current size of " + n2 + " connections " + this.poolInfo.e());
            }
        }
        catch (SQLException sQLException) {
            throw DB2ConnectionPool.b(sQLException);
        }
        return this.getNewConn();
    }

    public int getUsedConnectionsCount() {
        return this.poolInfo.a();
    }

    public int getFreeConnectionsCount() {
        return this.maxPoolSize - this.poolInfo.a();
    }

    public int getTotalConnections() {
        return this.maxPoolSize;
    }

    public void testConnection() throws SQLException {
        Connection connection = this.getConnection();
        k9 k92 = (k9)connection.createStatement();
        ResultSet resultSet = k92.executeQuery(this.preferredTestQuery);
        if (resultSet.next()) {
            Date date = resultSet.getDate(1);
        }
        resultSet.close();
        k92.close();
        connection.close();
    }

    synchronized DB2PooledConnection createPool() throws SQLException {
        DB2PooledConnection dB2PooledConnection = (DB2PooledConnection)this.sds.getPooledConnection(this.sds.getUser(), this.retrievePassword());
        dB2PooledConnection.addConnectionEventListener(this.connectionEventHandler);
        return dB2PooledConnection;
    }

    private String retrievePassword() {
        block5: {
            block4: {
                String string = "";
                try {
                    if (this.password != null && this.password.length() > 1) break block4;
                }
                catch (Exception exception) {
                    throw DB2ConnectionPool.b(exception);
                }
                try {
                    Field field = this.sds.getClass().getDeclaredField("password");
                    field.setAccessible(true);
                    string = field.get(this.sds) + "";
                    return string;
                }
                catch (Exception exception) {
                    this.logPoolInfo("exception while getting password", exception.toString());
                }
                break block5;
            }
            return this.password;
        }
        return "";
    }

    static c access$000(DB2ConnectionPool dB2ConnectionPool) {
        return dB2ConnectionPool.poolInfo;
    }

    static b access$100(DB2ConnectionPool dB2ConnectionPool) {
        return dB2ConnectionPool.connectionEventHandler;
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

