/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.util;

import java.beans.BeanInfo;
import java.beans.Beans;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sqlj.framework.error.ErrorLog;
import sqlj.framework.error.Info;
import sqlj.framework.error.JSError;
import sqlj.framework.error.LogEntry;
import sqlj.framework.error.Position;
import sqlj.framework.error.Warning;
import sqlj.framework.ide.TranslationOptionsQuery;
import sqlj.framework.options.ConnectionFactory;
import sqlj.mesg.CustomizerHarnessErrors;
import sqlj.runtime.profile.DefaultLoader;
import sqlj.runtime.profile.Loader;
import sqlj.runtime.profile.Profile;
import sqlj.runtime.profile.util.ProfileCustomizer;
import sqlj.runtime.profile.util.ProfileIOContext;

public class CustomizerHarness {
    private ConnectionFactory m_connFact = new ConnectionFactory();
    private ProfileCustomizer m_customizer = null;
    private boolean m_help = false;
    private boolean m_backup = false;
    private String m_contextList = null;
    private Hashtable m_contextTable = new Hashtable();
    private String m_driverList = null;
    private Hashtable m_driverTable = new Hashtable();
    private String m_digests;
    private MessageDigest[] m_digestArray;
    private Connection m_conn = null;
    private boolean m_verbose = false;
    private static final String[] SHARED_OPTIONS = new String[]{"verbose"};

    public CustomizerHarness() {
        this.setDigests("SHA,MD5");
        this.setDriver(ConnectionFactory.DRIVER_DEFAULT);
    }

    public ProfileCustomizer getCustomizer() {
        return this.m_customizer;
    }

    public void setCustomizer(ProfileCustomizer profileCustomizer) {
        this.m_customizer = profileCustomizer;
    }

    public boolean getHelp() {
        return this.m_help;
    }

    public void setHelp(boolean bl2) {
        this.m_help = bl2;
    }

    public boolean getBackup() {
        return this.m_backup;
    }

    public void setBackup(boolean bl2) {
        this.m_backup = bl2;
    }

    public int customize(String string, ErrorLog errorLog) {
        int n2;
        String string2 = errorLog.getFileName();
        errorLog.setFileName(string);
        if (string.endsWith(".jar")) {
            n2 = this.customizeJar(string, errorLog);
        } else if (string.endsWith(".ser")) {
            n2 = this.customizeSer(string, errorLog);
        } else {
            throw new IllegalArgumentException(CustomizerHarnessErrors.bad_filename((String)string));
        }
        this.logStatus(errorLog, n2);
        errorLog.setFileName(string2);
        return n2;
    }

    public int customizeJar(String string, ErrorLog errorLog) {
        try {
            JarIOContext jarIOContext = new JarIOContext(string, this.getBackup(), errorLog);
            return this.customizeJar(jarIOContext);
        }
        catch (IOException iOException) {
            this.logError(errorLog, iOException);
            return 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int customizeJar(ProfileIOContext profileIOContext) {
        int n2 = 5;
        try {
            JarProfiles jarProfiles = new JarProfiles(profileIOContext, this.getDigestArray());
            n2 = this.customizeProfiles(jarProfiles);
            jarProfiles.close(n2);
        }
        catch (IOException iOException) {
            this.logError(profileIOContext.getErrorLog(), iOException);
            n2 = 5;
        }
        finally {
            try {
                profileIOContext.close(n2);
            }
            catch (IOException iOException) {
                this.logError(profileIOContext.getErrorLog(), iOException);
                n2 = 5;
            }
        }
        return n2;
    }

    private void logError(ErrorLog errorLog, Exception exception) {
        errorLog.addEntry((LogEntry)new JSError((Object)exception.toString()));
    }

    public int customizeProfiles(Enumeration enumeration) {
        int n2 = 3;
        while (enumeration.hasMoreElements()) {
            int n3 = this.customizeProfile((ProfileIOContext)enumeration.nextElement());
            switch (n3) {
                case 5: {
                    return 5;
                }
                case 4: {
                    n2 = 4;
                    break;
                }
            }
        }
        return n2;
    }

    private void logStatus(ErrorLog errorLog, int n2) {
        if (!this.isVerbose()) {
            return;
        }
        switch (n2) {
            case 4: {
                errorLog.addEntry((LogEntry)new Info((Object)CustomizerHarnessErrors.customized()));
                break;
            }
            case 3: {
                errorLog.addEntry((LogEntry)new Info((Object)CustomizerHarnessErrors.unchanged()));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int customizeProfile(ProfileIOContext profileIOContext) {
        Status status;
        block31: {
            ErrorLog errorLog = profileIOContext.getErrorLog();
            Loader loader = profileIOContext.getLoader();
            status = new Status(errorLog);
            try {
                Profile profile = Profile.instantiate(loader, profileIOContext.getInputStream());
                if (!this.hasValidContext(profile)) {
                    if (this.isVerbose()) {
                        errorLog.addEntry((LogEntry)new Info((Object)CustomizerHarnessErrors.ignoring_context((String)profile.getContextName())));
                    }
                    int n2 = status.getStatus();
                    return n2;
                }
                Connection connection = this.getConnection(errorLog);
                boolean bl2 = this.getCustomizer().customize(profile, connection, errorLog);
                if (!bl2 || status.getStatus() == 5) break block31;
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(profileIOContext.getOutputStream());
                try {
                    objectOutputStream.writeObject(profile);
                }
                finally {
                    objectOutputStream.close();
                }
                status.setStatus(4);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                errorLog.addEntry((LogEntry)new JSError((Object)noClassDefFoundError.toString()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                this.logError(errorLog, classNotFoundException);
            }
            catch (IOException iOException) {
                this.logError(errorLog, iOException);
            }
            catch (SQLException sQLException) {
                this.logError(errorLog, sQLException);
            }
            finally {
                try {
                    profileIOContext.close(status.getStatus());
                }
                catch (IOException iOException) {
                    this.logError(errorLog, iOException);
                }
            }
        }
        return status.getStatus();
    }

    static File createUnique(String string, String string2) {
        String string3 = string + "." + string2;
        File file = new File(string3);
        int n2 = 1;
        while (file.exists()) {
            string3 = string + "." + string2 + n2;
            file = new File(string3);
            ++n2;
        }
        return file;
    }

    static void createBackup(String string, ErrorLog errorLog) throws IOException {
        File file = new File(string);
        File file2 = CustomizerHarness.createUnique(string, "bak");
        if (!file.renameTo(file2)) {
            throw new IOException(CustomizerHarnessErrors.cannot_create_backup());
        }
        errorLog.addEntry((LogEntry)new Info((Object)CustomizerHarnessErrors.backup_created((String)file2.getPath())));
    }

    public int customizeSer(String string, ErrorLog errorLog) {
        return this.customizeProfile(new FileIOContext(string, this.getBackup(), errorLog, null));
    }

    public String getContext() {
        return this.m_contextList;
    }

    public void setContext(String string) {
        this.m_contextList = string;
        this.parseListString(string, this.m_contextTable);
    }

    public boolean hasValidContext(Profile profile) {
        return this.m_contextList == null || this.m_contextTable.containsKey(profile.getContextName());
    }

    private void parseListString(String string, Hashtable hashtable) {
        String[] stringArray = this.listToArray(string, ',');
        hashtable.clear();
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            hashtable.put(stringArray[i10], stringArray[i10]);
        }
    }

    private String[] listToArray(String string, char c10) {
        Object object;
        int n2;
        Vector vector = new Vector();
        if (string != null && string.trim().length() > 0) {
            while ((n2 = string.indexOf(c10)) != -1) {
                object = string.substring(0, n2);
                string = string.substring(n2 + 1);
                this.addListItem((String)object, vector);
            }
            this.addListItem(string, vector);
        }
        n2 = vector.size();
        object = new String[n2];
        vector.copyInto((Object[])object);
        return object;
    }

    public String getDriver() {
        return this.m_driverList;
    }

    public void setDriver(String string) {
        this.resetConnection();
        this.m_driverList = string;
        this.parseListString(string, this.m_driverTable);
        this.m_connFact.setDrivers(this.m_driverTable.keys());
    }

    public String getDigests() {
        return this.m_digests;
    }

    public void setDigests(String string) {
        this.m_digests = string;
        this.setDigestArray(this.listToArray(string, ','));
    }

    private MessageDigest[] getDigestArray() {
        return this.m_digestArray;
    }

    private void setDigestArray(String[] stringArray) {
        this.m_digestArray = new MessageDigest[stringArray.length];
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            try {
                this.m_digestArray[i10] = MessageDigest.getInstance(stringArray[i10]);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new IllegalArgumentException(CustomizerHarnessErrors.unknown_digest((String)stringArray[i10]));
            }
        }
    }

    private void addListItem(String string, Vector vector) {
        if ((string = string.trim()).length() == 0) {
            throw new IllegalArgumentException(CustomizerHarnessErrors.empty_list_item());
        }
        vector.addElement(string);
    }

    public Connection getConnection(ErrorLog errorLog) throws SQLException {
        if (this.m_conn == null) {
            this.m_conn = this.m_connFact.getConnection(errorLog);
        }
        return this.m_conn;
    }

    public void setOptionsQuery(TranslationOptionsQuery translationOptionsQuery) {
        this.m_connFact.setOptionsQuery(translationOptionsQuery);
    }

    public TranslationOptionsQuery getOptionsQuery() {
        return this.m_connFact.getOptionsQuery();
    }

    public String getUrl() {
        return this.m_connFact.getURL();
    }

    public void setUrl(String string) {
        this.resetConnection();
        this.m_connFact.setURL(string);
    }

    public String getUrlPrefix() {
        return this.m_connFact.getURLPrefix();
    }

    public void setUrlPrefix(String string) {
        this.resetConnection();
        this.m_connFact.setURLPrefix(string);
    }

    public boolean isVerbose() {
        return this.m_verbose;
    }

    public void setVerbose(boolean bl2) {
        this.m_verbose = bl2;
        this.m_connFact.setVerbose(bl2);
    }

    public String getUser() {
        return this.m_connFact.getUser();
    }

    public void setUser(String string) {
        this.resetConnection();
        this.m_connFact.setUser(string);
    }

    public String getPassword() {
        return this.m_connFact.getPassword();
    }

    public void setPassword(String string) {
        this.resetConnection();
        this.m_connFact.setPassword(string);
    }

    private void resetConnection() {
        if (this.m_conn != null) {
            try {
                Connection connection = this.m_conn;
                this.m_conn = null;
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static boolean isValidFilename(String string) {
        return string.endsWith(".ser") || string.endsWith(".jar");
    }

    private boolean checkCustomizer(ErrorLog errorLog) {
        ProfileCustomizer profileCustomizer = this.getCustomizer();
        if (profileCustomizer == null) {
            errorLog.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.no_customizer()));
            return false;
        }
        try {
            if (this.getCustomizer().acceptsConnection(this.getConnection(errorLog))) {
                return true;
            }
            errorLog.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.connection_not_accepted((String)this.getConnectString())));
        }
        catch (SQLException sQLException) {
            errorLog.addEntry((LogEntry)new JSError((Object)sQLException.toString()));
        }
        return false;
    }

    private String getConnectString() {
        return this.m_connFact.toString();
    }

    public static void main(String[] stringArray) {
        System.exit(CustomizerHarness.mainStatus(stringArray));
    }

    public static int mainStatus(String[] stringArray) {
        PrintWriter printWriter = new PrintWriter(System.out, true);
        Log log = new Log(printWriter);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        int n2 = 0;
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            if (stringArray[i10].startsWith("-C")) {
                vector.addElement(stringArray[i10].substring(2));
                continue;
            }
            if (stringArray[i10].startsWith("-")) {
                vector2.addElement(stringArray[i10].substring(1));
                continue;
            }
            if (CustomizerHarness.isValidFilename(stringArray[i10])) {
                vector3.addElement(stringArray[i10]);
                continue;
            }
            log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.invalid_option((String)stringArray[i10])));
        }
        BeanEditor beanEditor = null;
        BeanEditor beanEditor2 = null;
        CustomizerHarness customizerHarness = new CustomizerHarness();
        ProfileCustomizer profileCustomizer = null;
        try {
            int n3;
            beanEditor = new BeanEditor((ErrorLog)log, customizerHarness);
            for (n3 = 0; n3 < vector2.size(); ++n3) {
                beanEditor.setProperty((String)vector2.elementAt(n3));
            }
            profileCustomizer = customizerHarness.getCustomizer();
            if (profileCustomizer != null) {
                beanEditor2 = new BeanEditor((ErrorLog)log, customizerHarness.getCustomizer());
                for (n3 = 0; n3 < vector.size(); ++n3) {
                    beanEditor2.setProperty((String)vector.elementAt(n3));
                }
                for (n3 = 0; n3 < SHARED_OPTIONS.length; ++n3) {
                    beanEditor2.setFrom(SHARED_OPTIONS[n3], beanEditor);
                }
            }
        }
        catch (IntrospectionException introspectionException) {
            log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.cannot_load_harness()));
        }
        if (customizerHarness.getHelp()) {
            CustomizerHarness.printUsage(printWriter, false);
            CustomizerHarness.printOptionSyntax(printWriter);
            if (beanEditor != null) {
                CustomizerHarness.printHelp(beanEditor.getPropertyInfo(), CustomizerHarnessErrors.general_options(), "  -", printWriter);
            }
            if (profileCustomizer != null) {
                CustomizerHarness.printHelp(beanEditor2.getPropertyInfo(), CustomizerHarnessErrors.customizer_options(), "  -C", printWriter);
            }
        } else if (vector3.size() == 0 || log.errorCount() > 0) {
            CustomizerHarness.printUsage(printWriter, true);
            n2 = 1;
        } else {
            if (customizerHarness.checkCustomizer(log)) {
                for (int i11 = 0; i11 < vector3.size(); ++i11) {
                    customizerHarness.customize((String)vector3.elementAt(i11), log);
                }
            }
            log.printSummary();
            if (log.errorCount() > 0) {
                n2 = 1;
            }
        }
        customizerHarness.resetConnection();
        return n2;
    }

    private static void printUsage(PrintWriter printWriter, boolean bl2) {
        String string = CustomizerHarnessErrors.usage();
        String string2 = CustomizerHarnessErrors.options();
        String string3 = CustomizerHarnessErrors.file();
        printWriter.println(string + ": [" + string2 + "] " + string3 + ".ser " + string3 + ".jar ...");
        if (bl2) {
            printWriter.println(CustomizerHarnessErrors.help_desc((String)"-help"));
        }
    }

    private static void printOptionSyntax(PrintWriter printWriter) {
        printWriter.println();
        printWriter.println(CustomizerHarnessErrors.summary_format());
    }

    private static void printHelp(String[][] stringArray, String string, String string2, PrintWriter printWriter) {
        if (stringArray.length == 0) {
            return;
        }
        printWriter.println();
        if (string != null) {
            printWriter.println(string);
        }
        for (int i10 = 0; i10 < stringArray.length; ++i10) {
            if (stringArray[i10] == null) continue;
            CustomizerHarness.printHelp(stringArray[i10], string2, printWriter);
        }
    }

    private static void printHelp(String[] stringArray, String string, PrintWriter printWriter) {
        printWriter.print(string + stringArray[0]);
        if (stringArray[1] != null) {
            printWriter.print(" : " + stringArray[1]);
        }
        if (stringArray[2] != null) {
            printWriter.print(" = " + stringArray[2]);
        }
        printWriter.println();
    }

    public static class BeanEditor {
        private Object m_bean;
        private Class m_beanClass;
        private BeanInfo m_info;
        private PropertyDescriptor[] m_props;
        private Hashtable m_propTable;
        private ErrorLog m_log;

        public BeanEditor(ErrorLog errorLog, ClassLoader classLoader, String string) throws IOException, ClassNotFoundException, IntrospectionException {
            this(errorLog, Beans.instantiate(classLoader, string));
        }

        public BeanEditor(ErrorLog errorLog, String string) throws IOException, ClassNotFoundException, IntrospectionException {
            this(errorLog, null, string);
        }

        public BeanEditor(ErrorLog errorLog, Object object) throws IntrospectionException {
            this.m_log = errorLog;
            this.m_bean = object;
            this.m_beanClass = this.m_bean.getClass();
            this.m_info = Introspector.getBeanInfo(this.m_beanClass, Object.class);
            this.m_props = this.m_info.getPropertyDescriptors();
            this.m_propTable = new Hashtable();
            for (int i10 = 0; i10 < this.m_props.length; ++i10) {
                this.m_propTable.put(this.m_props[i10].getName(), new Integer(i10));
            }
        }

        public void setFrom(String string, BeanEditor beanEditor) {
            PropertyDescriptor propertyDescriptor = this.getProp(string);
            if (propertyDescriptor == null) {
                return;
            }
            PropertyDescriptor propertyDescriptor2 = beanEditor.getProp(string);
            if (propertyDescriptor2 == null) {
                return;
            }
            String[] stringArray = beanEditor.getPropertyInfo(propertyDescriptor2);
            this.setProperty(string, stringArray[2]);
        }

        public boolean setProperty(String string) {
            String string2 = string;
            String string3 = "";
            int n2 = string.indexOf("=");
            if (n2 != -1) {
                string2 = string.substring(0, n2);
                string3 = string.substring(n2 + 1);
            }
            return this.setProperty(string2, string3);
        }

        private PropertyDescriptor getProp(String string) {
            Integer n2 = (Integer)this.m_propTable.get(string);
            if (n2 == null) {
                return null;
            }
            return this.m_props[n2];
        }

        public boolean setProperty(String string, String string2) {
            PropertyEditor propertyEditor;
            PropertyDescriptor propertyDescriptor = this.getProp(string);
            if (propertyDescriptor == null) {
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.invalid_option((String)string)));
                return false;
            }
            Class<?> clazz = propertyDescriptor.getPropertyType();
            if (clazz == Boolean.TYPE && string2.equals("")) {
                string2 = "true";
            }
            if ((propertyEditor = this.getPropertyEditor(propertyDescriptor)) == null) {
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.unknown_option_type((String)string)));
                return false;
            }
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.option_read_only((String)string)));
                return false;
            }
            try {
                propertyEditor.setAsText(string2);
                method.invoke(this.m_bean, propertyEditor.getValue());
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.invalid_option_value((String)(string + "=" + string2))));
            }
            catch (IllegalAccessException illegalAccessException) {
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.cannot_access_option((String)string)));
            }
            catch (InvocationTargetException invocationTargetException) {
                this.m_log.addEntry((LogEntry)new JSError((Object)(string + "=" + string2 + ": " + invocationTargetException.getTargetException())));
            }
            return false;
        }

        private PropertyEditor getPropertyEditor(PropertyDescriptor propertyDescriptor) {
            PropertyEditor propertyEditor = null;
            Class<?> clazz = propertyDescriptor.getPropertyEditorClass();
            if (clazz != null) {
                try {
                    propertyEditor = (PropertyEditor)clazz.newInstance();
                }
                catch (InstantiationException instantiationException) {
                }
                catch (IllegalAccessException illegalAccessException) {}
            } else {
                Class<?> clazz2 = propertyDescriptor.getPropertyType();
                propertyEditor = PropertyEditorManager.findEditor(clazz2);
            }
            return propertyEditor;
        }

        public String[][] getPropertyInfo() {
            String[][] stringArray = new String[this.m_props.length][];
            for (int i10 = 0; i10 < this.m_props.length; ++i10) {
                stringArray[i10] = this.m_props[i10].isHidden() ? null : this.getPropertyInfo(this.m_props[i10]);
            }
            return stringArray;
        }

        public String[] getPropertyInfo(String string) {
            PropertyDescriptor propertyDescriptor = this.getProp(string);
            if (propertyDescriptor == null) {
                this.m_log.addEntry((LogEntry)new JSError((Object)CustomizerHarnessErrors.invalid_option((String)string)));
                return null;
            }
            return this.getPropertyInfo(propertyDescriptor);
        }

        private String[] getPropertyInfo(PropertyDescriptor propertyDescriptor) {
            PropertyEditor propertyEditor;
            String string;
            String string2 = propertyDescriptor.getName();
            if (string2.equals(string = propertyDescriptor.getShortDescription())) {
                string = null;
            }
            String string3 = null;
            Method method = propertyDescriptor.getReadMethod();
            if (method != null && (propertyEditor = this.getPropertyEditor(propertyDescriptor)) != null) {
                try {
                    Object object = method.invoke(this.m_bean, new Object[0]);
                    propertyEditor.setValue(object);
                    string3 = propertyEditor.getAsText();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    this.m_log.addEntry((LogEntry)new JSError((Object)(string2 + ": " + invocationTargetException.getTargetException())));
                }
            }
            return new String[]{string2, string, string3};
        }

        public Object getAs(Class clazz) {
            return Beans.getInstanceOf(this.m_bean, clazz);
        }
    }

    public static class JarIOContext
    implements ProfileIOContext {
        private boolean m_createBackup;
        private String m_filename;
        private ErrorLog m_log;
        private Loader m_loader;
        private File m_outfile;

        public JarIOContext(String string, boolean bl2, ErrorLog errorLog) throws IOException {
            this.m_filename = string;
            this.m_createBackup = bl2;
            this.m_log = errorLog;
            this.m_loader = new DefaultLoader(new JarFileClassLoader(new ZipFile(string)));
        }

        @Override
        public ErrorLog getErrorLog() {
            return this.m_log;
        }

        @Override
        public Loader getLoader() {
            return this.m_loader;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.m_filename);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            this.m_outfile = CustomizerHarness.createUnique(this.m_filename, "tmp");
            return new FileOutputStream(this.m_outfile);
        }

        @Override
        public void close(int n2) throws IOException {
            if (n2 == 4) {
                this.saveFile();
            } else {
                this.removeFile();
            }
        }

        private void saveFile() throws IOException {
            if (this.m_outfile != null) {
                if (this.m_createBackup) {
                    CustomizerHarness.createBackup(this.m_filename, this.getErrorLog());
                }
                if (!this.m_outfile.renameTo(new File(this.m_filename))) {
                    throw new IOException(CustomizerHarnessErrors.cannot_rename((File)this.m_outfile, (String)this.m_filename));
                }
            }
        }

        private void removeFile() throws IOException {
            if (this.m_outfile != null && !this.m_outfile.delete()) {
                throw new IOException(CustomizerHarnessErrors.cannot_delete((File)this.m_outfile));
            }
        }
    }

    private static class JarFileClassLoader
    extends ClassLoader {
        private ZipFile m_zip;
        private Hashtable m_classes = new Hashtable();

        public JarFileClassLoader(ZipFile zipFile) {
            this.m_zip = zipFile;
        }

        public synchronized Class loadClass(String string, boolean bl2) throws ClassNotFoundException {
            long l10;
            Class<?> clazz = (Class<?>)this.m_classes.get(string);
            if (clazz != null) {
                return clazz;
            }
            String string2 = string.replace('.', '/') + ".class";
            ZipEntry zipEntry = this.m_zip.getEntry(string2);
            if (zipEntry != null && (l10 = zipEntry.getSize()) != -1L && l10 <= Integer.MAX_VALUE) {
                byte[] byArray = new byte[(int)l10];
                try {
                    InputStream inputStream = this.m_zip.getInputStream(zipEntry);
                    inputStream.read(byArray);
                    clazz = this.defineClass(string, byArray, 0, byArray.length);
                    if (bl2) {
                        this.resolveClass(clazz);
                    }
                    this.m_classes.put(string, clazz);
                    return clazz;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return this.findSystemClass(string);
        }

        @Override
        public InputStream getResourceAsStream(String string) {
            ZipEntry zipEntry = this.m_zip.getEntry(string);
            if (zipEntry != null) {
                try {
                    return this.m_zip.getInputStream(zipEntry);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return JarFileClassLoader.getSystemResourceAsStream(string);
        }
    }

    public static class FileIOContext
    implements ProfileIOContext {
        private boolean m_createBackup;
        private String m_filename;
        private ErrorLog m_log;
        private Loader m_loader;
        private ByteArrayOutputStream m_output = null;

        public FileIOContext(String string, boolean bl2, ErrorLog errorLog, Loader loader) {
            this.m_filename = string;
            this.m_createBackup = bl2;
            this.m_loader = loader;
            this.m_log = errorLog;
        }

        @Override
        public ErrorLog getErrorLog() {
            return this.m_log;
        }

        @Override
        public Loader getLoader() {
            return this.m_loader;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.m_filename);
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            this.m_output = new ByteArrayOutputStream(1024);
            return this.m_output;
        }

        @Override
        public void close(int n2) throws IOException {
            if (n2 == 4) {
                this.saveFile();
            }
        }

        private void saveFile() throws IOException {
            if (this.m_output != null) {
                if (this.m_createBackup) {
                    CustomizerHarness.createBackup(this.m_filename, this.getErrorLog());
                }
                FileOutputStream fileOutputStream = new FileOutputStream(this.m_filename);
                this.m_output.writeTo(fileOutputStream);
                ((OutputStream)fileOutputStream).close();
            }
        }
    }

    private static class Status {
        private int m_origErrorCount;
        private ErrorLog m_log;
        private int m_status = 3;

        public Status(ErrorLog errorLog) {
            this.m_origErrorCount = errorLog.errorCount();
            this.m_log = errorLog;
        }

        public int getStatus() {
            if (this.m_log.errorCount() > this.m_origErrorCount) {
                return 5;
            }
            return this.m_status;
        }

        public void setStatus(int n2) {
            this.m_status = n2;
        }
    }

    private static class JarProfiles
    implements Enumeration {
        ProfileIOContext m_jarContext;
        ZipInputStream m_jarInput;
        ZipOutputStream m_jarOutput;
        private static final int BUFFER_LEN = 1024;
        byte[] m_dataBuffer = new byte[1024];
        ZipEntry m_entry;
        private String m_origFilename;
        private ManifestData m_manifest;
        private ZipEntry m_manifestEntry;
        private MessageDigest[] m_digests;

        JarProfiles(ProfileIOContext profileIOContext, MessageDigest[] messageDigestArray) throws IOException {
            this.m_manifest = this.readManifest(profileIOContext);
            this.m_jarContext = profileIOContext;
            this.m_jarInput = new ZipInputStream(profileIOContext.getInputStream());
            try {
                this.m_jarOutput = new ZipOutputStream(profileIOContext.getOutputStream());
            }
            catch (IOException iOException) {
                this.m_jarInput.close();
                throw iOException;
            }
            this.m_origFilename = profileIOContext.getErrorLog().getFileName();
            this.m_digests = messageDigestArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ManifestData readManifest(ProfileIOContext profileIOContext) throws IOException {
            ZipInputStream zipInputStream = new ZipInputStream(profileIOContext.getInputStream());
            try {
                try {
                    ZipEntry zipEntry;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        if (ManifestData.isManifest(zipEntry)) {
                            ManifestData manifestData = new ManifestData(zipInputStream);
                            return manifestData;
                        }
                        zipInputStream.closeEntry();
                    }
                }
                finally {
                    zipInputStream.close();
                }
            }
            finally {
                profileIOContext.close(3);
            }
            throw new IOException(CustomizerHarnessErrors.no_manifest());
        }

        void close(int n2) throws IOException {
            try {
                if (n2 == 4) {
                    ProfileIOContext profileIOContext = this.getContextForEntry(this.m_manifestEntry);
                    this.m_manifest.toStream(profileIOContext.getOutputStream());
                    profileIOContext.close(4);
                }
            }
            finally {
                this.m_jarContext.getErrorLog().setFileName(this.m_origFilename);
                this.m_jarInput.close();
                this.m_jarOutput.close();
            }
        }

        @Override
        public boolean hasMoreElements() {
            try {
                while ((this.m_entry = this.m_jarInput.getNextEntry()) != null) {
                    if (this.isProfile(this.m_entry)) {
                        return true;
                    }
                    if (ManifestData.isManifest(this.m_entry)) {
                        this.m_manifestEntry = this.m_entry;
                        continue;
                    }
                    this.copyZipEntry(this.m_entry);
                }
            }
            catch (IOException iOException) {
                this.m_jarContext.getErrorLog().addEntry((LogEntry)new JSError((Object)iOException.toString()));
            }
            return false;
        }

        private boolean isProfile(ZipEntry zipEntry) {
            return this.m_manifest.isProfile(zipEntry.getName());
        }

        private void copyZipEntry(ZipEntry zipEntry) throws IOException {
            int n2;
            this.m_jarOutput.putNextEntry(zipEntry);
            while ((n2 = this.m_jarInput.read(this.m_dataBuffer, 0, 1024)) != -1) {
                this.m_jarOutput.write(this.m_dataBuffer, 0, n2);
            }
            this.m_jarOutput.closeEntry();
            this.m_jarInput.closeEntry();
        }

        private ZipEntry createNewEntry(ZipEntry zipEntry) {
            ZipEntry zipEntry2 = new ZipEntry(zipEntry.getName());
            zipEntry2.setComment(zipEntry.getComment());
            zipEntry2.setExtra(zipEntry.getExtra());
            zipEntry2.setMethod(zipEntry.getMethod());
            return zipEntry2;
        }

        public Object nextElement() {
            return this.getContextForEntry(this.m_entry);
        }

        private ProfileIOContext getContextForEntry(ZipEntry zipEntry) {
            this.m_jarContext.getErrorLog().setFileName(zipEntry.getName());
            return new JarEntryIOContext(zipEntry);
        }

        int getEntrySize(ZipEntry zipEntry) throws IOException {
            long l10 = zipEntry.getSize();
            if (l10 == -1L) {
                l10 = 1024L;
            } else if (l10 > Integer.MAX_VALUE) {
                throw new IOException(CustomizerHarnessErrors.file_too_big());
            }
            return (int)l10;
        }

        private class JarEntryIOContext
        implements ProfileIOContext {
            private ByteArrayOutputStream m_savedInput;
            private ByteArrayOutputStream m_savedOutput;
            private Checksum m_outputChecksum = null;
            private DigestOutputStream[] m_digestStreams;
            private ZipEntry m_entry;

            public JarEntryIOContext(ZipEntry zipEntry) {
                this.m_entry = zipEntry;
            }

            private ZipEntry getEntry() {
                return this.m_entry;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                this.m_savedInput = new ByteArrayOutputStream(JarProfiles.this.getEntrySize(this.getEntry()));
                return new FilterInputStream(JarProfiles.this.m_jarInput){

                    @Override
                    public void close() throws IOException {
                        JarProfiles.this.m_jarInput.closeEntry();
                    }

                    @Override
                    public int read() throws IOException {
                        int n2 = JarProfiles.this.m_jarInput.read();
                        if (n2 != -1) {
                            JarEntryIOContext.this.m_savedInput.write(n2);
                        }
                        return n2;
                    }

                    @Override
                    public int read(byte[] byArray) throws IOException {
                        int n2 = JarProfiles.this.m_jarInput.read(byArray);
                        if (n2 != -1) {
                            JarEntryIOContext.this.m_savedInput.write(byArray, 0, n2);
                        }
                        return n2;
                    }

                    @Override
                    public int read(byte[] byArray, int n2, int n3) throws IOException {
                        int n4 = JarProfiles.this.m_jarInput.read(byArray, n2, n3);
                        if (n4 != -1) {
                            JarEntryIOContext.this.m_savedInput.write(byArray, n2, n4);
                        }
                        return n4;
                    }
                };
            }

            @Override
            public OutputStream getOutputStream() throws IOException {
                this.m_savedOutput = new ByteArrayOutputStream(JarProfiles.this.getEntrySize(this.getEntry()));
                this.m_outputChecksum = new CRC32();
                FilterOutputStream filterOutputStream = new CheckedOutputStream(this.m_savedOutput, this.m_outputChecksum);
                this.m_digestStreams = new DigestOutputStream[JarProfiles.this.m_digests.length];
                for (int i10 = 0; i10 < JarProfiles.this.m_digests.length; ++i10) {
                    JarProfiles.this.m_digests[i10].reset();
                    this.m_digestStreams[i10] = new DigestOutputStream(filterOutputStream, JarProfiles.this.m_digests[i10]);
                    filterOutputStream = this.m_digestStreams[i10];
                }
                return filterOutputStream;
            }

            @Override
            public ErrorLog getErrorLog() {
                return JarProfiles.this.m_jarContext.getErrorLog();
            }

            @Override
            public Loader getLoader() {
                return JarProfiles.this.m_jarContext.getLoader();
            }

            @Override
            public void close(int n2) throws IOException {
                switch (n2) {
                    case 4: {
                        ZipEntry zipEntry = JarProfiles.this.createNewEntry(this.getEntry());
                        zipEntry.setCrc(this.m_outputChecksum.getValue());
                        zipEntry.setSize(this.m_savedOutput.size());
                        JarProfiles.this.m_jarOutput.putNextEntry(zipEntry);
                        this.m_savedOutput.writeTo(JarProfiles.this.m_jarOutput);
                        JarProfiles.this.m_jarOutput.closeEntry();
                        String string = zipEntry.getName();
                        if (!JarProfiles.this.m_manifest.isProfile(string)) break;
                        JarProfiles.this.m_manifest.clearDigests(string);
                        for (int i10 = 0; i10 < JarProfiles.this.m_digests.length; ++i10) {
                            JarProfiles.this.m_manifest.addDigest(string, this.m_digestStreams[i10].getMessageDigest());
                        }
                        break;
                    }
                    case 3: {
                        JarProfiles.this.m_jarOutput.putNextEntry(this.getEntry());
                        this.m_savedInput.writeTo(JarProfiles.this.m_jarOutput);
                        JarProfiles.this.m_jarOutput.closeEntry();
                        break;
                    }
                }
            }
        }
    }

    private static class ManifestData {
        private Hashtable m_profiles = new Hashtable();
        private Vector m_attributes = new Vector();
        private InputStreamReader m_stream;
        private int m_nextChar;
        private static final String MANIFEST_ENCODING = "UTF8";
        private static final int CR = 13;
        private static final int LF = 10;
        private int eofCount = 0;

        public ManifestData(InputStream inputStream) throws IOException {
            this.m_stream = new InputStreamReader(inputStream, MANIFEST_ENCODING);
            this.m_nextChar = -1;
            this.readManifest();
            this.m_stream = null;
            this.findProfiles();
        }

        private void findProfiles() {
            Enumeration enumeration = this.m_attributes.elements();
            while (enumeration.hasMoreElements()) {
                String string;
                Section section = (Section)enumeration.nextElement();
                if (!section.isProfile() || this.m_profiles.get(string = section.getName()) != null) continue;
                this.m_profiles.put(string, section);
            }
        }

        private void readManifest() throws IOException {
            if (this.readSection(this.m_attributes) == null) {
                this.raise_invalid_manifest();
            }
            this.checkRequired((Section)this.m_attributes.elementAt(0));
            while (this.readSection(this.m_attributes) != null) {
            }
        }

        private void checkRequired(Section section) throws IOException {
            String string = section.getRequiredVersion();
            if (string != null && !string.equals("1.0")) {
                this.raise_invalid_manifest();
            }
        }

        private String readSection(Vector vector) throws IOException {
            Section section = new Section();
            String string = this.readHeader(section);
            if (string != null) {
                vector.addElement(section);
                while (this.readHeader(section) != null) {
                }
                if (!this.readEOL()) {
                    this.raise_invalid_manifest();
                }
                while (this.readEOL()) {
                }
            }
            return string;
        }

        private String readHeader(Section section) throws IOException {
            String string = this.readKey();
            if (string == null) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.readContinuation(stringBuffer)) {
                this.raise_invalid_manifest();
            }
            while (this.readContinuation(stringBuffer)) {
            }
            section.put(string, stringBuffer.toString());
            return string;
        }

        private boolean readContinuation(StringBuffer stringBuffer) throws IOException {
            if (!this.isSpace(this.peekNextChar())) {
                return false;
            }
            this.getNextChar();
            while (!this.readEOL()) {
                this.getNextChar(stringBuffer);
            }
            return true;
        }

        private boolean readEOL() throws IOException {
            boolean bl2 = false;
            int n2 = this.peekNextChar();
            if (n2 == 13) {
                this.getNextChar();
                bl2 = true;
                n2 = this.peekNextChar();
            }
            if (n2 == 10) {
                this.getNextChar();
                bl2 = true;
            }
            return bl2;
        }

        private boolean isSpace(int n2) {
            return n2 == 32 || n2 == 9;
        }

        private String readKey() throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.readAlphaNum(stringBuffer)) {
                return null;
            }
            while (this.readHeaderChar(stringBuffer)) {
            }
            if (this.getNextChar() != 58) {
                this.raise_invalid_manifest();
            }
            return stringBuffer.toString();
        }

        private void raise_invalid_manifest() throws IOException {
            throw new IOException(CustomizerHarnessErrors.invalid_manifest_syntax());
        }

        private boolean readAlphaNum(StringBuffer stringBuffer) throws IOException {
            int n2 = this.peekNextChar();
            if (n2 >= 65 && n2 <= 90 || n2 >= 97 && n2 <= 122 || n2 >= 48 && n2 <= 57) {
                this.getNextChar(stringBuffer);
                return true;
            }
            return false;
        }

        private boolean readHeaderChar(StringBuffer stringBuffer) throws IOException {
            if (this.readAlphaNum(stringBuffer)) {
                return true;
            }
            int n2 = this.peekNextChar();
            if (n2 == 45 || n2 == 95) {
                this.getNextChar(stringBuffer);
                return true;
            }
            return false;
        }

        private int peekNextChar() throws IOException {
            if (this.m_nextChar == -1) {
                this.m_nextChar = this.read();
            }
            return this.m_nextChar;
        }

        private int read() throws IOException {
            int n2 = this.m_stream.read();
            if (n2 == -1 && this.eofCount++ < 2) {
                return 10;
            }
            return n2;
        }

        private int getNextChar() throws IOException {
            int n2;
            if (this.m_nextChar != -1) {
                n2 = this.m_nextChar;
                this.m_nextChar = -1;
            } else {
                n2 = this.read();
            }
            return n2;
        }

        private void getNextChar(StringBuffer stringBuffer) throws IOException {
            stringBuffer.append((char)this.getNextChar());
        }

        public boolean isProfile(String string) {
            return this.m_profiles.containsKey(string);
        }

        public void clearDigests(String string) throws IOException {
            this.getProfile(string).clearDigests();
        }

        public void addDigest(String string, MessageDigest messageDigest) throws IOException {
            this.getProfile(string).addDigest(messageDigest);
        }

        private Section getProfile(String string) throws IOException {
            Section section = (Section)this.m_profiles.get(string);
            if (section == null) {
                throw new IOException(CustomizerHarnessErrors.invalid_profile_name((String)string));
            }
            return section;
        }

        public void toStream(OutputStream outputStream) throws IOException {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, MANIFEST_ENCODING);
            PrintWriter printWriter = new PrintWriter(new LineBreakFilter(outputStreamWriter, 72));
            int n2 = this.m_attributes.size();
            for (int i10 = 0; i10 < n2; ++i10) {
                ((Section)this.m_attributes.elementAt(i10)).toStream(printWriter);
            }
            printWriter.flush();
        }

        public static boolean isManifest(ZipEntry zipEntry) {
            String string = zipEntry.getName();
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            return string.equalsIgnoreCase("META-INF/MANIFEST.MF");
        }

        private static class LineBreakFilter
        extends FilterWriter {
            private int m_numBytesInLine = 0;
            private int m_bytesPerLine;
            private static final String CONTINUATION = "\n ";
            private static final int CONTINUATION_LEN = 2;

            public LineBreakFilter(Writer writer, int n2) {
                super(writer);
                this.m_bytesPerLine = n2;
            }

            @Override
            public void write(int n2) throws IOException {
                if (n2 == 10 || n2 == 13) {
                    this.m_numBytesInLine = 0;
                    super.write(n2);
                } else {
                    if (this.m_numBytesInLine >= this.m_bytesPerLine) {
                        super.write(CONTINUATION, 0, 2);
                        this.m_numBytesInLine = this.numBytesForChar(32);
                    }
                    this.m_numBytesInLine += this.numBytesForChar(n2);
                    super.write(n2);
                }
            }

            @Override
            public void write(char[] cArray, int n2, int n3) throws IOException {
                for (int i10 = 0; i10 < n3; ++i10) {
                    this.write(cArray[i10 + n2]);
                }
            }

            @Override
            public void write(String string, int n2, int n3) throws IOException {
                for (int i10 = 0; i10 < n3; ++i10) {
                    this.write(string.charAt(i10 + n2));
                }
            }

            private int numBytesForChar(int n2) {
                if (n2 < 128) {
                    return 1;
                }
                if (n2 < 2048) {
                    return 2;
                }
                return 3;
            }
        }

        private static class Section {
            private Object m_encoder;
            private Vector m_keys = new Vector();
            private Vector m_origKeys = new Vector();
            private Vector m_values = new Vector();
            private static final String ALGORITHM_KEY = "DIGEST-ALGORITHMS";

            public void put(String string, String string2) {
                String string3 = string.toUpperCase();
                int n2 = this.m_keys.indexOf(string3);
                if (n2 == -1) {
                    this.m_keys.addElement(string3);
                    this.m_origKeys.addElement(string);
                    this.m_values.addElement(string2);
                } else {
                    this.m_values.setElementAt(string2, n2);
                }
            }

            private String get(String string) {
                int n2 = this.m_keys.indexOf(string);
                if (n2 == -1) {
                    return null;
                }
                return (String)this.m_values.elementAt(n2);
            }

            private String remove(String string) {
                int n2 = this.m_keys.indexOf(string);
                if (n2 == -1) {
                    return null;
                }
                this.m_keys.removeElementAt(n2);
                this.m_origKeys.removeElementAt(n2);
                String string2 = (String)this.m_values.elementAt(n2);
                this.m_values.removeElementAt(n2);
                return string2;
            }

            public boolean isProfile() {
                String string = this.get("SQLJPROFILE");
                return string != null && string.equalsIgnoreCase("TRUE") && this.getName() != null;
            }

            public String getDigestAlgorithms() {
                return this.get(ALGORITHM_KEY);
            }

            public String getName() {
                return this.get("NAME");
            }

            public String getRequiredVersion() {
                return this.get("REQUIRED-VERSION");
            }

            public void toStream(PrintWriter printWriter) {
                int n2 = this.m_keys.size();
                for (int i10 = 0; i10 < n2; ++i10) {
                    printWriter.print(this.m_origKeys.elementAt(i10));
                    printWriter.print(": ");
                    printWriter.println(this.m_values.elementAt(i10));
                }
                printWriter.println();
            }

            public void clearDigests() {
                String string = this.getDigestAlgorithms();
                if (string == null) {
                    return;
                }
                int n2 = 0;
                int n3 = 0;
                int n4 = string.length();
                while (n3 != -1 && n2 < n4) {
                    n3 = string.indexOf(32, n2 + 1);
                    String string2 = n3 == -1 ? string.substring(n2) : string.substring(n2, n3);
                    this.remove(string2 + "-DIGEST");
                    n2 = n3 + 1;
                }
                this.remove(ALGORITHM_KEY);
            }

            public void addDigest(MessageDigest messageDigest) {
                block9: {
                    String string = this.getDigestAlgorithms();
                    String string2 = messageDigest.getAlgorithm();
                    string = string == null ? string2 : string + " " + string2;
                    this.put("Digest-Algorithms", string);
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName("java.util.Base64");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        try {
                            clazz = Class.forName("sun.misc.BASE64Encoder");
                        }
                        catch (ClassNotFoundException classNotFoundException2) {
                            // empty catch block
                        }
                    }
                    try {
                        if (clazz != null) {
                            if (clazz.getName().equals("java.util.Base64")) {
                                this.m_encoder = clazz.getMethod("getEncoder", new Class[0]).invoke(null, new Object[0]);
                                this.put(string2 + "-Digest", (String)this.m_encoder.getClass().getMethod("encodeToString", byte[].class).invoke(this.m_encoder, new Object[]{messageDigest.digest()}));
                            }
                            if (clazz.getName().equals("sun.misc.BASE64Encoder")) {
                                this.m_encoder = clazz.newInstance();
                                this.put(string2 + "-Digest", (String)this.m_encoder.getClass().getMethod("encode", byte[].class).invoke(this.m_encoder, new Object[]{messageDigest.digest()}));
                            }
                        }
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        if (System.err == null) break block9;
                        System.err.println("Error while invoking encoder methods through reflection");
                        reflectiveOperationException.printStackTrace(System.err);
                    }
                }
            }
        }
    }

    public static class Log
    implements ErrorLog {
        private PrintWriter m_out;
        private int m_numWarnings = 0;
        private int m_numErrors = 0;
        private String m_filename = null;

        public Log(PrintWriter printWriter) {
            this.m_out = printWriter;
        }

        public void addEntry(LogEntry logEntry) {
            logEntry.setFileName(this.m_filename);
            if (logEntry instanceof JSError) {
                this.incErrorCount();
            } else if (logEntry instanceof Warning) {
                this.incWarningCount();
            }
            this.m_out.println(logEntry);
        }

        public void addEntry(LogEntry logEntry, int n2, int n3) {
            logEntry.setPosition(new Position(n2, n3));
            this.addEntry(logEntry);
        }

        public void addEntryRegion(LogEntry logEntry, int n2, int n3, int n4, int n5) {
            logEntry.setRegion(n2, n3, n4, n5);
            this.addEntry(logEntry);
        }

        public int errorCount() {
            return this.m_numErrors;
        }

        public void incErrorCount() {
            ++this.m_numErrors;
        }

        public int warningCount() {
            return this.m_numWarnings;
        }

        public void incWarningCount() {
            ++this.m_numWarnings;
        }

        public void setFileName(String string) {
            this.m_filename = string;
        }

        public String getFileName() {
            return this.m_filename;
        }

        public Position getDefaultRegion() {
            return null;
        }

        public void printSummary() {
            this.m_out.print(CustomizerHarnessErrors.error_count((int)this.errorCount()));
            if (this.errorCount() > 0 && this.warningCount() > 0) {
                this.m_out.print(", ");
            }
            this.m_out.print(CustomizerHarnessErrors.warning_count((int)this.warningCount()));
            if (this.errorCount() > 0 || this.warningCount() > 0) {
                this.m_out.println();
            }
        }
    }
}

