/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.io.Serializable;
import java.lang.reflect.Executable;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.replay.ReplayStatistics;
import oracle.jdbc.replay.driver.ReplayStatisticsImpl;

public class StatisticsTracker
implements Serializable {
    private final LinkedList<oracle.jdbc.replay.internal.ReplayStatistics> acStatistics = new LinkedList();
    private final Monitor acStatisticsMonitor = Monitor.newInstance();
    private AtomicBoolean dsNameSet = new AtomicBoolean(false);
    private String dsName = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;

    public ReplayStatistics getReplayStatistics() {
        long totalRequests = 0L;
        long totalCompletedRequests = 0L;
        long totalCalls = 0L;
        long totalProtectedCalls = 0L;
        long totalCallsAffectedByOutages = 0L;
        long totalCallsTriggeringReplay = 0L;
        long totalCallsAffectedByOutagesDuringReplay = 0L;
        long successfulReplayCount = 0L;
        long failedReplayCount = 0L;
        long replayDisablingCount = 0L;
        long totalReplayAttempts = 0L;
        int[] histogram = new int[31];
        try (Monitor.CloseableLock lock = this.acStatisticsMonitor.acquireCloseableLock();){
            for (oracle.jdbc.replay.internal.ReplayStatistics stats : this.acStatistics) {
                totalRequests += stats.getTotalRequests();
                totalCompletedRequests += stats.getTotalCompletedRequests();
                totalCalls += stats.getTotalCalls();
                totalProtectedCalls += stats.getTotalProtectedCalls();
                totalCallsAffectedByOutages += stats.getTotalCallsAffectedByOutages();
                totalCallsTriggeringReplay += stats.getTotalCallsTriggeringReplay();
                totalCallsAffectedByOutagesDuringReplay += stats.getTotalCallsAffectedByOutagesDuringReplay();
                successfulReplayCount += stats.getSuccessfulReplayCount();
                failedReplayCount += stats.getFailedReplayCount();
                replayDisablingCount += stats.getReplayDisablingCount();
                totalReplayAttempts += stats.getTotalReplayAttempts();
                int[] h2 = stats.getRequestSizeHistogram();
                if (h2 == null || h2.length <= 0) continue;
                for (int i2 = 0; i2 < h2.length; ++i2) {
                    int n2 = i2;
                    histogram[n2] = histogram[n2] + h2[i2];
                }
            }
        }
        ReplayStatisticsImpl globalStats = new ReplayStatisticsImpl(totalRequests, totalCompletedRequests, totalCalls, totalProtectedCalls, totalCallsAffectedByOutages, totalCallsTriggeringReplay, totalCallsAffectedByOutagesDuringReplay, successfulReplayCount, failedReplayCount, replayDisablingCount, totalReplayAttempts, 0);
        globalStats.setRequestSizeHistogram(histogram);
        return globalStats;
    }

    @DisableTrace
    public String getReplayStatisticsString() {
        long totalRequests = 0L;
        long totalCompletedRequests = 0L;
        long totalCalls = 0L;
        long totalProtectedCalls = 0L;
        long totalCallsAffectedByOutages = 0L;
        long totalCallsTriggeringReplay = 0L;
        long totalCallsAffectedByOutagesDuringReplay = 0L;
        long successfulReplayCount = 0L;
        long failedReplayCount = 0L;
        long replayDisablingCount = 0L;
        long totalReplayAttempts = 0L;
        int[] histogram = new int[31];
        StringBuilder builder = new StringBuilder().append("All current in-flight AC request sizes:").append("\n===============================================");
        try (Monitor.CloseableLock lock = this.acStatisticsMonitor.acquireCloseableLock();){
            for (oracle.jdbc.replay.internal.ReplayStatistics stats : this.acStatistics) {
                totalRequests += stats.getTotalRequests();
                totalCompletedRequests += stats.getTotalCompletedRequests();
                totalCalls += stats.getTotalCalls();
                totalProtectedCalls += stats.getTotalProtectedCalls();
                totalCallsAffectedByOutages += stats.getTotalCallsAffectedByOutages();
                totalCallsTriggeringReplay += stats.getTotalCallsTriggeringReplay();
                totalCallsAffectedByOutagesDuringReplay += stats.getTotalCallsAffectedByOutagesDuringReplay();
                successfulReplayCount += stats.getSuccessfulReplayCount();
                failedReplayCount += stats.getFailedReplayCount();
                replayDisablingCount += stats.getReplayDisablingCount();
                totalReplayAttempts += stats.getTotalReplayAttempts();
                builder.append("\n  ").append(stats.getCurrentRequestSize());
                int[] h2 = stats.getRequestSizeHistogram();
                if (h2 == null || h2.length <= 0) continue;
                for (int i2 = 0; i2 < h2.length; ++i2) {
                    int n2 = i2;
                    histogram[n2] = histogram[n2] + h2[i2];
                }
            }
        }
        ReplayStatisticsImpl globalStats = new ReplayStatisticsImpl(totalRequests, totalCompletedRequests, totalCalls, totalProtectedCalls, totalCallsAffectedByOutages, totalCallsTriggeringReplay, totalCallsAffectedByOutagesDuringReplay, successfulReplayCount, failedReplayCount, replayDisablingCount, totalReplayAttempts, 0);
        globalStats.setRequestSizeHistogram(histogram);
        builder.append("\n===============================================").append("\n\n").append(globalStats.toString()).append("\n\n").append(globalStats.getRequestSizeHistogramString()).append("\n\n");
        return builder.toString();
    }

    public void clearReplayStatistics() {
        try (Monitor.CloseableLock lock = this.acStatisticsMonitor.acquireCloseableLock();){
            for (oracle.jdbc.replay.internal.ReplayStatistics stats : this.acStatistics) {
                stats.clear();
            }
        }
    }

    public void updateReplayStatistics(String dsName, oracle.jdbc.replay.internal.ReplayStatistics newStats) {
        if (this.dsNameSet.compareAndSet(false, true) && dsName != null) {
            this.dsName = dsName;
        }
        try (Monitor.CloseableLock lock = this.acStatisticsMonitor.acquireCloseableLock();){
            this.acStatistics.add(newStats);
        }
    }

    public String getDataSourceName() {
        return this.dsName;
    }

    static {
        try {
            $$$methodRef$$$4 = StatisticsTracker.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = StatisticsTracker.class.getDeclaredMethod("getDataSourceName", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = StatisticsTracker.class.getDeclaredMethod("updateReplayStatistics", String.class, oracle.jdbc.replay.internal.ReplayStatistics.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = StatisticsTracker.class.getDeclaredMethod("clearReplayStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = StatisticsTracker.class.getDeclaredMethod("getReplayStatistics", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

