/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocket;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;

public class TcpsConfigure {
    static final boolean DEBUG = false;
    private static final int SSL_CERT_SAN_DNS_NAME = 2;
    public static final String[] VALID_SSL_VERSION_STRINGS;
    public static final String[][] TABLE_ENABLED_SSL_PROTOCOLS;
    public static final int[] VALID_SSL_STRING_TO_PROTOCOLS_MAP;
    static final HashSet<String> UNSUPPORTED_PROTOCOLS_SET;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    private TcpsConfigure() {
    }

    public static void configureVersion(SSLSocket sslSocket, SSLEngine sslEngine, String sslVersionString, boolean useNio) throws NetException, IOException {
        if (sslVersionString == null) {
            sslVersionString = System.getProperty("oracle.net.ssl_version");
        }
        String[] enabledProtocols = null;
        int validSSLVersionIndex = 0;
        if (sslVersionString != null) {
            sslVersionString = sslVersionString.startsWith("(") && sslVersionString.endsWith(")") ? "(ssl_version=" + sslVersionString.substring(1) : "(ssl_version=" + sslVersionString + ")";
            try {
                NVPair nvpVersion = new NVFactory().createNVPair(sslVersionString);
                String sslVersion = nvpVersion.getAtom();
                for (int i2 = 0; i2 < VALID_SSL_VERSION_STRINGS.length; ++i2) {
                    if (!sslVersion.equalsIgnoreCase(VALID_SSL_VERSION_STRINGS[i2])) continue;
                    validSSLVersionIndex = i2;
                    break;
                }
            }
            catch (NLException ex) {
                throw (NetException)new NetException(400, sslVersionString).initCause(ex);
            }
            if (validSSLVersionIndex >= VALID_SSL_VERSION_STRINGS.length) {
                throw new NetException(400);
            }
            enabledProtocols = TABLE_ENABLED_SSL_PROTOCOLS[VALID_SSL_STRING_TO_PROTOCOLS_MAP[validSSLVersionIndex]];
        } else {
            enabledProtocols = TcpsConfigure.getAllSupportedProtocols(useNio, sslEngine, sslSocket);
            if (enabledProtocols == null) {
                throw new NetException(400);
            }
        }
        try {
            if (!useNio) {
                sslSocket.setEnabledProtocols(enabledProtocols);
            } else {
                sslEngine.setEnabledProtocols(enabledProtocols);
            }
        }
        catch (IllegalArgumentException ex) {
            throw (NetException)new NetException(401).initCause(ex);
        }
    }

    public static void configureCipherSuites(SSLSocket sslSocket, SSLEngine sslEngine, String cipherSuitesString, boolean useNio) throws NetException, IOException {
        if (cipherSuitesString == null) {
            cipherSuitesString = System.getProperty("oracle.net.ssl_cipher_suites");
        }
        if (cipherSuitesString == null) {
            return;
        }
        cipherSuitesString = cipherSuitesString.startsWith("(") && cipherSuitesString.endsWith(")") ? "(cipher_suites=" + cipherSuitesString + ")" : "(cipher_suites=(" + cipherSuitesString + "))";
        try {
            NVPair nvpCipher = new NVFactory().createNVPair(cipherSuitesString);
            String[] listCipherSuites = new String[nvpCipher.getListSize()];
            if (nvpCipher.getRHSType() == NVPair.LIST_COMMASEP || nvpCipher.getRHSType() == NVPair.RHS_LIST) {
                for (int i2 = 0; i2 < nvpCipher.getListSize(); ++i2) {
                    listCipherSuites[i2] = nvpCipher.getListElement(i2).getName();
                }
            } else {
                throw new NetException(403, cipherSuitesString);
            }
            if (!useNio) {
                sslSocket.setEnabledCipherSuites(listCipherSuites);
            } else {
                sslEngine.setEnabledCipherSuites(listCipherSuites);
            }
        }
        catch (NLException ex) {
            throw new NetException(403, cipherSuitesString);
        }
        catch (IllegalArgumentException ex) {
            throw (NetException)new NetException(404).initCause(ex);
        }
    }

    private static String[] getAllSupportedProtocols(boolean useNio, SSLEngine sslEngine, SSLSocket sslSocket) {
        ArrayList<String> allSupportedProtocols = new ArrayList<String>();
        String[] allProtocols = null;
        allProtocols = useNio ? sslEngine.getSupportedProtocols() : sslSocket.getSupportedProtocols();
        if (allProtocols == null) {
            return null;
        }
        for (String curProtocol : allProtocols) {
            if (UNSUPPORTED_PROTOCOLS_SET.contains(curProtocol)) continue;
            allSupportedProtocols.add(curProtocol);
        }
        return allSupportedProtocols.toArray(new String[allSupportedProtocols.size()]);
    }

    public static boolean matchServerDN(X509Certificate peerCert, String configDN, boolean isUserConfiguredDNAvailable, String dbHostName) {
        String serverCertDN = peerCert.getSubjectDN().getName();
        if (isUserConfiguredDNAvailable) {
            return TcpsConfigure.matchServerDN(serverCertDN, configDN, true);
        }
        return TcpsConfigure.matchHostName(peerCert, dbHostName) || TcpsConfigure.matchServerDN(serverCertDN, configDN, false);
    }

    private static boolean matchHostName(X509Certificate peerCert, String dbHostName) {
        return TcpsConfigure.matchCN(peerCert, dbHostName) || TcpsConfigure.matchSANs(peerCert, dbHostName);
    }

    private static boolean matchCN(X509Certificate cert, String dbHostName) {
        try {
            LdapName certDN = new LdapName(cert.getSubjectDN().getName());
            List<Rdn> rdns = certDN.getRdns();
            for (Rdn rdn : rdns) {
                if (!rdn.getType().equalsIgnoreCase("cn")) continue;
                return TcpsConfigure.matchHostNames(rdn.getValue().toString(), dbHostName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private static boolean matchSANs(X509Certificate cert, String dbHostName) {
        String[] altNames = TcpsConfigure.getDNSSubjectAlts(cert);
        if (altNames == null) {
            return false;
        }
        for (String altName : altNames) {
            if (!TcpsConfigure.matchHostNames(altName, dbHostName)) continue;
            return true;
        }
        return false;
    }

    private static String[] getDNSSubjectAlts(X509Certificate cert) {
        LinkedList<String> subjectAltList = new LinkedList<String>();
        Collection<List<?>> c2 = null;
        try {
            c2 = cert.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException cpe) {
            return null;
        }
        if (c2 != null) {
            for (List<?> aC : c2) {
                List<?> list = aC;
                int type = (Integer)list.get(0);
                if (type != 2) continue;
                String s2 = (String)list.get(1);
                subjectAltList.add(s2);
            }
        }
        if (!subjectAltList.isEmpty()) {
            String[] subjectAlts = new String[subjectAltList.size()];
            subjectAltList.toArray(subjectAlts);
            return subjectAlts;
        }
        return null;
    }

    private static boolean matchHostNames(String certHostName, String hostName) {
        certHostName = certHostName.toLowerCase();
        hostName = hostName.toLowerCase();
        if (certHostName.startsWith("*.") && certHostName.indexOf(46, 2) != -1) {
            return hostName.endsWith(certHostName.substring(1));
        }
        return certHostName.equals(hostName);
    }

    public static boolean matchServerDN(String serverDN, String userDN, boolean fullMatch) {
        if ((serverDN = TcpsConfigure.normalizeDN(serverDN)) == null) {
            return false;
        }
        if (fullMatch) {
            if ((userDN = TcpsConfigure.normalizeDN(userDN)) == null) {
                return false;
            }
            if (userDN.equalsIgnoreCase(serverDN)) {
                return true;
            }
            return userDN.equalsIgnoreCase(serverDN = TcpsConfigure.reverseDN(serverDN));
        }
        int startIndex = serverDN.indexOf("CN=");
        return startIndex != -1 && userDN.equalsIgnoreCase(serverDN = serverDN.indexOf(44, startIndex) != -1 ? serverDN.substring(startIndex, serverDN.indexOf(44, startIndex)) : serverDN.substring(startIndex));
    }

    public static String normalizeDN(String dn) {
        StringBuffer normalizedDN = new StringBuffer();
        String attribute = null;
        String value = null;
        int currentIndex = 0;
        int prevIndex = 0;
        dn = dn.trim();
        while ((currentIndex = dn.indexOf(61, currentIndex)) != -1) {
            attribute = dn.substring(prevIndex, currentIndex);
            attribute = attribute.trim();
            normalizedDN.append(attribute.toUpperCase());
            normalizedDN.append('=');
            prevIndex = currentIndex;
            if (prevIndex >= dn.length() - 1) {
                return null;
            }
            if ((currentIndex = dn.indexOf(44, currentIndex)) == -1) {
                value = dn.substring(prevIndex + 1);
                normalizedDN.append(value.trim());
                break;
            }
            value = dn.substring(prevIndex + 1, currentIndex);
            normalizedDN.append(value.trim());
            normalizedDN.append(',');
            if (currentIndex >= dn.length() - 1) {
                return null;
            }
            prevIndex = currentIndex + 1;
        }
        return normalizedDN.toString();
    }

    public static String reverseDN(String dn) {
        int currentIndex;
        StringBuffer reversedDN = new StringBuffer();
        String pair = null;
        int prevIndex = currentIndex = dn.length();
        do {
            if ((currentIndex = dn.lastIndexOf(44, currentIndex)) == -1) {
                reversedDN.append(dn.substring(0, prevIndex));
                break;
            }
            pair = dn.substring(currentIndex + 1, prevIndex);
            reversedDN.append(pair);
            reversedDN.append(',');
            prevIndex = currentIndex--;
        } while (currentIndex != -1);
        return reversedDN.toString();
    }

    static {
        try {
            $$$methodRef$$$12 = TcpsConfigure.class.getDeclaredConstructor(new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = TcpsConfigure.class.getDeclaredMethod("reverseDN", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = TcpsConfigure.class.getDeclaredMethod("normalizeDN", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = TcpsConfigure.class.getDeclaredMethod("matchServerDN", String.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = TcpsConfigure.class.getDeclaredMethod("matchHostNames", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = TcpsConfigure.class.getDeclaredMethod("getDNSSubjectAlts", X509Certificate.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = TcpsConfigure.class.getDeclaredMethod("matchSANs", X509Certificate.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = TcpsConfigure.class.getDeclaredMethod("matchCN", X509Certificate.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = TcpsConfigure.class.getDeclaredMethod("matchHostName", X509Certificate.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = TcpsConfigure.class.getDeclaredMethod("matchServerDN", X509Certificate.class, String.class, Boolean.TYPE, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = TcpsConfigure.class.getDeclaredMethod("getAllSupportedProtocols", Boolean.TYPE, SSLEngine.class, SSLSocket.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = TcpsConfigure.class.getDeclaredMethod("configureCipherSuites", SSLSocket.class, SSLEngine.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = TcpsConfigure.class.getDeclaredMethod("configureVersion", SSLSocket.class, SSLEngine.class, String.class, Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        VALID_SSL_VERSION_STRINGS = new String[]{"0", "undetermined", "2", "2.0", "version 2", "3", "3.0", "version 3 only", "1", "1.0", "version 1 only", "1 or 3", "1.0 or 3.0", "version 1 or version 3", "1.1", "1.2", "1.1 or 3.0", "1.2 or 3.0", "1.1 or 1.0", "1.2 or 1.0", "1.2 or 1.1", "1.1 or 1.0 or 3.0", "1.2 or 1.0 or 3.0", "1.2 or 1.1 or 1.0", "1.2 or 1.1 or 3.0", "1.2 or 1.1 or 1.0 or 3.0"};
        TABLE_ENABLED_SSL_PROTOCOLS = new String[][]{{"TLSv1.2", "TLSv1.1", "TLSv1"}, {"SSLv2Hello"}, {"SSLv3"}, {"TLSv1"}, {"TLSv1", "SSLv3"}, {"TLSv1.1"}, {"TLSv1.2"}, {"TLSv1.1", "SSLv3"}, {"TLSv1.2", "SSLv3"}, {"TLSv1.1", "TLSv1"}, {"TLSv1.2", "TLSv1"}, {"TLSv1.2", "TLSv1.1"}, {"TLSv1.1", "TLSv1", "SSLv3"}, {"TLSv1.2", "TLSv1", "SSLv3"}, {"TLSv1.2", "TLSv1.1", "TLSv1"}, {"TLSv1.2", "TLSv1.1", "SSLv3"}, {"TLSv1.2", "TLSv1.1", "TLSv1", "SSLv3"}};
        VALID_SSL_STRING_TO_PROTOCOLS_MAP = new int[]{0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        UNSUPPORTED_PROTOCOLS_SET = new HashSet();
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv3");
        UNSUPPORTED_PROTOCOLS_SET.add("SSLv2Hello");
    }
}

