/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.management;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import org.firebirdsql.gds.ServiceRequestBuffer;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.FbService;
import org.firebirdsql.management.FBServiceManager;
import org.firebirdsql.management.FBUser;
import org.firebirdsql.management.User;
import org.firebirdsql.management.UserManager;

public class FBUserManager
extends FBServiceManager
implements UserManager {
    private int count = 0;
    private String securityDatabase = null;

    public FBUserManager() {
    }

    public FBUserManager(String gdsType) {
        super(gdsType);
    }

    public FBUserManager(GDSType gdsType) {
        super(gdsType);
    }

    private Map<String, User> getFBUsers() throws SQLException, IOException {
        User user = null;
        TreeMap<String, User> users = new TreeMap<String, User>();
        byte[] displayBuffer = ((ByteArrayOutputStream)this.getLogger()).toByteArray();
        this.count = 0;
        block8: while (this.count < displayBuffer.length && displayBuffer[this.count] != 1) {
            switch (displayBuffer[this.count]) {
                case 7: {
                    if (user != null) {
                        users.put(user.getUserName(), user);
                    }
                    user = new FBUser();
                    user.setUserName(this.getSRBString(displayBuffer));
                    continue block8;
                }
                case 10: {
                    assert (user != null) : "Should have a non null user";
                    user.setFirstName(this.getSRBString(displayBuffer));
                    continue block8;
                }
                case 11: {
                    assert (user != null) : "Should have a non null user";
                    user.setMiddleName(this.getSRBString(displayBuffer));
                    continue block8;
                }
                case 12: {
                    assert (user != null) : "Should have a non null user";
                    user.setLastName(this.getSRBString(displayBuffer));
                    continue block8;
                }
                case 5: {
                    assert (user != null) : "Should have a non null user";
                    user.setUserId(this.getSRBInteger(displayBuffer));
                    continue block8;
                }
                case 6: {
                    assert (user != null) : "Should have a non null user";
                    user.setGroupId(this.getSRBInteger(displayBuffer));
                    continue block8;
                }
            }
            ++this.count;
        }
        if (user != null) {
            users.put(user.getUserName(), user);
        }
        return users;
    }

    private ServiceRequestBuffer getUserSRB(FbService service, int action, User user) {
        ServiceRequestBuffer srb = service.createServiceRequestBuffer();
        srb.addArgument(action);
        if (user.getUserName() != null) {
            srb.addArgument(7, user.getUserName());
        }
        if (user.getPassword() != null) {
            srb.addArgument(8, user.getPassword());
        }
        if (user.getFirstName() != null) {
            srb.addArgument(10, user.getFirstName());
        }
        if (user.getMiddleName() != null) {
            srb.addArgument(11, user.getMiddleName());
        }
        if (user.getLastName() != null) {
            srb.addArgument(12, user.getLastName());
        }
        if (user.getUserId() != -1) {
            srb.addArgument(5, user.getUserId());
        }
        if (user.getGroupId() != -1) {
            srb.addArgument(6, user.getGroupId());
        }
        return srb;
    }

    private int getSRBInteger(byte[] displayBuffer) {
        ++this.count;
        int integer = VaxEncoding.iscVaxInteger(displayBuffer, this.count, 4);
        this.count += 4;
        return integer;
    }

    private String getSRBString(byte[] displayBuffer) {
        ++this.count;
        int length = VaxEncoding.iscVaxInteger(displayBuffer, this.count, 2);
        this.count += 2;
        String string = new String(displayBuffer, this.count, length);
        this.count += length;
        return string;
    }

    private void setSecurityDatabaseArgument(ServiceRequestBuffer srb) {
        if (this.securityDatabase != null) {
            srb.addArgument(106, this.securityDatabase);
        }
    }

    private void userAction(int action, User user) throws SQLException, IOException {
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = this.getUserSRB(service, action, user);
            this.setSecurityDatabaseArgument(srb);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void add(User user) throws SQLException, IOException {
        if (user.getUserName() == null) {
            throw new SQLException("UserName is required.");
        }
        this.userAction(4, user);
    }

    @Override
    public void delete(User user) throws SQLException, IOException {
        if (user.getUserName() == null) {
            throw new SQLException("UserName is required.");
        }
        FBUser delUser = new FBUser();
        delUser.setUserName(user.getUserName());
        this.userAction(5, delUser);
    }

    @Override
    public void update(User user) throws SQLException, IOException {
        if (user.getUserName() == null) {
            throw new SQLException("UserName is required.");
        }
        this.userAction(6, user);
    }

    @Override
    public Map<String, User> getUsers() throws SQLException, IOException {
        OutputStream savedStream = this.getLogger();
        this.setLogger(new ByteArrayOutputStream());
        try {
            this.userAction(7, new FBUser());
            Map<String, User> map = this.getFBUsers();
            return map;
        }
        finally {
            this.setLogger(savedStream);
        }
    }

    @Override
    public void setSecurityDatabase(String securityDatabase) {
        this.securityDatabase = securityDatabase;
    }

    private void adminRoleAction(int action) throws SQLException, IOException {
        try (FbService service = this.attachServiceManager();){
            ServiceRequestBuffer srb = service.createServiceRequestBuffer();
            srb.addArgument(action);
            this.setSecurityDatabaseArgument(srb);
            this.executeServicesOperation(service, srb);
        }
    }

    @Override
    public void setAdminRoleMapping() throws SQLException, IOException {
        this.adminRoleAction(27);
    }

    @Override
    public void dropAdminRoleMapping() throws SQLException, IOException {
        this.adminRoleAction(28);
    }
}

