/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.fields.FieldDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.DefaultStatementListener;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDatabaseMetaData;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBResultSetNotUpdatableException;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FirebirdRowUpdater;
import org.firebirdsql.jdbc.QuoteStrategy;
import org.firebirdsql.jdbc.Synchronizable;
import org.firebirdsql.jdbc.field.FBField;
import org.firebirdsql.jdbc.field.FBFlushableField;
import org.firebirdsql.jdbc.field.FieldDataProvider;
import org.firebirdsql.util.SQLExceptionChainBuilder;

public class FBRowUpdater
implements FirebirdRowUpdater {
    private static final int PARAMETER_UNUSED = 0;
    private static final int PARAMETER_USED = 1;
    private static final int PARAMETER_DBKEY = 2;
    private static final byte[][] EMPTY_2D_BYTES = new byte[0][];
    private final FBConnection connection;
    private final GDSHelper gdsHelper;
    private final Synchronizable syncProvider;
    private final RowDescriptor rowDescriptor;
    private final FBField[] fields;
    private final QuoteStrategy quoteStrategy;
    private boolean inInsertRow;
    private RowValue newRow;
    private RowValue oldRow;
    private RowValue insertRow;
    private boolean[] updatedFlags;
    private String tableName;
    private FbStatement updateStatement;
    private FbStatement deleteStatement;
    private FbStatement insertStatement;
    private FbStatement selectStatement;
    private final FBObjectListener.ResultSetListener rsListener;
    private boolean closed;
    private boolean processing;
    private static final int UPDATE_STATEMENT_TYPE = 1;
    private static final int DELETE_STATEMENT_TYPE = 2;
    private static final int INSERT_STATEMENT_TYPE = 3;
    private static final int SELECT_STATEMENT_TYPE = 4;

    public FBRowUpdater(FBConnection connection, RowDescriptor rowDescriptor, Synchronizable syncProvider, boolean cached, FBObjectListener.ResultSetListener rsListener) throws SQLException {
        this.rsListener = rsListener;
        this.connection = connection;
        this.gdsHelper = connection.getGDSHelper();
        this.syncProvider = syncProvider;
        this.rowDescriptor = rowDescriptor;
        this.fields = new FBField[rowDescriptor.getCount()];
        this.quoteStrategy = QuoteStrategy.forDialect(this.gdsHelper.getDialect());
        this.newRow = rowDescriptor.createDefaultFieldValues();
        this.updatedFlags = new boolean[rowDescriptor.getCount()];
        for (int i = 0; i < rowDescriptor.getCount(); ++i) {
            final int fieldPos = i;
            FieldDataProvider dataProvider = new FieldDataProvider(){

                @Override
                public byte[] getFieldData() {
                    if (!FBRowUpdater.this.updatedFlags[fieldPos]) {
                        return FBRowUpdater.this.oldRow.getFieldData(fieldPos);
                    }
                    if (FBRowUpdater.this.inInsertRow) {
                        return FBRowUpdater.this.insertRow.getFieldData(fieldPos);
                    }
                    return FBRowUpdater.this.newRow.getFieldData(fieldPos);
                }

                @Override
                public void setFieldData(byte[] data) {
                    if (FBRowUpdater.this.inInsertRow) {
                        FBRowUpdater.this.insertRow.setFieldData(fieldPos, data);
                    } else {
                        FBRowUpdater.this.newRow.setFieldData(fieldPos, data);
                    }
                    ((FBRowUpdater)FBRowUpdater.this).updatedFlags[fieldPos] = true;
                }
            };
            this.fields[i] = FBField.createField(rowDescriptor.getFieldDescriptor(i), dataProvider, this.gdsHelper, cached);
        }
        for (FieldDescriptor fieldDescriptor : rowDescriptor) {
            if (this.tableName == null) {
                this.tableName = fieldDescriptor.getOriginalTableName();
                continue;
            }
            if (this.tableName.equals(fieldDescriptor.getOriginalTableName())) continue;
            throw new FBResultSetNotUpdatableException("Underlying result set references at least two relations: " + this.tableName + " and " + fieldDescriptor.getOriginalTableName() + ".");
        }
    }

    private void notifyExecutionStarted() throws SQLException {
        if (this.closed) {
            throw new FBSQLException("Corresponding result set is closed.");
        }
        if (this.processing) {
            return;
        }
        this.rsListener.executionStarted(this);
        this.processing = true;
    }

    private void notifyExecutionCompleted(boolean success) throws SQLException {
        if (!this.processing) {
            return;
        }
        this.rsListener.executionCompleted(this, success);
        this.processing = false;
    }

    private void deallocateStatement(FbStatement handle, SQLExceptionChainBuilder<SQLException> chain) {
        if (handle == null) {
            return;
        }
        try {
            handle.close();
        }
        catch (SQLException ex) {
            chain.append(ex);
        }
    }

    @Override
    public void close() throws SQLException {
        SQLExceptionChainBuilder<SQLException> chain = new SQLExceptionChainBuilder<SQLException>();
        this.deallocateStatement(this.selectStatement, chain);
        this.deallocateStatement(this.insertStatement, chain);
        this.deallocateStatement(this.updateStatement, chain);
        this.deallocateStatement(this.deleteStatement, chain);
        if (chain.hasException()) {
            throw chain.getException();
        }
        this.closed = true;
        if (this.processing) {
            this.notifyExecutionCompleted(true);
        }
    }

    @Override
    public void setRow(RowValue row) {
        this.oldRow = row;
        this.updatedFlags = new boolean[this.rowDescriptor.getCount()];
        this.inInsertRow = false;
    }

    @Override
    public void cancelRowUpdates() {
        this.newRow = this.rowDescriptor.createDefaultFieldValues();
        this.updatedFlags = new boolean[this.rowDescriptor.getCount()];
        this.inInsertRow = false;
    }

    @Override
    public FBField getField(int fieldPosition) {
        return this.fields[fieldPosition];
    }

    private int[] getParameterMask() throws SQLException {
        FBDatabaseMetaData metaData = (FBDatabaseMetaData)this.connection.getMetaData();
        try (ResultSet bestRowIdentifier = metaData.getBestRowIdentifier("", "", this.tableName, 1, true);){
            int[] result = new int[this.rowDescriptor.getCount()];
            boolean hasParams = false;
            while (bestRowIdentifier.next()) {
                String columnName = bestRowIdentifier.getString(2);
                if (columnName == null) continue;
                for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
                    if ("RDB$DB_KEY".equals(columnName) && this.rowDescriptor.getFieldDescriptor(i).isDbKey()) {
                        result[i] = 2;
                        hasParams = true;
                        continue;
                    }
                    if (!columnName.equals(this.rowDescriptor.getFieldDescriptor(i).getOriginalName())) continue;
                    result[i] = 1;
                    hasParams = true;
                }
                if (hasParams) continue;
                throw new FBResultSetNotUpdatableException("Underlying result set does not contain all columns that form 'best row identifier'.");
            }
            if (!hasParams) {
                throw new FBResultSetNotUpdatableException("No columns that can be used in WHERE clause could be found.");
            }
            int[] nArray = result;
            return nArray;
        }
    }

    private void appendWhereClause(StringBuilder sb, int[] parameterMask) {
        sb.append("WHERE ");
        boolean hasDbKey = false;
        for (int aParameterMask : parameterMask) {
            if (aParameterMask != 2) continue;
            hasDbKey = true;
            break;
        }
        if (hasDbKey) {
            sb.append("RDB$DB_KEY = ?");
            return;
        }
        boolean first = true;
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            if (parameterMask[i] == 0) continue;
            if (!first) {
                sb.append(" AND");
            }
            sb.append("\n\t");
            this.quoteStrategy.appendQuoted(this.rowDescriptor.getFieldDescriptor(i).getOriginalName(), sb).append(" = ?");
            first = false;
        }
    }

    private String buildUpdateStatement(int[] parameterMask) {
        StringBuilder sb = new StringBuilder("UPDATE ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append("\nSET\n");
        boolean first = true;
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            if (!this.updatedFlags[i]) continue;
            if (!first) {
                sb.append(',');
            }
            sb.append("\n\t");
            this.quoteStrategy.appendQuoted(this.rowDescriptor.getFieldDescriptor(i).getOriginalName(), sb).append(" = ?");
            first = false;
        }
        sb.append('\n');
        this.appendWhereClause(sb, parameterMask);
        return sb.toString();
    }

    private String buildDeleteStatement(int[] parameterMask) {
        StringBuilder sb = new StringBuilder("DELETE FROM ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append('\n');
        this.appendWhereClause(sb, parameterMask);
        return sb.toString();
    }

    private String buildInsertStatement() {
        StringBuilder columns = new StringBuilder();
        StringBuilder params = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            if (!this.updatedFlags[i]) continue;
            if (!first) {
                columns.append(',');
                params.append(',');
            }
            this.quoteStrategy.appendQuoted(this.rowDescriptor.getFieldDescriptor(i).getOriginalName(), columns);
            params.append('?');
            first = false;
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append(" (").append((CharSequence)columns).append(") VALUES (").append((CharSequence)params).append(')');
        return sb.toString();
    }

    private String buildSelectStatement(int[] parameterMask) {
        StringBuilder columns = new StringBuilder();
        boolean first = true;
        for (FieldDescriptor fieldDescriptor : this.rowDescriptor) {
            if (!first) {
                columns.append(',');
            }
            if (fieldDescriptor.isDbKey()) {
                columns.append("RDB$DB_KEY");
            } else {
                this.quoteStrategy.appendQuoted(fieldDescriptor.getOriginalName(), columns);
            }
            first = false;
        }
        StringBuilder sb = new StringBuilder("SELECT ");
        sb.append((CharSequence)columns).append('\n').append("FROM ");
        this.quoteStrategy.appendQuoted(this.tableName, sb).append('\n');
        this.appendWhereClause(sb, parameterMask);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow() throws SQLException {
        boolean success = false;
        Object object = this.syncProvider.getSynchronizationObject();
        synchronized (object) {
            try {
                this.notifyExecutionStarted();
                if (this.updateStatement == null) {
                    this.updateStatement = this.gdsHelper.allocateStatement();
                } else {
                    this.updateStatement.setTransaction(this.gdsHelper.getCurrentTransaction());
                }
                this.executeStatement(1, this.updateStatement);
                success = true;
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteRow() throws SQLException {
        boolean success = false;
        Object object = this.syncProvider.getSynchronizationObject();
        synchronized (object) {
            try {
                this.notifyExecutionStarted();
                if (this.deleteStatement == null) {
                    this.deleteStatement = this.gdsHelper.allocateStatement();
                } else {
                    this.deleteStatement.setTransaction(this.gdsHelper.getCurrentTransaction());
                }
                this.executeStatement(2, this.deleteStatement);
                success = true;
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertRow() throws SQLException {
        boolean success = false;
        Object object = this.syncProvider.getSynchronizationObject();
        synchronized (object) {
            try {
                this.notifyExecutionStarted();
                if (this.insertStatement == null) {
                    this.insertStatement = this.gdsHelper.allocateStatement();
                } else {
                    this.insertStatement.setTransaction(this.gdsHelper.getCurrentTransaction());
                }
                this.executeStatement(3, this.insertStatement);
                success = true;
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshRow() throws SQLException {
        boolean success = false;
        Object object = this.syncProvider.getSynchronizationObject();
        synchronized (object) {
            try {
                this.notifyExecutionStarted();
                if (this.selectStatement == null) {
                    this.selectStatement = this.gdsHelper.allocateStatement();
                } else {
                    this.selectStatement.setTransaction(this.gdsHelper.getCurrentTransaction());
                }
                RowListener rowListener = new RowListener();
                this.selectStatement.addStatementListener(rowListener);
                try {
                    this.executeStatement(4, this.selectStatement);
                    this.selectStatement.fetchRows(10);
                    List<RowValue> rows = rowListener.getRows();
                    if (rows.size() == 0) {
                        throw new SQLException("No rows could be fetched.");
                    }
                    if (rows.size() > 1) {
                        throw new SQLException("More then one row fetched.");
                    }
                    this.setRow(rows.get(0));
                }
                finally {
                    this.selectStatement.removeStatementListener(rowListener);
                    this.selectStatement.closeCursor();
                }
                success = true;
            }
            finally {
                this.notifyExecutionCompleted(success);
            }
        }
    }

    private void executeStatement(int statementType, FbStatement stmt) throws SQLException {
        String sql;
        if (this.inInsertRow && statementType != 3) {
            throw new SQLException("Only insertRow() is allowed when result set is positioned on insert row.");
        }
        if (statementType != 3 && this.oldRow == null) {
            throw new SQLException("Result set is not positioned on a row.");
        }
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            if (!(this.fields[i] instanceof FBFlushableField)) continue;
            ((FBFlushableField)((Object)this.fields[i])).flushCachedData();
        }
        int[] parameterMask = this.getParameterMask();
        switch (statementType) {
            case 1: {
                sql = this.buildUpdateStatement(parameterMask);
                break;
            }
            case 2: {
                sql = this.buildDeleteStatement(parameterMask);
                break;
            }
            case 3: {
                sql = this.buildInsertStatement();
                break;
            }
            case 4: {
                sql = this.buildSelectStatement(parameterMask);
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrect statement type specified.");
            }
        }
        stmt.prepare(sql);
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        if (statementType == 1) {
            for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
                if (!this.updatedFlags[i]) continue;
                params.add(this.newRow.getFieldData(i));
            }
        }
        RowValue source = statementType == 3 ? this.insertRow : this.oldRow;
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            if (parameterMask[i] == 0 && statementType != 3 || !this.updatedFlags[i] && statementType == 3) continue;
            params.add(source.getFieldData(i));
        }
        stmt.execute(RowValue.of((byte[][])params.toArray((T[])EMPTY_2D_BYTES)));
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public RowValue getNewRow() {
        RowValue newRowCopy = this.rowDescriptor.createDefaultFieldValues();
        for (int i = 0; i < this.rowDescriptor.getCount(); ++i) {
            RowValue source = this.updatedFlags[i] ? this.newRow : this.oldRow;
            byte[] fieldData = source.getFieldData(i);
            newRowCopy.setFieldData(i, fieldData != null ? (byte[])fieldData.clone() : null);
        }
        return newRowCopy;
    }

    @Override
    public RowValue getInsertRow() {
        return this.insertRow;
    }

    @Override
    public RowValue getOldRow() {
        return this.oldRow;
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.inInsertRow = true;
        this.insertRow = this.rowDescriptor.createDefaultFieldValues();
        this.updatedFlags = new boolean[this.rowDescriptor.getCount()];
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.inInsertRow = false;
        this.insertRow = this.rowDescriptor.createDefaultFieldValues();
        this.updatedFlags = new boolean[this.rowDescriptor.getCount()];
    }

    private static class RowListener
    extends DefaultStatementListener {
        private final List<RowValue> rows = new ArrayList<RowValue>();

        private RowListener() {
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            this.rows.add(rowValue);
        }

        public List<RowValue> getRows() {
            return this.rows;
        }
    }
}

