/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.server.postgresql;

import java.io.IOException;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.RegularExpressionExclusionRule;
import schemacrawler.plugin.EnumDataTypeHelper;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.server.postgresql.PostgreSQLEnumDataTypeHelper;
import schemacrawler.tools.databaseconnector.DatabaseConnectionUrlBuilder;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.executable.commandline.PluginCommand;

public final class PostgreSQLDatabaseConnector
extends DatabaseConnector {
    public PostgreSQLDatabaseConnector() throws IOException {
        super(new DatabaseServerType("postgresql", "PostgreSQL"), url -> url != null && url.startsWith("jdbc:postgresql:"), (informationSchemaViewsBuilder, connection) -> informationSchemaViewsBuilder.fromResourceFolder("/postgresql.information_schema"), (schemaRetrievalOptionsBuilder, connection) -> schemaRetrievalOptionsBuilder.withEnumDataTypeHelper((EnumDataTypeHelper)new PostgreSQLEnumDataTypeHelper()), limitOptionsBuilder -> limitOptionsBuilder.includeSchemas((InclusionRule)new RegularExpressionExclusionRule("pg_catalog|information_schema")), () -> DatabaseConnectionUrlBuilder.builder((String)"jdbc:postgresql://${host}:${port}/${database}?ApplicationName=SchemaCrawler;loggerLevel=DEBUG").withDefaultPort(5432));
    }

    public PluginCommand getHelpCommand() {
        PluginCommand pluginCommand = super.getHelpCommand();
        pluginCommand.addOption("server", String.class, new String[]{"--server=postgresql%nLoads SchemaCrawler plug-in for PostgreSQL"}).addOption("host", String.class, new String[]{"Host name%nOptional, uses the PGHOSTADDR and PGHOST environmental variables if available, or defaults to localhost"}).addOption("port", Integer.class, new String[]{"Port number%nOptional, uses the PGPORT environmental variable if available, or defaults to 5432"}).addOption("database", String.class, new String[]{"Database name%nOptional, uses the PGDATABASE environmental variable if available"});
        return pluginCommand;
    }
}

