/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.lint.options;

import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.tools.options.OutputFormat;
import schemacrawler.tools.options.OutputFormatState;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

public enum LintReportOutputFormat implements OutputFormat
{
    text("Plain text format", "txt"),
    html("HyperText Markup Language (HTML) format"),
    json("JavaScript Object Notation (JSON) format"),
    yaml("YAML Ain't Markup Language (YAML) format");

    private static final Logger LOGGER;
    private final OutputFormatState outputFormatState;

    public static LintReportOutputFormat fromFormat(String format) {
        LintReportOutputFormat outputFormat = LintReportOutputFormat.fromFormatOrNull(format);
        if (outputFormat == null) {
            LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Unknown format <%s>, using default", new Object[]{format}));
            return text;
        }
        return outputFormat;
    }

    public static boolean isSupportedFormat(String format) {
        return LintReportOutputFormat.fromFormatOrNull(format) != null;
    }

    private static LintReportOutputFormat fromFormatOrNull(String format) {
        if (Utility.isBlank((CharSequence)format)) {
            return null;
        }
        for (LintReportOutputFormat outputFormat : LintReportOutputFormat.values()) {
            if (!outputFormat.outputFormatState.isSupportedFormat(format)) continue;
            return outputFormat;
        }
        return null;
    }

    private LintReportOutputFormat(String description) {
        this.outputFormatState = new OutputFormatState(this.name(), description, new String[0]);
    }

    private LintReportOutputFormat(String description, String formatSpecifier) {
        this.outputFormatState = new OutputFormatState(formatSpecifier, description, new String[]{this.name()});
    }

    public String getDescription() {
        return this.outputFormatState.getDescription();
    }

    public String getFormat() {
        return this.outputFormatState.getFormat();
    }

    public List<String> getFormats() {
        return this.outputFormatState.getFormats();
    }

    public String toString() {
        return this.outputFormatState.toString();
    }

    static {
        LOGGER = Logger.getLogger(LintReportOutputFormat.class.getName());
    }
}

