/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.Column;
import schemacrawler.schema.JavaSqlTypeGroup;
import schemacrawler.schema.Table;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintSeverity;
import schemacrawler.tools.options.Config;

public class LinterTooManyLobs
extends BaseLinter {
    private int maxLargeObjectsInTable;

    public LinterTooManyLobs() {
        this.setSeverity(LintSeverity.low);
        this.maxLargeObjectsInTable = 1;
    }

    @Override
    public String getSummary() {
        return "too many binary objects";
    }

    @Override
    protected void configure(Config config) {
        Objects.requireNonNull(config, "No configuration provided");
        this.maxLargeObjectsInTable = config.getIntegerValue("max-large-objects", 1);
    }

    @Override
    protected void lint(Table table, Connection connection) {
        Objects.requireNonNull(table, "No table provided");
        ArrayList<Column> lobColumns = this.findLobColumns(this.getColumns(table));
        if (lobColumns.size() > this.maxLargeObjectsInTable) {
            this.addTableLint(table, this.getSummary(), lobColumns);
        }
    }

    private ArrayList<Column> findLobColumns(List<Column> columns) {
        ArrayList<Column> lobColumns = new ArrayList<Column>();
        for (Column column : columns) {
            JavaSqlTypeGroup javaSqlTypeGroup;
            if (!column.isColumnDataTypeKnown() || (javaSqlTypeGroup = column.getColumnDataType().getJavaSqlType().getJavaSqlTypeGroup()) != JavaSqlTypeGroup.large_object) continue;
            lobColumns.add(column);
        }
        return lobColumns;
    }
}

