/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.script;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.script.ScriptCommand;
import schemacrawler.tools.command.script.options.ScriptOptions;
import schemacrawler.tools.executable.BaseSchemaCrawlerCommand;
import schemacrawler.tools.executable.CommandRegistry;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.LanguageOptions;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;

public final class CommandChain
extends BaseSchemaCrawlerCommand<LanguageOptions> {
    private static final String COMMAND = "chain";
    private static final Logger LOGGER = Logger.getLogger(CommandChain.class.getName());
    private final CommandRegistry commandRegistry;
    private final List<SchemaCrawlerCommand<?>> scCommands;
    private final Config additionalConfig;

    public CommandChain(ScriptCommand scCommand) throws SchemaCrawlerException {
        super(COMMAND);
        Objects.requireNonNull(scCommand, "No command provided, for settings");
        this.commandRegistry = CommandRegistry.getCommandRegistry();
        this.scCommands = new ArrayList();
        this.additionalConfig = new Config(((ScriptOptions)scCommand.getCommandOptions()).getConfig());
        this.setSchemaCrawlerOptions(scCommand.getSchemaCrawlerOptions());
        this.setOutputOptions(scCommand.getOutputOptions());
        this.setCatalog(scCommand.getCatalog());
        this.setConnection(scCommand.getConnection());
        this.setIdentifiers(scCommand.getIdentifiers());
    }

    public final SchemaCrawlerCommand<?> addNext(String command, String outputFormat, String outputFileName) throws SchemaCrawlerException {
        Objects.requireNonNull(command, "No command provided");
        Objects.requireNonNull(outputFormat, "No output format provided");
        Objects.requireNonNull(outputFileName, "No output file name provided");
        Path outputFile = Paths.get(outputFileName, new String[0]);
        OutputOptions outputOptions = OutputOptionsBuilder.builder((OutputOptions)this.getOutputOptions()).withOutputFormatValue(outputFormat).withOutputFile(outputFile).toOptions();
        return this.addNextAndConfigureForExecution(command, outputOptions);
    }

    public void checkAvailability() throws Exception {
        this.checkAvailabilityChain();
    }

    public void execute() throws Exception {
        this.checkCatalog();
        this.initializeChain();
        this.checkAvailabilityChain();
        this.executeChain();
    }

    public boolean usesConnection() {
        return false;
    }

    private SchemaCrawlerCommand<?> addNextAndConfigureForExecution(String command, OutputOptions outputOptions) throws SchemaCrawlerException {
        try {
            SchemaCrawlerCommand scCommand = this.commandRegistry.configureNewCommand(command, this.schemaCrawlerOptions, this.additionalConfig, outputOptions);
            if (scCommand == null) {
                return null;
            }
            scCommand.setCatalog(this.catalog);
            scCommand.setConnection(this.connection);
            scCommand.setIdentifiers(this.identifiers);
            this.scCommands.add(scCommand);
            return scCommand;
        }
        catch (SchemaCrawlerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaCrawlerException(String.format("Cannot chain command, unknown command <%s>", command), (Throwable)e);
        }
    }

    private void checkAvailabilityChain() throws Exception {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No command to execute");
            return;
        }
        for (SchemaCrawlerCommand<?> scCommand : this.scCommands) {
            scCommand.checkAvailability();
        }
    }

    private void executeChain() throws Exception {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No command to execute");
            return;
        }
        for (SchemaCrawlerCommand<?> scCommand : this.scCommands) {
            scCommand.execute();
        }
    }

    private void initializeChain() throws Exception {
        if (this.scCommands.isEmpty()) {
            LOGGER.log(Level.INFO, "No command to initialize");
            return;
        }
        for (SchemaCrawlerCommand<?> scCommand : this.scCommands) {
            scCommand.initialize();
        }
    }
}

