/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.script;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.ScriptEngineManager;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.script.AbstractScriptEngineExecutor;
import us.fatehi.utility.string.StringFormat;

public final class ScriptEngineExecutor
extends AbstractScriptEngineExecutor {
    private static final Logger LOGGER = Logger.getLogger(ScriptEngineExecutor.class.getName());

    public ScriptEngineExecutor(String scriptingLanguage) {
        super(scriptingLanguage);
    }

    @Override
    public boolean canGenerate() {
        try {
            this.obtainScriptEngine();
            return this.scriptEngine != null;
        }
        catch (SchemaCrawlerException e) {
            LOGGER.log(Level.CONFIG, "Script engine not found for language, " + this.scriptingLanguage, e);
            return false;
        }
    }

    @Override
    protected void obtainScriptEngine() throws SchemaCrawlerException {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        LOGGER.log(Level.CONFIG, (Supplier<String>)new StringFormat("Using script language <%s>", new Object[]{this.scriptingLanguage}));
        try {
            this.scriptEngine = scriptEngineManager.getEngineByName(this.scriptingLanguage);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Script engine not found for language, " + this.scriptingLanguage);
        }
        if (this.scriptEngine == null) {
            this.scriptEngine = scriptEngineManager.getEngineByExtension(this.scriptingLanguage);
        }
        if (this.scriptEngine == null) {
            throw new SchemaCrawlerException("Script engine not found for language, " + this.scriptingLanguage);
        }
    }
}

