/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.template;

import java.io.Writer;
import java.nio.charset.Charset;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.FileTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.UrlTemplateResolver;
import schemacrawler.tools.command.template.BaseTemplateRenderer;
import schemacrawler.tools.options.OutputOptions;

public final class ThymeleafRenderer
extends BaseTemplateRenderer {
    private static ITemplateResolver configure(AbstractConfigurableTemplateResolver templateResolver, Charset inputEncoding) {
        templateResolver.setCharacterEncoding(inputEncoding.name());
        templateResolver.setTemplateMode("HTML5");
        return templateResolver;
    }

    @Override
    public void execute() throws Exception {
        OutputOptions outputOptions = this.getOutputOptions();
        Context context = new Context();
        context.setVariables(this.getContext());
        TemplateEngine templateEngine = new TemplateEngine();
        Charset inputCharset = outputOptions.getInputCharset();
        FileTemplateResolver fileResolver = new FileTemplateResolver();
        fileResolver.setCheckExistence(true);
        templateEngine.addTemplateResolver(ThymeleafRenderer.configure((AbstractConfigurableTemplateResolver)fileResolver, inputCharset));
        ClassLoaderTemplateResolver classpathResolver = new ClassLoaderTemplateResolver();
        classpathResolver.setCheckExistence(true);
        templateEngine.addTemplateResolver(ThymeleafRenderer.configure((AbstractConfigurableTemplateResolver)classpathResolver, inputCharset));
        UrlTemplateResolver urlResolver = new UrlTemplateResolver();
        urlResolver.setCheckExistence(true);
        templateEngine.addTemplateResolver(ThymeleafRenderer.configure((AbstractConfigurableTemplateResolver)urlResolver, inputCharset));
        String templateLocation = this.getResourceFilename();
        try (Writer writer = outputOptions.openNewOutputWriter();){
            templateEngine.process(templateLocation, (IContext)context, writer);
        }
    }
}

