/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.formatter.serialize;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.PropertyFilter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.PartialDatabaseObject;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.formatter.serialize.CatalogSerializer;

public abstract class BaseJacksonSerializedCatalog
implements CatalogSerializer {
    private final Catalog catalog;
    private final SortedSet<Column> allTableColumns;

    public BaseJacksonSerializedCatalog(Catalog catalog) {
        this.catalog = Objects.requireNonNull(catalog, "No catalog provided");
        this.allTableColumns = new TreeSet<Column>();
        this.loadAllTableColumns();
    }

    public Set<Column> getAllTableColumns() {
        return new TreeSet<Column>(this.allTableColumns);
    }

    @Override
    public Catalog getCatalog() {
        return this.catalog;
    }

    @Override
    public void save(OutputStream out) throws SchemaCrawlerException {
        Objects.requireNonNull(out, "No output stream provided");
        this.save(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    @Override
    public void save(Writer out) throws SchemaCrawlerException {
        Objects.requireNonNull(out, "No writer provided");
        try {
            ObjectMapper mapper = this.newConfiguredObjectMapper();
            mapper.writeValue(out, (Object)this);
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not serialize catalog", (Throwable)e);
        }
    }

    protected abstract ObjectMapper newObjectMapper();

    private void loadAllTableColumns() {
        for (Table table : this.catalog.getTables()) {
            for (Column column : table.getColumns()) {
                this.allTableColumns.add(column);
            }
        }
    }

    private ObjectMapper newConfiguredObjectMapper() {
        SimpleFilterProvider filters = new SimpleFilterProvider().addFilter("ignore-getter-errors-filter", (PropertyFilter)new IgnoreExceptionBeanPropertyFilter());
        ObjectMapper mapper = this.newObjectMapper();
        mapper.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT, SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID, SerializationFeature.WRITE_ENUMS_USING_TO_STRING});
        mapper.registerModule((Module)new JavaTimeModule());
        @JsonIgnoreProperties(value={"parent", "referenced-column", "exported-foreign-keys", "imported-foreign-keys"})
        @JsonPropertyOrder(value={"@uuid", "name", "short-name", "full-name", "crawl-info", "schema-crawler-info", "jvm-system-info", "operating-system-info", "database-info", "jdbc-driver-info", "schemas", "system-column-data-types", "column-data-types", "all-table-columns"}, alphabetic=true)
        @JsonIdentityInfo(generator=ObjectIdGenerators.UUIDGenerator.class, property="@uuid")
        @JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
        @JsonFilter(value="ignore-getter-errors-filter")
        class JacksonAnnotationMixIn {
            JacksonAnnotationMixIn() {
            }
        }
        mapper.addMixIn(Object.class, JacksonAnnotationMixIn.class);
        mapper.setFilterProvider((FilterProvider)filters);
        return mapper;
    }

    private static class IgnoreExceptionBeanPropertyFilter
    extends SimpleBeanPropertyFilter {
        private static final List<String> PARTIAL_PROPERTIES = Arrays.asList("name", "short-name", "full-name", "attributes", "parent-partial", "remarks", "schema");

        private IgnoreExceptionBeanPropertyFilter() {
        }

        public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider provider, PropertyWriter writer) throws Exception {
            if (this.include(writer)) {
                try {
                    if (pojo instanceof PartialDatabaseObject && !PARTIAL_PROPERTIES.contains(writer.getName())) {
                        return;
                    }
                    writer.serializeAsField(pojo, jgen, provider);
                }
                catch (Exception e) {
                    return;
                }
            } else if (!jgen.canOmitFields()) {
                writer.serializeAsOmittedField(pojo, jgen, provider);
            }
        }

        protected boolean include(BeanPropertyWriter writer) {
            return true;
        }

        protected boolean include(PropertyWriter writer) {
            return true;
        }
    }
}

