/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import schemacrawler.crawl.ImmutableJdbcDriverProperty;
import schemacrawler.schema.ConnectionInfo;
import schemacrawler.schema.JdbcDriverInfo;
import schemacrawler.schema.JdbcDriverProperty;
import us.fatehi.utility.Utility;

final class MutableJdbcDriverInfo
implements JdbcDriverInfo {
    private static final long serialVersionUID = 8030156654422512161L;
    private final String connectionUrl;
    private final String driverName;
    private final String driverVersion;
    private final int driverMajorVersion;
    private final int driverMinorVersion;
    private final int jdbcMajorVersion;
    private final int jdbcMinorVersion;
    private String driverClassName;
    private boolean jdbcCompliant;
    private final Set<ImmutableJdbcDriverProperty> jdbcDriverProperties;

    public MutableJdbcDriverInfo(ConnectionInfo connectionInfo) {
        Objects.requireNonNull(connectionInfo, "No connection information provided");
        this.connectionUrl = connectionInfo.getConnectionUrl();
        this.driverName = connectionInfo.getDriverName();
        this.driverVersion = connectionInfo.getDriverVersion();
        this.driverMajorVersion = connectionInfo.getDriverMajorVersion();
        this.driverMinorVersion = connectionInfo.getDriverMinorVersion();
        this.jdbcMajorVersion = connectionInfo.getJdbcMajorVersion();
        this.jdbcMinorVersion = connectionInfo.getJdbcMinorVersion();
        this.jdbcDriverProperties = new HashSet<ImmutableJdbcDriverProperty>();
        this.driverClassName = "";
        this.jdbcCompliant = false;
    }

    @Override
    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    @Override
    public String getDriverClassName() {
        return this.driverClassName;
    }

    @Override
    public int getDriverMajorVersion() {
        return this.driverMajorVersion;
    }

    @Override
    public int getDriverMinorVersion() {
        return this.driverMinorVersion;
    }

    @Override
    public Collection<JdbcDriverProperty> getDriverProperties() {
        ArrayList<JdbcDriverProperty> properties = new ArrayList<JdbcDriverProperty>(this.jdbcDriverProperties);
        properties.sort(Comparator.naturalOrder());
        return properties;
    }

    @Override
    public int getJdbcMajorVersion() {
        return this.jdbcMajorVersion;
    }

    @Override
    public int getJdbcMinorVersion() {
        return this.jdbcMinorVersion;
    }

    @Override
    public String getProductName() {
        return this.driverName;
    }

    @Override
    public String getProductVersion() {
        return this.driverVersion;
    }

    @Override
    public boolean hasDriverClassName() {
        return !Utility.isBlank(this.driverClassName);
    }

    @Override
    public boolean isJdbcCompliant() {
        return this.jdbcCompliant;
    }

    public String toString() {
        StringBuilder info = new StringBuilder(1024);
        info.append("-- driver: ").append(this.getProductName()).append(' ').append(this.getProductVersion()).append(System.lineSeparator());
        info.append("-- driver class: ").append(this.getDriverClassName()).append(System.lineSeparator());
        info.append("-- url: ").append(this.getConnectionUrl()).append(System.lineSeparator());
        info.append("-- jdbc compliant: ").append(this.isJdbcCompliant());
        return info.toString();
    }

    void addJdbcDriverProperty(ImmutableJdbcDriverProperty jdbcDriverProperty) {
        this.jdbcDriverProperties.add(jdbcDriverProperty);
    }

    void setJdbcCompliant(boolean jdbcCompliant) {
        this.jdbcCompliant = jdbcCompliant;
    }

    void setJdbcDriverClassName(String jdbcDriverClassName) {
        this.driverClassName = jdbcDriverClassName;
    }
}

