/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.utility;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.ConnectionInfoBuilder;
import schemacrawler.crawl.ResultsCrawler;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.ConnectionInfo;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schemacrawler.DatabaseServerType;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptions;
import schemacrawler.schemacrawler.SchemaRetrievalOptionsBuilder;
import schemacrawler.tools.catalogloader.CatalogLoaderRegistry;
import schemacrawler.tools.catalogloader.ChainedCatalogLoader;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.DatabaseUtility;
import us.fatehi.utility.PropertiesUtility;
import us.fatehi.utility.string.ObjectToStringFormat;
import us.fatehi.utility.string.StringFormat;

public final class SchemaCrawlerUtility {
    private static final Logger LOGGER = Logger.getLogger(SchemaCrawlerUtility.class.getName());

    public static Catalog getCatalog(Connection connection, SchemaCrawlerOptions schemaCrawlerOptions) throws SchemaCrawlerException {
        SchemaCrawlerUtility.checkConnection(connection);
        LOGGER.log(Level.CONFIG, new ObjectToStringFormat(schemaCrawlerOptions));
        SchemaRetrievalOptions schemaRetrievalOptions = SchemaCrawlerUtility.matchSchemaRetrievalOptions(connection);
        return SchemaCrawlerUtility.getCatalog(connection, schemaRetrievalOptions, schemaCrawlerOptions, new Config());
    }

    public static Catalog getCatalog(Connection connection, SchemaRetrievalOptions schemaRetrievalOptions, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig) throws SchemaCrawlerException {
        CatalogLoaderRegistry catalogLoaderRegistry = new CatalogLoaderRegistry();
        ChainedCatalogLoader catalogLoader = catalogLoaderRegistry.newChainedCatalogLoader();
        LOGGER.log(Level.CONFIG, new StringFormat("Catalog loader: %s", catalogLoader));
        SchemaCrawlerUtility.logConnection(connection);
        catalogLoader.setConnection(connection);
        catalogLoader.setSchemaRetrievalOptions(schemaRetrievalOptions);
        catalogLoader.setSchemaCrawlerOptions(schemaCrawlerOptions);
        catalogLoader.setAdditionalConfiguration(additionalConfig);
        catalogLoader.loadCatalog();
        Catalog catalog = catalogLoader.getCatalog();
        Objects.requireNonNull(catalog, "Catalog could not be retrieved");
        return catalog;
    }

    public static ResultsColumns getResultsColumns(ResultSet resultSet) throws SchemaCrawlerException {
        try {
            SchemaCrawlerUtility.checkResultSet(resultSet);
            ResultsCrawler resultSetCrawler = new ResultsCrawler(resultSet);
            ResultsColumns resultsColumns = resultSetCrawler.crawl();
            return resultsColumns;
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Could not retrieve result-set metadata", e);
        }
    }

    public static SchemaRetrievalOptions matchSchemaRetrievalOptions(Connection connection) throws SchemaCrawlerException {
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = SchemaCrawlerUtility.buildSchemaRetrievalOptions(connection);
        SchemaRetrievalOptions schemaRetrievalOptions = schemaRetrievalOptionsBuilder.toOptions();
        return schemaRetrievalOptions;
    }

    private static SchemaRetrievalOptionsBuilder buildSchemaRetrievalOptions(Connection connection) throws SchemaCrawlerException {
        SchemaCrawlerUtility.checkConnection(connection);
        DatabaseConnectorRegistry registry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        DatabaseConnector dbConnector = registry.findDatabaseConnector(connection);
        DatabaseServerType databaseServerType = dbConnector.getDatabaseServerType();
        LOGGER.log(Level.INFO, "Using database plugin for " + databaseServerType);
        String withoutDatabasePlugin = PropertiesUtility.getSystemConfigurationProperty("SC_WITHOUT_DATABASE_PLUGIN", "");
        if (!databaseServerType.isUnknownDatabaseSystem() && databaseServerType.getDatabaseSystemIdentifier().equalsIgnoreCase(withoutDatabasePlugin)) {
            dbConnector = DatabaseConnector.UNKNOWN;
        }
        SchemaRetrievalOptionsBuilder schemaRetrievalOptionsBuilder = dbConnector.getSchemaRetrievalOptionsBuilder(connection);
        return schemaRetrievalOptionsBuilder;
    }

    private static void checkConnection(Connection connection) throws SchemaCrawlerException {
        try {
            DatabaseUtility.checkConnection(connection);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Bad database connection", e);
        }
    }

    private static void checkResultSet(ResultSet resultSet) throws SchemaCrawlerException {
        try {
            DatabaseUtility.checkResultSet(resultSet);
        }
        catch (SQLException e) {
            throw new SchemaCrawlerException("Bad result-set", e);
        }
    }

    private static void logConnection(Connection connection) {
        if (connection == null || !LOGGER.isLoggable(Level.INFO)) {
            return;
        }
        try {
            ConnectionInfo connectionInfo = ConnectionInfoBuilder.builder(connection).build();
            LOGGER.log(Level.INFO, connectionInfo.toString());
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Could not log connection information", e);
        }
    }

    private SchemaCrawlerUtility() {
    }
}

