/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LRUCache;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.STATEMENT_CACHE})
final class LRUStatementCache {
    private int cacheSize;
    private final LRUCache<OraclePreparedStatement> implicitCache;
    private final LRUCache<OraclePreparedStatement> explicitCache;
    private boolean implicitCacheEnabled;
    private boolean explicitCacheEnabled;
    static final String DMS_HIT_COUNT_NAME = "StatementCacheHit";
    static final String DMS_HIT_COUNT_DESCRIPTION = "Statement found in cache";
    static final String DMS_MISS_COUNT_NAME = "StatementCacheMiss";
    static final String DMS_MISS_COUNT_DESCRIPTION = "Statement not found in cache";
    DMSFactory.DMSEvent dmsStatementCacheHitCount;
    DMSFactory.DMSEvent dmsStatementCacheMissCount;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;

    LRUStatementCache(int size) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$19, null, size);
            }
            this.implicitCache = new LRUCache(true);
            this.explicitCache = new LRUCache(false);
            this.implicitCacheEnabled = false;
            this.explicitCacheEnabled = false;
            this.dmsStatementCacheHitCount = null;
            this.dmsStatementCacheMissCount = null;
            if (size < 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$19, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$19, null, sQLException);
                }
                throw sQLException;
            }
            this.cacheSize = size;
            this.implicitCache.vacancy(size);
            this.explicitCache.vacancy(size);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$19, null);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$19, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createDMSSensors(DMSFactory.DMSNoun dMSNoun) {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void parent;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$0, this, dMSNoun);
            }
            this.dmsStatementCacheHitCount = DMSFactory.getInstance().createEvent((DMSFactory.DMSNoun)parent, DMS_HIT_COUNT_NAME, DMS_HIT_COUNT_DESCRIPTION);
            this.dmsStatementCacheMissCount = DMSFactory.getInstance().createEvent((DMSFactory.DMSNoun)parent, DMS_MISS_COUNT_NAME, DMS_MISS_COUNT_DESCRIPTION);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void resize(int n2) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void newSize;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$1, this, n2);
            }
            if (newSize < 0) {
                SQLException sQLException = (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 123).fillInStackTrace();
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            while (this.implicitCache.size() > newSize) {
                this.implicitCache.removeLeastRecent().exitImplicitCacheToClose();
            }
            while (this.explicitCache.size() > newSize) {
                this.explicitCache.removeLeastRecent().exitImplicitCacheToClose();
            }
            this.cacheSize = newSize;
            this.implicitCache.vacancy((int)newSize);
            this.explicitCache.vacancy((int)newSize);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setImplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$2, this, bl);
            }
            if (cache == false) {
                this.purgeImplicitCache();
            }
            this.implicitCacheEnabled = cache;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean getImplicitCachingEnabled() throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$3, this, new Object[0]);
            }
            boolean retValue = this.cacheSize == 0 ? false : this.implicitCacheEnabled;
            boolean bl2 = retValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$3, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$3, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setExplicitCachingEnabled(boolean bl) throws SQLException {
        boolean bl2 = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void cache;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$4, this, bl);
            }
            if (cache == false) {
                this.purgeExplicitCache();
            }
            this.explicitCacheEnabled = cache;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    public boolean getExplicitCachingEnabled() throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$5, this, new Object[0]);
            }
            boolean retValue = this.cacheSize == 0 ? false : this.explicitCacheEnabled;
            boolean bl2 = retValue;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$5, this, bl2);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$5, this, null);
            }
            return bl2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addToImplicitCache(OraclePreparedStatement oraclePreparedStatement, String string, int n2, int n3) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            void scrollType;
            void statementType;
            void stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this, oraclePreparedStatement, string, n2, n3);
            }
            if (!this.implicitCacheEnabled || 0 == this.cacheSize || stmt.cacheState == 2) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this);
                    ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this, null);
                }
                return;
            }
            stmt.enterImplicitCache();
            this.implicitCache.add((OraclePreparedStatement)stmt, (int)statementType, (int)scrollType, (String)sql);
            while (this.implicitCache.size() > this.cacheSize) {
                this.implicitCache.removeLeastRecent().exitImplicitCacheToClose();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void addToExplicitCache(OraclePreparedStatement oraclePreparedStatement, String string) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void key;
            void stmt;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this, oraclePreparedStatement, string);
            }
            if (!this.explicitCacheEnabled || 0 == this.cacheSize || stmt.cacheState == 2) {
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this);
                    ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this, null);
                }
                return;
            }
            stmt.enterExplicitCache();
            this.explicitCache.add((OraclePreparedStatement)stmt, 0, 0, (String)key);
            while (this.explicitCache.size() > this.cacheSize) {
                this.explicitCache.removeLeastRecent().exitExplicitCacheToClose();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    OracleStatement searchImplicitCache(String string, int n2, int n3, PhysicalConnection physicalConnection) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void sql;
            void scrollType;
            void statementType;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, string, n2, n3, physicalConnection);
            }
            if (!this.implicitCacheEnabled || 0 == this.cacheSize) {
                OracleStatement oracleStatement = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, oracleStatement);
                    ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, null);
                }
                return null;
            }
            OraclePreparedStatement stmt = this.implicitCache.removeMostRecent((int)statementType, (int)scrollType, (String)sql);
            if (null != stmt) {
                stmt.exitImplicitCacheToActive();
                this.dmsStatementCacheHitCount.occurred();
            } else {
                this.dmsStatementCacheMissCount.occurred();
            }
            OraclePreparedStatement oraclePreparedStatement = stmt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, oraclePreparedStatement);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, null);
            }
            return oraclePreparedStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    OracleStatement searchExplicitCache(String string) throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            void key;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, string);
            }
            if (!this.explicitCacheEnabled || 0 == this.cacheSize) {
                OracleStatement oracleStatement = null;
                if (bl) {
                    ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, oracleStatement);
                    ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, null);
                }
                return null;
            }
            OraclePreparedStatement stmt = this.explicitCache.removeMostRecent(0, 0, (String)key);
            if (null != stmt) {
                stmt.exitExplicitCacheToActive();
                this.dmsStatementCacheHitCount.occurred();
            } else {
                this.dmsStatementCacheMissCount.occurred();
            }
            OraclePreparedStatement oraclePreparedStatement = stmt;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, oraclePreparedStatement);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, null);
            }
            return oraclePreparedStatement;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    void purgeImplicitCache() throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$10, this, new Object[0]);
            }
            OraclePreparedStatement stmt = this.implicitCache.removeLeastRecent();
            while (null != stmt) {
                stmt.exitImplicitCacheToClose();
                stmt = this.implicitCache.removeLeastRecent();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$10, this);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$10, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    void purgeExplicitCache() throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$11, this, new Object[0]);
            }
            OraclePreparedStatement stmt = this.explicitCache.removeLeastRecent();
            while (null != stmt) {
                stmt.exitExplicitCacheToClose();
                stmt = this.explicitCache.removeLeastRecent();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$11, this);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$11, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    int getCacheSize() {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$12, this, new Object[0]);
            }
            int n2 = this.cacheSize;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$12, this, n2);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$12, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$12, this, throwable2);
            }
            throw throwable;
        }
    }

    void close() throws SQLException {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$13, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$13, this, new Object[0]);
            }
            OraclePreparedStatement stmt = this.implicitCache.removeLeastRecent();
            while (null != stmt) {
                stmt.exitImplicitCacheToClose();
                stmt = this.implicitCache.removeLeastRecent();
            }
            stmt = this.explicitCache.removeLeastRecent();
            while (null != stmt) {
                stmt.exitExplicitCacheToClose();
                stmt = this.explicitCache.removeLeastRecent();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$13, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$13, this);
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$13, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$13, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$13, this, throwable2);
            }
            throw throwable;
        }
    }

    private OracleConnection getConnectionDuringExceptionHandling() {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$14, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$14, this, new Object[0]);
            }
            OracleConnection oracleConnection = null;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$14, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$14, this, oracleConnection);
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$14, this, null);
            }
            return null;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$14, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$14, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void clearCursorIds() {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$15, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$15, this, new Object[0]);
            }
            this.implicitCache.forEach(oraclePreparedStatement -> {
                boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
                try {
                    OraclePreparedStatement p2;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$18, null, oraclePreparedStatement);
                    }
                    p2.clearCursorId();
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$18, null);
                        ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$18, null, null);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$18, null, throwable2);
                    }
                    throw throwable;
                }
            });
            this.explicitCache.forEach(oraclePreparedStatement -> {
                boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
                try {
                    OraclePreparedStatement p2;
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$17, null, oraclePreparedStatement);
                    }
                    p2.clearCursorId();
                    if (bl) {
                        ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$17, null);
                        ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$17, null, null);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (bl) {
                        ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$17, null, throwable2);
                    }
                    throw throwable;
                }
            });
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$15, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$15, this);
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$15, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$15, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$15, this, throwable2);
            }
            throw throwable;
        }
    }

    public String toString() {
        boolean bl = (0x20000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$16, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$16, this, new Object[0]);
            }
            String string = "implicitCache=" + this.implicitCache.toString() + ", explicitCache=" + this.explicitCache.toString();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$16, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$16, this, string);
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$16, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$16, Level.FINEST, LRUStatementCache.class, $$$methodRef$$$16, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$19 = LRUStatementCache.class.getDeclaredConstructor(Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = LRUStatementCache.class.getDeclaredMethod("lambda$clearCursorIds$0", OraclePreparedStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = LRUStatementCache.class.getDeclaredMethod("lambda$clearCursorIds$1", OraclePreparedStatement.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = LRUStatementCache.class.getDeclaredMethod("toString", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = LRUStatementCache.class.getDeclaredMethod("clearCursorIds", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = LRUStatementCache.class.getDeclaredMethod("getConnectionDuringExceptionHandling", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = LRUStatementCache.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = LRUStatementCache.class.getDeclaredMethod("getCacheSize", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = LRUStatementCache.class.getDeclaredMethod("purgeExplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = LRUStatementCache.class.getDeclaredMethod("purgeImplicitCache", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = LRUStatementCache.class.getDeclaredMethod("searchExplicitCache", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = LRUStatementCache.class.getDeclaredMethod("searchImplicitCache", String.class, Integer.TYPE, Integer.TYPE, PhysicalConnection.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = LRUStatementCache.class.getDeclaredMethod("addToExplicitCache", OraclePreparedStatement.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = LRUStatementCache.class.getDeclaredMethod("addToImplicitCache", OraclePreparedStatement.class, String.class, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = LRUStatementCache.class.getDeclaredMethod("getExplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = LRUStatementCache.class.getDeclaredMethod("setExplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = LRUStatementCache.class.getDeclaredMethod("getImplicitCachingEnabled", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = LRUStatementCache.class.getDeclaredMethod("setImplicitCachingEnabled", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = LRUStatementCache.class.getDeclaredMethod("resize", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = LRUStatementCache.class.getDeclaredMethod("createDMSSensors", DMSFactory.DMSNoun.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

