/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.util;

import com.amazon.redshift.logger.LogLevel;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazon.redshift.util.GT;
import com.amazon.redshift.util.RedshiftException;
import com.amazon.redshift.util.RedshiftState;
import java.lang.management.ManagementFactory;

public class RedshiftPropertyMaxResultBufferParser {
    private static final RedshiftLogger logger = RedshiftLogger.getDriverLogger();
    private static final String[] PERCENT_PHRASES = new String[]{"p", "pct", "percent"};

    public static long parseProperty(String value) throws RedshiftException {
        long result = -1L;
        if (RedshiftPropertyMaxResultBufferParser.checkIfValueContainsPercent(value)) {
            result = RedshiftPropertyMaxResultBufferParser.parseBytePercentValue(value);
        } else if (RedshiftPropertyMaxResultBufferParser.checkIfValueExistsToBeParsed(value)) {
            result = RedshiftPropertyMaxResultBufferParser.parseByteValue(value);
        }
        result = RedshiftPropertyMaxResultBufferParser.adjustResultSize(result);
        return result;
    }

    private static boolean checkIfValueContainsPercent(String value) {
        return value != null && RedshiftPropertyMaxResultBufferParser.getPercentPhraseLengthIfContains(value) != -1;
    }

    private static long parseBytePercentValue(String value) throws RedshiftException {
        long result = -1L;
        if (RedshiftPropertyMaxResultBufferParser.checkIfValueExistsToBeParsed(value)) {
            int length = RedshiftPropertyMaxResultBufferParser.getPercentPhraseLengthIfContains(value);
            if (length == -1) {
                RedshiftPropertyMaxResultBufferParser.throwExceptionAboutParsingError("Received MaxResultBuffer parameter can't be parsed. Value received to parse: {0}", value);
            }
            result = RedshiftPropertyMaxResultBufferParser.calculatePercentOfMemory(value, length);
        }
        return result;
    }

    private static int getPercentPhraseLengthIfContains(String valueToCheck) {
        int result = -1;
        for (String phrase : PERCENT_PHRASES) {
            int indx = RedshiftPropertyMaxResultBufferParser.getPhraseLengthIfContains(valueToCheck, phrase);
            if (indx == -1) continue;
            result = indx;
        }
        return result;
    }

    private static int getPhraseLengthIfContains(String valueToCheck, String phrase) {
        String subValue;
        int searchValueLength = phrase.length();
        if (valueToCheck.length() > searchValueLength && (subValue = valueToCheck.substring(valueToCheck.length() - searchValueLength)).equals(phrase)) {
            return searchValueLength;
        }
        return -1;
    }

    private static long calculatePercentOfMemory(String value, int percentPhraseLength) {
        String realValue = value.substring(0, value.length() - percentPhraseLength);
        double percent = Double.parseDouble(realValue) / 100.0;
        long result = (long)(percent * (double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax());
        return result;
    }

    private static boolean checkIfValueExistsToBeParsed(String value) {
        return value != null && value.length() != 0;
    }

    private static long parseByteValue(String value) throws RedshiftException {
        long result = -1L;
        long multiplier = 1L;
        long mul = 1000L;
        char sign = value.charAt(value.length() - 1);
        switch (sign) {
            case 'T': 
            case 't': {
                multiplier *= mul;
            }
            case 'G': 
            case 'g': {
                multiplier *= mul;
            }
            case 'M': 
            case 'm': {
                multiplier *= mul;
            }
            case 'K': 
            case 'k': {
                String realValue = value.substring(0, value.length() - 1);
                result = (long)Integer.parseInt(realValue) * (multiplier *= mul);
                break;
            }
            case '%': {
                return result;
            }
            default: {
                if (sign >= '0' && sign <= '9') {
                    result = Long.parseLong(value);
                    break;
                }
                RedshiftPropertyMaxResultBufferParser.throwExceptionAboutParsingError("Received MaxResultBuffer parameter can't be parsed. Value received to parse: {0}", value);
            }
        }
        return result;
    }

    private static long adjustResultSize(long value) {
        if ((double)value > 0.9 * (double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax()) {
            long newResult = (long)(0.9 * (double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax());
            if (RedshiftLogger.isEnable() && logger != null) {
                logger.log(LogLevel.INFO, GT.tr("WARNING! Required to allocate {0} bytes, which exceeded possible heap memory size. Assigned {1} bytes as limit.", String.valueOf(value), String.valueOf(newResult)), new Object[0]);
            }
            value = newResult;
        }
        return value;
    }

    private static void throwExceptionAboutParsingError(String message, Object ... values) throws RedshiftException {
        throw new RedshiftException(GT.tr(message, values), RedshiftState.SYNTAX_ERROR);
    }
}

