/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.sqlite;

import java.io.IOException;
import java.nio.file.Path;
import java.sql.Connection;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerOptionsBuilder;
import schemacrawler.tools.databaseconnector.DatabaseConnectionOptions;
import schemacrawler.tools.databaseconnector.DatabaseConnectionSource;
import schemacrawler.tools.databaseconnector.DatabaseUrlConnectionOptions;
import schemacrawler.tools.executable.SchemaCrawlerExecutable;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.options.OutputOptionsBuilder;
import schemacrawler.tools.sqlite.SQLiteDatabaseConnector;
import us.fatehi.utility.DatabaseUtility;
import us.fatehi.utility.IOUtility;

public class EmbeddedSQLiteWrapper {
    private static final Logger LOGGER = Logger.getLogger(EmbeddedSQLiteWrapper.class.getName());
    private Path databaseFile;

    public DatabaseConnectionSource createDatabaseConnectionSource() throws SchemaCrawlerException {
        Objects.requireNonNull(this.databaseFile, "Database file not loaded");
        try {
            DatabaseUrlConnectionOptions urlConnectionOptions = new DatabaseUrlConnectionOptions(this.getConnectionUrl());
            DatabaseConnectionSource connectionOptions = new SQLiteDatabaseConnector().newDatabaseConnectionSource((DatabaseConnectionOptions)urlConnectionOptions);
            return connectionOptions;
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Cannot read SQLite database file, " + this.databaseFile, (Throwable)e);
        }
    }

    public Path createDiagram(String title, String extension) throws Exception {
        try (Connection connection = this.createDatabaseConnectionSource().get();){
            Path path = this.createDiagram(connection, title, extension);
            return path;
        }
    }

    public String getConnectionUrl() {
        Objects.requireNonNull(this.databaseFile, "Database file not loaded");
        return "jdbc:sqlite:" + this.databaseFile.toString();
    }

    public String getDatabase() {
        if (this.databaseFile == null) {
            return "";
        }
        return this.databaseFile.toString();
    }

    public void loadDatabaseFile(Path dbFile) throws IOException {
        this.databaseFile = this.checkDatabaseFile(dbFile);
    }

    protected final Path checkDatabaseFile(Path dbFile) throws IOException {
        Path databaseFile = Objects.requireNonNull(dbFile, "No database file path provided").normalize().toAbsolutePath();
        if (!IOUtility.isFileReadable((Path)databaseFile)) {
            IOException e = new IOException("Cannot read database file, " + databaseFile);
            LOGGER.log(Level.FINE, e.getMessage(), e);
            throw e;
        }
        return databaseFile;
    }

    private Path createDiagram(Connection connection, String title, String extension) throws Exception {
        DatabaseUtility.checkConnection((Connection)connection);
        SchemaCrawlerOptions schemaCrawlerOptions = SchemaCrawlerOptionsBuilder.newSchemaCrawlerOptions();
        Path diagramFile = IOUtility.createTempFilePath((String)"schemacrawler", (String)extension);
        OutputOptions outputOptions = OutputOptionsBuilder.builder().title(title).withOutputFormatValue(extension).withOutputFile(diagramFile).toOptions();
        SchemaCrawlerExecutable executable = new SchemaCrawlerExecutable("schema");
        executable.setSchemaCrawlerOptions(schemaCrawlerOptions);
        executable.setOutputOptions(outputOptions);
        executable.setConnection(connection);
        executable.execute();
        return diagramFile;
    }
}

