/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.mapping;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;

public enum MonetDBToJavaMapping {
    Boolean(Boolean.class),
    Char(String.class),
    Varchar(String.class),
    Clob(String.class),
    Tinyint(Byte.class),
    Smallint(Short.class),
    Int(Integer.class),
    Bigint(Long.class),
    Decimal(BigDecimal.class),
    Real(Float.class),
    Double(Double.class),
    MonthInterval(Integer.class),
    SecondInterval(Long.class),
    Time(Time.class),
    TimeTz(Time.class),
    Date(Date.class),
    Timestamp(Timestamp.class),
    TimestampTz(Timestamp.class),
    Blob(byte[].class),
    Oid(String.class);

    private static final HashMap<String, MonetDBToJavaMapping> monetDBMappings;
    private final Class<?> javaClass;

    public static MonetDBToJavaMapping getJavaMappingFromMonetDBString(String sqlName) throws MonetDBEmbeddedException {
        MonetDBToJavaMapping attempt = monetDBMappings.get(sqlName);
        if (attempt == null) {
            throw new MonetDBEmbeddedException("The SQL type " + sqlName + " is not mapped");
        }
        return attempt;
    }

    public static int getJavaMappingFromMonetDBStringOrdinalValue(String sqlName) throws MonetDBEmbeddedException {
        MonetDBToJavaMapping attempt = monetDBMappings.get(sqlName);
        if (attempt == null) {
            throw new MonetDBEmbeddedException("The SQL type " + sqlName + " is not mapped");
        }
        return monetDBMappings.get(sqlName).ordinal();
    }

    private MonetDBToJavaMapping(Class<?> javaClass) {
        this.javaClass = javaClass;
    }

    public <T> Class<T> getJavaClass() {
        return this.javaClass;
    }

    static {
        monetDBMappings = new HashMap();
        monetDBMappings.put("boolean", Boolean);
        monetDBMappings.put("char", Char);
        monetDBMappings.put("varchar", Varchar);
        monetDBMappings.put("clob", Clob);
        monetDBMappings.put("tinyint", Tinyint);
        monetDBMappings.put("smallint", Smallint);
        monetDBMappings.put("int", Int);
        monetDBMappings.put("bigint", Bigint);
        monetDBMappings.put("decimal", Decimal);
        monetDBMappings.put("real", Real);
        monetDBMappings.put("double", Double);
        monetDBMappings.put("month_interval", MonthInterval);
        monetDBMappings.put("sec_interval", SecondInterval);
        monetDBMappings.put("time", Time);
        monetDBMappings.put("timetz", TimeTz);
        monetDBMappings.put("date", Date);
        monetDBMappings.put("timestamp", Timestamp);
        monetDBMappings.put("timestamptz", TimestampTz);
        monetDBMappings.put("blob", Blob);
        monetDBMappings.put("oid", Oid);
    }
}

