/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.NTFJMSConnectionGroup;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIoaqnfy;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.jdbc.pool.OracleDataSource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class NTFJMSConnection
extends Thread
implements Monitor {
    private String jmsConnectionId;
    private String instanceName;
    private String serviceName;
    private String userName;
    private OpaqueString password;
    private String connClass;
    private ArrayList<String> listenerAddresses;
    private static final int MAX_NUMBER_OF_TRIES = 5;
    private Connection conn;
    private T4CTTIoaqnfy oaqnfy;
    private volatile boolean needToBeClosed;
    private boolean safeToClose;
    private int numberOfRegistrations;
    private NTFJMSConnectionGroup connectionGroup;
    private final Monitor.CloseableLock monitorLock;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;

    NTFJMSConnection(String jmsConnectionId, ArrayList<String> listenerAddresses, String instanceName, String serviceName, String userName, OpaqueString password, String connClass, int numberOfRegistrations) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null, jmsConnectionId, listenerAddresses, instanceName, serviceName, userName, password, connClass, numberOfRegistrations);
            }
            this.conn = null;
            this.oaqnfy = null;
            this.needToBeClosed = false;
            this.safeToClose = true;
            this.numberOfRegistrations = 0;
            this.connectionGroup = null;
            this.monitorLock = this.newDefaultLock();
            this.userName = userName;
            this.password = password;
            this.serviceName = serviceName;
            this.jmsConnectionId = jmsConnectionId;
            this.listenerAddresses = listenerAddresses;
            this.instanceName = instanceName;
            this.connClass = connClass;
            this.numberOfRegistrations = numberOfRegistrations;
            if (!$assertionsDisabled && listenerAddresses == null) {
                AssertionError assertionError = new AssertionError((Object)"listenerAddresses is null");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (!$assertionsDisabled && instanceName == null) {
                AssertionError assertionError = new AssertionError((Object)"instancename is null");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null, (Throwable)((Object)assertionError));
                }
                throw assertionError;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null);
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$12, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$12, null, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void run() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$0, this, new Object[0]);
            }
            boolean retry = false;
            boolean reConnect = false;
            int conAttempt = 0;
            int errorCode = 0;
            for (int cnt = 0; cnt < 2 && !this.needToBeClosed; ++cnt) {
                try {
                    if (cnt == 0 || reConnect) {
                        this.conn = this.getConnection(conAttempt);
                        this.oaqnfy = new T4CTTIoaqnfy((T4CConnection)this.conn, this.jmsConnectionId);
                    }
                    if (retry || !this.needToBeClosed) {
                        retry = false;
                        reConnect = false;
                        cnt = 0;
                    }
                    this.oaqnfy.doRPC();
                    continue;
                }
                catch (IOException eIo) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFJMSConnection - connectionId = " + this.jmsConnectionId + ", userName = " + this.userName + ", connClass = " + this.connClass + ", instnaceName =" + this.instanceName + ": ERROR: got Exception during thread execution" + eIo.getMessage());
                    }
                    this.needToBeClosed = true;
                    continue;
                }
                catch (Exception e2) {
                    if (bl) {
                        OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFJMSConnection - connectionId = " + this.jmsConnectionId + ", userName = " + this.userName + ", connClass = " + this.connClass + ", instnaceName =" + this.instanceName + ": ERROR: got Exception during thread execution" + e2.getMessage());
                    }
                    if (this.needToBeClosed) break;
                    if (retry) {
                        this.getConnectionGroup().raiseException();
                        break;
                    }
                    if (e2 instanceof SQLException) {
                        errorCode = ((SQLException)e2).getErrorCode();
                    }
                    if (errorCode == 17410) {
                        reConnect = true;
                        errorCode = 0;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {}
                    } else {
                        reConnect = false;
                    }
                    retry = true;
                }
            }
            if (bl) {
                OracleLog.debug($$$loggerRef$$$0, Level.FINEST, this.getClass(), $$$methodRef$$$0, "NTFJMSConnection -, connectionId = " + this.jmsConnectionId + ", userName = " + this.userName + ": end of run method. Thread will be closed.");
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    Connection getConnection(int n2) throws SQLException, InterruptedException {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void noOfTries;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$1, this, n2);
            }
            Connection notificationConnection = null;
            OracleDataSource ods = new OracleDataSource();
            ods.setUser(this.userName);
            ods.setPassword(this.password.get());
            if (this.connClass != null) {
                Properties props = new Properties();
                props.put("oracle.jdbc.DRCPConnectionClass", this.connClass);
                props.put("oracle.jdbc.jmsNotification", "true");
                props.put("oracle.jdbc.ReadTimeout", (Object)0);
                props.put("oracle.net.CONNECT_TIMEOUT", (Object)0);
                ods.setConnectionProperties(props);
            }
            while (notificationConnection == null && ++noOfTries < 5 && !this.needToBeClosed) {
                notificationConnection = this.tryListenerAddressesToGetConnection(ods);
                if (notificationConnection != null || noOfTries >= 5) continue;
                Thread.sleep((long)(noOfTries * 5000));
            }
            if (notificationConnection == null && !this.needToBeClosed) {
                SQLException sQLException = new SQLException("Failed to create notification connection to emon server");
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$1, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$1, this, sQLException);
                }
                throw sQLException;
            }
            Connection connection = notificationConnection;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$1, this, connection);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$1, this, null);
            }
            return connection;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Connection tryListenerAddressesToGetConnection(OracleDataSource oracleDataSource) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$2, this, oracleDataSource);
            }
            Iterator<String> iterator = this.listenerAddresses.iterator();
            while (true) {
                void ods;
                if (!iterator.hasNext()) {
                    Connection connection = null;
                    if (!bl) return null;
                    ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$2, this, connection);
                    ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$2, this, null);
                    return null;
                }
                String listenerAddress = iterator.next();
                String url = "jdbc:oracle:thin:@(DESCRIPTION=" + listenerAddress + "(CONNECT_DATA=(SERVICE_NAME=" + this.serviceName + ")(SERVER=EMON)(INSTANCE_NAME=" + this.instanceName + ")))";
                ods.setURL(url);
                try {
                    Throwable throwable;
                    Monitor.CloseableLock lock;
                    block34: {
                        Connection connection;
                        block35: {
                            block36: {
                                block31: {
                                    Connection connection2;
                                    block32: {
                                        block33: {
                                            lock = this.acquireCloseableLock();
                                            throwable = null;
                                            if (!this.needToBeClosed) break block31;
                                            connection2 = null;
                                            if (lock == null) break block32;
                                            if (throwable == null) break block33;
                                            try {
                                                lock.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            break block32;
                                        }
                                        lock.close();
                                    }
                                    Connection connection3 = connection2;
                                    if (bl) {
                                        ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$2, this, connection3);
                                        ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$2, this, null);
                                    }
                                    return connection3;
                                }
                                Connection notificationConnection = ods.getConnection();
                                if (notificationConnection == null) break block34;
                                connection = notificationConnection;
                                if (lock == null) break block35;
                                if (throwable == null) break block36;
                                try {
                                    lock.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                break block35;
                            }
                            lock.close();
                        }
                        Connection connection4 = connection;
                        if (bl) {
                            ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$2, this, connection4);
                            ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$2, this, null);
                        }
                        return connection4;
                    }
                    if (lock == null) continue;
                    if (throwable != null) {
                        try {
                            lock.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    lock.close();
                    continue;
                    catch (Throwable throwable5) {
                        try {
                            throwable = throwable5;
                            Throwable throwable6 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$2, this, throwable6);
                            }
                            throw throwable6;
                        }
                        catch (Throwable throwable7) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable8) {
                                        throwable.addSuppressed(throwable8);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable9 = throwable7;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$2, this, throwable9);
                            }
                            throw throwable9;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Throwable throwable10 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$2, this, throwable10);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void closeThisListener() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            block23: {
                Monitor.CloseableLock lock;
                block24: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$3, this, new Object[0]);
                    }
                    lock = this.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        block22: {
                            this.needToBeClosed = true;
                            try {
                                if (this.oaqnfy != null) {
                                    this.oaqnfy.stopListening();
                                }
                                if (this.conn != null) {
                                    this.conn.close();
                                }
                            }
                            catch (SQLException ex) {
                                if (!bl) break block22;
                                OracleLog.debug($$$loggerRef$$$3, Level.FINEST, this.getClass(), $$$methodRef$$$3, "NTFJMSConnection -, jmsConnectionId = " + this.jmsConnectionId + ", userName = " + this.userName + ": ERROR: got SQLException while closing the connection " + ex.getMessage());
                            }
                        }
                        if (lock == null) break block23;
                        if (throwable == null) break block24;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$3, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$3, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block23;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$3, this, throwable8);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setNeedToBeClosed(boolean bl) {
        boolean bl2 = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _needToBeClosed;
            if (bl2) {
                ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$4, this, bl);
            }
            this.needToBeClosed = _needToBeClosed;
            if (bl2) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl2) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$4, this, throwable2);
            }
            throw throwable;
        }
    }

    String getJMSConnectionId() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$5, this, new Object[0]);
            }
            String string = this.jmsConnectionId;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$5, this, string);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$5, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    int getNumberOfRegistrations() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$6, this, new Object[0]);
            }
            int n2 = this.numberOfRegistrations;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$6, this, n2);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$6, this, null);
            }
            return n2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void incrementNumberOfRegistrations(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$7, this, n2);
            }
            this.numberOfRegistrations += n3;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$7, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$7, this);
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$7, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$7, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$7, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void decrementNumberOfRegistrations(int n2) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void n3;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$8, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$8, this, n2);
            }
            this.numberOfRegistrations -= n3;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$8, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$8, this);
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$8, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$8, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$8, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setConnectionGroup(NTFJMSConnectionGroup nTFJMSConnectionGroup) {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            void _connGroup;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$9, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$9, this, nTFJMSConnectionGroup);
            }
            this.connectionGroup = _connGroup;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$9, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$9, this);
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$9, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$9, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$9, this, throwable2);
            }
            throw throwable;
        }
    }

    NTFJMSConnectionGroup getConnectionGroup() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$10, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$10, this, new Object[0]);
            }
            if (this.connectionGroup == null) {
                this.connectionGroup = PhysicalConnection.ntfManager.getJMSConnectionGroup(this.userName + this.instanceName);
            }
            NTFJMSConnectionGroup nTFJMSConnectionGroup = this.connectionGroup;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$10, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$10, this, nTFJMSConnectionGroup);
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$10, this, null);
            }
            return nTFJMSConnectionGroup;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$10, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$10, this, throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        boolean bl = (0x204L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$11, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$11, this, new Object[0]);
            }
            Monitor.CloseableLock closeableLock = this.monitorLock;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$11, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$11, this, closeableLock);
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$11, this, null);
            }
            return closeableLock;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$11, Level.FINEST, NTFJMSConnection.class, $$$methodRef$$$11, this, throwable2);
            }
            throw throwable;
        }
    }

    static {
        try {
            $$$methodRef$$$12 = NTFJMSConnection.class.getDeclaredConstructor(String.class, ArrayList.class, String.class, String.class, String.class, OpaqueString.class, String.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = NTFJMSConnection.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = NTFJMSConnection.class.getDeclaredMethod("getConnectionGroup", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = NTFJMSConnection.class.getDeclaredMethod("setConnectionGroup", NTFJMSConnectionGroup.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = NTFJMSConnection.class.getDeclaredMethod("decrementNumberOfRegistrations", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = NTFJMSConnection.class.getDeclaredMethod("incrementNumberOfRegistrations", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = NTFJMSConnection.class.getDeclaredMethod("getNumberOfRegistrations", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = NTFJMSConnection.class.getDeclaredMethod("getJMSConnectionId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = NTFJMSConnection.class.getDeclaredMethod("setNeedToBeClosed", Boolean.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = NTFJMSConnection.class.getDeclaredMethod("closeThisListener", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = NTFJMSConnection.class.getDeclaredMethod("tryListenerAddressesToGetConnection", OracleDataSource.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = NTFJMSConnection.class.getDeclaredMethod("getConnection", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = NTFJMSConnection.class.getDeclaredMethod("run", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

