/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.json.binary;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import oracle.jdbc.driver.json.OracleJsonExceptions;
import oracle.jdbc.driver.json.binary.OsonPrimitiveConversions;

public final class OsonBuffer {
    final CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
    final ByteBuffer buffer;
    char[] charBuffer;
    public Map<Integer, String> cache = new HashMap<Integer, String>();
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;

    public OsonBuffer(ByteBuffer buffer) {
        buffer.order(ByteOrder.BIG_ENDIAN);
        this.buffer = buffer;
    }

    public int getInt() {
        return this.buffer.getInt();
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public int position() {
        return this.buffer.position();
    }

    public void position(int pos) {
        this.buffer.position(pos);
    }

    public int getUB1() {
        return 0xFF & this.buffer.get();
    }

    public int getUB1(int i2) {
        return 0xFF & this.buffer.get(i2);
    }

    public int getUB2() {
        return 0xFFFF & this.buffer.getShort();
    }

    public int getUB2(int i2) {
        return 0xFFFF & this.buffer.getShort(i2);
    }

    public String readString(int len) {
        if (!this.buffer.hasArray()) {
            throw new UnsupportedOperationException();
        }
        byte[] raw = this.buffer.array();
        if (this.charBuffer == null || this.charBuffer.length < len) {
            this.charBuffer = new char[len];
        }
        int pos = this.buffer.position() + this.buffer.arrayOffset();
        for (int i2 = 0; i2 < len; ++i2) {
            byte b2 = raw[i2 + pos];
            if (b2 < 0) {
                String result = new String(this.buffer.array(), this.buffer.position() + this.buffer.arrayOffset(), len, StandardCharsets.UTF_8);
                this.buffer.position(pos + len);
                return result;
            }
            this.charBuffer[i2] = (char)b2;
        }
        this.buffer.position(pos + len);
        return new String(this.charBuffer, 0, len);
    }

    public void readBytes(OutputStream out, int len) throws IOException {
        if (!this.buffer.hasArray()) {
            throw new UnsupportedOperationException();
        }
        int pos = this.buffer.position() + this.buffer.arrayOffset();
        out.write(this.buffer.array(), pos, len);
    }

    public int getUB4int() {
        int res = this.buffer.getInt();
        if (res < 0) {
            throw OracleJsonExceptions.OVERFLOW.create(null, res);
        }
        return res;
    }

    public int getUB4int(int i2) {
        int res = this.buffer.getInt(i2);
        if (res < 0) {
            throw OracleJsonExceptions.OVERFLOW.create(null, res);
        }
        return res;
    }

    public void get(byte[] bytes) {
        this.buffer.get(bytes);
    }

    public double readDtyDouble() {
        byte[] res = new byte[8];
        this.buffer.get(res);
        return OsonPrimitiveConversions.canonicalFormatBytesToDouble(res);
    }

    public float readDtyFloat() {
        byte[] res = new byte[4];
        this.buffer.get(res);
        return OsonPrimitiveConversions.canonicalFormatBytesToFloat(res);
    }

    int binarySearchUb1(int fromPos, int count, int test) {
        int low = 0;
        int high = count - 1;
        byte[] bytes = this.buffer.array();
        while (low <= high) {
            int mid = low + high >>> 1;
            int midValue = bytes[fromPos + mid] & 0xFF;
            if (midValue < test) {
                low = mid + 1;
                continue;
            }
            if (midValue > test) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    int binarySearchUb2(int fromPos, int count, int test) {
        int low = 0;
        int high = count - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midValue = this.getUB2(fromPos + mid * 2);
            if (midValue < test) {
                low = mid + 1;
                continue;
            }
            if (midValue > test) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    int binarySearchUb4(int fromPos, int count, int test) {
        int low = 0;
        int high = count - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midValue = this.getUB4int(fromPos + mid * 4);
            if (midValue < test) {
                low = mid + 1;
                continue;
            }
            if (midValue > test) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public int linearSearchUb1(int fromPos, int count, int test) {
        for (int i2 = fromPos; i2 < fromPos + count; ++i2) {
            if (this.getUB1(i2) != test) continue;
            return i2 - fromPos;
        }
        return -1;
    }

    int linearSearchUb2(int fromPos, int count, int test) {
        int endPos = fromPos + count * 2;
        for (int i2 = fromPos; i2 < endPos; i2 += 2) {
            if (this.getUB2(i2) != test) continue;
            return (i2 - fromPos) / 2;
        }
        return -1;
    }

    public int linearSearchUb4(int fromPos, int count, int test) {
        int endPos = fromPos + count * 4;
        for (int i2 = fromPos; i2 < endPos; i2 += 4) {
            if (this.getUB4int(i2) != test) continue;
            return (i2 - fromPos) / 4;
        }
        return -1;
    }

    static {
        try {
            $$$methodRef$$$21 = OsonBuffer.class.getDeclaredConstructor(ByteBuffer.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = OsonBuffer.class.getDeclaredMethod("linearSearchUb4", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = OsonBuffer.class.getDeclaredMethod("linearSearchUb2", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = OsonBuffer.class.getDeclaredMethod("linearSearchUb1", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = OsonBuffer.class.getDeclaredMethod("binarySearchUb4", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = OsonBuffer.class.getDeclaredMethod("binarySearchUb2", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = OsonBuffer.class.getDeclaredMethod("binarySearchUb1", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = OsonBuffer.class.getDeclaredMethod("readDtyFloat", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = OsonBuffer.class.getDeclaredMethod("readDtyDouble", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = OsonBuffer.class.getDeclaredMethod("get", byte[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = OsonBuffer.class.getDeclaredMethod("getUB4int", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = OsonBuffer.class.getDeclaredMethod("getUB4int", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = OsonBuffer.class.getDeclaredMethod("readBytes", OutputStream.class, Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = OsonBuffer.class.getDeclaredMethod("readString", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = OsonBuffer.class.getDeclaredMethod("getUB2", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = OsonBuffer.class.getDeclaredMethod("getUB2", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = OsonBuffer.class.getDeclaredMethod("getUB1", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = OsonBuffer.class.getDeclaredMethod("getUB1", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = OsonBuffer.class.getDeclaredMethod("position", Integer.TYPE);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = OsonBuffer.class.getDeclaredMethod("position", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = OsonBuffer.class.getDeclaredMethod("buffer", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = OsonBuffer.class.getDeclaredMethod("getInt", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
    }
}

