/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Locale;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;

public final class MonetDBJavaLiteLoader {
    private static String loadedLibraryFullPath = null;
    private static final String tempDirectory = new File(System.getProperty("java.io.tmpdir")).getAbsolutePath();
    private static final String monetDBJDBCDriverString = "2-39";

    private MonetDBJavaLiteLoader() {
    }

    private static String getLibraryFileName(SupportedOS os) throws MonetDBEmbeddedException {
        switch (os) {
            case WindowsNT: {
                return "libmonetdblitejava.dll";
            }
            case MacOSX: 
            case Linux: {
                return "libmonetdblitejava.so";
            }
        }
        throw new MonetDBEmbeddedException("Unknown operating system");
    }

    private static String getLibraryFileBasePath(SupportedOS os, SupportedArc arc) throws MonetDBEmbeddedException {
        switch (os) {
            case WindowsNT: {
                if (arc != SupportedArc.X86_X64) {
                    throw new MonetDBEmbeddedException("Architecture not supported on Windows NT");
                }
                return "/libs/windows/x86x64/";
            }
            case MacOSX: {
                if (arc != SupportedArc.X86_X64) {
                    throw new MonetDBEmbeddedException("Architecture not supported on MacOS X");
                }
                return "/libs/macosx/x86x64/";
            }
            case Linux: {
                if (arc != SupportedArc.X86_X64) {
                    throw new MonetDBEmbeddedException("Architecture not supported on Linux");
                }
                return "/libs/linux/" + (arc == SupportedArc.X86_X64 ? "x86x64" : "arm64") + "/";
            }
        }
        throw new MonetDBEmbeddedException("Unknown operating system");
    }

    public static synchronized boolean isNativeLibraryLoaded() {
        return loadedLibraryFullPath != null;
    }

    private static SupportedOS detectRunningOperatingSystem() throws MonetDBEmbeddedException {
        String OS = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (OS.contains("mac") || OS.contains("darwin")) {
            return SupportedOS.MacOSX;
        }
        if (OS.contains("win")) {
            return SupportedOS.WindowsNT;
        }
        if (OS.contains("nux")) {
            return SupportedOS.Linux;
        }
        throw new MonetDBEmbeddedException("The operating system " + OS + " is not currently supported by MonetDBLite-Java");
    }

    private static SupportedArc detectCPUArchitecture(SupportedOS os) throws MonetDBEmbeddedException {
        boolean is_arm64;
        boolean is_x86_64;
        String arch = System.getProperty("os.arch").toLowerCase(Locale.ENGLISH);
        if (os == SupportedOS.WindowsNT) {
            is_x86_64 = System.getenv("ProgramFiles(x86)") != null;
            is_arm64 = false;
        } else {
            is_x86_64 = arch.contains("amd64") || arch.contains("x64") || arch.contains("x86_64") || arch.contains("x8664");
            boolean bl = is_arm64 = arch.contains("arm64") || arch.contains("aarch64");
        }
        if (!(os != SupportedOS.WindowsNT && os != SupportedOS.MacOSX || is_x86_64)) {
            String desc = os == SupportedOS.WindowsNT ? "Windows" : "MacOS X";
            throw new MonetDBEmbeddedException("MonetDBLite-Java is only supported on x86_64 architectures on " + desc);
        }
        if (os == SupportedOS.Linux && !is_x86_64 && !is_arm64) {
            throw new MonetDBEmbeddedException("MonetDBLite-Java is only supported on x86_64 and arm64 architectures on Linux");
        }
        if (is_x86_64 && is_arm64) {
            throw new MonetDBEmbeddedException("Ambiguous architecture detected");
        }
        if (is_x86_64) {
            return SupportedArc.X86_X64;
        }
        if (is_arm64) {
            return SupportedArc.ARM64;
        }
        throw new MonetDBEmbeddedException("The architecture " + arch + " is not currently supported by MonetDBLite-Java");
    }

    private static byte[] makeSHA256Digest(InputStream input) throws MonetDBEmbeddedException {
        try {
            byte[] buffer = new byte[8192];
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            try (DigestInputStream dis = new DigestInputStream(input, md);){
                while (dis.read(buffer) != -1) {
                }
            }
            return md.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            throw new MonetDBEmbeddedException(e);
        }
    }

    private static String loadNativeLibrary(String libraryFilePath, String libraryFileName) {
        File libPath = new File(libraryFilePath, libraryFileName);
        if (libPath.exists()) {
            System.load(new File(libraryFilePath, libraryFileName).getAbsolutePath());
            return libPath.getAbsolutePath();
        }
        return null;
    }

    private static String loadLibraryIntoDirectory(String libraryFilePath, String prefix, String libraryFileName, String destinationDirectory) throws MonetDBEmbeddedException {
        try {
            int bytesRead;
            String nativeLibraryFilePath = libraryFilePath + libraryFileName;
            String extractedLibFileName = prefix + libraryFileName;
            File extractedLibFile = new File(destinationDirectory, extractedLibFileName);
            if (extractedLibFile.exists()) {
                byte[] digest2;
                byte[] digest1 = MonetDBJavaLiteLoader.makeSHA256Digest(MonetDBJavaLiteLoader.class.getResourceAsStream(nativeLibraryFilePath));
                if (Arrays.equals(digest1, digest2 = MonetDBJavaLiteLoader.makeSHA256Digest(new FileInputStream(extractedLibFile)))) {
                    return MonetDBJavaLiteLoader.loadNativeLibrary(destinationDirectory, extractedLibFileName);
                }
                if (!extractedLibFile.delete()) {
                    throw new IOException("failed to remove existing native library file: " + extractedLibFile.getAbsolutePath());
                }
            }
            InputStream reader = MonetDBJavaLiteLoader.class.getResourceAsStream(nativeLibraryFilePath);
            FileOutputStream writer = new FileOutputStream(extractedLibFile);
            byte[] buffer = new byte[8192];
            while ((bytesRead = reader.read(buffer)) != -1) {
                writer.write(buffer, 0, bytesRead);
            }
            writer.close();
            reader.close();
            return MonetDBJavaLiteLoader.loadNativeLibrary(destinationDirectory, extractedLibFileName);
        }
        catch (IOException ex) {
            throw new MonetDBEmbeddedException(ex);
        }
    }

    static synchronized void loadMonetDBJavaLite() throws MonetDBEmbeddedException {
        if (loadedLibraryFullPath != null) {
            return;
        }
        SupportedOS foundOS = MonetDBJavaLiteLoader.detectRunningOperatingSystem();
        SupportedArc foundArc = MonetDBJavaLiteLoader.detectCPUArchitecture(foundOS);
        String nativeLibraryPath = MonetDBJavaLiteLoader.getLibraryFileBasePath(foundOS, foundArc);
        String nativeLibraryName = MonetDBJavaLiteLoader.getLibraryFileName(foundOS);
        if (MonetDBJavaLiteLoader.class.getResource(nativeLibraryPath + nativeLibraryName) == null) {
            loadedLibraryFullPath = null;
            throw new MonetDBEmbeddedException("Error while loading library: " + nativeLibraryPath + nativeLibraryName);
        }
        if (foundOS == SupportedOS.WindowsNT) {
            MonetDBJavaLiteLoader.loadLibraryIntoDirectory(nativeLibraryPath, "", "vcruntime140.dll", tempDirectory);
        }
        String prefix = "MonetDBJavaLite-2-39-";
        loadedLibraryFullPath = MonetDBJavaLiteLoader.loadLibraryIntoDirectory(nativeLibraryPath, prefix, nativeLibraryName, tempDirectory);
    }

    static {
        try {
            Class.forName("nl.cwi.monetdb.jdbc.MonetDriver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            System.err.println("monetdb-jdbc-new driver not found, add monetdb-jdbc-new jar to the CLASSPATH");
            System.exit(1);
        }
    }

    private static enum SupportedOS {
        WindowsNT,
        MacOSX,
        Linux;

    }

    private static enum SupportedArc {
        X86_X64,
        ARM64;

    }
}

