/*
 * Decompiled with CFR 0.152.
 */
package nl.cwi.monetdb.embedded.resultset;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.ListIterator;
import nl.cwi.monetdb.embedded.env.AbstractConnectionResult;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedConnection;
import nl.cwi.monetdb.embedded.env.MonetDBEmbeddedException;
import nl.cwi.monetdb.embedded.mapping.MonetDBRow;
import nl.cwi.monetdb.embedded.mapping.MonetDBToJavaMapping;
import nl.cwi.monetdb.embedded.mapping.NullMappings;
import nl.cwi.monetdb.embedded.resultset.QueryResultRowSet;

public strictfp class QueryResultSet
extends AbstractConnectionResult
implements Iterable {
    private volatile long structPointer;
    private final int numberOfColumns;
    private final int numberOfRows;
    private String[] columnNames;
    private int[] typesIDs;

    private static String TypeIDToString(int typeID) {
        switch (typeID) {
            case 1: {
                return "boolean";
            }
            case 2: {
                return "tinyint";
            }
            case 3: {
                return "smallint";
            }
            case 4: {
                return "int";
            }
            case 5: {
                return "bigint";
            }
            case 6: {
                return "real";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "char";
            }
            case 9: {
                return "date";
            }
            case 10: {
                return "timestamp";
            }
            case 11: {
                return "time";
            }
            case 12: {
                return "blob";
            }
            case 13: {
                return "decimal";
            }
            case 14: {
                return "oid";
            }
        }
        return "unknown";
    }

    QueryResultSet(MonetDBEmbeddedConnection connection, long structPointer, int numberOfColumns, int numberOfRows, int[] typesIDs) {
        super(connection);
        this.structPointer = structPointer;
        this.numberOfColumns = numberOfColumns;
        this.numberOfRows = numberOfRows;
        this.typesIDs = typesIDs;
        this.columnNames = null;
    }

    public boolean isQueryResultSetClosed() {
        return this.structPointer == 0L;
    }

    private void checkQueryResultSetIsNotClosed() throws MonetDBEmbeddedException {
        if (this.isQueryResultSetClosed()) {
            throw new MonetDBEmbeddedException("This QueryResultSet is already closed");
        }
    }

    @Override
    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    @Override
    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    private native void getColumnNamesInternal(long var1, String[] var3) throws MonetDBEmbeddedException;

    private native void getColumnTypesInternal(long var1, String[] var3) throws MonetDBEmbeddedException;

    private native void getMappingsInternal(long var1, MonetDBToJavaMapping[] var3) throws MonetDBEmbeddedException;

    private native void getColumnDigitsInternal(long var1, int[] var3) throws MonetDBEmbeddedException;

    private native void getColumnScalesInternal(long var1, int[] var3) throws MonetDBEmbeddedException;

    @Override
    public void getColumnNames(String[] input) throws MonetDBEmbeddedException {
        this.checkQueryResultSetIsNotClosed();
        this.checkMetadataArrayLength(input);
        this.getColumnNamesInternal(this.structPointer, input);
    }

    @Override
    public void getColumnTypes(String[] input) throws MonetDBEmbeddedException {
        this.checkQueryResultSetIsNotClosed();
        this.checkMetadataArrayLength(input);
        this.getColumnTypesInternal(this.structPointer, input);
    }

    @Override
    public void getMappings(MonetDBToJavaMapping[] input) throws MonetDBEmbeddedException {
        this.checkQueryResultSetIsNotClosed();
        this.checkMetadataArrayLength(input);
        this.getMappingsInternal(this.structPointer, input);
    }

    @Override
    public void getColumnDigits(int[] input) throws MonetDBEmbeddedException {
        this.checkQueryResultSetIsNotClosed();
        this.checkMetadataArrayLength(input);
        this.getColumnDigitsInternal(this.structPointer, input);
    }

    @Override
    public void getColumnScales(int[] input) throws MonetDBEmbeddedException {
        this.checkQueryResultSetIsNotClosed();
        this.checkMetadataArrayLength(input);
        this.getColumnScalesInternal(this.structPointer, input);
    }

    public int getColumnIndexByName(String columnName) throws MonetDBEmbeddedException {
        if (this.columnNames == null) {
            this.columnNames = new String[this.numberOfColumns];
            this.getColumnNamesInternal(this.structPointer, this.columnNames);
        }
        int index = 0;
        for (String col : this.columnNames) {
            if (col.equals(columnName)) {
                return index + 1;
            }
            ++index;
        }
        throw new ArrayIndexOutOfBoundsException("The column with the name " + columnName + " is not present in the result set");
    }

    private native byte getByteByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native short getShortByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native int getIntegerByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native long getLongByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native float getFloatByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native double getDoubleByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native String getStringByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native Date getDateByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native Timestamp getTimestampByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native Time getTimeByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native BigDecimal getDecimalByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native byte[] getBlobByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private native String getOidByColumnAndRowInternal(long var1, int var3, int var4) throws MonetDBEmbeddedException;

    private void checkRangesScalars(int column, int row) throws MonetDBEmbeddedException {
        this.checkQueryResultSetIsNotClosed();
        if (column < 1) {
            throw new ArrayIndexOutOfBoundsException("The column index is smaller than 1?");
        }
        if (column > this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException("The column index is larger than the number of columns? " + column + " > " + this.numberOfColumns);
        }
        if (row < 1) {
            throw new ArrayIndexOutOfBoundsException("The row index is smaller than 1?");
        }
        if (row > this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException("The row index is larger than the number of rows?" + row + " > " + this.numberOfRows);
        }
    }

    public boolean getBooleanByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                return this.getByteByColumnAndRowInternal(this.structPointer, column, row) != 0;
            }
            case 3: {
                return this.getShortByColumnAndRowInternal(this.structPointer, column, row) != 0;
            }
            case 4: {
                return this.getIntegerByColumnAndRowInternal(this.structPointer, column, row) != 0;
            }
            case 5: {
                return this.getLongByColumnAndRowInternal(this.structPointer, column, row) != 0L;
            }
            case 6: {
                return this.getFloatByColumnAndRowInternal(this.structPointer, column, row) != 0.0f;
            }
            case 7: {
                return this.getDoubleByColumnAndRowInternal(this.structPointer, column, row) != 0.0;
            }
            case 8: {
                String aux6 = this.getStringByColumnAndRowInternal(this.structPointer, column, row);
                return Boolean.parseBoolean(aux6);
            }
            case 13: {
                BigDecimal aux7 = this.getDecimalByColumnAndRowInternal(this.structPointer, column, row);
                return aux7 != null && !aux7.equals(BigDecimal.ZERO);
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to boolean");
    }

    public byte getByteByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                return this.getByteByColumnAndRowInternal(this.structPointer, column, row);
            }
            case 3: {
                short aux1 = this.getShortByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == NullMappings.getShortNullConstant() ? NullMappings.getByteNullConstant() : (byte)aux1;
            }
            case 4: {
                int aux2 = this.getIntegerByColumnAndRowInternal(this.structPointer, column, row);
                return aux2 == NullMappings.getIntNullConstant() ? NullMappings.getByteNullConstant() : (byte)aux2;
            }
            case 5: {
                long aux3 = this.getLongByColumnAndRowInternal(this.structPointer, column, row);
                return aux3 == NullMappings.getLongNullConstant() ? NullMappings.getByteNullConstant() : (byte)aux3;
            }
            case 6: {
                float aux4 = this.getFloatByColumnAndRowInternal(this.structPointer, column, row);
                return aux4 == NullMappings.getFloatNullConstant() ? NullMappings.getByteNullConstant() : (byte)Math.round(aux4);
            }
            case 7: {
                double aux5 = this.getDoubleByColumnAndRowInternal(this.structPointer, column, row);
                return aux5 == NullMappings.getDoubleNullConstant() ? NullMappings.getByteNullConstant() : (byte)Math.round(aux5);
            }
            case 8: {
                String aux6 = this.getStringByColumnAndRowInternal(this.structPointer, column, row);
                return aux6 == null ? NullMappings.getByteNullConstant() : Byte.parseByte(aux6);
            }
            case 13: {
                BigDecimal aux7 = this.getDecimalByColumnAndRowInternal(this.structPointer, column, row);
                return aux7 == null ? NullMappings.getByteNullConstant() : aux7.byteValue();
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to byte");
    }

    public short getShortByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte aux1 = this.getByteByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == NullMappings.getByteNullConstant() ? NullMappings.getShortNullConstant() : (short)aux1;
            }
            case 3: {
                return this.getShortByColumnAndRowInternal(this.structPointer, column, row);
            }
            case 4: {
                int aux2 = this.getIntegerByColumnAndRowInternal(this.structPointer, column, row);
                return aux2 == NullMappings.getIntNullConstant() ? NullMappings.getShortNullConstant() : (short)aux2;
            }
            case 5: {
                long aux3 = this.getLongByColumnAndRowInternal(this.structPointer, column, row);
                return aux3 == NullMappings.getLongNullConstant() ? NullMappings.getShortNullConstant() : (short)aux3;
            }
            case 6: {
                float aux4 = this.getFloatByColumnAndRowInternal(this.structPointer, column, row);
                return aux4 == NullMappings.getFloatNullConstant() ? NullMappings.getShortNullConstant() : (short)Math.round(aux4);
            }
            case 7: {
                double aux5 = this.getDoubleByColumnAndRowInternal(this.structPointer, column, row);
                return aux5 == NullMappings.getDoubleNullConstant() ? NullMappings.getShortNullConstant() : (short)Math.round(aux5);
            }
            case 8: {
                String aux6 = this.getStringByColumnAndRowInternal(this.structPointer, column, row);
                return aux6 == null ? NullMappings.getShortNullConstant() : Short.parseShort(aux6);
            }
            case 13: {
                BigDecimal aux7 = this.getDecimalByColumnAndRowInternal(this.structPointer, column, row);
                return aux7 == null ? NullMappings.getShortNullConstant() : aux7.shortValue();
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to short");
    }

    public int getIntegerByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte aux1 = this.getByteByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == NullMappings.getByteNullConstant() ? NullMappings.getIntNullConstant() : (int)aux1;
            }
            case 3: {
                short aux2 = this.getShortByColumnAndRowInternal(this.structPointer, column, row);
                return aux2 == NullMappings.getShortNullConstant() ? NullMappings.getIntNullConstant() : (int)aux2;
            }
            case 4: {
                return this.getIntegerByColumnAndRowInternal(this.structPointer, column, row);
            }
            case 5: {
                long aux3 = this.getLongByColumnAndRowInternal(this.structPointer, column, row);
                return aux3 == NullMappings.getLongNullConstant() ? NullMappings.getIntNullConstant() : (int)aux3;
            }
            case 6: {
                float aux4 = this.getFloatByColumnAndRowInternal(this.structPointer, column, row);
                return aux4 == NullMappings.getFloatNullConstant() ? NullMappings.getIntNullConstant() : Math.round(aux4);
            }
            case 7: {
                double aux5 = this.getDoubleByColumnAndRowInternal(this.structPointer, column, row);
                return aux5 == NullMappings.getDoubleNullConstant() ? NullMappings.getIntNullConstant() : (int)Math.round(aux5);
            }
            case 8: {
                String aux6 = this.getStringByColumnAndRowInternal(this.structPointer, column, row);
                return aux6 == null ? NullMappings.getIntNullConstant() : Integer.parseInt(aux6);
            }
            case 13: {
                BigDecimal aux7 = this.getDecimalByColumnAndRowInternal(this.structPointer, column, row);
                return aux7 == null ? NullMappings.getIntNullConstant() : aux7.intValue();
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to int");
    }

    public long getLongByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte aux1 = this.getByteByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == NullMappings.getByteNullConstant() ? NullMappings.getLongNullConstant() : (long)aux1;
            }
            case 3: {
                short aux2 = this.getShortByColumnAndRowInternal(this.structPointer, column, row);
                return aux2 == NullMappings.getShortNullConstant() ? NullMappings.getLongNullConstant() : (long)aux2;
            }
            case 4: {
                int aux3 = this.getIntegerByColumnAndRowInternal(this.structPointer, column, row);
                return aux3 == NullMappings.getIntNullConstant() ? NullMappings.getLongNullConstant() : (long)aux3;
            }
            case 5: {
                return this.getLongByColumnAndRowInternal(this.structPointer, column, row);
            }
            case 6: {
                float aux4 = this.getFloatByColumnAndRowInternal(this.structPointer, column, row);
                return aux4 == NullMappings.getFloatNullConstant() ? NullMappings.getLongNullConstant() : (long)Math.round(aux4);
            }
            case 7: {
                double aux5 = this.getDoubleByColumnAndRowInternal(this.structPointer, column, row);
                return aux5 == NullMappings.getDoubleNullConstant() ? NullMappings.getLongNullConstant() : Math.round(aux5);
            }
            case 8: {
                String aux6 = this.getStringByColumnAndRowInternal(this.structPointer, column, row);
                return aux6 == null ? NullMappings.getLongNullConstant() : Long.parseLong(aux6);
            }
            case 13: {
                BigDecimal aux7 = this.getDecimalByColumnAndRowInternal(this.structPointer, column, row);
                return aux7 == null ? NullMappings.getLongNullConstant() : aux7.longValue();
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to long");
    }

    public float getFloatByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte aux1 = this.getByteByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == NullMappings.getByteNullConstant() ? NullMappings.getFloatNullConstant() : (float)aux1;
            }
            case 3: {
                short aux2 = this.getShortByColumnAndRowInternal(this.structPointer, column, row);
                return aux2 == NullMappings.getShortNullConstant() ? NullMappings.getFloatNullConstant() : (float)aux2;
            }
            case 4: {
                int aux3 = this.getIntegerByColumnAndRowInternal(this.structPointer, column, row);
                return aux3 == NullMappings.getIntNullConstant() ? NullMappings.getFloatNullConstant() : (float)aux3;
            }
            case 5: {
                long aux4 = this.getLongByColumnAndRowInternal(this.structPointer, column, row);
                return aux4 == NullMappings.getLongNullConstant() ? NullMappings.getFloatNullConstant() : (float)aux4;
            }
            case 6: {
                return this.getFloatByColumnAndRowInternal(this.structPointer, column, row);
            }
            case 7: {
                double aux5 = this.getDoubleByColumnAndRowInternal(this.structPointer, column, row);
                return aux5 == NullMappings.getDoubleNullConstant() ? NullMappings.getFloatNullConstant() : (float)aux5;
            }
            case 8: {
                String aux6 = this.getStringByColumnAndRowInternal(this.structPointer, column, row);
                return aux6 == null ? NullMappings.getFloatNullConstant() : Float.parseFloat(aux6);
            }
            case 13: {
                BigDecimal aux7 = this.getDecimalByColumnAndRowInternal(this.structPointer, column, row);
                return aux7 == null ? NullMappings.getFloatNullConstant() : aux7.floatValue();
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to float");
    }

    public double getDoubleByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte aux1 = this.getByteByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == NullMappings.getByteNullConstant() ? NullMappings.getDoubleNullConstant() : (double)aux1;
            }
            case 3: {
                short aux2 = this.getShortByColumnAndRowInternal(this.structPointer, column, row);
                return aux2 == NullMappings.getShortNullConstant() ? NullMappings.getDoubleNullConstant() : (double)aux2;
            }
            case 4: {
                int aux3 = this.getIntegerByColumnAndRowInternal(this.structPointer, column, row);
                return aux3 == NullMappings.getIntNullConstant() ? NullMappings.getDoubleNullConstant() : (double)aux3;
            }
            case 5: {
                long aux4 = this.getLongByColumnAndRowInternal(this.structPointer, column, row);
                return aux4 == NullMappings.getLongNullConstant() ? NullMappings.getDoubleNullConstant() : (double)aux4;
            }
            case 6: {
                double aux5 = this.getFloatByColumnAndRowInternal(this.structPointer, column, row);
                return aux5 == (double)NullMappings.getFloatNullConstant() ? NullMappings.getDoubleNullConstant() : aux5;
            }
            case 7: {
                return this.getDoubleByColumnAndRowInternal(this.structPointer, column, row);
            }
            case 8: {
                String aux6 = this.getStringByColumnAndRowInternal(this.structPointer, column, row);
                return aux6 == null ? NullMappings.getDoubleNullConstant() : Double.parseDouble(aux6);
            }
            case 13: {
                BigDecimal aux7 = this.getDecimalByColumnAndRowInternal(this.structPointer, column, row);
                return aux7 == null ? NullMappings.getDoubleNullConstant() : aux7.doubleValue();
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to double");
    }

    public String getStringByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        Comparable<java.util.Date> aux;
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte aux1 = this.getByteByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == NullMappings.getByteNullConstant() ? null : Byte.toString(aux1);
            }
            case 3: {
                short aux2 = this.getByteByColumnAndRowInternal(this.structPointer, column, row);
                return aux2 == NullMappings.getShortNullConstant() ? null : Short.toString(aux2);
            }
            case 4: {
                byte aux3 = this.getByteByColumnAndRowInternal(this.structPointer, column, row);
                return aux3 == NullMappings.getIntNullConstant() ? null : Integer.toString(aux3);
            }
            case 5: {
                long aux4 = this.getByteByColumnAndRowInternal(this.structPointer, column, row);
                return aux4 == NullMappings.getLongNullConstant() ? null : Long.toString(aux4);
            }
            case 6: {
                float aux5 = this.getByteByColumnAndRowInternal(this.structPointer, column, row);
                return aux5 == NullMappings.getFloatNullConstant() ? null : Float.toString(aux5);
            }
            case 7: {
                double aux6 = this.getByteByColumnAndRowInternal(this.structPointer, column, row);
                return aux6 == NullMappings.getDoubleNullConstant() ? null : Double.toString(aux6);
            }
            case 8: {
                return this.getStringByColumnAndRowInternal(this.structPointer, column, row);
            }
            case 12: {
                byte[] array = this.getBlobByColumnAndRowInternal(this.structPointer, column, row);
                return array == null ? null : Arrays.toString(array);
            }
            case 9: {
                aux = this.getDateByColumnAndRowInternal(this.structPointer, column, row);
                break;
            }
            case 10: {
                aux = this.getTimestampByColumnAndRowInternal(this.structPointer, column, row);
                break;
            }
            case 11: {
                aux = this.getTimeByColumnAndRowInternal(this.structPointer, column, row);
                break;
            }
            case 13: {
                aux = this.getDecimalByColumnAndRowInternal(this.structPointer, column, row);
                break;
            }
            case 14: {
                return this.getOidByColumnAndRowInternal(this.structPointer, column, row);
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to string");
            }
        }
        return aux == null ? null : aux.toString();
    }

    public Date getDateByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 9: {
                return this.getDateByColumnAndRowInternal(this.structPointer, column, row);
            }
            case 10: {
                Timestamp aux1 = this.getTimestampByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == null ? null : new Date(aux1.getTime());
            }
            case 11: {
                Time aux2 = this.getTimeByColumnAndRowInternal(this.structPointer, column, row);
                return aux2 == null ? null : new Date(aux2.getTime());
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to date");
    }

    public Timestamp getTimestampByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 9: {
                Date aux1 = this.getDateByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == null ? null : new Timestamp(aux1.getTime());
            }
            case 10: {
                return this.getTimestampByColumnAndRowInternal(this.structPointer, column, row);
            }
            case 11: {
                Time aux2 = this.getTimeByColumnAndRowInternal(this.structPointer, column, row);
                return aux2 == null ? null : new Timestamp(aux2.getTime());
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to timestamp");
    }

    public Time getTimeByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 9: {
                Date aux1 = this.getDateByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == null ? null : new Time(aux1.getTime());
            }
            case 10: {
                Timestamp aux2 = this.getTimestampByColumnAndRowInternal(this.structPointer, column, row);
                return aux2 == null ? null : new Time(aux2.getTime());
            }
            case 11: {
                return this.getTimeByColumnAndRowInternal(this.structPointer, column, row);
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to time");
    }

    public byte[] getBlobByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 8: {
                String aux1 = this.getStringByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == null ? null : aux1.getBytes();
            }
            case 12: {
                return this.getBlobByColumnAndRowInternal(this.structPointer, column, row);
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to blob");
    }

    public BigDecimal getDecimalByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                return new BigDecimal(this.getByteByColumnAndRowInternal(this.structPointer, column, row));
            }
            case 3: {
                return new BigDecimal(this.getShortByColumnAndRowInternal(this.structPointer, column, row));
            }
            case 4: {
                return new BigDecimal(this.getIntegerByColumnAndRowInternal(this.structPointer, column, row));
            }
            case 5: {
                return new BigDecimal(this.getLongByColumnAndRowInternal(this.structPointer, column, row));
            }
            case 6: {
                return new BigDecimal(this.getFloatByColumnAndRowInternal(this.structPointer, column, row));
            }
            case 7: {
                return new BigDecimal(this.getDoubleByColumnAndRowInternal(this.structPointer, column, row));
            }
            case 8: {
                String aux1 = this.getStringByColumnAndRowInternal(this.structPointer, column, row);
                return aux1 == null ? null : new BigDecimal(aux1);
            }
            case 13: {
                return this.getDecimalByColumnAndRowInternal(this.structPointer, column, row);
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to decimal");
    }

    public String getOidByColumnIndexAndRow(int column, int row) throws MonetDBEmbeddedException {
        this.checkRangesScalars(column, row);
        --row;
        switch (this.typesIDs[--column]) {
            case 14: {
                return this.getOidByColumnAndRowInternal(this.structPointer, column, row);
            }
        }
        throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to oid");
    }

    public boolean getBooleanByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getBooleanByColumnIndexAndRow(index, row);
    }

    public byte getByteByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getByteByColumnIndexAndRow(index, row);
    }

    public short getShortByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getShortByColumnIndexAndRow(index, row);
    }

    public int getIntegerByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getIntegerByColumnIndexAndRow(index, row);
    }

    public long getLongByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getLongByColumnIndexAndRow(index, row);
    }

    public float getFloatByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getFloatByColumnIndexAndRow(index, row);
    }

    public double getDoubleByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getDoubleByColumnIndexAndRow(index, row);
    }

    public String getStringByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getStringByColumnIndexAndRow(index, row);
    }

    public Date getDateByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getDateByColumnIndexAndRow(index, row);
    }

    public Timestamp getTimestampByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getTimestampByColumnIndexAndRow(index, row);
    }

    public Time getTimeByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getTimeByColumnIndexAndRow(index, row);
    }

    public byte[] getBlobByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getBlobByColumnIndexAndRow(index, row);
    }

    public BigDecimal getDecimalByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getDecimalByColumnIndexAndRow(index, row);
    }

    public String getOidByColumnNameAndRow(String columnName, int row) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        return this.getOidByColumnIndexAndRow(index, row);
    }

    private native void getBooleanColumnByIndexInternal(long var1, int var3, boolean[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getByteColumnByIndexInternal(long var1, int var3, byte[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getShortColumnByIndexInternal(long var1, int var3, short[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getIntColumnByIndexInternal(long var1, int var3, int[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getLongColumnByIndexInternal(long var1, int var3, long[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getFloatColumnByIndexInternal(long var1, int var3, float[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getDoubleColumnByIndexInternal(long var1, int var3, double[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getStringColumnByIndexInternal(long var1, int var3, String[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getDateColumnByIndexInternal(long var1, int var3, Date[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getTimestampColumnByIndexInternal(long var1, int var3, Timestamp[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getTimeColumnByIndexInternal(long var1, int var3, Time[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getBlobColumnByIndexInternal(long var1, int var3, byte[][] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getDecimalColumnByIndexInternal(long var1, int var3, BigDecimal[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private native void getOidColumnByIndexInternal(long var1, int var3, String[] var4, int var5, int var6) throws MonetDBEmbeddedException;

    private void checkRangesArrays(int column, Object input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkQueryResultSetIsNotClosed();
        int sum = offset + length;
        if (column < 1) {
            throw new ArrayIndexOutOfBoundsException("The column index is smaller than 1?");
        }
        if (column > this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException("The column index is larger than the number of columns? " + column + " > " + this.numberOfColumns);
        }
        if (length < 1) {
            throw new ArrayIndexOutOfBoundsException("Retrieving 0 rows?");
        }
        if (sum > this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException("The end index is larger than the number of rows! " + sum + " > " + this.numberOfRows);
        }
        int arrayLength = Array.getLength(input);
        if (sum > arrayLength) {
            throw new ArrayIndexOutOfBoundsException("The end index is larger than the length of the provided array! " + sum + " > " + arrayLength);
        }
    }

    public void getBooleanColumnByIndex(int column, boolean[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                this.getBooleanColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            case 3: {
                short[] aux2 = new short[length];
                this.getShortColumnByIndexInternal(this.structPointer, column, aux2, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux2[i] != 0 && aux2[i] != NullMappings.getShortNullConstant();
                }
                break;
            }
            case 4: {
                int[] aux3 = new int[length];
                this.getIntColumnByIndexInternal(this.structPointer, column, aux3, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux3[i] != 0 && aux3[i] != NullMappings.getIntNullConstant();
                }
                break;
            }
            case 5: {
                long[] aux4 = new long[length];
                this.getLongColumnByIndexInternal(this.structPointer, column, aux4, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux4[i] != 0L && aux4[i] != NullMappings.getLongNullConstant();
                }
                break;
            }
            case 6: {
                float[] aux5 = new float[length];
                this.getFloatColumnByIndexInternal(this.structPointer, column, aux5, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux5[i] != 0.0f && aux5[i] != NullMappings.getFloatNullConstant();
                }
                break;
            }
            case 7: {
                double[] aux6 = new double[length];
                this.getDoubleColumnByIndexInternal(this.structPointer, column, aux6, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux6[i] != 0.0 && aux6[i] != NullMappings.getDoubleNullConstant();
                }
                break;
            }
            case 8: {
                String[] aux7 = new String[length];
                this.getStringColumnByIndexInternal(this.structPointer, column, aux7, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux7[i] != null && Boolean.parseBoolean(aux7[i]);
                }
                break;
            }
            case 13: {
                BigDecimal[] aux8 = new BigDecimal[length];
                this.getDecimalColumnByIndexInternal(this.structPointer, column, aux8, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux8[i] != null && !aux8[i].equals(BigDecimal.ZERO);
                }
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to boolean[]");
            }
        }
    }

    public void getByteColumnByIndex(int column, byte[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                this.getByteColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            case 3: {
                short[] aux2 = new short[length];
                this.getShortColumnByIndexInternal(this.structPointer, column, aux2, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux2[i] == NullMappings.getShortNullConstant() ? NullMappings.getByteNullConstant() : (byte)aux2[i];
                }
                break;
            }
            case 4: {
                int[] aux3 = new int[length];
                this.getIntColumnByIndexInternal(this.structPointer, column, aux3, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux3[i] == NullMappings.getIntNullConstant() ? NullMappings.getByteNullConstant() : (byte)aux3[i];
                }
                break;
            }
            case 5: {
                long[] aux4 = new long[length];
                this.getLongColumnByIndexInternal(this.structPointer, column, aux4, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux4[i] == NullMappings.getLongNullConstant() ? NullMappings.getByteNullConstant() : (byte)aux4[i];
                }
                break;
            }
            case 6: {
                float[] aux5 = new float[length];
                this.getFloatColumnByIndexInternal(this.structPointer, column, aux5, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux5[i] == NullMappings.getFloatNullConstant() ? NullMappings.getByteNullConstant() : (byte)Math.round(aux5[i]);
                }
                break;
            }
            case 7: {
                double[] aux6 = new double[length];
                this.getDoubleColumnByIndexInternal(this.structPointer, column, aux6, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux6[i] == NullMappings.getDoubleNullConstant() ? NullMappings.getByteNullConstant() : (byte)Math.round(aux6[i]);
                }
                break;
            }
            case 8: {
                String[] aux7 = new String[length];
                this.getStringColumnByIndexInternal(this.structPointer, column, aux7, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux7[i] != null ? Byte.parseByte(aux7[i]) : NullMappings.getByteNullConstant();
                }
                break;
            }
            case 13: {
                BigDecimal[] aux8 = new BigDecimal[length];
                this.getDecimalColumnByIndexInternal(this.structPointer, column, aux8, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux8[i] != null ? aux8[i].byteValue() : NullMappings.getByteNullConstant();
                }
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to byte[]");
            }
        }
    }

    public void getShortColumnByIndex(int column, short[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte[] aux1 = new byte[length];
                this.getByteColumnByIndexInternal(this.structPointer, column, aux1, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux1[i] == NullMappings.getByteNullConstant() ? NullMappings.getShortNullConstant() : (short)aux1[i];
                }
                break;
            }
            case 3: {
                this.getShortColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            case 4: {
                int[] aux3 = new int[length];
                this.getIntColumnByIndexInternal(this.structPointer, column, aux3, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux3[i] == NullMappings.getIntNullConstant() ? NullMappings.getShortNullConstant() : (short)aux3[i];
                }
                break;
            }
            case 5: {
                long[] aux4 = new long[length];
                this.getLongColumnByIndexInternal(this.structPointer, column, aux4, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux4[i] == NullMappings.getLongNullConstant() ? NullMappings.getShortNullConstant() : (short)aux4[i];
                }
                break;
            }
            case 6: {
                float[] aux5 = new float[length];
                this.getFloatColumnByIndexInternal(this.structPointer, column, aux5, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux5[i] == NullMappings.getFloatNullConstant() ? NullMappings.getShortNullConstant() : (short)Math.round(aux5[i]);
                }
                break;
            }
            case 7: {
                double[] aux6 = new double[length];
                this.getDoubleColumnByIndexInternal(this.structPointer, column, aux6, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux6[i] == NullMappings.getDoubleNullConstant() ? NullMappings.getShortNullConstant() : (short)Math.round(aux6[i]);
                }
                break;
            }
            case 8: {
                String[] aux7 = new String[length];
                this.getStringColumnByIndexInternal(this.structPointer, column, aux7, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux7[i] != null ? Short.parseShort(aux7[i]) : NullMappings.getShortNullConstant();
                }
                break;
            }
            case 13: {
                BigDecimal[] aux8 = new BigDecimal[length];
                this.getDecimalColumnByIndexInternal(this.structPointer, column, aux8, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux8[i] != null ? aux8[i].shortValue() : NullMappings.getShortNullConstant();
                }
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to short[]");
            }
        }
    }

    public void getIntColumnByIndex(int column, int[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte[] aux1 = new byte[length];
                this.getByteColumnByIndexInternal(this.structPointer, column, aux1, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux1[i] == NullMappings.getByteNullConstant() ? NullMappings.getIntNullConstant() : aux1[i];
                }
                break;
            }
            case 3: {
                short[] aux2 = new short[length];
                this.getShortColumnByIndexInternal(this.structPointer, column, aux2, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux2[i] == NullMappings.getShortNullConstant() ? NullMappings.getIntNullConstant() : aux2[i];
                }
                break;
            }
            case 4: {
                this.getIntColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            case 5: {
                long[] aux4 = new long[length];
                this.getLongColumnByIndexInternal(this.structPointer, column, aux4, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux4[i] == NullMappings.getLongNullConstant() ? NullMappings.getIntNullConstant() : (int)aux4[i];
                }
                break;
            }
            case 6: {
                float[] aux5 = new float[length];
                this.getFloatColumnByIndexInternal(this.structPointer, column, aux5, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux5[i] == NullMappings.getFloatNullConstant() ? NullMappings.getIntNullConstant() : Math.round(aux5[i]);
                }
                break;
            }
            case 7: {
                double[] aux6 = new double[length];
                this.getDoubleColumnByIndexInternal(this.structPointer, column, aux6, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux6[i] == NullMappings.getDoubleNullConstant() ? NullMappings.getIntNullConstant() : (int)Math.round(aux6[i]);
                }
                break;
            }
            case 8: {
                String[] aux7 = new String[length];
                this.getStringColumnByIndexInternal(this.structPointer, column, aux7, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux7[i] != null ? Integer.parseInt(aux7[i]) : NullMappings.getIntNullConstant();
                }
                break;
            }
            case 13: {
                BigDecimal[] aux8 = new BigDecimal[length];
                this.getDecimalColumnByIndexInternal(this.structPointer, column, aux8, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux8[i] != null ? aux8[i].intValue() : NullMappings.getIntNullConstant();
                }
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to int[]");
            }
        }
    }

    public void getLongColumnByIndex(int column, long[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte[] aux1 = new byte[length];
                this.getByteColumnByIndexInternal(this.structPointer, column, aux1, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux1[i] == NullMappings.getByteNullConstant() ? NullMappings.getLongNullConstant() : (long)aux1[i];
                }
                break;
            }
            case 3: {
                short[] aux2 = new short[length];
                this.getShortColumnByIndexInternal(this.structPointer, column, aux2, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux2[i] == NullMappings.getShortNullConstant() ? NullMappings.getLongNullConstant() : (long)aux2[i];
                }
                break;
            }
            case 4: {
                int[] aux3 = new int[length];
                this.getIntColumnByIndexInternal(this.structPointer, column, aux3, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux3[i] == NullMappings.getIntNullConstant() ? NullMappings.getLongNullConstant() : (long)aux3[i];
                }
                break;
            }
            case 5: {
                this.getLongColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            case 6: {
                float[] aux5 = new float[length];
                this.getFloatColumnByIndexInternal(this.structPointer, column, aux5, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux5[i] == NullMappings.getFloatNullConstant() ? NullMappings.getLongNullConstant() : (long)Math.round(aux5[i]);
                }
                break;
            }
            case 7: {
                double[] aux6 = new double[length];
                this.getDoubleColumnByIndexInternal(this.structPointer, column, aux6, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux6[i] == NullMappings.getDoubleNullConstant() ? NullMappings.getLongNullConstant() : Math.round(aux6[i]);
                }
                break;
            }
            case 8: {
                String[] aux7 = new String[length];
                this.getStringColumnByIndexInternal(this.structPointer, column, aux7, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux7[i] != null ? Long.parseLong(aux7[i]) : NullMappings.getLongNullConstant();
                }
                break;
            }
            case 13: {
                BigDecimal[] aux8 = new BigDecimal[length];
                this.getDecimalColumnByIndexInternal(this.structPointer, column, aux8, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux8[i] != null ? aux8[i].longValue() : NullMappings.getLongNullConstant();
                }
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to long[]");
            }
        }
    }

    public void getFloatColumnByIndex(int column, float[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte[] aux1 = new byte[length];
                this.getByteColumnByIndexInternal(this.structPointer, column, aux1, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux1[i] == NullMappings.getByteNullConstant() ? NullMappings.getFloatNullConstant() : (float)aux1[i];
                }
                break;
            }
            case 3: {
                short[] aux2 = new short[length];
                this.getShortColumnByIndexInternal(this.structPointer, column, aux2, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux2[i] == NullMappings.getShortNullConstant() ? NullMappings.getFloatNullConstant() : (float)aux2[i];
                }
                break;
            }
            case 4: {
                int[] aux3 = new int[length];
                this.getIntColumnByIndexInternal(this.structPointer, column, aux3, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux3[i] == NullMappings.getIntNullConstant() ? NullMappings.getFloatNullConstant() : (float)aux3[i];
                }
                break;
            }
            case 5: {
                long[] aux4 = new long[length];
                this.getLongColumnByIndexInternal(this.structPointer, column, aux4, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux4[i] == NullMappings.getLongNullConstant() ? NullMappings.getFloatNullConstant() : (float)aux4[i];
                }
                break;
            }
            case 6: {
                this.getFloatColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            case 7: {
                double[] aux6 = new double[length];
                this.getDoubleColumnByIndexInternal(this.structPointer, column, aux6, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux6[i] == NullMappings.getDoubleNullConstant() ? NullMappings.getFloatNullConstant() : (float)aux6[i];
                }
                break;
            }
            case 8: {
                String[] aux7 = new String[length];
                this.getStringColumnByIndexInternal(this.structPointer, column, aux7, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux7[i] != null ? Float.parseFloat(aux7[i]) : NullMappings.getFloatNullConstant();
                }
                break;
            }
            case 13: {
                BigDecimal[] aux8 = new BigDecimal[length];
                this.getDecimalColumnByIndexInternal(this.structPointer, column, aux8, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux8[i] != null ? aux8[i].floatValue() : NullMappings.getFloatNullConstant();
                }
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to float[]");
            }
        }
    }

    public void getDoubleColumnByIndex(int column, double[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte[] aux1 = new byte[length];
                this.getByteColumnByIndexInternal(this.structPointer, column, aux1, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux1[i] == NullMappings.getByteNullConstant() ? NullMappings.getDoubleNullConstant() : (double)aux1[i];
                }
                break;
            }
            case 3: {
                short[] aux2 = new short[length];
                this.getShortColumnByIndexInternal(this.structPointer, column, aux2, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux2[i] == NullMappings.getShortNullConstant() ? (double)NullMappings.getFloatNullConstant() : (double)aux2[i];
                }
                break;
            }
            case 4: {
                int[] aux3 = new int[length];
                this.getIntColumnByIndexInternal(this.structPointer, column, aux3, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux3[i] == NullMappings.getIntNullConstant() ? NullMappings.getDoubleNullConstant() : (double)aux3[i];
                }
                break;
            }
            case 5: {
                long[] aux4 = new long[length];
                this.getLongColumnByIndexInternal(this.structPointer, column, aux4, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux4[i] == NullMappings.getLongNullConstant() ? NullMappings.getDoubleNullConstant() : (double)aux4[i];
                }
                break;
            }
            case 6: {
                float[] aux5 = new float[length];
                this.getFloatColumnByIndexInternal(this.structPointer, column, aux5, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux5[i] == NullMappings.getFloatNullConstant() ? NullMappings.getDoubleNullConstant() : (double)aux5[i];
                }
                break;
            }
            case 7: {
                this.getDoubleColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            case 8: {
                String[] aux7 = new String[length];
                this.getStringColumnByIndexInternal(this.structPointer, column, aux7, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux7[i] != null ? Double.parseDouble(aux7[i]) : NullMappings.getDoubleNullConstant();
                }
                break;
            }
            case 13: {
                BigDecimal[] aux8 = new BigDecimal[length];
                this.getDecimalColumnByIndexInternal(this.structPointer, column, aux8, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux8[i] != null ? aux8[i].doubleValue() : NullMappings.getDoubleNullConstant();
                }
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to double[]");
            }
        }
    }

    public void getStringColumnByIndex(int column, String[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte[] aux1 = new byte[length];
                this.getByteColumnByIndexInternal(this.structPointer, column, aux1, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux1[i] == NullMappings.getByteNullConstant() ? null : Byte.toString(aux1[i]);
                }
                break;
            }
            case 3: {
                short[] aux2 = new short[length];
                this.getShortColumnByIndexInternal(this.structPointer, column, aux2, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux2[i] == NullMappings.getShortNullConstant() ? null : Short.toString(aux2[i]);
                }
                break;
            }
            case 4: {
                int[] aux3 = new int[length];
                this.getIntColumnByIndexInternal(this.structPointer, column, aux3, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux3[i] == NullMappings.getIntNullConstant() ? null : Integer.toString(aux3[i]);
                }
                break;
            }
            case 5: {
                long[] aux4 = new long[length];
                this.getLongColumnByIndexInternal(this.structPointer, column, aux4, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux4[i] == NullMappings.getLongNullConstant() ? null : Long.toString(aux4[i]);
                }
                break;
            }
            case 6: {
                float[] aux5 = new float[length];
                this.getFloatColumnByIndexInternal(this.structPointer, column, aux5, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux5[i] == NullMappings.getFloatNullConstant() ? null : Float.toString(aux5[i]);
                }
                break;
            }
            case 7: {
                double[] aux6 = new double[length];
                this.getDoubleColumnByIndexInternal(this.structPointer, column, aux6, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux6[i] == NullMappings.getDoubleNullConstant() ? null : Double.toString(aux6[i]);
                }
                break;
            }
            case 8: {
                this.getStringColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            case 9: {
                Date[] aux7 = new Date[length];
                this.getDateColumnByIndexInternal(this.structPointer, column, aux7, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux7[i] == null ? null : aux7[i].toString();
                }
                break;
            }
            case 10: {
                Timestamp[] aux8 = new Timestamp[length];
                this.getTimestampColumnByIndexInternal(this.structPointer, column, aux8, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux8[i] == null ? null : aux8[i].toString();
                }
                break;
            }
            case 11: {
                Time[] aux9 = new Time[length];
                this.getTimeColumnByIndexInternal(this.structPointer, column, aux9, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux9[i] == null ? null : aux9[i].toString();
                }
                break;
            }
            case 12: {
                byte[][] aux10 = new byte[length][];
                this.getBlobColumnByIndexInternal(this.structPointer, column, aux10, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux10[i] == null ? null : Arrays.toString(aux10[i]);
                }
                break;
            }
            case 13: {
                BigDecimal[] aux11 = new BigDecimal[length];
                this.getDecimalColumnByIndexInternal(this.structPointer, column, aux11, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux11[i] == null ? null : aux11[i].toString();
                }
                break;
            }
            case 14: {
                this.getOidColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to String[]");
            }
        }
    }

    public void getDateColumnByIndex(int column, Date[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 9: {
                this.getDateColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            case 10: {
                Timestamp[] aux8 = new Timestamp[length];
                this.getTimestampColumnByIndexInternal(this.structPointer, column, aux8, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux8[i] == null ? null : new Date(aux8[i].getTime());
                }
                break;
            }
            case 11: {
                Time[] aux9 = new Time[length];
                this.getTimeColumnByIndexInternal(this.structPointer, column, aux9, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux9[i] == null ? null : new Date(aux9[i].getTime());
                }
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to Date[]");
            }
        }
    }

    public void getTimestampColumnByIndex(int column, Timestamp[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 9: {
                Date[] aux7 = new Date[length];
                this.getDateColumnByIndexInternal(this.structPointer, column, aux7, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux7[i] == null ? null : new Timestamp(aux7[i].getTime());
                }
                break;
            }
            case 10: {
                this.getTimestampColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            case 11: {
                Time[] aux9 = new Time[length];
                this.getTimeColumnByIndexInternal(this.structPointer, column, aux9, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux9[i] == null ? null : new Timestamp(aux9[i].getTime());
                }
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to Timestamp[]");
            }
        }
    }

    public void getTimeColumnByIndex(int column, Time[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 9: {
                Date[] aux7 = new Date[length];
                this.getDateColumnByIndexInternal(this.structPointer, column, aux7, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux7[i] == null ? null : new Time(aux7[i].getTime());
                }
                break;
            }
            case 10: {
                Timestamp[] aux8 = new Timestamp[length];
                this.getTimestampColumnByIndexInternal(this.structPointer, column, aux8, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux8[i] == null ? null : new Time(aux8[i].getTime());
                }
                break;
            }
            case 11: {
                this.getTimeColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to Time[]");
            }
        }
    }

    public void getBlobColumnByIndex(int column, byte[][] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 8: {
                String[] aux7 = new String[length];
                this.getStringColumnByIndexInternal(this.structPointer, column, aux7, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux7[i] == null ? null : aux7[i].getBytes();
                }
                break;
            }
            case 12: {
                this.getBlobColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to byte[][]");
            }
        }
    }

    public void getDecimalColumnByIndex(int column, BigDecimal[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 1: 
            case 2: {
                byte[] aux1 = new byte[length];
                this.getByteColumnByIndexInternal(this.structPointer, column, aux1, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux1[i] == NullMappings.getByteNullConstant() ? null : new BigDecimal(aux1[i]);
                }
                break;
            }
            case 3: {
                short[] aux2 = new short[length];
                this.getShortColumnByIndexInternal(this.structPointer, column, aux2, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux2[i] == NullMappings.getShortNullConstant() ? null : new BigDecimal(aux2[i]);
                }
                break;
            }
            case 4: {
                int[] aux3 = new int[length];
                this.getIntColumnByIndexInternal(this.structPointer, column, aux3, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux3[i] == NullMappings.getIntNullConstant() ? null : new BigDecimal(aux3[i]);
                }
                break;
            }
            case 5: {
                long[] aux4 = new long[length];
                this.getLongColumnByIndexInternal(this.structPointer, column, aux4, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux4[i] == NullMappings.getLongNullConstant() ? null : new BigDecimal(aux4[i]);
                }
                break;
            }
            case 6: {
                float[] aux5 = new float[length];
                this.getFloatColumnByIndexInternal(this.structPointer, column, aux5, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux5[i] == NullMappings.getFloatNullConstant() ? null : new BigDecimal(aux5[i]);
                }
                break;
            }
            case 7: {
                double[] aux6 = new double[length];
                this.getDoubleColumnByIndexInternal(this.structPointer, column, aux6, offset, length);
                for (int i = 0; i < length; ++i) {
                    input[i] = aux6[i] == NullMappings.getDoubleNullConstant() ? null : new BigDecimal(aux6[i]);
                }
                break;
            }
            case 13: {
                this.getDecimalColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to BigDecimal[]");
            }
        }
    }

    public void getOidColumnByIndex(int column, String[] input, int offset, int length) throws MonetDBEmbeddedException {
        this.checkRangesArrays(column, input, offset, length);
        switch (this.typesIDs[--column]) {
            case 14: {
                this.getOidColumnByIndexInternal(this.structPointer, column, input, offset, length);
                break;
            }
            default: {
                throw new ClassCastException("Cannot convert " + QueryResultSet.TypeIDToString(this.typesIDs[column]) + " to String[]");
            }
        }
    }

    public void getBooleanColumnByName(String columnName, boolean[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getBooleanColumnByIndex(index, input, offset, length);
    }

    public void getByteColumnByName(String columnName, byte[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getByteColumnByIndex(index, input, offset, length);
    }

    public void getShortColumnByName(String columnName, short[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getShortColumnByIndex(index, input, offset, length);
    }

    public void getIntColumnByName(String columnName, int[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getIntColumnByIndex(index, input, offset, length);
    }

    public void getLongColumnByName(String columnName, long[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getLongColumnByIndex(index, input, offset, length);
    }

    public void getFloatColumnByName(String columnName, float[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getFloatColumnByIndex(index, input, offset, length);
    }

    public void getDoubleColumnByName(String columnName, double[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getDoubleColumnByIndex(index, input, offset, length);
    }

    public void getStringColumnByName(String columnName, String[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getStringColumnByIndex(index, input, offset, length);
    }

    public void getDateColumnByName(String columnName, Date[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getDateColumnByIndex(index, input, offset, length);
    }

    public void getTimestampColumnByName(String columnName, Timestamp[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getTimestampColumnByIndex(index, input, offset, length);
    }

    public void getTimeColumnByName(String columnName, Time[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getTimeColumnByIndex(index, input, offset, length);
    }

    public void getBlobColumnByName(String columnName, byte[][] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getBlobColumnByIndex(index, input, offset, length);
    }

    public void getDecimalColumnByName(String columnName, BigDecimal[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getDecimalColumnByIndex(index, input, offset, length);
    }

    public void getOidColumnByName(String columnName, String[] input, int offset, int length) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getOidColumnByIndex(index, input, offset, length);
    }

    public void getBooleanColumnByIndex(int column, boolean[] input) throws MonetDBEmbeddedException {
        this.getBooleanColumnByIndex(column, input, 0, input.length);
    }

    public void getByteColumnByIndex(int column, byte[] input) throws MonetDBEmbeddedException {
        this.getByteColumnByIndex(column, input, 0, input.length);
    }

    public void getShortColumnByIndex(int column, short[] input) throws MonetDBEmbeddedException {
        this.getShortColumnByIndex(column, input, 0, input.length);
    }

    public void getIntColumnByIndex(int column, int[] input) throws MonetDBEmbeddedException {
        this.getIntColumnByIndex(column, input, 0, input.length);
    }

    public void getLongColumnByIndex(int column, long[] input) throws MonetDBEmbeddedException {
        this.getLongColumnByIndex(column, input, 0, input.length);
    }

    public void getFloatColumnByIndex(int column, float[] input) throws MonetDBEmbeddedException {
        this.getFloatColumnByIndex(column, input, 0, input.length);
    }

    public void getDoubleColumnByIndex(int column, double[] input) throws MonetDBEmbeddedException {
        this.getDoubleColumnByIndex(column, input, 0, input.length);
    }

    public void getStringColumnByIndex(int column, String[] input) throws MonetDBEmbeddedException {
        this.getStringColumnByIndex(column, input, 0, input.length);
    }

    public void getDateColumnByIndex(int column, Date[] input) throws MonetDBEmbeddedException {
        this.getDateColumnByIndex(column, input, 0, input.length);
    }

    public void getTimestampColumnByIndex(int column, Timestamp[] input) throws MonetDBEmbeddedException {
        this.getTimestampColumnByIndex(column, input, 0, input.length);
    }

    public void getTimeColumnByIndex(int column, Time[] input) throws MonetDBEmbeddedException {
        this.getTimeColumnByIndex(column, input, 0, input.length);
    }

    public void getBlobColumnByIndex(int column, byte[][] input) throws MonetDBEmbeddedException {
        this.getBlobColumnByIndex(column, input, 0, input.length);
    }

    public void getDecimalColumnByIndex(int column, BigDecimal[] input) throws MonetDBEmbeddedException {
        this.getDecimalColumnByIndex(column, input, 0, input.length);
    }

    public void getOidColumnByIndex(int column, String[] input) throws MonetDBEmbeddedException {
        this.getOidColumnByIndex(column, input, 0, input.length);
    }

    public void getBooleanColumnByName(String columnName, boolean[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getBooleanColumnByIndex(index, input, 0, input.length);
    }

    public void getByteColumnByName(String columnName, byte[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getByteColumnByIndex(index, input, 0, input.length);
    }

    public void getShortColumnByName(String columnName, short[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getShortColumnByIndex(index, input, 0, input.length);
    }

    public void getIntColumnByName(String columnName, int[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getIntColumnByIndex(index, input, 0, input.length);
    }

    public void getLongColumnByName(String columnName, long[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getLongColumnByIndex(index, input, 0, input.length);
    }

    public void getFloatColumnByName(String columnName, float[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getFloatColumnByIndex(index, input, 0, input.length);
    }

    public void getDoubleColumnByName(String columnName, double[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getDoubleColumnByIndex(index, input, 0, input.length);
    }

    public void getStringColumnByName(String columnName, String[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getStringColumnByIndex(index, input, 0, input.length);
    }

    public void getDateColumnByName(String columnName, Date[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getDateColumnByIndex(index, input, 0, input.length);
    }

    public void getTimestampColumnByName(String columnName, Timestamp[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getTimestampColumnByIndex(index, input, 0, input.length);
    }

    public void getTimeColumnByName(String columnName, Time[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getTimeColumnByIndex(index, input, 0, input.length);
    }

    public void getBlobColumnByName(String columnName, byte[][] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getBlobColumnByIndex(index, input, 0, input.length);
    }

    public void getDecimalColumnByName(String columnName, BigDecimal[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getDecimalColumnByIndex(index, input, 0, input.length);
    }

    public void getOidColumnByName(String columnName, String[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getOidColumnByIndex(index, input, 0, input.length);
    }

    public boolean checkBooleanIsNull(int column, int row) throws MonetDBEmbeddedException {
        this.checkQueryResultSetIsNotClosed();
        if (row < 1) {
            throw new ArrayIndexOutOfBoundsException("A row smaller than 1?");
        }
        if (row > this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException("The row is larger than the number of rows");
        }
        if (column < 1) {
            throw new ArrayIndexOutOfBoundsException("The column index is smaller than 1?");
        }
        if (column > this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException("The column index is larger than the number of columns? " + column + " > " + this.numberOfColumns);
        }
        if (this.typesIDs[column - 1] != 1) {
            throw new ClassCastException("The column is not a boolean");
        }
        return this.getByteByColumnAndRowInternal(this.structPointer, column - 1, row - 1) == NullMappings.getByteNullConstant();
    }

    private void checkRowArray(int column, Object input) throws MonetDBEmbeddedException {
        this.checkQueryResultSetIsNotClosed();
        int arrayLength = Array.getLength(input);
        if (column < 1) {
            throw new ArrayIndexOutOfBoundsException("The column index is smaller than 1?");
        }
        if (column > this.numberOfColumns) {
            throw new ArrayIndexOutOfBoundsException("The column index is larger than the number of columns? " + column + " > " + this.numberOfColumns);
        }
        if (arrayLength != this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException("The array length is different from the number of rows! " + this.numberOfRows + " != " + arrayLength);
        }
    }

    private native void getColumnNullMappingsByIndexInternal(long var1, int var3, int var4, boolean[] var5) throws MonetDBEmbeddedException;

    public void getColumnNullMappingsByIndex(int column, boolean[] input) throws MonetDBEmbeddedException {
        this.checkRowArray(column, input);
        this.getColumnNullMappingsByIndexInternal(this.structPointer, --column, this.typesIDs[column], input);
    }

    public void getNullMappingByName(String columnName, boolean[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.getColumnNullMappingsByIndex(index, input);
    }

    private native void mapColumnToObjectByIndexInternal(long var1, int var3, int var4, Object[] var5) throws MonetDBEmbeddedException;

    public void mapColumnToObjectByIndex(int column, Object[] input) throws MonetDBEmbeddedException {
        this.checkRowArray(column, input);
        this.mapColumnToObjectByIndexInternal(this.structPointer, --column, this.typesIDs[column], input);
    }

    public void mapColumnToObjectByName(String columnName, Object[] input) throws MonetDBEmbeddedException {
        int index = this.getColumnIndexByName(columnName);
        this.mapColumnToObjectByIndex(index, input);
    }

    private QueryResultRowSet fetchRowsInternal(int startIndex, int endIndex) throws MonetDBEmbeddedException {
        int numberOfRowsToRetrieve = Math.max(endIndex - startIndex + 1, 0);
        Object[][] temp = new Object[numberOfRowsToRetrieve][this.getNumberOfColumns()];
        for (int i = 0; i < this.getNumberOfColumns(); ++i) {
            Object[] aux = new Object[numberOfRowsToRetrieve];
            if (numberOfRowsToRetrieve > 0) {
                this.mapColumnToObjectByIndex(i + 1, aux);
            }
            Object[] nextColumn = numberOfRowsToRetrieve == 0 ? new Object[]{} : Arrays.copyOfRange(aux, startIndex - 1, endIndex);
            for (int j = 0; j < numberOfRowsToRetrieve; ++j) {
                temp[j][i] = nextColumn[j];
            }
        }
        return new QueryResultRowSet(this, temp);
    }

    public QueryResultRowSet fetchResultSetRows(int startIndex, int endIndex) throws MonetDBEmbeddedException {
        if (endIndex < startIndex) {
            startIndex ^= endIndex;
            endIndex ^= startIndex;
            startIndex ^= endIndex;
        }
        if (startIndex < 1) {
            throw new ArrayIndexOutOfBoundsException("The start index must be larger than 1");
        }
        if (endIndex > this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException("The index must be smaller than the number of elements in the columns");
        }
        if (startIndex == endIndex) {
            throw new ArrayIndexOutOfBoundsException("Retrieving 0 rows?");
        }
        return this.fetchRowsInternal(startIndex, endIndex);
    }

    public QueryResultRowSet fetchFirstNRowValues(int n) throws MonetDBEmbeddedException {
        if (n > this.numberOfRows) {
            throw new ArrayIndexOutOfBoundsException("The number of rows is larger the number of rows: (" + n + " > " + this.numberOfRows + ")");
        }
        return this.fetchRowsInternal(1, n);
    }

    public QueryResultRowSet fetchAllRowValues() throws MonetDBEmbeddedException {
        return this.fetchRowsInternal(1, this.numberOfRows);
    }

    public ListIterator<MonetDBRow> iterator() {
        try {
            return Arrays.asList(this.fetchAllRowValues().getAllRows()).listIterator();
        }
        catch (MonetDBEmbeddedException ex) {
            return null;
        }
    }

    private native void freeResultSet(long var1);

    @Override
    protected void closeResultImplementation() {
        if (!this.isQueryResultSetClosed()) {
            this.freeResultSet(this.structPointer);
            this.structPointer = 0L;
        }
    }

    @Override
    public void close() {
        super.close();
        this.closeResultImplementation();
    }
}

